/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ConsoleThread;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class Shell {
    public static void main(String[] args) {
        String fileName = null;
        Interp interp = new Interp();
        if (args.length > 0 && !args[0].startsWith("-")) {
            fileName = args[0];
        }
        TclObject argv = TclList.newInstance();
        argv.preserve();
        try {
            try {
                int i = 0;
                int argc = args.length;
                if (fileName == null) {
                    interp.setVar("argv0", "tcl.lang.Shell", 1);
                    interp.setVar("tcl_interactive", "1", 1);
                } else {
                    interp.setVar("argv0", fileName, 1);
                    interp.setVar("tcl_interactive", "0", 1);
                    ++i;
                    --argc;
                }
                while (i < args.length) {
                    TclList.append(interp, argv, TclString.newInstance((String)args[i]));
                    ++i;
                }
                interp.setVar("argv", argv, 1);
                interp.setVar("argc", Integer.toString(argc), 1);
            }
            catch (TclException e) {
                throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
            }
            Object var5_10 = null;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            argv.release();
            throw throwable;
        }
        argv.release();
        if (fileName != null) {
            try {
                interp.evalFile(fileName);
            }
            catch (TclException e) {
                int code = e.getCompletionCode();
                if (code == 2) {
                    code = interp.updateReturnInfo();
                    if (code != 0) {
                        System.err.println("command returned bad code: " + code);
                    }
                }
                if (code == 1) {
                    System.err.println(interp.getResult().toString());
                }
                System.err.println("command returned bad code: " + code);
            }
        }
        if (fileName == null) {
            ConsoleThread consoleThread = new ConsoleThread(interp);
            consoleThread.setDaemon(true);
            consoleThread.start();
            Notifier notifier = interp.getNotifier();
            while (true) {
                notifier.doOneEvent(-3);
            }
        }
        System.exit(0);
    }
}

