/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Field;
import tcl.lang.ClassRep;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.reflect.PkgInvoker;

class FieldSig
extends InternalRep {
    Class targetCls;
    Class sigCls;
    Field field;
    PkgInvoker pkgInvoker;

    protected InternalRep duplicate() {
        return new FieldSig(this.targetCls, this.sigCls, this.pkgInvoker, this.field);
    }

    static FieldSig get(Interp interp, TclObject signature, Class targetCls) throws TclException {
        Field field;
        Class sigCls;
        InternalRep rep = signature.getInternalRep();
        if (rep instanceof FieldSig && ((FieldSig)rep).targetCls == targetCls) {
            return (FieldSig)rep;
        }
        int len = TclList.getLength((Interp)interp, (TclObject)signature);
        if (len < 1 || len > 2) {
            throw new TclException(interp, "bad field signature \"" + signature + "\"");
        }
        String fieldName = TclList.index((Interp)interp, (TclObject)signature, (int)0).toString();
        TclObject sigClsObj = TclList.index((Interp)interp, (TclObject)signature, (int)1);
        if (sigClsObj != null) {
            sigCls = ClassRep.get(interp, sigClsObj);
            if (!sigCls.isAssignableFrom(targetCls)) {
                throw new TclException(interp, "\"" + sigCls.getName() + "\" is not a superclass of \"" + targetCls.getName() + "\"");
            }
        } else {
            sigCls = targetCls;
        }
        try {
            field = sigCls.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new TclException(interp, "field \"" + signature + "\" doesn't exist");
        }
        FieldSig sig = new FieldSig(targetCls, sigCls, PkgInvoker.getPkgInvoker(targetCls), field);
        signature.setInternalRep(sig);
        return sig;
    }

    FieldSig(Class tc, Class sc, PkgInvoker p, Field f) {
        this.targetCls = tc;
        this.sigCls = sc;
        this.pkgInvoker = p;
        this.field = f;
    }
}

