# Text chapter
source colormodel.tcl

proc TextButton { t start end command } {
	global textbutton
	if ![info exists textbutton(uid)] {
		set textbutton(uid) 0
	} else {
		incr textbutton(uid)
	}
	set tag button$textbutton(uid)
	$t tag configure $tag -relief raised -borderwidth 2
	if {[tk colormodel $t] == "color"} {
		$t tag configure $tag -background thistle
	} else {
		$t tag configure $tag -background [$t cget -fg]
		$t tag configure $tag -foreground [$t cget -bg]
	}
	$t tag bind $tag <Enter> {%W config -cursor tcross}
	$t tag bind $tag <Leave> {
		%W config -cursor [lindex [%W config -cursor] 3]
	}
	$t tag bind $tag <Button-1> $command
	$t tag add $tag $start $end
}
