# Font chapter
proc FindFont { w {sizes 14} {weight medium} {slant r}} {
	foreach family {times courier helvetica} {
		foreach size $sizes {
			if {[catch {$w config -font \
				-*-$family-$weight-$slant-*-*-$size-*}] == 0} {
				return -*-$family-$weight-$slant-*-*-$size-*
			}
		}
	}
	$w config -font fixed
	return fixed
}
proc Button { name text command args } {
	set cmd [list button $name -text $text -command $command]
	if [catch {concat $cmd $args} w] {
		puts stderr "Button (warning) $w"
		# Delete the font specified in args, if any
		set ix [lsearch $args -font]
		if {$ix >= 0} {
			set args [lreplace $args $ix [expr $ix+1]]
		}
		# This font overrides the resource database
		eval $cmd $args {-font fixed}
	}
	return $name
}
proc FontWidget { args } {
	if [catch $args w] {
		# Delete the font specified in args, if any
		set ix [lsearch $args -font]
		if {$ix >= 0} {
			set args [lreplace $args $ix [expr $ix+1]]
		}
		# This font overrides the resource database
		set w [eval $args {-font fixed}]
	}
	return $w
}
FontWidget button .foo -text Foo -font garbage
pack .foo
