
/* -*-Mode: C;-*- sql.c -[Mon Oct 12 11:43:36 1992 by cxh]- */
#ifndef lint
static char     rcsid[] = "$Id: sql.sc,v 1.4 1992/09/29 21:20:13 cxh Exp cxh $";
#endif
/*
 * Copyright 1992 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided 'as is' without express or implied warranty.
 */

/* A bunch of this code was borrowed from postgres-tcl.c */
/*
 * A bunch more of this code came from the 'Ingres/ESQL Companion Guide for
 * C'
 */

/*
 * This file consists of the sql specific code.  This file contains embedded
 * sql, it should be converted to a .c file by Ingres' esql. The functions at
 * the bottom are externally visible.
 */

#include "tclsql.h"
#include "coltype.h"

/* Include the sql communications area. */
EXEC SQL INCLUDE SQLCA;

/* Include the global data location typdef. */
EXEC SQL INCLUDE SQLDA;
#include "curs.h"


#define DATE_SIZE	25

void            exit();
int             SelectRow = 0;	/* Row number for SQLselectRow. */

RES_BUF         res_buf =
{0, NULL};

extern CURSOR  *CursorHead, *LastPrepareCursor;

/*
 * Convert a cursor name to a CURSOR pointer.
 */
CURSOR         *
get_cursor(name)
     char           *name;
{
  CURSOR         *curs_ele;

  if (name == NULL)
    return NULL;

  for (curs_ele = CursorHead;
       curs_ele && strcmp(curs_ele->name, name); curs_ele = curs_ele->next)
    if (curs_ele->next == NULL)
      break;

  if (!curs_ele || strcmp(curs_ele->name, name))
    return NULL;
  return curs_ele;
}

/*
 * Free up a cursor.
 */
void
free_cursor(cursor)
     CURSOR         *cursor;
{
  /* TODO: It would be nice to have some error checking on free(). */
  if (cursor->sqlda)
    free((char *) cursor->sqlda);
  if (cursor->res_buf.res_data)
    free((char *) cursor->res_buf.res_data);
  if (cursor->coltype)
    cursor->coltype = free_coltype(cursor->coltype);

  free((char *) cursor);
}

/*
 * Free up all the user defined cursors.  SQLcommit and SQLclosedb call this.
 */
void
free_all_cursors()
{
  CURSOR         *cursor;

  for (cursor = CursorHead;
       cursor; cursor = cursor->next) {
    if (cursor->next == NULL) {
      free_cursor(cursor);
      break;
    }
    free_cursor(cursor);
  }
  CursorHead = NULL;
}

/* Allocate memory.  Rollback any updates if there is an error. */
char           *
sql_malloc(size, error)
     int             size;
     char           *error;
{
  char           *ptr;
  if ((ptr = calloc((unsigned) 1, (unsigned) size)) == NULL) {
    fprintf(stderr, "TCL Ingres fatal error: cannot allocate %d bytes for %s\n",
	    size, error);
    fprintf(stderr, "Any pending updates are being rolled back.\n");
    EXEC SQL WHENEVER SQLERROR CONTINUE;
    EXEC SQL        ROLLBACK;
    EXEC SQL        DISCONNECT;
    return NULL;
  }
  return ptr;
}

/*
 * Initialize SQLDA. Return NULL on error, otherwise return the address of
 * the new SQLDA.
 */
IISQLDA        *
init_sqlda(num_elements)
     int             num_elements;
{
  IISQLDA        *sqlda;
  sqlda = (IISQLDA *)
    sql_malloc(IISQDA_HEAD_SIZE + (num_elements * IISQDA_VAR_SIZE),
	       "new SQLDA");
  if (sqlda == NULL)
    return NULL;
  sqlda->sqln = num_elements;
  return sqlda;
}

/*
 * Set up the results area for fetches.  Put the column names in the tcl
 * array variable res_var (if it exists). Return 0 if sucessful.
 */

append_header(interp, res_var, row_indice, ncols, op, sqlda, coltype)
     Tcl_Interp     *interp;
     char           *res_var;
     char           *row_indice;
     int	    *ncols;
     int             op;
     IISQLDA        *sqlda;
     COLTYPE        *coltype;
{
  int             i;
  IISQLVAR       *sqv;
  int             base_type;
  int             res_cur_size;
  int             round;


  if ((op & SELECT_1D) && (sqlda->sqld > 1) &&
      !(op & SELECT_COLNAMES) && !(op & SELECT_COLTYPES) &&
      !(op & SELECT_ROW)) {
    Tcl_AppendResult(interp,
	   " Select returned more than one column, conflict with -1d. ", 0);
    return TCL_ERROR;
  }

  /*
   * Process each column of the table, determining the size. If res_var is
   * non-NULL, then output the column headers
   */
  for (res_cur_size = 0, i = 0; i < sqlda->sqld; i++) {
    sqv = &sqlda->sqlvar[i];

    coltype[i] = (int) sqv->sqltype;

    set_res_header(interp, res_var, row_indice, op, sqv, i, coltype);

    /*
     * TODO: if we are doing a SELECT_COLNAMES or SELECT_COLTYPES, then we
     * may not want to deal with the result area.
     * 
     */

    if ((base_type = sqv->sqltype) < 0)
      base_type = -base_type;

    switch (base_type) {
    case IISQ_INT_TYPE:
      res_cur_size += sizeof(long);
      sqv->sqllen = sizeof(long);
      break;

    case IISQ_MNY_TYPE:
      if (sqv->sqltype < 0)
	sqv->sqltype = -IISQ_FLT_TYPE;
      else
	sqv->sqltype = IISQ_FLT_TYPE;
      if (round = res_cur_size % 8)	/* align doubles on 8 bytes */
	res_cur_size += 8 - round;
      res_cur_size += sizeof(double);
      sqv->sqllen = sizeof(double);
      break;
    case IISQ_FLT_TYPE:
      if (round = res_cur_size % 8)	/* align doubles on 8 bytes */
	res_cur_size += 8 - round;
      res_cur_size += sizeof(double);
      sqv->sqllen = sizeof(double);
      break;
    case IISQ_DTE_TYPE:
      sqv->sqllen = DATE_SIZE;
    case IISQ_CHA_TYPE:
    case IISQ_VCH_TYPE:
      res_cur_size += sqv->sqllen + 1;
      if (round = res_cur_size % 4)	/* align everything on 4 bytes */
	res_cur_size += 4 - round;
      if (sqv->sqltype < 0)
	sqv->sqltype = -IISQ_CHA_TYPE;
      else
	sqv->sqltype = IISQ_CHA_TYPE;
      break;
    }				/* switch */
    if (sqv->sqltype < 0) {
      res_cur_size += sizeof(short);
      if (round = res_cur_size % 4)	/* align everything on 4 bytes */
	res_cur_size += 4 - round;
    }
  }				/* for each column */

  /*
   * Check on the size of the results area, allocate a bigger results area if
   * necessary.
   */
  if (res_buf.res_length > 0 && res_buf.res_length < res_cur_size) {
    free(res_buf.res_data);
    res_buf.res_length = 0;
  }
  if (res_buf.res_length == 0) {
    if ((res_buf.res_data = sql_malloc(res_cur_size,
				     "result data storage area")) == NULL) {
      return TCL_ERROR;
    }
    res_buf.res_length = res_cur_size;
  }

  /*
   * For each column, compute a pointer into the results area.
   */
  for (res_cur_size = 0, i = 0; i < sqlda->sqld; i++) {
    sqv = &sqlda->sqlvar[i];

    if ((base_type = sqv->sqltype) < 0)
      base_type = -base_type;
    if (base_type == IISQ_FLT_TYPE) {
      if (round = res_cur_size % 8)	/* align doubles on 8 bytes */
	res_cur_size += 8 - round;
    }
    sqv->sqldata = (char *) &res_buf.res_data[res_cur_size];
    res_cur_size += sqv->sqllen;


    if (base_type == IISQ_CHA_TYPE) {
      res_cur_size++;		/* Add a character for the null. */
      if (round = res_cur_size % 4)	/* align everything on 4 bytes */
	res_cur_size += 4 - round;
    }
    if (sqv->sqltype < 0) {
      sqv->sqlind = (short *) &res_buf.res_data[res_cur_size];
      res_cur_size += sizeof(short);
      if (round = res_cur_size % 4)	/* align everything on 4 bytes */
	res_cur_size += 4 - round;
    }
    else {
      sqv->sqlind = (short *) 0;
    }
  }


  *ncols = sqlda->sqld;		/* Return the number of columns in ncol. */

  return TCL_OK;
}


set_res_header(interp, res_var, row_indice, op, sqv, col, coltype)
     Tcl_Interp     *interp;
     char           *res_var;
     char           *row_indice;
     int             op;
     IISQLVAR       *sqv;
     int             col;
     COLTYPE        *coltype;
{
  char            output[BUFSIZ];
  char            res_index[INDEX_LEN];

  if ((op & (SELECT_ALL | SELECT_COLNAMES | SELECT_COLTYPES)) &&
      res_var && (!(op & SELECT_NOHDR)) && (!(op & SELECT_ROW))) {

    if (op & SELECT_COLTYPES)
      sprintf(output, "%d", coltype[col]);
    else
      sprintf(output, "%.*s", sqv->sqlname.sqlnamel, sqv->sqlname.sqlnamec);

    /*
     * If res_var is non-null, then fill the variable named by res_var with
     * the column names
     */
    if (row_indice && (!((op > 0) && (op & SELECT_1D))))
      sprintf(res_index, "%1s,%d", row_indice, col);
    else
      sprintf(res_index, "%d", col);
    Tcl_SetVar2(interp, res_var, res_index, output, 0);
  }
}

/*
 * Read a row from the sqlda, append the results to row # 'row' of the tcl
 * array variable 'res_var'.  The array indices will be row,0  row,1 . . .
 */
append_row(interp, res_var, row_indice, op, sqlda)
     Tcl_Interp     *interp;
     char           *res_var;
     char           *row_indice;
     int             op;
     IISQLDA        *sqlda;
{
  int             i;
  IISQLVAR       *sqv;
  int             base_type;
  char            output[BUFSIZ];
  char            res_index[100];

  for (i = 0; i < sqlda->sqld; i++) {
    sqv = &sqlda->sqlvar[i];

    if (row_indice && (op & SELECT_1D) && (sqlda->sqld == 1))
      /* TODO: we should do something other than a sprintf here. */
      sprintf(res_index, "%s", row_indice);
    else if ((op & SELECT_1D) && (op & SELECT_ROW))
      sprintf(res_index, "%d", i);
    else if (row_indice)
      sprintf(res_index, "%s,%d", row_indice, i);
    else
      sprintf(res_index, "%d", i);

    if (sqv->sqlind && *sqv->sqlind < 0) {
      Tcl_SetVar2(interp, res_var, res_index, "N/A", 0);
      /* Tcl_AppendElement(interp, "N/A", 0); */
    }
    else {
      if ((base_type = sqv->sqltype) < 0)
	base_type = -base_type;

      /*
       * If you get bus errors in the sprintf()s below, check to be sure that
       * alignment is on 4 byte boundaries (for sparc). append_header is
       * probably the culprit.
       */
      switch (base_type) {
      case IISQ_INT_TYPE:
	sprintf(output, "%ld", *(long *) sqv->sqldata);
	break;
      case IISQ_FLT_TYPE:
	/*
	 * Note that if the cast below is a double, then gcc will produce a
	 * bus error, but cc will work ok if there is an alignment problem.
	 */
	sprintf(output, "%g", *(double *) sqv->sqldata);
	break;
      case IISQ_CHA_TYPE:
	sprintf(output, "%s", (char *) sqv->sqldata);
	/* sprintf(output,"%-*s",sqv->sqllen, (char *)sqv->sqldata); */
	break;
      }				/* switch */
      Tcl_SetVar2(interp, res_var, res_index, output, 0);
    }
  }				/* for */
  return TCL_OK;
}

/* Process sql errors. */
sql_error(interp, cmd)
     Tcl_Interp     *interp;
     char           *cmd;	/* Calling tcl command name. */
{
  EXEC SQL BEGIN DECLARE SECTION;
  char            error_buf[BUFSIZ];
  EXEC SQL END DECLARE SECTION;


  EXEC SQL        INQUIRE_SQL(:error_buf = ERRORTEXT);
  Tcl_AppendResult(interp, "\n", cmd, ": SQL Error:\n", error_buf, 0);
}



/*
 * Do any necessary cleanup before exiting. User C code should call this
 * before exiting. This function is the heart of SQLclosedb.
 */
sql_cleanup(interp)
     Tcl_Interp     *interp;

{
  sql_clean_static();
  free_all_cursors();

  /* TODO?: free up any cursors inside SQL*/
  EXEC SQL        DISCONNECT;
  Db_open = 0;
  Db_name[0] = '\0';
}



/*
 * Entry point for all select commands.  The argument 'op' differentiates
 * which operation to perform.  Returns TCL_OK or TCL_ERROR.  Output of
 * select statement will be placed in the variable named by argv[0].
 */
setup_select(clientData, interp, argc, argv, op)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
     int             op;	/* Command operation. */
{
  EXEC SQL BEGIN DECLARE SECTION;
  char           *cbuf;
  EXEC SQL END DECLARE SECTION;
  int             retval;
  static char     select_str[] = "select";
  char           *res_var;

  res_var = argv[1];
  argv[1] = select_str;

  cbuf = Tcl_Concat(argc - 1, argv + 1);
  retval = exec_sql(interp, res_var, argv[0], cbuf, op);
  if (cbuf)
    free(cbuf);
  else
    /* TODO: Need to make this be a tcl style error. */
    fprintf(stderr, "Internal error, cbuf is null!!\n");
  return retval;
}
