


DistributeObject(1)      USER COMMANDS        DistributeObject(1)



_________________________________________________________________

NAME
     DistributeObject, UndistributeObject
     setf, getf
     SetTrigger, SetSlotOwner

       - Tcl-DP support for replicated, distributed objects
_________________________________________________________________

     The distributed object commands described here are  part  of
     the   Tcl-DP  (Tcl  Distributed  Programming)  extension  to
     Tcl/Tk.  These Tcl/Tk commands are used  to  manage  objects
     which  are  distributed among several Tcl/Tk processes.  The
     Tcl/Tk processes must be linked by Tcl-DP  remote  procedure
     call (RPC) connections.

     An object in Tcl-DP is  a  procedure,  just  like  a  widget
     instance  of  Tk  is  a procedure.  A procedural object must
     take as its first argument  a  method  selector.   In  other
     words, if _o_b_j_e_c_t is the name of a procedural object:

     _o_b_j_e_c_t _m_e_t_h_o_d ?_a_r_g_s ...?

     Objects can have slots.  Objects which are to be distributed
     using  Tcl-DP  must  handle two methods, configure and slot-
     value, which access the slots of the object.

     The configure method must handle three  different  forms  of
     arguments,  which  makes  it  very  much  like the configure
     option for Tk widgets:

     _o_b_j_e_c_t configure ?-_s_l_o_t?
     _o_b_j_e_c_t configure ?-_s_l_o_t _v_a_l_u_e ...?
     _o_b_j_e_c_t configure

     When the Tcl/Tk expression "_o_b_j_e_c_t configure" is  evaluated,
     the  return  value  is a list of triplets of the form {-_s_l_o_t
     _d_e_f_a_u_l_t _c_u_r_r_e_n_t}, one triplet for each slot of  the  object.
     The  _s_l_o_t  gives  the  name  of  the slot, _d_e_f_a_u_l_t gives the
     default value of the slot when the object  is  created,  and
     _c_u_r_r_e_n_t  gives  the  current  value  of  the slot within the
     object.  Furthermore, when  the  command  "_o_b_j_e_c_t  configure
     -_s_l_o_t"  is evaluated, the return value should be the triplet
     associated with the given _s_l_o_t.  The command "_o_b_j_e_c_t config-
     ure  -_s_l_o_t  _v_a_l_u_e"  will  set  the  value of the _s_l_o_t of the
     _o_b_j_e_c_t to the given _v_a_l_u_e.

     The slot-value method must take one argument:

     _o_b_j_e_c_t slot-value ?_s_l_o_t?




Sun Release 4.1           Last change:                          1






DistributeObject(1)      USER COMMANDS        DistributeObject(1)



     The slot-value method returns the current value of a _s_l_o_t of
     an _o_b_j_e_c_t.

     Objects are usually defined in  C  for  speed,  with  a  Tcl
     access  interface, just like Tk widgets are defined in C but
     have Tcl access interfaces.  Objects  can  also  be  defined
     using  Tcl/Tk  scripting  only,  as  Tcl-DP supplies several
     utility procedures for creating objects with Tcl/Tk  script-
     ing only.  (See object(l).)

     Each object to be distributed must also  support  a  creator
     command  or  _m_a_k_e_C_m_d.  This is the command used to create an
     object.  It should be of the form "_m_a_k_e_C_m_d  _o_b_j_N_a_m_e  ?-_s_l_o_t_1
     _v_a_l_u_e_1  -_s_l_o_t_2  _v_a_l_u_e_2  ...?".  This command should create a
     procedural object called _o_b_j_N_a_m_e and  initialize  the  slots
     the of new object.

     For example, suppose a point object named _p_1 has two  slots,
     _x  and _y, and the default value for each slot is _0.  Suppose
     the current value of _x is _1 and the current value of _y is _2.
     If  the  _m_a_k_e_C_m_d  is  called  _p_o_i_n_t,  then to create such an
     object, evaluate the command "_p_o_i_n_t _p_1 -_x _1 -_y _2".  Then the
     command  "_p_1 _c_o_n_f_i_g" will have the return value of {{-_x _0 _1}
     {-_y _0 _2}}, the command "_p_1 _c_o_n_f_i_g -_x" will have  the  return
     value of -_x _0 _1, and the command "_p_1 _s_l_o_t-_v_a_l_u_e _x" will have
     the return value of _1.

     Several assumptions were made in the development of the dis-
     tributed  object  system.  First, the graph of RPC connected
     processes is assumed to be acyclic.  If this  assumption  is
     violated,  deadlock  could  result.  Second, each slot of an
     object has an owner process.  Although the value of  a  slot
     can  be set in any process, it is most efficient to do so in
     the owner process.

COMMANDS
     setf _o_b_j_e_c_t _s_l_o_t _v_a_l_u_e

          The setf command is used to set the _v_a_l_u_e of a _s_l_o_t  in
          a  distributed object.  The side effect of this command
          includes replicating the new _v_a_l_u_e of the _s_l_o_t  to  all
          processes where the object is distributed.

     getf _o_b_j_e_c_t _s_l_o_t

          The getf command is used to get the current value of  a
          _s_l_o_t in a distributed object.  It is the counterpart of
          the setf command.

     DistributeObject _o_b_j_e_c_t _p_r_o_c_e_s_s_e_s _m_a_k_e_C_m_d

          DistributeObject arranges for _o_b_j_e_c_t to be  distributed



Sun Release 4.1           Last change:                          2






DistributeObject(1)      USER COMMANDS        DistributeObject(1)



          to  the given _p_r_o_c_e_s_s_e_s.  The argument _o_b_j_e_c_t should be
          the name of the object  to  be  distributed,  _p_r_o_c_e_s_s_e_s
          should  be  a  list  of _f_i_l_e_I_d's (which we can use with
          RPC) which represent connections to  remote  processes,
          and  _m_a_k_e_C_m_d  should  be  the  creator  command for the
          object, as described above.

     UndistributeObject _o_b_j_e_c_t _p_r_o_c_e_s_s_e_s

          UndistributeObject arranges for the slots of _o_b_j_e_c_t  to
          not  be  shared  anymore  with  remote  _p_r_o_c_e_s_s_e_s.  The
          _p_r_o_c_e_s_s_e_s (which should be a  list  of  _f_i_l_e_I_d's  which
          represent RPC connections to remote processes) supplied
          should be the same as or a subset of the _p_r_o_c_e_s_s_e_s ori-
          ginally passed into DistributeObject.  The _o_b_j_e_c_t still
          exists in all processes, but its slots  are  no  longer
          shared.

     SetSlotOwner _o_b_j_e_c_t _s_l_o_t _p_r_o_c_e_s_s

          This command is used to set the owner of a _s_l_o_t  of  an
          _o_b_j_e_c_t  to  be the specified _p_r_o_c_e_s_s (which is a _f_i_l_e_I_d
          that represents an RPC connection to a remote process).
          Although the value of a slot can be set in any process,
          it is most efficient to do so in the process that  owns
          the slot.

     SetTrigger _o_b_j_e_c_t _s_l_o_t _c_m_d

          SetTrigger is used to cause the Tcl command _c_m_d  to  be
          evaluated  whenever  a  call to setf causes the _s_l_o_t of
          _o_b_j_e_c_t to change value.

SEE ALSO
     connect, rpc, Tcl-DP, object

AUTHOR
     Brian Smith (bsmith@cs.berkeley.edu)
     Steve Yen (syen@cs.berkeley.edu)
















Sun Release 4.1           Last change:                          3



