#source "conf.tcl"
initConf $argv

proc createPostitSender {} {global ouropts
    wm title . "PostIt Sender"
    wm iconname . "PostIt Sender"
    set editor [addPostitEditor]
    frame .f
    button .f.postitbutton -text "PostIt" \
	-command "postit \"[keylget ouropts username]\" \[$editor get 0.0 end\] "
    button .f.clear -text "Clear Note" -command "$editor delete 1.0 end"
    pack append .f \
	.f.clear {left fillx} \
	.f.postitbutton {right fillx} 
    pack append . .f {top fillx}
}

proc addPostitEditor {} {
    frame .editf -borderwidth 3 -relief sunken
    text .editf.editor -wrap word -width 30 -height 10 -font *helvetica*-r-*12*
    .editf.editor insert end "Type your message here. Then select the people you want to send the message to, and press the PostIt button."
    pack append .editf .editf.editor {top} 
    pack append . .editf {top}
    return .editf.editor
}

proc postit {from msg} {    # HAVE TO DO REMINDERS TOO
    foreach i [others] {
	RDO [keylget i filedesc] newPostitNote $from $msg 
    }
    after 500 "destroy ."
}

set blat 0
proc getUniqueNumber {} { global blat; incr blat; return $blat }

proc newPostitNote {from msg} {
    # Create a new top-level window
    set window .w[getUniqueNumber]
    toplevel $window
    wm title $window "PostIt Note"
    wm iconname $window "PostIt Note"
    wm protocol $window WM_DELETE_WINDOW "destroy ."
    frame $window.f -bg #ffff9b
    pack append $window $window.f {top} 
    message $window.f.msg -text $msg -font *helvetica*-r-*14* -aspect 300 -bg #ffff9b
    label $window.f.lbl -text $from -font *helvetica*-o-*14* -bg #ffff9b
    pack append $window.f $window.f.lbl top $window.f.msg top 
}

set rhst [keylget ouropts reghost]
set rprt [keylget ouropts regport]
set myid $rhst$rprt
if {$myid==[keylget ouropts originator]} {
    createPostitSender
} else {
    wm withdraw .
}
