proc moogDoIndex {dHost dPort dPath dName} {
  global i

  set I $i
  incr i
  
  toplevel .moogIndex$I
  wm title .moogIndex$I "Index Search - $dName"

  message .moogIndex$I.msg -font -Adobe-times-medium-r-normal--*-180* \
    -aspect 900 \
    -text "Enter the keywords to search for:"

  frame .moogIndex$I.frame -borderwidth 10

  pack append .moogIndex$I.frame \
    [entry .moogIndex$I.frame.keywords -relief sunken] {top fillx} \
    [scrollbar .moogIndex$I.frame.scroll -relief sunken -orient horiz \
      -command ".moogIndex$I.frame.keywords view"] {top fillx} 

  moogBindings .moogIndex$I.frame.keywords

  .moogIndex$I.frame.keywords config -scroll ".moogIndex$I.frame.scroll set"

  bind .moogIndex$I.frame.keywords <Return> \
    "moogIndexACT $dHost $dPort \"$dPath\" \"$dName\" $I"

  button .moogIndex$I.ok -text {Search} \
    -command "moogIndexACT $dHost $dPort \"$dPath\" \"$dName\" $I"

  button .moogIndex$I.cancel -text {Close} \
    -command "destroy .moogIndex$I"
 
  pack append .moogIndex$I \
    .moogIndex$I.msg {top fill} \
    .moogIndex$I.frame {top expand fill} \
    .moogIndex$I.ok {left expand fill} \
    .moogIndex$I.cancel {left expand fill}
}

