menubutton .menu.user -text User -menu .menu.user.m
menu .menu.user.m
.menu.user.m add command -label {Monochrome} -command {
  tk colormodel . monochrome
}
.menu.user.m add command -label {Colour} -command {
  tk colormodel . color
}
.menu.user.m add separator
.menu.user.m add command -label {New xterm} -command {exec xterm &}
.menu.user.m add command -label {New xedit} -command {exec xedit &}
.menu.user.m add command -label {New edit.tk} -command {exec edit.tk &}
.menu.user.m add separator
.menu.user.m add command -label {Go to Selection} -command {
  cd [j:selection_if_any]
  fillbrowser
}
.menu.user.m add command -label {Open This Script} -command {
  exec edit.tk /u/js/bin/scripts/browser.tk &
}

pack append .menu .menu.user right

.cur.list configure \
  -selectbackground bisque3 \
  -selectborderwidth 1 \
  -selectforeground black

######################################################################
# cmd_view - view contents of a file
######################################################################

proc cmd_view {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert {Yup, you're using your own ticklish script.}}
      {*.dvi}
        {exec xdvi $i &}
      {*.obj}
	{exec tgif $i &}
      {*.ps *.eps}
        {exec ghostview $i &}
      {*.gif *.jpg *.p?m *.xbm}
	{exec xv $i &}
      {*.tiff}
        {exec xtiff $i &}
      {*.snd}
        {exec sndplay $i &}
      {*.score}
        {exec playscore $i &}
      {*.tar.Z}
	{tkb_more {Uncompressed archive contents} \
	[exec zcat $i | tar tBvf -]}
      {*.Z}
	{tkb_more {Uncompressed file} [exec zcat $i]}
      {*.tar}
	{tkb_more {Archive contents} [exec tar tvf $i]}
      {default}
	{tkb_more "Contents of `$i'" [exec cat $i]}

      }
    } else {
      j:alert "`$i' is a directory."
    }
  }
}

######################################################################
# cmd_edit - edit a file
######################################################################

proc cmd_edit {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert {Yup, you're using your own ticklish script.}}
      {*.xbm}
		{exec bitmap $i &}
      {*.bdf}
		{exec xfed $i &}
      {*.dvi *.gif *.jpg *.tiff *.Z *.tar core}
		{j:alert "I don't know how to edit this kind of file."}
      {*.obj}
		{exec tgif $i &}
      {default}
		{exec edit.tk $i &}

      }
    } else {
      j:alert "`$i' is a directory."
    }
  }
}

######################################################################
# cmd_print - send a file to the printer
######################################################################

# dependencies:
#	enscript
#	lpr -d (dvi2ps)

proc cmd_print {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert {Yup, you're using your own ticklish script.}}
      {*.c *.h *.f *.tk}
	{exec enscript -2rGh $i &}
      {*.dvi}
	{exec lpr -d $i &}
      {*.tex}
	{j:alert "Process this file, and then print the .dvi file."}
      {*.latex}
	{j:alert "Process this file, and then print the .dvi file."}
      {*.Z *.tar}
	{j:alert "This file cannot be printed without further processing."}
      {core}
	{j:alert "You don't really want to print a core file, do you?"}
      {*.dvi *.gif *.jpg *.tiff *.xbm *.bdf *.p?m}
	{j:alert "I don't know how to print this kind of file."}
      {*.obj}
	{j:alert "Print this file from within TGIF."}
      {default}
	{exec lpr $i &}

      }
    } else {
      j:alert "`$i' is a directory."
    }
  }
}

######################################################################
# cmd_process - compile or otherwise process a file
######################################################################

# counter-intuitive to launch files here, but...
# maybe should put in generalised executable-launching mechanism
# how do you check whether an executable is an X app?  use nm?
# is nm portable?

# add:
#	troff

proc cmd_process {} {
  foreach i [getfiles] {
    if {![file isdirectory $i]} {
      case $i in {

      {browser-test}
	{j:alert {Yup, you're using your own ticklish script.}}
      {[mM]akefile*}
		{tkb_more {Output of `make'} [exec make -f $i]}
      {Imakefile}
		{tkb_more {Output of `xmkmf'} [exec xmkmf]}
      {*.c}
		{tkb_more {Output of `cc'} [exec cc -o [file rootname $i] $i]}
      {*.tex}
		{tkb_more {Output of `tex'} [exec tex $i < /dev/null]}
      {*.latex}
		{tkb_more {Output of `latex'} [exec latex $i < /dev/null]}
      {*.Z}
		{exec zcat $i > [file rootname $i]; fillbrowser}
      {*.tar}
		{tkb_more "Output of `tar xvf $i'" [exec tar xvf $i]}
      {*.shar}
		{tkb_more {Output of `sh'} [exec sh $i]}
      {*.uu *.uud}
		{exec uudecode $i; fillbrowser}
      {*.tk}
		{exec $i}
      {*.obj}
		{j:alert "I can't process this file."}
      {default}
		{j:alert "I don't know what to do with this file."}

      }
    } else {
      j:alert "`$i' is a directory."
    }
  }
}
