/* Copyright (c) 1993 by Sanjay Ghemawat */
/*
 * Common hash functions.
 */

#include "Hash.h"

unsigned int hash_int(int x) {
    return (((unsigned int) x) * 2654435767);
}

unsigned int hash_string(char const* x) {
    char const* p;
    unsigned int h = 0;
    unsigned int g;

    for (p = x; *p != '\0'; p++) {
        h = (h << 4) + *p;
        if ((g = h & 0xf0000000)) {
            h = h ^ (g >> 24);
            h = h ^ g;
        }
    }
    return h;
}
