# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Error Dialog
#
# Commands
#
#	error_notify <leader> <message>
#		Display error message to user.

# Hidden global variables
#
#	error_init		Created error dialog window?
#	error_done		Is error interaction finished

set error_init 0
set error_done 0

proc error_notify {leader message} {
    error_make
    error_interact $leader $message
}

proc error_make {} {
    global error_init error_done
    if {$error_init} {return}
    set error_init 1

    set f .error_dialog

    toplevel $f -class Dialog
    wm title $f Error
    wm protocol $f WM_DELETE_WINDOW {set error_done 1}

    frame $f.top -relief raised -bd 1
    frame $f.bot -relief raised -bd 1
    frame $f.bot.default -relief sunken -bd 1

    label $f.icon -bitmap [icon warn.xbm]
    message $f.text -aspect 400 -text {Uninitialized Error Message}
    button $f.yes -text Okay -command {set error_done 1}

    pack append $f.top $f.text {right expand fill padx 5m pady 5m}
    pack append $f.top $f.icon {left padx 5m pady 5m}

    pack append $f.bot.default $f.yes {left padx 3m pady 3m}
    pack append $f.bot $f.bot.default {left expand}

    pack append $f $f.top {top fill}
    pack append $f $f.bot {bottom fill}

    bind $f <Control-c> {set error_done 1}
    bind $f <Return> {set error_done 1}

    wm withdraw $f
    update
}

proc error_interact {leader message} {
    global error_done
    set f .error_dialog

    # Fix dialog contents
    $f.text configure -text $message

    # Run dialog
    set error_done -1
    dialog_run $leader $f $f error_done
}
