/* Copyright (c) 1993 by Sanjay Ghemawat */
#ifndef _ITEM_TCL_H
#define _ITEM_TCL_H

/*
 * TCL Interface to items.
 */

#include "object.h"
#include "item.h"

class Item_Tcl : public Object {
  public:
    Item_Tcl(Tcl_Interp*, Item*);
    virtual ~Item_Tcl();

    /*
     * effects	Return associated item
     */
    Item* value();

    /*
     * effects	Returns Item_Tcl for specified item.  If no such
     *		Item_Tcl exists, returns 0.
     */
    static Item_Tcl* find(Item*);

    /*
     * effects	Handle TCL commands
     */
    virtual int method(int, char*[]);
  private:
    Item* item;		/* Associated item */
};

inline Item* Item_Tcl::value() {
    return item;
}

#endif /* _ITEM_TCL_H */
