/* Copyright (c) 1993 by Sanjay Ghemawat */
#ifndef _COLLECT_H
#define _COLLECT_H

/*
 * Collect item occurrences.
 */

#include "Array.h"
#include "Date.h"

class Item_Tcl;

/*
 * Item listing sorted by occurrence date.
 */

struct Occurrence {
    Item_Tcl* item;
    Date      date;
};

declareArray(Occurrences,Occurrence)

/*
 * Fill list with occurrences in specified range.
 *
 * If earlywarning is true, also consider items whose early warning
 * period falls in the specified range.
 */
extern void collect_occurrences(Occurrences& list,
				Date start,
				Date finish,
				int  earlywarning);

/*
 * Sort occurrences.
 */
extern void sort_occurrences(Occurrences&);

#endif /* _COLLECT_H */
