#include <stdio.h>
#include <sys/param.h>  /* MIN and MAX */
#include <sys/vlimit.h>

#define IF ((
#define THEN )?(
#define ELSE ):(
#define FI ))

#define MIN_HEAP_SIZE 524288  /* .5 Mb */
#define DEFAULT_HEAP_SIZE 4096000  /* 4 Mb  */
#define STDIO_SPACE   49152   /* be sure to save 48k of data space for stdio */
#define STATIC_SPACE  131072  /* .125Mb for fun, usr "-l" to add to this */
#define SAVED_SPACE   (STDIO_SPACE+STATIC_SPACE)

extern char *etext;

main( argc, argv )
char **argv;
int argc;
{
    long heap_wanted = -1;
    long leave_wanted = -1;
    long debug = 0;

    long
	data_used,
	data_avail,
	max_heap_size,
	heap_size;
			  
    long
	total,
	aligned_total,
	aligned_heap_size;

    char **av;

    av = argv;
    av[argc] = 0; /* easy end test */

    while (*av)  {
	if ( ( !strcmp( *av, "-h" ) ) || ( !strcmp( *av, "-heap" ) ) )
	    heap_wanted = IF (!*++av) THEN -2 ELSE atoi( *av ) FI;
	else if ( ( !strcmp( *av, "-l" ) ) || ( !strcmp( *av, "-leave" ) ) )
	    leave_wanted = IF (!*++av) THEN -2 ELSE atoi( *av ) FI;
	else if (!strcmp( *av, "-d" ) )
	    debug = -1;
	av++;
    }

    /* Compute max allowed heap size.  MIN in case datasize is big. */
    /*  Quad align. */

    data_used  = (char *) sbrk(0) - (char *) &etext;
    data_avail = vlimit(LIM_DATA, -1)
		 - ( SAVED_SPACE + data_used + leave_wanted );
    max_heap_size = (data_avail/2) & 0xFFFFFFF8;
				   
    /* decide what to allocate - give user his request if it's within reason */

    if (heap_wanted < 0) 
	heap_size = MIN(DEFAULT_HEAP_SIZE,max_heap_size);
    else if (heap_wanted > max_heap_size)
	heap_size = max_heap_size;
    else
	heap_size = MAX( heap_wanted, MIN_HEAP_SIZE );

    total = sbrk( heap_size * 2 );
    if (total == -1)  {
	printf( "T could not allocate two heaps of %d bytes.\n", heap_size);
	printf( "Please retry with smaller heaps by using the -h switch.\n");
	exit(1);
    }
		
    /* make heaps smaller (if necessary) for quadword alignment */

    aligned_total = (total + 15) & 0xFFFFFFF0;
    aligned_heap_size = ( ((heap_size * 2) - (aligned_total - total))
			  & 0xFFFFFFF0 );

    heap_size = aligned_heap_size / 2;

    /* print message if any command line flag is given */

    if ( (heap_wanted != -1) || (leave_wanted != -1) )
	printf( "%d bytes per heap, %d bytes reserved\n",
		heap_size, leave_wanted + STATIC_SPACE );

    start_t( aligned_total, (aligned_total + heap_size), heap_size, 
             argc, argv, debug);
}

gc_interrupt()
{
  printf("Interrupted during GC; 'q' to exit, anything else to continue GC.\n");
  if (getchar() == 'q')
     exit(0);
}

extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;

get_unix_error_msg(t, size) 
char *t;
int size; 
{
  char *s;    
  int i;

  i = 0;
  s = (char *) sys_errlist[ errno ];
  while (i<size && ((*t++ = *s++) != '\0')) i++; 
}



