(herald spkernel (env tsys))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define (risc-big-bang)
  (lap (big_bang handle-stack-base
         icall-bad-proc icall-wrong-nargs
         handle-undefined-effect
        really-gc
        heap-overflow-error interrupt-handler cont-wrong-nargs)

    (move link-reg %g6)
    (store l nil-reg (d@nil %%cdr))            ; (cdr '()) = '()
    (store l nil-reg (d@nil %%car))             ; (car '()) = '()
    (store l P (d@nil slink/kernel))        ; save kernel pointer

    (movea %extra-args extra)
    (store l extra (d@nil slink/make-extra-args))
    (movea %nary-setup extra)
    (store l extra (d@nil slink/nary-setup))
    (movea %undefined-effect extra)
    (store l extra (d@nil slink/undefined-effect))
    (movea %make-pair extra)
    (store l extra (d@nil slink/make-pair))
    (movea %make-extend extra)
    (store l extra (d@nil slink/make-extend))
    (movea %heap-overflow extra)
    (store l extra (d@nil slink/heap-overflow))
    (movea %set extra)
    (store l extra (d@nil slink/set))
    (movea %icall extra)
    (store l extra (d@nil slink/icall))
    (movea %cont-wrong-nargs extra)
    (store l extra (d@nil slink/cont-wrong-nargs))
    (movea %kernel-begin extra)
    (store l extra (d@nil slink/kernel-begin))
    (movea %kernel-end extra)
    (store l extra (d@nil slink/kernel-end))

    ;; initialize root process, stored in outer space?  

;    (sub ($ 4) sp)
;    (movec #xBADBAD extra)                       ; distinguished value
;    (store l extra (d@r sp 0))
;    (movea stack-base-template extra)
;    (sub ($ 2) extra link-reg)		;this will become the stack base
;    (sub ($ 4) sp  extra)
;    (store l extra (d@nil slink/stack))	;point to future stack base
    (store l nil-reg (d@nil slink/dynamic-state))

    (store l nil-reg (d@nil slink/doing-gc?))
    (store l nil-reg (d@nil slink/k-list))
    (store l nil-reg (d@nil slink/gc-weak-set-list))
    (store l nil-reg (d@nil slink/gc-weak-alist-list))
    (store l nil-reg (d@nil slink/gc-weak-table-list))
    (store l nil-reg (d@nil slink/snapper-freelist))
    (store l nil-reg (d@nil slink/pair-freelist))
    (load l (d@r P (static big_bang)) P)
    (load l (d@r p 2) p)
    (jr (d@r %g6 0))
    (noop)

%extra-args				;bytes in scratch
    (load l (d@nil slink/area-frontier) extra)
    (add extra scratch)
    (load l (d@nil slink/area-limit) vector)
    (j> scratch vector %extra-args-heap-overflow)
    (store l scratch (d@nil slink/area-frontier))
    (add ($ 8) scratch vector)
    (add ($ 3) extra extra-args)
    (add ($ 11) extra)
extra-args-test
    (j> extra vector extra-args-done)
    (store l extra (d@r extra -11))
    (add ($ 8) extra)
    (jbr extra-args-test)
extra-args-done
    (store l nil-reg (d@r extra -19))
    (jr (d@r link-reg 0))
    (noop)
%extra-args-heap-overflow
    (store l zero (d@nil slink/doing-gc?))
    (sub extra scratch)
    (move link-reg extra)			;heap overflow moves it back
    (load l (d@nil slink/heap-overflow) link-reg)
    (jalr (d@r link-reg 0))
    (noop)
    (store l nil-reg (d@nil slink/doing-gc?))
    (jbr %extra-args)
  
;; in nary-setup NARGS is referred to as %i4 because the value in nargs from
;; the caller has passed through a save by the jumper to nary-setup!!

%nary-setup                                 ; required args in vector
  (sub ($ 1) %I4)
  (sub vector %i4 parassign-extra)
  (j= parassign-extra zero no-rest-args)
  (sll ($ 3) parassign-extra)			;bytes to cons
%nary-setup-continue                        ; lose, lose
  (load l (d@nil slink/area-frontier) AN)
  (add an parassign-extra)
  (load l (d@nil slink/area-limit) extra)
  (j> parassign-extra extra %nary-make-pair-heap-overflow)
  (store l parassign-extra (d@nil slink/area-frontier))
  (add ($ 3) an)
  (add ($ 8) an extra)
  (j= vector zero move-a1)
  (j= vector ($ 1) move-a2)
  (j= vector ($ 2) move-a3)
  (j= vector ($ 3) move-a4)
  (j= vector ($ 4) move-a5)
many-loop
  (load l (d@r extra-args %%car) vector)
  (load l (d@r extra-args %%cdr) extra-args)
  (store l vector (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j< vector %i4 many-loop)
  (jr (d@r link-reg 0))
  (store l extra-args (d@r extra -19))
move-a1
  (store l a1 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector %i4 registers-moved)
move-a2
  (store l a2 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector %i4 registers-moved)
move-a3
  (store l a3 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector %i4 registers-moved)
move-a4
  (store l a4 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector %i4 registers-moved)
move-a5
  (store l a5 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector %i4 registers-moved)
  (jr (d@r link-reg 0))
  (store l extra-args (d@r extra -19))
registers-moved
  (jr (d@r link-reg 0))
  (store l nil-reg (d@r extra -19))
no-rest-args
  (jr (d@r link-reg 0))
  (move nil-reg an)
%nary-make-pair-heap-overflow
    (store l zero (d@nil slink/doing-gc?))
    (sub an parassign-extra)
    (move link-reg extra)			;heap overflow moves it back
    (load l (d@nil slink/heap-overflow) link-reg)
    (jalr (d@r link-reg 0))
    (noop)
    (store l nil-reg (d@nil slink/doing-gc?))
    (jbr %nary-setup-continue)
 
%make-pair
    ;; return pair in AN
    (load l (d@nil slink/area-frontier) AN)
    (add ($ 8) AN)
    (load l (d@nil slink/area-limit) extra)
    (j> AN extra %make-pair-heap-overflow)
%make-pair-continue
    (store l AN (d@nil slink/area-frontier))
    (sub ($ 5) AN)
    (clear l (d@r AN %%car))
    (clear l (d@r AN %%cdr))
    (jr (d@r link-reg 0))
    (noop)

%make-pair-heap-overflow
    (store l zero (d@nil slink/doing-gc?))
    (move link-reg extra)			;heap overflow moves it back
    (jl %heap-overflow) 
    (noop)
    (load l (d@nil slink/area-frontier) AN)
    (add ($ 8) AN)
    (load l (d@nil slink/area-limit) scratch)
    (j> AN scratch %horrible-heap-overflow)
    (store l nil-reg (d@nil slink/doing-gc?))
    (jbr %make-pair-continue)
    

%make-extend
    ;; receive descriptor in An, size in bytes in scratch,
    ;; return extend in AN.
    (load l (d@nil slink/area-frontier) extra)
    (add ($ 4) scratch)                           
    (add extra scratch)
    (load l (d@nil slink/area-limit) parassign-extra)
    (j> scratch parassign-extra %make-extend-heap-overflow)
%make-extend-continue  
    (store l scratch (d@nil slink/area-frontier))
    (store l AN (d@r extra 0))
    (add ($ 2) extra AN)
    (add ($ 4) extra)
    (jbr extend-test)
extend-loop
    (clear l (d@r extra 0))
    (add ($ 4) extra)
extend-test
    (j> scratch extra extend-loop)
copy-done
    (jr (d@r link-reg 0))
    (noop)
   
%make-extend-heap-overflow
    (store l zero (d@nil slink/doing-gc?))
    (sub extra scratch)
    (move link-reg extra)			;heap overflow moves it back
    (jl %heap-overflow) 
    (noop)
    (load l (d@nil slink/area-frontier) extra) ; get area-frontier
    (add extra scratch) 
    (load l (d@nil slink/area-limit) parassign-extra) ; get area-frontier
    (j> scratch parassign-extra %horrible-heap-overflow)
    (store l nil-reg (d@nil slink/doing-gc?))
    (jbr %make-extend-continue)

%heap-overflow				;extra and link-reg have been swapped
   (noop)
#|    (sub ($ (* (+ *argument-registers* 9) 4)) sp) ;scratch,vector,extra::
	 	 			;an+1,link,p,an,eargs,parassign-extra
    (store l link-reg (d@r sp 0))		;internal return address
    (store l extra-args (d@r sp 4))
    (store l parassign-extra (d@r sp 8))
    (store l an+1 (d@r sp 12))
    (store l an (d@r sp 16))
    (store l a11 (d@r sp 20))
    (store l a10 (d@r sp 24))
    (store l a9 (d@r sp 28))
    (store l a8 (d@r sp 32))
    (store l a7 (d@r sp 36))
    (store l a6 (d@r sp 40))
    (store l a5 (d@r sp 44))
    (store l a4 (d@r sp 48))
    (store l a3 (d@r sp 52))
    (store l a2 (d@r sp 56))
    (store l a1 (d@r sp 60))
    (store l p (d@r sp 64))
    (store l scratch (d@r sp 68))
    (store l vector (d@r sp 72))
    (store l extra (d@r sp 76))		;real return address
    (add ($ (+ (* (+ *argument-registers* 8) 4) 2)) sp a1) ;stack to gc
    (add ($ 2) sp a2)			;gc-frame to gc
    (load l (d@nil slink/kernel) P)
    (load l (d@r P (static really-gc)) P)
    (load l (d@r p 2) p)
    (load l (d@r P -2) extra)
    (jalr (d@r extra 2))
    (noop)
    (sub ($ 4) sp a2)
    (mask ($ 31) a2 a3)			;check for multiple of 8 longwords
    (j= a3 zero gc-zero)
    (store l zero (d@r a2 0))
    (sub ($ 4) a2)
    (mask ($ 31) a2 a3)			;check for multiple of 8 longwords
    (j= a3 zero gc-zero)
    (store l zero (d@r a2 0))
    (sub ($ 4) a2)
    (mask ($ 31) a2 a3)			;check for multiple of 8 longwords
    (j= a3 zero gc-zero)
    (store l zero (d@r a2 0))
    (sub ($ 4) a2)
    (mask ($ 31) a2 a3)			;check for multiple of 8 longwords
    (j= a3 zero gc-zero)
    (store l zero (d@r a2 0))
    (sub ($ 4) a2)
    (mask ($ 31) a2 a3)			;check for multiple of 8 longwords
    (j= a3 zero gc-zero)
    (store l zero (d@r a2 0))
    (sub ($ 4) a2)
    (mask ($ 31) a2 a3)			;check for multiple of 8 longwords
    (j= a3 zero gc-zero)
    (store l zero (d@r a2 0))
    (sub ($ 4) a2)
    (mask ($ 31) a2 a3)			;check for multiple of 8 longwords
    (j= a3 zero gc-zero)
    (store l zero (d@r a2 0))
    (sub ($ 4) a2)
gc-zero
    (movec #x80000 a3)			;(* 512 1024)
    (sub ($ 3) nil-reg a1)		;bottom of stack
    (sub a3 a1)			;lowest possible stack location
    (add ($ 31) a1)
    (movec #xffffffe0 scratch)
    (and scratch a1)			;make multiple of 8 longwords
    (j= a1 a2 gc-zero-done)
gc-zero-loop
    (store l zero (d@r a1 0))
    (store l zero (d@r a1 4))
    (store l zero (d@r a1 8))
    (store l zero (d@r a1 12))
    (store l zero (d@r a1 16))
    (store l zero (d@r a1 20))
    (store l zero (d@r a1 24))
    (store l zero (d@r a1 28))
    (add ($ 32) a1)
    (jn= a1 a2 gc-zero-loop)
gc-zero-done
    (store l zero (d@r a1 0))		;last one
    (load l (d@r sp 0) extra)
    (load l (d@r sp 4) extra-args)
    (load l (d@r sp 8) parassign-extra)
    (load l (d@r sp 12) an+1)
    (load l (d@r sp 16) an)
    (load l (d@r sp 20) a11)
    (load l (d@r sp 24) a10)
    (load l (d@r sp 28) a9)
    (load l (d@r sp 32) a8)
    (load l (d@r sp 36) a7)
    (load l (d@r sp 40) a6)
    (load l (d@r sp 44) a5)
    (load l (d@r sp 48) a4)
    (load l (d@r sp 52) a3)
    (load l (d@r sp 56) a2)
    (load l (d@r sp 60) a1)
    (load l (d@r sp 64) p)
    (load l (d@r sp 68) scratch)
    (load l (d@r sp 72) vector)
    (load l (d@r sp 76) link-reg)
    (store l zero (d@r sp 68))		;clear slot for scratch
    (store l zero (d@r sp 72))		;clear slot for vector
    (jr extra)
    (add ($ (* (+ *argument-registers* 9) 4)) sp) ;scratch,vector,extra::
	 	 			;link,p,an,extra-args,parassign-extra
|#           
;;; the template header byte has high bit set if nary

%icall                     
  (mask ($ 3) P vector)
  (jn= vector ($ tag/extend) %icall-bad-proc)
  (load l (d@r P -2) extra)                         ; fetch header
  (mask ($ 3) extra vector)                 ; check header is extend
  (jn= vector ($ tag/extend) %icall-bad-proc)
  (load ub (d@r extra template/header) vector)
  (jn= vector ($ header/template) %icall-check-nary)
  (load sb (d@r extra template/nargs) parassign-extra)         ; check number of args
  (j= parassign-extra nargs %icall-ok)
  (jbr %icall-wrong-nargs)
%icall-check-nary
  (jn= vector ($ (fx+ header/template 128)) %icall-bad-proc)
  (load sb (d@r extra template/nargs) parassign-extra)         ; check number of args
  (j> parassign-extra NARGS %icall-wrong-nargs)
%icall-ok
  (jr (d@r extra 2))
  (noop)

%icall-bad-proc
  (store l p (d@nil slink/P))
  (load l (d@nil slink/kernel) P)
  (load l (d@r P (static icall-bad-proc)) P)
  (load l (d@r p 2) p)
  (load l (d@r P -2) extra)
  (jr (d@r extra 2))
  (noop)

%icall-wrong-nargs
  (store l p (d@nil slink/P))
  (load l (d@nil slink/kernel) P)
  (load l (d@r P (static icall-wrong-nargs)) P)
  (load l (d@r p 2) p)
  (load l (d@r P -2) extra)
  (jr (d@r extra 2))
  (noop)


%deferred-interrupts
#|    (sub ($ (* (+ *argument-registers* 7) 4)) sp) 
	 	 			;an+1,link,p,an,eargs,parassign-extra,
    (store l extra (d@r sp 0))		;extra
    (store l extra-args (d@r sp 4))
    (store l parassign-extra (d@r sp 8))
    (store l an+1 (d@r sp 12))
    (store l an (d@r sp 16))
    (store l a11 (d@r sp 20))
    (store l a10 (d@r sp 24))
    (store l a9 (d@r sp 28))
    (store l a8 (d@r sp 32))
    (store l a7 (d@r sp 36))
    (store l a6 (d@r sp 40))
    (store l a5 (d@r sp 44))
    (store l a4 (d@r sp 48))
    (store l a3 (d@r sp 52))
    (store l a2 (d@r sp 56))
    (store l a1 (d@r sp 60))
    (store l p (d@r sp 64))
    (store l link-reg (d@r sp 68))
    (load l (d@nil slink/kernel) P)
    (load l (d@r P (static interrupt-handler)) P)
    (load l (d@r p 2) p)
    (load l (d@r P -2) extra)
    (jalr (d@r extra 2))
    (add ($ 12) link-reg)
    (template 17 -1 t)
    (load l (d@r sp 0) extra)
    (load l (d@r sp 4) extra-args)
    (load l (d@r sp 8) parassign-extra)
    (load l (d@r sp 12) an+1)
    (load l (d@r sp 16) an)
    (load l (d@r sp 20) a11)
    (load l (d@r sp 24) a10)
    (load l (d@r sp 28) a9)
    (load l (d@r sp 32) a8)
    (load l (d@r sp 36) a7)
    (load l (d@r sp 40) a6)
    (load l (d@r sp 44) a5)
    (load l (d@r sp 48) a4)
    (load l (d@r sp 52) a3)
    (load l (d@r sp 56) a2)
    (load l (d@r sp 60) a1)
    (load l (d@r sp 64) p)
    (load l (d@r sp 68) link-reg)
    (jr link-reg)
    (sub ($ (* (+ *argument-registers* 7) 4)) sp) ;extra.
	 	 			;link,p,an,extra-args,parassign-extra
|#
%kernel-begin
  (noop)
%cont-wrong-nargs
  (sub ($ 2) link-reg extra)
  (store l extra (d@nil slink/P))
  (load l (d@nil slink/kernel) P)
  (load l (d@r P (static cont-wrong-nargs)) P)
  (load l (d@r p 2) p)
  (load l (d@r P -2) extra)
  (jr (d@r extra 2))
  (sub nargs zero nargs)
                

%set                                        ; a location is (unit  . index)
;;  vcell in parassign-extra 
;; regs pextra=value,scratch=len counter,extra-args=snapper,an-1=vector
   (load l (d@r parassign-extra 6) an-1)                  ; get locations
   (load l (d@r parassign-extra 2) parassign-extra) ;get value
   (load l (d@r an-1 2) an-1)                  ; get the vector from weak-alist
   (load l (d@r an-1 -2) scratch)
   (sra ($ 8) scratch)
   (sll ($ 2) scratch)
   (sub ($ 4) scratch)			;so offset is less than 4 (88000)
   (jbr %set-test)
%set-loop
   (load l (d@nil slink/snapper-freelist) an)
   (j= an nil-reg cons-snapper)
   (load l (d@r an %%car) extra-args)
   (load l (d@r an %%cdr) vector)
   (store l vector (d@nil slink/snapper-freelist))
   (load l (d@nil slink/pair-freelist) vector)
   (store l vector (d@r an %%cdr))
   (store l an (d@nil slink/pair-freelist))
%real-top
   (store l parassign-extra (d@r extra-args 2)) ;snapper-value
   (add an-1 scratch vector)
   (load l (d@r vector -2) an)		;unit
   (store l an (d@r extra-args 6))		;snapper-unit
   (load l (d@r vector 2) vector)	;index
   (store l vector (d@r extra-args 10))	;snapper-index
   (add an vector vector)
   (store l extra-args (d@r vector 2))	;store away snapper
   (sub ($ 8) scratch)
%set-test
   (j> scratch zero %set-loop)
   (jr (d@r link-reg 0))
   (noop)
cons-snapper
   (load l (d@nil slink/area-frontier) AN)
   (add ($ 16) AN)
   (load l (d@nil slink/area-limit) vector)
   (j> AN vector %set-heap-overflow)
%set-continue                        ; lose, lose
   (store l AN (d@nil slink/area-frontier))
   (add ($ -14) an extra-args)
   (load l (d@nil slink/kernel) an)
   (load l (d@r an (static *link-snapper-template*)) an)
   (load l (d@r an 2) an)
   (store l an (d@r extra-args -2))
   (jbr %real-top)
%set-heap-overflow
    (store l zero (d@nil slink/doing-gc?))
    (move link-reg extra)			;heap overflow moves it back
    (jl %heap-overflow) 
    (noop)
    (load l (d@nil slink/area-frontier) AN)
    (add ($ 16) AN)
    (load l (d@nil slink/area-limit) vector)
    (j> AN vector %horrible-heap-overflow)
    (store l nil-reg (d@nil slink/doing-gc?))
    (jbr %set-continue)

%kernel-end
  (noop)      
%horrible-heap-overflow
    (store l nil-reg (d@nil slink/doing-gc?))
    (load l (d@nil slink/kernel) P)
    (load l (d@r P (static heap-overflow-error)) P)
    (load l (d@r p 2) p)
    (load l (d@r P -2) extra)
    (jr (d@r extra 2))
    (move ($ 1) nargs)

%undefined-effect
  (sub ($ 2) link-reg a2)
  (load l (d@nil slink/kernel) P)
  (load l (d@r P (static handle-undefined-effect)) P)
  (load l (d@r p 2) p)
  (load l (d@r P -2) extra)
  (jr (d@r extra 2))
  (move ($ 3) nargs)
))                         

(define (gc)
  (lap ()
    (store l zero (d@nil slink/doing-gc?))
    (move link-reg extra)			;heap overflow moves it back
    (jl %heap-overflow) 
    (noop)
    (store l nil-reg (d@nil slink/doing-gc?))
    (jr (d@r link-reg 0))
    (move ($ -1) nargs)))
    

                 
(lap-template (0 1 nil stack stack-base-handler)
stack-base-template
  (load l (d@nil slink/undefined-effect) extra)
  (jr (d@r extra 0))
  (noop)
stack-base-handler
  (load l (d@nil slink/kernel) AN)
  (load l (d@r AN (static handle-stack-base)) A1)
  (load l (d@r a1 2) a1)
  (load l (d@nil slink/dispatch-label) extra)
  (jr (d@r extra 0))
  (noop))
    

; debugger hacks

(define (@@ address)    ; randomness
  (lap ()
    (add ($ 2) a1)
    (jr (d@r link-reg 0))
    (move ($ -2) nargs)))

;(define-foreign gc-interrupt ("gc_interrupt") ignore)

(define (crawl-exhibit-interrupt-frame frame)
  (print-register frame 'an+1 3)
  (print-register frame 'an 4)
  (print-register frame 'a11 5)
  (print-register frame 'a10 6)
  (print-register frame 'a9 7)
  (print-register frame 'a8 8)
  (print-register frame 'a7 9)
  (print-register frame 'a6 10)
  (print-register frame 'a5 11)
  (print-register frame 'a4 12)
  (print-register frame 'a3 13)
  (print-register frame 'a2 14)
  (print-register frame 'a1 15)
  (print-register frame 'p 16))
  


(define (make-link-snapper value unit i)
  (lap ()
    (load l (d@nil slink/snapper-freelist) p)
    (j= p nil-reg cons-snapper-1)
    (load l (d@r p %%car) an)
    (load l (d@r p %%cdr) extra)
    (store l extra (d@nil slink/snapper-freelist))
    (load l (d@nil slink/pair-freelist) extra)
    (store l extra (d@r p %%cdr))
    (store l p (d@nil slink/pair-freelist))
foobarfoo
    (store l a1 (d@r an 2))
    (store l a2 (d@r an 6))
    (store l a3 (d@r an 10))
    (move an a1)
    (jr (d@r link-reg 0))
    (move ($ -2) nargs)
cons-snapper-1
    (sub ($ 4) sp)
    (store l link-reg (d@r sp 0))
    (movea link-snapper an)
    (sub ($ 2) an)			;make code address it a template!
    (move ($ 12) scratch)
    (jl %make-extend)
    (add ($ 12) link-reg)
    (template 0 -1 t)
    (load l (d@r sp 0) link-reg)
    (add ($ 4) sp)
    (jbr foobarfoo)))

(define *link-snapper-template*
(lap-template (3 1 t heap handle-snapper)
link-snapper
  (move p an)
  (load l (d@r p 2) p)
  (mask ($ 3) P vector)
  (jn= vector ($ tag/extend) %icall-bad-proc)
  (load l (d@r P -2) parassign-extra)                         ; fetch header
  (mask ($ 3) parassign-extra vector)                 ; check header is extend
  (jn= vector ($ tag/extend) %icall-bad-proc)
  (load ub (d@r parassign-extra template/header) vector)
  (jn= vector ($ header/template) %icall-check-nary-l)
  (load ub (d@r parassign-extra template/nargs) vector)
  (j= vector NARGS snap-link)         ; check number of args
  (jbr %icall-wrong-nargs)
%icall-check-nary-l
  (jn= vector ($ (fx+ header/template 128)) %icall-bad-proc)
  (load ub (d@r parassign-extra template/nargs) vector)
  (j> vector NARGS %icall-wrong-nargs)
snap-link
  (load l (d@r an 10) vector)
  (load l (d@r an 6) extra)
  (add extra vector)
  (store l p (d@r vector 2))
  (move an parassign-extra)
  (load l (d@nil slink/pair-freelist) an)
  (j= an nil-reg cons-pair)
  (load l (d@r an %%cdr) extra)
  (store l extra (d@nil slink/pair-freelist))
consed-pair
  (store l parassign-extra (d@r an %%car))
  (load l (d@nil slink/snapper-freelist) extra)
  (store l extra (d@r an %%cdr))
  (store l an (d@nil slink/snapper-freelist))
  (load l (d@r p -2) extra)
  (jr (d@r extra 2))
  (noop)
cons-pair
  (sub ($ 4) sp)
  (store l link-reg (d@r sp 0))
  (jl %make-pair)
  (add ($ 12) link-reg)
  (template 0 -1 t)
  (load l (d@r sp 0) link-reg)
  (add ($ 4) sp)
  (jbr consed-pair)
handle-snapper
  (jr (d@r link-reg 0))
  (move nil-reg AN)))
#|
(define (reset-ssp ssp)
  (lap ()
    (move a1 ssp)
    (jr (d@r link-reg 0))
    (move ($ -1) nargs)))
|#