(herald sp_dispatch (env tsys))

(define (dispatch-init)
  (lap (handle-stype handle-true handle-fixnum handle-pair
        handle-char handle-nonvalue *handlers* icall-wrong-nargs
        bogus-return bogus-return-miss apply handle-immediate
	handle-magic-frame no-default-method)

    (move link-reg a1)			;movea kills this
    (store l p (d@nil slink/dispatch))
    (movea dispatch extra)
    (store l extra (d@nil slink/dispatch-label))
    (jr (d@r a1 0))
    (move ($ -1) nargs)))


(define *magic-frame-template*
 (lap-template (4 -1 t stack magic-frame-handler)
  (load l (d@r sp 16) link-reg)
  (jr (d@r link-reg 0))
  (add ($ 20) sp)
magic-frame-handler
  (load l (d@nil slink/dispatch) AN)
  (load l (d@r AN (static handle-magic-frame)) A1)
  (load l (d@r a1 2) a1)
  (jbr dispatch)))

(define *structure-template*
  (lap-template (0 1 nil heap structure-handler)
    (load l (d@nil slink/undefined-effect) extra)
    (jr (d@r extra 0))
    (noop)
structure-handler
    (load l (d@r A1 -2) A1)                       ; internal-template
    (load l (d@r A1 -30) A1)                        ; stype-handler
    (jbr dispatch)))

    
(define *stype-template*
  (lap-template (9 1 nil heap stype-handler)           ; stype size is 9
    (load l (d@nil slink/undefined-effect) extra)
    (jr (d@r extra 0))
    (noop)
stype-handler
    (load l (d@nil slink/dispatch) AN)
    (load l (d@r AN (static handle-stype)) A1)
    (load l (d@r a1 2) a1)
    (jbr dispatch)))
  
(define *traced-op-template*
  (lap-template (0 1 nil heap t-op)
    (save ($ -64) sp sp)
    (move A1 S3)                                   ; self
    (move nil-reg S2)
    (move P S1)                                    ; op
    (move A1 S0)                                   ; obj
    (jl dispatch)
    (add ($ template/return-offset) link-reg)
    (template 0 -1 t)
    (j= AN nil-reg traced-op-default)	; did we get a method?
					; AN contains code
    (move A1 P)                              ; environment
    (move S3 A1)                         ; self is first arg of method
    (move S0 %i1)		;obj
    (jbr op-icall)
traced-op-default
    (load l (d@r P 6) P)                       ; rhs is operation
    (jbr default)))

  

;;; We have the operation in P, the object in A1 and we can use AN which is
;;; where the method id returned

;;; nargs is %i4 from here on because of the save
(define *operation-template*
  (lap-template (3 1 t heap operation-handler)
    (save ($ -64) sp sp)
    (move A1 S3)                                   ; self
    (move nil-reg S2)
    (move P S1)                                    ; op
    (move A1 S0)                                   ; obj
    (jl dispatch)
    (add ($ template/return-offset) link-reg)
    (template 0 -1 t)
    (j= AN nil-reg default)                             ; did we get a method?
    (move A1 P)
    (move S3 A1)                    ; self is first arg of method
    (move S0 %i1)			;AN+1/in obj
op-icall
    (load sb (d@r AN (- template/nargs 2)) vector) ;handler added this 2
    (j= %I4 vector %icall-ok)         ; check number of args
    (j< %i4 vector %icall-wrong-nargs)
    (load ub (d@r an (- template/header 2)) vector)
    (jn= vector ($ (fx+ header/template 128)) %icall-wrong-nargs) 
%icall-ok
    (jr (d@r an 0))				;handler gives code address (tp - 2)
    (restore)
%icall-wrong-nargs
  (move S1 p)
  (store l p (d@nil slink/p))   ; operation
  (load l (d@nil slink/dispatch) P)
  (load l (d@r P (static icall-wrong-nargs)) P)
  (load l (d@r p 2) p)
  (load l (d@r P -2) extra)
  (jr (d@r extra 2))
  (restore)
default
  (move S3 A1)                         ; self is first arg of method
  (load l (d@r P offset/operation-default) P)
  (j= p nil-reg no-default)
  (load l (d@nil slink/icall) extra)
  (jr (d@r extra 0))
  (restore)
no-default    
  (move S1 p)   ; operation
  (store l p (d@nil slink/p))
  (load l (d@nil slink/dispatch) P)
  (load l (d@r P (static no-default-method)) P)
  (load l (d@r p 2) p)
  (load l (d@r P -2) extra)
  (jr (d@r extra 2))
  (restore)
dispatch
    (mask ($ 3) A1 vector)                 ; get object tag 
    (jn= vector ($ tag/extend) object-not-extend) ; is it an extend?
    (load l (d@r A1 -2) extra)                        ; get object's header
    (mask ($ 3) extra vector)                 ; is it a template?
    (jn= vector ($ tag/extend) object-not-closure)
    (load ub (d@r extra template/nargs) vector)
    (j= zero vector cit)         ; closure internal template?
    (load sw (d@r extra template/handler) vector)                       ; get handler offset
    (j= zero vector no-handler)                       ; it it's 0, no handler
    (add extra vector)
    (jr (d@r vector 0))                     ; call the handler
    (noop)
no-handler              
    (jr (d@r link-reg 0))
    (move nil-reg AN)
cit
    (load l (d@r extra 2) AN)                         ; get auxilliary template
    (load sw (d@r AN template/handler) vector)                       ; get handler offset
    (j= zero vector no-handler)
    (add an vector)
    (jr (d@r vector 0))
    (noop)
object-not-extend
    (load l (d@nil slink/dispatch) AN)         ; establish addressability
    (j= vector ($ tag/fixnum) fixnum)
    (j= vector ($ tag/pair) pair)
    (j= a1 ($ header/true) true)
    (mask ($ #xff) a1 vector)
    (j= vector ($ header/char) char)
    (j= vector ($ header/nonvalue) nonvalue)
    (load l (d@r AN (static handle-immediate)) A1)
    (load l(d@r a1 2) a1)
    (jbr dispatch)
true
    (load l (d@r AN (static handle-true)) A1)
    (load l (d@r a1 2) a1)
    (jbr dispatch)
nonvalue
    (load l (d@r AN (static handle-nonvalue)) A1)
    (load l (d@r a1 2) a1)
    (jbr dispatch)
fixnum   
    (load l (d@r AN (static handle-fixnum)) A1)
    (load l (d@r a1 2) a1)
    (jbr dispatch)
pair
    (load l (d@r AN (static handle-pair)) A1)
    (load l (d@r a1 2) a1)
    (jbr dispatch)
char
    (load l (d@r AN (static handle-char)) A1)
    (load l (d@r a1 2) a1)
    (jbr dispatch)
object-not-closure
    (j= vector zero frame-op)
    (load l (d@nil slink/dispatch) AN)
    (load l (d@r AN (static *handlers*)) AN)
    (load l (d@r an 2) an)
    (mask ($ #x7c) extra vector)                 ; isolate low seven bits
    (add an vector)
    (load l (d@r vector 2) a1)              ; index into vector of handlers
    (jbr dispatch)
frame-op
    (sub ($ 2) extra)			;coerce to template
    (load sw (d@r extra template/handler) vector)                       ; get handler offset
    (j= zero vector no-handler)                       ; it it's 0, no handler
    (add extra vector)
    (jr (d@r vector 0))                     ; call the handler
    (noop)
operation-handler
    (load l (d@r A1 offset/operation-handler) A1)
    (jbr dispatch)))

;;; At the top of the join loop the stack looks like    self                       
;;;                                                     next
;;;                                                     op
;;;                                                     obj
;;;                                               sp -> dispatch-return

(define *join-template*
  (lap-template (2 1 t heap join-handler)
join-template
    (load l (d@r P 2) P)                     ; joined lhs
    (load l (d@nil slink/icall) extra)
    (jr (d@r extra 0))
    (noop)
join-handler                                            
    (sub ($ 2) link-reg S4)		;save link as template
    (load l (d@r A1 6) S2)		; next <- rhs
    (load l (d@r A1 2) A1)		
    (move A1 S0)			; obj  <- lhs
    (jl dispatch)
    (add ($ template/return-offset) link-reg) ; try to get a handler from lhs
    (template 0 -1 t)
join-return
    (j= AN nil-reg join-miss)                      ; did we get a handler?
    (jr (d@r S4 2))
    (add ($ 2) S4 link-reg)		;restore link
join-miss
    (move S2 A1)                  ; get next
    (move A1 S0)                   ; obj <- next
    (move nil-reg S2) ; next <- tbsh
    (add ($ 2) S4 link-reg)		;restore link
    (jbr dispatch)))                 ; try rhs

 
(define *bogus-entity-template*
  (lap-template (2 1 t heap bogus-entity-handler)
    (load l (d@r P 2) P)
    (load l (d@nil slink/icall) extra)
    (jr (d@r extra 0))
    (noop)
bogus-entity-handler
    (move p S5)		;save p
    (move link-reg S6)			;save link
    (move A1 AN)			;temp
    (move P A1)                        ; operation is argument to handler
    (load l (d@r AN 6) p)               ; bogus-entity handler
    (load l (d@nil slink/icall) extra)
    (jalr (d@r extra 0))
    (add ($ template/return-offset) link-reg)
    (template 0 -3 nil)			;return method and args
    (jn= A1 nil-reg bogus-return-hit)
    (load l (d@nil slink/dispatch) AN)
    (move a2 a3)			;args
    (load l (d@r AN (static bogus-return-miss)) A1) ;A2 has dummy value
    (load l (d@r a1 2) a1)
    (load l (d@r AN (static apply)) P)
    (load l (d@r p 2) p)
    (load l (d@r P -2) extra)
    (jr (d@r extra 2))
    (move ($ 4) %i4)
bogus-return-hit
    (load l (d@nil slink/dispatch) AN)
    (move a2 a4)               ; args
    (move A1 A2)                       ; method
    (load l (d@r AN (static bogus-return)) A1)
    (load l (d@r a1 2) a1)
    (load l (d@r AN (static apply)) P)
    (load l (d@r p 2) p)
    (load l (d@r P -2) extra)
    (jr (d@r extra 2))
    (move ($ 5) %I4)      ; dummy obj in a3
bogus-return-handler
    (jr (d@r link-reg 0))
    (move nil-reg AN)))

(define (bogus-return-miss method  . args)
  (lap ()
    (move S5 p)
    (move S6 link-reg)
    (jr (d@r link-reg 0))
    (move nil-reg AN)))                  ; compiled handlers return register


(define (bogus-return method obj . args)
  (lap ()
    (move S6 link-reg)
    (move A1 P)                        ; method in procedure register
    (movea join-return A1)          ; is a join return address on top?
    (jn= a1 S6 bogus-dispatch-return)
    (add ($ 2) S4 link-reg)                      ; pop join return addr
bogus-dispatch-return
    (move S3 A1)              ; self is first of interpreted method
    (move S0  A2)              ; obj is second of interpreted method
    (load l (d@nil slink/icall) extra)
    (jr (d@r extra 0))
    (restore)))				;from dispatch




(dispatch-init)