(herald break (env tsys (osys hash)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define (make-broken-object proc id origin pred)
  (let ((id (or id (identification proc) proc))
        (broken-proc nil))
   (set broken-proc
    (join (object (lambda arglist
                    (cond ((apply pred arglist)
			   (format (debug-output) "Breaking ~s with arguments~_~s~%"
				   id arglist)
			   (receive return-break? 
			     (breakpoint nil (repl-env))
			     (cond ((null? return-break?)
				    (if (operation? proc)
					(apply-traced-operation broken-proc arglist)
					(apply proc arglist)))
				   (else
				    (receive vals 
				      (if (operation? proc)
					  (apply-traced-operation broken-proc arglist)
					  (apply proc arglist))
				      (format (debug-output) 
					      "Returning from ~s with values~_~s~%"
                                                id vals)
				      (breakpoint nil (repl-env))
				      (apply return vals))))))
                          (else
                           (apply proc arglist))))
                  ((get-loaded-file self) (get-loaded-file proc))  ;not a no-op!
                  ((broken-location self) origin)
                  ((broken-id self) id)
                  ((*unbreak self) proc)
                  ((broken? self) t)
                  ((print self port)
                   (format port "#{Broken~_~s~_~s}" (object-hash self) proc)))
          proc))
     broken-proc))

(define-operation (broken-location obj))
(define-operation (broken-id       obj))
(define-predicate broken?)

(define-operation (*break proc id origin pred)       ; operations handle
  (make-broken-object proc id origin pred))

(define-operation (*unbreak obj))

(define *broken-objects* (make-population '*broken-objects*))

(define (set-broken loc id pred)
  (let ((proc (contents loc)))
    (cond ((broken? proc)
           (format (debug-output) "~&~s already broken.~%" id))
          (else
           (let ((broken (*break (contents loc) id loc pred)))
             (add-to-population *broken-objects* broken)
             (set (contents loc) broken)
             (format (debug-output) "~&~s broken.~%" id))))
    repl-wont-print))

(define (set-unbroken loc)
  (let ((proc (contents loc)))
    (cond ((broken? proc)
           (remove-from-population *broken-objects* proc)
           (let ((probe (contents (broken-location proc))))
             (cond ((eq? probe proc)
                    (format (debug-output) "~&~s unbroken.~%"
                            (set (contents loc) (*unbreak proc))))
                   (else
                    (format (debug-output) "~&~s not unbreakable.~%" probe)))))
          (else
           (format (debug-output) "~&~s not broken.~%" proc)))
    repl-wont-print))

(define (display-broken-objects)
  (format (debug-output) "~&Broken:~%")
  (walk-population
   *broken-objects*
   (lambda (obj)
     (cond ((eq? obj (contents (broken-location obj)))
            (format (debug-output) "  ~s~%" (broken-id obj))))))
    repl-wont-print)

(define (unbreak-broken-objects)
  (walk-population
   *broken-objects*
   (lambda (obj)
     (set-unbroken (broken-location obj))
     (remove-from-population *broken-objects* obj)))
  repl-wont-print)

;;; "user interface"

(define-syntax (break . places)
  (cond ((null? places)
         '(display-broken-objects))
        (else
         (blockify (map (lambda (place)
                          `(set-broken (,(t-syntax 'locative) ,place)
                                       ',(if (symbol? place) place nil)
				       true))
                        places)))))

(define-syntax (unbreak . places)
  (cond ((null? places)
         '(unbreak-broken-objects))
        (else
         (blockify (map (lambda (place)
                          `(set-unbroken (,(t-syntax 'locative) ,place)))
                        places)))))

(define-syntax (break-if proc place)  
  `(set-broken (,(t-syntax 'locative) ,place)
	       ',(if (symbol? place) place nil)
	       ,proc))


