;Below is the procedure for compiling the primops.

;;; To compile system files that contain primops set *COMPILE-PRIMOPS?* to #F
;;; and ignore the "primops not compiled for this system" messages.


;; big-endian

(set-logical-name (local-fs) 'back_end "~kranz/risc/comp/back_end")
(set-logical-name (local-fs) 'front_end "~kranz/risc/comp/front_end")
(set-logical-name (local-fs) 't3_primops "~kranz/risc/comp/primops")
(set-logical-name (local-fs) 'link "~kranz/risc/link")
(set-logical-name (local-fs) 'osys "~kranz/risc/sys")

(define (orbit-mips-setup directory)
  (set *object-file-extension* 'mbo)
  (set *information-file-extension* 'mbi)
  (set *noise-file-extension* 'mbn)
  (orbit-setup directory)
  (set (table-entry *modules* 'constants) `(,directory mipsconstants))
  (set (table-entry *modules* 'primops)   `(,directory mipsprimops))
  (set (table-entry *modules* 'arith)     `(,directory mipsarith))
  (set (table-entry *modules* 'low)       `(,directory mipslow))
  (set (table-entry *modules* 'genarith)     `(,directory mipsgenarith))
  nil)

(define (orbit-mips-init . directory)
  (orbit-mips-setup (if directory (car directory) '#f))
  (orbit-init 'base
              'constants
              'primops
	      'arith
              'locations
              'low
	      'predicates
              'open
              'aliases
              'carcdr
              'genarith))

(lset *endian* 'big)
(orbit-mips-setup 't3_Primops)
(create-support '(t3_Primops mipsconstants) '(t3_Primops mipsconstants))
(load '(t3_Primops mipsconstants t) orbit-env)
(orbit-init 'base)
(set (orbit-syntax-table) primop-syntax-table)
(set *compile-primops?* nil)
(create-support '(t3_Primops mipsprimops)   '(t3_Primops mipsprimops))
(create-support '(t3_Primops mipsarith)     '(t3_Primops mipsarith))
(create-support '(t3_Primops locations)    '(t3_Primops locations))
(create-support '(t3_Primops mipslow)       '(t3_Primops mipslow))
(create-support '(t3_Primops predicates)       '(t3_Primops predicates))
(orbit-init 'base  
            'constants 'primops 'arith 'locations 'low 'predicates)
(create-support '(t3_Primops open)    '(t3_Primops open))
(create-support '(t3_Primops aliases) '(t3_Primops aliases))
(create-support '(t3_Primops carcdr)  '(t3_Primops carcdr))
(create-support '(t3_Primops mipsgenarith)  '(t3_Primops mipsgenarith))


;;; Ready to COMFILE the MIPS files.


;;; To compile the primop code in the VINF files, run the following in an
;;; Orbit for the machine on which you want to use the MINF.
;;; WARNING: if you COMFILE the MIPS primop files in the same directory you
;;; will clobber the compiled versions of the VINF files.
(compile-primop-source '(t3_Primops mipsprimops   mbi))
(compile-primop-source '(t3_Primops mipsarith     mbi))
(compile-primop-source '(t3_Primops locations    mbi))
(compile-primop-source '(t3_Primops mipslow       mbi))
(combile-primop-source '(t3_Primops mipsgenarith    mbi))


;;; little-endian


(set-logical-name (local-fs) 'back_end "~kranz/risc/comp/back_end")
(set-logical-name (local-fs) 'front_end "~kranz/risc/comp/front_end")
(set-logical-name (local-fs) 't3_primops "~kranz/risc/comp/primops")
(set-logical-name (local-fs) 'link "~kranz/risc/link")
(set-logical-name (local-fs) 'osys "~kranz/risc/sys")

(define (orbit-mips-setup directory)
  (set *object-file-extension* 'mlo)
  (set *information-file-extension* 'mli)
  (set *noise-file-extension* 'mln)
  (orbit-setup directory)
  (set (table-entry *modules* 'constants) `(,directory mipsconstants))
  (set (table-entry *modules* 'primops)   `(,directory mipsprimops))
  (set (table-entry *modules* 'arith)     `(,directory mipsarith))
  (set (table-entry *modules* 'low)       `(,directory mipslow))
  (set (table-entry *modules* 'genarith)     `(,directory mipsgenarith))
  nil)

(define (orbit-mips-init . directory)
  (orbit-mips-setup (if directory (car directory) '#f))
  (orbit-init 'base
              'constants
              'primops
	      'arith
              'locations
              'low
	      'predicates
              'open
              'aliases
              'carcdr
              'genarith))

(lset *endian* 'little)
(orbit-mips-setup 't3_Primops)
(create-support '(t3_Primops mipsconstants) '(t3_Primops mipsconstants))
(load '(t3_Primops mipsconstants t) orbit-env)
(orbit-init 'base)
(set (orbit-syntax-table) primop-syntax-table)
(set *compile-primops?* nil)
(create-support '(t3_Primops mipsprimops)   '(t3_Primops mipsprimops))
(create-support '(t3_Primops mipsarith)     '(t3_Primops mipsarith))
(create-support '(t3_Primops locations)    '(t3_Primops locations))
(create-support '(t3_Primops mipslow)       '(t3_Primops mipslow))
(create-support '(t3_Primops predicates)       '(t3_Primops predicates))
(orbit-init 'base  
            'constants 'primops 'arith 'locations 'low 'predicates)
(create-support '(t3_Primops open)    '(t3_Primops open))
(create-support '(t3_Primops aliases) '(t3_Primops aliases))
(create-support '(t3_Primops carcdr)  '(t3_Primops carcdr))
(create-support '(t3_Primops mipsgenarith)  '(t3_Primops mipsgenarith))


;;; Ready to COMFILE the MIPS files.


;;; To compile the primop code in the VINF files, run the following in an
;;; Orbit for the machine on which you want to use the MINF.
;;; WARNING: if you COMFILE the MIPS primop files in the same directory you
;;; will clobber the compiled versions of the VINF files.
(compile-primop-source '(t3_Primops mipsprimops   mli))
(compile-primop-source '(t3_Primops mipsarith     mli))
(compile-primop-source '(t3_Primops locations    mli))
(compile-primop-source '(t3_Primops mipslow       mli))
(compile-primop-source '(t3_Primops mipsgenarith    mli))


(set-logical-name (local-fs) 'back_end "~kranz/risc/comp/back_end")
(set-logical-name (local-fs) 'front_end "~kranz/risc/comp/front_end")
(set-logical-name (local-fs) 't3_primops "~kranz/risc/comp/primops")
(set-logical-name (local-fs) 'link "~kranz/risc/link")
(set-logical-name (local-fs) 'osys "~kranz/risc/sys")

(define (orbit-mips-setup directory)
  (set *object-file-extension* 'mbo)
  (set *information-file-extension* 'mbi)
  (set *noise-file-extension* 'mbn)
  (orbit-setup directory)
  (set (table-entry *modules* 'constants) `(,directory mipsconstants))
  (set (table-entry *modules* 'primops)   `(,directory mipsprimops))
  (set (table-entry *modules* 'arith)     `(,directory mipsarith))
  (set (table-entry *modules* 'low)       `(,directory mipslow))
  (set (table-entry *modules* 'genarith)     `(,directory mipsgenarith))
  nil)

(define (orbit-mips-init . directory)
  (orbit-mips-setup (if directory (car directory) '#f))
  (orbit-init 'base
              'constants
              'primops
	      'arith
              'locations
              'low
	      'predicates
              'open
              'aliases
              'carcdr
              'genarith))

(lset *endian* 'big)
(orbit-sparc-setup 't3_Primops)
(create-support '(t3_Primops spconstants) '(t3_Primops spconstants))
(load '(t3_Primops spconstants t) orbit-env)
(orbit-init 'base)
(set (orbit-syntax-table) primop-syntax-table)
(set *compile-primops?* nil)
(create-support '(t3_Primops spprimops)   '(t3_Primops spprimops))
(create-support '(t3_Primops sparith)     '(t3_Primops sparith))
(create-support '(t3_Primops locations)    '(t3_Primops locations))
(create-support '(t3_Primops splow)       '(t3_Primops splow))
(create-support '(t3_Primops predicates)       '(t3_Primops predicates))
(orbit-init 'base  
            'constants 'primops 'arith 'locations 'low 'predicates)
(create-support '(t3_Primops open)    '(t3_Primops open))
(create-support '(t3_Primops aliases) '(t3_Primops aliases))
(create-support '(t3_Primops carcdr)  '(t3_Primops carcdr))
(create-support '(t3_Primops spgenarith)  '(t3_Primops spgenarith))

(compile-primop-source '(t3_Primops spprimops   si))
(compile-primop-source '(t3_Primops sparith     si))
(compile-primop-source '(t3_Primops locations    si))
(compile-primop-source '(t3_Primops splow       si))
(compile-primop-source '(t3_Primops spgenarith    si))
