(herald sunbuild)
#|

To build a new system from sources:

1. You should be in a directory with sources and tsystem as subdirectories
   Execute the shell script in tsystem/envset
2. Start up tsystem/xt and load this file into orbit-env
3. (compile-support) and (exit)
4. Start up tsystem/xt again and load this file into orbit-env
5. (compile-sources) and (link-t '(tsystem new)) and (exit)
6. cd tsystem; linkt new.o new; cd ..
7. tsystem/new is a T without compiler. Start up new with a large heap.
8. ((*value t-implementation-env 'load-and-suspend-system) '(tsystem new) t)
   (exit)
9. cd tsystem; linkt new.o new    That's it.

|#

;;; Build compiler early binding environment

(lset *endian* 'little)

(*define user-env 'compile-support
(lambda ()
(create-support '(t3_primops mipsconstants) '(t3_primops mipsconstants))
(load '(t3_primops mipsconstants t) orbit-env)
(orbit-mips-setup 't3_primops)
(orbit-init 'base)
(set (orbit-syntax-table) primop-syntax-table)
(set *compile-primops?* nil)
(create-support '(t3_primops mipsprimops)   '(t3_primops mipsprimops))
(create-support '(t3_primops mipsarith)     '(t3_primops mipsarith))
(create-support '(t3_primops locations)    '(t3_primops locations))
(create-support '(t3_primops mipslow)       '(t3_primops mipslow))
(create-support '(t3_primops predicates)       '(t3_primops predicates))
(orbit-init 'base  
            'constants 'primops 'arith 'locations 'low 'predicates)
(create-support '(t3_primops open)    '(t3_primops open))
(create-support '(t3_primops aliases) '(t3_primops aliases))
(create-support '(t3_primops carcdr)  '(t3_primops carcdr))
(create-support '(t3_primops mipsgenarith)  '(t3_primops mipsgenarith))))

;;; compile compiler code in early binding environment, runtime system

(*define user-env 'compile-sources
(lambda ()
(set (orbit-syntax-table) primop-syntax-table)
(comfile '(t3_primops base))
(compile-primop-source '(t3_primops mipsprimops   mli))
(compile-primop-source '(t3_primops mipsarith     mli))
(compile-primop-source '(t3_primops locations    mli))
(compile-primop-source '(t3_primops mipslow       mli))
(compile-primop-source '(t3_primops mipsgenarith    mli))
(set *compile-primops?* nil)
(set (table-entry *modules* 'bignum) '(osys risc_bignum))
(load-quietly '(t3_primops mipsconstants t) orbit-env)
(set (orbit-syntax-table) (env-syntax-table t-implementation-env))
(orbit-mips-init 't3_primops)
(set primop/computed-goto (table-entry primop-table 'computed-goto))
(define (comsys system . start)
  (walk (lambda (file)
	  (xcase (car file)
            ((osys)
	     (set (tc-syntax-table) (env-syntax-table t-implementation-env))
	     (comfile file))
	    ((t3_primops)
	     (set (tc-syntax-table) primop-syntax-table)
	     (bind ((write-support-file false))
	       (comfile file)))))
	(let ((files (xcase system
		       ((z) *zvm-system*)
		       ((t) *t-system*))))
	  (if start (mem alikev? (car start) files) files))))
(load '(osys pmax_files) orbit-env)
(comsys 't)
(comfile '(link defs))
(comfile '(link linker))
(comfile '(link pmax_link))
(comfile '(link lp_table))
(comfile '(link suspend))
(comfile '(link pmaxsuspend))
(comfile '(tscheme scheme))
(comfile '(tscheme syntax))
(comfile '(tscheme system))
(comfile '(tscheme runtime))
(comfile '(tscheme compiler))
(set (tc-syntax-table) (env-syntax-table orbit-env))
(comfile '(front_end pmaxfix))
(walk comfile
      (append *orbit-files*
	      *top-files*
	      *front-files*
	      '((front_end computed_goto))
	      *back-end-files*
	      *orbit-mips-files*
	      *tas-mips-files*))))


(define (load-linker . system)
  (let* ((system (if (null? system) 
                     ((*value t-implementation-env 'machine-type) 
                      ((*value t-implementation-env 'local-machine)))
                     (car system)))
         (link-env (make-locale orbit-env 'link-env)))
    (*define standard-env 'link-env link-env)
    (load '(link defs )         link-env)
    (load '(link linker )       link-env)
    (load 
     '(link pmax_link)
     link-env)
    (load '(t3_primops mipsconstants t)  link-env)
    (*define standard-env  'link
	     (lambda (files outfile)
	       (set (repl-results) nil)
	       (gc)
	       ((*value link-env 'link) files outfile)))))

(*define user-env 'link-t
(lambda (file)
(load-linker)
(load '(osys pmax_files) orbit-env)
(link *t-system* file)))


