(herald (back_end lookkup)
  (env t (orbit_top defs) (back_end closure) (back_end bookkeep)))

(define (all-important-refs-are-calls? var)
  (every? (lambda (ref)
	    (or (eq? (node-role ref) call-proc)
		(and (eq? (node-role ref) (call-arg 2))
		     (let ((call (node-parent ref)))
		       (or (primop-ref? (call-proc call) primop/*define)
			   (primop-ref? (call-proc call) primop/*lset))))))
	  (variable-refs var)))

(define (var-is-vcell? var)
  (and (not (all-important-refs-are-calls? var))
       (neq? var *the-environment*)))

;;; ACCESS-VALUE This is the primary routine to get addressability to values.
;;; Just a giant case statement.


(define (lookup-value node value)
  (cond ((and (variable? value)
	      (not (variable-binder value))
	      (var-is-vcell? value))
	 (let ((acc (lookup node (get-lvalue value) nil)))
	   (let ((reg (get-register node)))
	     (generate-move acc reg)
	     (reg-offset reg tag/extend))))
	(else
	 (really-access-value node value))))

(define (really-access-value node value)               
 (let ((value (cond ((and (variable? value) (variable-known value))
                     => lambda-self-var)
                    (else value))))
  (cond ((register-loc value)
         => (lambda (spec)
              (cond ((fixnum? spec) spec)
		    (else (error "Register loc not a fixnum ~s" value)))))
        ((temp-loc value))
        ((variable? value)
         (let ((binder (variable-binder value)))
           (cond ((not binder)
                  (lookup node value nil))
                 ((and (fx= (variable-number value) 0) 
                       (assq binder (closure-env *unit*)))
                  (lookup node binder nil))
                 (else
                  (lookup node value binder)))))
        ((primop? value)
         (if (eq? value primop/undefined)
             zero
             (lookup node value nil)))
        ((eq? value '#T)
         (machine-true-value))
        ((or (eq? value '#F) (eq? value '()))
          nil-reg)
        ((addressable? value)
         (reference-addressable node value))
        (else
         (lookup node value nil)))))


;;; LOOKUP If the value is a known procedure, if it is in the unit we get it
;;; from there, otherwise we get the variable which the known procedure is
;;; bound to.

(define (lookup node value lambda-bound?)
  (xselect (lambda-strategy *heap-env*)
    ((strategy/heap)
     (let ((contour (lambda-self-var *heap-env*)))
       (->register node contour)
       (fetch-from-heap node contour value lambda-bound?)))))


                                
(define (get-env var)
  (lambda-env (variable-binder var)))
                                      

(define (fetch-from-stack node value lambda-bound?) (error " Fetch from stack"))


(define (closure-internal-closure? value closure)
  (cond ((neq? closure *unit*)
         (memq? value (closure-members closure)))
        (else
         (or (and (node? value) (lambda-node? value))
             (closure? value)))))

(define (fetch-from-heap node contour value lambda-bound?) 
  (iterate loop ((env (get-env contour)) (contour contour)) 
    (let* ((closure (environment-closure env))
	   (a-list (closure-env closure))
	   (current-offset (environment-cic-offset env)))
      (cond ((assq value a-list)
             => (lambda (pair)
                  (if (closure-internal-closure? value closure)
                      (list (reg-offset (register-loc contour)  ; *** hack
                                        (fx- (cdr pair) current-offset)))
                      (reg-offset (register-loc contour)
                                  (fx- (cdr pair)
                                       (fx+ current-offset tag/extend))))))
            ((and (not lambda-bound?) (closure-cit-offset closure))
	     => (lambda (up)
		  (into-register node up
		     (reg-offset (register-loc contour)
               (fx- (fx- (cdr (assq up a-list)) current-offset) tag/extend)))
		  (loop (get-env up) up)))
            ((neq? closure *unit*)
             (into-register node (caadr a-list)
                (reg-offset  (register-loc contour)
                             (fx+ (fx- 0 current-offset) tag/extend)))
             (loop (get-env (caadr a-list)) (caadr a-list)))
            (else
             (bug "Couldn't find ~s~% in call ~s"
                  value
                  (pp-cps node)))))))




