(herald spas)

(define maybe-pushfr 'maybe-pushfr)
(define maybe-popfr 'maybe-popfr)

(define (emit-jump 1tag)
  (cond ((and (node? 1tag)
	      (lambda-node? 1tag)
	      (eq? (lambda-strategy 1tag) strategy/heap))
	 (push (ib-instructions *current-ib*)
	       (list jbr-inst nil jump-op/jabs
		     (cons 'template (maybe-cons-an-ib 1tag))))
	 (push (ib-instructions *current-ib*)
	       (list sparc/noop nil)))
	(else
	 (set (ib-cc *current-ib*) jump-op/jabs)
	 (let ((1next (maybe-cons-an-ib 1tag)))
	   (set (ib-1next *current-ib*) 1next)
	   (push (ib-previous 1next) *current-ib*)))))

(define (emit-branch-and-link l)
  (push (ib-instructions *current-ib*)
	(list jbr-inst nil jump-op/jl
	      (cond ((fixnum? l) l)
		    ((and (node? l) (eq? (lambda-strategy l) strategy/heap))
		     (cons 'template (maybe-cons-an-ib l)))
		    (else
		     (cons 'label (maybe-cons-an-ib l)))))))

(define (emit-branch l)
  (push (ib-instructions *current-ib*)
	(list jbr-inst nil jump-op/jabs
	      (cons 'label (maybe-cons-an-ib l)))))

(define (emit-avoid-jump 1tag)
  (set (ib-avoid-jump? *current-ib*) '#t)
  (emit-jump 1tag))

(define (emit-compare cc reg1 reg2 1tag 0tag)
  (emit risc/sub reg2 reg1 zero)
    (set (ib-cc *current-ib*) cc)
    (let ((1next (maybe-cons-an-ib 1tag)))
      (set (ib-1next *current-ib*) 1next)
      (push (ib-previous 1next) *current-ib*))
    (and 0tag
	 (let ((0next (maybe-cons-an-ib 0tag)))
	   (set (ib-0next *current-ib*) 0next)
	   (push (ib-previous 0next) *current-ib*))))


(define (assembly-list is bv)
  (do ((is is (cdr is))
       (i 0 (fx+ i CELL)))
      ((null? is) repl-wont-print)
    (format t "~&~d:~8t" i)
    (write-i-bytes bv i)
    (destructure (((op comment . args) (car is)))
      (format t "~20t~a~40t" (apply instruction-as-string op i args))
      (if comment
	  (apply format t (car comment) (cdr comment))))))

(define (assemble-bits size is)
  (let ((code (make-bytev size)))
    (set *is* is)
    (set *bits* code)
    (do ((is is (cdr is))
	 (i 0 (fx+ i CELL)))
	((null? is)
	 (format *noise+terminal* "~&; assembled ~d bytes~%" size)
	 code)
      (destructure (((op comment . args) (car is)))
	(apply op code i args)))))


(define (add-to-front block)
  (cond ((or (not block) (ib-address block)))
	((fx> (length (ib-previous block)) 1)
	 (push *blocks-pending* block))
	(else
	 (modify *blocks-pending* (lambda (x) (append! x (list block)))))))


(define (linearize-code-blocks i is)
  (if (null? *blocks-pending*)
      (return i is)
      (let ((ib (pop *blocks-pending*)))
	(cond ((ib-address ib) (linearize-code-blocks i is))
	      (else
	(set (ib-address ib) i) 
	(iterate loop ((i i) (ib ib) (newis (ib-instructions ib)) (is is))
	  (cond ((null? newis)
		 (let ((0next (ib-0next ib))
		       (1next (ib-1next ib)))
		   (cond ((not 0next) 
			  (cond ((null? 1next)
				 (linearize-code-blocks i is))
				((and (not (ib-avoid-jump? ib))
				      (any? ib-avoid-jump?
					    (ib-previous 1next))
				      (not (ib-address 1next)))
				 (add-to-front (ib-0next 1next))
				 (add-to-front (ib-1next 1next))
				 (add-jump-no-return 1next i is))
				((not (ib-address 1next))
				 (set (ib-address 1next) i)
				 (loop i 1next (ib-instructions 1next) is))
				(else
				 (add-jump-no-return 1next i is))))
			 ((not (ib-address 1next))
			  (add-to-front 0next)
			  (modify (ib-cc ib) reverse-branch)
			  (receive (i is) (add-jump 0next i is (ib-cc ib))
			    (set (ib-address 1next) i)
			    (loop i 1next (ib-instructions 1next) is)))
			 ((not (ib-address 0next))
			  (receive (i is) (add-jump 1next i is (ib-cc ib))
			    (set (ib-address 0next) i)
                            (loop i 0next (ib-instructions 0next) is)))
			 ((preferred-arm? 0next 1next)
			  (modify (ib-cc ib) reverse-branch)
			  (receive (i is) (add-jump 0next i is (ib-cc ib))
			    (add-jump-no-return 1next i is)))
			 (else
			  (receive (i is) (add-jump 1next i is (ib-cc ib))
			    (add-jump-no-return 0next i is))))))
		(else
		 (let ((inst (caar newis)))
  		 (select inst
		   ((maybe-pushfr)
		    (receive (is incr)
		             (figure-pushfr is (lambda-max-temps (caddr (car newis))))
		      (loop (fx+ i incr) ib (cdr newis) is)))
		   ((maybe-popfr)
		    (receive (is incr)
		             (figure-popfr is (lambda-max-temps (caddr (car newis))))
		      (loop (fx+ i incr) ib (cdr newis) is)))
		   (else
		    (loop (fx+ i CELL) ib (cdr newis) (cons (car newis) is)))))))))))))


(define (preferred-arm? ib1 ib2)
  (let ((node1 (ib-node ib1))
	(node2 (ib-node ib2)))
    (and (node? node1)
	 (node? node2)
	 (fx< (lambda-trace node1) (lambda-trace node2)))))
    

(define (reverse-branch cc)
  (select cc
    ((jump-op/jabs jump-op/jl) cc)
    (else (- cc))))

#|
(define (figure-pushfr is n)
  (cond ((fx= n 0) (return is 0))
	((fx< n *real-registers*)
	 (return
	  `((,sparc/save () (lit . -64) ,SP ,SP)
	    ,@is)
	  CELL))
	(else
	 (let ((bump (* (fx+ (fx- n *real-registers*) 1) 4)))
	   (return 
	    `((,sparc/save () (lit . ,(- (+ bump 64))) ,SP ,SP)
	    ,@is)
	    CELL)))))

(define (figure-popfr is n)
  (cond ((fx= n 0) (return is 0))
	(else
	 (return
	  `((,sparc/restore () ,zero ,zero ,zero)
	    ,@is)
	  CELL))))
|#
(define (add-jump-no-return next i is)
  (receive (i is) (add-jump next i is jump-op/jabs)
    (linearize-code-blocks i is)))

#|
(define (add-jump next i is cc)
  (return (fx+ i (fx* CELL 2))
	  (cons noop-inst
		(cons (list jbr-inst nil cc (cons 'label next)) is))))

(define (need-to-delay? #f #f) '#t)

|#

(define (add-jump next i is cc)
  (let ((insts (ib-instructions next)))
    (cond ((or (null? insts)
	       (fx= cc jump-op/jl)
	       (branch-instruction? (car insts)))
	   (return (fx+ i (fx* CELL 2))
		   (cons noop-inst 
			 (cons (list jbr-inst nil cc (cons 'label next))
			       is))))
	  ((fx= cc jump-op/jabs)
	   (return (fx+ i (fx* CELL 2))
		   (cons (car insts) 
			 (cons (list jbr-inst nil cc (cons 'label+1 next))
			       is))))
	  (else
	   (return (fx+ i (fx* CELL 2))
		   (cons (car insts) 
			 (cons (list jbr-a-inst nil cc (cons 'label+1 next))
			       is)))))))

(define (branch-instruction? x)
  (or (eq? (car x) sparc/jmpl)
      (eq? (car x) jbr-inst)
      (eq? (car x) jbr-a-inst)
      (eq? (car x) maybe-popfr)
      (eq? (car x) maybe-pushfr)))

(define (figure-pushfr is n)
  (cond ((fx= n 0) (return is 0))
	((fx= n 1)
	 (return
	  `((,risc/store () l ,LINK-REG (reg-offset ,SP 0))
	    (,risc/add () (lit . -4) ,SP ,SP)
	    ,@is)
	  (fx* CELL 2)))
	(else
	 (let ((bump (* (fx+ (fx- n *real-registers*) 2) 4)))
	   (return 
	    `((,risc/store () l ,LINK-REG (reg-offset ,SP ,(fx- bump 4)))
	      (,risc/add () (lit . ,(- bump)) ,SP ,SP)
	    ,@is)
	    (fx* CELL 2))))))

(define (figure-popfr is n)
  (cond ((fx= n 0) (return is 0))
	((fx= n 1)
	 (return
	  `((,risc/add () (lit . 4) ,SP ,SP)
	    (,risc/load () l (reg-offset ,SP 0) ,LINK-REG)
	    ,@is)
	  (fx* CELL 2)))
	(else
	 (let ((bump (* (fx+ (fx- n *real-registers*) 2) 4)))
	   (return
	    `((,risc/add () (lit . ,bump) ,SP ,SP)
	      (,risc/load () l (reg-offset ,SP ,(fx- bump 4)) ,LINK-REG)
	    ,@is)
	  (fx* CELL 2))))))

	

