(herald test (env tsys))

(define-structure-type lstate   ;linker state
    pure            
    impure          
    foreign-reloc   
    foreign                     
    symbols                        
    symbol-count
    text-reloc   ;List of relocation items
    data-reloc
    pure-size
    reloc 
    null
    )

(define-structure-type +area         ;A.k.a. "heap"
  frontier      ;Address of next available cell
  objects       ;List of objects allocated
  )

(define (vgc-extend obj ptrs size)
  (let* ((heap (lstate-impure *lstate*))
         (addr (+area-frontier heap))
         (desc 
           (if (fx= ptrs size)
               (object nil
                 ((heap-stored self) (lstate-impure *lstate*))
                 ((heap-offset self) addr)
                 ((write-descriptor self stream)
                  (write-data stream (fx+ addr tag/extend)))
                 ((write-store self stream)
                  (do ((i -1 (fx+ i 1)))
                      ((fx= i ptrs) t)
                    (write-slot (extend-elt obj i) stream))))
               (object nil
                 ((heap-stored self) (lstate-impure *lstate*))
                 ((heap-offset self) addr)
                 ((write-descriptor self stream)
                  (write-data stream (fx+ addr tag/extend)))
                 ((write-store self stream)
                  (do ((i -1 (fx+ i 1)))
                      ((fx= i ptrs)
                       (do ((i i (fx+ i 1)))
                           ((fx= i size) t)
                         (write-scratch stream obj i)))
                    (write-slot (extend-elt obj i) stream)))))))
      (set (+area-frontier heap) (fx+ addr (fx+ (fx* CELL size) CELL)))
      (push (+area-objects heap) desc)
      (set-lp-table-entry (lstate-reloc *lstate*) obj desc)
      (do ((i -1 (fx+ i 1))
           (a addr (fx+ a CELL)))
          ((fx= i ptrs) desc)
        (generate-slot-relocation (extend-elt obj i) a))))