(herald test (env tsys))


(define (continuation-throw sp stack vals k-state base-state)
  (cond ((stack? stack)
         (let ((a (swap *the-current-throw-value* vals))
               (b (swap *the-current-throw-frame* stack)))
           (unwind-to-top)
           (set *the-current-throw-frame* b)
           (set *the-current-throw-value* a)
           (set (process-global task/dynamic-state) k-state)
           (invoke-continuation sp stack vals base-state k-state)))
        (else
         (error "throwing ~s to bad continuation ~s" vals stack))))
                                  
                             
(define (unwind-to-top)
  (iterate loop ((state (process-global task/dynamic-state)))
    (cond ((eq? state nil))
          ((eq? (state-winder state) false)
	   (loop (state-previous state)))
          (else
           (perform-unwind state)
           (loop (state-previous state))))))