(herald m68fix)

(define (emit-hacked-branch jump-op displ)
  (%emit m68/hack-jbcc (jump-op->m68-cc jump-op) displ))

(define (generate-remove-state-object node)
  (let ((cont (car (call-args node))))
    (if (and (lambda-node? cont)
	     (not (lambda-rest-var cont))
	     (variable-refs (lambda-cont-var cont)))
	(receive (t-spec t-rep) (continuation-wants cont)
	  (let ((dest (get-target-register node t-spec)))
	    (emit m68/move .l (reg-offset sp 4) dest)
	    (mark-continuation node dest)))))
  (or (not (method-lambda (node-parent node)))
      (emit m68/add .w ($ 20) sp)))

(define (generate-move-address from to)
  (cond ((register? to)
         (if (or (atom? from)
                 (neq? (car from) to)
                 (neq? (cdr from) 0))
             (emit m68/lea from to)))
        ((locked? AN)
         (emit m68/pea from)
         (generate-pop to))
        (else
         (emit m68/lea from AN)
         (emit m68/move .l AN to))))

(define-integrable (generate-slink-jump offset)
  (emit m68/jsr (*d@nil offset)))

(define (generate-return n-args)               
  (emit m68/move .l (machine-num (fx- -1 n-args)) NARGS)
  (emit m68/move .l (@r 15) TP)
  (emit m68/jmp (@r 13)))

(define (generate-return-without-nargs)
  (emit m68/move .l (@r 15) TP)
  (emit m68/jmp (@r 13)))


(define (generate-general-call proc-var n-args)
  (emit m68/move .l  (machine-num (fx+ n-args 1)) NARGS)
  (cond ((and (or (variable-binder proc-var)
		  (var-is-vcell? proc-var)))
	 (emit m68/jmp (*d@nil slink/icall)))
	(else
         (emit m68/move .l (reg-offset P -2) TP)
         (emit m68/jmp (@r 13)))))


(define (generate-extend node n)
  (free-register node S1)
  (free-register node S2)
  (generate-move (machine-num (fx- n CELL)) S1)   ;; don't include template
  (let ((reg (get-register 'pointer node '*)))
    (generate-slink-jump slink/make-extend)
    reg))

(define (rep-analyze-top node)
  (rep-analyze ((call-arg 1) (lambda-body node)))
  (rep-analyze ((call-arg 1) (lambda-body node))))

(define (rep-analyze node)
  (cond ((lambda-node? node)
         (rep-analyze-call (lambda-body node))
         (select (lambda-strategy node)
           ((strategy/label strategy/open) 
            (walk (lambda (var)
                    (or (eq? (variable-type var) type/top)
                        (neq? (variable-rep var) 'rep/pointer)
                        (set (variable-rep var) (most-important-rep var))))
                  (if (continuation? node)
                      (lambda-variables node)
                      (cdr (lambda-variables node)))))))))


(define (rep-analyze-call node)
  (let ((proc (call-proc node)))
    (cond ((lambda-node? proc)
           (walk rep-analyze (call-args node))
           (rep-analyze-call (lambda-body proc)))
	  ((not (primop-node? proc))
           (walk rep-analyze (call-args node)))
          ((eq? (primop-value proc) primop/Y)
           (rep-analyze ((call-arg 1) node))
           (destructure (((body . procs) 
                          (call-args (lambda-body ((call-arg 2) node)))))
             (walk rep-analyze procs)
             (rep-analyze body)))
          (else
	   (walk rep-analyze (call-args node))
	   (cond ((and (eq? (primop-value proc) primop/contents-location)
		       (lambda-node? ((call-arg 1) node))
		       (eq? (variable-rep (lambda-cont-var ((call-arg 1) node)))
			    'rep/pointer))
		  (set (variable-rep (lambda-cont-var ((call-arg 1) node)))
		       (primop.rep-wants (leaf-value ((call-arg 2) node))))))))))



(define (most-important-rep var)
  (iterate loop ((refs (variable-refs var)) (reps '()))
    (cond ((null? refs) 
           (select-rep (reverse! reps) (variable-type var)))
          (else
           (let* ((parent (node-parent (car refs)))
                  (proc (call-proc parent))
                  (number (call-arg-number (node-role (car refs)))))
             (cond ((primop-node? proc)
                    (cond ((primop.rep-wants (primop-value proc))
                           => (lambda (creps)
				(let ((rep 
				       (nth creps (fx- (fx- number
                                                    (call-exits parent))
							     1))))
				  (if (neq? rep '*)
				      (loop (cdr refs) (cons rep reps))
				      (let ((cont ((call-arg 1) parent)))
					(loop (cdr refs)
					      (if (leaf-node? cont)
						  (cons 'rep/pointer reps)
						  (let ((rep (variable-rep
							 (lambda-cont-var cont))))
					    (cons (if (eq? (rep-size rep) 4)
						      rep
						      'rep/integer)
						  reps)))))))))
                          ((eq? (primop-value proc) primop/contents-location)
			   (loop (cdr refs)
				 (cons
                           (if (and (fx= number 4) 
                                    (fx< (rep-size (primop.rep-wants
                                             (leaf-value ((call-arg 2) parent))))
                                          size/long))
                               'rep/integer 'rep/pointer)
			   reps)))
                          ((eq? (primop-value proc) primop/set-location)
			   (loop (cdr refs)
				 (cons 
                           (cond ((and (fx= number 5)
                                       (fx< (rep-size (primop.rep-wants
                                               (leaf-value ((call-arg 2) parent))))
                                            size/long))
                                  'rep/integer)
                                 ((fx= number 3)
                                  (primop.rep-wants 
                                      (leaf-value ((call-arg 2) parent))))
                                 (else 'rep/pointer))
			   reps)))
                          (else 
                           (loop (cdr refs) reps))))
                   ((variable-known (leaf-value proc)) 
                    => (lambda (label)
                         (cond ((lambda-rest-var label) 
                                (loop (cdr refs) reps))
                               (else
				(loop (cdr refs)
				      (cons (variable-rep (nth (lambda-variables label)
							       (fx- number 1)))
					    reps))))))
                   (else
                    (loop (cdr refs) (cons 'rep/pointer reps)))))))))

(define (select-rep reps type)
  (cond ((null? reps)
	 'rep/pointer)
	((eq? type type/char)
	 (car reps))
	(else
	 (let ((size (rep-size (car reps))))
	   (iterate loop ((r (cdr reps)))
	     (cond ((null? r) (car reps))
		   ((fx= (rep-size (car r)) size)
		    (loop (cdr r)))
		   (else
		    (car (sort-list! reps (lambda (x y)
					    (fx> (rep-size x) (rep-size y))))))))))))




