(herald vorbit_changes)

(set (print-env-warnings?) nil)
(set *compile-primops?* nil)
(set (table-entry *modules* 'bignum) '(osys m68_bignum))
(load-quietly '(t3_primops mconstants t))
(set (orbit-syntax-table) (env-syntax-table t-implementation-env))
(comment
(walk load '((assembler expand)
                (assembler fg_spec)  
             (assembler fg_expr)  
          (assembler as_syntax)))
)


  (load '(back_end aem68gen) orbit-env)



(define (comsys system . start)
  (walk (lambda (file)
	  (xcase (car file)
            ((osys)
	     (set (tc-syntax-table) (env-syntax-table t-implementation-env))
	     (comfile file))
	    ((t3_primops)
	     (set (tc-syntax-table) primop-syntax-table)
	     (bind ((write-support-file false))
	       (comfile file)))))
	(let ((files (xcase system
		       ((z) *zvm-system*)
		       ((t) *t-system*))))
	  (if start (mem alikev? (car start) files) files))))
	
(set (print-env-warnings?) t)

(eval '(block

(define-syntax (define-enumerated type-name . types)
  (ignore type-name)
  (do ((i 0 (fx+ i 1))
       (l types (cdr l))
       (z '() (cons `(define-constant ,(car l) ,i) z)))
      ((null? l)
       `(block ,@(reverse! z)))))

(define-syntax (define-set-of type-name . types)
  (ignore type-name)
  (do ((i 1 (fixnum-ashl i 1))
       (l types (cdr l))
       (z '() (cons `(define-constant ,(car l) ,i) z)))
      ((null? l)
       `(block ,@(reverse! z)))))

(define-syntax (set-of . types)
  (if (null? types) 
    0
    (iterate loop ((types types))
      (cond ((null? (cdr types)) (car types))
            (else
             `(fx-ior ,(car types) ,(loop (cdr types))))))))
)
t-implementation-env)