(herald (assemble vaxorbas t 9)
        (env tsys (assembler as_open))
        (syntax-table
         (block (*require 'as_syntax '(assembler as_syntax) (repl-env))
                (env-syntax-table (repl-env))))
        )


;;; Orbit & VAX specific extensions to the assembler

(define  (assemble-init c)
  (assemble-init-1 c vax emit-vax-template))

(define vaxemit %%emit)

;;; ---------------- make machine operations available in orbit env

(table-walk (machine-ops-table vax)
            (lambda (key val)
              ;(format t "defining VAX/~s~%" key)
              (*define orbit-env (concatenate-symbol 'vax/ key) val)))

(define-local-syntax (vaxop opname)
  `(vref (machine-ops-vector vax) ,(concatenate-symbol '%vax% opname)))

(define r (vaxop r))
(define @r (vaxop @r))
(define @-r (vaxop @-r))
(define @r+ (vaxop @r+))
(define *@r+ (vaxop *@r+))
(define d@r (vaxop d@r))
(define *d@r (vaxop *d@r))
(define index (vaxop index))
(define $ (vaxop $))

(define (template tag) (vax/label *current-assembly-section* tag))
(define (label tag) (vax/label *current-assembly-section* tag))

;;; ---------------- Lap additions

(define vax-register-names
  '#( "s0" "s1" "s2" "s3"  "p"    "a1" "a2" "a3" 
      "a4" "an" "tp" "nil" "task" "fp" "sp" "pc" ))

(walk (lambda (name index)
        (*define-lap-register vax name index))
      '(S0 S1 S2 S3 NARGS P A1 A2 A3 A4 AN AN-1 TP nil-reg AP TASK FP SP)
      '(0  1   2 3  3     4 5  6  7  8  9  8    10 11      12 12   13 14))

(walk (lambda (i)
        (set (table-entry (machine-pseudo-operands vax) (car i)) (cdr i)))
      `(
        (static  . ,(lambda (form section)
                      (destructure (((static id) form))
                        (static id))))
        
        (template . ,(lambda (form section)
                       (destructure (((template tag) form))
                         (vax/label section tag))))
        ))


;;; -------------------------- Template stuff.

;    |  handler offset               |  annotation offset        |H|I| :0
;    +---------------+---------------+-------------------------------+
;    |  # ptr cells  |  # scr cells  |   offset within bit vector    | :4
;    +---------------+---------------+---------------+---------+-+---+
;    |          <<---- instructions  |   # of args   |    tmplt|0|imm| <--- ptr
                                                   

;;; these fields are in the wrong order.

(define-data-fg (vax/template lambda-node handler-ib)
  (printer ".template")
  (local template-end)
  (fields
   (fixed 16 (get-template-annotation lambda-node))        
   ;;handler offset
   (fixed 16 (fixnum-ashr (from template-end handler-ib) 3))   
   ;;bitv offset
   (fixed 16 (fx+ (fixnum-ashr (mark-address template-end) 3) 2)) 
   (fixed 16 (get-template-cells lambda-node))
   (fixed 1 (if (template-nary lambda-node)  1 0))
   (fixed 7 (identity header/template))
   (fixed 8 (get-template-nargs lambda-node))
   (mark template-end)
   ))

(define (emit-vax-template code-node code-ib handler-ib template-ib)
   (set (ib-align template-ib) '(24 31 0))
   (as-emit template-ib (vax/template code-node handler-ib))
   (set-ib-follower template-ib code-ib)
   )


