(herald tsas)

(define (assemble-file inspec outspec listspec machine)
  (with-open-ports ((in (open inspec '(in)))
                    (out (open outspec '(out)))
                    (lst (open listspec '(out))))
    (let ((items (read in)))
      (let ((section (assemble (test-lap items machine))))
        (write out
               `(,(vector `(verbatim ',(bits-bv (assembly-section-bits section))))
                 ,@(map (lambda (key)
                          `((,key) (offset-in (circular 0)
                                              ,(- (quotient
                                                   (label-offset section key)
                                                   8)
                                                  10))))
                        ;; divide by 8 to convert from bits to bytes
                        ;; subtract adjust from tagged pointer to
                        ;; address of object header [which is what offset-in
                        ;; wants]

                        (assembly-section-globals section))))
        (listing-to-port lst section)
        section))))
      
      
                              
(define-global-lap-macro m68 (dbra.l reg lab)              
 `((dbcc 'f ,reg ,lab)
   (clr .w ,reg)
   (sub .l ($ 1) ,reg)
   (uj>= ,(cadr lab))))

(define-global-lap-macro m68 (millicall offset . rettag)
  (let ((l0 (generate-symbol 'l0))
        (l1 (if (null? rettag)
                (generate-symbol 'l1)
                (car rettag))))
    `((jsr (d@a TASK ,offset))
      ,l0 (jbr ,l1)
      (word (expr (- (- (tag ,l0) object_overhead)
                     tag$pointer)))
      ,@(if (null? rettag) (list l1) '()))))

(define-global-lap-macro M68 (.return count)
  `((moveq ($ ,count) NARGS)
    (jmp   (d@a TASK task$qreturn))
    ))

(define-global-lap-macro M68 (.call CallProc CallReturn CallArgCount)
  `((move .l ,CallProc PP)
    (lea     ,CallReturn TEMP)
    (moveq   ($ ,CallArgCount) NARGS)
    (jmp     (d@a TASK task$qcall))
    ))

(define-global-lap-macro M68 (.trcall TRCallProc TRCallArgCount)
  (cond ((eq? TRCallProc 'PP)
         `((moveq   ($ ,TRCallArgCount) NARGS)
           (jmp     (d@a TASK task$qtrcall))
           ))
        (else 
         `((move .l ,TRCallProc PP)
           (moveq   ($ ,TRCallArgCount) NARGS)
           (jmp     (d@a TASK task$qtrcall))
           ))))

(define-global-lap-macro M68 (.trcall_nopoll TRCallProc TRCallArgCount)
  `((move .l ,TRCallProc P)
    (moveq   ($ ,TRCallArgCount) NARGS)
    (move .l (d@a P procedure$code_chunk) TEMP)
    (jmp     (d@a TEMP chunk$instructions))
    ))


;;; This must be around a whole assembly

(define-global-lap-macro m68 (.mixed-binary-only . instructions)
  (let ((start-tag (generate-symbol 'start))
        (end-tag (generate-symbol 'end)))
    `((long (+ (<< class$randommixed 16)
               (<< header$initial_gc_byte 8)
               headertag$mixed))
      (long (expr (- (tag ,end-tag) (tag ,start-tag))))
      ,start-tag
      (long (expr (- (tag ,end-tag) (tag ,start-tag))))
      ,@instructions
      (align-tag ,end-tag 24 31 0)
      )))

;;; Assumes that containing object is at 0 in assembly

(define-global-lap-macro m68 (.internal-chunk tag . instructions)
  (let ((delta-tag (generate-symbol 'delta))
        (start-tag (generate-symbol 'start))
        (end-tag (generate-symbol 'end)))
    `((global ,tag)
      (align 24 31 0)
      (long (expr (tag ,delta-tag)))            ; delta
      ,delta-tag
      (long (+ (<< class$codechunk 16)          ; header
               (<< header$initial_gc_byte 8)
               headertag$ibinary))
      (long (expr (- (tag ,end-tag) (tag ,start-tag))))
      ,start-tag
      (word 0)                                  ; frame count
      ,tag
      (word 0)                                  ; unused
      ,@instructions
      ,end-tag
      )))

;;; This must be around whole assembly

(define-global-lap-macro m68 (.chunk tag . instructions)
  (let ((start-tag (generate-symbol 'start))
        (end-tag (generate-symbol 'end)))
    `((global ,tag)
      (long (+ (<< class$codechunk 16)          ; header
               (<< header$initial_gc_byte 8)
               headertag$binary))
      (long (expr (- (tag ,end-tag) (tag ,start-tag))))
      ,start-tag
      (word 0)                                  ; frame count
      ,tag
      (word 0)                                  ; unused
      ,@instructions
      ,end-tag
      )))

;;; Assumes that containing object is at 0 in assembly

(define-global-lap-macro m68 (.internal-millicode-entry tag . instructions)
  (let ((delta-tag (generate-symbol 'delta))
        (start-tag (generate-symbol 'start))
        (end-tag (generate-symbol 'end)))
    `((global ,tag)
      (align 24 31 0)
      (long (expr (tag ,delta-tag)))            ; delta
      ,delta-tag
      (long (+ (<< class$randombinary 16)               ; header
               (<< header$initial_gc_byte 8)
               headertag$ibinary))
      (long (expr (- (tag ,end-tag) (tag ,start-tag))))
      ,start-tag
      (word 0)
      ,tag
      ,@instructions
      ,end-tag
      )))
