@appendix[ASCII character conversion]
@label[ascii appendix] @index[ASCII codes]

The ASCII character set has nothing inherently to do with the @Tau[]
language or its implementations.  Internally, any implementation is free
to use any convenient encoding for characters, for example, a modified
ASCII (such as that of the Lisp Machine), or EBCDIC.  However, the
language does provide conversions between characters and ASCII codes
(@tc[CHAR->ASCII] and @tc[ASCII->CHAR]), so this correspondence is, for
the purposes of those routines, a part of the language definition.  The
table below is also provided as a general reference, because people
using @Tau[] are also likely to be using computers, and this information
may often be useful in that context.

@begin[verbatim, size 9, facecode 2, columns 4, boxed]
 8  10  16  character

 0   0   0  #\NULL
 1   1   1
 2   2   2
 3   3   3
 4   4   4
 5   5   5
 6   6   6
 7   7   7  #\BELL
10   8   8  #\BACKSPACE
11   9   9  #\TAB
12  10   A  #\LINEFEED
13  11   B
14  12   C  #\FORM
15  13   D  #\RETURN
16  14   E
17  15   F
20  16  10
21  17  11
22  18  12
23  19  13
24  20  14
25  21  15
26  22  16
27  23  17
30  24  18
31  25  19
32  26  1A
33  27  1B  #\ESCAPE
34  28  1C
35  29  1D
36  30  1E
37  31  1F
@newcolumn[]
 8  10  16   character

40  32  20   #\SPACE
41  33  21   !
42  34  22   "
43  35  23   #
44  36  24   $
45  37  25   %
46  38  26   &
47  39  27   '
50  40  28   (
51  41  29   )
52  42  2A   *
53  43  2B   +
54  44  2C   ,
55  45  2D   -
56  46  2E   .
57  47  2F   /
60  48  30   0
61  49  31   1
62  50  32   2
63  51  33   3
64  52  34   4
65  53  35   5
66  54  36   6
67  55  37   7
70  56  38   8
71  57  39   9
72  58  3A   :
73  59  3B   ;
74  60  3C   <
75  61  3D   =
76  62  3E   >
77  63  3F   ?
@newcolumn[]
  8  10  16   character

100  64  40   @@
101  65  41   A
102  66  42   B
103  67  43   C
104  68  44   D
105  69  45   E
106  70  46   F
107  71  47   G
110  72  48   H
111  73  49   I
112  74  4A   J
113  75  4B   K
114  76  4C   L
115  77  4D   M
116  78  4E   N
117  79  4F   O
120  80  50   P
121  81  51   Q
122  82  52   R
123  83  53   S
124  84  54   T
125  85  55   U
126  86  56   V
127  87  57   W
130  88  58   X
131  89  59   Y
132  90  5A   Z
133  91  5B   [
134  92  5C   \
135  93  5D   ]
136  94  5E   ^
137  95  5F   _
@newcolumn[]
  8   10  16   character

140   96  60   `
141   97  61   a
142   98  62   b
143   99  63   c
144  100  64   d
145  101  65   e
146  102  66   f
147  103  67   g
150  104  68   h
151  105  69   i
152  106  6A   j
153  107  6B   k
154  108  6C   l
155  109  6D   m
156  110  6E   n
157  111  6F   o
160  112  70   p
161  113  71   q
162  114  72   r
163  115  73   s
164  116  74   t
165  117  75   u
166  118  76   v
167  119  77   w
170  120  78   x
171  121  79   y
172  122  7A   z
173  123  7B   {
174  124  7C   |
175  125  7D   }
176  126  7E   @tilde[]
177  127  7F   #\RUBOUT
@end[verbatim]
