#| -*-Scheme-*-

$Header: genin.scm,v 1.1 90/11/09 08:45:16 GMT cph Rel $

Copyright (c) 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Generic Input Ports
;;; package: (runtime generic-input)

(declare (usual-integrations))

(define (initialize-package!)
  (set! generic-input-template
	(make-input-port `((ASSOCIATED-PORT ,input-port/associated-port)
			   (BUFFER-SIZE ,operation/buffer-size)
			   (BUFFERED-CHARS ,operation/buffered-chars)
			   (CHANNEL ,operation/channel)
			   (CHAR-READY? ,operation/char-ready?)
			   (CHARS-REMAINING ,operation/chars-remaining)
			   (CLOSE ,operation/close)
			   (DISCARD-CHAR ,operation/discard-char)
			   (DISCARD-CHARS ,operation/discard-chars)
			   (EOF? ,operation/eof?)
			   (PEEK-CHAR ,operation/peek-char)
			   (PRINT-SELF ,operation/print-self)
			   (READ-CHAR ,operation/read-char)
			   (READ-CHARS ,operation/read-chars)
			   (READ-STRING ,operation/read-string)
			   (SET-BUFFER-SIZE ,operation/set-buffer-size))
			 false))
  unspecific)

(define generic-input-template)

(define (make-generic-input-port channel buffer-size)
  (input-port/copy
   generic-input-template
   (make-input-port-state (make-input-buffer channel buffer-size) false)))

(define-structure (input-port-state (type vector)
				    (conc-name input-port-state/))
  ;; Buffer must come first -- other input ports use the buffer
  ;; operations defined here.
  (buffer false read-only true)
  (associated-port false))

(define-integrable (input-port/buffer port)
  (input-port-state/buffer (input-port/state port)))

(define-integrable (input-port/associated-port port)
  (input-port-state/associated-port (input-port/state port)))

(define-integrable (set-input-port/associated-port! port port*)
  (set-input-port-state/associated-port! (input-port/state port) port*))

(define (operation/buffer-size port)
  (input-buffer/size (input-port/buffer port)))

(define (operation/buffered-chars port)
  (input-buffer/buffered-chars (input-port/buffer port)))

(define (operation/channel port)
  (input-buffer/channel (input-port/buffer port)))

(define (operation/char-ready? port interval)
  (input-buffer/char-ready? (input-port/buffer port) interval))

(define (operation/chars-remaining port)
  (input-buffer/chars-remaining (input-port/buffer port)))

(define (operation/close port)
  (input-buffer/close (input-port/buffer port)))

(define (operation/discard-char port)
  (input-buffer/discard-char (input-port/buffer port)))

(define (operation/discard-chars port delimiters)
  (input-buffer/discard-until-delimiter (input-port/buffer port) delimiters))

(define (operation/eof? port)
  (input-buffer/eof? (input-port/buffer port)))

(define (operation/peek-char port)
  (input-buffer/peek-char (input-port/buffer port)))

(define (operation/print-self unparser-state port)
  (unparse-string unparser-state "for channel: ")
  (unparse-object unparser-state (operation/channel port)))

(define (operation/read-char port)
  (input-buffer/read-char (input-port/buffer port)))

(define (operation/read-chars port result-buffer)
  (input-buffer/read-substring (input-port/buffer port)
			       result-buffer
			       0
			       (string-length result-buffer)))

(define (operation/read-string port delimiters)
  (input-buffer/read-until-delimiter (input-port/buffer port) delimiters))

(define (operation/set-buffer-size port size)
  (input-buffer/set-size (input-port/buffer port) size))