/*  -*- Mode: C;  -*-
 * File: envivars_.c
 * Author: Hiroshi HARADA
 * Copyright (C) Software Research Assosiates, Inc. Tokyo Japan.
 * Changes: Heinz Schmidt (hws@csis.dit.csiro.AU)
 * Copyright (C) CSIRO Division of Information Technology, 1992
 *
 * COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
 * and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
 * LICENSE contained in the file: "sather/doc/license.txt" of the Sather
 * distribution.
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ** FUNCTION: putenv() and setenv() using gc_malloc().
 **           The system provided ones implicitly use malloc and 
 **           can loose with GC_ on. This is also a pot of
 **           compatibility stuff, to be moved elsewhere later.
 **
 ** RELATED PACKAGES: compiler calls this.
 **
 ** HISTORY:
 ** Last edited: Mar 28 13:23 1992 (hws)
 **  Mar  2 01:17 1992 (hws): adapted to GC V1.9
 **  Feb 15 11:46 1992 (hws): merged with other compile time 
 **                           conditionalization.
 ** Created: Mon Aug 5 1991
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */

#include <stdio.h>
#include <sys/param.h>

#ifdef sony_news
# include <sys/vmparam.h>
#endif

#ifdef hpux7
#  include <string.h>
#else
#  include <strings.h>
#endif

#ifdef sequent
#  include <stdio.h>
#  include <sys/ioctl.h>
#  include <pwd.h>
#  include <varargs.h>
#  include <ctype.h>
#  include <string.h>
#endif

#if defined(GC_) || defined(NeXT)
#  define ENVISETENV setenv_
#  define ENVIPUTENV putenv_
#else
#  define ENVISETENV setenv
#  define ENVIPUTENV putenv
#endif 

#if defined(GC_)
extern   char  *gc_malloc();
#  define ENVIMALLOC gc_malloc
#else
#  define ENVIMALLOC malloc
#endif

int
putenv_(env)
     char  *env;
{
    char *name;
    char *value;

    name = strcpy((char *)ENVIMALLOC(strlen(env)+1),env);
    if( (value = index(name,'=')) == NULL)
        return(1);     /* No Identifier */

    *value=NULL;
    value++;
    return( *value ? ENVISETENV(name,value,1) : 1 );  /* if *value is NULL return error*/
}
    
int
setenv_(name,value,ov_write)
     char  *name;
     char  *value;
     int   ov_write;
{
    char  *env;
    char  **P;
    int   env_cnt=0;
    int   name_len=0;
    char  **new_env;
    extern char **environ;

    if( !(name_len = strlen(name)) )
        return(1);

    for(P=environ; *P ; P++,env_cnt++)
    {
	if( (index(*P,'=') - *P)== (name_len+1) && strncmp(name,*P,name_len)==0 )
	    break;
    }

    if(*P)
    {
	if(ov_write)
	{
	    if( strlen(*P) < strlen(name)+strlen(value)+2)
	    {
	      *P = (char *)ENVIMALLOC(strlen(name)+strlen(value)+2);
	    }
	    strcat(strcat(strcpy(*P,name),"="),value);
	    return(0);
	}
	else
	    return(0);
    }
    new_env = (char  **)ENVIMALLOC(sizeof(char *) * (env_cnt+2));
    bcopy(environ,new_env,sizeof(char *) * env_cnt);
    environ = new_env;
    environ[env_cnt] = (char *)ENVIMALLOC(strlen(name)+strlen(value)+2);
    strcat(strcat(strcpy(environ[env_cnt],name),"="),value);
    environ[env_cnt+1] = NULL;
    return(0);
}


/* For testing above....
 * void printenv()
 *{
 *    extern char **environ;
 *    register char **P;
 *
 *    fprintf(stderr,"****** PRINTENV ******\n");
 *    for(P = environ; *P ; P++)
 *	fprintf(stderr,"            [%s]\n",*P);
 *} 
 */

/*
 * We cannot rely on availability of Fortran getcwd. getwd is the C library
 * function available everywhere. However we need to take care not to malloc
 * in the presence of the GC!
 */

int getcwd_()
{
  int err = 0;
  char *str = (char *)ENVIMALLOC(MAXPATHLEN);
  str[0] = 0;
#ifdef hpux
  err = getcwd(str,MAXPATHLEN);  
#else
  err = getwd(str);
#endif
  if ( err == 0 ) {
    return((int)str);
  } else
    { 
      return((int)err);
    };
}

/*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  */
/* The rest should perhaps go into some other file as it grows.
** I have been adding more and more with ports failing (hws).
*/

#if defined(sequent) || defined(NeXT)

double fmod(x,y)
     double x, y;
{ return ((double) 0);
}

#endif


#if defined(hpux) || defined(SCO)
/* According to Jean-Jacques Moreau we need to map (later by macros perhaps):
**
** ~sather/compiler/cs.cs.boot/unix__85.c
**      setregid (__, __)          -> setresgid (__, __, -1)
**      setreuid (__, __)          -> setresuid (__, __, -1)
*/

extern int setresgid();
extern int setreuid();

int setregid(rgid,egid)
     int rgid,egid;
{ 
#  if defined(hpux)
  return (setresgid(rgid,egid,-1));
#  else 
#    if defined(SCO)
  fprintf(stderr,"setregid() not implemented in SCO.\n");
  return(1);
#    else
          ----->> fix it <<-----
#    endif  
#  endif
}

int setreuid(ruid, euid)
     int ruid, euid;
{ 
#  if defined(hpux)
  return (setresuid(ruid,euid,-1));
#  else 
#    if defined(SCO)
  fprintf(stderr,"setreuid() not implemented in SCO.\n");
  return(1);
#    else
          ----->> fix it <<-----
#    endif  
#  endif
  }

#endif
