/* * Last edited: Mar 28 23:17 1992 (hws) */
/* File: sather/lib/base/C/time_.c
   Author: Stephen M. Omohundro
   Created: Tue Sep 25 17:14:23 1990
   Copyright (C) International Computer Science Institute, 1990

   COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
   and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
   LICENSE contained in the file: "sather/doc/license.txt" of the Sather
   distribution. The license is also available from ICSI, 1947 Center
   St., Suite 600, Berkeley CA 94704, USA.

   Time related functions.
*/

#include "all_.h"
#ifdef sequent
#include <sys/types.h>
#endif
#ifdef mips
#include <sys/types.h>
#endif

#ifdef SCO
#include <sys/types.h>
#include <sys/select.h>
#endif

#if defined(SCO) || defined(hpux8)
#include <sys/times.h>
#endif

#include <sys/time.h>
#include <sys/resource.h>
#include <sys/timeb.h>

#if defined(hpux) || defined(SCO)
/* From Jean-Jacques Moreau's msg of 13 Aug 91.
 *  I have ported Sather to an HP9000s300 running HP-UX 7.05. To the best of
 *  my understanding, the port should also work on s800 and on machines running
 *  the new HP-UX 8.0.
 */

#include <unistd.h>

/*
 * Partial implementation of getrusage(2).
 */

int getrusage (who, rusage)
     int who;
     struct rusage *rusage;
{
  struct tms tusage;
  long hz;
  clock_t res;

  res = times (&tusage);
  if (res == -1) 
    return -1;

  hz = sysconf (_SC_CLK_TCK);
  if (hz == -1)
    return -1;

  switch (who) {
  case RUSAGE_SELF:
    rusage->ru_utime.tv_sec = tusage.tms_utime / hz;
    rusage->ru_utime.tv_usec = (tusage.tms_utime % hz) * 1000000;

    rusage->ru_stime.tv_sec = tusage.tms_stime / hz;
    rusage->ru_stime.tv_usec = (tusage.tms_stime % hz) * 1000000;

  case RUSAGE_CHILDREN:
    rusage->ru_utime.tv_sec = tusage.tms_cutime / hz;
    rusage->ru_utime.tv_usec = (tusage.tms_cutime % hz) * 1000000;

    rusage->ru_stime.tv_sec = tusage.tms_cstime / hz;
    rusage->ru_stime.tv_usec = (tusage.tms_cstime % hz) * 1000000;
  }

  return 0;
}


/* 
 * Partial implementation of wait4().
 */

pid_t wait4 (pid, status, options, rusage)
     pid_t pid;
     int *status;
     int options;
     struct rusage *rusage;
{
  pid_t res;

  res = waitpid (pid, status, options);

  if (res == -1)
    return -1;

  /*
   * This doesn't really emulate the original function, but it will do
   * for now.
   */
  if ((pid == -1) || (pid == 0) || (pid < 0) || (pid > 0)) {
    if (getrusage (RUSAGE_CHILDREN, rusage) == -1)
      return -1;
  }

  return res;
}

#endif

static struct rusage ru;
static float st;		/* holds start time */

/* Initializes st. */
extern void start_clock_()
{
  getrusage(RUSAGE_SELF,&ru);
  st=ru.ru_utime.tv_sec+.000001*ru.ru_utime.tv_usec;
}

/* Returns time since start_clock. */
extern float get_clock_()
{
  getrusage(RUSAGE_SELF,&ru);
  return(ru.ru_utime.tv_sec+.000001*ru.ru_utime.tv_usec-st);
}

/* Time since 00:00:00 GMT, Jan. 1, 1970 in seconds. */
double time_() 
{
  static struct timeb t;
  ftime(&t);
  return(t.time+(t.millitm/1000.));
}
