;;; -*- Mode: Emacs-Lisp;  -*-
;;; File: sa-install.el
;;; Author: Heinz Schmidt (hws@ICSI.Berkeley.EDU)
;;; Copyright (C) International Computer Science Institute, 1990, 1991
;;;
;;; COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY.
;;; It is subject to the terms of the GNU EMACS GENERAL PUBLIC LICENSE
;;; described in a file COPYING in the GNU EMACS distribution or to be obtained
;;; from Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139
;;;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;* FUNCTION: installs the sather emacs support: byte-compiles all elisp
;;;*           files and tells .emacs the default home directory.
;;;*
;;;* HISTORY:
;;;* Last edited: Mar  8 10:02 1992 (hws)
;;;*  Jun 18 13:46 1991 (hws): ensure this does not die with incomplete
;;;*                           emacs installation.
;;;*  Jun  3 17:18 1991 (bilmes): fix use of top vs. home directory.
;;;*  May 23 13:12 1991 (hws): pathnames relative to sather-home-directory
;;;* Created: Sun Dec 30 07:11:22 1990 (hws)
;;;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;; Don't (require 'cl), mini-cl (to be compiled) seems to be incompatible
;;; with that.
;;; We expect these variables to be setup correctly when this is called.

(if (not (and (getenv "SATHER_HOME") (getenv "TOPDIR")))
    (error "Envi variables TOPDIR or SATHER_HOME not set properly."))

;;;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

(defun sather-install ()
  "Compiles all el files and enters the sather home pathname as a default
into et/.emacs. The default can be overwritten by the $SATHER_HOME value."
  (interactive)
  (let* ((home (getenv "SATHER_HOME"))	; where it is to be installed
	 (top (getenv "TOPDIR"))	; where we are building it
	 (emacs (expand-file-name "emacs/lisp" top))
	 (epoch (expand-file-name "emacs/epoch-lisp" top))
	 (found-byte-compile
	  (condition-case nil		; there was an installation without it
	      (progn (require 'byte-compile "bytecomp") t)
	    (error nil)))
	 files)
    (message "***********************************************************")
    (message "* OPTIONAL COMPILATION of Emacs elisp files to speed up Emacs")
    (message "* Sather support.\n*")
    (message "* Some of the functionality requires Emacs X support. Some sites/users")
    (message "* may not have/want it. The uncompiled Emacs lisp files are ok if")
    (message "* your Emacs installation contains all required files. Byte-compilation")
    (message "* may yield considerable speed-up of Emacs functions though.")
    (message "* If some of the compile steps below fail, you may want to")
    (message "* check locally that")
    (message "*      1. byte-compile is supported in your Emacs.")
    (message "*      2. Required files are part of your installation.")
    (message "*      (If everything is complete later you may byte-compile the files")
    (message "*      manually from within Emacs [M-x byte-compile <file>]).")
    (message "* or check with sather-admin@icsi.berkeley.edu whether")
    (message "*      your local Emacs version is compatible with the Emacs Sather support.")
    (message "*      You find out about the version from within Emacs by typing:")
    (message "*                C-h v emacs-version.")
    (message "***********************************************************")
    
    (message "* Emacs load-path = %s" load-path)
    (setq load-path (append (list emacs epoch) load-path))

    (if found-byte-compile
	(let* ((files (append (directory-files emacs t ".el$")
			      (directory-files epoch t ".el$"))
		      (cdr files))
	       (file (car files)))
	  ;; (require 'sky-mouse) (require 'x-mouse)
	  ;; compilation of x-mouse-base may load x-mouse in the wrong setting
	  ;; where window-system-version = nil
	  (if (not (and (boundp 'window-system-version) window-system-version))
	      (setq window-system-version 11)) ; for compile the value is irrelevant

	  ;; load before compile, mini-cl seems to use macros defined inline.
	  (load "mini-cl.el")

	  (while files
	    (cond ((and (string-equal 
			 "epoch"
			 (substring (file-name-nondirectory file) 0 5))
			(not (and (boundp 'epoch::version) epoch::version)))
		   (message "* Compilation of %s skipped, \n* would require Epoch installation."
			    file)
		   (message 
		    "* If you happen to use Epoch in your site, you may byte-compile this \n* file from within Epoch later."))
		  (t (s-byte-compile-file file)))
	    (setq files (cdr files) file (car files))))
      (message "*>>> Skipping compilation of Emacs lisp files. Byte-compile not found."))
    (find-file (expand-file-name "etc/.emacs" top))
    (message "***********************************************************")
    (message "* Updating  <sather>/etc/.emacs  to know $SATHER_HOME.")
    ;; find the first occurrence of load-path setting.
    (beginning-of-buffer)
    (cond ((re-search-forward "^(defvar sather-home-directory" nil t)
	   (beginning-of-line 1) (kill-sexp 1))
	  ((re-search-forward "^(" nil t) 
	   (beginning-of-line 1)
	   (open-line 2))
	  (t (end-of-buffer)))
    (insert "(defvar sather-home-directory\n")
    (insert "   (or (getenv \"SATHER_HOME\")\n")
    (insert (format "       \"%s\"))" home))
    (write-file (expand-file-name "etc/.emacs" top))
    
    (message "***********************************************************")))

(defun s-byte-compile-file (file)
  (condition-case msg
      ;; ensure this does not break when required files are missing.
      (byte-compile-file file)
    (error 
     (message "*>>> Cannot compile %s. Emacs complains:\n*>>>   %s" file msg))))
