;;; -*- Mode: Emacs-Lisp;  -*-
;;; File: sac-it.el
;;; Author: Heinz Schmidt (hws@ICSI.Berkeley.EDU)
;;; Copyright (C) International Computer Science Institute, 1990, 1991
;;;
;;; COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY.
;;; It is subject to the terms of the GNU EMACS GENERAL PUBLIC LICENSE
;;; described in a file COPYING in the GNU EMACS distribution or to be obtained
;;; from Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139
;;;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;* FUNCTION: top-level conversion of Sather to C interface definitions.
;;;*
;;;* HISTORY:
;;;* Last edited: Mar  8 14:36 1992 (hws)
;;;*  May 23 13:12 1991 (hws): pathnames relative to sather-home-directory
;;;* Created: Sun Dec 30 07:11:22 1990 (hws)
;;;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(defvar sather-home-directory (getenv "SATHER_HOME"))
(if (not sather-home-directory) 
    (error "The envi variable SATHER_HOME is not set properly."))

;;;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 
(setq load-path (append load-path 
			(list (expand-file-name "emacs/lisp"
					       sather-home-directory))))

(require 'sather)
(require 'sac)

(setq auto-mode-alist (append
		       (list (cons "\\.sa$" 'sather-mode))
		       auto-mode-alist))

;;; Sather C interface code
(setq auto-mode-alist (append
		       (list (cons "\\.sac$" 'sather-mode))
		       auto-mode-alist))

(defun compile-SACFILE ()
  (let ((file (getenv "SACFILE"))
        (doc-auto-log-mode-list nil))
    (cond ((stringp file) (find-file file) 
	   (message "Converting ...")
	   (sac-convert-buffer nil)
	   (sather-mode)
	   (message "... Done."))
	  (t (error "Cannot sac %s." file)))
    ))


	
