package Twilio::WebApp;
use Twilio::Functions;
use Twilio::Objects;
use Twilio::Twiml qw(!Response);
use Moduler;
use CGI;
use CGI::Cookie;
use Perlmazing;
use parent 'Twilio';
1;
__END__
our $drivers;
BEGIN {
	for my $i (ModulePaths('Twilio::WebApp::Session::Drivers')) {
		$i->require;
		$drivers->{lc $i->Name} = $i;
	}
}

sub new {
	my $class = shift;
	my $self = {
		@_,
	};
	bless $self, $class;
	$self->Objects->{apache_request} = delete $self->{apache_request};
	$self->Objects->{log_file} = delete $self->{log_file};
	my ($sid, $token) = (delete($self->{sid}), delete($self->{token}));
	$self->die("This constructor requires a 'sid' and 'token' to create the Twilio API object") unless $sid and $token;
	eval {
		$self->Objects->{api} = Twilio->new(sid => $sid, token => $token);
	};
	if (my $e = $@) {
		$self->die("Error creating the Twilio API object for Twilio::WebApp!\n$e");
	}
	$self->get_cookies;
	$self->get_driver;
	for my $i (keys %$self) {
		next if $i eq 'sid';
		delete $self->{$i};
	}
	$self->Objects->{session} = Twilio::WebApp::Session->new($self->driver);
	$self->Objects->{q} = CGI->new;
	$self->get_request;
	$self->get_uri_params;
	$self->Objects->{method} = $ENV{REQUEST_METHOD};
	$self->Objects->{verbs} = [];
	$self->log_request;
	$self;
}

sub log_request {
	my $self = shift;
	if ($self->log_file) {
		$self->log('------------------------------------------------------------------------');
		$self->log (
			(
				$self->inbound ? 'Inbound' : $self->outbound ? 'Outbound' : 'Unkown-direction'
			)
			.' '.
			(
				$self->voice ? 'voice' : $self->text ? 'text' : 'unkown-type-of'
			)
			.' '.
			"request received at ".localtime
		);
		$self->log("Remote address: ".$ENV{REMOTE_ADDR}) if $ENV{REMOTE_ADDR};
		$self->log("User agent: ".$ENV{HTTP_USER_AGENT}) if $ENV{HTTP_USER_AGENT};
		$self->log("Request uri: ".$ENV{REQUEST_URI}) if $ENV{REQUEST_URI};
		$self->log('');
		my $longest = 0;
		for my $i (sort keys %{$self->request}) {
			my $length = length($i);
			$longest = $length if $length > $longest;
		}
		for my $i (sort keys %{$self->request}) {
			my $length = length($i);
			$self->log((' ' x ($longest - $length))."$i: ".$self->request->{$i});
		}
	}
}

sub inbound {
	my $self = shift;
	return 1 if $self->text;
	($self->request->direction and $self->request->direction =~ /^inbound/) ? 1 : 0;
}

sub outbound {
	my $self = shift;
	($self->request->direction and $self->request->direction =~ /^outbound/) ? 1 : 0;
}

sub voice {
	my $self = shift;
	$self->request->call_sid;
}

sub text {
	my $self = shift;
	$self->request->message_sid;
}

sub get_request {
	my $self = shift;
	my $params = bless {}, 'Twilio::Hash';
	for my $i ($self->q->param) {
		next unless defined $i;
		$params->{camel_to_modern $i} = $self->q->param($i);
	}
	$self->Objects->{request} = $params;
}

sub get_uri_params {
	my $self = shift;
	my $params = bless {}, 'Twilio::Hash';
	for my $i ($self->q->url_param) {
		next unless defined $i;
		$params->{$i} = $self->q->url_param($i);
	}
	$self->Objects->{uri_params} = $params;
}

sub get_driver {
	my $self = shift;
	$self->{session_driver} = (not_empty $self->{session_driver}) ? lc $self->{session_driver} : 'file';
	unless (exists $drivers->{$self->{session_driver}}) {
		$self->die("'session_driver' '$self->{session_driver}' doesn't have a valid driver installed (e.g. Twilio/WebApp/Session/Drivers/$self->{session_driver}.pm)");
	}
	my $driver = 'Twilio::WebApp::Session::Drivers::'.delete $self->{session_driver};
	$driver = $driver->new(%$self);
	$self->{sid} = $driver->sid;
	$self->Objects->{driver} = $driver;
}

sub get_cookies {
	my $self = shift;
	my $ck = CGI::Cookie->fetch;
	if ($ck->{session} and $ck->{session}->value) {
		$self->{sid} = $ck->{session}->value;
	}
}

sub End {
	my $self = shift;
	$self->do(@_);
	my $final = '';
	my $cookie = CGI::Cookie->new(-name => 'session', -value => $self->driver->sid);
	if (my $r = $self->apache_request) {
		$r->content_type('application/xml');
		$r->header_out('set-cookie', $cookie);
	} else {
		$final .= "content-type: application/xml\n";
		$final .= "set-cookie: $cookie\n";
		$final .= "\n";
	}
	$final .= Twilio::Twiml::Response(@{$self->verbs});
	$self->log("\n".$final);
	if (list_context or scalar_context) {
		return $final;
	}
	print $final;
}

sub Response {
	my $self = shift;
	for my $i (@_) {
		push @{$self->verbs}, $i;
	}
}

sub Location {
	my $self = shift;
	return $self->current_location unless @_;
	if (@_ == 1) {
		if (isa_hash $_[0] or isa_array $_[0]) {
			return build_url (
				$self->current_location,
				$_[0],
			);
		} else {
			my $changed = $self->current_location;
			$changed =~ s[/[^/]*?$][/$_[0]];
			return build_url $changed, $self->uri_params;
		}
	} elsif (@_ == 2) {
		if (isa_hash $_[1] or isa_array $_[1]) {
			my $changed = $self->current_location;
			$changed =~ s[/[^/]*?$][/$_[0]];
			return build_url $changed, $_[1];
		} else {
			my $new_params = {
				%{$self->uri_params},
				$_[0] => $_[1],
			};
			return build_url $self->current_location, $new_params;
		}
	} elsif (@_ % 2) {
		return build_url 
		
sub log {
	my $self = shift;
	return unless $self->log_file;
	open my $log, '>>', $self->log_file or $self->die("Cannot write to log file '".$self->log_file."': $!");
	for my $i (@_) {
		say $log $i;
	}
	close $log;
}

1;

