use lib 'lib';
use lib '../lib';
use 5.006;
use strict;
use warnings;
use Test::More tests => 39;
use Perlmazing qw(truncate_text);

my $string = 'This is an awesome string for testing.';

is truncate_text($string, 0), '', 'truncated at the right place';
is truncate_text($string, 1), 'T', 'truncated at the right place';
is truncate_text($string, 2), 'Th', 'truncated at the right place';
is truncate_text($string, 3), 'Thi', 'truncated at the right place';
is truncate_text($string, 4), 'This', 'truncated at the right place';
is truncate_text($string, 5), 'This', 'truncated at the right place';
is truncate_text($string, 6), 'This', 'truncated at the right place';
is truncate_text($string, 7), 'This is', 'truncated at the right place';
is truncate_text($string, 8), 'This is', 'truncated at the right place';
is truncate_text($string, 9), 'This is', 'truncated at the right place';
is truncate_text($string, 10), 'This is an', 'truncated at the right place';
is truncate_text($string, 11), 'This is an', 'truncated at the right place';
is truncate_text($string, 12), 'This is an', 'truncated at the right place';
is truncate_text($string, 13), 'This is an', 'truncated at the right place';
is truncate_text($string, 14), 'This is an', 'truncated at the right place';
is truncate_text($string, 15), 'This is an', 'truncated at the right place';
is truncate_text($string, 16), 'This is an', 'truncated at the right place';
is truncate_text($string, 17), 'This is an', 'truncated at the right place';
is truncate_text($string, 18), 'This is an awesome', 'truncated at the right place';
is truncate_text($string, 19), 'This is an awesome', 'truncated at the right place';
is truncate_text($string, 20), 'This is an awesome', 'truncated at the right place';
is truncate_text($string, 21), 'This is an awesome', 'truncated at the right place';
is truncate_text($string, 22), 'This is an awesome', 'truncated at the right place';
is truncate_text($string, 23), 'This is an awesome', 'truncated at the right place';
is truncate_text($string, 24), 'This is an awesome', 'truncated at the right place';
is truncate_text($string, 25), 'This is an awesome string', 'truncated at the right place';
is truncate_text($string, 26), 'This is an awesome string', 'truncated at the right place';
is truncate_text($string, 27), 'This is an awesome string', 'truncated at the right place';
is truncate_text($string, 28), 'This is an awesome string', 'truncated at the right place';
is truncate_text($string, 29), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 30), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 31), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 32), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 33), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 34), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 35), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 36), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 37), 'This is an awesome string for', 'truncated at the right place';
is truncate_text($string, 38), 'This is an awesome string for testing.', 'truncated at the right place';