package Microsoft::AdCenter::V6::ReportingService::MetroAreaDemographicReportColumn;
# Copyright (C) 2011 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V6::ReportingService::MetroAreaDemographicReportColumn - Represents "MetroAreaDemographicReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountName
    AccountNumber
    AdDistribution
    AdGroupName
    AverageCpc
    AverageCpm
    AveragePosition
    CampaignName
    Clicks
    Country
    Ctr
    CurrencyCode
    Hour
    Impressions
    LanguageAndRegion
    MetroArea
    Spend
    State
    TimePeriod

=cut

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdDistribution {
    return 'AdDistribution';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub AverageCpm {
    return 'AverageCpm';
}

sub AveragePosition {
    return 'AveragePosition';
}

sub CampaignName {
    return 'CampaignName';
}

sub Clicks {
    return 'Clicks';
}

sub Country {
    return 'Country';
}

sub Ctr {
    return 'Ctr';
}

sub CurrencyCode {
    return 'CurrencyCode';
}

sub Hour {
    return 'Hour';
}

sub Impressions {
    return 'Impressions';
}

sub LanguageAndRegion {
    return 'LanguageAndRegion';
}

sub MetroArea {
    return 'MetroArea';
}

sub Spend {
    return 'Spend';
}

sub State {
    return 'State';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
