#!perl
use warnings; use strict;
use Test::More tests => 13;
use Test::Fatal;

use version;

use lib '.';
use t::Elive::StandardV3;
use Elive::Util;

use Elive::StandardV3::Session;
use Elive::StandardV3::SessionTelephony;

our $t = Test::More->builder;
our $class = 'Elive::StandardV3::Session' ;

our $connection;

SKIP: {

    my $skippable = 13;

    my %result = t::Elive::StandardV3->test_connection();
    my $auth = $result{auth};

   skip ($result{reason} || 'skipping live tests', $skippable)
	unless $auth && @$auth;

    use Elive::StandardV3::Connection;
    my $connection_class = $result{class};
    $connection = $connection_class->connect(@$auth);
    Elive::StandardV3->connection($connection);

    my $session_start = Elive::Util::next_quarter_hour();
    my $session_end = Elive::Util::next_quarter_hour( $session_start );

    $session_start .= '000';
    $session_end .= '000';

    my %session_data = (
	sessionName => 'test session, generated by t/soap-session-telephony.t',
	creatorId => $connection->user,
	startTime =>  $session_start,
	endTime => $session_end,
    );

    my ($session) = $class->insert(\%session_data);

    my $session_telephony;
    is( exception {$session_telephony = $session->telephony} => undef, 'get session telephony - lives');

    my %telephony_data = (
        telephonyType => 'thirdParty',
	chairPhone => '1 123 123 1234',
	chairPIN   => '6342',
	nonChairPhone => '1 248 248 0248',
	nonChairPIN   => '7722',
	isPhone => '0',
	sessionSIPPhone => 'sip:foo@bar.com',
	sessionPIN => '1234',
	);

    is( exception {$session_telephony->update(\%telephony_data)} => undef, 'telephony update - lives');

    $session_telephony = undef;

    is( exception {$session_telephony = Elive::StandardV3::SessionTelephony->retrieve($session)} => undef,
	     'retrieve session telephony - lives');

    foreach (grep {$_ ne 'telephonyType'} sort keys %telephony_data) {
        is($session_telephony->$_, $telephony_data{$_}, "session telephony: $_ - as expected");
    }

    my $session_telephony_list;

    is( exception {$session_telephony_list = Elive::StandardV3::SessionTelephony->list({sessionId => $session})} => undef,
	'list session telephony - lives');

    ok($session_telephony_list
       && $session_telephony_list->[0]
       && $session_telephony_list->[0]->sessionId eq $session->sessionId,
       'telephony list sanity')
	or diag explain {session_telephony_list => $session_telephony_list};

    is( exception {$session->delete} => undef,'session deletion - lives');

}

Elive::StandardV3->disconnect;

