
use strict;
use warnings;
use Geo::Coordinates::OSGB qw(ll_to_grid grid_to_ll grid_to_ll_helmert);
use Geo::Coordinates::OSGB::Grid qw(format_grid parse_grid parse_landranger_grid random_grid);
use Test::More tests => 101;

my $lat_one_metre = 0.00001;
my $lon_one_metre = 0.0000125;

sub errs {
    my ($e, $n,$lat, $lon) = @_;
    my ($Lat, $Lon) = grid_to_ll($e, $n);
    my $later = $Lat-$lat;
    my $loner = $Lon-$lon;
    #printf "%d %8.6f %d %8.6f\n",$e, $loner, $n, $later;
    return abs($later) < $lat_one_metre && abs($loner) < $lon_one_metre;
}

ok(errs( 64890, 820859, 57.1557640, -7.5445870), "OS Batch LL 64890 820859");
ok(errs( 91978, 863965, 57.5603870, -7.1525730), "OS Batch LL 91978 863965");
ok(errs(116169, 795502, 56.9633100, -6.6712510), "OS Batch LL 116169 795502");
ok(errs(135087, 881753, 57.7470020, -6.4538730), "OS Batch LL 135087 881753");
ok(errs(160554, 628937, 55.4953790, -5.7924170), "OS Batch LL 160554 628937");
ok(errs(160855, 827342, 57.2739150, -5.9686960), "OS Batch LL 160855 827342");
ok(errs(177798, 797126, 57.0115970, -5.6614340), "OS Batch LL 177798 797126");
ok(errs(179357, 801476, 57.0513420, -5.6396310), "OS Batch LL 179357 801476");
ok(errs(194341, 647628, 55.6784360, -5.2724980), "OS Batch LL 194341 647628");
ok(errs(195879, 814775, 57.1782150, -5.3786250), "OS Batch LL 195879 814775");
ok(errs(212081, 147568, 51.1963500, -4.6909830), "OS Batch LL 212081 147568");
ok(errs(215641, 909773, 58.0386470, -5.1245960), "OS Batch LL 215641 909773");
ok(errs(218792, 865904, 57.6464750, -5.0379630), "OS Batch LL 218792 865904");
ok(errs(225180, 688599, 56.0582010, -4.8091720), "OS Batch LL 225180 688599");
ok(errs(225713,  49637, 50.3208220, -4.4496830), "OS Batch LL 225713 49637");
ok(errs(237148, 617644, 55.4255550, -4.5748830), "OS Batch LL 237148 617644");
ok(errs(265446, 535556, 54.6970080, -4.0893430), "OS Batch LL 265446 535556");
ok(errs(284878, 690868, 56.0966740, -3.8521210), "OS Batch LL 284878 690868");
ok(errs(300816, 623394, 55.4942370, -3.5714420), "OS Batch LL 300816 623394");
ok(errs(302892, 381234, 53.3191130, -3.4592250), "OS Batch LL 302892 381234");
ok(errs(310262, 581912, 55.1234370, -3.4087120), "OS Batch LL 310262 581912");
ok(errs(311568, 337753, 52.9298870, -3.3170200), "OS Batch LL 311568 337753");
ok(errs(313223, 326568, 52.8296370, -3.2894200), "OS Batch LL 313223 326568");
ok(errs(319263, 242630, 52.0761290, -3.1794620), "OS Batch LL 319263 242630");
ok(errs(324494, 411403, 53.5937570, -3.1422730), "OS Batch LL 324494 411403");
ok(errs(341285, 673755, 55.9532140, -2.9418640), "OS Batch LL 341285 673755");
ok(errs(342283, 735085, 56.5042660, -2.9392710), "OS Batch LL 342283 735085");
ok(errs(357953, 793693, 57.0323980, -2.6943780), "OS Batch LL 357953 793693");
ok(errs(358767, 639506, 55.6473330, -2.6567250), "OS Batch LL 358767 639506");
ok(errs(363361, 749878, 56.6392740, -2.5989660), "OS Batch LL 363361 749878");
ok(errs(369334, 481145, 54.2251080, -2.4718610), "OS Batch LL 369334 481145");
ok(errs(382320, 441477, 53.8692110, -2.2703540), "OS Batch LL 382320 441477");
ok(errs(384075, 503369, 54.4255090, -2.2469610), "OS Batch LL 384075 503369");
ok(errs(384193, 341179, 52.9677510, -2.2368020), "OS Batch LL 384193 341179");
ok(errs(410586,1165918, 60.3770900, -1.8098660), "OS Batch LL 410586 1165918");
ok(errs(439154, 540217, 54.7553900, -1.3931630), "OS Batch LL 439154 540217");
ok(errs(452211, 404714, 53.5365090, -1.2137020), "OS Batch LL 452211 404714");
ok(errs(452926, 233717, 51.9993910, -1.2304720), "OS Batch LL 452926 233717");
ok(errs(452979,1203121, 60.7077540, -1.0312300), "OS Batch LL 452979 1203121");
ok(errs(453999, 180622, 51.5219430, -1.2230760), "OS Batch LL 453999 180622");
ok(errs(465492, 444022, 53.8882750, -1.0050500), "OS Batch LL 465492 444022");
ok(errs(467011, 240965, 52.0630290, -1.0239220), "OS Batch LL 467011 240965");
ok(errs(480654, 283072, 52.4396920, -0.8149190), "OS Batch LL 480654 283072");
ok(errs(502040, 137660, 51.1291350, -0.5431230), "OS Batch LL 502040 137660");
ok(errs(509887, 210014, 51.7780220, -0.4085730), "OS Batch LL 509887 210014");
ok(errs(528683, 366458, 53.1796960, -0.0759230), "OS Batch LL 528683 366458");
ok(errs(534303, 330470, 52.8550020, -0.0068330), "OS Batch LL 534303 330470");
ok(errs(543193, 160084, 51.3218440,  0.0535980), "OS Batch LL 543193 160084");
ok(errs(548812, 325994, 52.8109830,  0.2064450), "OS Batch LL 548812 325994");
ok(errs(593529, 189571, 51.5717880,  0.7912830), "OS Batch LL 593529 189571");
ok(errs(639178, 170883, 51.3865630,  1.4362010), "OS Batch LL 639178 170883");

my $margin = 0.058;

sub check {
    my ($lat, $lon, $e, $n) = @_;
    my ($E, $N) = ll_to_grid($lat, $lon);
    my $de = $E-$e;
    my $dn = $N-$n;
    if ( abs($de) <= $margin && abs($dn) <= $margin ) {
        return 1
    }
    else {
        print "$lat $lon -> $E $N -> $de $dn\n";
        return 0
    }
}


ok(check(50.594478, -2.354895, 374976.002,77256.003), "OS Batch Grid 50.5944775 -2.3548947");
ok(check(51.029361, -1.203906, 455922.999,125857.000), "OS Batch Grid 51.0293608 -1.203906");
ok(check(51.16747, 0.729383, 590913.998,144455.004), "OS Batch Grid 51.16747 0.7293825");
ok(check(51.200252, -4.661146, 214180.997,147925.997), "OS Batch Grid 51.2002521 -4.6611463");
ok(check(51.262858, -0.776512, 485462.000,152232.997), "OS Batch Grid 51.2628575 -0.7765123");
ok(check(51.391913, -2.972461, 332434.998,166323.997), "OS Batch Grid 51.3919126 -2.9724609");
ok(check(51.675076, -3.894754, 269083.999,199067.004), "OS Batch Grid 51.6750757 -3.8947541");
ok(check(51.694417, -1.887962, 407840.000,199523.997), "OS Batch Grid 51.694417 -1.8879617");
ok(check(51.763855, -0.765012, 485324.002,207961.999), "OS Batch Grid 51.7638548 -0.7650124");
ok(check(51.84497, -4.305976, 241250.997,218777.000), "OS Batch Grid 51.8449699 -4.3059758");
ok(check(51.993859, 0.945688, 602329.999,236919.002), "OS Batch Grid 51.9938588 0.945688");
ok(check(52.178801, -1.825403, 412035.002,253406.998), "OS Batch Grid 52.178801 -1.8254034");
ok(check(52.189588, -0.172719, 525007.002,256165.995), "OS Batch Grid 52.1895883 -0.1727185");
ok(check(52.253172, 0.526755, 572568.998,264671.999), "OS Batch Grid 52.2531723 0.5267549");
ok(check(52.26405, 0.333404, 559333.999,265438.998), "OS Batch Grid 52.2640498 0.3334037");
ok(check(52.264313, -3.992067, 264150.998,264774.001), "OS Batch Grid 52.2643132 -3.9920672");
ok(check(52.821802, -3.558029, 295107.998,326054.995), "OS Batch Grid 52.8218019 -3.5580286");
ok(check(52.866957, -1.80913, 412946.002,329956.998), "OS Batch Grid 52.8669574 -1.8091304");
ok(check(52.918128, 0.484959, 567169.001,338521.995), "OS Batch Grid 52.9181277 0.4849586");
ok(check(52.937815, -0.243214, 518162.997,339266.000), "OS Batch Grid 52.9378154 -0.2432141");
ok(check(53.082363, -2.349712, 376671.999,353959.995), "OS Batch Grid 53.0823628 -2.3497122");
ok(check(53.407977, -3.221939, 318866.999,390823.002), "OS Batch Grid 53.4079774 -3.2219391");
ok(check(53.431691, -1.618676, 425432.998,392833.000), "OS Batch Grid 53.4316907 -1.6186757");
ok(check(54.043486, -2.787667, 348518.998,461121.004), "OS Batch Grid 54.0434863 -2.7876666");
ok(check(55.178653, -3.594693, 298542.998,588311.021), "OS Batch Grid 55.178653 -3.5946926");
ok(check(55.230645, -4.562429, 237138.000,595931.023), "OS Batch Grid 55.2306452 -4.5624285");
ok(check(55.244343, -5.11293, 202206.997,598880.030), "OS Batch Grid 55.2443431 -5.1129299");
ok(check(55.632648, -1.933323, 404297.002,637678.043), "OS Batch Grid 55.6326481 -1.9333231");
ok(check(55.63402, -4.025583, 272581.001,639690.043), "OS Batch Grid 55.6340202 -4.0255826");
ok(check(55.803032, -6.085788, 144051.998,664197.060), "OS Batch Grid 55.8030319 -6.0857884");
ok(check(55.818596, -4.550399, 240305.000,661315.053), "OS Batch Grid 55.8185964 -4.5503985");
ok(check(55.944704, -4.277801, 257843.000,674751.064), "OS Batch Grid 55.9447039 -4.2778013");
ok(check(56.069865, -5.797443, 163743.997,692842.066), "OS Batch Grid 56.0698647 -5.7974427");
ok(check(56.11888, -4.72108, 230930.000,695130.066), "OS Batch Grid 56.1188795 -4.7210803");
ok(check(56.136894, -4.486604, 245575.999,696584.066), "OS Batch Grid 56.1368938 -4.486604");
ok(check(56.168287, -4.566587, 240736.998,700259.068), "OS Batch Grid 56.1682871 -4.5665868");
ok(check(56.525777, -5.351994, 193928.000,742118.079), "OS Batch Grid 56.5257767 -5.3519943");
ok(check(56.590386, -4.829426, 226355.001,747859.085), "OS Batch Grid 56.5903855 -4.8294255");
ok(check(56.657456, -4.718883, 233436.999,755047.086), "OS Batch Grid 56.6574558 -4.7188834");
ok(check(56.681125, -3.542171, 305616.999,755439.087), "OS Batch Grid 56.6811251 -3.5421711");
ok(check(56.711591, -6.618804, 117460.997,767301.089), "OS Batch Grid 56.7115908 -6.6188043");
ok(check(57.018972, -2.984477, 340324.000,792415.095), "OS Batch Grid 57.0189724 -2.9844771");
ok(check(57.030259, -4.970201, 219838.998,797163.100), "OS Batch Grid 57.0302593 -4.9702013");
ok(check(57.047424, -6.289135, 139964.999,803330.102), "OS Batch Grid 57.0474241 -6.2891353");
ok(check(57.436439, -6.151596, 150942.003,846073.110), "OS Batch Grid 57.4364393 -6.1515962");
ok(check(57.484802, -3.376364, 317578.998,844678.114), "OS Batch Grid 57.4848019 -3.3763641");
ok(check(57.660639, -5.102, 215044.003,867653.110), "OS Batch Grid 57.6606394 -5.1020003");
ok(check(58.438676, -3.820891, 293793.001,951482.117), "OS Batch Grid 58.4386762 -3.8208906");
ok(check(59.028089, -4.50807, 256140.999,1018375.099), "OS Batch Grid 59.0280888 -4.5080702");
ok(check(60.566809, -1.250448, 441193.003,1187267.010), "OS Batch Grid 60.5668093 -1.2504475");
