package Geo::Coordinates::OSGB::Maps;
use base qw(Exporter);
use strict;
use warnings;
our $VERSION = '2.12';
our @EXPORT_OK = qw(%maps %name_for_map_series);
our %maps;
our %name_for_map_series = ( 
  A => 'OS Landranger', 
  B => 'OS Explorer',
  C => 'OS One-Inch 7th series',
  H => 'Harvey British Mountain maps',
  J => 'Harvey Superwalker',
);
$maps{"A:1"} = { bbox => [[428200, 1180000], [469000, 1220600]], area => '1601.7025', series => 'A', number => '1', parent => 'A:1', title => 'Shetland – Yell, Unst and Fetlar', polygon => [[429000,1180000],[469000,1180000],[469000,1220000],[462300,1220000],[462000,1220150],[461500,1220550],[461300,1220600],[461000,1220550],[460400,1220300],[460250,1220000],[429000,1220000],[429000,1187400],[428200,1187000],[428200,1186450],[429000,1185600],[429000,1180000]] };
$maps{"A:2"} = { bbox => [[433000, 1156000], [473000, 1196000]], area => '1600', series => 'A', number => '2', parent => 'A:2', title => 'Shetland – Sullom Voe & Whalsay', polygon => [[433000,1156000],[473000,1156000],[473000,1196000],[433000,1196000],[433000,1156000]] };
$maps{"A:3"} = { bbox => [[413200, 1146600], [454800, 1187000]], area => '1605.309', series => 'A', number => '3', parent => 'A:3', title => 'Shetland – North Mainland', polygon => [[414000,1147000],[420000,1147000],[420750,1146650],[421500,1146600],[422000,1146700],[422600,1147000],[454000,1147000],[454000,1164120],[454400,1165000],[454500,1165300],[454540,1165500],[454500,1165700],[454400,1165900],[454300,1166000],[454000,1166200],[454000,1180500],[454400,1181400],[454400,1184900],[454750,1186000],[454800,1186600],[454000,1187000],[414000,1187000],[414000,1162400],[413200,1161600],[413200,1161000],[414000,1160200],[414000,1147000]] };
$maps{"A:3.a"} = { bbox => [[409000, 1161000], [416000, 1167000]], area => '42', series => 'A', number => '3', parent => 'A:3', title => 'Shetland – North Mainland', polygon => [[409000,1161000],[416000,1161000],[416000,1167000],[409000,1167000],[409000,1161000]] };
$maps{"A:4"} = { bbox => [[420000, 1107000], [460000, 1147000]], area => '1600', series => 'A', number => '4', parent => 'A:4', title => 'Shetland – South Mainland', polygon => [[420000,1107000],[460000,1107000],[460000,1147000],[420000,1147000],[420000,1107000]] };
$maps{"A:4.a"} = { bbox => [[392000, 1135000], [400000, 1143000]], area => '64', series => 'A', number => '4', parent => 'A:4', title => 'Shetland – South Mainland', polygon => [[392000,1135000],[400000,1135000],[400000,1143000],[392000,1143000],[392000,1135000]] };
$maps{"A:4.b"} = { bbox => [[417000, 1068000], [425000, 1076000]], area => '64', series => 'A', number => '4', parent => 'A:4', title => 'Shetland – South Mainland', polygon => [[417000,1068000],[425000,1068000],[425000,1076000],[417000,1076000],[417000,1068000]] };
$maps{"A:5"} = { bbox => [[338900, 1019500], [380000, 1060000]], area => '1603.1475', series => 'A', number => '5', parent => 'A:5', title => 'Orkney – Northern Isles', polygon => [[340000,1020000],[367000,1020000],[367500,1019500],[367800,1019500],[368200,1020000],[380000,1020000],[380000,1060000],[340000,1060000],[340000,1050950],[338900,1050400],[338900,1048900],[339500,1048000],[340000,1047600],[340000,1020000]] };
$maps{"A:5.a"} = { bbox => [[366000, 1015000], [369000, 1018000]], area => '9', series => 'A', number => '5', parent => 'A:5', title => 'Orkney – Northern Isles', polygon => [[366000,1015000],[369000,1015000],[369000,1018000],[366000,1018000],[366000,1015000]] };
$maps{"A:6"} = { bbox => [[321000, 996000], [362400, 1036000]], area => '1603.46', series => 'A', number => '6', parent => 'A:6', title => 'Orkney – Mainland', polygon => [[321000,996000],[361000,996000],[361000,1000000],[362200,1001500],[362300,1002000],[362400,1002700],[362200,1003000],[361000,1004000],[361000,1036000],[321000,1036000],[321000,996000]] };
$maps{"A:6.a"} = { bbox => [[261000, 1023000], [264000, 1025000]], area => '6', series => 'A', number => '6', parent => 'A:6', title => 'Orkney – Mainland', polygon => [[261000,1023000],[264000,1023000],[264000,1025000],[261000,1025000],[261000,1023000]] };
$maps{"A:6.b"} = { bbox => [[255000, 1017000], [258000, 1019000]], area => '6', series => 'A', number => '6', parent => 'A:6', title => 'Orkney – Mainland', polygon => [[255000,1017000],[258000,1017000],[258000,1019000],[255000,1019000],[255000,1017000]] };
$maps{"A:7"} = { bbox => [[315000, 970000], [355000, 1010000]], area => '1600', series => 'A', number => '7', parent => 'A:7', title => 'Orkney – Southern Isles', polygon => [[315000,970000],[355000,970000],[355000,1010000],[315000,1010000],[315000,970000]] };
$maps{"A:8"} = { bbox => [[116200, 926000], [157900, 967000]], area => '1610.2875', series => 'A', number => '8', parent => 'A:8', title => 'Stornoway & North Lewis / Steòrnabhagh agus Ceann a Tuath Leòdhais', polygon => [[117000,926000],[157000,926000],[157000,935000],[157500,936000],[157800,937000],[157900,937600],[157700,938700],[157000,939600],[157000,945950],[157700,946800],[157700,947200],[157000,948300],[157000,954200],[157800,956000],[157000,958000],[157000,966000],[155000,966000],[153500,967000],[151500,967000],[149400,966000],[117000,966000],[117000,945000],[116200,943200],[116200,942800],[117000,941900],[117000,926000]] };
$maps{"A:8.a"} = { bbox => [[179000, 1030000], [184000, 1035000]], area => '25', series => 'A', number => '8', parent => 'A:8', title => 'Stornoway & North Lewis / Steòrnabhagh agus Ceann a Tuath Leòdhais', polygon => [[179000,1030000],[184000,1030000],[184000,1035000],[179000,1035000],[179000,1030000]] };
$maps{"A:8.b"} = { bbox => [[159000, 1028000], [164000, 1033000]], area => '25', series => 'A', number => '8', parent => 'A:8', title => 'Stornoway & North Lewis / Steòrnabhagh agus Ceann a Tuath Leòdhais', polygon => [[159000,1028000],[164000,1028000],[164000,1033000],[159000,1033000],[159000,1028000]] };
$maps{"A:9"} = { bbox => [[212000, 940000], [252000, 980000]], area => '1600', series => 'A', number => '9', parent => 'A:9', title => 'Cape Wrath (Durness & Scourie)', polygon => [[212000,940000],[252000,940000],[252000,980000],[212000,980000],[212000,940000]] };
$maps{"A:10"} = { bbox => [[252000, 940000], [292000, 980000]], area => '1600', series => 'A', number => '10', parent => 'A:10', title => 'Strath Naver / Srath Nabhair (Bettyhill & Tongue)', polygon => [[252000,940000],[292000,940000],[292000,980000],[252000,980000],[252000,940000]] };
$maps{"A:11"} = { bbox => [[292000, 929000], [332000, 969750]], area => '1602.66', series => 'A', number => '11', parent => 'A:11', title => 'Thurso & Dunbeath', polygon => [[292000,929000],[332000,929000],[332000,969000],[309500,969000],[309000,969500],[308500,969600],[308000,969600],[307000,969750],[306000,969700],[305000,969300],[304600,969000],[292000,969000],[292000,929000]] };
$maps{"A:12"} = { bbox => [[300000, 939000], [341000, 979700]], area => '1604.9', series => 'A', number => '12', parent => 'A:12', title => 'Thurso & Wick (John O’Groats)', polygon => [[300000,939000],[340000,939000],[340000,967400],[340500,969300],[340300,970400],[340400,971300],[341000,972800],[341000,974000],[340000,975000],[340000,979000],[336500,979000],[335600,979600],[335300,979700],[334000,979000],[300000,979000],[300000,939000]] };
$maps{"A:13"} = { bbox => [[94400, 903000], [135000, 944250]], area => '1607.26', series => 'A', number => '13', parent => 'A:13', title => 'West Lewis & North Harris / Taobh Siar Leòdhais agus Ceann a Tuath na Hearadh', polygon => [[95000,903000],[135000,903000],[135000,943000],[117500,943000],[117400,943200],[117000,943600],[115000,944200],[114300,944200],[114250,944250],[114150,944250],[114000,944200],[110700,943700],[110400,943000],[95000,943000],[95000,917200],[94400,916100],[94400,915800],[95000,914700],[95000,903000]] };
$maps{"A:13.a"} = { bbox => [[68500, 944500], [74500, 947500]], area => '18', series => 'A', number => '13', parent => 'A:13', title => 'West Lewis & North Harris / Taobh Siar Leòdhais agus Ceann a Tuath na Hearadh', polygon => [[68500,944500],[74500,944500],[74500,947500],[68500,947500],[68500,944500]] };
$maps{"A:13.b"} = { bbox => [[86500, 910500], [89500, 912500]], area => '6', series => 'A', number => '13', parent => 'A:13', title => 'West Lewis & North Harris / Taobh Siar Leòdhais agus Ceann a Tuath na Hearadh', polygon => [[86500,910500],[89500,910500],[89500,912500],[86500,912500],[86500,910500]] };
$maps{"A:14"} = { bbox => [[105000, 886000], [145000, 926000]], area => '1600', series => 'A', number => '14', parent => 'A:14', title => 'Tarbert & Loch Seaforth / An Tairbeart agus Loch Shìophoirt', polygon => [[105000,886000],[145000,886000],[145000,926000],[105000,926000],[105000,886000]] };
$maps{"A:15"} = { bbox => [[194900, 900000], [236000, 940000]], area => '1608.24', series => 'A', number => '15', parent => 'A:15', title => 'Loch Assynt (Lochinver & Kylesku)', polygon => [[196000,900000],[236000,900000],[236000,940000],[196000,940000],[196000,913000],[195250,912000],[195150,911500],[195350,911000],[194900,910000],[194900,909050],[195400,908550],[195500,908000],[195500,907000],[195250,906000],[195200,905300],[195550,904550],[195600,904000],[195050,902850],[195100,902000],[195200,901800],[195800,901200],[196000,900800],[196000,900000]] };
$maps{"A:15.a"} = { bbox => [[190000, 901000], [194000, 906000]], area => '20', series => 'A', number => '15', parent => 'A:15', title => 'Loch Assynt (Lochinver & Kylesku)', polygon => [[190000,901000],[194000,901000],[194000,906000],[190000,906000],[190000,901000]] };
$maps{"A:16"} = { bbox => [[236000, 900000], [276000, 940000]], area => '1600', series => 'A', number => '16', parent => 'A:16', title => 'Lairg & Loch Shin (Loch Naver)', polygon => [[236000,900000],[276000,900000],[276000,940000],[236000,940000],[236000,900000]] };
$maps{"A:17"} = { bbox => [[276000, 900000], [316700, 940000]], area => '1601.49', series => 'A', number => '17', parent => 'A:17', title => 'Helmsdale & Strath of Kildonan', polygon => [[276000,900000],[316000,900000],[316000,927000],[316500,929000],[316700,929900],[316500,930400],[316000,931000],[316000,940000],[276000,940000],[276000,900000]] };
$maps{"A:18"} = { bbox => [[68500, 863000], [109500, 903800]], area => '1602.525', series => 'A', number => '18', parent => 'A:18', title => 'Sound of Harris / Caolas na Hearadh (North Uist, Taransay & St Kilda / Uibhist a Tuath, Tarasaigh agus Hiort)', polygon => [[69000,863000],[109000,863000],[109000,885000],[109500,885400],[109500,885700],[109000,886100],[109000,903000],[105000,903000],[104300,903500],[103400,903800],[102300,903500],[101400,903000],[69000,903000],[69000,871100],[68500,870800],[68500,870100],[69000,869900],[69000,863000]] };
$maps{"A:18.a"} = { bbox => [[5000, 896000], [17000, 907000]], area => '132', series => 'A', number => '18', parent => 'A:18', title => 'Sound of Harris / Caolas na Hearadh (North Uist, Taransay & St Kilda / Uibhist a Tuath, Tarasaigh agus Hiort)', polygon => [[5000,896000],[17000,896000],[17000,907000],[5000,907000],[5000,896000]] };
$maps{"A:18.b"} = { bbox => [[64000, 866000], [70000, 872000]], area => '36', series => 'A', number => '18', parent => 'A:18', title => 'Sound of Harris / Caolas na Hearadh (North Uist, Taransay & St Kilda / Uibhist a Tuath, Tarasaigh agus Hiort)', polygon => [[64000,866000],[70000,866000],[70000,872000],[64000,872000],[64000,866000]] };
$maps{"A:18.c"} = { bbox => [[59000, 880000], [63000, 883000]], area => '12', series => 'A', number => '18', parent => 'A:18', title => 'Sound of Harris / Caolas na Hearadh (North Uist, Taransay & St Kilda / Uibhist a Tuath, Tarasaigh agus Hiort)', polygon => [[59000,880000],[63000,880000],[63000,883000],[59000,883000],[59000,880000]] };
$maps{"A:19"} = { bbox => [[172100, 860000], [214000, 900300]], area => '1619.025', series => 'A', number => '19', parent => 'A:19', title => 'Gairloch & Ullapool (Loch Maree)', polygon => [[174000,860000],[214000,860000],[214000,900000],[210300,900000],[210000,900300],[208500,900300],[208150,900000],[174000,900000],[174000,892400],[173600,892000],[173450,891500],[173550,891000],[173600,890000],[173300,889000],[173350,888000],[173300,887000],[173600,886000],[173700,885000],[173800,884000],[173550,883000],[173200,882000],[173300,881000],[172950,880000],[173100,879000],[173000,878700],[172500,878500],[172350,878000],[172500,877500],[173100,877000],[174000,876100],[174000,874000],[173900,873000],[173600,872000],[173100,871000],[172800,870500],[172600,870000],[172400,869000],[172200,868600],[172100,868000],[172100,867300],[173000,866800],[174000,866200],[174000,860000]] };
$maps{"A:20"} = { bbox => [[214000, 860000], [254000, 900000]], area => '1600', series => 'A', number => '20', parent => 'A:20', title => 'Beinn Dearg & Loch Broom (Ben Wyvis)', polygon => [[214000,860000],[254000,860000],[254000,900000],[214000,900000],[214000,860000]] };
$maps{"A:21"} = { bbox => [[254000, 860000], [295300, 900000]], area => '1603.155', series => 'A', number => '21', parent => 'A:21', title => 'Dornoch & Alness (Invergordon & Tain)', polygon => [[254000,860000],[294000,860000],[294000,884500],[295300,887000],[295300,888000],[295000,888200],[294000,888200],[294000,900000],[254000,900000],[254000,860000]] };
$maps{"A:22"} = { bbox => [[57000, 822600], [97000, 863700]], area => '1604.3', series => 'A', number => '22', parent => 'A:22', title => 'Benbecula & South Uist / Beinn na Faoghla agus Uibhist a Deas', polygon => [[57000,823000],[82700,823000],[83300,822600],[83700,822700],[84100,823000],[97000,823000],[97000,863000],[66700,863000],[66100,863500],[63000,863500],[62300,863700],[62000,863700],[60000,863600],[59500,863400],[59000,863000],[57000,863000],[57000,823000]] };
$maps{"A:22.a"} = { bbox => [[56000, 863000], [59000, 866000]], area => '9', series => 'A', number => '22', parent => 'A:22', title => 'Benbecula & South Uist / Beinn na Faoghla agus Uibhist a Deas', polygon => [[56000,863000],[59000,863000],[59000,866000],[56000,866000],[56000,863000]] };
$maps{"A:23"} = { bbox => [[112500, 835400], [153000, 877200]], area => '1611.59', series => 'A', number => '23', parent => 'A:23', title => 'North Skye (Dunvegan & Portree)', polygon => [[113000,836000],[128000,836000],[129000,835400],[132000,835400],[133000,836000],[153000,836000],[153000,876000],[145400,876000],[145000,876300],[144500,877000],[144000,877200],[139400,877200],[139300,877000],[139000,876500],[138500,876000],[113000,876000],[113000,851100],[112500,850800],[112500,846800],[113000,846000],[113000,836000]] };
$maps{"A:23.a"} = { bbox => [[135000, 876000], [145000, 882000]], area => '60', series => 'A', number => '23', parent => 'A:23', title => 'North Skye (Dunvegan & Portree)', polygon => [[135000,876000],[145000,876000],[145000,882000],[135000,882000],[135000,876000]] };
$maps{"A:24"} = { bbox => [[150000, 830000], [190000, 870000]], area => '1600', series => 'A', number => '24', parent => 'A:24', title => 'Raasay & Applecross (Loch Torridon & Plockton)', polygon => [[150000,830000],[190000,830000],[190000,870000],[150000,870000],[150000,830000]] };
$maps{"A:25"} = { bbox => [[190000, 820000], [230000, 860000]], area => '1600', series => 'A', number => '25', parent => 'A:25', title => 'Glen Carron & Glen Affric', polygon => [[190000,820000],[230000,820000],[230000,860000],[190000,860000],[190000,820000]] };
$maps{"A:26"} = { bbox => [[230000, 820000], [270000, 860000]], area => '1600', series => 'A', number => '26', parent => 'A:26', title => 'Inverness & Loch Ness (Strathglass)', polygon => [[230000,820000],[270000,820000],[270000,860000],[230000,860000],[230000,820000]] };
$maps{"A:27"} = { bbox => [[269600, 830000], [310000, 870000]], area => '1600.4', series => 'A', number => '27', parent => 'A:27', title => 'Nairn & Forres (River Findhorn)', polygon => [[270000,830000],[310000,830000],[310000,870000],[270000,870000],[270000,864100],[269700,863700],[269600,863300],[270000,862300],[270000,830000]] };
$maps{"A:28"} = { bbox => [[310000, 833000], [350000, 873000]], area => '1600', series => 'A', number => '28', parent => 'A:28', title => 'Elgin & Dufftown (Buckie & Keith)', polygon => [[310000,833000],[350000,833000],[350000,873000],[310000,873000],[310000,833000]] };
$maps{"A:29"} = { bbox => [[345000, 830000], [385000, 870000]], area => '1600', series => 'A', number => '29', parent => 'A:29', title => 'Banff & Huntly (Portsoy & Turriff)', polygon => [[345000,830000],[385000,830000],[385000,870000],[345000,870000],[345000,830000]] };
$maps{"A:30"} = { bbox => [[377000, 830000], [417000, 870000]], area => '1600', series => 'A', number => '30', parent => 'A:30', title => 'Fraserburgh (Peterhead & Ellon)', polygon => [[377000,830000],[417000,830000],[417000,870000],[377000,870000],[377000,830000]] };
$maps{"A:31"} = { bbox => [[50000, 783000], [90000, 823000]], area => '1600', series => 'A', number => '31', parent => 'A:31', title => 'Barra & South Uist / Barraigh agus Uibhist a Deas (Vatersay & Eriskay / Bhatarsaigh agus Eirisgeigh)', polygon => [[50000,783000],[90000,783000],[90000,823000],[50000,823000],[50000,783000]] };
$maps{"A:31.a"} = { bbox => [[53000, 778000], [59000, 786000]], area => '48', series => 'A', number => '31', parent => 'A:31', title => 'Barra & South Uist / Barraigh agus Uibhist a Deas (Vatersay & Eriskay / Bhatarsaigh agus Eirisgeigh)', polygon => [[53000,778000],[59000,778000],[59000,786000],[53000,786000],[53000,778000]] };
$maps{"A:32"} = { bbox => [[129000, 798900], [170800, 840000]], area => '1612.8825', series => 'A', number => '32', parent => 'A:32', title => 'South Skye & Cuillin Hills', polygon => [[130000,800000],[153000,800000],[154000,799750],[155000,799150],[156000,798900],[158000,798900],[159500,799300],[161300,800000],[170000,800000],[170000,811600],[170500,812500],[170400,812700],[170500,813000],[170750,813800],[170700,814500],[170600,815000],[170000,816000],[170000,832000],[170800,833800],[170800,834300],[170000,836300],[170000,840000],[130000,840000],[130000,835000],[129000,832800],[129000,832100],[130000,829600],[130000,800000]] };
$maps{"A:33"} = { bbox => [[169400, 790000], [210000, 830000]], area => '1601.26', series => 'A', number => '33', parent => 'A:33', title => 'Loch Alsh, Glen Shiel & Loch Hourn', polygon => [[170000,790000],[210000,790000],[210000,830000],[170000,830000],[170000,804300],[169400,803600],[169400,802100],[170000,801600],[170000,790000]] };
$maps{"A:34"} = { bbox => [[210000, 780000], [250000, 820000]], area => '1600', series => 'A', number => '34', parent => 'A:34', title => 'Fort Augustus (Glen Roy & Glen Moriston)', polygon => [[210000,780000],[250000,780000],[250000,820000],[210000,820000],[210000,780000]] };
$maps{"A:35"} = { bbox => [[250000, 790000], [290000, 830000]], area => '1600', series => 'A', number => '35', parent => 'A:35', title => 'Kingussie & Monadhliath Mountains', polygon => [[250000,790000],[290000,790000],[290000,830000],[250000,830000],[250000,790000]] };
$maps{"A:36"} = { bbox => [[285000, 793000], [325000, 833000]], area => '1600', series => 'A', number => '36', parent => 'A:36', title => 'Grantown & Aviemore (Cairngorm Mountains)', polygon => [[285000,793000],[325000,793000],[325000,833000],[285000,833000],[285000,793000]] };
$maps{"A:37"} = { bbox => [[325000, 793000], [365000, 833000]], area => '1600', series => 'A', number => '37', parent => 'A:37', title => 'Strathdon & Alford', polygon => [[325000,793000],[365000,793000],[365000,833000],[325000,833000],[325000,793000]] };
$maps{"A:38"} = { bbox => [[365000, 790000], [405600, 830000]], area => '1600.235', series => 'A', number => '38', parent => 'A:38', title => 'Aberdeen (Inverurie & Pitmedden)', polygon => [[365000,790000],[405000,790000],[405000,829500],[405580,829700],[405600,830000],[365000,830000],[365000,790000]] };
$maps{"A:39"} = { bbox => [[119800, 770000], [160000, 810000]], area => '1600.09', series => 'A', number => '39', parent => 'A:39', title => 'Rum, Eigg, Muck & Canna', polygon => [[120000,770000],[160000,770000],[160000,810000],[120000,810000],[120000,800700],[119800,800600],[119800,800300],[120000,800100],[120000,770000]] };
$maps{"A:39.a"} = { bbox => [[114000, 795000], [118000, 798000]], area => '12', series => 'A', number => '39', parent => 'A:39', title => 'Rum, Eigg, Muck & Canna', polygon => [[114000,795000],[118000,795000],[118000,798000],[114000,798000],[114000,795000]] };
$maps{"A:40"} = { bbox => [[160000, 760000], [200000, 800000]], area => '1600', series => 'A', number => '40', parent => 'A:40', title => 'Mallaig & Glenfinnan (Loch Shiel)', polygon => [[160000,760000],[200000,760000],[200000,800000],[160000,800000],[160000,760000]] };
$maps{"A:41"} = { bbox => [[200000, 750000], [240000, 790000]], area => '1600', series => 'A', number => '41', parent => 'A:41', title => 'Ben Nevis (Fort William & Glen Coe)', polygon => [[200000,750000],[240000,750000],[240000,790000],[200000,790000],[200000,750000]] };
$maps{"A:42"} = { bbox => [[240000, 750000], [280000, 790000]], area => '1600', series => 'A', number => '42', parent => 'A:42', title => 'Glen Garry & Loch Rannoch', polygon => [[240000,750000],[280000,750000],[280000,790000],[240000,790000],[240000,750000]] };
$maps{"A:43"} = { bbox => [[280000, 759850], [320000, 800000]], area => '1600.1985', series => 'A', number => '43', parent => 'A:43', title => 'Braemar & Blair Atholl', polygon => [[280000,760000],[282500,760000],[282900,759900],[283200,759900],[283600,760000],[285300,760000],[285600,759900],[286000,759950],[286100,759950],[286300,759850],[286400,759870],[286700,759950],[286800,759900],[287000,760000],[320000,760000],[320000,800000],[280000,800000],[280000,760000]] };
$maps{"A:44"} = { bbox => [[320000, 760000], [360000, 800000]], area => '1600', series => 'A', number => '44', parent => 'A:44', title => 'Ballater, Glen Clova', polygon => [[320000,760000],[360000,760000],[360000,800000],[320000,800000],[320000,760000]] };
$maps{"A:45"} = { bbox => [[360000, 760000], [400000, 800000]], area => '1600', series => 'A', number => '45', parent => 'A:45', title => 'Stonehaven & Banchory', polygon => [[360000,760000],[400000,760000],[400000,800000],[360000,800000],[360000,760000]] };
$maps{"A:46"} = { bbox => [[91100, 733000], [133400, 773000]], area => '1603.82', series => 'A', number => '46', parent => 'A:46', title => 'Coll & Tiree', polygon => [[92000,733000],[132000,733000],[132000,734000],[132500,734400],[133000,734500],[133300,734700],[133400,735400],[133300,735700],[133000,736200],[132000,736600],[132000,773000],[92000,773000],[92000,749600],[91200,748200],[91100,747800],[92000,747200],[92000,746200],[91800,745800],[92000,745000],[92000,733000]] };
$maps{"A:47"} = { bbox => [[120000, 733000], [160000, 773500]], area => '1600.98', series => 'A', number => '47', parent => 'A:47', title => 'Tobermory & North Mull', polygon => [[120000,733000],[160000,733000],[160000,773000],[159800,773000],[159300,773300],[158800,773500],[158000,773400],[157400,773300],[156500,773000],[120000,773000],[120000,733000]] };
$maps{"A:48"} = { bbox => [[120000, 710000], [160000, 750000]], area => '1600', series => 'A', number => '48', parent => 'A:48', title => 'Iona & West Mull (Ulva)', polygon => [[120000,710000],[160000,710000],[160000,750000],[120000,750000],[120000,710000]] };
$maps{"A:49"} = { bbox => [[159200, 719250], [200000, 760000]], area => '1602.5725', series => 'A', number => '49', parent => 'A:49', title => 'Oban & East Mull', polygon => [[160000,720000],[162600,719250],[162900,719300],[164000,720000],[200000,720000],[200000,760000],[160000,760000],[160000,722000],[159900,721800],[159200,721500],[159200,721000],[159500,720500],[160000,720000]] };
$maps{"A:50"} = { bbox => [[200000, 710000], [240000, 750000]], area => '1600', series => 'A', number => '50', parent => 'A:50', title => 'Glen Orchy & Loch Etive', polygon => [[200000,710000],[240000,710000],[240000,750000],[200000,750000],[200000,710000]] };
$maps{"A:51"} = { bbox => [[240000, 720000], [280000, 760000]], area => '1600', series => 'A', number => '51', parent => 'A:51', title => 'Loch Tay & Glen Dochart', polygon => [[240000,720000],[280000,720000],[280000,760000],[240000,760000],[240000,720000]] };
$maps{"A:52"} = { bbox => [[270000, 720000], [310000, 760550]], area => '1602.4575', series => 'A', number => '52', parent => 'A:52', title => 'Pitlochry & Crieff (Aberfeldy)', polygon => [[270000,720000],[310000,720000],[310000,760000],[287200,760000],[286800,760200],[286000,760300],[284000,760500],[283000,760550],[282000,760400],[281000,760300],[280550,760000],[270000,760000],[270000,720000]] };
$maps{"A:53"} = { bbox => [[294000, 720000], [334000, 760000]], area => '1600', series => 'A', number => '53', parent => 'A:53', title => 'Blairgowrie & Forest of Alyth', polygon => [[294000,720000],[334000,720000],[334000,760000],[294000,760000],[294000,720000]] };
$maps{"A:54"} = { bbox => [[334000, 720000], [374000, 760000]], area => '1600', series => 'A', number => '54', parent => 'A:54', title => 'Dundee & Montrose (Forfar & Arbroath)', polygon => [[334000,720000],[374000,720000],[374000,760000],[334000,760000],[334000,720000]] };
$maps{"A:55"} = { bbox => [[163100, 680000], [204000, 720700]], area => '1604.778', series => 'A', number => '55', parent => 'A:55', title => 'Lochgilphead & Loch Awe', polygon => [[164000,680000],[204000,680000],[204000,720000],[178000,720000],[177000,720400],[176000,720600],[175000,720700],[174000,720600],[173000,720210],[172700,720000],[164000,720000],[164000,712000],[163550,711000],[163200,710000],[163100,709500],[163100,709300],[164000,707330],[164000,680000]] };
$maps{"A:56"} = { bbox => [[204000, 682000], [244000, 722000]], area => '1600', series => 'A', number => '56', parent => 'A:56', title => 'Loch Lomond & Inveraray', polygon => [[204000,682000],[244000,682000],[244000,722000],[204000,722000],[204000,682000]] };
$maps{"A:57"} = { bbox => [[244000, 682000], [284000, 722000]], area => '1600', series => 'A', number => '57', parent => 'A:57', title => 'Stirling & The Trossachs', polygon => [[244000,682000],[284000,682000],[284000,722000],[244000,722000],[244000,682000]] };
$maps{"A:58"} = { bbox => [[284000, 690000], [324310, 730000]], area => '1600.2055', series => 'A', number => '58', parent => 'A:58', title => 'Perth & Alloa (Auchterarder)', polygon => [[284000,690000],[324000,690000],[324000,711100],[324250,711400],[324310,712000],[324000,712000],[324000,730000],[284000,730000],[284000,690000]] };
$maps{"A:59"} = { bbox => [[324000, 690000], [364900, 730600]], area => '1602.7635', series => 'A', number => '59', parent => 'A:59', title => 'St Andrews (Kirkcaldy & Glenrothes)', polygon => [[324000,690000],[364000,690000],[364000,709000],[364700,709500],[364900,711000],[364900,711400],[364750,711680],[364000,712000],[364000,730000],[341000,730000],[340600,730550],[340300,730600],[340000,730500],[339400,730200],[339200,730000],[324000,730000],[324000,690000]] };
$maps{"A:59.a"} = { bbox => [[363000, 698000], [367000, 701000]], area => '12', series => 'A', number => '59', parent => 'A:59', title => 'St Andrews (Kirkcaldy & Glenrothes)', polygon => [[363000,698000],[367000,698000],[367000,701000],[363000,701000],[363000,698000]] };
$maps{"A:60"} = { bbox => [[110000, 639700], [150200, 680400]], area => '1600.76', series => 'A', number => '60', parent => 'A:60', title => 'Islay', polygon => [[110000,640000],[130500,640000],[130900,639700],[131700,639800],[132000,640000],[150000,640000],[150000,662100],[150200,662200],[150200,662600],[150000,662700],[150000,680000],[149300,680000],[149000,680300],[148600,680400],[148200,680300],[147900,680000],[110000,680000],[110000,640000]] };
$maps{"A:61"} = { bbox => [[131000, 661800], [171600, 702000]], area => '1602.5', series => 'A', number => '61', parent => 'A:61', title => 'Jura & Colonsay', polygon => [[131000,662000],[149000,662000],[149700,661800],[150000,661800],[150700,662000],[171000,662000],[171000,679000],[171300,680000],[171350,680600],[171000,681200],[171000,696000],[171500,698000],[171600,699000],[171400,700000],[171000,701500],[171000,702000],[131000,702000],[131000,662000]] };
$maps{"A:62"} = { bbox => [[160000, 640000], [201000, 680000]], area => '1602.78', series => 'A', number => '62', parent => 'A:62', title => 'North Kintyre & Tarbert', polygon => [[160000,640000],[200000,640000],[200000,674200],[200200,675000],[201000,675500],[201000,676000],[200700,676800],[200900,678100],[200300,678300],[200200,678500],[200000,678600],[200000,680000],[160000,680000],[160000,640000]] };
$maps{"A:63"} = { bbox => [[198600, 642000], [240000, 682000]], area => '1605.557', series => 'A', number => '63', parent => 'A:63', title => 'Firth of Clyde (Greenock & Rothesay)', polygon => [[200000,642000],[240000,642000],[240000,682000],[200000,682000],[200000,678800],[199600,678300],[199500,678000],[199350,677000],[199450,676000],[199500,675600],[200000,675000],[200000,673800],[199400,673400],[199100,672900],[198800,672500],[198600,672200],[199000,671800],[199050,671000],[199020,670600],[199100,670250],[199580,669800],[200000,668800],[200000,642000]] };
$maps{"A:64"} = { bbox => [[239500, 645000], [280000, 685000]], area => '1600.4', series => 'A', number => '64', parent => 'A:64', title => 'Glasgow (Motherwell & Airdrie)', polygon => [[240000,645000],[280000,645000],[280000,685000],[240000,685000],[240000,675000],[239500,674500],[239500,674400],[240000,673500],[240000,645000]] };
$maps{"A:65"} = { bbox => [[280000, 650000], [320000, 690000]], area => '1600', series => 'A', number => '65', parent => 'A:65', title => 'Falkirk & Linlithgow (Dunfermline)', polygon => [[280000,650000],[320000,650000],[320000,690000],[280000,690000],[280000,650000]] };
$maps{"A:66"} = { bbox => [[316000, 650000], [356000, 690000]], area => '1600', series => 'A', number => '66', parent => 'A:66', title => 'Edinburgh (Penicuik & North Berwick)', polygon => [[316000,650000],[356000,650000],[356000,690000],[316000,690000],[316000,650000]] };
$maps{"A:67"} = { bbox => [[356000, 650000], [397000, 690000]], area => '1601.47275', series => 'A', number => '67', parent => 'A:67', title => 'Duns, Dunbar & Eyemouth', polygon => [[356000,650000],[396000,650000],[396000,659800],[396830,659900],[397000,660250],[397000,660500],[396700,660780],[396550,661150],[396500,661620],[396000,662200],[396000,690000],[356000,690000],[356000,650000]] };
$maps{"A:68"} = { bbox => [[157000, 600000], [197000, 640000]], area => '1600', series => 'A', number => '68', parent => 'A:68', title => 'South Kintyre & Campbeltown', polygon => [[157000,600000],[197000,600000],[197000,640000],[157000,640000],[157000,600000]] };
$maps{"A:69"} = { bbox => [[175000, 613000], [215850, 653200]], area => '1602.6025', series => 'A', number => '69', parent => 'A:69', title => 'Isle of Arran', polygon => [[175000,613000],[215000,613000],[215000,650000],[215850,650500],[215850,653000],[215300,653200],[214500,653200],[214000,653000],[175000,653000],[175000,613000]] };
$maps{"A:70"} = { bbox => [[215000, 605000], [255000, 645000]], area => '1600', series => 'A', number => '70', parent => 'A:70', title => 'Ayr, Kilmarnock & Troon', polygon => [[215000,605000],[255000,605000],[255000,645000],[215000,645000],[215000,605000]] };
$maps{"A:71"} = { bbox => [[255000, 605000], [295000, 645000]], area => '1600', series => 'A', number => '71', parent => 'A:71', title => 'Lanark & Upper Nithsdale', polygon => [[255000,605000],[295000,605000],[295000,645000],[255000,645000],[255000,605000]] };
$maps{"A:72"} = { bbox => [[280000, 620000], [320000, 660000]], area => '1600', series => 'A', number => '72', parent => 'A:72', title => 'Upper Clyde Valley (Biggar & Lanark)', polygon => [[280000,620000],[320000,620000],[320000,660000],[280000,660000],[280000,620000]] };
$maps{"A:73"} = { bbox => [[320000, 620000], [360000, 660000]], area => '1600', series => 'A', number => '73', parent => 'A:73', title => 'Peebles, Galashiels & Selkirk (Tweed Valley)', polygon => [[320000,620000],[360000,620000],[360000,660000],[320000,660000],[320000,620000]] };
$maps{"A:74"} = { bbox => [[357000, 620000], [397000, 660300]], area => '1600.725', series => 'A', number => '74', parent => 'A:74', title => 'Kelso & Coldstream (Jedburgh & Duns)', polygon => [[357000,620000],[397000,620000],[397000,660000],[373500,660000],[373000,660300],[372000,660300],[371000,660200],[370000,660000],[357000,660000],[357000,620000]] };
$maps{"A:75"} = { bbox => [[390000, 620000], [430000, 660000]], area => '1600', series => 'A', number => '75', parent => 'A:75', title => 'Berwick-upon-Tweed (Holy Island & Wooler)', polygon => [[390000,620000],[430000,620000],[430000,660000],[390000,660000],[390000,620000]] };
$maps{"A:76"} = { bbox => [[195000, 570000], [235000, 610000]], area => '1600', series => 'A', number => '76', parent => 'A:76', title => 'Girvan (Ballantrae & Barrhill)', polygon => [[195000,570000],[235000,570000],[235000,610000],[195000,610000],[195000,570000]] };
$maps{"A:77"} = { bbox => [[235000, 570000], [275000, 610000]], area => '1600', series => 'A', number => '77', parent => 'A:77', title => 'Dalmellington & New Galloway (Galloway Forest Park)', polygon => [[235000,570000],[275000,570000],[275000,610000],[235000,610000],[235000,570000]] };
$maps{"A:78"} = { bbox => [[275000, 580000], [315000, 620000]], area => '1600', series => 'A', number => '78', parent => 'A:78', title => 'Nithsdale & Annandale (Sanquhar & Moffat)', polygon => [[275000,580000],[315000,580000],[315000,620000],[275000,620000],[275000,580000]] };
$maps{"A:79"} = { bbox => [[315000, 580000], [355000, 620000]], area => '1600', series => 'A', number => '79', parent => 'A:79', title => 'Hawick & Eskdale (Langholm)', polygon => [[315000,580000],[355000,580000],[355000,620000],[315000,620000],[315000,580000]] };
$maps{"A:80"} = { bbox => [[355000, 580000], [395000, 620000]], area => '1600', series => 'A', number => '80', parent => 'A:80', title => 'Cheviot Hills & Kielder Water', polygon => [[355000,580000],[395000,580000],[395000,620000],[355000,620000],[355000,580000]] };
$maps{"A:81"} = { bbox => [[395000, 580000], [435000, 620000]], area => '1600', series => 'A', number => '81', parent => 'A:81', title => 'Alnwick & Morpeth (Rothbury & Amble)', polygon => [[395000,580000],[435000,580000],[435000,620000],[395000,620000],[395000,580000]] };
$maps{"A:82"} = { bbox => [[195000, 530000], [235000, 570000]], area => '1600', series => 'A', number => '82', parent => 'A:82', title => 'Stranraer & Glenluce (The Rhins)', polygon => [[195000,530000],[235000,530000],[235000,570000],[195000,570000],[195000,530000]] };
$maps{"A:82.a"} = { bbox => [[195000, 568000], [204000, 575000]], area => '63', series => 'A', number => '82', parent => 'A:82', title => 'Stranraer & Glenluce (The Rhins)', polygon => [[195000,568000],[204000,568000],[204000,575000],[195000,575000],[195000,568000]] };
$maps{"A:83"} = { bbox => [[235000, 530000], [275000, 570000]], area => '1600', series => 'A', number => '83', parent => 'A:83', title => 'Newton Stewart & Kirkcudbright (Gatehouse of Fleet)', polygon => [[235000,530000],[275000,530000],[275000,570000],[235000,570000],[235000,530000]] };
$maps{"A:84"} = { bbox => [[265000, 540000], [305000, 580000]], area => '1600', series => 'A', number => '84', parent => 'A:84', title => 'Dumfries & Castle Douglas', polygon => [[265000,540000],[305000,540000],[305000,580000],[265000,580000],[265000,540000]] };
$maps{"A:85"} = { bbox => [[305000, 540000], [345000, 580000]], area => '1600', series => 'A', number => '85', parent => 'A:85', title => 'Carlisle & Solway Firth (Gretna Green)', polygon => [[305000,540000],[345000,540000],[345000,580000],[305000,580000],[305000,540000]] };
$maps{"A:86"} = { bbox => [[345000, 540000], [385000, 580000]], area => '1600', series => 'A', number => '86', parent => 'A:86', title => 'Haltwhistle & Brampton (Bewcastle & Alston)', polygon => [[345000,540000],[385000,540000],[385000,580000],[345000,580000],[345000,540000]] };
$maps{"A:87"} = { bbox => [[367000, 540000], [407000, 580000]], area => '1600', series => 'A', number => '87', parent => 'A:87', title => 'Hexham & Haltwhistle', polygon => [[367000,540000],[407000,540000],[407000,580000],[367000,580000],[367000,540000]] };
$maps{"A:88"} = { bbox => [[407000, 540000], [447000, 580000]], area => '1600', series => 'A', number => '88', parent => 'A:88', title => 'Newcastle upon Tyne (Durham & Sunderland)', polygon => [[407000,540000],[447000,540000],[447000,580000],[407000,580000],[407000,540000]] };
$maps{"A:89"} = { bbox => [[290000, 500000], [330000, 540000]], area => '1600', series => 'A', number => '89', parent => 'A:89', title => 'West Cumbria (Cockermouth & Wast Water)', polygon => [[290000,500000],[330000,500000],[330000,540000],[290000,540000],[290000,500000]] };
$maps{"A:90"} = { bbox => [[317000, 500000], [357000, 540000]], area => '1600', series => 'A', number => '90', parent => 'A:90', title => 'Penrith & Keswick (Ambleside)', polygon => [[317000,500000],[357000,500000],[357000,540000],[317000,540000],[317000,500000]] };
$maps{"A:91"} = { bbox => [[357000, 500000], [397000, 540000]], area => '1600', series => 'A', number => '91', parent => 'A:91', title => 'Appleby-in-Westmorland (Brough & Kirkby Stephen)', polygon => [[357000,500000],[397000,500000],[397000,540000],[357000,540000],[357000,500000]] };
$maps{"A:92"} = { bbox => [[380000, 500000], [420000, 540000]], area => '1600', series => 'A', number => '92', parent => 'A:92', title => 'Barnard Castle & Richmond (Teesdale)', polygon => [[380000,500000],[420000,500000],[420000,540000],[380000,540000],[380000,500000]] };
$maps{"A:93"} = { bbox => [[420000, 500000], [460000, 540000]], area => '1600', series => 'A', number => '93', parent => 'A:93', title => 'Middlesbrough (Darlington & Hartlepool)', polygon => [[420000,500000],[460000,500000],[460000,540000],[420000,540000],[420000,500000]] };
$maps{"A:94"} = { bbox => [[460000, 485000], [500100, 526400]], area => '1602.7365', series => 'A', number => '94', parent => 'A:94', title => 'Whitby & Esk Dale (Robin Hood’s Bay)', polygon => [[460000,485000],[500000,485000],[500000,499800],[500100,499900],[500100,500000],[500000,500150],[500000,525000],[462500,525000],[462000,526000],[461800,526270],[461600,526400],[461300,526350],[461000,526280],[460800,526150],[460000,526150],[460000,485000]] };
$maps{"A:95"} = { bbox => [[213000, 463850], [253000, 505500]], area => '1604.1575', series => 'A', number => '95', parent => 'A:95', title => 'Isle of Man', polygon => [[213000,465000],[213300,465000],[213900,464000],[214000,463900],[214100,463850],[215800,463850],[217000,465000],[253000,465000],[253000,505000],[248000,505000],[247000,505500],[246000,505500],[245500,505300],[245200,505000],[213000,505000],[213000,465000]] };
$maps{"A:96"} = { bbox => [[303000, 460000], [343000, 500000]], area => '1600', series => 'A', number => '96', parent => 'A:96', title => 'Barrow-in-Furness & South Lakeland', polygon => [[303000,460000],[343000,460000],[343000,500000],[303000,500000],[303000,460000]] };
$maps{"A:97"} = { bbox => [[326000, 460000], [366000, 500000]], area => '1600', series => 'A', number => '97', parent => 'A:97', title => 'Kendal & Morecambe (Windermere & Lancaster)', polygon => [[326000,460000],[366000,460000],[366000,500000],[326000,500000],[326000,460000]] };
$maps{"A:98"} = { bbox => [[366000, 460000], [406000, 500000]], area => '1600', series => 'A', number => '98', parent => 'A:98', title => 'Wensleydale & Upper Wharfedale', polygon => [[366000,460000],[406000,460000],[406000,500000],[366000,500000],[366000,460000]] };
$maps{"A:99"} = { bbox => [[406000, 460000], [446000, 500000]], area => '1600', series => 'A', number => '99', parent => 'A:99', title => 'Northallerton & Ripon (Pateley Bridge & Leyburn)', polygon => [[406000,460000],[446000,460000],[446000,500000],[406000,500000],[406000,460000]] };
$maps{"A:100"} = { bbox => [[446000, 460000], [486000, 500000]], area => '1600', series => 'A', number => '100', parent => 'A:100', title => 'Malton & Pickering (Helmsley & Easingwold)', polygon => [[446000,460000],[486000,460000],[486000,500000],[446000,500000],[446000,460000]] };
$maps{"A:101"} = { bbox => [[486000, 460000], [526200, 500000]], area => '1600.24', series => 'A', number => '101', parent => 'A:101', title => 'Scarborough (Bridlington & Filey)', polygon => [[486000,460000],[526000,460000],[526000,469800],[526200,470300],[526200,471100],[526000,471400],[526000,500000],[486000,500000],[486000,460000]] };
$maps{"A:102"} = { bbox => [[326000, 420000], [366000, 460000]], area => '1600', series => 'A', number => '102', parent => 'A:102', title => 'Preston & Blackpool (Lytham St Anne’s)', polygon => [[326000,420000],[366000,420000],[366000,460000],[326000,460000],[326000,420000]] };
$maps{"A:103"} = { bbox => [[360000, 420000], [400000, 460000]], area => '1600', series => 'A', number => '103', parent => 'A:103', title => 'Blackburn & Burnley (Clitheroe & Skipton)', polygon => [[360000,420000],[400000,420000],[400000,460000],[360000,460000],[360000,420000]] };
$maps{"A:104"} = { bbox => [[400000, 420000], [440000, 460000]], area => '1600', series => 'A', number => '104', parent => 'A:104', title => 'Leeds & Bradford (Harrogate & Ilkley)', polygon => [[400000,420000],[440000,420000],[440000,460000],[400000,460000],[400000,420000]] };
$maps{"A:105"} = { bbox => [[440000, 420000], [480000, 460000]], area => '1600', series => 'A', number => '105', parent => 'A:105', title => 'York & Selby', polygon => [[440000,420000],[480000,420000],[480000,460000],[440000,460000],[440000,420000]] };
$maps{"A:106"} = { bbox => [[463000, 420000], [503000, 460000]], area => '1600', series => 'A', number => '106', parent => 'A:106', title => 'Market Weighton (Goole & Stamford Bridge)', polygon => [[463000,420000],[503000,420000],[503000,460000],[463000,460000],[463000,420000]] };
$maps{"A:107"} = { bbox => [[500000, 420000], [540000, 460000]], area => '1600', series => 'A', number => '107', parent => 'A:107', title => 'Kingston upon Hull (Beverley & Driffield)', polygon => [[500000,420000],[540000,420000],[540000,460000],[500000,460000],[500000,420000]] };
$maps{"A:107.a"} = { bbox => [[522100, 409000], [542500, 420000]], area => '145.395', series => 'A', number => '107', parent => 'A:107', title => 'Kingston upon Hull (Beverley & Driffield)', polygon => [[527000,414000],[535500,414000],[535500,409000],[542500,409000],[542500,420000],[522100,420000],[522100,418900],[527000,414000]] };
$maps{"A:108"} = { bbox => [[320000, 380000], [360000, 420000]], area => '1600', series => 'A', number => '108', parent => 'A:108', title => 'Liverpool (Southport & Wigan)', polygon => [[320000,380000],[360000,380000],[360000,420000],[320000,420000],[320000,380000]] };
$maps{"A:108.a"} = { bbox => [[317000, 385000], [321000, 392000]], area => '28', series => 'A', number => '108', parent => 'A:108', title => 'Liverpool (Southport & Wigan)', polygon => [[317000,385000],[321000,385000],[321000,392000],[317000,392000],[317000,385000]] };
$maps{"A:109"} = { bbox => [[360000, 380000], [400000, 420000]], area => '1600', series => 'A', number => '109', parent => 'A:109', title => 'Manchester (Bolton & Warrington)', polygon => [[360000,380000],[400000,380000],[400000,420000],[360000,420000],[360000,380000]] };
$maps{"A:110"} = { bbox => [[400000, 380000], [440000, 420000]], area => '1600', series => 'A', number => '110', parent => 'A:110', title => 'Sheffield & Huddersfield (Glossop & Holmfirth)', polygon => [[400000,380000],[440000,380000],[440000,420000],[400000,420000],[400000,380000]] };
$maps{"A:111"} = { bbox => [[430000, 380000], [470000, 420400]], area => '1600.84', series => 'A', number => '111', parent => 'A:111', title => 'Sheffield & Doncaster (Rotherham, Barnsley & Thorne)', polygon => [[430000,380000],[470000,380000],[470000,420000],[443000,420000],[442800,420200],[442000,420300],[441600,420400],[441000,420300],[440000,420200],[439800,420000],[430000,420000],[430000,380000]] };
$maps{"A:112"} = { bbox => [[470000, 385000], [510000, 425000]], area => '1600', series => 'A', number => '112', parent => 'A:112', title => 'Scunthorpe & Gainsborough', polygon => [[470000,385000],[510000,385000],[510000,425000],[470000,425000],[470000,385000]] };
$maps{"A:113"} = { bbox => [[510000, 386000], [550000, 426000]], area => '1600', series => 'A', number => '113', parent => 'A:113', title => 'Grimsby (Louth & Market Rasen)', polygon => [[510000,386000],[550000,386000],[550000,426000],[510000,426000],[510000,386000]] };
$maps{"A:114"} = { bbox => [[220000, 360000], [260000, 400000]], area => '1600', series => 'A', number => '114', parent => 'A:114', title => 'Anglesey / Ynys Môn', polygon => [[220000,360000],[260000,360000],[260000,400000],[220000,400000],[220000,360000]] };
$maps{"A:114.a"} = { bbox => [[259000, 374500], [266000, 383000]], area => '59.5', series => 'A', number => '114', parent => 'A:114', title => 'Anglesey / Ynys Môn', polygon => [[259000,374500],[266000,374500],[266000,383000],[259000,383000],[259000,374500]] };
$maps{"A:115"} = { bbox => [[240000, 345000], [280000, 385000]], area => '1600', series => 'A', number => '115', parent => 'A:115', title => 'Snowdon / Yr Wyddfa (Caernarfon)', polygon => [[240000,345000],[280000,345000],[280000,385000],[240000,385000],[240000,345000]] };
$maps{"A:116"} = { bbox => [[279150, 345000], [320000, 385850]], area => '1605.9425', series => 'A', number => '116', parent => 'A:116', title => 'Denbigh & Colwyn Bay / Dinbych a Bae Colwyn', polygon => [[280000,345000],[320000,345000],[320000,385000],[315000,385000],[314500,385600],[313800,385800],[312500,385850],[311800,385850],[310800,385750],[308000,385000],[280000,385000],[280000,362800],[279650,362700],[279350,362300],[279200,362000],[279150,361500],[279300,361000],[279800,360000],[280000,359000],[280000,345000]] };
$maps{"A:117"} = { bbox => [[320000, 340000], [360000, 380000]], area => '1600', series => 'A', number => '117', parent => 'A:117', title => 'Chester & Wrexham / Caer a Wrecsam (Ellesmere Port)', polygon => [[320000,340000],[360000,340000],[360000,380000],[320000,380000],[320000,340000]] };
$maps{"A:118"} = { bbox => [[360000, 340000], [400000, 380000]], area => '1600', series => 'A', number => '118', parent => 'A:118', title => 'Stoke-on-Trent & Macclesfield', polygon => [[360000,340000],[400000,340000],[400000,380000],[360000,380000],[360000,340000]] };
$maps{"A:119"} = { bbox => [[400000, 340000], [440000, 380000]], area => '1600', series => 'A', number => '119', parent => 'A:119', title => 'Buxton & Matlock (Chesterfield, Bakewell & Dove Dale)', polygon => [[400000,340000],[440000,340000],[440000,380000],[400000,380000],[400000,340000]] };
$maps{"A:120"} = { bbox => [[439700, 350000], [480300, 390100]], area => '1601.7175', series => 'A', number => '120', parent => 'A:120', title => 'Mansfield & Worksop (Sherwood Forest)', polygon => [[440000,350000],[480000,350000],[480000,360800],[480300,361500],[480300,361600],[480200,362000],[480100,362400],[480100,363000],[480000,383100],[480000,390000],[444000,390000],[443900,390100],[443100,390100],[443000,390000],[440000,390000],[440000,351100],[439800,351050],[439700,350500],[439800,350000],[440000,350000]] };
$maps{"A:121"} = { bbox => [[478000, 350000], [518000, 390000]], area => '1600', series => 'A', number => '121', parent => 'A:121', title => 'Lincoln & Newark-on-Trent', polygon => [[478000,350000],[518000,350000],[518000,390000],[478000,390000],[478000,350000]] };
$maps{"A:122"} = { bbox => [[518000, 350000], [558000, 390000]], area => '1600', series => 'A', number => '122', parent => 'A:122', title => 'Skegness & Horncastle', polygon => [[518000,350000],[558000,350000],[558000,390000],[518000,390000],[518000,350000]] };
$maps{"A:123"} = { bbox => [[210000, 320000], [250000, 360000]], area => '1600', series => 'A', number => '123', parent => 'A:123', title => 'Lleyn Peninsula / Pen Llŷn', polygon => [[210000,320000],[250000,320000],[250000,360000],[210000,360000],[210000,320000]] };
$maps{"A:124"} = { bbox => [[250000, 305000], [290000, 345000]], area => '1600', series => 'A', number => '124', parent => 'A:124', title => 'Porthmadog & Dolgellau', polygon => [[250000,305000],[290000,305000],[290000,345000],[250000,345000],[250000,305000]] };
$maps{"A:125"} = { bbox => [[280000, 305000], [320000, 345000]], area => '1600', series => 'A', number => '125', parent => 'A:125', title => 'Bala & Lake Vyrnwy / Y Bala a Llyn Efyrnwy (Berwyn)', polygon => [[280000,305000],[320000,305000],[320000,345000],[280000,345000],[280000,305000]] };
$maps{"A:126"} = { bbox => [[320000, 300000], [360000, 340000]], area => '1600', series => 'A', number => '126', parent => 'A:126', title => 'Shrewsbury & Oswestry (Amwythig & Chroesoswallt)', polygon => [[320000,300000],[360000,300000],[360000,340000],[320000,340000],[320000,300000]] };
$maps{"A:127"} = { bbox => [[360000, 300000], [400000, 340000]], area => '1600', series => 'A', number => '127', parent => 'A:127', title => 'Stafford & Telford (Ironbridge)', polygon => [[360000,300000],[400000,300000],[400000,340000],[360000,340000],[360000,300000]] };
$maps{"A:128"} = { bbox => [[400000, 308000], [440000, 348000]], area => '1600', series => 'A', number => '128', parent => 'A:128', title => 'Derby & Burton upon Trent', polygon => [[400000,308000],[440000,308000],[440000,348000],[400000,348000],[400000,308000]] };
$maps{"A:129"} = { bbox => [[439920, 310000], [480000, 350000]], area => '1600.05885', series => 'A', number => '129', parent => 'A:129', title => 'Nottingham & Loughborough (Melton Mowbray)', polygon => [[440000,310000],[480000,310000],[480000,350000],[440000,350000],[439920,349950],[439920,349550],[440000,349200],[440000,348800],[439930,348500],[440000,348490],[440000,310000]] };
$maps{"A:130"} = { bbox => [[480000, 310000], [520000, 350000]], area => '1600', series => 'A', number => '130', parent => 'A:130', title => 'Grantham (Sleaford & Bourne)', polygon => [[480000,310000],[520000,310000],[520000,350000],[480000,350000],[480000,310000]] };
$maps{"A:131"} = { bbox => [[520000, 310000], [560000, 350000]], area => '1600', series => 'A', number => '131', parent => 'A:131', title => 'Boston & Spalding', polygon => [[520000,310000],[560000,310000],[560000,350000],[520000,350000],[520000,310000]] };
$maps{"A:132"} = { bbox => [[560000, 310000], [600000, 350000]], area => '1600', series => 'A', number => '132', parent => 'A:132', title => 'North West Norfolk (King’s Lynn & Fakenham)', polygon => [[560000,310000],[600000,310000],[600000,350000],[560000,350000],[560000,310000]] };
$maps{"A:133"} = { bbox => [[600000, 309800], [640000, 350000]], area => '1600.7535', series => 'A', number => '133', parent => 'A:133', title => 'North East Norfolk (Cromer & Wroxham)', polygon => [[600000,310000],[633800,310000],[634100,309870],[636180,309820],[636920,309800],[638150,309800],[638400,310000],[640000,310000],[640000,350000],[600000,350000],[600000,310000]] };
$maps{"A:134"} = { bbox => [[617000, 289200], [657200, 330000]], area => '1603.62465', series => 'A', number => '134', parent => 'A:134', title => 'Norwich & The Broads (Great Yarmouth)', polygon => [[617000,290000],[637350,290000],[637500,289950],[637800,289950],[637900,290000],[638100,290000],[638900,289800],[639100,289560],[639500,289420],[640160,289460],[640400,289550],[640620,289720],[641200,289900],[641470,289850],[641800,289960],[642220,289920],[642530,289900],[642950,289800],[643210,289820],[643600,289730],[644330,289800],[645000,289840],[645700,289300],[647000,289200],[647200,289250],[648200,290000],[657000,290000],[657000,313000],[657200,313200],[657200,313800],[657000,314000],[657000,330000],[617000,330000],[617000,290000]] };
$maps{"A:135"} = { bbox => [[249000, 265000], [290000, 305000]], area => '1600.9625', series => 'A', number => '135', parent => 'A:135', title => 'Aberystwyth & Machynlleth', polygon => [[250000,265000],[290000,265000],[290000,305000],[250000,305000],[250000,266800],[249700,266400],[249500,265800],[249250,265500],[249000,265300],[249000,265000],[250000,265000]] };
$maps{"A:136"} = { bbox => [[280000, 265000], [320000, 305000]], area => '1600', series => 'A', number => '136', parent => 'A:136', title => 'Newtown & Llanidloes / Y Drenewydd a Llanidloes', polygon => [[280000,265000],[320000,265000],[320000,305000],[280000,305000],[280000,265000]] };
$maps{"A:137"} = { bbox => [[320000, 260000], [360000, 300000]], area => '1600', series => 'A', number => '137', parent => 'A:137', title => 'Church Stretton & Ludlow / Llwydlo (Wenlock Edge)', polygon => [[320000,260000],[360000,260000],[360000,300000],[320000,300000],[320000,260000]] };
$maps{"A:138"} = { bbox => [[345000, 259700], [385000, 300240]], area => '1600.34975', series => 'A', number => '138', parent => 'A:138', title => 'Kidderminster & Wyre Forest', polygon => [[345000,260000],[375200,260000],[375350,259850],[375550,259700],[376500,259900],[376550,260000],[385000,260000],[385000,300000],[362550,300000],[362500,300200],[362200,300240],[361950,300000],[345000,300000],[345000,260000]] };
$maps{"A:139"} = { bbox => [[385000, 268000], [425000, 308000]], area => '1600', series => 'A', number => '139', parent => 'A:139', title => 'Birmingham & Wolverhampton (including the Black Country)', polygon => [[385000,268000],[425000,268000],[425000,308000],[385000,308000],[385000,268000]] };
$maps{"A:140"} = { bbox => [[425000, 270000], [465000, 310000]], area => '1600', series => 'A', number => '140', parent => 'A:140', title => 'Leicester, Coventry & Rugby', polygon => [[425000,270000],[465000,270000],[465000,310000],[425000,310000],[425000,270000]] };
$maps{"A:141"} = { bbox => [[465000, 270000], [505000, 310000]], area => '1600', series => 'A', number => '141', parent => 'A:141', title => 'Kettering & Corby (Market Harborough & Stamford)', polygon => [[465000,270000],[505000,270000],[505000,310000],[465000,310000],[465000,270000]] };
$maps{"A:142"} = { bbox => [[505000, 274000], [545000, 314000]], area => '1600', series => 'A', number => '142', parent => 'A:142', title => 'Peterborough (Market Deeping & Chatteris)', polygon => [[505000,274000],[545000,274000],[545000,314000],[505000,314000],[505000,274000]] };
$maps{"A:143"} = { bbox => [[537000, 274000], [577000, 314000]], area => '1600', series => 'A', number => '143', parent => 'A:143', title => 'Ely & Wisbech (Downham Market)', polygon => [[537000,274000],[577000,274000],[577000,314000],[537000,314000],[537000,274000]] };
$maps{"A:144"} = { bbox => [[577000, 270000], [617000, 310400]], area => '1600.26', series => 'A', number => '144', parent => 'A:144', title => 'Thetford & Diss (Breckland & Wymondham)', polygon => [[577000,270000],[617000,270000],[617000,310000],[582600,310000],[581900,310400],[581850,310400],[581350,310000],[577000,310000],[577000,270000]] };
$maps{"A:145"} = { bbox => [[199500, 220000], [240000, 260910]], area => '1601.9725', series => 'A', number => '145', parent => 'A:145', title => 'Cardigan & Mynydd Preseli / Aberteifi a Mynydd Preseli', polygon => [[200000,220000],[240000,220000],[240000,260000],[239700,260000],[239400,260500],[239000,260850],[238700,260910],[238000,260800],[236900,260000],[200000,260000],[200000,241300],[199500,240600],[200000,240000],[200000,220000]] };
$maps{"A:146"} = { bbox => [[240000, 225000], [280000, 265000]], area => '1600', series => 'A', number => '146', parent => 'A:146', title => 'Lampeter & Llandovery / Llanbedr Pont Steffan a Llanymddyfri', polygon => [[240000,225000],[280000,225000],[280000,265000],[240000,265000],[240000,225000]] };
$maps{"A:147"} = { bbox => [[270000, 240000], [310000, 280000]], area => '1600', series => 'A', number => '147', parent => 'A:147', title => 'Elan Valley & Builth Wells / Cwm Elan a Llanfair-ym-Muallt', polygon => [[270000,240000],[310000,240000],[310000,280000],[270000,280000],[270000,240000]] };
$maps{"A:148"} = { bbox => [[309800, 240000], [350000, 280000]], area => '1600.125', series => 'A', number => '148', parent => 'A:148', title => 'Presteigne & Hay-on-Wye / Llanandras a’r Gelli Gandryll', polygon => [[310000,240000],[350000,240000],[350000,280000],[310000,280000],[310000,272500],[309900,272450],[309800,271900],[309800,271800],[310000,271600],[310000,240000]] };
$maps{"A:149"} = { bbox => [[333000, 228000], [373000, 268000]], area => '1600', series => 'A', number => '149', parent => 'A:149', title => 'Hereford & Leominster (Bromyard & Ledbury)', polygon => [[333000,228000],[373000,228000],[373000,268000],[333000,268000],[333000,228000]] };
$maps{"A:150"} = { bbox => [[373000, 228000], [413000, 268200]], area => '1600.29125', series => 'A', number => '150', parent => 'A:150', title => 'Worcester & The Malverns (Evesham & Tewkesbury)', polygon => [[373000,228000],[413000,228000],[413000,268000],[407300,268000],[407150,268200],[406850,268100],[406500,268150],[405500,268150],[405000,268000],[373000,268000],[373000,228000]] };
$maps{"A:151"} = { bbox => [[413000, 230000], [453000, 270000]], area => '1600', series => 'A', number => '151', parent => 'A:151', title => 'Stratford-upon-Avon (Warwick & Banbury)', polygon => [[413000,230000],[453000,230000],[453000,270000],[413000,270000],[413000,230000]] };
$maps{"A:152"} = { bbox => [[453000, 230000], [493000, 270400]], area => '1600.45', series => 'A', number => '152', parent => 'A:152', title => 'Northampton & Milton Keynes (Buckingham & Daventry)', polygon => [[453000,230000],[493000,230000],[493000,270000],[458800,270000],[458700,270200],[458400,270400],[457800,270400],[457600,270350],[457400,270000],[453000,270000],[453000,230000]] };
$maps{"A:153"} = { bbox => [[493000, 234000], [533000, 274000]], area => '1600', series => 'A', number => '153', parent => 'A:153', title => 'Bedford & Huntingdon (St Neots & Biggleswade)', polygon => [[493000,234000],[533000,234000],[533000,274000],[493000,274000],[493000,234000]] };
$maps{"A:154"} = { bbox => [[533000, 234000], [573000, 274000]], area => '1600', series => 'A', number => '154', parent => 'A:154', title => 'Cambridge & Newmarket (Saffron Walden)', polygon => [[533000,234000],[573000,234000],[573000,274000],[533000,274000],[533000,234000]] };
$maps{"A:155"} = { bbox => [[573000, 234000], [613000, 274000]], area => '1600', series => 'A', number => '155', parent => 'A:155', title => 'Bury St Edmunds (Sudbury & Stowmarket)', polygon => [[573000,234000],[613000,234000],[613000,274000],[573000,274000],[573000,234000]] };
$maps{"A:156"} = { bbox => [[613000, 250000], [654150, 291100]], area => '1611.530875', series => 'A', number => '156', parent => 'A:156', title => 'Saxmundham, Aldeburgh & Southwold', polygon => [[613000,250000],[653000,250000],[653000,279100],[653500,281000],[653500,281000],[654150,282300],[654150,290000],[643200,290000],[643000,290250],[642600,290500],[642700,290900],[642110,291100],[641900,290300],[641550,290150],[641000,290000],[638500,290000],[638000,290100],[637800,290005],[637500,290005],[636750,290150],[635800,290000],[613000,290000],[613000,250000]] };
$maps{"A:157"} = { bbox => [[165000, 199600], [205000, 242100]], area => '1614.13475', series => 'A', number => '157', parent => 'A:157', title => 'St Davids & Haverfordwest / Tyddewi a Hwlffordd', polygon => [[165000,201000],[183900,201000],[187500,200050],[188300,200050],[189400,200200],[190000,200600],[191000,200150],[191500,200100],[192400,199900],[193500,199900],[194400,199800],[194700,199600],[195500,200100],[196300,200350],[196550,200300],[197200,200600],[197220,201000],[205000,201000],[205000,241000],[202100,241000],[200800,241800],[200300,241750],[200000,241620],[199850,241000],[192000,241000],[191000,241600],[190000,242000],[189700,242100],[189400,242100],[188000,241000],[165000,241000],[165000,201000]] };
$maps{"A:157.a"} = { bbox => [[145000, 207500], [148000, 210000]], area => '7.5', series => 'A', number => '157', parent => 'A:157', title => 'St Davids & Haverfordwest / Tyddewi a Hwlffordd', polygon => [[145000,207500],[148000,207500],[148000,210000],[145000,210000],[145000,207500]] };
$maps{"A:157.b"} = { bbox => [[158000, 208000], [161000, 210500]], area => '7.5', series => 'A', number => '157', parent => 'A:157', title => 'St Davids & Haverfordwest / Tyddewi a Hwlffordd', polygon => [[158000,208000],[161000,208000],[161000,210500],[158000,210500],[158000,208000]] };
$maps{"A:158"} = { bbox => [[189000, 190000], [229000, 230000]], area => '1600', series => 'A', number => '158', parent => 'A:158', title => 'Tenby & Pembroke / Dinbych-y-pysgod a Penfro', polygon => [[189000,190000],[229000,190000],[229000,230000],[189000,230000],[189000,190000]] };
$maps{"A:158.a"} = { bbox => [[183000, 194000], [190000, 204000]], area => '70', series => 'A', number => '158', parent => 'A:158', title => 'Tenby & Pembroke / Dinbych-y-pysgod a Penfro', polygon => [[183000,194000],[190000,194000],[190000,204000],[183000,204000],[183000,194000]] };
$maps{"A:159"} = { bbox => [[229000, 184100], [269000, 225000]], area => '1603.58', series => 'A', number => '159', parent => 'A:159', title => 'Swansea & Gower / Abertawe a Gŵyr (Carmarthen / Caerfyrddin)', polygon => [[229000,185000],[244700,185000],[245000,184800],[246000,184600],[246500,184150],[247000,184100],[248000,184200],[248500,184500],[250800,184500],[251500,185000],[269000,185000],[269000,225000],[229000,225000],[229000,185000]] };
$maps{"A:160"} = { bbox => [[269000, 205000], [309400, 245000]], area => '1600.105', series => 'A', number => '160', parent => 'A:160', title => 'Brecon Beacons / Bannau Brycheiniog', polygon => [[269000,205000],[309000,205000],[309000,243700],[309400,243700],[309300,244000],[309000,244000],[309000,245000],[269000,245000],[269000,205000]] };
$maps{"A:161"} = { bbox => [[309000, 205000], [349000, 245000]], area => '1600', series => 'A', number => '161', parent => 'A:161', title => 'The Black Mountains / Y Mynyddoedd Duon (Abergavenny / Y Fenni)', polygon => [[309000,205000],[349000,205000],[349000,245000],[309000,245000],[309000,205000]] };
$maps{"A:162"} = { bbox => [[349000, 186900], [389000, 228000]], area => '1603.74', series => 'A', number => '162', parent => 'A:162', title => 'Gloucester & Forest of Dean (Caerloyw a Fforest y Dena)', polygon => [[349000,188000],[349000,186900],[351300,186900],[353500,188000],[389000,188000],[389000,228000],[349000,228000],[349000,188000]] };
$maps{"A:163"} = { bbox => [[388800, 190000], [429000, 230000]], area => '1600.05', series => 'A', number => '163', parent => 'A:163', title => 'Cheltenham & Cirencester (Stow-on-the-Wold)', polygon => [[389000,190000],[429000,190000],[429000,230000],[389000,230000],[389000,193600],[388800,193300],[389000,193100],[389000,190000]] };
$maps{"A:164"} = { bbox => [[429000, 189300], [469000, 230000]], area => '1601.515', series => 'A', number => '164', parent => 'A:164', title => 'Oxford (Chipping Norton & Bicester)', polygon => [[429000,190000],[451000,190000],[451100,189700],[452700,189300],[454700,190000],[469000,190000],[469000,230000],[429000,230000],[429000,190000]] };
$maps{"A:165"} = { bbox => [[460000, 195000], [500000, 235000]], area => '1600', series => 'A', number => '165', parent => 'A:165', title => 'Aylesbury & Leighton Buzzard (Thame & Berkhamsted)', polygon => [[460000,195000],[500000,195000],[500000,235000],[460000,235000],[460000,195000]] };
$maps{"A:166"} = { bbox => [[500000, 194000], [540000, 234000]], area => '1600', series => 'A', number => '166', parent => 'A:166', title => 'Luton & Hertford (Hitchin & St Albans)', polygon => [[500000,194000],[540000,194000],[540000,234000],[500000,234000],[500000,194000]] };
$maps{"A:167"} = { bbox => [[540000, 194000], [580000, 234000]], area => '1600', series => 'A', number => '167', parent => 'A:167', title => 'Chelmsford (Harlow & Bishop’s Stortford)', polygon => [[540000,194000],[580000,194000],[580000,234000],[540000,234000],[540000,194000]] };
$maps{"A:168"} = { bbox => [[580000, 194000], [620000, 234000]], area => '1600', series => 'A', number => '168', parent => 'A:168', title => 'Colchester (Halstead & Maldon)', polygon => [[580000,194000],[620000,194000],[620000,234000],[580000,234000],[580000,194000]] };
$maps{"A:169"} = { bbox => [[607000, 210000], [647000, 250000]], area => '1600', series => 'A', number => '169', parent => 'A:169', title => 'Ipswich & The Naze (Clacton-on-Sea)', polygon => [[607000,210000],[647000,210000],[647000,250000],[607000,250000],[607000,210000]] };
$maps{"A:170"} = { bbox => [[269000, 165000], [309000, 205000]], area => '1600', series => 'A', number => '170', parent => 'A:170', title => 'Vale of Glamorgan West / Gorllewin Bro Morgannwg (Porthcawl & Rhondda)', polygon => [[269000,165000],[309000,165000],[309000,205000],[269000,205000],[269000,165000]] };
$maps{"A:171"} = { bbox => [[309000, 164500], [349000, 205000]], area => '1600.355', series => 'A', number => '171', parent => 'A:171', title => 'Cardiff & Newport / Caerdydd & Casnewydd (Pontypool / Pont-y-pŵl)', polygon => [[309000,165000],[321600,165000],[321700,164600],[322300,164500],[322400,164600],[322500,165000],[349000,165000],[349000,205000],[309000,205000],[309000,165000]] };
$maps{"A:172"} = { bbox => [[338500, 154300], [380000, 195000]], area => '1606.15', series => 'A', number => '172', parent => 'A:172', title => 'Bristol & Bath (Thornbury & Chew Magna)', polygon => [[340000,155000],[364500,155000],[367000,154300],[369000,154300],[370000,155000],[380000,155000],[380000,195000],[340000,195000],[340000,173000],[338500,171600],[338500,170500],[340000,169400],[340000,155000]] };
$maps{"A:173"} = { bbox => [[380000, 155000], [420000, 195000]], area => '1600', series => 'A', number => '173', parent => 'A:173', title => 'Swindon & Devizes (Marlborough & Trowbridge)', polygon => [[380000,155000],[420000,155000],[420000,195000],[380000,195000],[380000,155000]] };
$maps{"A:174"} = { bbox => [[420000, 155000], [460000, 195100]], area => '1600.0215', series => 'A', number => '174', parent => 'A:174', title => 'Newbury & Wantage (Hungerford & Didcot)', polygon => [[420000,155000],[460000,155000],[460000,195000],[427950,195000],[427800,195100],[427700,195060],[427500,195000],[420000,195000],[420000,155000]] };
$maps{"A:175"} = { bbox => [[460000, 155000], [500000, 195000]], area => '1600', series => 'A', number => '175', parent => 'A:175', title => 'Reading & Windsor (Henley-on-Thames & Bracknell)', polygon => [[460000,155000],[500000,155000],[500000,195000],[460000,195000],[460000,155000]] };
$maps{"A:176"} = { bbox => [[495000, 160000], [535300, 200200]], area => '1600.20675', series => 'A', number => '176', parent => 'A:176', title => 'West London (Rickmansworth & Staines)', polygon => [[495000,160000],[535000,160000],[535000,200000],[535300,200000],[534950,200200],[534300,200150],[533820,200080],[533750,200000],[495000,200000],[495000,160000]] };
$maps{"A:177"} = { bbox => [[530000, 160000], [570000, 200350]], area => '1600.5595', series => 'A', number => '177', parent => 'A:177', title => 'East London (Billericay & Gravesend)', polygon => [[530000,160000],[570000,160000],[570000,200000],[547500,200000],[547280,200300],[547150,200350],[546500,200200],[546500,200000],[536550,200000],[535450,200100],[534950,200220],[534300,200130],[533850,200100],[533750,200000],[530000,200000],[530000,160000]] };
$maps{"A:178"} = { bbox => [[565000, 155000], [606000, 195900]], area => '1605.9585', series => 'A', number => '178', parent => 'A:178', title => 'Thames Estuary (Rochester & Southend-on-Sea)', polygon => [[565000,155000],[605000,155000],[605000,166850],[605900,167500],[606000,168000],[606000,169000],[605640,170000],[605400,170400],[605100,170790],[605000,170800],[605000,194700],[605200,195200],[605300,195700],[605000,195800],[604800,195900],[604300,195850],[602000,195000],[595600,195000],[594800,195500],[594000,195450],[593000,195500],[592650,195550],[592500,195400],[592600,195000],[565000,195000],[565000,155000]] };
$maps{"A:179"} = { bbox => [[603000, 133000], [643000, 173000]], area => '1600', series => 'A', number => '179', parent => 'A:179', title => 'Canterbury & East Kent (Dover & Margate)', polygon => [[603000,133000],[643000,133000],[643000,173000],[603000,173000],[603000,133000]] };
$maps{"A:180"} = { bbox => [[239600, 112000], [280000, 152000]], area => '1600.3', series => 'A', number => '180', parent => 'A:180', title => 'Barnstaple & Ilfracombe (Lynton & Bideford)', polygon => [[240000,112000],[280000,112000],[280000,152000],[240000,152000],[240000,128000],[239600,127800],[239600,127300],[240000,127000],[240000,112000]] };
$maps{"A:180.a"} = { bbox => [[212000, 143000], [215500, 149000]], area => '21', series => 'A', number => '180', parent => 'A:180', title => 'Barnstaple & Ilfracombe (Lynton & Bideford)', polygon => [[212000,143000],[215500,143000],[215500,149000],[212000,149000],[212000,143000]] };
$maps{"A:181"} = { bbox => [[280000, 112000], [320000, 152000]], area => '1600', series => 'A', number => '181', parent => 'A:181', title => 'Minehead & Brendon Hills (Dulverton & Tiverton)', polygon => [[280000,112000],[320000,112000],[320000,152000],[280000,152000],[280000,112000]] };
$maps{"A:182"} = { bbox => [[320000, 130000], [360000, 170800]], area => '1601.14', series => 'A', number => '182', parent => 'A:182', title => 'Weston-super-Mare (Bridgwater & Wells)', polygon => [[320000,130000],[360000,130000],[360000,170000],[339600,170000],[339350,170500],[338800,170800],[337000,170000],[320000,170000],[320000,130000]] };
$maps{"A:183"} = { bbox => [[349000, 115000], [389000, 155500]], area => '1602.75', series => 'A', number => '183', parent => 'A:183', title => 'Yeovil & Frome (Shaftesbury & Shepton Mallet)', polygon => [[349000,115000],[389000,115000],[389000,155000],[371000,155000],[370000,155500],[366000,155500],[364000,155000],[349000,155000],[349000,115000]] };
$maps{"A:184"} = { bbox => [[389000, 115000], [429000, 155000]], area => '1600', series => 'A', number => '184', parent => 'A:184', title => 'Salisbury & The Plain (Amesbury)', polygon => [[389000,115000],[429000,115000],[429000,155000],[389000,155000],[389000,115000]] };
$maps{"A:185"} = { bbox => [[429000, 116000], [469000, 156000]], area => '1600', series => 'A', number => '185', parent => 'A:185', title => 'Winchester & Basingstoke (Andover & Romsey)', polygon => [[429000,116000],[469000,116000],[469000,156000],[429000,156000],[429000,116000]] };
$maps{"A:186"} = { bbox => [[465000, 125000], [505000, 165000]], area => '1600', series => 'A', number => '186', parent => 'A:186', title => 'Aldershot & Guildford (Camberley & Haslemere)', polygon => [[465000,125000],[505000,125000],[505000,165000],[465000,165000],[465000,125000]] };
$maps{"A:187"} = { bbox => [[505000, 125000], [545000, 165000]], area => '1600', series => 'A', number => '187', parent => 'A:187', title => 'Dorking & Reigate (Crawley & Horsham)', polygon => [[505000,125000],[545000,125000],[545000,165000],[505000,165000],[505000,125000]] };
$maps{"A:188"} = { bbox => [[545000, 125000], [585000, 165000]], area => '1600', series => 'A', number => '188', parent => 'A:188', title => 'Maidstone & Royal Tunbridge Wells (Sevenoaks & Tonbridge)', polygon => [[545000,125000],[585000,125000],[585000,165000],[545000,165000],[545000,125000]] };
$maps{"A:189"} = { bbox => [[585000, 113900], [625000, 155000]], area => '1601.24625', series => 'A', number => '189', parent => 'A:189', title => 'Ashford & Romney Marsh (Rye & Folkestone)', polygon => [[585000,115000],[590000,115000],[590000,114900],[589650,114550],[589650,114000],[589750,113900],[590300,113900],[591450,115000],[625000,115000],[625000,155000],[585000,155000],[585000,115000]] };
$maps{"A:190"} = { bbox => [[207000, 87000], [247000, 128150]], area => '1607.0725', series => 'A', number => '190', parent => 'A:190', title => 'Bude & Clovelly (Boscastle & Holsworthy)', polygon => [[207000,87000],[247000,87000],[247000,127000],[230000,127000],[227000,128150],[223000,128150],[221700,127000],[207000,127000],[207000,87000]] };
$maps{"A:191"} = { bbox => [[247000, 72000], [287000, 112000]], area => '1600', series => 'A', number => '191', parent => 'A:191', title => 'Okehampton & North Dartmoor (Crediton & Bovey Tracey)', polygon => [[247000,72000],[287000,72000],[287000,112000],[247000,112000],[247000,72000]] };
$maps{"A:192"} = { bbox => [[287000, 72000], [327000, 112000]], area => '1600', series => 'A', number => '192', parent => 'A:192', title => 'Exeter & Sidmouth (Exmouth & Teignmouth)', polygon => [[287000,72000],[327000,72000],[327000,112000],[287000,112000],[287000,72000]] };
$maps{"A:193"} = { bbox => [[310000, 88500], [350000, 130000]], area => '1609.15', series => 'A', number => '193', parent => 'A:193', title => 'Taunton & Lyme Regis (Chard & Bridport)', polygon => [[310000,90000],[323000,90000],[323500,89500],[325000,89500],[328000,89000],[330000,89500],[331000,89500],[331600,90000],[346000,90000],[348600,88500],[349300,88500],[350000,89000],[350000,130000],[310000,130000],[310000,90000]] };
$maps{"A:194"} = { bbox => [[349000, 75000], [389000, 115000]], area => '1600', series => 'A', number => '194', parent => 'A:194', title => 'Dorchester & Weymouth (Cerne Abbas & Bere Regis)', polygon => [[349000,75000],[389000,75000],[389000,115000],[349000,115000],[349000,75000]] };
$maps{"A:194.a"} = { bbox => [[365150, 68150], [371000, 78200]], area => '57.04875', series => 'A', number => '194', parent => 'A:194', title => 'Dorchester & Weymouth (Cerne Abbas & Bere Regis)', polygon => [[365150,68150],[371000,68150],[371000,76650],[368750,78200],[365150,78200],[365150,68150]] };
$maps{"A:195"} = { bbox => [[389000, 75000], [429500, 115000]], area => '1600.6', series => 'A', number => '195', parent => 'A:195', title => 'Bournemouth & Purbeck (Wimborne Minster & Ringwood)', polygon => [[389000,75000],[429000,75000],[429000,84000],[429400,84500],[429500,85000],[429300,85500],[429000,86000],[429000,115000],[389000,115000],[389000,75000]] };
$maps{"A:196"} = { bbox => [[428300, 74800], [469000, 116000]], area => '1606.28', series => 'A', number => '196', parent => 'A:196', title => 'The Solent & Isle of Wight (Southampton & Portsmouth)', polygon => [[429000,76000],[447300,76000],[449700,74800],[451000,74800],[455300,76000],[469000,76000],[469000,116000],[429000,116000],[429000,86000],[428300,85000],[429000,84000],[429000,76000]] };
$maps{"A:197"} = { bbox => [[468400, 90000], [509000, 130000]], area => '1601.63', series => 'A', number => '197', parent => 'A:197', title => 'Chichester & The South Downs (Bognor Regis & Arundel)', polygon => [[469000,90000],[509000,90000],[509000,130000],[469000,130000],[469000,102500],[468400,101400],[468600,99000],[469000,98500],[469000,90000]] };
$maps{"A:198"} = { bbox => [[509000, 97000], [549000, 137000]], area => '1600', series => 'A', number => '198', parent => 'A:198', title => 'Brighton & Lewes (Worthing, Horsham & Haywards Heath)', polygon => [[509000,97000],[549000,97000],[549000,137000],[509000,137000],[509000,97000]] };
$maps{"A:199"} = { bbox => [[549000, 94000], [590000, 134000]], area => '1602.445', series => 'A', number => '199', parent => 'A:199', title => 'Eastbourne & Hastings (Crowborough, Battle & Heathfield)', polygon => [[549000,94000],[589000,94000],[589000,112650],[589400,112800],[589600,113000],[590000,113400],[590000,115000],[589600,115400],[589000,115650],[589000,134000],[549000,134000],[549000,94000]] };
$maps{"A:200"} = { bbox => [[175000, 49000], [215000, 90250]], area => '1603.2925', series => 'A', number => '200', parent => 'A:200', title => 'Newquay & Bodmin (Camelford & St Austell)', polygon => [[175000,50000],[207900,50000],[208600,49000],[210800,49000],[211800,50000],[215000,50000],[215000,90000],[206800,90000],[206100,90250],[205500,90200],[205300,90000],[175000,90000],[175000,50000]] };
$maps{"A:201"} = { bbox => [[213100, 45200], [255000, 87000]], area => '1609.03', series => 'A', number => '201', parent => 'A:201', title => 'Plymouth & Launceston (Tavistock & Looe)', polygon => [[215000,47000],[251600,47000],[252800,46000],[254000,45300],[254500,45200],[255000,45300],[255000,87000],[215000,87000],[215000,52700],[213100,52700],[213100,50200],[213800,50000],[215000,50000],[215000,47000]] };
$maps{"A:201.a"} = { bbox => [[238000, 32000], [240000, 34000]], area => '4', series => 'A', number => '201', parent => 'A:201', title => 'Plymouth & Launceston (Tavistock & Looe)', polygon => [[238000,32000],[240000,32000],[240000,34000],[238000,34000],[238000,32000]] };
$maps{"A:202"} = { bbox => [[255000, 32000], [296000, 72800]], area => '1605.995', series => 'A', number => '202', parent => 'A:202', title => 'Torbay & South Dartmoor (Totnes & Salcombe)', polygon => [[255000,32000],[295000,32000],[295000,62350],[296000,63000],[296000,64000],[295000,64500],[295000,72000],[294800,72000],[293800,72800],[289700,72700],[287000,72000],[255000,72000],[255000,32000]] };
$maps{"A:203"} = { bbox => [[132000, 11000], [172000, 51000]], area => '1600', series => 'A', number => '203', parent => 'A:203', title => 'Land’s End & Isles of Scilly (St Ives & Lizard Point)', polygon => [[132000,11000],[172000,11000],[172000,51000],[132000,51000],[132000,11000]] };
$maps{"A:203.a"} = { bbox => [[80000, 5000], [96000, 18250]], area => '184.17125', series => 'A', number => '203', parent => 'A:203', title => 'Land’s End & Isles of Scilly (St Ives & Lizard Point)', polygon => [[80000,5000],[96000,5000],[96000,18250],[86150,18250],[80000,9200],[80000,5000]] };
$maps{"A:203.b"} = { bbox => [[169000, 50000], [176000, 55000]], area => '35', series => 'A', number => '203', parent => 'A:203', title => 'Land’s End & Isles of Scilly (St Ives & Lizard Point)', polygon => [[169000,50000],[176000,50000],[176000,55000],[169000,55000],[169000,50000]] };
$maps{"A:203.c"} = { bbox => [[126000, 11000], [128000, 13000]], area => '4', series => 'A', number => '203', parent => 'A:203', title => 'Land’s End & Isles of Scilly (St Ives & Lizard Point)', polygon => [[126000,11000],[128000,11000],[128000,13000],[126000,13000],[126000,11000]] };
$maps{"A:204"} = { bbox => [[171600, 14000], [214450, 55000]], area => '1609.333', series => 'A', number => '204', parent => 'A:204', title => 'Truro & Falmouth (Roseland Peninsula)', polygon => [[172000,14000],[212000,14000],[212000,49650],[212300,50000],[214100,50000],[214450,50400],[214450,52500],[214380,52700],[212250,52700],[212000,53000],[212000,54000],[177000,54000],[177000,54200],[176300,55000],[175000,55000],[173600,54000],[172000,54000],[172000,51300],[171700,50650],[171600,50400],[172000,49900],[172000,14000]] };
$maps{"B:101"} = { bbox => [[80000, 3000], [97000, 19000]], area => '206', series => 'B', number => '101', parent => 'B:101', title => 'Isles of Scilly', polygon => [[80000,3000],[94000,3000],[94000,13000],[97000,13000],[97000,19000],[84000,19000],[84000,10000],[80000,10000],[80000,3000]] };
$maps{"B:102"} = { bbox => [[131000, 21200], [161000, 43900]], area => '601.4', series => 'B', number => '102', parent => 'B:102', title => 'Land’s End (Penzance & St Ives)', polygon => [[131000,21500],[136000,21500],[136200,21200],[137600,21200],[137800,21500],[161000,21500],[161000,43500],[159800,43500],[159600,43900],[157500,43900],[157300,43500],[141000,43500],[141000,37500],[131000,37500],[131000,21500]] };
$maps{"B:103"} = { bbox => [[161000, 10000], [183000, 37000]], area => '594', series => 'B', number => '103', parent => 'B:103', title => 'The Lizard (Falmouth & Helston)', polygon => [[161000,10000],[183000,10000],[183000,37000],[161000,37000],[161000,10000]] };
$maps{"B:104"} = { bbox => [[161000, 33300], [183000, 64000]], area => '595.47', series => 'B', number => '104', parent => 'B:104', title => 'Redruth & St Agnes (Camborne & Perranporth)', polygon => [[161000,34000],[180300,34000],[180400,33300],[182400,33300],[182500,34000],[183000,34000],[183000,64000],[167000,64000],[167000,53000],[161000,53000],[161000,34000]] };
$maps{"B:105"} = { bbox => [[175000, 30000], [205000, 52000]], area => '600', series => 'B', number => '105', parent => 'B:105', title => 'Falmouth & Mevagissey (Truro & St Mawes)', polygon => [[175000,30000],[195000,30000],[195000,36000],[205000,36000],[205000,52000],[175000,52000],[175000,30000]] };
$maps{"B:106"} = { bbox => [[179400, 52000], [202500, 82000]], area => '599.06', series => 'B', number => '106', parent => 'B:106', title => 'Newquay & Padstow (Wadebridge, Port Isaac & St Columb Major)', polygon => [[180500,52000],[202500,52000],[202500,82000],[187000,82000],[187000,77000],[183000,77000],[183000,65000],[180500,65000],[180500,63300],[179400,63300],[180000,61600],[180500,60800],[180500,52000]] };
$maps{"B:107"} = { bbox => [[200000, 47700], [230000, 68000]], area => '600.27', series => 'B', number => '107', parent => 'B:107', title => 'St Austell & Liskeard (Fowey, Looe & Lostwithiel)', polygon => [[200000,48000],[203300,48000],[203400,47700],[204200,47700],[204300,48000],[230000,48000],[230000,68000],[200000,68000],[200000,48000]] };
$maps{"B:108"} = { bbox => [[230000, 48000], [252250, 78000]], area => '602.5', series => 'B', number => '108', parent => 'B:108', title => 'Lower Tamar Valley & Plymouth (Tavistock & Callington)', polygon => [[230000,50000],[240000,50000],[240000,48000],[252250,48000],[252250,58000],[250000,58000],[250000,78000],[230000,78000],[230000,50000]] };
$maps{"B:109"} = { bbox => [[202500, 63500], [230000, 86000]], area => '606.525', series => 'B', number => '109', parent => 'B:109', title => 'Bodmin Moor (Bodmin, Camelford & Liskeard)', polygon => [[202500,64000],[223100,64000],[223400,63500],[226100,63500],[226500,64000],[230000,64000],[230000,86000],[202500,86000],[202500,64000]] };
$maps{"B:110/OL44"} = { bbox => [[278000, 60000], [300000, 90000]], area => '604', series => 'B', number => '110/OL44', parent => 'B:110/OL44', title => 'Torquay & Dawlish (Newton Abbot)', polygon => [[278000,60000],[296500,60000],[296500,76000],[300000,76000],[300000,90000],[278000,90000],[278000,60000]] };
$maps{"B:111"} = { bbox => [[202000, 86000], [232000, 108000]], area => '600', series => 'B', number => '111', parent => 'B:111', title => 'Bude, Boscastle & Tintagel', polygon => [[202000,86000],[232000,86000],[232000,108000],[212000,108000],[212000,102000],[202000,102000],[202000,86000]] };
$maps{"B:111.a"} = { bbox => [[201000, 81000], [206000, 87000]], area => '30', series => 'B', number => '111', parent => 'B:111', title => 'Bude, Boscastle & Tintagel', polygon => [[201000,81000],[206000,81000],[206000,87000],[201000,87000],[201000,81000]] };
$maps{"B:112"} = { bbox => [[228500, 78000], [251000, 108000]], area => '594.775', series => 'B', number => '112', parent => 'B:112', title => 'Launceston & Holsworthy (Roadford Lake)', polygon => [[228500,78000],[250500,78000],[250500,83300],[251000,84000],[251000,85000],[250500,85400],[250500,108000],[231500,108000],[231500,86000],[228500,86000],[228500,78000]] };
$maps{"B:113"} = { bbox => [[250000, 90000], [280000, 110000]], area => '600', series => 'B', number => '113', parent => 'B:113', title => 'Okehampton (Hatherleigh, North Tawton & Lapford)', polygon => [[250000,90000],[280000,90000],[280000,110000],[250000,110000],[250000,90000]] };
$maps{"B:114S"} = { bbox => [[280000, 87000], [300000, 107000]], area => '400', series => 'B', number => '114', parent => 'B:114S', title => 'Exeter & the Exe Valley (Crediton, Tiverton & Dulverton)', polygon => [[280000,87000],[300000,87000],[300000,107000],[280000,107000],[280000,87000]] };
$maps{"B:114N"} = { bbox => [[280000, 107000], [300000, 130000]], area => '460', series => 'B', number => '114', parent => 'B:114N', title => 'Exeter & the Exe Valley (Crediton, Tiverton & Dulverton)', polygon => [[280000,107000],[300000,107000],[300000,130000],[280000,130000],[280000,107000]] };
$maps{"B:115"} = { bbox => [[298400, 79300], [321000, 110000]], area => '604.09', series => 'B', number => '115', parent => 'B:115', title => 'Exmouth & Sidmouth (Honiton)', polygon => [[299000,80000],[299900,80000],[301000,79300],[304100,79300],[304400,80000],[311000,80000],[311000,86000],[321000,86000],[321000,110000],[299000,110000],[299000,94000],[298600,93500],[299000,92700],[299000,85900],[298400,85500],[298400,84000],[299000,83500],[299000,80000]] };
$maps{"B:116"} = { bbox => [[321000, 87800], [349000, 110000]], area => '598.29', series => 'B', number => '116', parent => 'B:116', title => 'Lyme Regis & Bridport (Chard)', polygon => [[321000,88000],[322000,87800],[322900,87800],[323000,88000],[335000,88000],[335000,91000],[341000,91000],[341000,88000],[349000,88000],[349000,110000],[321000,110000],[321000,88000]] };
$maps{"B:117W"} = { bbox => [[347000, 90000], [370000, 110000]], area => '460', series => 'B', number => '117', parent => 'B:117W', title => 'Cerne Abbas & Bere Regis (Blandford Forum & Beaminster)', polygon => [[347000,90000],[370000,90000],[370000,110000],[347000,110000],[347000,90000]] };
$maps{"B:117E"} = { bbox => [[370000, 90000], [390000, 110000]], area => '400', series => 'B', number => '117', parent => 'B:117E', title => 'Cerne Abbas & Bere Regis (Blandford Forum & Beaminster)', polygon => [[370000,90000],[390000,90000],[390000,110000],[370000,110000],[370000,90000]] };
$maps{"B:118N"} = { bbox => [[383000, 110000], [406000, 130000]], area => '460', series => 'B', number => '118', parent => 'B:118N', title => 'Shaftesbury & Cranborne Chase (Poole, Wimborne Minster & Blandford Forum)', polygon => [[383000,110000],[406000,110000],[406000,130000],[383000,130000],[383000,110000]] };
$maps{"B:118S"} = { bbox => [[386000, 89600], [406000, 110000]], area => '401.2', series => 'B', number => '118', parent => 'B:118S', title => 'Shaftesbury & Cranborne Chase (Poole, Wimborne Minster & Blandford Forum)', polygon => [[386000,90000],[398000,90000],[400000,89600],[401000,89600],[403000,90000],[406000,90000],[406000,110000],[386000,110000],[386000,90000]] };
$maps{"B:119/OL3"} = { bbox => [[447600, 97000], [470000, 125000]], area => '600.2', series => 'B', number => '119/OL3', parent => 'B:119/OL3', title => 'Meon Valley (Portsmouth, Gosport & Fareham)', polygon => [[448000,99000],[456000,99000],[456000,97000],[470000,97000],[470000,125000],[448000,125000],[448000,101700],[447600,101700],[447600,101300],[448000,101100],[448000,99000]] };
$maps{"B:120/OL8"} = { bbox => [[468000, 92000], [490000, 122000]], area => '597', series => 'B', number => '120/OL8', parent => 'B:120/OL8', title => 'Chichester (South Harting & Selsey)', polygon => [[468000,97000],[477000,97000],[483000,93000],[483000,92000],[490000,92000],[490000,122000],[468000,122000],[468000,97000]] };
$maps{"B:121/OL10"} = { bbox => [[490000, 97600], [517000, 120000]], area => '595.68', series => 'B', number => '121/OL10', parent => 'B:121/OL10', title => 'Arundel & Pulborough (Worthing & Bognor Regis)', polygon => [[490000,98000],[490000,97600],[494200,97600],[494200,98000],[517000,98000],[517000,120000],[490000,120000],[490000,98000]] };
$maps{"B:122/OL11"} = { bbox => [[517000, 99000], [547000, 121000]], area => '600', series => 'B', number => '122/OL11', parent => 'B:122/OL11', title => 'Brighton & Hove (Lewes & Burgess Hill)', polygon => [[517000,102000],[537000,102000],[537000,99000],[547000,99000],[547000,121000],[517000,121000],[517000,102000]] };
$maps{"B:123/OL25"} = { bbox => [[542700, 95000], [565000, 122000]], area => '594.78', series => 'B', number => '123/OL25', parent => 'B:123/OL25', title => 'Eastbourne & Beachy Head (Newhaven, Seaford, Hailsham & Heathfield)', polygon => [[543000,95000],[565000,95000],[565000,122000],[543000,122000],[543000,106000],[542700,106000],[542700,103400],[543000,103400],[543000,95000]] };
$maps{"B:124"} = { bbox => [[561000, 102000], [591000, 124000]], area => '600', series => 'B', number => '124', parent => 'B:124', title => 'Hastings & Bexhill (Battle & Robertsbridge)', polygon => [[561000,102000],[581000,102000],[581000,108000],[591000,108000],[591000,124000],[561000,124000],[561000,102000]] };
$maps{"B:125"} = { bbox => [[580000, 115000], [610400, 135000]], area => '600.58', series => 'B', number => '125', parent => 'B:125', title => 'Romney Marsh, Rye & Winchelsea (Tenterden & New Romney)', polygon => [[580000,115000],[610000,115000],[610000,128100],[610400,128699],[610400,129699],[610000,130000],[610000,135000],[580000,135000],[580000,115000]] };
$maps{"B:126"} = { bbox => [[219300, 108000], [250000, 128000]], area => '604.745', series => 'B', number => '126', parent => 'B:126', title => 'Clovelly & Hartland (Bideford & Bradworthy)', polygon => [[220000,108000],[250000,108000],[250000,128000],[220000,128000],[220000,116900],[219300,116000],[219300,112300],[219600,111500],[219600,108000],[220000,108000]] };
$maps{"B:127"} = { bbox => [[249400, 110000], [280000, 130000]], area => '600.9', series => 'B', number => '127', parent => 'B:127', title => 'South Molton & Chulmleigh (King’s Nympton, Chittlehampton & Dolton)', polygon => [[250000,110000],[280000,110000],[280000,130000],[250000,130000],[250000,120000],[249400,119500],[249400,118500],[250000,118000],[250000,110000]] };
$maps{"B:128E"} = { bbox => [[320000, 110000], [340000, 130000]], area => '400', series => 'B', number => '128', parent => 'B:128E', title => 'Taunton & Blackdown Hills (Wellington & Ilminster)', polygon => [[320000,110000],[340000,110000],[340000,130000],[320000,130000],[320000,110000]] };
$maps{"B:128W"} = { bbox => [[300000, 107000], [320000, 130000]], area => '460', series => 'B', number => '128', parent => 'B:128W', title => 'Taunton & Blackdown Hills (Wellington & Ilminster)', polygon => [[300000,107000],[320000,107000],[320000,130000],[300000,130000],[300000,107000]] };
$maps{"B:129W"} = { bbox => [[340000, 110000], [360000, 130000]], area => '400', series => 'B', number => '129', parent => 'B:129W', title => 'Yeovil & Sherborne (Somerton & Wincanton)', polygon => [[340000,110000],[360000,110000],[360000,130000],[340000,130000],[340000,110000]] };
$maps{"B:129E"} = { bbox => [[360000, 110000], [383000, 130000]], area => '460', series => 'B', number => '129', parent => 'B:129E', title => 'Yeovil & Sherborne (Somerton & Wincanton)', polygon => [[360000,110000],[383000,110000],[383000,130000],[360000,130000],[360000,110000]] };
$maps{"B:130S"} = { bbox => [[400000, 120000], [420000, 140000]], area => '400', series => 'B', number => '130', parent => 'B:130S', title => 'Salisbury & Stonehenge (Milton & Market Lavington)', polygon => [[400000,120000],[420000,120000],[420000,140000],[400000,140000],[400000,120000]] };
$maps{"B:130N"} = { bbox => [[397000, 140000], [420000, 160000]], area => '460', series => 'B', number => '130', parent => 'B:130N', title => 'Salisbury & Stonehenge (Milton & Market Lavington)', polygon => [[397000,140000],[420000,140000],[420000,160000],[397000,160000],[397000,140000]] };
$maps{"B:131S"} = { bbox => [[420000, 120000], [440000, 140000]], area => '400', series => 'B', number => '131', parent => 'B:131S', title => 'Romsey, Andover & Test Valley (Stockbridge & Ludgershall)', polygon => [[420000,120000],[440000,120000],[440000,140000],[420000,140000],[420000,120000]] };
$maps{"B:131N"} = { bbox => [[420000, 140000], [440000, 160000]], area => '400', series => 'B', number => '131', parent => 'B:131N', title => 'Romsey, Andover & Test Valley (Stockbridge & Ludgershall)', polygon => [[420000,140000],[440000,140000],[440000,160000],[420000,160000],[420000,140000]] };
$maps{"B:132/OL32"} = { bbox => [[440000, 120000], [470000, 140000]], area => '600', series => 'B', number => '132/OL32', parent => 'B:132/OL32', title => 'Winchester (New Alresford & East Meon)', polygon => [[440000,120000],[470000,120000],[470000,140000],[440000,140000],[440000,120000]] };
$maps{"B:133/OL33"} = { bbox => [[470000, 120000], [500000, 140000]], area => '600', series => 'B', number => '133/OL33', parent => 'B:133/OL33', title => 'Haslemere & Petersfield (Midhurst & Selbourne)', polygon => [[470000,120000],[500000,120000],[500000,140000],[470000,140000],[470000,120000]] };
$maps{"B:134/OL34"} = { bbox => [[500000, 120000], [530000, 140000]], area => '600', series => 'B', number => '134/OL34', parent => 'B:134/OL34', title => 'Crawley & Horsham (Cranleigh & Billingshurst)', polygon => [[500000,120000],[530000,120000],[530000,140000],[500000,140000],[500000,120000]] };
$maps{"B:135"} = { bbox => [[530000, 120000], [560000, 140000]], area => '600', series => 'B', number => '135', parent => 'B:135', title => 'Ashdown Forest (Royal Tunbridge Wells, East Grinstead, Haywards Heath & Crowborough)', polygon => [[530000,120000],[560000,120000],[560000,140000],[530000,140000],[530000,120000]] };
$maps{"B:136"} = { bbox => [[557700, 122000], [580000, 150000]], area => '599.54', series => 'B', number => '136', parent => 'B:136', title => 'High Weald (Royal Tunbridge Wells, Cranbrook, Hawkhurst & Bewl Water)', polygon => [[558000,122000],[563000,122000],[563000,123000],[580000,123000],[580000,150000],[558000,150000],[558000,140900],[557700,139300],[558000,137300],[558000,122000]] };
$maps{"B:137"} = { bbox => [[580000, 135000], [610000, 155000]], area => '600', series => 'B', number => '137', parent => 'B:137', title => 'Ashford (Headcorn, Chilham & Wye)', polygon => [[580000,135000],[610000,135000],[610000,155000],[580000,155000],[580000,135000]] };
$maps{"B:138"} = { bbox => [[609000, 129000], [639000, 151000]], area => '591', series => 'B', number => '138', parent => 'B:138', title => 'Dover, Folkestone & Hythe', polygon => [[609000,129000],[616000,129000],[616000,132000],[639000,132000],[639000,151000],[609000,151000],[609000,129000]] };
$maps{"B:139"} = { bbox => [[238000, 120000], [260000, 150000]], area => '596.5', series => 'B', number => '139', parent => 'B:139', title => 'Bideford, Ilfracombe & Barnstaple (Woolacombe & Lundy)', polygon => [[238000,120000],[260000,120000],[260000,150000],[249000,150000],[249000,148000],[243000,148000],[243000,143000],[241000,143000],[241000,137500],[238000,137500],[238000,120000]] };
$maps{"B:139.a"} = { bbox => [[212500, 143000], [215000, 148500]], area => '13.75', series => 'B', number => '139', parent => 'B:139', title => 'Bideford, Ilfracombe & Barnstaple (Woolacombe & Lundy)', polygon => [[212500,143000],[215000,143000],[215000,148500],[212500,148500],[212500,143000]] };
$maps{"B:140"} = { bbox => [[310000, 128000], [340000, 150000]], area => '600.36', series => 'B', number => '140', parent => 'B:140', title => 'Quantock Hills & Bridgwater', polygon => [[310000,128000],[340000,128000],[340000,150000],[330000,150000],[330000,147000],[329200,147000],[329000,147300],[328000,147300],[327800,147000],[310000,147000],[310000,128000]] };
$maps{"B:141"} = { bbox => [[340000, 130000], [360000, 160000]], area => '600', series => 'B', number => '141', parent => 'B:141', title => 'Cheddar Gorge & Mendip Hills West (Wells & Glastonbury)', polygon => [[340000,130000],[360000,130000],[360000,160000],[340000,160000],[340000,130000]] };
$maps{"B:142"} = { bbox => [[360000, 130000], [380000, 160000]], area => '600', series => 'B', number => '142', parent => 'B:142', title => 'Shepton Mallet & Mendip Hills East (Frome & Midsomer Norton)', polygon => [[360000,130000],[380000,130000],[380000,160000],[360000,160000],[360000,130000]] };
$maps{"B:143"} = { bbox => [[380000, 130000], [400000, 160000]], area => '600', series => 'B', number => '143', parent => 'B:143', title => 'Warminster & Trowbridge (Westbury & Mere)', polygon => [[380000,130000],[400000,130000],[400000,160000],[380000,160000],[380000,130000]] };
$maps{"B:144E"} = { bbox => [[460000, 137000], [480000, 160000]], area => '460', series => 'B', number => '144', parent => 'B:144E', title => 'Basingstoke, Alton & Whitchurch (Odiham, Overton & Hook)', polygon => [[460000,137000],[480000,137000],[480000,160000],[460000,160000],[460000,137000]] };
$maps{"B:144W"} = { bbox => [[440000, 140000], [460000, 160000]], area => '400', series => 'B', number => '144', parent => 'B:144W', title => 'Basingstoke, Alton & Whitchurch (Odiham, Overton & Hook)', polygon => [[440000,140000],[460000,140000],[460000,160000],[440000,160000],[440000,140000]] };
$maps{"B:145"} = { bbox => [[480000, 140000], [510000, 160000]], area => '600', series => 'B', number => '145', parent => 'B:145', title => 'Guildford & Farnham (Godalming & Farnborough)', polygon => [[480000,140000],[510000,140000],[510000,160000],[480000,160000],[480000,140000]] };
$maps{"B:146"} = { bbox => [[510000, 140000], [540000, 160000]], area => '600', series => 'B', number => '146', parent => 'B:146', title => 'Dorking, Box Hill & Reigate (Leatherhead & Caterham)', polygon => [[510000,140000],[540000,140000],[540000,160000],[510000,160000],[510000,140000]] };
$maps{"B:147"} = { bbox => [[540000, 138000], [562000, 165000]], area => '594', series => 'B', number => '147', parent => 'B:147', title => 'Sevenoaks & Tonbridge (Royal Tunbridge Wells & Westerham)', polygon => [[540000,138000],[562000,138000],[562000,165000],[540000,165000],[540000,138000]] };
$maps{"B:148"} = { bbox => [[560000, 150000], [590000, 170000]], area => '600', series => 'B', number => '148', parent => 'B:148', title => 'Maidstone & the Medway Towns', polygon => [[560000,150000],[590000,150000],[590000,170000],[560000,170000],[560000,150000]] };
$maps{"B:149"} = { bbox => [[588000, 150000], [610000, 177000]], area => '594', series => 'B', number => '149', parent => 'B:149', title => 'Sittingbourne & Faversham (Isle of Sheppey)', polygon => [[588000,150000],[610000,150000],[610000,177000],[588000,177000],[588000,150000]] };
$maps{"B:150"} = { bbox => [[610000, 151000], [640400, 173000]], area => '597.41', series => 'B', number => '150', parent => 'B:150', title => 'Canterbury & The Isle of Thanet (Herne Bay, Deal & Whitstable)', polygon => [[610000,151000],[640000,151000],[640000,166750],[640400,167500],[640400,170300],[640000,171000],[640000,173000],[633000,173000],[633000,171000],[628000,171000],[628000,170000],[610000,170000],[610000,151000]] };
$maps{"B:151W"} = { bbox => [[278000, 166000], [301000, 186000]], area => '391.75', series => 'B', number => '151', parent => 'B:151W', title => 'Cardiff & Bridgend / Caerdydd a Phen-y-bont ar Ogwr (Vale of Glamorgan / Bro Morgannwg)', polygon => [[278000,172500],[288500,172500],[288500,166000],[301000,166000],[301000,186000],[278000,186000],[278000,172500]] };
$maps{"B:151E"} = { bbox => [[301000, 165200], [324000, 186000]], area => '463.75625', series => 'B', number => '151', parent => 'B:151E', title => 'Cardiff & Bridgend / Caerdydd a Phen-y-bont ar Ogwr (Vale of Glamorgan / Bro Morgannwg)', polygon => [[301000,166000],[301200,166000],[301350,165900],[301800,165400],[302000,165250],[302200,165200],[302500,165300],[303000,165300],[303200,165300],[303500,165400],[304000,165400],[304500,165500],[305000,165550],[305300,165600],[305500,165600],[306000,165500],[306300,165400],[306600,165300],[307000,165350],[307500,165650],[307950,166000],[310000,166000],[310200,165800],[310400,165800],[310600,166000],[310800,166000],[311000,165750],[311100,165700],[311200,165750],[311300,165850],[311400,166000],[324000,166000],[324000,186000],[301000,186000],[301000,166000]] };
$maps{"B:151E.a"} = { bbox => [[320250, 164250], [322750, 165750]], area => '3.75', series => 'B', number => '151', parent => 'B:151E', title => 'Cardiff & Bridgend / Caerdydd a Phen-y-bont ar Ogwr (Vale of Glamorgan / Bro Morgannwg)', polygon => [[320250,164250],[322750,164250],[322750,165750],[320250,165750],[320250,164250]] };
$maps{"B:152"} = { bbox => [[320000, 176000], [342000, 206000]], area => '597.5', series => 'B', number => '152', parent => 'B:152', title => 'Newport & Pontypool / Casnewydd a Pont-y-pŵl', polygon => [[320000,176000],[329500,176000],[329500,181000],[342000,181000],[342000,206000],[320000,206000],[320000,176000]] };
$maps{"B:153"} = { bbox => [[320000, 143000], [342000, 173000]], area => '600', series => 'B', number => '153', parent => 'B:153', title => 'Weston-super-Mare & Bleadon Hill (Burnham-on-Sea & Clevedon)', polygon => [[320000,143000],[342000,143000],[342000,173000],[330000,173000],[330000,167000],[320000,167000],[320000,143000]] };
$maps{"B:154"} = { bbox => [[340000, 160000], [360000, 190000]], area => '600', series => 'B', number => '154', parent => 'B:154', title => 'Bristol West & Portishead (Congresbury & Chew Magna)', polygon => [[340000,160000],[360000,160000],[360000,190000],[340000,190000],[340000,160000]] };
$maps{"B:155"} = { bbox => [[352400, 160000], [380000, 182000]], area => '594.54', series => 'B', number => '155', parent => 'B:155', title => 'Bristol & Bath (Keynsham & Marshfield)', polygon => [[353000,160000],[380000,160000],[380000,182000],[353000,182000],[353000,176800],[352400,176000],[353000,175000],[353000,160000]] };
$maps{"B:156"} = { bbox => [[380000, 153000], [400000, 183000]], area => '600', series => 'B', number => '156', parent => 'B:156', title => 'Chippenham & Bradford-on-Avon (Trowbridge & Melksham)', polygon => [[380000,153000],[400000,153000],[400000,183000],[380000,183000],[380000,153000]] };
$maps{"B:157"} = { bbox => [[399400, 159600], [430000, 180000]], area => '602.335', series => 'B', number => '157', parent => 'B:157', title => 'Marlborough & Savernake Forest (Avebury & Devizes)', polygon => [[400000,160000],[415700,160000],[415700,159600],[417300,159600],[417300,160000],[430000,160000],[430000,180000],[400000,180000],[400000,172700],[399400,172300],[399400,170400],[400000,170000],[400000,162000],[399700,162000],[399700,161000],[400000,160900],[400000,160000]] };
$maps{"B:158"} = { bbox => [[428000, 160000], [458000, 180000]], area => '600', series => 'B', number => '158', parent => 'B:158', title => 'Newbury & Hungerford (Lambourn & Kintbury)', polygon => [[428000,160000],[458000,160000],[458000,180000],[428000,180000],[428000,160000]] };
$maps{"B:159"} = { bbox => [[455000, 160000], [485000, 180000]], area => '600', series => 'B', number => '159', parent => 'B:159', title => 'Reading, Wokingham & Pangbourne', polygon => [[455000,160000],[485000,160000],[485000,180000],[455000,180000],[455000,160000]] };
$maps{"B:160"} = { bbox => [[480000, 160000], [510000, 180000]], area => '600', series => 'B', number => '160', parent => 'B:160', title => 'Windsor, Weybridge & Bracknell', polygon => [[480000,160000],[510000,160000],[510000,180000],[480000,180000],[480000,160000]] };
$maps{"B:161"} = { bbox => [[510000, 160000], [540000, 180630]], area => '601.005725', series => 'B', number => '161', parent => 'B:161', title => 'London South (Westminster, Greenwich, Croydon, Esher & Twickenham)', polygon => [[510000,160000],[540000,160000],[540000,180000],[539660,180000],[539500,180200],[539325,180350],[539120,180450],[539050,180450],[539000,180400],[538850,180300],[538750,180200],[538650,180000],[536800,180000],[536800,180160],[536750,180320],[536650,180470],[536500,180550],[536340,180620],[536150,180630],[536000,180620],[535850,180580],[535650,180450],[535240,180000],[510000,180000],[510000,160000]] };
$maps{"B:162"} = { bbox => [[536000, 165000], [566000, 185000]], area => '600', series => 'B', number => '162', parent => 'B:162', title => 'Greenwich & Gravesend (East End, Docklands, Bromley, Sidcup & Thurrock)', polygon => [[536000,165000],[566000,165000],[566000,185000],[536000,185000],[536000,165000]] };
$maps{"B:163"} = { bbox => [[563000, 162000], [590450, 184000]], area => '594.72', series => 'B', number => '163', parent => 'B:163', title => 'Gravesend & Rochester (Hoo Peninsula)', polygon => [[563000,162000],[590000,162000],[590000,175700],[590450,177000],[590400,177500],[590300,177900],[590000,178400],[590000,184000],[563000,184000],[563000,162000]] };
$maps{"B:164"} = { bbox => [[235000, 184000], [265000, 204000]], area => '600', series => 'B', number => '164', parent => 'B:164', title => 'Gower / Gŵyr (Llanelli)', polygon => [[235000,184000],[265000,184000],[265000,204000],[235000,204000],[235000,184000]] };
$maps{"B:165"} = { bbox => [[260000, 181000], [282000, 211000]], area => '595', series => 'B', number => '165', parent => 'B:165', title => 'Swansea / Abertawe (Neath / Castell Nedd & Port Talbot)', polygon => [[260000,186000],[273000,186000],[273000,181000],[282000,181000],[282000,211000],[260000,211000],[260000,186000]] };
$maps{"B:166E"} = { bbox => [[301000, 186000], [321000, 209000]], area => '460', series => 'B', number => '166', parent => 'B:166E', title => 'Rhondda & Merthyr Tydfil / Merthyr Tudful', polygon => [[301000,186000],[321000,186000],[321000,209000],[301000,209000],[301000,186000]] };
$maps{"B:166W"} = { bbox => [[281000, 186000], [301000, 206000]], area => '400', series => 'B', number => '166', parent => 'B:166W', title => 'Rhondda & Merthyr Tydfil / Merthyr Tudful', polygon => [[281000,186000],[301000,186000],[301000,206000],[281000,206000],[281000,186000]] };
$maps{"B:167"} = { bbox => [[353000, 181000], [380000, 203000]], area => '594', series => 'B', number => '167', parent => 'B:167', title => 'Thornbury, Dursley & Yate (Berkeley & Wotton-under-Edge)', polygon => [[353000,181000],[380000,181000],[380000,203000],[353000,203000],[353000,181000]] };
$maps{"B:168"} = { bbox => [[378000, 180000], [400000, 207000]], area => '594', series => 'B', number => '168', parent => 'B:168', title => 'Stroud, Tetbury & Malmesbury', polygon => [[378000,180000],[400000,180000],[400000,207000],[378000,207000],[378000,180000]] };
$maps{"B:169"} = { bbox => [[400000, 175000], [420000, 205000]], area => '600', series => 'B', number => '169', parent => 'B:169', title => 'Cirencester & Swindon (Fairford & Cricklade)', polygon => [[400000,175000],[420000,175000],[420000,205000],[400000,205000],[400000,175000]] };
$maps{"B:170E"} = { bbox => [[442000, 180000], [462000, 200000]], area => '400', series => 'B', number => '170', parent => 'B:170E', title => 'Vale of White Horse (Abingdon, Wantage, Wallingford & Faringdon)', polygon => [[442000,180000],[462000,180000],[462000,200000],[442000,200000],[442000,180000]] };
$maps{"B:170W"} = { bbox => [[419000, 180000], [442000, 200000]], area => '460', series => 'B', number => '170', parent => 'B:170W', title => 'Vale of White Horse (Abingdon, Wantage, Wallingford & Faringdon)', polygon => [[419000,180000],[442000,180000],[442000,200000],[419000,200000],[419000,180000]] };
$maps{"B:171"} = { bbox => [[459000, 173680], [481000, 201000]], area => '595.28', series => 'B', number => '171', parent => 'B:171', title => 'Chiltern Hills West (Henley-on-Thames & Wallingford)', polygon => [[459000,174000],[470000,174000],[472000,173680],[474000,173680],[476000,174000],[481000,174000],[481000,201000],[459000,201000],[459000,174000]] };
$maps{"B:172"} = { bbox => [[480000, 180000], [510000, 200000]], area => '600', series => 'B', number => '172', parent => 'B:172', title => 'Chiltern Hills East (High Wycombe, Maidenhead & Rickmansworth)', polygon => [[480000,180000],[510000,180000],[510000,200000],[480000,200000],[480000,180000]] };
$maps{"B:173"} = { bbox => [[510000, 178000], [537000, 200000]], area => '594', series => 'B', number => '173', parent => 'B:173', title => 'London North (The City, West End, Enfield, Ealing, Harrow & Watford)', polygon => [[510000,178000],[537000,178000],[537000,200000],[510000,200000],[510000,178000]] };
$maps{"B:174"} = { bbox => [[530000, 185000], [550000, 215000]], area => '600', series => 'B', number => '174', parent => 'B:174', title => 'Epping Forest & Lee Valley (Hertford & Harlow)', polygon => [[530000,185000],[550000,185000],[550000,215000],[530000,215000],[530000,185000]] };
$maps{"B:175E"} = { bbox => [[570000, 180000], [593000, 200000]], area => '460', series => 'B', number => '175', parent => 'B:175E', title => 'Southend-on-Sea & Basildon (Brentwood & Billericay)', polygon => [[570000,180000],[593000,180000],[593000,200000],[570000,200000],[570000,180000]] };
$maps{"B:175W"} = { bbox => [[550000, 180000], [570000, 200000]], area => '400', series => 'B', number => '175', parent => 'B:175W', title => 'Southend-on-Sea & Basildon (Brentwood & Billericay)', polygon => [[550000,180000],[570000,180000],[570000,200000],[550000,200000],[550000,180000]] };
$maps{"B:176"} = { bbox => [[584000, 183000], [606000, 211000]], area => '595.795', series => 'B', number => '176', parent => 'B:176', title => 'Blackwater Estuary (Maldon, Burnham-on-Crouch & Southend-on-Sea)', polygon => [[584000,184000],[587000,184000],[588000,183600],[588700,183000],[589200,183000],[589900,184000],[592400,184000],[592800,183800],[593800,183800],[593950,184000],[606000,184000],[606000,211000],[584000,211000],[584000,184000]] };
$maps{"B:177"} = { bbox => [[216000, 204000], [246000, 224000]], area => '600', series => 'B', number => '177', parent => 'B:177', title => 'Carmarthen & Kidwelly / Caerfyrddin a Cydweli (Pendine & Laugharne / Pentywyn a Lacharn)', polygon => [[216000,204000],[246000,204000],[246000,224000],[216000,224000],[216000,204000]] };
$maps{"B:178"} = { bbox => [[237000, 198000], [267000, 218000]], area => '600', series => 'B', number => '178', parent => 'B:178', title => 'Llanelli & Ammanford / Rhydaman (Kidwelly / Cydweli)', polygon => [[237000,198000],[267000,198000],[267000,218000],[237000,218000],[237000,198000]] };
$maps{"B:179"} = { bbox => [[378000, 203000], [400000, 230000]], area => '594', series => 'B', number => '179', parent => 'B:179', title => 'Gloucester, Cheltenham & Stroud', polygon => [[378000,203000],[400000,203000],[400000,230000],[378000,230000],[378000,203000]] };
$maps{"B:180E"} = { bbox => [[449000, 200000], [472200, 220000]], area => '460.29', series => 'B', number => '180', parent => 'B:180E', title => 'Oxford (Witney & Woodstock)', polygon => [[449000,200000],[472000,200000],[472000,204500],[472200,205000],[472200,206000],[472000,206400],[472000,220000],[449000,220000],[449000,200000]] };
$maps{"B:180W"} = { bbox => [[429500, 200000], [449500, 220000]], area => '400', series => 'B', number => '180', parent => 'B:180W', title => 'Oxford (Witney & Woodstock)', polygon => [[429500,200000],[449500,200000],[449500,220000],[429500,220000],[429500,200000]] };
$maps{"B:181"} = { bbox => [[472000, 200000], [502000, 220000]], area => '600', series => 'B', number => '181', parent => 'B:181', title => 'Chiltern Hills North (Aylesbury, Berkhamsted & Chesham)', polygon => [[472000,200000],[502000,200000],[502000,220000],[472000,220000],[472000,200000]] };
$maps{"B:182"} = { bbox => [[500000, 200000], [530000, 220000]], area => '600', series => 'B', number => '182', parent => 'B:182', title => 'St Albans & Hatfield (Hemel Hempstead & Welwyn Garden City)', polygon => [[500000,200000],[530000,200000],[530000,220000],[500000,220000],[500000,200000]] };
$maps{"B:183E"} = { bbox => [[567000, 200000], [590000, 220000]], area => '460', series => 'B', number => '183', parent => 'B:183E', title => 'Chelmsford & The Rodings (Maldon & Witham)', polygon => [[567000,200000],[590000,200000],[590000,220000],[567000,220000],[567000,200000]] };
$maps{"B:183W"} = { bbox => [[550000, 200000], [570000, 220000]], area => '400', series => 'B', number => '183', parent => 'B:183W', title => 'Chelmsford & The Rodings (Maldon & Witham)', polygon => [[550000,200000],[570000,200000],[570000,220000],[550000,220000],[550000,200000]] };
$maps{"B:184W"} = { bbox => [[590000, 210000], [610000, 230000]], area => '400', series => 'B', number => '184', parent => 'B:184W', title => 'Colchester (Harwich & Clacton-on-Sea)', polygon => [[590000,210000],[610000,210000],[610000,230000],[590000,230000],[590000,210000]] };
$maps{"B:184E"} = { bbox => [[607000, 211000], [627000, 234000]], area => '460', series => 'B', number => '184', parent => 'B:184E', title => 'Colchester (Harwich & Clacton-on-Sea)', polygon => [[607000,211000],[627000,211000],[627000,234000],[607000,234000],[607000,211000]] };
$maps{"B:185"} = { bbox => [[220000, 223000], [247000, 245000]], area => '594', series => 'B', number => '185', parent => 'B:185', title => 'Newcastle Emlyn / Castell Newydd Emlyn (Llandysul & Cynwyl Elfed)', polygon => [[220000,223000],[247000,223000],[247000,245000],[220000,245000],[220000,223000]] };
$maps{"B:186"} = { bbox => [[246000, 218000], [268000, 245000]], area => '594', series => 'B', number => '186', parent => 'B:186', title => 'Llandeilo & Brechfa Forest / Fforest Brechfa (Llanybydder)', polygon => [[246000,218000],[268000,218000],[268000,245000],[246000,245000],[246000,218000]] };
$maps{"B:187S"} = { bbox => [[267000, 232000], [290000, 252000]], area => '460', series => 'B', number => '187', parent => 'B:187S', title => 'Llandovery / Llanymddyfri (Llanwrtyd Wells & Llyn Brianne)', polygon => [[267000,232000],[290000,232000],[290000,252000],[267000,252000],[267000,232000]] };
$maps{"B:187N"} = { bbox => [[270000, 248000], [290000, 268000]], area => '400', series => 'B', number => '187', parent => 'B:187N', title => 'Llandovery / Llanymddyfri (Llanwrtyd Wells & Llyn Brianne)', polygon => [[270000,248000],[290000,248000],[290000,268000],[270000,268000],[270000,248000]] };
$maps{"B:188"} = { bbox => [[290000, 233000], [320000, 253000]], area => '600', series => 'B', number => '188', parent => 'B:188', title => 'Builth Wells / Llanfair-ym-Muallt (Painscastle / Castell Paen & Talgarth)', polygon => [[290000,233000],[320000,233000],[320000,253000],[290000,253000],[290000,233000]] };
$maps{"B:189"} = { bbox => [[340000, 220000], [370000, 242000]], area => '600.33', series => 'B', number => '189', parent => 'B:189', title => 'Hereford & Ross-on-Wye', polygon => [[340000,220000],[364000,220000],[364000,227200],[364400,227600],[364400,228000],[364000,228450],[364000,230000],[370000,230000],[370000,242000],[340000,242000],[340000,220000]] };
$maps{"B:190"} = { bbox => [[370000, 230000], [400000, 250000]], area => '600', series => 'B', number => '190', parent => 'B:190', title => 'Malvern Hills & Bredon Hill (Tewkesbury, Ledbury, Pershore & Upton upon Severn)', polygon => [[370000,230000],[400000,230000],[400000,250000],[370000,250000],[370000,230000]] };
$maps{"B:191W"} = { bbox => [[428000, 220000], [448000, 243000]], area => '460', series => 'B', number => '191', parent => 'B:191W', title => 'Banbury, Bicester & Chipping Norton (Brackley)', polygon => [[428000,220000],[448000,220000],[448000,243000],[428000,243000],[428000,220000]] };
$maps{"B:191E"} = { bbox => [[444000, 220000], [464000, 240000]], area => '400', series => 'B', number => '191', parent => 'B:191E', title => 'Banbury, Bicester & Chipping Norton (Brackley)', polygon => [[444000,220000],[464000,220000],[464000,240000],[444000,240000],[444000,220000]] };
$maps{"B:192E"} = { bbox => [[480000, 220000], [500000, 243000]], area => '460', series => 'B', number => '192', parent => 'B:192E', title => 'Buckingham & Milton Keynes (Leighton Buzzard & Woburn)', polygon => [[480000,220000],[500000,220000],[500000,243000],[480000,243000],[480000,220000]] };
$maps{"B:192W"} = { bbox => [[460000, 220000], [480000, 240000]], area => '400', series => 'B', number => '192', parent => 'B:192W', title => 'Buckingham & Milton Keynes (Leighton Buzzard & Woburn)', polygon => [[460000,220000],[480000,220000],[480000,240000],[460000,240000],[460000,220000]] };
$maps{"B:193"} = { bbox => [[500000, 220000], [530000, 240000]], area => '600', series => 'B', number => '193', parent => 'B:193', title => 'Luton & Stevenage (Hitchin & Ampthill)', polygon => [[500000,220000],[530000,220000],[530000,240000],[500000,240000],[500000,220000]] };
$maps{"B:194"} = { bbox => [[530000, 210000], [550800, 240000]], area => '601.79', series => 'B', number => '194', parent => 'B:194', title => 'Hertford & Bishop’s Stortford (Buntingford & Clavering)', polygon => [[530000,210000],[550000,210000],[550000,220000],[550500,220250],[550800,221800],[550450,222700],[550000,223400],[550000,240000],[530000,240000],[530000,210000]] };
$maps{"B:195W"} = { bbox => [[547000, 220000], [570000, 240000]], area => '460', series => 'B', number => '195', parent => 'B:195W', title => 'Braintree & Saffron Walden (Halstead & Great Dunmow)', polygon => [[547000,220000],[570000,220000],[570000,240000],[547000,240000],[547000,220000]] };
$maps{"B:195E"} = { bbox => [[570000, 220000], [590000, 240000]], area => '400', series => 'B', number => '195', parent => 'B:195E', title => 'Braintree & Saffron Walden (Halstead & Great Dunmow)', polygon => [[570000,220000],[590000,220000],[590000,240000],[570000,240000],[570000,220000]] };
$maps{"B:196"} = { bbox => [[580000, 230000], [610000, 250000]], area => '600', series => 'B', number => '196', parent => 'B:196', title => 'Sudbury, Hadleigh & Dedham Vale (Lavenham & Long Melford)', polygon => [[580000,230000],[610000,230000],[610000,250000],[580000,250000],[580000,230000]] };
$maps{"B:197"} = { bbox => [[609380, 229000], [640000, 251000]], area => '598.4695', series => 'B', number => '197', parent => 'B:197', title => 'Ipswich, Felixstowe & Harwich (Woodbridge & Manningtree)', polygon => [[610000,229000],[630500,229000],[630500,234000],[635000,234000],[635000,237000],[640000,237000],[640000,251000],[610000,251000],[610000,232900],[609600,232500],[609380,231000],[609580,230700],[610000,230850],[610000,229000]] };
$maps{"B:198W"} = { bbox => [[213000, 240000], [233000, 260000]], area => '400', series => 'B', number => '198', parent => 'B:198W', title => 'Cardigan & New Quay / Aberteifi a Ceinewydd (Aberaeron)', polygon => [[213000,240000],[233000,240000],[233000,260000],[213000,260000],[213000,240000]] };
$maps{"B:198E"} = { bbox => [[231000, 245000], [251700, 268000]], area => '460.33', series => 'B', number => '198', parent => 'B:198E', title => 'Cardigan & New Quay / Aberteifi a Ceinewydd (Aberaeron)', polygon => [[231000,245000],[251000,245000],[251000,267200],[251300,267400],[251700,268000],[231000,268000],[231000,245000]] };
$maps{"B:199"} = { bbox => [[248000, 243000], [270000, 270000]], area => '594', series => 'B', number => '199', parent => 'B:199', title => 'Lampeter / Llanbedr Pont Steffan (Tregaron & Llan-non)', polygon => [[248000,243000],[270000,243000],[270000,270000],[248000,270000],[248000,243000]] };
$maps{"B:200W"} = { bbox => [[280000, 253000], [300000, 273000]], area => '400', series => 'B', number => '200', parent => 'B:200W', title => 'Llandrindod Wells & Elan Valley / Llandrindod a Dyffryn Elan (Rhayader / Rhaeadr Gwy)', polygon => [[280000,253000],[300000,253000],[300000,273000],[280000,273000],[280000,253000]] };
$maps{"B:200E"} = { bbox => [[300000, 250000], [320000, 273000]], area => '460', series => 'B', number => '200', parent => 'B:200E', title => 'Llandrindod Wells & Elan Valley / Llandrindod a Dyffryn Elan (Rhayader / Rhaeadr Gwy)', polygon => [[300000,250000],[320000,250000],[320000,273000],[300000,273000],[300000,250000]] };
$maps{"B:201N"} = { bbox => [[320000, 260000], [340000, 283000]], area => '460', series => 'B', number => '201', parent => 'B:201N', title => 'Knighton & Presteigne / Tref-y-clawdd a Llanandras (Kington & Hay-on-Wye / Y Gelli Gandryll)', polygon => [[320000,260000],[340000,260000],[340000,283000],[320000,283000],[320000,260000]] };
$maps{"B:201S"} = { bbox => [[320000, 240000], [340000, 260000]], area => '400', series => 'B', number => '201', parent => 'B:201S', title => 'Knighton & Presteigne / Tref-y-clawdd a Llanandras (Kington & Hay-on-Wye / Y Gelli Gandryll)', polygon => [[320000,240000],[340000,240000],[340000,260000],[320000,260000],[320000,240000]] };
$maps{"B:202"} = { bbox => [[340000, 240000], [370000, 260000]], area => '600', series => 'B', number => '202', parent => 'B:202', title => 'Leominster & Bromyard (Hereford North)', polygon => [[340000,240000],[370000,240000],[370000,260000],[340000,260000],[340000,240000]] };
$maps{"B:203"} = { bbox => [[340000, 260000], [370000, 280000]], area => '600', series => 'B', number => '203', parent => 'B:203', title => 'Ludlow (Tenbury Wells & Cleobury Mortimer)', polygon => [[340000,260000],[370000,260000],[370000,280000],[340000,280000],[340000,260000]] };
$maps{"B:204"} = { bbox => [[370000, 250000], [400000, 270000]], area => '600', series => 'B', number => '204', parent => 'B:204', title => 'Worcester & Droitwich Spa', polygon => [[370000,250000],[400000,250000],[400000,270000],[370000,270000],[370000,250000]] };
$maps{"B:205"} = { bbox => [[400000, 240000], [430000, 260000]], area => '600', series => 'B', number => '205', parent => 'B:205', title => 'Stratford-upon-Avon & Evesham (Alcester)', polygon => [[400000,240000],[430000,240000],[430000,260000],[400000,260000],[400000,240000]] };
$maps{"B:206"} = { bbox => [[430000, 240000], [460000, 260000]], area => '600', series => 'B', number => '206', parent => 'B:206', title => 'Edge Hill & Fenny Compton (Badby, Kineton & Middle Tysoe)', polygon => [[430000,240000],[460000,240000],[460000,260000],[430000,260000],[430000,240000]] };
$maps{"B:207E"} = { bbox => [[473000, 240000], [493000, 263000]], area => '460', series => 'B', number => '207', parent => 'B:207E', title => 'Newport Pagnell & Northampton South (Towcester & Olney)', polygon => [[473000,240000],[493000,240000],[493000,263000],[473000,263000],[473000,240000]] };
$maps{"B:207W"} = { bbox => [[455000, 240000], [475000, 260000]], area => '400', series => 'B', number => '207', parent => 'B:207W', title => 'Newport Pagnell & Northampton South (Towcester & Olney)', polygon => [[455000,240000],[475000,240000],[475000,260000],[455000,260000],[455000,240000]] };
$maps{"B:208W"} = { bbox => [[493000, 240000], [513000, 260000]], area => '400', series => 'B', number => '208', parent => 'B:208W', title => 'Bedford & St Neots (Sandy & Biggleswade)', polygon => [[493000,240000],[513000,240000],[513000,260000],[493000,260000],[493000,240000]] };
$maps{"B:208E"} = { bbox => [[513000, 240000], [533000, 263000]], area => '460', series => 'B', number => '208', parent => 'B:208E', title => 'Bedford & St Neots (Sandy & Biggleswade)', polygon => [[513000,240000],[533000,240000],[533000,263000],[513000,263000],[513000,240000]] };
$maps{"B:209"} = { bbox => [[533000, 240000], [560000, 262400]], area => '594.66', series => 'B', number => '209', parent => 'B:209', title => 'Cambridge (Royston, Duxford & Linton)', polygon => [[533000,240000],[560000,240000],[560000,262000],[548200,262000],[547200,262400],[546800,262400],[545300,262000],[533000,262000],[533000,240000]] };
$maps{"B:210"} = { bbox => [[560000, 240000], [580000, 270000]], area => '600', series => 'B', number => '210', parent => 'B:210', title => 'Newmarket & Haverhill (Barrow, Clare & Kedington)', polygon => [[560000,240000],[580000,240000],[580000,270000],[560000,270000],[560000,240000]] };
$maps{"B:211W"} = { bbox => [[580000, 250000], [600000, 270000]], area => '400', series => 'B', number => '211', parent => 'B:211W', title => 'Bury St Edmunds & Stowmarket (Debenham & Elmswell)', polygon => [[580000,250000],[600000,250000],[600000,270000],[580000,270000],[580000,250000]] };
$maps{"B:211E"} = { bbox => [[600000, 250000], [623000, 270000]], area => '460', series => 'B', number => '211', parent => 'B:211E', title => 'Bury St Edmunds & Stowmarket (Debenham & Elmswell)', polygon => [[600000,250000],[623000,250000],[623000,270000],[600000,270000],[600000,250000]] };
$maps{"B:212"} = { bbox => [[621000, 246000], [648000, 268000]], area => '594', series => 'B', number => '212', parent => 'B:212', title => 'Woodbridge & Saxmundham (Aldeburgh & Framlington)', polygon => [[621000,246000],[648000,246000],[648000,268000],[621000,268000],[621000,246000]] };
$maps{"B:213"} = { bbox => [[251000, 268000], [281000, 290000]], area => '600', series => 'B', number => '213', parent => 'B:213', title => 'Aberystwyth & Cwm Rheidol (Devil’s Bridge / Pontarfynach)', polygon => [[251000,268000],[281000,268000],[281000,290000],[257000,290000],[257000,280000],[251000,280000],[251000,268000]] };
$maps{"B:214E"} = { bbox => [[300000, 270000], [320000, 293000]], area => '460', series => 'B', number => '214', parent => 'B:214E', title => 'Llanidloes & Newtown / Y Drenewydd (Llyn Clywedog)', polygon => [[300000,270000],[320000,270000],[320000,293000],[300000,293000],[300000,270000]] };
$maps{"B:214W"} = { bbox => [[280000, 273000], [300000, 293000]], area => '400', series => 'B', number => '214', parent => 'B:214W', title => 'Llanidloes & Newtown / Y Drenewydd (Llyn Clywedog)', polygon => [[280000,273000],[300000,273000],[300000,293000],[280000,293000],[280000,273000]] };
$maps{"B:215W"} = { bbox => [[274580, 290000], [298000, 310000]], area => '460.4494', series => 'B', number => '215', parent => 'B:215W', title => 'Newtown / Y Drenewydd & Machynlleth (Llanfair Caereinion)', polygon => [[275000,290000],[298000,290000],[298000,310000],[275000,310000],[275000,301620],[274580,301520],[274580,300500],[275000,300500],[275000,290000]] };
$maps{"B:215E"} = { bbox => [[298000, 290000], [318000, 310000]], area => '400', series => 'B', number => '215', parent => 'B:215E', title => 'Newtown / Y Drenewydd & Machynlleth (Llanfair Caereinion)', polygon => [[298000,290000],[318000,290000],[318000,310000],[298000,310000],[298000,290000]] };
$maps{"B:216"} = { bbox => [[318000, 283000], [340000, 310000]], area => '594', series => 'B', number => '216', parent => 'B:216', title => 'Welshpool & Montgomery / Y Trallwng a Threfaldwyn (Bishop’s Castle)', polygon => [[318000,283000],[340000,283000],[340000,310000],[318000,310000],[318000,283000]] };
$maps{"B:217"} = { bbox => [[335000, 280000], [365000, 300350]], area => '600.58175', series => 'B', number => '217', parent => 'B:217', title => 'The Long Mynd & Wenlock Edge (Church Stretton & Craven Arms)', polygon => [[335000,280000],[365000,280000],[365000,300000],[363500,300000],[363500,300350],[363050,300310],[361950,300310],[361500,300100],[361500,300000],[335000,300000],[335000,280000]] };
$maps{"B:218"} = { bbox => [[365000, 270000], [385000, 300000]], area => '600', series => 'B', number => '218', parent => 'B:218', title => 'Wyre Forest & Kidderminster (Brignorth)', polygon => [[365000,270000],[385000,270000],[385000,300000],[365000,300000],[365000,270000]] };
$maps{"B:219N"} = { bbox => [[380000, 287000], [400000, 307000]], area => '400', series => 'B', number => '219', parent => 'B:219N', title => 'Wolverhampton & Dudley (Stourbridge & Kidderminster)', polygon => [[380000,287000],[400000,287000],[400000,307000],[380000,307000],[380000,287000]] };
$maps{"B:219S"} = { bbox => [[380000, 270000], [400000, 293000]], area => '460', series => 'B', number => '219', parent => 'B:219S', title => 'Wolverhampton & Dudley (Stourbridge & Kidderminster)', polygon => [[380000,270000],[400000,270000],[400000,293000],[380000,293000],[380000,270000]] };
$maps{"B:220N"} = { bbox => [[400000, 280000], [420250, 303000]], area => '460.34275', series => 'B', number => '220', parent => 'B:220N', title => 'Birmingham (Walsall, Solihull & Redditch)', polygon => [[400000,280000],[420000,280000],[420000,282000],[420220,282400],[420250,282900],[420250,283250],[420000,284000],[420000,303000],[400000,303000],[400000,280000]] };
$maps{"B:220S"} = { bbox => [[399580, 260000], [420000, 280000]], area => '400.8022', series => 'B', number => '220', parent => 'B:220S', title => 'Birmingham (Walsall, Solihull & Redditch)', polygon => [[400000,260000],[420000,260000],[420000,280000],[400000,280000],[400000,276500],[399580,275920],[399580,274600],[400000,274000],[400000,260000]] };
$maps{"B:221"} = { bbox => [[420000, 260000], [440000, 290000]], area => '600', series => 'B', number => '221', parent => 'B:221', title => 'Coventry & Warwick (Royal Leamington Spa & Kenilworth)', polygon => [[420000,260000],[440000,260000],[440000,290000],[420000,290000],[420000,260000]] };
$maps{"B:222"} = { bbox => [[440000, 260000], [460350, 290000]], area => '600.35', series => 'B', number => '222', parent => 'B:222', title => 'Rugby & Daventry (Southam & Lutterworth)', polygon => [[440000,260000],[460000,260000],[460000,265100],[460300,265400],[460350,266150],[460000,266500],[460000,290000],[440000,290000],[440000,260000]] };
$maps{"B:223S"} = { bbox => [[460000, 256000], [483000, 276000]], area => '460', series => 'B', number => '223', parent => 'B:223S', title => 'Northampton & Market Harborough (Brixworth & Pitsford Water)', polygon => [[460000,256000],[483000,256000],[483000,276000],[460000,276000],[460000,256000]] };
$maps{"B:223N"} = { bbox => [[460000, 274000], [480000, 294000]], area => '400', series => 'B', number => '223', parent => 'B:223N', title => 'Northampton & Market Harborough (Brixworth & Pitsford Water)', polygon => [[460000,274000],[480000,274000],[480000,294000],[460000,294000],[460000,274000]] };
$maps{"B:224N"} = { bbox => [[480000, 280000], [503000, 300000]], area => '400', series => 'B', number => '224', parent => 'B:224N', title => 'Corby, Kettering & Wellingborough (Rockingham Forest)', polygon => [[480000,280000],[503000,280000],[503000,300000],[492000,300000],[492000,295000],[480000,295000],[480000,280000]] };
$maps{"B:224S"} = { bbox => [[480000, 260000], [503000, 280000]], area => '460', series => 'B', number => '224', parent => 'B:224S', title => 'Corby, Kettering & Wellingborough (Rockingham Forest)', polygon => [[480000,260000],[503000,260000],[503000,280000],[480000,280000],[480000,260000]] };
$maps{"B:225W"} = { bbox => [[503000, 260000], [526000, 280000]], area => '460', series => 'B', number => '225', parent => 'B:225W', title => 'Huntingdon & St Ives (Grafham Water)', polygon => [[503000,260000],[526000,260000],[526000,280000],[503000,280000],[503000,260000]] };
$maps{"B:225E"} = { bbox => [[526000, 260000], [546000, 280000]], area => '400', series => 'B', number => '225', parent => 'B:225E', title => 'Huntingdon & St Ives (Grafham Water)', polygon => [[526000,260000],[546000,260000],[546000,280000],[526000,280000],[526000,260000]] };
$maps{"B:226"} = { bbox => [[546000, 262000], [576000, 282200]], area => '600.0915', series => 'B', number => '226', parent => 'B:226', title => 'Ely & Newmarket (Mildenhall & Soham)', polygon => [[546000,262000],[576000,262000],[576000,282000],[555200,282000],[555200,282060],[554650,282200],[554450,282000],[546000,282000],[546000,262000]] };
$maps{"B:227W"} = { bbox => [[503000, 280000], [523000, 303000]], area => '460', series => 'B', number => '227', parent => 'B:227W', title => 'Peterborough (March, Whittlesey, Chatteris & Oundle)', polygon => [[503000,280000],[523000,280000],[523000,303000],[503000,303000],[503000,280000]] };
$maps{"B:227E"} = { bbox => [[523000, 280000], [543000, 300000]], area => '400', series => 'B', number => '227', parent => 'B:227E', title => 'Peterborough (March, Whittlesey, Chatteris & Oundle)', polygon => [[523000,280000],[543000,280000],[543000,300000],[523000,300000],[523000,280000]] };
$maps{"B:228W"} = { bbox => [[538550, 279300], [556000, 303000]], area => '393.48375', series => 'B', number => '228', parent => 'B:228W', title => 'March & Ely (Chatteris, Littleport, Welney & Denver Sluice)', polygon => [[539000,280000],[552000,280000],[552600,279350],[554350,279300],[555000,280000],[556000,280000],[556000,303000],[539000,303000],[539000,287400],[538800,287250],[538800,286800],[538550,285800],[538550,284900],[539000,284700],[539000,280000]] };
$maps{"B:228E"} = { bbox => [[555000, 280000], [575000, 303000]], area => '460', series => 'B', number => '228', parent => 'B:228E', title => 'March & Ely (Chatteris, Littleport, Welney & Denver Sluice)', polygon => [[555000,280000],[575000,280000],[575000,303000],[555000,303000],[555000,280000]] };
$maps{"B:229"} = { bbox => [[575000, 270000], [595000, 300000]], area => '600', series => 'B', number => '229', parent => 'B:229', title => 'Thetford Forest in The Brecks (Thetford & Brandon)', polygon => [[575000,270000],[595000,270000],[595000,300000],[575000,300000],[575000,270000]] };
$maps{"B:230E"} = { bbox => [[610000, 267000], [630000, 290000]], area => '460', series => 'B', number => '230', parent => 'B:230E', title => 'Diss & Harleston (East Harling & Stanton)', polygon => [[610000,267000],[630000,267000],[630000,290000],[610000,290000],[610000,267000]] };
$maps{"B:230W"} = { bbox => [[590000, 270000], [610000, 290000]], area => '400', series => 'B', number => '230', parent => 'B:230W', title => 'Diss & Harleston (East Harling & Stanton)', polygon => [[590000,270000],[610000,270000],[610000,290000],[590000,290000],[590000,270000]] };
$maps{"B:231"} = { bbox => [[627000, 268000], [654000, 290400]], area => '594.34', series => 'B', number => '231', parent => 'B:231', title => 'Southwold & Bungay (Halesworth & Kessingland)', polygon => [[627000,268000],[654000,268000],[654000,290000],[634500,290000],[633300,290400],[632800,290000],[627000,290000],[627000,268000]] };
$maps{"B:232"} = { bbox => [[411070, 289000], [441500, 311500]], area => '601.91885', series => 'B', number => '232', parent => 'B:232', title => 'Nuneaton & Tamworth (Lichfield & Atherstone)', polygon => [[411500,299000],[417500,299000],[417500,289000],[441500,289000],[441500,311000],[412600,311000],[412330,311450],[412200,311450],[412000,311500],[411800,311500],[411600,311420],[411070,311420],[411070,308000],[411500,308000],[411500,299000]] };
$maps{"B:233W"} = { bbox => [[441500, 287000], [461500, 310000]], area => '460', series => 'B', number => '233', parent => 'B:233W', title => 'Leicester & Hinckley', polygon => [[441500,287000],[461500,287000],[461500,310000],[441500,310000],[441500,287000]] };
$maps{"B:233E"} = { bbox => [[461500, 289650], [482000, 310000]], area => '401.855', series => 'B', number => '233', parent => 'B:233E', title => 'Leicester & Hinckley', polygon => [[461500,290000],[468000,290000],[468500,289650],[470500,289650],[471000,290000],[481500,290000],[481500,299400],[481850,300000],[482000,300500],[482000,301350],[481500,302300],[481500,310000],[461500,310000],[461500,290000]] };
$maps{"B:234"} = { bbox => [[480000, 295000], [510000, 315000]], area => '600', series => 'B', number => '234', parent => 'B:234', title => 'Rutland Water (Stamford & Oakham)', polygon => [[480000,295000],[510000,295000],[510000,315000],[480000,315000],[480000,295000]] };
$maps{"B:235W"} = { bbox => [[510000, 297000], [530000, 320000]], area => '460', series => 'B', number => '235', parent => 'B:235W', title => 'Wisbech & Peterborough North (Market Deeping & Crowland)', polygon => [[510000,297000],[530000,297000],[530000,320000],[510000,320000],[510000,297000]] };
$maps{"B:235E"} = { bbox => [[530000, 300000], [550000, 320000]], area => '400', series => 'B', number => '235', parent => 'B:235E', title => 'Wisbech & Peterborough North (Market Deeping & Crowland)', polygon => [[530000,300000],[550000,300000],[550000,320000],[530000,320000],[530000,300000]] };
$maps{"B:236W"} = { bbox => [[550000, 300000], [570000, 323000]], area => '460', series => 'B', number => '236', parent => 'B:236W', title => 'King’s Lynn, Downham Market & Swaffham', polygon => [[550000,300000],[570000,300000],[570000,323000],[550000,323000],[550000,300000]] };
$maps{"B:236E"} = { bbox => [[570000, 300000], [590000, 320000]], area => '400', series => 'B', number => '236', parent => 'B:236E', title => 'King’s Lynn, Downham Market & Swaffham', polygon => [[570000,300000],[590000,300000],[590000,320000],[570000,320000],[570000,300000]] };
$maps{"B:237E"} = { bbox => [[609000, 290000], [629000, 313000]], area => '460', series => 'B', number => '237', parent => 'B:237E', title => 'Norwich (Wymondham, Attleborough & Watton)', polygon => [[609000,290000],[629000,290000],[629000,313000],[609000,313000],[609000,290000]] };
$maps{"B:237W"} = { bbox => [[589000, 290000], [609000, 310000]], area => '400', series => 'B', number => '237', parent => 'B:237W', title => 'Norwich (Wymondham, Attleborough & Watton)', polygon => [[589000,290000],[609000,290000],[609000,310000],[589000,310000],[589000,290000]] };
$maps{"B:238W"} = { bbox => [[580000, 310000], [600000, 330000]], area => '400', series => 'B', number => '238', parent => 'B:238W', title => 'Dereham & Aylsham (Castle Acre & Reepham)', polygon => [[580000,310000],[600000,310000],[600000,330000],[580000,330000],[580000,310000]] };
$maps{"B:238E"} = { bbox => [[600000, 310000], [623000, 330000]], area => '460', series => 'B', number => '238', parent => 'B:238E', title => 'Dereham & Aylsham (Castle Acre & Reepham)', polygon => [[600000,310000],[623000,310000],[623000,330000],[600000,330000],[600000,310000]] };
$maps{"B:239"} = { bbox => [[294000, 306000], [321750, 328000]], area => '594.82', series => 'B', number => '239', parent => 'B:239', title => 'Lake Vyrnwy / Llyn Efyrnwy & Llanfyllin (Tanat Valley / Dyffryn Tanat)', polygon => [[294000,306000],[321000,306000],[321000,307000],[321150,307000],[321750,307500],[321750,307900],[321200,308500],[321000,308600],[321000,328000],[294000,328000],[294000,306000]] };
$maps{"B:240"} = { bbox => [[320000, 310000], [340450, 340000]], area => '600.75375', series => 'B', number => '240', parent => 'B:240', title => 'Oswestry / Croesoswallt (Chirk / Y Waun, Ellesmere & Pant)', polygon => [[320000,310000],[340000,310000],[340000,333900],[340450,334200],[340450,335500],[340000,335950],[340000,340000],[320000,340000],[320000,310000]] };
$maps{"B:241S"} = { bbox => [[340000, 300000], [360000, 320000]], area => '400', series => 'B', number => '241', parent => 'B:241S', title => 'Shrewsbury (Wem, Shawbury & Baschurch)', polygon => [[340000,300000],[360000,300000],[360000,320000],[340000,320000],[340000,300000]] };
$maps{"B:241N"} = { bbox => [[340000, 317000], [360000, 340000]], area => '460', series => 'B', number => '241', parent => 'B:241N', title => 'Shrewsbury (Wem, Shawbury & Baschurch)', polygon => [[340000,317000],[360000,317000],[360000,340000],[340000,340000],[340000,317000]] };
$maps{"B:242"} = { bbox => [[360000, 300000], [390000, 320000]], area => '600', series => 'B', number => '242', parent => 'B:242', title => 'Telford, Ironbridge & The Wrekin', polygon => [[360000,300000],[390000,300000],[390000,320000],[360000,320000],[360000,300000]] };
$maps{"B:243"} = { bbox => [[360000, 320000], [390000, 340000]], area => '600', series => 'B', number => '243', parent => 'B:243', title => 'Market Drayton (Loggerheads & Eccleshall)', polygon => [[360000,320000],[390000,320000],[390000,340000],[360000,340000],[360000,320000]] };
$maps{"B:244"} = { bbox => [[390000, 303000], [412000, 330000]], area => '594', series => 'B', number => '244', parent => 'B:244', title => 'Cannock Chase & Chasewater (Stafford, Rugeley & Cannock)', polygon => [[390000,303000],[412000,303000],[412000,330000],[390000,330000],[390000,303000]] };
$maps{"B:245W"} = { bbox => [[411000, 310000], [431000, 330000]], area => '400', series => 'B', number => '245', parent => 'B:245W', title => 'The National Forest (Burton upon Trent, Swadlincote, Ashby-de-la-Zouch & Coalville)', polygon => [[411000,310000],[431000,310000],[431000,330000],[411000,330000],[411000,310000]] };
$maps{"B:245E"} = { bbox => [[431000, 307000], [451000, 330000]], area => '460', series => 'B', number => '245', parent => 'B:245E', title => 'The National Forest (Burton upon Trent, Swadlincote, Ashby-de-la-Zouch & Coalville)', polygon => [[431000,307000],[451000,307000],[451000,330000],[431000,330000],[431000,307000]] };
$maps{"B:246"} = { bbox => [[450000, 309450], [480000, 330000]], area => '600.94875', series => 'B', number => '246', parent => 'B:246', title => 'Loughborough (Melton Mowbray & Syston)', polygon => [[450000,310000],[451400,310000],[451700,309700],[452000,309600],[452500,309550],[453000,309450],[453200,309450],[453850,309900],[454150,310000],[480000,310000],[480000,330000],[450000,330000],[450000,310000]] };
$maps{"B:247"} = { bbox => [[480000, 315000], [500000, 345000]], area => '600', series => 'B', number => '247', parent => 'B:247', title => 'Grantham (Bottesford & Colsterworth)', polygon => [[480000,315000],[500000,315000],[500000,345000],[480000,345000],[480000,315000]] };
$maps{"B:248"} = { bbox => [[500000, 315000], [520000, 345000]], area => '600', series => 'B', number => '248', parent => 'B:248', title => 'Bourne & Heckington (Billingborough & Morton)', polygon => [[500000,315000],[520000,315000],[520000,345000],[500000,345000],[500000,315000]] };
$maps{"B:249W"} = { bbox => [[520000, 320000], [540000, 340000]], area => '400', series => 'B', number => '249', parent => 'B:249W', title => 'Spalding & Holbeach (Long Sutton & Kirton)', polygon => [[520000,320000],[540000,320000],[540000,340000],[520000,340000],[520000,320000]] };
$maps{"B:249E"} = { bbox => [[540000, 320000], [563000, 340000]], area => '460', series => 'B', number => '249', parent => 'B:249E', title => 'Spalding & Holbeach (Long Sutton & Kirton)', polygon => [[540000,320000],[563000,320000],[563000,340000],[540000,340000],[540000,320000]] };
$maps{"B:250"} = { bbox => [[559550, 317000], [582000, 347000]], area => '600.51375', series => 'B', number => '250', parent => 'B:250', title => 'Norfolk Coast West (King’s Lynn & Hunstanton)', polygon => [[560000,317000],[582000,317000],[582000,347000],[565000,347000],[565000,335000],[560000,335000],[560000,326100],[559700,325600],[559700,325600],[559700,325000],[559550,324850],[559550,324900],[560000,323900],[560000,317000]] };
$maps{"B:251"} = { bbox => [[581000, 328000], [611000, 348000]], area => '600', series => 'B', number => '251', parent => 'B:251', title => 'Norfolk Coast Central (Wells-next-the-Sea & Fakenham)', polygon => [[581000,328000],[611000,328000],[611000,348000],[581000,348000],[581000,328000]] };
$maps{"B:252"} = { bbox => [[610000, 323000], [640000, 345000]], area => '600', series => 'B', number => '252', parent => 'B:252', title => 'Norfolk Coast East (Cromer & North Walsham)', polygon => [[610000,323000],[640000,323000],[640000,339000],[630000,339000],[630000,345000],[610000,345000],[610000,323000]] };
$maps{"B:253"} = { bbox => [[213000, 323000], [240000, 345000]], area => '594', series => 'B', number => '253', parent => 'B:253', title => 'Lleyn Peninsula West / Pen Llŷn Ardal Orllewinol (Pwllheli, Abersoch & Aberdaron)', polygon => [[213000,323000],[240000,323000],[240000,345000],[213000,345000],[213000,323000]] };
$maps{"B:253.a"} = { bbox => [[210000, 320000], [213000, 323500]], area => '10.5', series => 'B', number => '253', parent => 'B:253', title => 'Lleyn Peninsula West / Pen Llŷn Ardal Orllewinol (Pwllheli, Abersoch & Aberdaron)', polygon => [[210000,320000],[213000,320000],[213000,323500],[210000,323500],[210000,320000]] };
$maps{"B:254"} = { bbox => [[234600, 334000], [257400, 361200]], area => '595.0505', series => 'B', number => '254', parent => 'B:254', title => 'Lleyn Peninsula East / Pen Llŷn Ardal Ddwyreiniol (Porthmadog, Pwllheli & Criccieth)', polygon => [[235000,334000],[257000,334000],[257000,337750],[257300,338000],[257400,338400],[257400,338600],[257300,338650],[257000,339100],[257000,361000],[244400,361000],[244300,361200],[243600,361200],[243500,361000],[235000,361000],[235000,346000],[234600,345500],[234600,344800],[234700,344500],[235000,344080],[235000,334000]] };
$maps{"B:255"} = { bbox => [[298000, 325000], [328700, 347000]], area => '603.5', series => 'B', number => '255', parent => 'B:255', title => 'Llangollen & Berwyn (Ceiriog Valley / Glyn Ceiriog)', polygon => [[298000,325000],[314000,325000],[314000,328000],[322000,328000],[322000,331000],[328000,331000],[328000,336300],[328700,337000],[328700,341300],[328000,342000],[328000,347000],[298000,347000],[298000,325000]] };
$maps{"B:256"} = { bbox => [[307000, 337000], [337000, 359000]], area => '600', series => 'B', number => '256', parent => 'B:256', title => 'Wrexham / Wrecsam & Llangollen', polygon => [[307000,342000],[319000,342000],[319000,337000],[337000,337000],[337000,359000],[307000,359000],[307000,342000]] };
$maps{"B:257E"} = { bbox => [[357000, 340000], [380000, 360000]], area => '460', series => 'B', number => '257', parent => 'B:257E', title => 'Crewe & Nantwich (Whitchurch & Tattenhall)', polygon => [[357000,340000],[380000,340000],[380000,360000],[357000,360000],[357000,340000]] };
$maps{"B:257W"} = { bbox => [[337000, 340000], [357000, 360450]], area => '401.06875', series => 'B', number => '257', parent => 'B:257W', title => 'Crewe & Nantwich (Whitchurch & Tattenhall)', polygon => [[337000,340000],[357000,340000],[357000,360000],[349450,360000],[349100,360450],[347050,360450],[346750,360000],[337000,360000],[337000,340000]] };
$maps{"B:258"} = { bbox => [[380000, 330000], [400000, 360000]], area => '600', series => 'B', number => '258', parent => 'B:258', title => 'Stoke-on-Trent & Newcastle-under-Lyme (Biddulph & Stone)', polygon => [[380000,330000],[400000,330000],[400000,360000],[380000,360000],[380000,330000]] };
$maps{"B:259E"} = { bbox => [[420000, 330000], [443000, 350000]], area => '460', series => 'B', number => '259', parent => 'B:259E', title => 'Derby (Uttoxeter, Ashbourne & Cheadle)', polygon => [[420000,330000],[443000,330000],[443000,350000],[420000,350000],[420000,330000]] };
$maps{"B:259W"} = { bbox => [[400000, 330000], [420000, 350000]], area => '400', series => 'B', number => '259', parent => 'B:259W', title => 'Derby (Uttoxeter, Ashbourne & Cheadle)', polygon => [[400000,330000],[420000,330000],[420000,350000],[400000,350000],[400000,330000]] };
$maps{"B:260W"} = { bbox => [[440000, 330000], [463000, 350000]], area => '460', series => 'B', number => '260', parent => 'B:260W', title => 'Nottingham (Vale of Belvoir)', polygon => [[440000,330000],[463000,330000],[463000,350000],[440000,350000],[440000,330000]] };
$maps{"B:260E"} = { bbox => [[463000, 329200], [483000, 350000]], area => '403.035', series => 'B', number => '260', parent => 'B:260E', title => 'Nottingham (Vale of Belvoir)', polygon => [[463000,330000],[468200,330000],[468600,329350],[470500,329350],[471000,329200],[471700,329450],[472500,329400],[473000,329500],[473400,330000],[483000,330000],[483000,350000],[463000,350000],[463000,330000]] };
$maps{"B:261E"} = { bbox => [[530000, 340000], [553000, 360000]], area => '460', series => 'B', number => '261', parent => 'B:261E', title => 'Boston (Tattershall, Billinghay & Heckington)', polygon => [[530000,340000],[553000,340000],[553000,360000],[530000,360000],[530000,340000]] };
$maps{"B:261W"} = { bbox => [[510000, 340000], [530000, 360000]], area => '400', series => 'B', number => '261', parent => 'B:261W', title => 'Boston (Tattershall, Billinghay & Heckington)', polygon => [[510000,340000],[530000,340000],[530000,360000],[510000,360000],[510000,340000]] };
$maps{"B:262"} = { bbox => [[220000, 366000], [242000, 396000]], area => '600', series => 'B', number => '262', parent => 'B:262', title => 'Anglesey West / Gorllewin Ynys Môn (Holyhead / Caergybi)', polygon => [[220000,371000],[232000,371000],[232000,366000],[242000,366000],[242000,396000],[220000,396000],[220000,371000]] };
$maps{"B:263S"} = { bbox => [[235800, 360000], [259000, 380000]], area => '460.07', series => 'B', number => '263', parent => 'B:263S', title => 'Anglesey East / Dwyrain Ynys Môn (Beaumaris, Amlwch & Menai Bridge / Biwmares, Amlwch & Porthaethwy)', polygon => [[236000,360000],[259000,360000],[259000,380000],[236000,380000],[236000,366000],[235800,365800],[235800,365700],[236000,365400],[236000,360000]] };
$maps{"B:263N"} = { bbox => [[242000, 375000], [265700, 395000]], area => '400.28', series => 'B', number => '263', parent => 'B:263N', title => 'Anglesey East / Dwyrain Ynys Môn (Beaumaris, Amlwch & Menai Bridge / Biwmares, Amlwch & Porthaethwy)', polygon => [[242000,375000],[265000,375000],[265000,381800],[265700,382450],[265700,382550],[265000,382500],[265000,389000],[255000,389000],[255000,395000],[242000,395000],[242000,375000]] };
$maps{"B:264N"} = { bbox => [[290000, 365000], [310000, 385000]], area => '400', series => 'B', number => '264', parent => 'B:264N', title => 'Vale of Clwyd / Dyffryn Clwyd (Rhyl, Denbigh & Ruthin / Rhyl, Dinbych a Rhuthun)', polygon => [[290000,365000],[310000,365000],[310000,385000],[290000,385000],[290000,365000]] };
$maps{"B:264S"} = { bbox => [[290000, 345000], [313000, 365000]], area => '460', series => 'B', number => '264', parent => 'B:264S', title => 'Vale of Clwyd / Dyffryn Clwyd (Rhyl, Denbigh & Ruthin / Rhyl, Dinbych a Rhuthun)', polygon => [[290000,345000],[313000,345000],[313000,365000],[290000,365000],[290000,345000]] };
$maps{"B:265"} = { bbox => [[305000, 355000], [325000, 385850]], area => '603.655', series => 'B', number => '265', parent => 'B:265', title => 'Clwydian Range / Bryniau Clwyd (Prestatyn, Mold & Ruthin / Prestatyn, Yr Wyddgrug a Rhuthun)', polygon => [[305000,355000],[325000,355000],[325000,385000],[314000,385000],[312800,385850],[310500,385850],[307700,385000],[305000,385000],[305000,355000]] };
$maps{"B:266N"} = { bbox => [[318000, 376000], [339000, 396000]], area => '402.08', series => 'B', number => '266', parent => 'B:266N', title => 'Wirral & Chester / Caer', polygon => [[319000,376000],[339000,376000],[339000,396000],[319000,396000],[319000,389500],[318000,388300],[318200,387500],[318300,387000],[319000,385900],[319000,376000]] };
$maps{"B:266S"} = { bbox => [[325000, 359000], [348000, 379500]], area => '460.6', series => 'B', number => '266', parent => 'B:266S', title => 'Wirral & Chester / Caer', polygon => [[325000,359000],[348000,359000],[348000,379000],[340000,379000],[339500,379400],[339000,379500],[338500,379300],[338000,379000],[325000,379000],[325000,359000]] };
$maps{"B:267"} = { bbox => [[348000, 360000], [375000, 382000]], area => '594', series => 'B', number => '267', parent => 'B:267', title => 'Northwich & Delamere Forest (Winsford & Middlewich)', polygon => [[348000,360000],[375000,360000],[375000,382000],[348000,382000],[348000,360000]] };
$maps{"B:268N"} = { bbox => [[373550, 373000], [397450, 390450]], area => '393.9325', series => 'B', number => '268', parent => 'B:268N', title => 'Wilmslow, Macclesfield & Congleton (Altrincham, Knutsford & Sandbach)', polygon => [[374000,373000],[397000,373000],[397000,379000],[397400,379500],[397450,379800],[397450,381400],[397000,382000],[397000,390000],[396800,390200],[396500,390450],[394200,390450],[393800,390000],[374000,390000],[374000,382100],[373550,381500],[373550,380800],[374000,380100],[374000,373000]] };
$maps{"B:268S"} = { bbox => [[374000, 354000], [397000, 374000]], area => '460', series => 'B', number => '268', parent => 'B:268S', title => 'Wilmslow, Macclesfield & Congleton (Altrincham, Knutsford & Sandbach)', polygon => [[374000,354000],[397000,354000],[397000,374000],[374000,374000],[374000,354000]] };
$maps{"B:269"} = { bbox => [[432000, 350000], [452000, 380000]], area => '600', series => 'B', number => '269', parent => 'B:269', title => 'Chesterfield & Alfreton (Sutton in Ashfield & Bolsover)', polygon => [[432000,350000],[452000,350000],[452000,380000],[432000,380000],[432000,350000]] };
$maps{"B:270"} = { bbox => [[450000, 350000], [470000, 380000]], area => '600', series => 'B', number => '270', parent => 'B:270', title => 'Sherwood Forest (Mansfield, Worksop & Edwinstowe)', polygon => [[450000,350000],[470000,350000],[470000,380000],[450000,380000],[450000,350000]] };
$maps{"B:271S"} = { bbox => [[469200, 345000], [490000, 365000]], area => '401.73975', series => 'B', number => '271', parent => 'B:271S', title => 'Newark-on-Trent (Retford, Southwell & Saxilby)', polygon => [[470000,345000],[490000,345000],[490000,365000],[470000,365000],[470000,355650],[469370,355000],[469200,354500],[469200,354000],[469250,353500],[469550,353000],[470000,352600],[470000,345000]] };
$maps{"B:271N"} = { bbox => [[470000, 365000], [490000, 388000]], area => '460', series => 'B', number => '271', parent => 'B:271N', title => 'Newark-on-Trent (Retford, Southwell & Saxilby)', polygon => [[470000,365000],[490000,365000],[490000,388000],[470000,388000],[470000,365000]] };
$maps{"B:272N"} = { bbox => [[490000, 365000], [510000, 388000]], area => '460', series => 'B', number => '272', parent => 'B:272N', title => 'Lincoln (Sleaford, Metheringham & Navenby)', polygon => [[490000,365000],[510000,365000],[510000,388000],[490000,388000],[490000,365000]] };
$maps{"B:272S"} = { bbox => [[490000, 344550], [510000, 365000]], area => '401.025', series => 'B', number => '272', parent => 'B:272S', title => 'Lincoln (Sleaford, Metheringham & Navenby)', polygon => [[490000,345000],[505000,345000],[505500,344600],[506000,344550],[507000,344550],[507500,344700],[508000,345000],[510000,345000],[510000,365000],[490000,365000],[490000,345000]] };
$maps{"B:273"} = { bbox => [[510000, 360000], [540650, 380000]], area => '600.70625', series => 'B', number => '273', parent => 'B:273', title => 'Lincolnshire Wolds South (Horncastle & Woodhall Spa)', polygon => [[510000,360000],[540000,360000],[540000,365200],[540600,365700],[540650,366000],[540350,366650],[540000,366900],[540000,380000],[510000,380000],[510000,360000]] };
$maps{"B:274"} = { bbox => [[538000, 353000], [558000, 383000]], area => '600', series => 'B', number => '274', parent => 'B:274', title => 'Skegnesss, Alford & Spilsby (Chapel St Leonards & Wainfleet All Saints)', polygon => [[538000,353000],[558000,353000],[558000,383000],[538000,383000],[538000,353000]] };
$maps{"B:275"} = { bbox => [[329000, 379000], [359000, 401000]], area => '597', series => 'B', number => '275', parent => 'B:275', title => 'Liverpool (St Helens, Widnes & Runcorn)', polygon => [[329000,395000],[332000,395000],[332000,384000],[335000,384000],[335000,379000],[359000,379000],[359000,401000],[329000,401000],[329000,395000]] };
$maps{"B:276"} = { bbox => [[355000, 382000], [375400, 412000]], area => '600.215', series => 'B', number => '276', parent => 'B:276', title => 'Bolton Central, Wigan & Warrington', polygon => [[355000,382000],[375000,382000],[375000,398450],[375200,398800],[375300,399000],[375400,399200],[375000,399500],[375000,412000],[355000,412000],[355000,382000]] };
$maps{"B:277"} = { bbox => [[374500, 388000], [397000, 415450]], area => '596.0495', series => 'B', number => '277', parent => 'B:277', title => 'Manchester & Salford (Oldham, Rochdale & Stockport)', polygon => [[375000,388000],[397000,388000],[397000,415000],[394500,415000],[394100,415450],[393200,415450],[393000,415200],[392900,415000],[375000,415000],[375000,407000],[374700,406500],[374550,406100],[374600,406000],[375000,405000],[375000,401200],[374500,400500],[374500,399700],[374700,399000],[374800,398500],[375000,398180],[375000,388000]] };
$maps{"B:278S"} = { bbox => [[427000, 380000], [447000, 400000]], area => '400', series => 'B', number => '278', parent => 'B:278S', title => 'Sheffield & Barnsley (Rotherham)', polygon => [[427000,380000],[447000,380000],[447000,400000],[427000,400000],[427000,380000]] };
$maps{"B:278N"} = { bbox => [[426600, 400000], [450000, 420000]], area => '460.31', series => 'B', number => '278', parent => 'B:278N', title => 'Sheffield & Barnsley (Rotherham)', polygon => [[427000,400000],[450000,400000],[450000,420000],[427000,420000],[427000,403000],[426600,402500],[426600,402200],[427000,401750],[427000,400000]] };
$maps{"B:279N"} = { bbox => [[450000, 400000], [470000, 420000]], area => '400', series => 'B', number => '279', parent => 'B:279N', title => 'Doncaster (Conisbrough, Maltby & Thorne)', polygon => [[450000,400000],[470000,400000],[470000,420000],[450000,420000],[450000,400000]] };
$maps{"B:279S"} = { bbox => [[447000, 380000], [470000, 400000]], area => '460', series => 'B', number => '279', parent => 'B:279S', title => 'Doncaster (Conisbrough, Maltby & Thorne)', polygon => [[447000,380000],[470000,380000],[470000,400000],[447000,400000],[447000,380000]] };
$maps{"B:280"} = { bbox => [[470000, 388000], [492000, 415000]], area => '594', series => 'B', number => '280', parent => 'B:280', title => 'Isle of Axholme (Scunthorpe & Gainsborough)', polygon => [[470000,388000],[492000,388000],[492000,415000],[470000,415000],[470000,388000]] };
$maps{"B:281N"} = { bbox => [[487000, 406000], [510000, 426000]], area => '460', series => 'B', number => '281', parent => 'B:281N', title => 'Ancholme Valley (Barton-upon-Humber, Brigg, Scunthorpe & Kirton in Lindsey)', polygon => [[487000,406000],[510000,406000],[510000,426000],[487000,426000],[487000,406000]] };
$maps{"B:281S"} = { bbox => [[490000, 388000], [510000, 408000]], area => '400', series => 'B', number => '281', parent => 'B:281S', title => 'Ancholme Valley (Barton-upon-Humber, Brigg, Scunthorpe & Kirton in Lindsey)', polygon => [[490000,388000],[510000,388000],[510000,408000],[490000,408000],[490000,388000]] };
$maps{"B:282"} = { bbox => [[510000, 380000], [537000, 402000]], area => '594', series => 'B', number => '282', parent => 'B:282', title => 'Lincolnshire Wolds North (Louth & Market Rasen)', polygon => [[510000,380000],[537000,380000],[537000,402000],[510000,402000],[510000,380000]] };
$maps{"B:283"} = { bbox => [[532000, 378000], [554000, 408000]], area => '600', series => 'B', number => '283', parent => 'B:283', title => 'Louth & Mablethorpe (Sutton on Sea & North Somercotes)', polygon => [[532000,378000],[554000,378000],[554000,402000],[544000,402000],[544000,408000],[532000,408000],[532000,378000]] };
$maps{"B:284"} = { bbox => [[510000, 396000], [532600, 426000]], area => '600.6825', series => 'B', number => '284', parent => 'B:284', title => 'Grimsby, Cleethorpes & Immingham (Caistor & North Thoresby)', polygon => [[510000,396000],[532000,396000],[532000,405900],[532300,406000],[532600,406350],[532600,406900],[532000,407500],[532000,420000],[522000,420000],[522000,426000],[510000,426000],[510000,396000]] };
$maps{"B:285W"} = { bbox => [[324000, 400000], [344000, 423000]], area => '460', series => 'B', number => '285', parent => 'B:285W', title => 'Southport & Chorley (Wigan, Formby & Ormskirk)', polygon => [[324000,400000],[344000,400000],[344000,423000],[324000,423000],[324000,400000]] };
$maps{"B:285E"} = { bbox => [[344000, 400000], [364000, 423000]], area => '400', series => 'B', number => '285', parent => 'B:285E', title => 'Southport & Chorley (Wigan, Formby & Ormskirk)', polygon => [[344000,400000],[359000,400000],[359000,412000],[364000,412000],[364000,423000],[344000,423000],[344000,400000]] };
$maps{"B:286"} = { bbox => [[330000, 421000], [360000, 441000]], area => '600', series => 'B', number => '286', parent => 'B:286', title => 'Blackpool & Preston (Lytham St Anne’s & Leyland)', polygon => [[330000,421000],[360000,421000],[360000,441000],[330000,441000],[330000,421000]] };
$maps{"B:287"} = { bbox => [[357750, 410000], [380500, 440000]], area => '622.1', series => 'B', number => '287', parent => 'B:287', title => 'West Pennine Moors (Blackburn, Darwen & Accrington)', polygon => [[357750,410000],[380500,410000],[380500,413500],[380000,413900],[380000,440000],[360000,440000],[360000,419000],[357750,419000],[357750,410000]] };
$maps{"B:288N"} = { bbox => [[408000, 419000], [428000, 442000]], area => '460', series => 'B', number => '288', parent => 'B:288N', title => 'Bradford & Huddersfield (East Calderdale)', polygon => [[408000,419000],[428000,419000],[428000,442000],[408000,442000],[408000,419000]] };
$maps{"B:288S"} = { bbox => [[408000, 404000], [428000, 424000]], area => '400', series => 'B', number => '288', parent => 'B:288S', title => 'Bradford & Huddersfield (East Calderdale)', polygon => [[408000,404000],[428000,404000],[428000,424000],[408000,424000],[408000,404000]] };
$maps{"B:289S"} = { bbox => [[425000, 420000], [448000, 440000]], area => '460', series => 'B', number => '289', parent => 'B:289S', title => 'Leeds (Harrogate, Wetherby & Pontefract)', polygon => [[425000,420000],[448000,420000],[448000,440000],[425000,440000],[425000,420000]] };
$maps{"B:289N"} = { bbox => [[428000, 440000], [448000, 460000]], area => '400', series => 'B', number => '289', parent => 'B:289N', title => 'Leeds (Harrogate, Wetherby & Pontefract)', polygon => [[428000,440000],[448000,440000],[448000,460000],[428000,460000],[428000,440000]] };
$maps{"B:290N"} = { bbox => [[447300, 440000], [471000, 460000]], area => '461.695', series => 'B', number => '290', parent => 'B:290N', title => 'York (Selby & Tadcaster)', polygon => [[448000,440000],[471000,440000],[471000,460000],[448000,460000],[448000,444300],[447750,444000],[447550,443600],[447350,443000],[447300,442500],[447350,442000],[447500,441500],[447750,441000],[448000,440700],[448000,440000]] };
$maps{"B:290S"} = { bbox => [[448000, 420000], [468000, 440000]], area => '400', series => 'B', number => '290', parent => 'B:290S', title => 'York (Selby & Tadcaster)', polygon => [[448000,420000],[468000,420000],[468000,440000],[448000,440000],[448000,420000]] };
$maps{"B:291"} = { bbox => [[467000, 415000], [489000, 442000]], area => '594', series => 'B', number => '291', parent => 'B:291', title => 'Goole & Gilberdyke (Holme-on-Spalding-Moor, Hemingbrough & Howden)', polygon => [[467000,415000],[489000,415000],[489000,442000],[467000,442000],[467000,415000]] };
$maps{"B:292"} = { bbox => [[519000, 415000], [541000, 445000]], area => '600', series => 'B', number => '292', parent => 'B:292', title => 'Withernsea & Spurn Head', polygon => [[519000,415000],[541000,415000],[541000,441000],[526000,441000],[526000,445000],[519000,445000],[519000,415000]] };
$maps{"B:292.a"} = { bbox => [[537000, 409000], [542500, 419000]], area => '55', series => 'B', number => '292', parent => 'B:292', title => 'Withernsea & Spurn Head', polygon => [[537000,409000],[542500,409000],[542500,419000],[537000,419000],[537000,409000]] };
$maps{"B:293"} = { bbox => [[489000, 424000], [519450, 444000]], area => '600.9875', series => 'B', number => '293', parent => 'B:293', title => 'Kingston upon Hull & Beverley', polygon => [[489000,424000],[519000,424000],[519000,427500],[519450,427900],[519450,429000],[519200,429300],[519000,429500],[519000,430000],[519350,430100],[519200,431000],[519000,431200],[519000,444000],[489000,444000],[489000,424000]] };
$maps{"B:294"} = { bbox => [[470000, 440000], [500000, 460000]], area => '600', series => 'B', number => '294', parent => 'B:294', title => 'Market Weighton & Yorkshire Wolds Central (Pocklington)', polygon => [[470000,440000],[500000,440000],[500000,460000],[470000,460000],[470000,440000]] };
$maps{"B:295"} = { bbox => [[500000, 444000], [522450, 471000]], area => '594.535', series => 'B', number => '295', parent => 'B:295', title => 'Bridlington, Driffield & Hornsea', polygon => [[500000,444000],[522000,444000],[522000,444500],[522200,444500],[522450,444900],[522450,445500],[522000,446100],[522000,471000],[500000,471000],[500000,444000]] };
$maps{"B:296"} = { bbox => [[330000, 440000], [350000, 470000]], area => '600', series => 'B', number => '296', parent => 'B:296', title => 'Lancaster, Morecambe & Fleetwood', polygon => [[330000,440000],[350000,440000],[350000,470000],[330000,470000],[330000,440000]] };
$maps{"B:297"} = { bbox => [[405000, 440000], [435000, 460000]], area => '600', series => 'B', number => '297', parent => 'B:297', title => 'Lower Wharfedale & Washburn Valley (Harrogate & Ilkley Moor)', polygon => [[405000,440000],[435000,440000],[435000,460000],[405000,460000],[405000,440000]] };
$maps{"B:298"} = { bbox => [[405000, 458000], [432200, 480000]], area => '594.03', series => 'B', number => '298', parent => 'B:298', title => 'Nidderdale (Fountains Abbey, Ripon & Pateley Bridge)', polygon => [[405000,458000],[432000,458000],[432000,470400],[432200,470500],[432000,470700],[432000,480000],[405000,480000],[405000,458000]] };
$maps{"B:299"} = { bbox => [[427000, 460000], [457000, 480000]], area => '600', series => 'B', number => '299', parent => 'B:299', title => 'Ripon & Boroughbridge (Easingwold)', polygon => [[427000,460000],[457000,460000],[457000,480000],[427000,480000],[427000,460000]] };
$maps{"B:300W"} = { bbox => [[457000, 460000], [477000, 480000]], area => '400', series => 'B', number => '300', parent => 'B:300W', title => 'Howardian Hills & Malton (Yorkshire Wolds North)', polygon => [[457000,460000],[477000,460000],[477000,480000],[457000,480000],[457000,460000]] };
$maps{"B:300E"} = { bbox => [[477000, 460000], [500000, 480000]], area => '460', series => 'B', number => '300', parent => 'B:300E', title => 'Howardian Hills & Malton (Yorkshire Wolds North)', polygon => [[477000,460000],[500000,460000],[500000,480000],[477000,480000],[477000,460000]] };
$maps{"B:301"} = { bbox => [[500000, 465000], [522000, 495000]], area => '600', series => 'B', number => '301', parent => 'B:301', title => 'Scarborough, Bridlington & Flamborough Head', polygon => [[500000,465000],[522000,465000],[522000,489000],[512000,489000],[512000,495000],[500000,495000],[500000,465000]] };
$maps{"B:301.a"} = { bbox => [[520000, 468000], [526000, 475000]], area => '42', series => 'B', number => '301', parent => 'B:301', title => 'Scarborough, Bridlington & Flamborough Head', polygon => [[520000,468000],[526000,468000],[526000,475000],[520000,475000],[520000,468000]] };
$maps{"B:302"} = { bbox => [[414000, 480000], [444200, 500000]], area => '600.205', series => 'B', number => '302', parent => 'B:302', title => 'Northallerton & Thirsk (Catterick & Bedale)', polygon => [[414000,480000],[444000,480000],[444000,480900],[444200,481100],[444100,482200],[444000,482600],[444000,500000],[414000,500000],[414000,480000]] };
$maps{"B:303"} = { bbox => [[292000, 503500], [314000, 533500]], area => '597.5', series => 'B', number => '303', parent => 'B:303', title => 'Whitehaven & Workington (Cockermouth & Egremont)', polygon => [[292000,503500],[314000,503500],[314000,533500],[297000,533500],[297000,521000],[292000,521000],[292000,503500]] };
$maps{"B:304E"} = { bbox => [[424000, 498000], [444000, 521000]], area => '460', series => 'B', number => '304', parent => 'B:304E', title => 'Darlington & Richmond (Egglescliffe & Gainford)', polygon => [[424000,498000],[444000,498000],[444000,521000],[424000,521000],[424000,498000]] };
$maps{"B:304W"} = { bbox => [[408000, 498000], [425000, 521000]], area => '391', series => 'B', number => '304', parent => 'B:304W', title => 'Darlington & Richmond (Egglescliffe & Gainford)', polygon => [[408000,498000],[425000,498000],[425000,521000],[408000,521000],[408000,498000]] };
$maps{"B:305"} = { bbox => [[410000, 520000], [440000, 540000]], area => '600', series => 'B', number => '305', parent => 'B:305', title => 'Bishop Auckland (Spennymoor, Newton Aycliffe, Sedgefield & Crook)', polygon => [[410000,520000],[440000,520000],[440000,540000],[410000,540000],[410000,520000]] };
$maps{"B:306"} = { bbox => [[440000, 516000], [470000, 538000]], area => '600', series => 'B', number => '306', parent => 'B:306', title => 'Middlesbrough & Hartlepool (Stockton-on-Tees & Redcar)', polygon => [[440000,516000],[470000,516000],[470000,532000],[460000,532000],[460000,538000],[440000,538000],[440000,516000]] };
$maps{"B:307"} = { bbox => [[390000, 537600], [420000, 560000]], area => '601.39', series => 'B', number => '307', parent => 'B:307', title => 'Consett & Derwent Reservoir (Stanhope)', polygon => [[390000,538000],[390800,538000],[391300,537700],[392000,537700],[393000,537600],[393500,537690],[394000,538000],[420000,538000],[420000,560000],[396000,560000],[396000,551000],[395000,550000],[390000,550000],[390000,538000]] };
$maps{"B:308"} = { bbox => [[418000, 538000], [448000, 560000]], area => '594', series => 'B', number => '308', parent => 'B:308', title => 'Durham & Sunderland (Chester-le-Street & Peterlee)', polygon => [[418000,538000],[448000,538000],[448000,544000],[445000,544000],[445000,551000],[443000,551000],[443000,560000],[418000,560000],[418000,538000]] };
$maps{"B:309N"} = { bbox => [[195500, 552000], [215500, 575000]], area => '460', series => 'B', number => '309', parent => 'B:309N', title => 'Stranraer & The Rhins', polygon => [[195500,552000],[215500,552000],[215500,575000],[195500,575000],[195500,552000]] };
$maps{"B:309S"} = { bbox => [[200000, 530000], [220000, 553000]], area => '388', series => 'B', number => '309', parent => 'B:309S', title => 'Stranraer & The Rhins', polygon => [[200000,542000],[206000,542000],[206000,530000],[220000,530000],[220000,553000],[200000,553000],[200000,542000]] };
$maps{"B:309S.a"} = { bbox => [[225000, 533000], [227000, 535000]], area => '4', series => 'B', number => '309', parent => 'B:309S', title => 'Stranraer & The Rhins', polygon => [[225000,533000],[227000,533000],[227000,535000],[225000,535000],[225000,533000]] };
$maps{"B:310"} = { bbox => [[215500, 548000], [235500, 578000]], area => '600', series => 'B', number => '310', parent => 'B:310', title => 'Glenluce & Kirkcowan', polygon => [[215500,548000],[235500,548000],[235500,578000],[215500,578000],[215500,548000]] };
$maps{"B:311"} = { bbox => [[228000, 533000], [250000, 563000]], area => '602.5', series => 'B', number => '311', parent => 'B:311', title => 'Wigtown, Whithorn & The Machars', polygon => [[228000,544500],[233000,544500],[233000,533000],[250000,533000],[250000,563000],[228000,563000],[228000,544500]] };
$maps{"B:312"} = { bbox => [[250000, 542850], [280420, 563400]], area => '601.27275', series => 'B', number => '312', parent => 'B:312', title => 'Kirkcudbright & Castle Douglas (Gatehouse of Fleet)', polygon => [[250000,543000],[265650,543000],[265800,542850],[266100,543000],[280000,543000],[280000,547000],[280420,547800],[280420,548200],[280000,549000],[280000,563000],[277700,563000],[277000,563350],[276500,563400],[276000,563350],[275500,563300],[275000,563000],[250000,563000],[250000,543000]] };
$maps{"B:313"} = { bbox => [[280000, 547150], [300000, 578000]], area => '600.2975', series => 'B', number => '313', parent => 'B:313', title => 'Dumfries & Dalbeattie (New Abbey & Mabie Forest)', polygon => [[280000,548000],[280000,547150],[280700,548000],[300000,548000],[300000,578000],[280000,578000],[280000,548000]] };
$maps{"B:314"} = { bbox => [[300000, 547000], [330000, 567000]], area => '600', series => 'B', number => '314', parent => 'B:314', title => 'Solway Firth (Wigton & Silloth)', polygon => [[300000,547000],[330000,547000],[330000,567000],[300000,567000],[300000,547000]] };
$maps{"B:315"} = { bbox => [[329500, 550000], [359500, 570000]], area => '600', series => 'B', number => '315', parent => 'B:315', title => 'Carlisle (Brampton, Longtown & Gretna Green)', polygon => [[329500,550000],[359500,550000],[359500,570000],[329500,570000],[329500,550000]] };
$maps{"B:316E"} = { bbox => [[419000, 560000], [442000, 580000]], area => '460', series => 'B', number => '316', parent => 'B:316E', title => 'Newcastle upon Tyne (Gateshead, South Shields, Prudhoe, Ponteland, Cramlington & Whitley Bay)', polygon => [[419000,560000],[442000,560000],[442000,580000],[419000,580000],[419000,560000]] };
$maps{"B:316W"} = { bbox => [[400000, 560000], [420000, 580000]], area => '400', series => 'B', number => '316', parent => 'B:316W', title => 'Newcastle upon Tyne (Gateshead, South Shields, Prudhoe, Ponteland, Cramlington & Whitley Bay)', polygon => [[400000,560000],[420000,560000],[420000,580000],[400000,580000],[400000,560000]] };
$maps{"B:317"} = { bbox => [[204000, 575000], [234000, 597000]], area => '600.99', series => 'B', number => '317', parent => 'B:317', title => 'Ballantrae, Barr & Barrhill', polygon => [[204000,575000],[234000,575000],[234000,597000],[209000,597000],[209000,586800],[207900,585000],[204000,585000],[204000,575000]] };
$maps{"B:317.a"} = { bbox => [[201000, 598500], [203500, 601000]], area => '6.25', series => 'B', number => '317', parent => 'B:317', title => 'Ballantrae, Barr & Barrhill', polygon => [[201000,598500],[203500,598500],[203500,601000],[201000,601000],[201000,598500]] };
$maps{"B:318"} = { bbox => [[232500, 578000], [262500, 600000]], area => '600', series => 'B', number => '318', parent => 'B:318', title => 'Galloway Forest Park North (Glen Trool, Loch Doon & St John’s Town of Dalry)', polygon => [[232500,578000],[262500,578000],[262500,590000],[256500,590000],[256500,600000],[232500,600000],[232500,578000]] };
$maps{"B:319"} = { bbox => [[234750, 562000], [265670, 582000]], area => '601.69275', series => 'B', number => '319', parent => 'B:319', title => 'Galloway Forest Park South (Glen Trool, Clatteringshaws Loch & Newton Stewart)', polygon => [[235250,562000],[265250,562000],[265250,569000],[265500,569200],[265400,570000],[265370,570350],[265670,571000],[265670,572000],[265500,572500],[265450,573000],[265260,573400],[265250,582000],[235250,582000],[235250,577500],[234750,576800],[235250,575500],[235250,562000]] };
$maps{"B:320"} = { bbox => [[261000, 561600], [281000, 592000]], area => '600.41', series => 'B', number => '320', parent => 'B:320', title => 'Castle Douglas, Loch Ken & New Galloway (St John’s Town of Dalry & Moniaive)', polygon => [[261000,562000],[275600,562000],[276000,561800],[276300,561600],[276800,561600],[277200,562000],[281000,562000],[281000,592000],[261000,592000],[261000,562000]] };
$maps{"B:321"} = { bbox => [[278000, 573000], [300000, 600000]], area => '594', series => 'B', number => '321', parent => 'B:321', title => 'Nithsdale & Dumfries (Thornhill)', polygon => [[278000,573000],[300000,573000],[300000,600000],[278000,600000],[278000,573000]] };
$maps{"B:322S"} = { bbox => [[300000, 564000], [323000, 584000]], area => '460', series => 'B', number => '322', parent => 'B:322S', title => 'Annandale (Annan, Lockerbie & Beattock)', polygon => [[300000,564000],[323000,564000],[323000,584000],[300000,584000],[300000,564000]] };
$maps{"B:322N"} = { bbox => [[300000, 584000], [320000, 604000]], area => '400', series => 'B', number => '322', parent => 'B:322N', title => 'Annandale (Annan, Lockerbie & Beattock)', polygon => [[300000,584000],[320000,584000],[320000,604000],[300000,604000],[300000,584000]] };
$maps{"B:323N"} = { bbox => [[318000, 584000], [341000, 604000]], area => '460', series => 'B', number => '323', parent => 'B:323N', title => 'Eskdale & Castle O’er Forest (Langholm, Canonbie & Gretna Green)', polygon => [[318000,584000],[341000,584000],[341000,604000],[318000,604000],[318000,584000]] };
$maps{"B:323S"} = { bbox => [[321000, 563700], [341000, 584000]], area => '400.195', series => 'B', number => '323', parent => 'B:323S', title => 'Eskdale & Castle O’er Forest (Langholm, Canonbie & Gretna Green)', polygon => [[321000,564000],[325900,564000],[326500,563700],[326700,563700],[327000,564000],[341000,564000],[341000,584000],[321000,584000],[321000,564000]] };
$maps{"B:324"} = { bbox => [[338000, 570000], [358000, 600000]], area => '600', series => 'B', number => '324', parent => 'B:324', title => 'Liddesdale & Kershope Forest (Newcastleton & Canonbie)', polygon => [[338000,570000],[358000,570000],[358000,600000],[338000,600000],[338000,570000]] };
$maps{"B:325"} = { bbox => [[406000, 580000], [433200, 602000]], area => '594.05', series => 'B', number => '325', parent => 'B:325', title => 'Morpeth & Blyth (Ashington & Longframlington)', polygon => [[406000,580000],[433000,580000],[433000,580500],[433200,580750],[433000,581000],[433000,602000],[406000,602000],[406000,580000]] };
$maps{"B:326N"} = { bbox => [[225000, 614000], [248000, 634000]], area => '400', series => 'B', number => '326', parent => 'B:326N', title => 'Ayr & Troon (Girvan & Maybole)', polygon => [[225000,614000],[248000,614000],[248000,634000],[230000,634000],[230000,622000],[225000,622000],[225000,614000]] };
$maps{"B:326S"} = { bbox => [[217000, 596000], [240000, 616000]], area => '460', series => 'B', number => '326', parent => 'B:326S', title => 'Ayr & Troon (Girvan & Maybole)', polygon => [[217000,596000],[240000,596000],[240000,616000],[217000,616000],[217000,596000]] };
$maps{"B:327"} = { bbox => [[240000, 600000], [260000, 630000]], area => '600', series => 'B', number => '327', parent => 'B:327', title => 'Cumnock & Dalmellington (Mauchline & Patna)', polygon => [[240000,600000],[260000,600000],[260000,630000],[240000,630000],[240000,600000]] };
$maps{"B:328N"} = { bbox => [[259000, 610000], [279000, 630000]], area => '400', series => 'B', number => '328', parent => 'B:328N', title => 'Sanquhar & New Cumnock (Muirkirk & Moniaive)', polygon => [[259000,610000],[279000,610000],[279000,630000],[259000,630000],[259000,610000]] };
$maps{"B:328S"} = { bbox => [[256000, 590000], [279000, 610000]], area => '460', series => 'B', number => '328', parent => 'B:328S', title => 'Sanquhar & New Cumnock (Muirkirk & Moniaive)', polygon => [[256000,590000],[279000,590000],[279000,610000],[256000,610000],[256000,590000]] };
$maps{"B:329"} = { bbox => [[277600, 597000], [300000, 624000]], area => '594.37375', series => 'B', number => '329', parent => 'B:329', title => 'Lowther Hills, Sanquhar & Leadhills (Wanlockhead & Crawford)', polygon => [[278000,597000],[300000,597000],[300000,624000],[278000,624000],[278000,610750],[277750,610500],[277600,610000],[277800,609600],[278000,609000],[278000,597000]] };
$maps{"B:330"} = { bbox => [[300000, 604000], [330000, 624000]], area => '600', series => 'B', number => '330', parent => 'B:330', title => 'Moffat & St Mary’s Loch (Megget Reservoir)', polygon => [[300000,604000],[330000,604000],[330000,624000],[300000,624000],[300000,604000]] };
$maps{"B:331"} = { bbox => [[330000, 600000], [360000, 620000]], area => '600', series => 'B', number => '331', parent => 'B:331', title => 'Teviotdale South (Hawick)', polygon => [[330000,600000],[360000,600000],[360000,620000],[330000,620000],[330000,600000]] };
$maps{"B:332"} = { bbox => [[402000, 601050], [432000, 624000]], area => '595.68', series => 'B', number => '332', parent => 'B:332', title => 'Alnwick & Amble (Craster & Whittingham)', polygon => [[402000,602000],[404000,602000],[404500,601500],[405000,601200],[405500,601050],[406500,601050],[407000,601240],[407500,601550],[408000,602000],[432000,602000],[432000,607000],[429000,607000],[429000,616000],[427000,616000],[427000,624000],[402000,624000],[402000,602000]] };
$maps{"B:333"} = { bbox => [[226000, 629000], [248000, 659000]], area => '600', series => 'B', number => '333', parent => 'B:333', title => 'Kilmarnock & Irvine (Stewarton & Beith)', polygon => [[226000,629000],[248000,629000],[248000,659000],[232000,659000],[232000,649000],[226000,649000],[226000,629000]] };
$maps{"B:334"} = { bbox => [[248000, 629000], [270000, 656000]], area => '594', series => 'B', number => '334', parent => 'B:334', title => 'East Kilbride, Galston & Darvel (Loudoun Hill & Whitelee Forest)', polygon => [[248000,629000],[270000,629000],[270000,656000],[248000,656000],[248000,629000]] };
$maps{"B:335"} = { bbox => [[269000, 624000], [299000, 646000]], area => '600', series => 'B', number => '335', parent => 'B:335', title => 'Lanark & Tinto Hills (Lesmahagow & Douglas)', polygon => [[269000,630000],[279000,630000],[279000,624000],[299000,624000],[299000,646000],[269000,646000],[269000,630000]] };
$maps{"B:336"} = { bbox => [[298000, 622000], [320000, 649000]], area => '594', series => 'B', number => '336', parent => 'B:336', title => 'Biggar & Broughton (Culter Fell & Dollar Law)', polygon => [[298000,622000],[320000,622000],[320000,649000],[298000,649000],[298000,622000]] };
$maps{"B:337"} = { bbox => [[320000, 620000], [340000, 650000]], area => '600', series => 'B', number => '337', parent => 'B:337', title => 'Peebles & Innerleithen (Eddleston, Ettrickbridge, Traquair & Yarrow)', polygon => [[320000,620000],[340000,620000],[340000,650000],[320000,650000],[320000,620000]] };
$maps{"B:338"} = { bbox => [[340000, 620000], [362000, 650000]], area => '596', series => 'B', number => '338', parent => 'B:338', title => 'Galashiels, Selkirk & Melrose (St Boswell’s & Lauder)', polygon => [[340000,620000],[362000,620000],[362000,636000],[359000,636000],[359000,639000],[357000,639000],[357000,650000],[340000,650000],[340000,620000]] };
$maps{"B:339W"} = { bbox => [[357000, 630000], [377000, 650000]], area => '400', series => 'B', number => '339', parent => 'B:339W', title => 'Kelso, Coldstream & Lower Tweed Valley', polygon => [[357000,630000],[377000,630000],[377000,650000],[357000,650000],[357000,630000]] };
$maps{"B:339E"} = { bbox => [[377000, 630000], [400000, 650000]], area => '460', series => 'B', number => '339', parent => 'B:339E', title => 'Kelso, Coldstream & Lower Tweed Valley', polygon => [[377000,630000],[400000,630000],[400000,650000],[377000,650000],[377000,630000]] };
$maps{"B:340"} = { bbox => [[398500, 624000], [426000, 646000]], area => '594.6375', series => 'B', number => '340', parent => 'B:340', title => 'Holy Island & Bamburgh (Wooler, Belford & Seahouses)', polygon => [[399000,624000],[426000,624000],[426000,646000],[399000,646000],[399000,628900],[398500,628500],[398500,627700],[399000,627150],[399000,624000]] };
$maps{"B:340.a"} = { bbox => [[400000, 645000], [407000, 650000]], area => '35', series => 'B', number => '340', parent => 'B:340', title => 'Holy Island & Bamburgh (Wooler, Belford & Seahouses)', polygon => [[400000,645000],[407000,645000],[407000,650000],[400000,650000],[400000,645000]] };
$maps{"B:341N"} = { bbox => [[218000, 658000], [241000, 678300]], area => '460.465', series => 'B', number => '341', parent => 'B:341N', title => 'Greenock, Largs & Millport (Clyde Muirshiel Regional Park)', polygon => [[218000,658000],[241000,658000],[241000,678000],[226500,678000],[226000,678300],[225200,678300],[225100,678000],[224500,678000],[224400,678300],[224100,678300],[223900,678000],[218000,678000],[218000,658000]] };
$maps{"B:341S"} = { bbox => [[213000, 640000], [237000, 660000]], area => '401.3', series => 'B', number => '341', parent => 'B:341S', title => 'Greenock, Largs & Millport (Clyde Muirshiel Regional Park)', polygon => [[214000,640000],[232000,640000],[232000,652000],[237000,652000],[237000,660000],[214000,660000],[214000,652300],[213000,651500],[213000,651000],[214000,650200],[214000,640000]] };
$maps{"B:342"} = { bbox => [[241000, 655000], [271000, 675000]], area => '600', series => 'B', number => '342', parent => 'B:342', title => 'Glasgow (Paisley, Rutherglen & Kirkintilloch)', polygon => [[241000,655000],[271000,655000],[271000,675000],[241000,675000],[241000,655000]] };
$maps{"B:343"} = { bbox => [[270000, 646000], [300000, 666000]], area => '600', series => 'B', number => '343', parent => 'B:343', title => 'Motherwell & Coatbridge (Whitburn & Carluke)', polygon => [[270000,646000],[300000,646000],[300000,666000],[270000,666000],[270000,646000]] };
$maps{"B:344"} = { bbox => [[300000, 648000], [330000, 668000]], area => '600', series => 'B', number => '344', parent => 'B:344', title => 'Pentland Hills (Penicuik & West Linton)', polygon => [[300000,648000],[330000,648000],[330000,668000],[300000,668000],[300000,648000]] };
$maps{"B:345W"} = { bbox => [[329000, 650000], [349000, 670000]], area => '400', series => 'B', number => '345', parent => 'B:345W', title => 'Lammermuir Hills (Dalkeith, Bonnyrigg & Gifford)', polygon => [[329000,650000],[349000,650000],[349000,670000],[329000,670000],[329000,650000]] };
$maps{"B:345E"} = { bbox => [[349000, 650000], [372000, 670000]], area => '460', series => 'B', number => '345', parent => 'B:345E', title => 'Lammermuir Hills (Dalkeith, Bonnyrigg & Gifford)', polygon => [[349000,650000],[372000,650000],[372000,670000],[349000,670000],[349000,650000]] };
$maps{"B:346"} = { bbox => [[372000, 650000], [402000, 672200]], area => '591.81', series => 'B', number => '346', parent => 'B:346', title => 'Berwick-upon-Tweed (Eyemouth, Duns, St Abb’s Head & Cockburnspath)', polygon => [[372000,650000],[402000,650000],[402000,659000],[399000,659000],[399000,665500],[394500,665500],[394500,672000],[378900,672000],[378600,672200],[378300,672000],[372000,672000],[372000,650000]] };
$maps{"B:347/OL38"} = { bbox => [[220500, 673000], [251200, 695000]], area => '601.095', series => 'B', number => '347/OL38', parent => 'B:347/OL38', title => 'Loch Lomond South (Dumbarton, Helensburgh, Drymen & Cove)', polygon => [[221000,679000],[231000,679000],[231000,673000],[251000,673000],[251000,680600],[251200,680700],[251200,681300],[251000,681700],[251000,695000],[221000,695000],[221000,689500],[220500,688800],[220500,687600],[221000,687000],[221000,679000]] };
$maps{"B:348"} = { bbox => [[250000, 674300], [280000, 695000]], area => '601.26', series => 'B', number => '348', parent => 'B:348', title => 'Campsie Fells (Kilsyth, Strathblane & Fintry)', polygon => [[250000,675000],[254000,675000],[254800,674300],[255500,674300],[256900,675000],[280000,675000],[280000,695000],[250000,695000],[250000,675000]] };
$maps{"B:349W"} = { bbox => [[270000, 665000], [290000, 688000]], area => '460', series => 'B', number => '349', parent => 'B:349W', title => 'Falkirk, Cumbernauld & Livingston (Linlithgow, Bathgate & Kilsyth)', polygon => [[270000,665000],[290000,665000],[290000,688000],[270000,688000],[270000,665000]] };
$maps{"B:349E"} = { bbox => [[288000, 665000], [308000, 688000]], area => '400', series => 'B', number => '349', parent => 'B:349E', title => 'Falkirk, Cumbernauld & Livingston (Linlithgow, Bathgate & Kilsyth)', polygon => [[288000,665000],[308000,665000],[308000,683000],[296000,683000],[296000,688000],[288000,688000],[288000,665000]] };
$maps{"B:350"} = { bbox => [[307000, 666000], [337000, 686000]], area => '600', series => 'B', number => '350', parent => 'B:350', title => 'Edinburgh (Musselburgh & Queensferry)', polygon => [[307000,666000],[337000,666000],[337000,686000],[307000,686000],[307000,666000]] };
$maps{"B:351E"} = { bbox => [[355000, 668000], [378200, 688000]], area => '400.12', series => 'B', number => '351', parent => 'B:351E', title => 'Dunbar & North Berwick (Musselburgh & Haddington)', polygon => [[355000,668000],[378000,668000],[378000,671900],[378200,672000],[378200,672400],[378000,672700],[378000,683000],[366000,683000],[366000,688000],[355000,688000],[355000,668000]] };
$maps{"B:351W"} = { bbox => [[332000, 668000], [355000, 688000]], area => '460', series => 'B', number => '351', parent => 'B:351W', title => 'Dunbar & North Berwick (Musselburgh & Haddington)', polygon => [[332000,668000],[355000,668000],[355000,688000],[332000,688000],[332000,668000]] };
$maps{"B:352"} = { bbox => [[126000, 639700], [148000, 667000]], area => '594.135', series => 'B', number => '352', parent => 'B:352', title => 'Islay South (Port Ellen, Bowmore & Bridgend / Port Eilein, Bogh Mor & Beul an Atha)', polygon => [[126000,640000],[130500,640000],[131000,639700],[131400,640000],[148000,640000],[148000,667000],[126000,667000],[126000,640000]] };
$maps{"B:353E"} = { bbox => [[125000, 661000], [145000, 681000]], area => '400', series => 'B', number => '353', parent => 'B:353E', title => 'Islay North (Port Askaig, Bridgend & Port Charlotte / Port Asgaig, Beul an Atha & Port Sgioba)', polygon => [[125000,661000],[145000,661000],[145000,681000],[125000,681000],[125000,661000]] };
$maps{"B:353W"} = { bbox => [[115000, 651000], [135000, 672000]], area => '420', series => 'B', number => '353', parent => 'B:353W', title => 'Islay North (Port Askaig, Bridgend & Port Charlotte / Port Asgaig, Beul an Atha & Port Sgioba)', polygon => [[115000,651000],[135000,651000],[135000,672000],[115000,672000],[115000,651000]] };
$maps{"B:354"} = { bbox => [[130000, 675000], [152000, 702000]], area => '594', series => 'B', number => '354', parent => 'B:354', title => 'Colonsay & Oronsay', polygon => [[130000,675000],[152000,675000],[152000,702000],[130000,702000],[130000,675000]] };
$maps{"B:355S"} = { bbox => [[142000, 662000], [162000, 682000]], area => '400', series => 'B', number => '355', parent => 'B:355S', title => 'Jura & Scarba', polygon => [[142000,662000],[162000,662000],[162000,682000],[142000,682000],[142000,662000]] };
$maps{"B:355N"} = { bbox => [[150100, 682000], [173900, 702000]], area => '461.105', series => 'B', number => '355', parent => 'B:355N', title => 'Jura & Scarba', polygon => [[150500,682000],[173500,682000],[173500,698600],[173900,699200],[173900,699700],[173500,700000],[173500,702000],[150500,702000],[150500,684800],[150200,684300],[150100,683300],[150100,682600],[150500,682500],[150500,682000]] };
$maps{"B:355N.a"} = { bbox => [[167000, 700000], [173000, 707000]], area => '42', series => 'B', number => '355', parent => 'B:355N', title => 'Jura & Scarba', polygon => [[167000,700000],[173000,700000],[173000,707000],[167000,707000],[167000,700000]] };
$maps{"B:356N"} = { bbox => [[163000, 625000], [183000, 645000]], area => '400', series => 'B', number => '356', parent => 'B:356N', title => 'Kintyre South (Campbeltown)', polygon => [[163000,625000],[183000,625000],[183000,645000],[163000,645000],[163000,625000]] };
$maps{"B:356S"} = { bbox => [[158000, 603000], [178000, 626000]], area => '460', series => 'B', number => '356', parent => 'B:356S', title => 'Kintyre South (Campbeltown)', polygon => [[158000,603000],[178000,603000],[178000,626000],[158000,626000],[158000,603000]] };
$maps{"B:357N"} = { bbox => [[170000, 653000], [193000, 673000]], area => '460', series => 'B', number => '357', parent => 'B:357N', title => 'Kintyre North (Knapdale South, Isle of Gigha & Tarbert)', polygon => [[170000,653000],[193000,653000],[193000,673000],[170000,673000],[170000,653000]] };
$maps{"B:357S"} = { bbox => [[162000, 643000], [185000, 660000]], area => '391', series => 'B', number => '357', parent => 'B:357S', title => 'Kintyre North (Knapdale South, Isle of Gigha & Tarbert)', polygon => [[162000,643000],[185000,643000],[185000,660000],[162000,660000],[162000,643000]] };
$maps{"B:358N"} = { bbox => [[172000, 687000], [198000, 707000]], area => '520', series => 'B', number => '358', parent => 'B:358N', title => 'Lochgilphead & Knapdale North (Kilmartin)', polygon => [[172000,687000],[198000,687000],[198000,707000],[172000,707000],[172000,687000]] };
$maps{"B:358S"} = { bbox => [[166000, 671000], [192000, 691000]], area => '460', series => 'B', number => '358', parent => 'B:358S', title => 'Lochgilphead & Knapdale North (Kilmartin)', polygon => [[166000,671000],[187000,671000],[187000,683000],[192000,683000],[192000,691000],[166000,691000],[166000,671000]] };
$maps{"B:359"} = { bbox => [[170100, 705000], [192500, 735500]], area => '542.165', series => 'B', number => '359', parent => 'B:359', title => 'Oban, Kerrera & Loch Melfort (The Garvellachs)', polygon => [[170500,705500],[173500,705500],[174400,705000],[174600,705000],[175400,705500],[186500,705500],[186500,715500],[192500,715500],[192500,735500],[179500,735500],[179500,729000],[170500,729000],[170500,715200],[170100,715100],[170100,714900],[170500,714700],[170500,705500]] };
$maps{"B:359.a"} = { bbox => [[163000, 707500], [171000, 713000]], area => '44', series => 'B', number => '359', parent => 'B:359', title => 'Oban, Kerrera & Loch Melfort (The Garvellachs)', polygon => [[163000,707500],[171000,707500],[171000,713000],[163000,713000],[163000,707500]] };
$maps{"B:360N"} = { bbox => [[192500, 712000], [218500, 729000]], area => '442', series => 'B', number => '360', parent => 'B:360N', title => 'Loch Awe & Inveraray (Dalmally, Dalavich & Furnace)', polygon => [[192500,712000],[218500,712000],[218500,729000],[192500,729000],[192500,712000]] };
$maps{"B:360S"} = { bbox => [[185000, 696000], [211000, 716000]], area => '520', series => 'B', number => '360', parent => 'B:360S', title => 'Loch Awe & Inveraray (Dalmally, Dalavich & Furnace)', polygon => [[185000,696000],[211000,696000],[211000,716000],[185000,716000],[185000,696000]] };
$maps{"B:361N"} = { bbox => [[186000, 633000], [206000, 653000]], area => '400', series => 'B', number => '361', parent => 'B:361N', title => 'Isle of Arran', polygon => [[186000,633000],[206000,633000],[206000,653000],[186000,653000],[186000,633000]] };
$maps{"B:361S"} = { bbox => [[186000, 618000], [209000, 638000]], area => '460', series => 'B', number => '361', parent => 'B:361S', title => 'Isle of Arran', polygon => [[186000,618000],[209000,618000],[209000,638000],[186000,638000],[186000,618000]] };
$maps{"B:362S"} = { bbox => [[192000, 651500], [212000, 675000]], area => '400.575', series => 'B', number => '362', parent => 'B:362S', title => 'Cowal West & Isle of Bute (Rothesay)', polygon => [[192000,657000],[204000,657000],[204000,652000],[209000,652000],[209500,651500],[210200,651500],[210600,652000],[212000,652000],[212000,675000],[192000,675000],[192000,657000]] };
$maps{"B:362S.a"} = { bbox => [[190000, 669000], [194000, 675000]], area => '24', series => 'B', number => '362', parent => 'B:362S', title => 'Cowal West & Isle of Bute (Rothesay)', polygon => [[190000,669000],[194000,669000],[194000,675000],[190000,675000],[190000,669000]] };
$maps{"B:362N"} = { bbox => [[190000, 675000], [210000, 698900]], area => '463.065', series => 'B', number => '362', parent => 'B:362N', title => 'Cowal West & Isle of Bute (Rothesay)', polygon => [[190000,675000],[210000,675000],[210000,698000],[206500,698000],[205850,698650],[205400,698900],[203500,698900],[202800,698400],[202400,698400],[201500,698000],[190000,698000],[190000,675000]] };
$maps{"B:363/OL37S"} = { bbox => [[205000, 667000], [225000, 690000]], area => '400', series => 'B', number => '363/OL37', parent => 'B:363/OL37S', title => 'Cowal East (Dunoon & Inveraray)', polygon => [[205000,667000],[219000,667000],[219000,677000],[225000,677000],[225000,690000],[205000,690000],[205000,667000]] };
$maps{"B:363/OL37N"} = { bbox => [[204720, 690000], [225000, 713000]], area => '460.525', series => 'B', number => '363/OL37', parent => 'B:363/OL37N', title => 'Cowal East (Dunoon & Inveraray)', polygon => [[205000,690000],[225000,690000],[225000,713000],[205000,713000],[205000,699000],[204720,698550],[204720,697100],[205000,696700],[205000,690000]] };
$maps{"B:364/OL39S"} = { bbox => [[218500, 693000], [241500, 713000]], area => '400', series => 'B', number => '364/OL39', parent => 'B:364/OL39S', title => 'Loch Lomond North (Tyndrum, Crianlarich & Arrochar)', polygon => [[218500,703000],[224500,703000],[224500,693000],[241500,693000],[241500,713000],[218500,713000],[218500,703000]] };
$maps{"B:364/OL39N"} = { bbox => [[218500, 712000], [241500, 732000]], area => '460', series => 'B', number => '364/OL39', parent => 'B:364/OL39N', title => 'Loch Lomond North (Tyndrum, Crianlarich & Arrochar)', polygon => [[218500,712000],[241500,712000],[241500,732000],[218500,732000],[218500,712000]] };
$maps{"B:365/OL46S"} = { bbox => [[241500, 693000], [265350, 713000]], area => '460.7', series => 'B', number => '365/OL46', parent => 'B:365/OL46S', title => 'The Trossachs (Callander, Aberfoyle & Lochearnhead, Balquhidder & Strathyre)', polygon => [[241500,693000],[264500,693000],[264500,694000],[265000,694000],[265350,694500],[264500,695000],[265000,695500],[264500,695600],[264500,713000],[241500,713000],[241500,693000]] };
$maps{"B:365/OL46N"} = { bbox => [[241500, 713000], [264500, 730000]], area => '391', series => 'B', number => '365/OL46', parent => 'B:365/OL46N', title => 'The Trossachs (Callander, Aberfoyle & Lochearnhead, Balquhidder & Strathyre)', polygon => [[241500,713000],[264500,713000],[264500,730000],[241500,730000],[241500,713000]] };
$maps{"B:366W"} = { bbox => [[263000, 687000], [283000, 710000]], area => '400', series => 'B', number => '366', parent => 'B:366W', title => 'Stirling & Ochil Hills West (Alloa & Dunblane)', polygon => [[263000,693000],[273000,693000],[273000,687000],[283000,687000],[283000,710000],[263000,710000],[263000,693000]] };
$maps{"B:366E"} = { bbox => [[280000, 687000], [300000, 710000]], area => '460', series => 'B', number => '366', parent => 'B:366E', title => 'Stirling & Ochil Hills West (Alloa & Dunblane)', polygon => [[280000,687000],[300000,687000],[300000,710000],[280000,710000],[280000,687000]] };
$maps{"B:367W"} = { bbox => [[293000, 680000], [316000, 700000]], area => '400', series => 'B', number => '367', parent => 'B:367W', title => 'Dunfermline, Kirkcaldy & Glenrothes South (Methil & Culross)', polygon => [[293000,680000],[316000,680000],[316000,700000],[299000,700000],[299000,690000],[293000,690000],[293000,680000]] };
$maps{"B:367E"} = { bbox => [[316000, 682000], [339000, 702000]], area => '460', series => 'B', number => '367', parent => 'B:367E', title => 'Dunfermline, Kirkcaldy & Glenrothes South (Methil & Culross)', polygon => [[316000,682000],[339000,682000],[339000,702000],[316000,702000],[316000,682000]] };
$maps{"B:367E.a"} = { bbox => [[338000, 700000], [343000, 704000]], area => '20', series => 'B', number => '367', parent => 'B:367E', title => 'Dunfermline, Kirkcaldy & Glenrothes South (Methil & Culross)', polygon => [[338000,700000],[343000,700000],[343000,704000],[338000,704000],[338000,700000]] };
$maps{"B:368/OL47W"} = { bbox => [[261500, 708000], [281500, 731000]], area => '460', series => 'B', number => '368/OL47', parent => 'B:368/OL47W', title => 'Crieff, Comrie & Glen Artney (Strathearn & Auchterarder)', polygon => [[261500,708000],[281500,708000],[281500,731000],[261500,731000],[261500,708000]] };
$maps{"B:368/OL47E"} = { bbox => [[281000, 708000], [298000, 731000]], area => '391', series => 'B', number => '368/OL47', parent => 'B:368/OL47E', title => 'Crieff, Comrie & Glen Artney (Strathearn & Auchterarder)', polygon => [[281000,708000],[298000,708000],[298000,731000],[281000,731000],[281000,708000]] };
$maps{"B:369"} = { bbox => [[298000, 698000], [318000, 728000]], area => '600', series => 'B', number => '369', parent => 'B:369', title => 'Perth & Kinross (Ochil Hills East & Loch Leven)', polygon => [[298000,698000],[318000,698000],[318000,728000],[298000,728000],[298000,698000]] };
$maps{"B:370"} = { bbox => [[315000, 700000], [345000, 722000]], area => '600', series => 'B', number => '370', parent => 'B:370', title => 'Glenrothes North, Falkland & Lomond Hills (Auchtermuchty & Cupar)', polygon => [[315000,700000],[345000,700000],[345000,716000],[335000,716000],[335000,722000],[315000,722000],[315000,700000]] };
$maps{"B:371S"} = { bbox => [[342000, 699000], [365000, 719000]], area => '460', series => 'B', number => '371', parent => 'B:371S', title => 'St Andrews & East Fife (Cupar, Anstruther & Crail)', polygon => [[342000,699000],[365000,699000],[365000,719000],[342000,719000],[342000,699000]] };
$maps{"B:371S.a"} = { bbox => [[364500, 698500], [366500, 700500]], area => '4', series => 'B', number => '371', parent => 'B:371S', title => 'St Andrews & East Fife (Cupar, Anstruther & Crail)', polygon => [[364500,698500],[366500,698500],[366500,700500],[364500,700500],[364500,698500]] };
$maps{"B:371N"} = { bbox => [[330000, 713000], [353000, 730000]], area => '391', series => 'B', number => '371', parent => 'B:371N', title => 'St Andrews & East Fife (Cupar, Anstruther & Crail)', polygon => [[330000,713000],[353000,713000],[353000,730000],[330000,730000],[330000,713000]] };
$maps{"B:372E"} = { bbox => [[108000, 747000], [131000, 767000]], area => '460', series => 'B', number => '372', parent => 'B:372E', title => 'Coll & Tiree', polygon => [[108000,747000],[131000,747000],[131000,767000],[108000,767000],[108000,747000]] };
$maps{"B:372W"} = { bbox => [[90000, 735000], [110000, 755000]], area => '400', series => 'B', number => '372', parent => 'B:372W', title => 'Coll & Tiree', polygon => [[90000,735000],[110000,735000],[110000,755000],[90000,755000],[90000,735000]] };
$maps{"B:373"} = { bbox => [[123500, 711000], [154700, 733000]], area => '601.425', series => 'B', number => '373', parent => 'B:373', title => 'Iona, Staffa & Ross of Mull', polygon => [[124000,711000],[144000,711000],[144000,717000],[154000,717000],[154000,728200],[154550,728450],[154700,729300],[154000,729600],[154000,733000],[124000,733000],[124000,726400],[123800,726300],[123800,726200],[124000,726000],[124000,720300],[123700,719500],[123700,719000],[124000,718500],[124000,714400],[123500,714200],[123500,713800],[124000,713500],[124000,711000]] };
$maps{"B:373.a"} = { bbox => [[131000, 734000], [134000, 737000]], area => '9', series => 'B', number => '373', parent => 'B:373', title => 'Iona, Staffa & Ross of Mull', polygon => [[131000,734000],[134000,734000],[134000,737000],[131000,737000],[131000,734000]] };
$maps{"B:374E"} = { bbox => [[140000, 737000], [160000, 760000]], area => '460', series => 'B', number => '374', parent => 'B:374E', title => 'Isle of Mull North & Tobermory (Ulva, Staffa & Treshnish Isles)', polygon => [[140000,737000],[160000,737000],[160000,760000],[140000,760000],[140000,737000]] };
$maps{"B:374W"} = { bbox => [[123000, 734000], [143000, 757000]], area => '400', series => 'B', number => '374', parent => 'B:374W', title => 'Isle of Mull North & Tobermory (Ulva, Staffa & Treshnish Isles)', polygon => [[123000,734000],[143000,734000],[143000,757000],[129000,757000],[129000,747000],[123000,747000],[123000,734000]] };
$maps{"B:375E"} = { bbox => [[156000, 719300], [176000, 743700]], area => '463.8', series => 'B', number => '375', parent => 'B:375E', title => 'Isle of Mull East (Craignure)', polygon => [[156000,720000],[161000,720000],[162000,719600],[162500,719300],[163300,719300],[164000,720000],[176000,720000],[176000,743000],[163600,743000],[162400,743700],[159800,743700],[159000,743000],[156000,743000],[156000,720000]] };
$maps{"B:375W"} = { bbox => [[140000, 720000], [160000, 743000]], area => '400', series => 'B', number => '375', parent => 'B:375W', title => 'Isle of Mull East (Craignure)', polygon => [[140000,726000],[150000,726000],[150000,720000],[160000,720000],[160000,743000],[140000,743000],[140000,726000]] };
$maps{"B:376"} = { bbox => [[178600, 728000], [201000, 758000]], area => '600.28', series => 'B', number => '376', parent => 'B:376', title => 'Oban & North Lorn (Benderloch, Lismore & Loch Creran)', polygon => [[179000,728000],[201000,728000],[201000,758000],[185000,758000],[185000,748000],[179000,748000],[179000,739500],[178600,739000],[178600,738800],[179000,738300],[179000,728000]] };
$maps{"B:376.a"} = { bbox => [[177000, 734000], [179500, 737500]], area => '8.75', series => 'B', number => '376', parent => 'B:376', title => 'Oban & North Lorn (Benderloch, Lismore & Loch Creran)', polygon => [[177000,734000],[179500,734000],[179500,737500],[177000,737500],[177000,734000]] };
$maps{"B:377W"} = { bbox => [[199000, 725000], [219000, 745000]], area => '400', series => 'B', number => '377', parent => 'B:377W', title => 'Loch Etive & Glen Orchy (Dalmally, Tyndrum, Bridge of Orchy & Taynuilt)', polygon => [[199000,725000],[219000,725000],[219000,745000],[199000,745000],[199000,725000]] };
$maps{"B:377E"} = { bbox => [[219000, 725000], [239000, 748000]], area => '460', series => 'B', number => '377', parent => 'B:377E', title => 'Loch Etive & Glen Orchy (Dalmally, Tyndrum, Bridge of Orchy & Taynuilt)', polygon => [[219000,725000],[239000,725000],[239000,748000],[219000,748000],[219000,725000]] };
$maps{"B:378/OL48W"} = { bbox => [[237000, 730000], [257500, 750000]], area => '400.88', series => 'B', number => '378/OL48', parent => 'B:378/OL48W', title => 'Ben Lawers & Glen Lyon (Loch Tay, Killin & Kenmore)', polygon => [[237000,730000],[257000,730000],[257000,732200],[257500,732600],[257500,733800],[257100,734400],[257000,734400],[257000,750000],[237000,750000],[237000,730000]] };
$maps{"B:378/OL48E"} = { bbox => [[256880, 730000], [277520, 753000]], area => '460.5775', series => 'B', number => '378/OL48', parent => 'B:378/OL48E', title => 'Ben Lawers & Glen Lyon (Loch Tay, Killin & Kenmore)', polygon => [[257000,730000],[277000,730000],[277000,744400],[277500,745000],[277520,745200],[277500,745500],[277300,745770],[277000,746000],[277000,753000],[257000,753000],[257000,734400],[256880,734200],[257000,733900],[257000,730000]] };
$maps{"B:379W"} = { bbox => [[276000, 727000], [296000, 750000]], area => '460', series => 'B', number => '379', parent => 'B:379W', title => 'Dunkeld, Aberfeldy & Glen Almond', polygon => [[276000,727000],[296000,727000],[296000,750000],[276000,750000],[276000,727000]] };
$maps{"B:379E"} = { bbox => [[296000, 727000], [313000, 750000]], area => '391', series => 'B', number => '379', parent => 'B:379E', title => 'Dunkeld, Aberfeldy & Glen Almond', polygon => [[296000,727000],[313000,727000],[313000,750000],[296000,750000],[296000,727000]] };
$maps{"B:380W"} = { bbox => [[313000, 719000], [333000, 739000]], area => '400', series => 'B', number => '380', parent => 'B:380W', title => 'Dundee & Sidlaw Hills', polygon => [[313000,719000],[333000,719000],[333000,739000],[313000,739000],[313000,719000]] };
$maps{"B:380E"} = { bbox => [[327000, 727000], [350000, 747000]], area => '460', series => 'B', number => '380', parent => 'B:380E', title => 'Dundee & Sidlaw Hills', polygon => [[327000,727000],[350000,727000],[350000,747000],[327000,747000],[327000,727000]] };
$maps{"B:381"} = { bbox => [[313000, 739000], [343000, 761000]], area => '600', series => 'B', number => '381', parent => 'B:381', title => 'Blairgowrie, Kirriemuir & Glamis (Strathmore West)', polygon => [[313000,739000],[331000,739000],[331000,744000],[343000,744000],[343000,761000],[313000,761000],[313000,739000]] };
$maps{"B:382S"} = { bbox => [[350000, 730000], [370900, 753000]], area => '461.31', series => 'B', number => '382', parent => 'B:382S', title => 'Arbroath, Montrose & Carnoustie (Laurencekirk)', polygon => [[350000,730000],[370000,730000],[370000,746500],[370900,748000],[370500,748800],[370000,749100],[370000,753000],[350000,753000],[350000,730000]] };
$maps{"B:382N"} = { bbox => [[362000, 750000], [382700, 773000]], area => '400.795', series => 'B', number => '382', parent => 'B:382N', title => 'Arbroath, Montrose & Carnoustie (Laurencekirk)', polygon => [[362000,750000],[376000,750000],[376000,760000],[382000,760000],[382000,769100],[382600,769700],[382700,770000],[382700,770200],[382000,771000],[382000,773000],[362000,773000],[362000,750000]] };
$maps{"B:383W"} = { bbox => [[154000, 741800], [177000, 763100]], area => '461.715', series => 'B', number => '383', parent => 'B:383W', title => 'Morvern & Lochaline (Kingairloch)', polygon => [[154000,742500],[169000,742500],[169100,742300],[169300,742300],[169400,742500],[170000,742500],[171000,742000],[172000,741800],[172600,742500],[177000,742500],[177000,762500],[172000,762500],[171000,763000],[170800,763100],[170600,763000],[170100,762500],[154000,762500],[154000,742500]] };
$maps{"B:383E"} = { bbox => [[172000, 739800], [195000, 760500]], area => '400.745', series => 'B', number => '383', parent => 'B:383E', title => 'Morvern & Lochaline (Kingairloch)', polygon => [[172000,740500],[172200,740500],[173000,740000],[173300,739800],[174000,740300],[174500,740500],[185000,740500],[185000,746500],[195000,746500],[195000,760500],[172000,760500],[172000,740500]] };
$maps{"B:384"} = { bbox => [[199000, 745000], [229000, 767330]], area => '600.1985', series => 'B', number => '384', parent => 'B:384', title => 'Glen Coe & Glen Etive (Ballachulish & Kinlochleven)', polygon => [[199000,745000],[229000,745000],[229000,764000],[209000,764000],[209000,767000],[205300,767000],[205200,767250],[205100,767330],[204800,767330],[204600,767200],[204550,767000],[199000,767000],[199000,745000]] };
$maps{"B:385W"} = { bbox => [[228000, 748000], [245000, 771000]], area => '391', series => 'B', number => '385', parent => 'B:385W', title => 'Rannoch Moor & Ben Alder (Loch Rannoch)', polygon => [[228000,748000],[245000,748000],[245000,771000],[228000,771000],[228000,748000]] };
$maps{"B:385E"} = { bbox => [[243000, 750000], [263000, 773000]], area => '460', series => 'B', number => '385', parent => 'B:385E', title => 'Rannoch Moor & Ben Alder (Loch Rannoch)', polygon => [[243000,750000],[263000,750000],[263000,773000],[243000,773000],[243000,750000]] };
$maps{"B:386/OL49E"} = { bbox => [[280000, 748000], [300000, 768000]], area => '400', series => 'B', number => '386/OL49', parent => 'B:386/OL49E', title => 'Pitlochry & Loch Tummel (Aberfeldy, Kinloch Rannoch & Schiehallion)', polygon => [[280000,748000],[300000,748000],[300000,768000],[280000,768000],[280000,748000]] };
$maps{"B:386/OL49W"} = { bbox => [[260000, 748000], [280000, 771000]], area => '460', series => 'B', number => '386/OL49', parent => 'B:386/OL49W', title => 'Pitlochry & Loch Tummel (Aberfeldy, Kinloch Rannoch & Schiehallion)', polygon => [[260000,748000],[280000,748000],[280000,771000],[260000,771000],[260000,748000]] };
$maps{"B:387/OL52N"} = { bbox => [[300000, 769000], [320000, 792000]], area => '460', series => 'B', number => '387/OL52', parent => 'B:387/OL52N', title => 'Glen Shee & Braemar (The Cairnwell & Glas Maol)', polygon => [[300000,769000],[320000,769000],[320000,792000],[300000,792000],[300000,769000]] };
$maps{"B:387/OL52S"} = { bbox => [[300000, 750000], [320000, 770000]], area => '400', series => 'B', number => '387/OL52', parent => 'B:387/OL52S', title => 'Glen Shee & Braemar (The Cairnwell & Glas Maol)', polygon => [[300000,750000],[320000,750000],[320000,770000],[300000,770000],[300000,750000]] };
$maps{"B:388/OL53N"} = { bbox => [[317000, 777000], [340000, 797000]], area => '460', series => 'B', number => '388/OL53', parent => 'B:388/OL53N', title => 'Lochnagar, Glen Muick & Glen Clova (Ballater & Balmoral)', polygon => [[317000,777000],[340000,777000],[340000,797000],[317000,797000],[317000,777000]] };
$maps{"B:388/OL53S"} = { bbox => [[317000, 761000], [340000, 778000]], area => '391', series => 'B', number => '388/OL53', parent => 'B:388/OL53S', title => 'Lochnagar, Glen Muick & Glen Clova (Ballater & Balmoral)', polygon => [[317000,761000],[340000,761000],[340000,778000],[317000,778000],[317000,761000]] };
$maps{"B:389"} = { bbox => [[340000, 747000], [362000, 777000]], area => '600', series => 'B', number => '389', parent => 'B:389', title => 'Forfar, Brechin & Edzell (Strathmore East)', polygon => [[340000,747000],[352000,747000],[352000,753000],[362000,753000],[362000,777000],[340000,777000],[340000,747000]] };
$maps{"B:390W"} = { bbox => [[141000, 760000], [161000, 783000]], area => '400', series => 'B', number => '390', parent => 'B:390W', title => 'Ardnamurchan (Moidart, Sunart & Loch Shiel)', polygon => [[141000,760000],[161000,760000],[161000,777000],[151000,777000],[151000,783000],[141000,783000],[141000,760000]] };
$maps{"B:390W.a"} = { bbox => [[138500, 778000], [143500, 782000]], area => '20', series => 'B', number => '390', parent => 'B:390W', title => 'Ardnamurchan (Moidart, Sunart & Loch Shiel)', polygon => [[138500,778000],[143500,778000],[143500,782000],[138500,782000],[138500,778000]] };
$maps{"B:390E"} = { bbox => [[160000, 759700], [180000, 783000]], area => '460.195', series => 'B', number => '390', parent => 'B:390E', title => 'Ardnamurchan (Moidart, Sunart & Loch Shiel)', polygon => [[160000,760000],[160600,760000],[160800,759700],[161200,759700],[161500,760000],[180000,760000],[180000,783000],[160000,783000],[160000,760000]] };
$maps{"B:391"} = { bbox => [[180000, 759000], [210000, 781450]], area => '600.77', series => 'B', number => '391', parent => 'B:391', title => 'Ardgour & Strontian (Glenfinnan, Loch Eil & Loch Shiel)', polygon => [[180000,759000],[204000,759000],[204000,769000],[210000,769000],[210000,781000],[191600,781000],[191200,781400],[190900,781450],[190000,781450],[189300,781000],[180000,781000],[180000,759000]] };
$maps{"B:392"} = { bbox => [[205000, 761000], [235000, 783000]], area => '600', series => 'B', number => '392', parent => 'B:392', title => 'Ben Nevis & Fort William (The Mamores & The Grey Corries, Kinlochleven & Spean Bridge)', polygon => [[205000,761000],[229000,761000],[229000,771000],[235000,771000],[235000,783000],[205000,783000],[205000,761000]] };
$maps{"B:393/OL50"} = { bbox => [[234000, 767800], [264800, 790000]], area => '601.895', series => 'B', number => '393/OL50', parent => 'B:393/OL50', title => 'Ben Alder, Loch Ericht & Loch Laggan (Dalwhinnie)', polygon => [[234000,768000],[249800,768000],[249800,767900],[249900,767800],[250800,767800],[251000,768000],[264000,768000],[264000,771500],[264800,772200],[264800,773500],[264000,774400],[264000,790000],[244000,790000],[244000,784000],[234000,784000],[234000,768000]] };
$maps{"B:394/OL51W"} = { bbox => [[262600, 767000], [280000, 790000]], area => '392.3625', series => 'B', number => '394/OL51', parent => 'B:394/OL51W', title => 'Atholl (Glen Tilt, Beinn Dearg & Carn nan Gabhar)', polygon => [[263000,767000],[280000,767000],[280000,790000],[263000,790000],[263000,780500],[262650,779550],[262600,777000],[263000,775800],[263000,767000]] };
$maps{"B:394/OL51E"} = { bbox => [[280000, 767000], [300000, 790000]], area => '460', series => 'B', number => '394/OL51', parent => 'B:394/OL51E', title => 'Atholl (Glen Tilt, Beinn Dearg & Carn nan Gabhar)', polygon => [[280000,767000],[300000,767000],[300000,790000],[280000,790000],[280000,767000]] };
$maps{"B:395/OL54"} = { bbox => [[340000, 775000], [362000, 802000]], area => '594', series => 'B', number => '395/OL54', parent => 'B:395/OL54', title => 'Glen Esk & Glen Tanar (Aboyne & Mount Keen)', polygon => [[340000,775000],[362000,775000],[362000,802000],[340000,802000],[340000,775000]] };
$maps{"B:396"} = { bbox => [[362000, 770000], [392000, 792000]], area => '595.5', series => 'B', number => '396', parent => 'B:396', title => 'Stonehaven, Inverbervie & Laurencekirk (Howe of the Mearns)', polygon => [[362000,770000],[386000,770000],[386000,774500],[389000,774500],[389000,787000],[392000,787000],[392000,792000],[362000,792000],[362000,770000]] };
$maps{"B:397"} = { bbox => [[128000, 777000], [150000, 807000]], area => '576', series => 'B', number => '397', parent => 'B:397', title => 'Rùm, Eigg, Muck, Canna & Sanday', polygon => [[128000,777000],[150000,777000],[150000,793000],[144000,793000],[144000,807000],[128000,807000],[128000,777000]] };
$maps{"B:397.a"} = { bbox => [[119500, 800000], [129500, 807000]], area => '44.5', series => 'B', number => '397', parent => 'B:397', title => 'Rùm, Eigg, Muck, Canna & Sanday', polygon => [[119500,800000],[121000,800000],[121000,803000],[129500,803000],[129500,807000],[119500,807000],[119500,800000]] };
$maps{"B:397.b"} = { bbox => [[114500, 795000], [116500, 797000]], area => '4', series => 'B', number => '397', parent => 'B:397', title => 'Rùm, Eigg, Muck, Canna & Sanday', polygon => [[114500,795000],[116500,795000],[116500,797000],[114500,797000],[114500,795000]] };
$maps{"B:398W"} = { bbox => [[160000, 779000], [180000, 802000]], area => '400', series => 'B', number => '398', parent => 'B:398W', title => 'Loch Morar & Mallaig', polygon => [[160000,779000],[180000,779000],[180000,802000],[166000,802000],[166000,792000],[160000,792000],[160000,779000]] };
$maps{"B:398E"} = { bbox => [[180000, 779000], [200000, 802000]], area => '460', series => 'B', number => '398', parent => 'B:398E', title => 'Loch Morar & Mallaig', polygon => [[180000,779000],[200000,779000],[200000,802000],[180000,802000],[180000,779000]] };
$maps{"B:399"} = { bbox => [[198000, 773500], [220000, 803500]], area => '595.5', series => 'B', number => '399', parent => 'B:399', title => 'Loch Arkaig (Fort William, Corpach, Gairlochy, Achnacarry & Kingie)', polygon => [[198000,777500],[205500,777500],[207500,776500],[207500,773500],[215000,773500],[215000,779000],[220000,779000],[220000,803500],[198000,803500],[198000,777500]] };
$maps{"B:400"} = { bbox => [[217000, 781000], [239000, 811000]], area => '596.5', series => 'B', number => '400', parent => 'B:400', title => 'Loch Lochy & Glen Roy (Spean Bridge, Invergarry & Fort Augustus)', polygon => [[217000,781000],[239000,781000],[239000,811000],[228000,811000],[228000,808500],[225000,808500],[225000,804000],[217000,804000],[217000,781000]] };
$maps{"B:401/OL55"} = { bbox => [[237000, 780000], [259000, 810000]], area => '600', series => 'B', number => '401/OL55', parent => 'B:401/OL55', title => 'Loch Laggan & Creag Meagaidh (Corrieyairack Pass)', polygon => [[237000,780000],[249000,780000],[249000,786000],[259000,786000],[259000,810000],[237000,810000],[237000,780000]] };
$maps{"B:402/OL56"} = { bbox => [[258000, 788000], [285000, 810000]], area => '594', series => 'B', number => '402/OL56', parent => 'B:402/OL56', title => 'Badenoch & Upper Strathspey (Kingussie & Newtonmore)', polygon => [[258000,788000],[285000,788000],[285000,810000],[258000,810000],[258000,788000]] };
$maps{"B:403/OL57N"} = { bbox => [[284000, 806000], [307000, 823000]], area => '391', series => 'B', number => '403/OL57', parent => 'B:403/OL57N', title => 'Cairn Gorm & Aviemore (Loch Morlich)', polygon => [[284000,806000],[307000,806000],[307000,823000],[284000,823000],[284000,806000]] };
$maps{"B:403/OL57S"} = { bbox => [[284000, 786700], [307000, 807000]], area => '460.3375', series => 'B', number => '403/OL57', parent => 'B:403/OL57S', title => 'Cairn Gorm & Aviemore (Loch Morlich)', polygon => [[284000,787000],[299300,787000],[300000,786700],[300700,786700],[300850,787000],[307000,787000],[307000,807000],[284000,807000],[284000,787000]] };
$maps{"B:404/OL58S"} = { bbox => [[303000, 788000], [326000, 808000]], area => '460', series => 'B', number => '404/OL58', parent => 'B:404/OL58S', title => 'Braemar, Tomintoul & Glen Avon (Beinn a’ Bhuird & Ben Avon)', polygon => [[303000,788000],[326000,788000],[326000,808000],[303000,808000],[303000,788000]] };
$maps{"B:404/OL58N"} = { bbox => [[303000, 805000], [326000, 822000]], area => '391', series => 'B', number => '404/OL58', parent => 'B:404/OL58N', title => 'Braemar, Tomintoul & Glen Avon (Beinn a’ Bhuird & Ben Avon)', polygon => [[303000,805000],[326000,805000],[326000,822000],[303000,822000],[303000,805000]] };
$maps{"B:405/OL59E"} = { bbox => [[346000, 796000], [366000, 819000]], area => '460', series => 'B', number => '405/OL59', parent => 'B:405/OL59E', title => 'Aboyne, Alford & Strathdon', polygon => [[346000,796000],[366000,796000],[366000,819000],[346000,819000],[346000,796000]] };
$maps{"B:405/OL59W"} = { bbox => [[326000, 795200], [346000, 816000]], area => '401.065', series => 'B', number => '405/OL59', parent => 'B:405/OL59W', title => 'Aboyne, Alford & Strathdon', polygon => [[326000,796000],[335800,796000],[336000,795600],[336500,795200],[337000,795200],[337200,795300],[337700,796000],[346000,796000],[346000,816000],[326000,816000],[326000,796000]] };
$maps{"B:406E"} = { bbox => [[378000, 791000], [398000, 814000]], area => '460', series => 'B', number => '406', parent => 'B:406E', title => 'Aberdeen & Banchory', polygon => [[378000,791000],[398000,791000],[398000,814000],[378000,814000],[378000,791000]] };
$maps{"B:406W"} = { bbox => [[361000, 791000], [378000, 814000]], area => '391', series => 'B', number => '406', parent => 'B:406W', title => 'Aberdeen & Banchory', polygon => [[361000,791000],[378000,791000],[378000,814000],[361000,814000],[361000,791000]] };
$maps{"B:407"} = { bbox => [[112000, 836000], [134000, 867300]], area => '593.425', series => 'B', number => '407', parent => 'B:407', title => 'Skye – Dunvegan (Waternish & Macleod’s Tables)', polygon => [[112000,836500],[124000,836500],[124000,836000],[125300,836000],[125600,836500],[134000,836500],[134000,866500],[124700,866500],[124500,866900],[124000,866900],[123900,867300],[122900,866500],[120000,866500],[120000,858000],[112000,858000],[112000,836500]] };
$maps{"B:408"} = { bbox => [[131000, 850000], [153000, 880000]], area => '596', series => 'B', number => '408', parent => 'B:408', title => 'Skye – Trotternish & The Storr (Uig)', polygon => [[131000,850000],[153000,850000],[153000,870000],[149000,870000],[149000,873000],[147000,873000],[147000,875000],[145000,875000],[145000,880000],[131000,880000],[131000,850000]] };
$maps{"B:408.a"} = { bbox => [[135000, 879000], [140000, 882000]], area => '15', series => 'B', number => '408', parent => 'B:408', title => 'Skye – Trotternish & The Storr (Uig)', polygon => [[135000,879000],[140000,879000],[140000,882000],[135000,882000],[135000,879000]] };
$maps{"B:409"} = { bbox => [[147000, 832000], [169000, 862300]], area => '600.255', series => 'B', number => '409', parent => 'B:409', title => 'Raasay, Rona & Scalpay', polygon => [[147000,832000],[169000,832000],[169000,850000],[164000,850000],[164000,862000],[163500,862000],[163300,862300],[162700,862300],[162400,862000],[147000,862000],[147000,832000]] };
$maps{"B:409.a"} = { bbox => [[157500, 827000], [166500, 833700]], area => '58.8', series => 'B', number => '409', parent => 'B:409', title => 'Raasay, Rona & Scalpay', polygon => [[159000,827000],[166500,827000],[166500,833700],[157500,833700],[157500,829000],[159000,827000]] };
$maps{"B:409.b"} = { bbox => [[161000, 860000], [164000, 863500]], area => '10.5', series => 'B', number => '409', parent => 'B:409', title => 'Raasay, Rona & Scalpay', polygon => [[161000,860000],[164000,860000],[164000,863500],[161000,863500],[161000,860000]] };
$maps{"B:410"} = { bbox => [[127000, 830000], [157000, 850000]], area => '600', series => 'B', number => '410', parent => 'B:410', title => 'Skye – Portree & Bracadale', polygon => [[127000,830000],[157000,830000],[157000,850000],[127000,850000],[127000,830000]] };
$maps{"B:411"} = { bbox => [[130900, 810900], [162300, 833400]], area => '591.895', series => 'B', number => '411', parent => 'B:411', title => 'Skye – Cuillin Hills (Soay)', polygon => [[131500,822000],[135000,822000],[135000,817000],[138000,817000],[138000,815000],[142000,815000],[142000,811000],[152100,811000],[152300,810900],[152400,810900],[152500,811000],[161500,811000],[161500,820000],[162300,821200],[162300,823800],[161500,825000],[161500,833000],[160800,833000],[160700,833200],[160000,833300],[159300,833400],[158800,833000],[131500,833000],[131500,831000],[130900,830000],[131300,829000],[131500,828000],[131500,822000]] };
$maps{"B:412"} = { bbox => [[155000, 799000], [177000, 829300]], area => '560.3', series => 'B', number => '412', parent => 'B:412', title => 'Skye – Sleat / Slèite (Broadford, Kyleakin & Armadale)', polygon => [[155000,799000],[167000,799000],[167000,805000],[173000,805000],[173000,815000],[177000,815000],[177000,829000],[158200,829000],[158000,829300],[157200,829300],[157000,829000],[155000,829000],[155000,799000]] };
$maps{"B:412.a"} = { bbox => [[177000, 817000], [180500, 826000]], area => '27.475', series => 'B', number => '412', parent => 'B:412', title => 'Skye – Sleat / Slèite (Broadford, Kyleakin & Armadale)', polygon => [[177000,817000],[180000,817000],[180000,823500],[180500,824000],[180500,824400],[180000,825000],[180000,826000],[177000,826000],[177000,817000]] };
$maps{"B:413N"} = { bbox => [[174000, 814000], [197000, 831000]], area => '391', series => 'B', number => '413', parent => 'B:413N', title => 'Knoydart, Loch Hourn & Loch Duich (Kyle of Lochalsh)', polygon => [[174000,814000],[197000,814000],[197000,831000],[174000,831000],[174000,814000]] };
$maps{"B:413S"} = { bbox => [[169700, 797000], [193000, 817000]], area => '460.615', series => 'B', number => '413', parent => 'B:413S', title => 'Knoydart, Loch Hourn & Loch Duich (Kyle of Lochalsh)', polygon => [[170000,797000],[193000,797000],[193000,817000],[170000,817000],[170000,804500],[169700,803600],[169700,802500],[170000,801500],[170000,797000]] };
$maps{"B:414S"} = { bbox => [[193000, 800000], [216000, 817000]], area => '391', series => 'B', number => '414', parent => 'B:414S', title => 'Glen Shiel & Kintail Forest (Shiel Bridge, Morvich, Killilan & Kinloch Hourn)', polygon => [[193000,800000],[216000,800000],[216000,817000],[193000,817000],[193000,800000]] };
$maps{"B:414N"} = { bbox => [[193000, 813000], [216000, 833000]], area => '460', series => 'B', number => '414', parent => 'B:414N', title => 'Glen Shiel & Kintail Forest (Shiel Bridge, Morvich, Killilan & Kinloch Hourn)', polygon => [[193000,813000],[216000,813000],[216000,833000],[193000,833000],[193000,813000]] };
$maps{"B:415"} = { bbox => [[215000, 803500], [237000, 833950]], area => '601.37', series => 'B', number => '415', parent => 'B:415', title => 'Glen Affric & Glen Moriston (Cannich)', polygon => [[215000,803500],[225000,803500],[225000,808500],[237000,808500],[237000,833500],[231200,833500],[230800,833900],[230500,833950],[229000,833950],[228100,833500],[227600,833500],[227000,833800],[226600,833800],[226100,833500],[215000,833500],[215000,803500]] };
$maps{"B:416N"} = { bbox => [[254000, 830000], [277000, 850000]], area => '394', series => 'B', number => '416', parent => 'B:416N', title => 'Inverness, Loch Ness & Culloden (Fort Augustus & Drumnadrochit)', polygon => [[254000,830000],[274000,830000],[274000,842000],[277000,842000],[277000,850000],[264000,850000],[264000,847000],[254000,847000],[254000,830000]] };
$maps{"B:416S"} = { bbox => [[237000, 808000], [257000, 831000]], area => '460', series => 'B', number => '416', parent => 'B:416S', title => 'Inverness, Loch Ness & Culloden (Fort Augustus & Drumnadrochit)', polygon => [[237000,808000],[257000,808000],[257000,831000],[237000,831000],[237000,808000]] };
$maps{"B:417"} = { bbox => [[257000, 810000], [284000, 832000]], area => '594', series => 'B', number => '417', parent => 'B:417', title => 'Monadhliath Mountains North & Strathdearn', polygon => [[257000,810000],[284000,810000],[284000,832000],[257000,832000],[257000,810000]] };
$maps{"B:418/OL60"} = { bbox => [[274000, 822000], [304000, 842000]], area => '600', series => 'B', number => '418/OL60', parent => 'B:418/OL60', title => 'Lochindorb, Grantown-on-Spey & Carrbridge', polygon => [[274000,822000],[304000,822000],[304000,842000],[274000,842000],[274000,822000]] };
$maps{"B:419/OL61S"} = { bbox => [[299000, 819000], [322000, 839000]], area => '460', series => 'B', number => '419/OL61', parent => 'B:419/OL61S', title => 'Grantown-on-Spey & Hills of Cromdale (Upper Knockdale & Tomnavoulin)', polygon => [[299000,819000],[322000,819000],[322000,839000],[299000,839000],[299000,819000]] };
$maps{"B:419/OL61N"} = { bbox => [[300000, 835000], [323000, 852000]], area => '391', series => 'B', number => '419/OL61', parent => 'B:419/OL61N', title => 'Grantown-on-Spey & Hills of Cromdale (Upper Knockdale & Tomnavoulin)', polygon => [[300000,835000],[323000,835000],[323000,852000],[300000,852000],[300000,835000]] };
$maps{"B:420/OL62E"} = { bbox => [[345000, 816000], [368550, 833000]], area => '391.6725', series => 'B', number => '420/OL62', parent => 'B:420/OL62E', title => 'Correen Hills & Glenlivet (Bennachie, Ladder Hills, Insch & Rhynie)', polygon => [[345000,816000],[368000,816000],[368000,821600],[368400,822000],[368550,822200],[368550,822700],[368400,823000],[368000,823400],[368000,833000],[345000,833000],[345000,816000]] };
$maps{"B:420/OL62W"} = { bbox => [[321500, 813000], [345000, 833000]], area => '460.325', series => 'B', number => '420/OL62', parent => 'B:420/OL62W', title => 'Correen Hills & Glenlivet (Bennachie, Ladder Hills, Insch & Rhynie)', polygon => [[322000,813000],[345000,813000],[345000,833000],[322000,833000],[322000,826200],[321500,825500],[322000,824900],[322000,813000]] };
$maps{"B:421E"} = { bbox => [[386000, 811000], [406250, 834000]], area => '400.1125', series => 'B', number => '421', parent => 'B:421E', title => 'Ellon & Inverurie (Oldmeldrum & Pitmedden)', polygon => [[386000,811000],[400000,811000],[400000,821000],[406000,821000],[406000,830700],[406250,830800],[406250,831100],[406000,831300],[406000,834000],[386000,834000],[386000,811000]] };
$maps{"B:421W"} = { bbox => [[366000, 811000], [386000, 834000]], area => '460', series => 'B', number => '421', parent => 'B:421W', title => 'Ellon & Inverurie (Oldmeldrum & Pitmedden)', polygon => [[366000,811000],[386000,811000],[386000,834000],[366000,834000],[366000,811000]] };
$maps{"B:422"} = { bbox => [[273000, 840000], [300000, 862550]], area => '594.61', series => 'B', number => '422', parent => 'B:422', title => 'Nairn & Cawdor (Darnaway Forest, Ardersier & Culloden Muir)', polygon => [[273000,840000],[300000,840000],[300000,862000],[296600,862000],[296000,862400],[295600,862550],[295000,862300],[294700,862000],[273000,862000],[273000,840000]] };
$maps{"B:423"} = { bbox => [[296000, 851000], [326000, 873000]], area => '600', series => 'B', number => '423', parent => 'B:423', title => 'Elgin, Forres & Lossiemouth (Burghead & Findhorn)', polygon => [[296000,851000],[326000,851000],[326000,873000],[306000,873000],[306000,867000],[296000,867000],[296000,851000]] };
$maps{"B:424N"} = { bbox => [[325000, 850000], [345000, 870000]], area => '400', series => 'B', number => '424', parent => 'B:424N', title => 'Buckie & Keith (Dufftown & Charlestown of Aberlour)', polygon => [[325000,850000],[345000,850000],[345000,870000],[325000,870000],[325000,850000]] };
$maps{"B:424S"} = { bbox => [[322000, 833000], [345000, 853000]], area => '460', series => 'B', number => '424', parent => 'B:424S', title => 'Buckie & Keith (Dufftown & Charlestown of Aberlour)', polygon => [[322000,833000],[345000,833000],[345000,853000],[322000,853000],[322000,833000]] };
$maps{"B:425S"} = { bbox => [[345000, 833000], [368000, 850000]], area => '391', series => 'B', number => '425', parent => 'B:425S', title => 'Huntly & Cullen (Portsoy & Aberchirder)', polygon => [[345000,833000],[368000,833000],[368000,850000],[345000,850000],[345000,833000]] };
$maps{"B:425N"} = { bbox => [[345000, 850000], [368000, 870000]], area => '460', series => 'B', number => '425', parent => 'B:425N', title => 'Huntly & Cullen (Portsoy & Aberchirder)', polygon => [[345000,850000],[368000,850000],[368000,870000],[345000,870000],[345000,850000]] };
$maps{"B:426N"} = { bbox => [[367600, 848000], [391000, 868000]], area => '460.56', series => 'B', number => '426', parent => 'B:426N', title => 'Banff, Macduff & Turriff (Fyvie)', polygon => [[368000,848000],[391000,848000],[391000,868000],[368000,868000],[368000,865000],[367600,864400],[367600,863600],[368000,863000],[368000,848000]] };
$maps{"B:426S"} = { bbox => [[368000, 831000], [391000, 848000]], area => '391', series => 'B', number => '426', parent => 'B:426S', title => 'Banff, Macduff & Turriff (Fyvie)', polygon => [[368000,831000],[391000,831000],[391000,848000],[368000,848000],[368000,831000]] };
$maps{"B:427S"} = { bbox => [[391000, 831000], [414500, 848000]], area => '391.595', series => 'B', number => '427', parent => 'B:427S', title => 'Peterhead & Fraserburgh', polygon => [[391000,831000],[414000,831000],[414000,843000],[414100,843200],[414000,843400],[414000,845200],[414500,845700],[414500,846300],[414000,846900],[414000,848000],[391000,848000],[391000,831000]] };
$maps{"B:427N"} = { bbox => [[391000, 848000], [414000, 868000]], area => '460', series => 'B', number => '427', parent => 'B:427N', title => 'Peterhead & Fraserburgh', polygon => [[391000,848000],[414000,848000],[414000,868000],[391000,868000],[391000,848000]] };
$maps{"B:428S"} = { bbox => [[168000, 827000], [191000, 847000]], area => '460', series => 'B', number => '428', parent => 'B:428S', title => 'Kyle of Lochalsh, Plockton & Applecross', polygon => [[168000,827000],[191000,827000],[191000,847000],[168000,847000],[168000,827000]] };
$maps{"B:428N"} = { bbox => [[167700, 845000], [191000, 865200]], area => '400.265', series => 'B', number => '428', parent => 'B:428N', title => 'Kyle of Lochalsh, Plockton & Applecross', polygon => [[168000,845000],[191000,845000],[191000,859000],[181000,859000],[181000,865000],[173300,865000],[173100,865200],[172900,865000],[168000,865000],[168000,850000],[167700,849200],[168000,848500],[168000,845000]] };
$maps{"B:429"} = { bbox => [[190000, 830000], [213000, 857000]], area => '595.5', series => 'B', number => '429', parent => 'B:429', title => 'Glen Carron & West Monar (Strathcarron & Attadale Forest)', polygon => [[190000,830000],[212000,830000],[212000,839000],[213000,839500],[213000,840500],[212000,841000],[212000,857000],[190000,857000],[190000,830000]] };
$maps{"B:430"} = { bbox => [[210000, 830000], [232000, 857000]], area => '594', series => 'B', number => '430', parent => 'B:430', title => 'Loch Monar, Glen Cannich & Glen Strathfarrar', polygon => [[210000,830000],[232000,830000],[232000,857000],[210000,857000],[210000,830000]] };
$maps{"B:431"} = { bbox => [[232000, 828450], [254000, 856000]], area => '594.9', series => 'B', number => '431', parent => 'B:431', title => 'Glen Urquhart & Strathglass (Drumnadrochit & Muir of Ord)', polygon => [[232000,829000],[251000,829000],[252000,828700],[253000,828500],[253300,828450],[254000,829000],[254000,856000],[232000,856000],[232000,829000]] };
$maps{"B:432"} = { bbox => [[252000, 846000], [282000, 868000]], area => '600', series => 'B', number => '432', parent => 'B:432', title => 'Black Isle (Fortrose, Cromarty & Dingwall)', polygon => [[252000,846000],[272000,846000],[272000,852000],[282000,852000],[282000,868000],[252000,868000],[252000,846000]] };
$maps{"B:433"} = { bbox => [[172000, 853950], [203300, 877100]], area => '605.3875', series => 'B', number => '433', parent => 'B:433', title => 'Torridon – Beinn Eighe & Liathach (Loch Maree, Kinlochewe & Gairloch)', polygon => [[172500,865000],[175500,865000],[175500,860000],[178000,860000],[178000,856500],[185000,856500],[185000,854500],[187500,854500],[188000,854000],[188750,853950],[189000,853960],[189500,854100],[190000,854500],[202500,854500],[202500,860000],[203100,861000],[203300,862000],[203200,863000],[203000,863550],[202500,864000],[202500,876500],[181000,876500],[180750,877100],[179900,877100],[179500,876500],[172500,876500],[172500,869000],[172000,868500],[172000,867500],[172500,867000],[172500,865000]] };
$maps{"B:434"} = { bbox => [[172000, 870000], [194000, 900000]], area => '600', series => 'B', number => '434', parent => 'B:434', title => 'Gairloch & Loch Ewe', polygon => [[172000,870000],[194000,870000],[194000,900000],[182000,900000],[182000,894000],[172000,894000],[172000,870000]] };
$maps{"B:435N"} = { bbox => [[193000, 876000], [213000, 899650]], area => '461.0975', series => 'B', number => '435', parent => 'B:435N', title => 'An Teallach & Slioch (Kinlochewe & Achnasheen / Achaidh na Sine)', polygon => [[193000,876000],[213000,876000],[213000,899000],[202100,899000],[201800,899650],[200800,899650],[200000,899200],[199900,899000],[193000,899000],[193000,876000]] };
$maps{"B:435S"} = { bbox => [[200000, 857000], [217000, 880000]], area => '391', series => 'B', number => '435', parent => 'B:435S', title => 'An Teallach & Slioch (Kinlochewe & Achnasheen / Achaidh na Sine)', polygon => [[200000,857000],[217000,857000],[217000,880000],[200000,880000],[200000,857000]] };
$maps{"B:436N"} = { bbox => [[212000, 876000], [232000, 896000]], area => '400', series => 'B', number => '436', parent => 'B:436N', title => 'Beinn Dearg & Loch Fannich (Ullapool)', polygon => [[212000,876000],[232000,876000],[232000,896000],[212000,896000],[212000,876000]] };
$maps{"B:436S"} = { bbox => [[215000, 857000], [235000, 880000]], area => '460', series => 'B', number => '436', parent => 'B:436S', title => 'Beinn Dearg & Loch Fannich (Ullapool)', polygon => [[215000,857000],[235000,857000],[235000,880000],[215000,880000],[215000,857000]] };
$maps{"B:437S"} = { bbox => [[232000, 855650], [255550, 876000]], area => '461.785', series => 'B', number => '437', parent => 'B:437S', title => 'Ben Wyvis & Strathpeffer (Dingwall)', polygon => [[232000,856000],[245200,856000],[245500,855650],[247000,855650],[247400,856000],[255000,856000],[255000,857500],[255300,858200],[255500,859100],[255550,859400],[255500,860000],[255000,860800],[255000,876000],[232000,876000],[232000,856000]] };
$maps{"B:437N"} = { bbox => [[232000, 876000], [255000, 893000]], area => '391', series => 'B', number => '437', parent => 'B:437N', title => 'Ben Wyvis & Strathpeffer (Dingwall)', polygon => [[232000,876000],[255000,876000],[255000,893000],[232000,893000],[232000,876000]] };
$maps{"B:438W"} = { bbox => [[255000, 867550], [275350, 891700]], area => '461.39535', series => 'B', number => '438', parent => 'B:438W', title => 'Dornoch & Tain (Alness & Invergordon)', polygon => [[255000,868000],[262200,868000],[262500,867700],[262900,867550],[263100,867550],[263800,868000],[275000,868000],[275000,884000],[275150,884200],[275150,884400],[275000,884600],[275000,889000],[275350,889250],[275350,889750],[275000,890000],[275000,891000],[261500,891000],[261200,891700],[260899,891700],[260000,891000],[255000,891000],[255000,868000]] };
$maps{"B:438E"} = { bbox => [[274500, 868000], [295500, 891000]], area => '397.3', series => 'B', number => '438', parent => 'B:438E', title => 'Dornoch & Tain (Alness & Invergordon)', polygon => [[274500,868000],[286000,868000],[286000,874000],[288900,876000],[294500,876000],[294500,885000],[295000,886000],[295300,887000],[295500,888000],[295000,888700],[294500,889000],[294500,891000],[274500,891000],[274500,868000]] };
$maps{"B:439E"} = { bbox => [[209000, 893300], [230000, 917350]], area => '462.62', series => 'B', number => '439', parent => 'B:439E', title => 'Coigach & Summer Isles (Inverpolly)', polygon => [[210000,894000],[211200,894000],[213000,893300],[213800,893600],[214500,894000],[230000,894000],[230000,917000],[227300,917000],[227000,917260],[226800,917350],[226400,917350],[226000,917000],[210000,917000],[210000,898400],[209000,897600],[209000,897300],[210000,896500],[210000,894000]] };
$maps{"B:439W"} = { bbox => [[190000, 898500], [210500, 923000]], area => '402.78', series => 'B', number => '439', parent => 'B:439W', title => 'Coigach & Summer Isles (Inverpolly)', polygon => [[190000,899000],[208500,899000],[209000,898500],[210000,898500],[210200,898800],[210000,899000],[210000,899200],[210500,899900],[210000,900400],[210000,922000],[209900,922600],[209800,922800],[209500,923000],[209000,922700],[207700,922000],[206300,922000],[206000,922300],[204700,922300],[203900,922000],[195000,922000],[195000,910000],[190000,910000],[190000,899000]] };
$maps{"B:440S"} = { bbox => [[230000, 890600], [250000, 914000]], area => '460.35', series => 'B', number => '440', parent => 'B:440S', title => 'Glen Cassley & Glen Oykel', polygon => [[230000,891000],[246150,891000],[246900,890600],[247900,891000],[250000,891000],[250000,914000],[230000,914000],[230000,891000]] };
$maps{"B:440N"} = { bbox => [[233000, 912000], [250000, 935000]], area => '391', series => 'B', number => '440', parent => 'B:440N', title => 'Glen Cassley & Glen Oykel', polygon => [[233000,912000],[250000,912000],[250000,935000],[233000,935000],[233000,912000]] };
$maps{"B:441E"} = { bbox => [[272000, 889200], [295000, 910000]], area => '401.985', series => 'B', number => '441', parent => 'B:441E', title => 'Lairg, Bonar Bridge & Golspie (Dornoch & Brora)', polygon => [[272000,890000],[278250,890000],[279500,889200],[280500,889200],[281000,889350],[281500,889600],[281800,890000],[285000,890000],[285000,896000],[295000,896000],[295000,910000],[272000,910000],[272000,890000]] };
$maps{"B:441W"} = { bbox => [[249000, 890000], [272000, 910000]], area => '460', series => 'B', number => '441', parent => 'B:441W', title => 'Lairg, Bonar Bridge & Golspie (Dornoch & Brora)', polygon => [[249000,890000],[272000,890000],[272000,910000],[249000,910000],[249000,890000]] };
$maps{"B:442E"} = { bbox => [[220000, 913000], [237000, 936000]], area => '391', series => 'B', number => '442', parent => 'B:442E', title => 'Assynt & Lochinver (Kylesku & Inchnadamph)', polygon => [[220000,913000],[237000,913000],[237000,936000],[220000,936000],[220000,913000]] };
$maps{"B:442W"} = { bbox => [[200000, 913000], [220000, 936000]], area => '460', series => 'B', number => '442', parent => 'B:442W', title => 'Assynt & Lochinver (Kylesku & Inchnadamph)', polygon => [[200000,913000],[220000,913000],[220000,936000],[200000,936000],[200000,913000]] };
$maps{"B:443"} = { bbox => [[250000, 908000], [272000, 935000]], area => '594', series => 'B', number => '443', parent => 'B:443', title => 'Ben Kilbreck & Ben Armine', polygon => [[250000,908000],[272000,908000],[272000,935000],[250000,935000],[250000,908000]] };
$maps{"B:444E"} = { bbox => [[294000, 909400], [317500, 930000]], area => '401.4', series => 'B', number => '444', parent => 'B:444E', title => 'Helmsdale & Strath of Kildonan', polygon => [[294000,910000],[294400,910000],[295000,909600],[296100,909400],[297500,910000],[307000,910000],[307000,916000],[317000,916000],[317000,929100],[317300,929300],[317500,930000],[294000,930000],[294000,910000]] };
$maps{"B:444W"} = { bbox => [[271000, 910000], [294000, 930000]], area => '460', series => 'B', number => '444', parent => 'B:444W', title => 'Helmsdale & Strath of Kildonan', polygon => [[271000,910000],[294000,910000],[294000,930000],[271000,930000],[271000,910000]] };
$maps{"B:445"} = { bbox => [[211800, 930500], [239000, 952500]], area => '594.13', series => 'B', number => '445', parent => 'B:445', title => 'Foinaven, Arkle, Kylesku & Scourie', polygon => [[212000,930500],[239000,930500],[239000,952500],[212000,952500],[212000,938200],[211800,938000],[211800,937500],[212000,937400],[212000,930500]] };
$maps{"B:446"} = { bbox => [[216000, 952050], [246000, 975200]], area => '597.97625', series => 'B', number => '446', parent => 'B:446', title => 'Durness & Cape Wrath (Kinlochbervie & Rhiconich)', polygon => [[216000,952500],[217800,952500],[218200,952300],[219000,952300],[219600,952500],[224700,952500],[224900,952100],[225400,952050],[225550,952100],[226200,952500],[246000,952500],[246000,971000],[241000,971000],[241000,974400],[226800,974500],[226000,975200],[225200,975200],[224800,974500],[223000,974500],[223000,968000],[216000,968000],[216000,952500]] };
$maps{"B:447N"} = { bbox => [[242000, 950000], [262000, 970000]], area => '400', series => 'B', number => '447', parent => 'B:447N', title => 'Ben Hope, Ben Loyal & Kyle of Tongue', polygon => [[242000,950000],[262000,950000],[262000,970000],[242000,970000],[242000,950000]] };
$maps{"B:447S"} = { bbox => [[239000, 932500], [262000, 952500]], area => '460', series => 'B', number => '447', parent => 'B:447S', title => 'Ben Hope, Ben Loyal & Kyle of Tongue', polygon => [[239000,932500],[262000,932500],[262000,952500],[239000,952500],[239000,932500]] };
$maps{"B:448N"} = { bbox => [[258000, 950000], [281000, 970000]], area => '397', series => 'B', number => '448', parent => 'B:448N', title => 'Strath Naver / Srath Nabhair & Loch Loyal (Bettyhill)', polygon => [[258000,950000],[281000,950000],[281000,970000],[279000,970000],[279000,967000],[258000,967000],[258000,950000]] };
$maps{"B:448S"} = { bbox => [[258000, 930000], [281000, 950000]], area => '460', series => 'B', number => '448', parent => 'B:448S', title => 'Strath Naver / Srath Nabhair & Loch Loyal (Bettyhill)', polygon => [[258000,930000],[281000,930000],[281000,950000],[258000,950000],[258000,930000]] };
$maps{"B:449N"} = { bbox => [[280000, 950000], [300000, 970000]], area => '400', series => 'B', number => '449', parent => 'B:449N', title => 'Strath Halladale & Strathy Point (Melvich & Forsinard)', polygon => [[280000,950000],[300000,950000],[300000,970000],[280000,970000],[280000,950000]] };
$maps{"B:449S"} = { bbox => [[280000, 930000], [303000, 950000]], area => '460', series => 'B', number => '449', parent => 'B:449S', title => 'Strath Halladale & Strathy Point (Melvich & Forsinard)', polygon => [[280000,930000],[303000,930000],[303000,950000],[280000,950000],[280000,930000]] };
$maps{"B:450E"} = { bbox => [[319000, 932550], [339150, 956000]], area => '397.855', series => 'B', number => '450', parent => 'B:450E', title => 'Wick & The Flow Country (Lybster, Latheron & Dunbeath)', polygon => [[319000,933000],[319200,932750],[319500,932750],[319900,932550],[320400,932550],[321600,933000],[330000,933000],[330000,936000],[333000,936000],[333000,940000],[336000,940000],[336000,944000],[339000,944000],[339000,954000],[339150,954200],[339150,954800],[339000,955000],[339000,956000],[319000,956000],[319000,933000]] };
$maps{"B:450W"} = { bbox => [[300000, 929100], [320000, 953000]], area => '462.265', series => 'B', number => '450', parent => 'B:450W', title => 'Wick & The Flow Country (Lybster, Latheron & Dunbeath)', polygon => [[300000,930000],[314300,930000],[314500,929800],[315000,929600],[315200,929300],[315600,929100],[317100,929100],[317800,930000],[320000,930000],[320000,953000],[300000,953000],[300000,930000]] };
$maps{"B:451W"} = { bbox => [[300000, 952000], [320000, 972000]], area => '400', series => 'B', number => '451', parent => 'B:451W', title => 'Thurso & John O’Groats (Dunnet Head)', polygon => [[300000,952000],[320000,952000],[320000,972000],[300000,972000],[300000,952000]] };
$maps{"B:451E"} = { bbox => [[318000, 956000], [341000, 977000]], area => '462.425', series => 'B', number => '451', parent => 'B:451E', title => 'Thurso & John O’Groats (Dunnet Head)', polygon => [[318000,956000],[341000,956000],[341000,976000],[322000,976000],[321000,977000],[320000,977000],[319000,976500],[318300,976000],[318000,976000],[318000,956000]] };
$maps{"B:451E.a"} = { bbox => [[333500, 975500], [336500, 979000]], area => '10.5', series => 'B', number => '451', parent => 'B:451E', title => 'Thurso & John O’Groats (Dunnet Head)', polygon => [[333500,975500],[336500,975500],[336500,979000],[333500,979000],[333500,975500]] };
$maps{"B:452N"} = { bbox => [[60300, 793000], [81300, 816000]], area => '460.8125', series => 'B', number => '452', parent => 'B:452N', title => 'Barra & Vatersay / Barraigh agus Bhatarsaigh (Eriskay & Mingulay / Eirisgeigh agus Miughalaigh)', polygon => [[61000,793000],[81000,793000],[81000,811800],[81300,812800],[81000,813050],[81000,816000],[61000,816000],[61000,797800],[60500,796600],[60300,796400],[60500,796100],[61000,796000],[61000,793000]] };
$maps{"B:452N.a"} = { bbox => [[82500, 810500], [84000, 812000]], area => '2.25', series => 'B', number => '452', parent => 'B:452N', title => 'Barra & Vatersay / Barraigh agus Bhatarsaigh (Eriskay & Mingulay / Eirisgeigh agus Miughalaigh)', polygon => [[82500,810500],[84000,810500],[84000,812000],[82500,812000],[82500,810500]] };
$maps{"B:452S"} = { bbox => [[53000, 779000], [73000, 799000]], area => '400', series => 'B', number => '452', parent => 'B:452S', title => 'Barra & Vatersay / Barraigh agus Bhatarsaigh (Eriskay & Mingulay / Eirisgeigh agus Miughalaigh)', polygon => [[53000,779000],[73000,779000],[73000,799000],[53000,799000],[53000,779000]] };
$maps{"B:453S"} = { bbox => [[70000, 812500], [90000, 836000]], area => '400.65', series => 'B', number => '453', parent => 'B:453S', title => 'Benbecula & South Uist / Beinn na Faoghla agus Uibhist a Deas (Eriskay / Eirisgeigh)', polygon => [[70000,813000],[82300,813000],[82700,812500],[83700,812500],[83900,813000],[85000,813000],[85000,825000],[90000,825000],[90000,836000],[70000,836000],[70000,813000]] };
$maps{"B:453S.a"} = { bbox => [[77500, 807000], [81500, 813000]], area => '24', series => 'B', number => '453', parent => 'B:453S', title => 'Benbecula & South Uist / Beinn na Faoghla agus Uibhist a Deas (Eriskay / Eirisgeigh)', polygon => [[77500,807000],[81500,807000],[81500,813000],[77500,813000],[77500,807000]] };
$maps{"B:453N"} = { bbox => [[73000, 835500], [93000, 858500]], area => '460', series => 'B', number => '453', parent => 'B:453N', title => 'Benbecula & South Uist / Beinn na Faoghla agus Uibhist a Deas (Eriskay / Eirisgeigh)', polygon => [[73000,835500],[93000,835500],[93000,858500],[73000,858500],[73000,835500]] };
$maps{"B:454W"} = { bbox => [[62500, 857400], [82500, 878400]], area => '401.545', series => 'B', number => '454', parent => 'B:454W', title => 'North Uist & Berneray / Uibhist a Tuath agus Beàrnaraigh', polygon => [[62500,858000],[77300,858000],[78000,857400],[78700,857500],[79300,857500],[79820,858000],[82500,858000],[82500,878400],[81400,878400],[81000,878000],[62500,878000],[62500,858000]] };
$maps{"B:454W.a"} = { bbox => [[57000, 860000], [65300, 865000]], area => '35.7125', series => 'B', number => '454', parent => 'B:454W', title => 'North Uist & Berneray / Uibhist a Tuath agus Beàrnaraigh', polygon => [[57000,860000],[65300,860000],[65300,863250],[64000,864000],[60000,864000],[60000,865000],[57000,865000],[57000,860000]] };
$maps{"B:454W.b"} = { bbox => [[59000, 880000], [62000, 883000]], area => '9', series => 'B', number => '454', parent => 'B:454W', title => 'North Uist & Berneray / Uibhist a Tuath agus Beàrnaraigh', polygon => [[59000,880000],[62000,880000],[62000,883000],[59000,883000],[59000,880000]] };
$maps{"B:454E"} = { bbox => [[82000, 858200], [102900, 881500]], area => '463.27', series => 'B', number => '454', parent => 'B:454E', title => 'North Uist & Berneray / Uibhist a Tuath agus Beàrnaraigh', polygon => [[82000,858500],[85000,858500],[87000,858350],[89000,858200],[91800,858200],[92000,858500],[102000,858500],[102000,878000],[102500,879000],[102900,880700],[102000,881500],[82000,881500],[82000,858500]] };
$maps{"B:454E.a"} = { bbox => [[88000, 879000], [95000, 884000]], area => '32', series => 'B', number => '454', parent => 'B:454E', title => 'North Uist & Berneray / Uibhist a Tuath agus Beàrnaraigh', polygon => [[88000,879000],[95000,879000],[95000,884000],[90000,884000],[88000,881000],[88000,879000]] };
$maps{"B:454E.b"} = { bbox => [[84000, 880000], [87200, 884500]], area => '12.82', series => 'B', number => '454', parent => 'B:454E', title => 'North Uist & Berneray / Uibhist a Tuath agus Beàrnaraigh', polygon => [[84000,880000],[87000,880000],[87000,883100],[87200,883200],[87000,883800],[87000,884500],[85000,884500],[84000,883000],[84000,880000]] };
$maps{"B:455"} = { bbox => [[95000, 881350], [125000, 903700]], area => '600.23', series => 'B', number => '455', parent => 'B:455', title => 'South Harris / Ceann a Deas na Hearadh (Taransay / Tarasaigh)', polygon => [[95000,881500],[103750,881500],[104400,881350],[104950,881500],[119000,881500],[119000,891500],[125000,891500],[125000,903500],[104000,903500],[103700,903700],[103300,903700],[103000,903500],[95000,903500],[95000,881500]] };
$maps{"B:455.a"} = { bbox => [[86500, 886000], [91500, 892000]], area => '30', series => 'B', number => '455', parent => 'B:455', title => 'South Harris / Ceann a Deas na Hearadh (Taransay / Tarasaigh)', polygon => [[86500,886000],[91500,886000],[91500,892000],[86500,892000],[86500,886000]] };
$maps{"B:455.b"} = { bbox => [[93000, 893500], [96000, 895000]], area => '4.5', series => 'B', number => '455', parent => 'B:455', title => 'South Harris / Ceann a Deas na Hearadh (Taransay / Tarasaigh)', polygon => [[93000,893500],[96000,893500],[96000,895000],[93000,895000],[93000,893500]] };
$maps{"B:456"} = { bbox => [[94700, 900000], [125000, 920000]], area => '600.1425', series => 'B', number => '456', parent => 'B:456', title => 'North Harris & Loch Seaforth / Ceann a Tuath na Hearadh agus Loch Shìophoirt', polygon => [[95000,900000],[125000,900000],[125000,920000],[95000,920000],[95000,916500],[94700,916300],[94900,916000],[95000,914950],[95000,900000]] };
$maps{"B:456.a"} = { bbox => [[86500, 910500], [89500, 912500]], area => '6', series => 'B', number => '456', parent => 'B:456', title => 'North Harris & Loch Seaforth / Ceann a Tuath na Hearadh agus Loch Shìophoirt', polygon => [[86500,910500],[89500,910500],[89500,912500],[86500,912500],[86500,910500]] };
$maps{"B:457"} = { bbox => [[122500, 896000], [144500, 926000]], area => '600', series => 'B', number => '457', parent => 'B:457', title => 'South East Lewis / Taobh an Eardheas Leòdhais (Loch Eireasort & Shiant Islands / Loch Èireasort agus Na h-Eileanan Mòra)', polygon => [[122500,900000],[137500,900000],[137500,896000],[144500,896000],[144500,926000],[122500,926000],[122500,900000]] };
$maps{"B:458"} = { bbox => [[97000, 919000], [124000, 941000]], area => '594', series => 'B', number => '458', parent => 'B:458', title => 'West Lewis / Taobh Siar Leòdhais (Callanish & Great Bernera / Calanais agus Beàrnaraigh)', polygon => [[97000,919000],[124000,919000],[124000,941000],[97000,941000],[97000,919000]] };
$maps{"B:458.a"} = { bbox => [[110800, 940000], [115500, 944200]], area => '19.74', series => 'B', number => '458', parent => 'B:458', title => 'West Lewis / Taobh Siar Leòdhais (Callanish & Great Bernera / Calanais agus Beàrnaraigh)', polygon => [[110800,940000],[115500,940000],[115500,944200],[110800,944200],[110800,940000]] };
$maps{"B:459W"} = { bbox => [[116000, 924000], [139000, 944000]], area => '460', series => 'B', number => '459', parent => 'B:459W', title => 'Central Lewis & Stornoway / Meadhan Leòdhais agus Steornabhagh (Eye Peninsula & Callanish / An Rubha agus Calanais)', polygon => [[116000,924000],[139000,924000],[139000,944000],[116000,944000],[116000,924000]] };
$maps{"B:459E"} = { bbox => [[138000, 924000], [158000, 944000]], area => '400', series => 'B', number => '459', parent => 'B:459E', title => 'Central Lewis & Stornoway / Meadhan Leòdhais agus Steornabhagh (Eye Peninsula & Callanish / An Rubha agus Calanais)', polygon => [[138000,924000],[158000,924000],[158000,944000],[138000,944000],[138000,924000]] };
$maps{"B:460W"} = { bbox => [[117000, 940000], [137000, 960000]], area => '400', series => 'B', number => '460', parent => 'B:460W', title => 'North Lewis / Ceann a Tuath Leòdhais (St Kilda & Flannan Isles / Hiort agus Na h-Eileanan Flannach)', polygon => [[117000,940000],[137000,940000],[137000,960000],[117000,960000],[117000,940000]] };
$maps{"B:460W.a"} = { bbox => [[5000, 896000], [14000, 903000]], area => '63', series => 'B', number => '460', parent => 'B:460W', title => 'North Lewis / Ceann a Tuath Leòdhais (St Kilda & Flannan Isles / Hiort agus Na h-Eileanan Flannach)', polygon => [[5000,896000],[14000,896000],[14000,903000],[5000,903000],[5000,896000]] };
$maps{"B:460W.b"} = { bbox => [[68500, 944500], [74500, 947500]], area => '18', series => 'B', number => '460', parent => 'B:460W', title => 'North Lewis / Ceann a Tuath Leòdhais (St Kilda & Flannan Isles / Hiort agus Na h-Eileanan Flannach)', polygon => [[68500,944500],[74500,944500],[74500,947500],[68500,947500],[68500,944500]] };
$maps{"B:460W.c"} = { bbox => [[14000, 904000], [17000, 907000]], area => '9', series => 'B', number => '460', parent => 'B:460W', title => 'North Lewis / Ceann a Tuath Leòdhais (St Kilda & Flannan Isles / Hiort agus Na h-Eileanan Flannach)', polygon => [[14000,904000],[17000,904000],[17000,907000],[14000,907000],[14000,904000]] };
$maps{"B:460E"} = { bbox => [[137000, 944000], [157000, 967000]], area => '460', series => 'B', number => '460', parent => 'B:460E', title => 'North Lewis / Ceann a Tuath Leòdhais (St Kilda & Flannan Isles / Hiort agus Na h-Eileanan Flannach)', polygon => [[137000,944000],[157000,944000],[157000,967000],[137000,967000],[137000,944000]] };
$maps{"B:460E.a"} = { bbox => [[179500, 1031000], [182500, 1034000]], area => '9', series => 'B', number => '460', parent => 'B:460E', title => 'North Lewis / Ceann a Tuath Leòdhais (St Kilda & Flannan Isles / Hiort agus Na h-Eileanan Flannach)', polygon => [[179500,1031000],[182500,1031000],[182500,1034000],[179500,1034000],[179500,1031000]] };
$maps{"B:460E.b"} = { bbox => [[161000, 1029500], [163000, 1031500]], area => '4', series => 'B', number => '460', parent => 'B:460E', title => 'North Lewis / Ceann a Tuath Leòdhais (St Kilda & Flannan Isles / Hiort agus Na h-Eileanan Flannach)', polygon => [[161000,1029500],[163000,1029500],[163000,1031500],[161000,1031500],[161000,1029500]] };
$maps{"B:461N"} = { bbox => [[342000, 1000000], [362000, 1023300]], area => '460.435', series => 'B', number => '461', parent => 'B:461N', title => 'Orkney – East Mainland (South Ronaldsay, Shapinsay & Kirkwall)', polygon => [[342000,1000000],[362000,1000000],[362000,1023000],[346000,1023000],[345700,1023300],[344500,1023300],[344300,1023000],[342000,1023000],[342000,1000000]] };
$maps{"B:461S"} = { bbox => [[334000, 976500], [354000, 1000000]], area => '400.65', series => 'B', number => '461', parent => 'B:461S', title => 'Orkney – East Mainland (South Ronaldsay, Shapinsay & Kirkwall)', polygon => [[334000,977000],[346100,977000],[346900,976500],[347400,976500],[348200,977000],[349000,977000],[349000,989000],[354000,989000],[354000,1000000],[334000,1000000],[334000,977000]] };
$maps{"B:462"} = { bbox => [[317000, 987500], [344000, 1009500]], area => '594', series => 'B', number => '462', parent => 'B:462', title => 'Orkney – Hoy, South Walls & Flotta', polygon => [[317000,987500],[344000,987500],[344000,1009500],[317000,1009500],[317000,987500]] };
$maps{"B:462.a"} = { bbox => [[255000, 1017500], [257000, 1018500]], area => '2', series => 'B', number => '462', parent => 'B:462', title => 'Orkney – Hoy, South Walls & Flotta', polygon => [[255000,1017500],[257000,1017500],[257000,1018500],[255000,1018500],[255000,1017500]] };
$maps{"B:462.b"} = { bbox => [[261000, 1024000], [263000, 1025000]], area => '2', series => 'B', number => '462', parent => 'B:462', title => 'Orkney – Hoy, South Walls & Flotta', polygon => [[261000,1024000],[263000,1024000],[263000,1025000],[261000,1025000],[261000,1024000]] };
$maps{"B:463"} = { bbox => [[321500, 1002900], [343500, 1030599]], area => '595.87695', series => 'B', number => '463', parent => 'B:463', title => 'Orkney – West Mainland (Stromness & Graemsay)', polygon => [[321500,1003000],[331000,1003000],[331500,1002900],[332000,1003000],[343500,1003000],[343500,1030000],[332100,1030000],[331800,1030599],[329000,1030599],[328800,1030000],[321500,1030000],[321500,1003000]] };
$maps{"B:464"} = { bbox => [[335400, 1025000], [357500, 1056000]], area => '598.075', series => 'B', number => '464', parent => 'B:464', title => 'Orkney – Westray, Papa Westray, Rousay, Egilsay & Wyre', polygon => [[335500,1026000],[340000,1026000],[343000,1025000],[345000,1025000],[346000,1026000],[357500,1026000],[357500,1044000],[352000,1044000],[352000,1056000],[335500,1056000],[335500,1030000],[335400,1029000],[335500,1028500],[335500,1026000]] };
$maps{"B:465N"} = { bbox => [[359500, 1033099], [379500, 1057200]], area => '400.9557', series => 'B', number => '465', parent => 'B:465N', title => 'Orkney – Sanday, Eday, North Ronaldsay & Stronsay', polygon => [[359500,1033500],[360100,1033500],[360400,1033099],[360900,1033099],[361000,1033500],[379500,1033500],[379500,1056500],[378700,1056500],[378500,1057000],[378000,1057200],[377500,1057000],[377400,1056500],[369500,1056500],[369500,1050500],[359500,1050500],[359500,1033500]] };
$maps{"B:465S"} = { bbox => [[350000, 1018000], [370000, 1041000]], area => '460', series => 'B', number => '465', parent => 'B:465S', title => 'Orkney – Sanday, Eday, North Ronaldsay & Stronsay', polygon => [[350000,1018000],[370000,1018000],[370000,1041000],[350000,1041000],[350000,1018000]] };
$maps{"B:465S.a"} = { bbox => [[366000, 1015000], [369000, 1018000]], area => '9', series => 'B', number => '465', parent => 'B:465S', title => 'Orkney – Sanday, Eday, North Ronaldsay & Stronsay', polygon => [[366000,1015000],[369000,1015000],[369000,1018000],[366000,1018000],[366000,1015000]] };
$maps{"B:466N"} = { bbox => [[433000, 1126000], [456000, 1146000]], area => '460', series => 'B', number => '466', parent => 'B:466N', title => 'Shetland – Mainland South (Lerwick, Sumburgh & Fair Isle)', polygon => [[433000,1126000],[456000,1126000],[456000,1146000],[433000,1146000],[433000,1126000]] };
$maps{"B:466S"} = { bbox => [[428000, 1107000], [448000, 1127000]], area => '400', series => 'B', number => '466', parent => 'B:466S', title => 'Shetland – Mainland South (Lerwick, Sumburgh & Fair Isle)', polygon => [[428000,1107000],[448000,1107000],[448000,1127000],[428000,1127000],[428000,1107000]] };
$maps{"B:466S.a"} = { bbox => [[419000, 1068500], [423000, 1074500]], area => '24', series => 'B', number => '466', parent => 'B:466S', title => 'Shetland – Mainland South (Lerwick, Sumburgh & Fair Isle)', polygon => [[419000,1068500],[423000,1068500],[423000,1074500],[419000,1074500],[419000,1068500]] };
$maps{"B:467E"} = { bbox => [[433000, 1140000], [453000, 1160000]], area => '400', series => 'B', number => '467', parent => 'B:467E', title => 'Shetland – Mainland Central (Lerwick, Papa Stour & Foula)', polygon => [[433000,1140000],[453000,1140000],[453000,1160000],[433000,1160000],[433000,1140000]] };
$maps{"B:467W"} = { bbox => [[413500, 1140000], [433500, 1163000]], area => '460', series => 'B', number => '467', parent => 'B:467W', title => 'Shetland – Mainland Central (Lerwick, Papa Stour & Foula)', polygon => [[413500,1140000],[433500,1140000],[433500,1163000],[413500,1163000],[413500,1140000]] };
$maps{"B:467W.a"} = { bbox => [[393000, 1136000], [398500, 1142000]], area => '33', series => 'B', number => '467', parent => 'B:467W', title => 'Shetland – Mainland Central (Lerwick, Papa Stour & Foula)', polygon => [[393000,1136000],[398500,1136000],[398500,1142000],[393000,1142000],[393000,1136000]] };
$maps{"B:468"} = { bbox => [[440000, 1158000], [470700, 1180000]], area => '600.385', series => 'B', number => '468', parent => 'B:468', title => 'Shetland – Mainland North East (Whalsay & Out Skerries)', polygon => [[440000,1158000],[470000,1158000],[470000,1171200],[470700,1172000],[470000,1172300],[470000,1174000],[460000,1174000],[460000,1180000],[440000,1180000],[440000,1158000]] };
$maps{"B:469N"} = { bbox => [[420000, 1177700], [443200, 1198200]], area => '400.36', series => 'B', number => '469', parent => 'B:469N', title => 'Shetland – Mainland North West (North Roe & Sullom Voe)', polygon => [[420000,1177700],[443000,1177700],[443000,1180800],[443200,1181000],[443200,1181400],[443000,1181500],[443000,1197700],[438000,1197700],[437600,1198200],[437300,1198200],[437300,1197700],[426000,1197700],[426000,1187700],[420000,1187700],[420000,1177700]] };
$maps{"B:469S"} = { bbox => [[420000, 1160000], [443000, 1180000]], area => '460', series => 'B', number => '469', parent => 'B:469S', title => 'Shetland – Mainland North West (North Roe & Sullom Voe)', polygon => [[420000,1160000],[443000,1160000],[443000,1180000],[420000,1180000],[420000,1160000]] };
$maps{"B:469S.a"} = { bbox => [[409000, 1164500], [411000, 1166000]], area => '3', series => 'B', number => '469', parent => 'B:469S', title => 'Shetland – Mainland North West (North Roe & Sullom Voe)', polygon => [[409000,1164500],[411000,1164500],[411000,1166000],[409000,1166000],[409000,1164500]] };
$maps{"B:470N"} = { bbox => [[447000, 1197000], [468000, 1220500]], area => '401.585', series => 'B', number => '470', parent => 'B:470N', title => 'Shetland – Unst, Yell & Fetlar', polygon => [[447000,1197000],[467000,1197000],[467000,1215000],[468000,1215300],[468000,1215800],[467000,1216200],[467000,1216900],[467500,1217100],[467400,1217700],[467000,1217900],[467000,1220000],[461800,1220000],[461500,1220500],[461100,1220500],[460700,1220000],[453000,1220000],[453000,1210000],[447000,1210000],[447000,1197000]] };
$maps{"B:470S"} = { bbox => [[443000, 1177000], [463000, 1200000]], area => '397', series => 'B', number => '470', parent => 'B:470S', title => 'Shetland – Unst, Yell & Fetlar', polygon => [[443000,1177000],[456000,1177000],[456000,1186000],[463000,1186000],[463000,1200000],[443000,1200000],[443000,1177000]] };
$maps{"B:470S.a"} = { bbox => [[462000, 1187000], [468000, 1195000]], area => '48', series => 'B', number => '470', parent => 'B:470S', title => 'Shetland – Unst, Yell & Fetlar', polygon => [[462000,1187000],[468000,1187000],[468000,1195000],[462000,1195000],[462000,1187000]] };
$maps{"B:OL1E"} = { bbox => [[410000, 380000], [432400, 410000]], area => '660.72', series => 'B', number => 'OL1', parent => 'B:OL1E', title => 'Peak District – Dark Peak area (Kinder Scout, Bleaklow, Black Hill & Ladybower Reservoir)', polygon => [[410000,380000],[432000,380000],[432000,405000],[432400,405000],[432400,406600],[432000,407000],[432000,410000],[410000,410000],[410000,380000]] };
$maps{"B:OL1W"} = { bbox => [[393000, 380000], [415000, 410000]], area => '600', series => 'B', number => 'OL1', parent => 'B:OL1W', title => 'Peak District – Dark Peak area (Kinder Scout, Bleaklow, Black Hill & Ladybower Reservoir)', polygon => [[393000,380000],[415000,380000],[415000,410000],[396000,410000],[396000,390000],[393000,390000],[393000,380000]] };
$maps{"B:OL2E"} = { bbox => [[380000, 450000], [410000, 472650]], area => '597.5135', series => 'B', number => 'OL2', parent => 'B:OL2E', title => 'Yorkshire Dales – Southern & Western areas (Whernside, Ingleborough & Pen-y-ghent)', polygon => [[380000,457000],[389000,457000],[389000,450000],[410000,450000],[410000,472000],[397550,472000],[397520,472450],[397300,472600],[397000,472650],[396650,472450],[396600,472000],[380000,472000],[380000,457000]] };
$maps{"B:OL2W"} = { bbox => [[358000, 467500], [388000, 490000]], area => '660.7825', series => 'B', number => 'OL2', parent => 'B:OL2W', title => 'Yorkshire Dales – Southern & Western areas (Whernside, Ingleborough & Pen-y-ghent)', polygon => [[358000,468000],[372750,468000],[373000,467800],[373350,467650],[373800,468000],[375550,468000],[376050,467500],[376500,467500],[376670,467620],[377500,468000],[388000,468000],[388000,490000],[358000,490000],[358000,468000]] };
$maps{"B:OL4S"} = { bbox => [[301000, 509000], [331000, 531000]], area => '660', series => 'B', number => 'OL4', parent => 'B:OL4S', title => 'The English Lakes – North Western area (Keswick, Cockermouth & Wigton)', polygon => [[301000,509000],[331000,509000],[331000,531000],[301000,531000],[301000,509000]] };
$maps{"B:OL4N"} = { bbox => [[301000, 530000], [331000, 550000]], area => '600', series => 'B', number => 'OL4', parent => 'B:OL4N', title => 'The English Lakes – North Western area (Keswick, Cockermouth & Wigton)', polygon => [[301000,530000],[331000,530000],[331000,550000],[301000,550000],[301000,530000]] };
$maps{"B:OL5S"} = { bbox => [[330000, 509000], [360000, 531000]], area => '660', series => 'B', number => 'OL5', parent => 'B:OL5S', title => 'The English Lakes – North Eastern area (Penrith, Patterdale & Caldbeck)', polygon => [[330000,509000],[360000,509000],[360000,531000],[330000,531000],[330000,509000]] };
$maps{"B:OL5N"} = { bbox => [[330000, 530000], [360000, 550000]], area => '600', series => 'B', number => 'OL5', parent => 'B:OL5N', title => 'The English Lakes – North Eastern area (Penrith, Patterdale & Caldbeck)', polygon => [[330000,530000],[360000,530000],[360000,550000],[330000,550000],[330000,530000]] };
$maps{"B:OL6N"} = { bbox => [[301000, 489000], [331000, 511000]], area => '660', series => 'B', number => 'OL6', parent => 'B:OL6N', title => 'The English Lakes – South-Western area (Coniston, Ulverston & Barrow-in-Furness)', polygon => [[301000,489000],[331000,489000],[331000,511000],[301000,511000],[301000,489000]] };
$maps{"B:OL6S"} = { bbox => [[307000, 461000], [329000, 491000]], area => '580.0825', series => 'B', number => 'OL6', parent => 'B:OL6S', title => 'The English Lakes – South-Western area (Coniston, Ulverston & Barrow-in-Furness)', polygon => [[307500,473000],[313000,473000],[313000,461000],[329000,461000],[329000,491000],[307300,491000],[307100,490000],[307000,489900],[307000,489000],[307500,487850],[307500,473000]] };
$maps{"B:OL7N"} = { bbox => [[330000, 489000], [360000, 511000]], area => '660', series => 'B', number => 'OL7', parent => 'B:OL7N', title => 'The English Lakes – South-eastern area (Windermere, Kendal & Silverdale)', polygon => [[330000,489000],[360000,489000],[360000,511000],[330000,511000],[330000,489000]] };
$maps{"B:OL7S"} = { bbox => [[329000, 470000], [359000, 490000]], area => '600', series => 'B', number => 'OL7', parent => 'B:OL7S', title => 'The English Lakes – South-eastern area (Windermere, Kendal & Silverdale)', polygon => [[329000,470000],[359000,470000],[359000,490000],[329000,490000],[329000,470000]] };
$maps{"B:OL9W"} = { bbox => [[250000, 129580], [280000, 151350]], area => '593.17725', series => 'B', number => 'OL9', parent => 'B:OL9W', title => 'Exmoor (Barnstaple, Lynton, Minehead & Dulverton)', polygon => [[250000,130000],[278350,130000],[278700,129800],[279200,129580],[280000,129580],[280000,130000],[280000,151000],[275950,151000],[275400,151350],[274800,151000],[274000,151000],[274000,150000],[272900,150000],[272400,150200],[271400,150250],[270800,150200],[270400,150000],[264000,150000],[264000,149000],[250000,149000],[250000,130000]] };
$maps{"B:OL9E"} = { bbox => [[280000, 127000], [310000, 149750]], area => '663.4625', series => 'B', number => 'OL9', parent => 'B:OL9E', title => 'Exmoor (Barnstaple, Lynton, Minehead & Dulverton)', polygon => [[280000,127500],[290550,127500],[291300,127000],[296950,127000],[297800,127500],[310000,127500],[310000,149500],[281500,149500],[281000,149650],[280000,149750],[280000,127500]] };
$maps{"B:OL12E"} = { bbox => [[289000, 204000], [311000, 234000]], area => '660', series => 'B', number => 'OL12', parent => 'B:OL12E', title => 'Brecon Beacons National Park – Western area', polygon => [[289000,204000],[311000,204000],[311000,234000],[289000,234000],[289000,204000]] };
$maps{"B:OL12W"} = { bbox => [[266350, 206000], [289000, 236000]], area => '595.8125', series => 'B', number => 'OL12', parent => 'B:OL12W', title => 'Brecon Beacons National Park – Western area', polygon => [[267000,211000],[280000,211000],[280000,206000],[289000,206000],[289000,236000],[267000,236000],[267000,220000],[266450,219400],[266350,219100],[266450,218550],[267000,218050],[267000,211000]] };
$maps{"B:OL13S"} = { bbox => [[310000, 205000], [340000, 225000]], area => '600', series => 'B', number => 'OL13', parent => 'B:OL13S', title => 'Brecon Beacons National Park – Eastern area', polygon => [[310000,205000],[340000,205000],[340000,225000],[310000,225000],[310000,205000]] };
$maps{"B:OL13N"} = { bbox => [[310000, 223000], [340000, 245000]], area => '660', series => 'B', number => 'OL13', parent => 'B:OL13N', title => 'Brecon Beacons National Park – Eastern area', polygon => [[310000,223000],[340000,223000],[340000,245000],[310000,245000],[310000,223000]] };
$maps{"B:OL14W"} = { bbox => [[340000, 189345], [360780, 220000]], area => '605.072825', series => 'B', number => 'OL14', parent => 'B:OL14W', title => 'Wye Valley & Forest of Dean', polygon => [[340000,190000],[354300,190000],[355150,189350],[355900,189350],[356250,189345],[358050,190000],[360000,190000],[360000,196150],[360780,196640],[360780,200070],[360000,200800],[360000,216750],[360400,217400],[360400,217800],[360000,218050],[360000,220000],[340000,220000],[340000,190000]] };
$maps{"B:OL14E"} = { bbox => [[356000, 199310], [378000, 230000]], area => '662.57715', series => 'B', number => 'OL14', parent => 'B:OL14E', title => 'Wye Valley & Forest of Dean', polygon => [[356000,200000],[358350,200000],[358880,199310],[362150,199310],[362550,200000],[378000,200000],[378000,230000],[356000,230000],[356000,200000]] };
$maps{"B:OL15E"} = { bbox => [[376000, 73000], [406750, 95900]], area => '664.1175', series => 'B', number => 'OL15', parent => 'B:OL15E', title => 'Purbeck & South Dorset (Poole, Dorchester, Weymouth & Swanage)', polygon => [[376000,73000],[406000,73000],[406000,89000],[406750,89550],[406750,91750],[406000,92000],[406000,95000],[395900,95000],[395600,95200],[394900,95400],[394900,95400],[394700,95900],[394350,95900],[393950,95800],[393550,95650],[393550,95000],[385400,95000],[385250,95400],[383200,95300],[382500,95000],[376000,95000],[376000,73000]] };
$maps{"B:OL15W"} = { bbox => [[345300, 73000], [376000, 95000]], area => '600.95', series => 'B', number => 'OL15', parent => 'B:OL15W', title => 'Purbeck & South Dorset (Poole, Dorchester, Weymouth & Swanage)', polygon => [[346000,85000],[351000,85000],[351000,73000],[376000,73000],[376000,95000],[346000,95000],[346000,94250],[345500,94000],[345300,93500],[345500,93000],[345850,92150],[346000,92000],[346000,85000]] };
$maps{"B:OL15W.a"} = { bbox => [[366000, 68000], [371000, 75000]], area => '35', series => 'B', number => 'OL15', parent => 'B:OL15W', title => 'Purbeck & South Dorset (Poole, Dorchester, Weymouth & Swanage)', polygon => [[366000,68000],[371000,68000],[371000,75000],[366000,75000],[366000,68000]] };
$maps{"B:OL16E"} = { bbox => [[380000, 600000], [402530, 630000]], area => '660.71225', series => 'B', number => 'OL16', parent => 'B:OL16E', title => 'The Cheviot Hills (Jedburgh & Wooler)', polygon => [[380000,600000],[402000,600000],[402000,614100],[402300,615300],[402530,615900],[402250,616450],[402000,617000],[402000,630000],[380000,630000],[380000,600000]] };
$maps{"B:OL16W"} = { bbox => [[360000, 600000], [380000, 630000]], area => '600', series => 'B', number => 'OL16', parent => 'B:OL16W', title => 'The Cheviot Hills (Jedburgh & Wooler)', polygon => [[360000,600000],[380000,600000],[380000,630000],[360000,630000],[360000,600000]] };
$maps{"B:OL17W"} = { bbox => [[247000, 345000], [269000, 375750]], area => '661.1075', series => 'B', number => 'OL17', parent => 'B:OL17W', title => 'Snowdon / Yr Wyddfa (Conwy Valley / Dyffryn Conwy)', polygon => [[247000,345000],[269000,345000],[269000,375000],[268850,375450],[268650,375650],[268300,375750],[267600,375750],[267350,375250],[266800,375000],[247000,375000],[247000,345000]] };
$maps{"B:OL17E"} = { bbox => [[267500, 355000], [290000, 385000]], area => '600.425', series => 'B', number => 'OL17', parent => 'B:OL17E', title => 'Snowdon / Yr Wyddfa (Conwy Valley / Dyffryn Conwy)', polygon => [[268000,355000],[290000,355000],[290000,380000],[285000,380000],[285000,385000],[273000,385000],[273000,378000],[268000,378000],[268000,376000],[267500,376000],[267500,375500],[267700,375100],[268000,375000],[268000,355000]] };
$maps{"B:OL18W"} = { bbox => [[254000, 315350], [276000, 346300]], area => '661.8155', series => 'B', number => 'OL18', parent => 'B:OL18W', title => 'Harlech, Porthmadog & Bala / Y Bala', polygon => [[254000,316000],[260200,316000],[260700,315500],[261000,315380],[261500,315350],[262000,315350],[262500,315450],[263000,315750],[263200,316000],[276000,316000],[276000,346000],[270800,346000],[270500,346200],[270000,346300],[269500,346250],[269000,346000],[254000,346000],[254000,316000]] };
$maps{"B:OL18E"} = { bbox => [[269000, 333000], [299000, 355000]], area => '591.25', series => 'B', number => 'OL18', parent => 'B:OL18E', title => 'Harlech, Porthmadog & Bala / Y Bala', polygon => [[269000,345500],[274500,345500],[274500,333000],[299000,333000],[299000,355000],[269000,355000],[269000,345500]] };
$maps{"B:OL19S"} = { bbox => [[360000, 490000], [390000, 510000]], area => '600', series => 'B', number => 'OL19', parent => 'B:OL19S', title => 'Howgill Fells & Upper Eden Valley', polygon => [[360000,490000],[390000,490000],[390000,510000],[360000,510000],[360000,490000]] };
$maps{"B:OL19N"} = { bbox => [[360000, 508000], [390000, 530000]], area => '660', series => 'B', number => 'OL19', parent => 'B:OL19N', title => 'Howgill Fells & Upper Eden Valley', polygon => [[360000,508000],[390000,508000],[390000,530000],[360000,530000],[360000,508000]] };
$maps{"B:OL20E"} = { bbox => [[270000, 34800], [292000, 65000]], area => '580.065', series => 'B', number => 'OL20', parent => 'B:OL20E', title => 'South Devon (Brixham to Newton Ferrers)', polygon => [[270000,35000],[276900,35000],[277200,34800],[277550,35000],[284000,35000],[284000,45000],[292000,45000],[292000,65000],[270000,65000],[270000,35000]] };
$maps{"B:OL20E.a"} = { bbox => [[287500, 48250], [294900, 57500]], area => '63.44875', series => 'B', number => 'OL20', parent => 'B:OL20E', title => 'South Devon (Brixham to Newton Ferrers)', polygon => [[287500,48500],[287500,48250],[288000,48250],[288400,48350],[288450,48500],[294500,48500],[294500,55650],[294900,56700],[294500,56850],[294500,57500],[287500,57500],[287500,48500]] };
$maps{"B:OL20W"} = { bbox => [[248000, 36000], [270000, 66000]], area => '600', series => 'B', number => 'OL20', parent => 'B:OL20W', title => 'South Devon (Brixham to Newton Ferrers)', polygon => [[248000,42000],[258000,42000],[258000,36000],[270000,36000],[270000,66000],[248000,66000],[248000,42000]] };
$maps{"B:OL21S"} = { bbox => [[380000, 410000], [410000, 432000]], area => '600', series => 'B', number => 'OL21', parent => 'B:OL21S', title => 'South Pennines (Burnley, Hebden Bridge, Keighley & Todmorden)', polygon => [[380000,415000],[392000,415000],[392000,410000],[410000,410000],[410000,432000],[380000,432000],[380000,415000]] };
$maps{"B:OL21N"} = { bbox => [[378000, 429000], [408000, 451420]], area => '661.9845', series => 'B', number => 'OL21', parent => 'B:OL21N', title => 'South Pennines (Burnley, Hebden Bridge, Keighley & Todmorden)', polygon => [[378000,429000],[408000,429000],[408000,451000],[401600,451000],[401600,451420],[396900,451420],[396850,451000],[378000,451000],[378000,429000]] };
$maps{"B:OL22E"} = { bbox => [[428000, 89520], [450000, 120000]], area => '596.973', series => 'B', number => 'OL22', parent => 'B:OL22E', title => 'New Forest (Southampton, Ringwood, Ferndown, Lymington, Christchurch & Bournemouth)', polygon => [[428000,90000],[430500,90000],[431400,89580],[434800,89580],[435000,89520],[435200,89580],[438000,89580],[438000,92000],[448000,98000],[450000,98000],[450000,120000],[428000,120000],[428000,90000]] };
$maps{"B:OL22W"} = { bbox => [[406000, 89750], [428000, 120000]], area => '660.1625', series => 'B', number => 'OL22', parent => 'B:OL22W', title => 'New Forest (Southampton, Ringwood, Ferndown, Lymington, Christchurch & Bournemouth)', polygon => [[406000,90000],[406500,90000],[406600,89850],[406750,89750],[407000,89750],[407500,90000],[428000,90000],[428000,120000],[406000,120000],[406000,90000]] };
$maps{"B:OL23W"} = { bbox => [[256000, 290000], [278000, 320000]], area => '660', series => 'B', number => 'OL23', parent => 'B:OL23W', title => 'Cadair Idris & Llyn Tegid', polygon => [[256000,290000],[278000,290000],[278000,320000],[256000,320000],[256000,290000]] };
$maps{"B:OL23E"} = { bbox => [[276000, 309000], [298000, 336700]], area => '595.155', series => 'B', number => 'OL23', parent => 'B:OL23E', title => 'Cadair Idris & Llyn Tegid', polygon => [[276000,309000],[298000,309000],[298000,336000],[293600,336000],[292800,336700],[291900,336700],[291200,336000],[276000,336000],[276000,309000]] };
$maps{"B:OL24W"} = { bbox => [[393000, 350000], [415000, 380110]], area => '660.13805', series => 'B', number => 'OL24', parent => 'B:OL24W', title => 'The Peak District – White Peak area (Buxton, Bakewell, Matlock & Dove Dale)', polygon => [[393000,350000],[415000,350000],[415000,380000],[404520,380000],[404370,380110],[403250,380110],[403130,380000],[393000,380000],[393000,350000]] };
$maps{"B:OL24E"} = { bbox => [[415000, 349750], [435250, 380000]], area => '600.5415', series => 'B', number => 'OL24', parent => 'B:OL24E', title => 'The Peak District – White Peak area (Buxton, Bakewell, Matlock & Dove Dale)', polygon => [[415000,350000],[424450,350000],[424550,349850],[424800,349750],[425050,349750],[425750,349900],[425380,350000],[435000,350000],[435000,352900],[435200,353200],[435250,353700],[435250,354200],[435000,354600],[435000,380000],[415000,380000],[415000,350000]] };
$maps{"B:OL26N"} = { bbox => [[441700, 500000], [472000, 522400]], area => '599.3425', series => 'B', number => 'OL26', parent => 'B:OL26N', title => 'North York Moors – Western area', polygon => [[442000,500000],[472000,500000],[472000,522000],[469800,522000],[469500,522200],[469300,522200],[468500,522400],[467600,522400],[467400,522000],[457000,522000],[457000,520000],[450000,520000],[450000,516000],[442000,516000],[442000,514600],[441750,514000],[441700,513500],[441700,513000],[441800,512200],[442000,511500],[442000,500000]] };
$maps{"B:OL26S"} = { bbox => [[443550, 478000], [474000, 500000]], area => '660.6525', series => 'B', number => 'OL26', parent => 'B:OL26S', title => 'North York Moors – Western area', polygon => [[444000,478000],[474000,478000],[474000,500000],[444000,500000],[444000,496000],[443550,494700],[443550,494300],[444000,493500],[444000,478000]] };
$maps{"B:OL27N"} = { bbox => [[470000, 499000], [500000, 521000]], area => '600', series => 'B', number => 'OL27', parent => 'B:OL27N', title => 'North York Moors – Eastern area', polygon => [[470000,499000],[500000,499000],[500000,515000],[490000,515000],[490000,521000],[470000,521000],[470000,499000]] };
$maps{"B:OL27S"} = { bbox => [[474000, 479000], [504450, 501000]], area => '661.60825', series => 'B', number => 'OL27', parent => 'B:OL27S', title => 'North York Moors – Eastern area', polygon => [[474000,479000],[504000,479000],[504000,485500],[504200,486150],[504420,486350],[504450,489600],[504000,489900],[504000,501000],[474000,501000],[474000,479000]] };
$maps{"B:OL28N"} = { bbox => [[250000, 74000], [280930, 96000]], area => '664.22275', series => 'B', number => 'OL28', parent => 'B:OL28N', title => 'Dartmoor', polygon => [[250500,74000],[280500,74000],[280500,77800],[280930,78100],[280930,78900],[280500,79200],[280500,87750],[280750,88000],[280800,88300],[280800,88500],[280500,88800],[280500,96000],[250500,96000],[250500,85100],[250080,84500],[250080,78000],[250000,78000],[250000,76850],[250500,76450],[250500,74000]] };
$maps{"B:OL28S"} = { bbox => [[248000, 55000], [278000, 77000]], area => '600', series => 'B', number => 'OL28', parent => 'B:OL28S', title => 'Dartmoor', polygon => [[248000,61000],[258000,61000],[258000,55000],[278000,55000],[278000,77000],[248000,77000],[248000,61000]] };
$maps{"B:OL29E"} = { bbox => [[445000, 75000], [467000, 105000]], area => '660', series => 'B', number => 'OL29', parent => 'B:OL29E', title => 'Isle of Wight (Cowes, Newport, Ryde, Sandown, Shanklin, Yarmouth & Ventnor)', polygon => [[445000,75000],[467000,75000],[467000,105000],[445000,105000],[445000,75000]] };
$maps{"B:OL29W"} = { bbox => [[428800, 75000], [451000, 105000]], area => '600.04', series => 'B', number => 'OL29', parent => 'B:OL29W', title => 'Isle of Wight (Cowes, Newport, Ryde, Sandown, Shanklin, Yarmouth & Ventnor)', polygon => [[429000,81000],[439000,81000],[439000,75000],[451000,75000],[451000,105000],[429000,105000],[429000,85000],[428800,84800],[429000,84600],[429000,81000]] };
$maps{"B:OL30S"} = { bbox => [[384000, 470000], [414000, 492000]], area => '660', series => 'B', number => 'OL30', parent => 'B:OL30S', title => 'Yorkshire Dales – Northern & Central areas (Wensleydale & Swaledale)', polygon => [[384000,470000],[414000,470000],[414000,492000],[414000,492000],[384000,492000],[384000,470000]] };
$maps{"B:OL30N"} = { bbox => [[384000, 492000], [414000, 514000]], area => '596', series => 'B', number => 'OL30', parent => 'B:OL30N', title => 'Yorkshire Dales – Northern & Central areas (Wensleydale & Swaledale)', polygon => [[384000,492000],[414000,492000],[414000,514000],[395000,514000],[395000,510000],[389000,510000],[389000,506000],[384000,506000],[384000,492000]] };
$maps{"B:OL31E"} = { bbox => [[390000, 510000], [410000, 540000]], area => '600', series => 'B', number => 'OL31', parent => 'B:OL31E', title => 'North Pennines (Teesdale & Weardale)', polygon => [[390000,510000],[410000,510000],[410000,540000],[390000,540000],[390000,510000]] };
$maps{"B:OL31W"} = { bbox => [[360000, 528000], [390000, 550000]], area => '660', series => 'B', number => 'OL31', parent => 'B:OL31W', title => 'North Pennines (Teesdale & Weardale)', polygon => [[360000,528000],[390000,528000],[390000,550000],[360000,550000],[360000,528000]] };
$maps{"B:OL35W"} = { bbox => [[169000, 220000], [199000, 242000]], area => '660', series => 'B', number => 'OL35', parent => 'B:OL35W', title => 'North Pembrokeshire / Gogledd Sir Benfro', polygon => [[169000,220000],[199000,220000],[199000,242000],[169000,242000],[169000,220000]] };
$maps{"B:OL35W.a"} = { bbox => [[165000, 221000], [171000, 229000]], area => '48', series => 'B', number => 'OL35', parent => 'B:OL35W', title => 'North Pembrokeshire / Gogledd Sir Benfro', polygon => [[165000,221000],[171000,221000],[171000,229000],[165000,229000],[165000,221000]] };
$maps{"B:OL35E"} = { bbox => [[198000, 222000], [220000, 252330]], area => '600.2937', series => 'B', number => 'OL35', parent => 'B:OL35E', title => 'North Pembrokeshire / Gogledd Sir Benfro', polygon => [[198000,222000],[220000,222000],[220000,252330],[219220,252330],[219000,252000],[208000,252000],[208000,246000],[198000,246000],[198000,222000]] };
$maps{"B:OL36W"} = { bbox => [[175200, 192600], [198000, 223750]], area => '664.93375', series => 'B', number => 'OL36', parent => 'B:OL36W', title => 'South Pembrokeshire / De Sir Benfro', polygon => [[176000,193000],[195300,193000],[196000,192600],[197600,192600],[198000,193000],[198000,223000],[185550,223000],[185100,223450],[184500,223500],[183600,223750],[181600,223750],[181000,223400],[180500,223000],[176000,223000],[176000,209800],[175200,209500],[175200,208500],[176000,207850],[176000,193000]] };
$maps{"B:OL36W.a"} = { bbox => [[171000, 204000], [176000, 211000]], area => '35', series => 'B', number => 'OL36', parent => 'B:OL36W', title => 'South Pembrokeshire / De Sir Benfro', polygon => [[171000,204000],[176000,204000],[176000,211000],[171000,211000],[171000,204000]] };
$maps{"B:OL36W.b"} = { bbox => [[146000, 208000], [148000, 209000]], area => '2', series => 'B', number => 'OL36', parent => 'B:OL36W', title => 'South Pembrokeshire / De Sir Benfro', polygon => [[146000,208000],[148000,208000],[148000,209000],[146000,209000],[146000,208000]] };
$maps{"B:OL36W.c"} = { bbox => [[159000, 209000], [161000, 210000]], area => '2', series => 'B', number => 'OL36', parent => 'B:OL36W', title => 'South Pembrokeshire / De Sir Benfro', polygon => [[159000,209000],[161000,209000],[161000,210000],[159000,210000],[159000,209000]] };
$maps{"B:OL36E"} = { bbox => [[198000, 193000], [220000, 223000]], area => '600.13', series => 'B', number => 'OL36', parent => 'B:OL36E', title => 'South Pembrokeshire / De Sir Benfro', polygon => [[198000,193000],[215000,193000],[215000,196250],[215250,196650],[215000,197050],[215000,203050],[215200,203200],[215000,203350],[215000,205000],[220000,205000],[220000,223000],[198000,223000],[198000,193000]] };
$maps{"B:OL40N"} = { bbox => [[622400, 307570], [653650, 330000]], area => '594.02025', series => 'B', number => 'OL40', parent => 'B:OL40N', title => 'The Broads (Wroxham, Beccles, Lowestoft & Great Yarmouth)', polygon => [[622850,308000],[623350,308000],[623550,307800],[624150,307570],[624650,307570],[625100,307700],[625450,308000],[653000,308000],[653000,308150],[653300,308750],[653650,309600],[653500,310700],[653000,311950],[653000,320000],[651000,320000],[642500,328500],[642500,330000],[623000,330000],[623000,310000],[622520,309300],[622400,308700],[622450,308350],[622850,308000]] };
$maps{"B:OL40S"} = { bbox => [[624580, 288000], [655700, 310000]], area => '662.1625', series => 'B', number => 'OL40', parent => 'B:OL40S', title => 'The Broads (Wroxham, Beccles, Lowestoft & Great Yarmouth)', polygon => [[625000,288000],[655000,288000],[655000,292400],[655350,292600],[655700,293700],[655350,294900],[655000,296200],[655000,310000],[625000,310000],[625000,308390],[624800,308000],[624580,307450],[624580,306600],[625000,306000],[625000,288000]] };
$maps{"B:OL41W"} = { bbox => [[346550, 440000], [369000, 470000]], area => '661.1725', series => 'B', number => 'OL41', parent => 'B:OL41W', title => 'Forest of Bowland & Ribblesdale (Pendle Hill, Clitheroe & Settle)', polygon => [[347000,440000],[369000,440000],[369000,470000],[347000,470000],[347000,466900],[346550,466450],[346550,464500],[347000,464000],[347000,460800],[346750,460450],[346750,460400],[347000,460200],[347000,440000]] };
$maps{"B:OL41E"} = { bbox => [[369000, 438000], [389450, 468000]], area => '600.8775', series => 'B', number => 'OL41', parent => 'B:OL41E', title => 'Forest of Bowland & Ribblesdale (Pendle Hill, Clitheroe & Settle)', polygon => [[369000,438000],[389000,438000],[389000,439250],[389450,440450],[389450,441550],[389000,442050],[389000,468000],[369000,468000],[369000,438000]] };
$maps{"B:OL42W"} = { bbox => [[350000, 580000], [380000, 600420]], area => '600.8775', series => 'B', number => 'OL42', parent => 'B:OL42W', title => 'Kielder Water & Forest (Bellingham & Simonside Hills)', polygon => [[350000,580000],[380000,580000],[380000,600000],[379000,600000],[378550,600420],[378300,600420],[378100,600330],[376600,600330],[376400,600250],[376000,600000],[350000,600000],[350000,580000]] };
$maps{"B:OL42E"} = { bbox => [[380000, 580000], [410000, 602350]], area => '660.39675', series => 'B', number => 'OL42', parent => 'B:OL42E', title => 'Kielder Water & Forest (Bellingham & Simonside Hills)', polygon => [[380000,580000],[410000,580000],[410000,602000],[406850,602000],[406450,602350],[405400,602220],[405150,602000],[380000,602000],[380000,580000]] };
$maps{"B:OL43W"} = { bbox => [[358000, 550000], [380000, 580000]], area => '660', series => 'B', number => 'OL43', parent => 'B:OL43W', title => 'Hadrian’s Wall (Haltwhistle & Hexham)', polygon => [[358000,550000],[380000,550000],[380000,580000],[358000,580000],[358000,550000]] };
$maps{"B:OL43E"} = { bbox => [[380000, 550000], [400000, 580000]], area => '600', series => 'B', number => 'OL43', parent => 'B:OL43E', title => 'Hadrian’s Wall (Haltwhistle & Hexham)', polygon => [[380000,550000],[400000,550000],[400000,580000],[380000,580000],[380000,550000]] };
$maps{"B:OL45S"} = { bbox => [[400000, 200000], [430370, 220000]], area => '600.1665', series => 'B', number => 'OL45', parent => 'B:OL45S', title => 'The Cotswolds (Burford, Chipping Campden, Cirencester & Stow-on-the-Wold)', polygon => [[400000,200000],[430000,200000],[430000,218300],[430370,218720],[430000,219200],[430000,220000],[400000,220000],[400000,200000]] };
$maps{"B:OL45N"} = { bbox => [[400000, 219700], [430000, 242000]], area => '660.3195', series => 'B', number => 'OL45', parent => 'B:OL45N', title => 'The Cotswolds (Burford, Chipping Campden, Cirencester & Stow-on-the-Wold)', polygon => [[400000,220000],[417000,220000],[417190,219820],[417700,219700],[418500,219850],[418500,220000],[430000,220000],[430000,242000],[400000,242000],[400000,220000]] };
$maps{"C:1"} = { bbox => [[430000, 1174250], [470000, 1220500]], area => '1802.04125', series => 'C', number => '1', parent => 'C:1', title => 'Shetland Islands (Yell & Unst)', polygon => [[430000,1175000],[451300,1175000],[451750,1174625],[452000,1174500],[453000,1174250],[453500,1174300],[454000,1174600],[454300,1175000],[470000,1175000],[470000,1220000],[462400,1220000],[461500,1220500],[461200,1220500],[460600,1220000],[430000,1220000],[430000,1175000]] };
$maps{"C:2"} = { bbox => [[409325, 1144800], [450750, 1190000]], area => '1801.44375', series => 'C', number => '2', parent => 'C:2', title => 'Shetland Islands (North Mainland)', polygon => [[410000,1145000],[430950,1145000],[430950,1144950],[431075,1144875],[431200,1145000],[431400,1145000],[431500,1144825],[431625,1144825],[431725,1144800],[431900,1145000],[450000,1145000],[450000,1153000],[450300,1153500],[450750,1154000],[450500,1154500],[450000,1154600],[450000,1190000],[410000,1190000],[410000,1165900],[409600,1165500],[409375,1165000],[409325,1164750],[409575,1164550],[410000,1164200],[410000,1145000]] };
$maps{"C:3"} = { bbox => [[429100, 1130000], [470850, 1175450]], area => '1803.45375', series => 'C', number => '3', parent => 'C:3', title => 'Shetland Islands (Lerwick)', polygon => [[430000,1130000],[470000,1130000],[470000,1171100],[470400,1171200],[470825,1171450],[470850,1171800],[470500,1172300],[470000,1172400],[470000,1175000],[453400,1175000],[453100,1175300],[452900,1175450],[452700,1175450],[452200,1175300],[452000,1175000],[430000,1175000],[430000,1174000],[429250,1173700],[429100,1173000],[429525,1172000],[429550,1171000],[429400,1170700],[429500,1170450],[430000,1170200],[430000,1130000]] };
$maps{"C:4"} = { bbox => [[420000, 1105000], [460000, 1150000]], area => '1800', series => 'C', number => '4', parent => 'C:4', title => 'Shetland Islands (South Mainland)', polygon => [[420000,1105000],[460000,1105000],[460000,1150000],[420000,1150000],[420000,1105000]] };
$maps{"C:4.a"} = { bbox => [[392000, 1135000], [400000, 1143000]], area => '64', series => 'C', number => '4', parent => 'C:4', title => 'Shetland Islands (South Mainland)', polygon => [[392000,1135000],[400000,1135000],[400000,1143000],[392000,1143000],[392000,1135000]] };
$maps{"C:4.b"} = { bbox => [[417000, 1068000], [425000, 1076000]], area => '64', series => 'C', number => '4', parent => 'C:4', title => 'Shetland Islands (South Mainland)', polygon => [[417000,1068000],[425000,1068000],[425000,1076000],[417000,1076000],[417000,1068000]] };
$maps{"C:5"} = { bbox => [[338700, 1014500], [379400, 1060000]], area => '1801.42725', series => 'C', number => '5', parent => 'C:5', title => 'Orkney Islands (North)', polygon => [[339000,1015000],[347800,1015000],[348200,1014650],[348700,1014650],[348720,1014900],[349100,1015000],[351700,1015000],[351900,1014700],[352200,1014500],[353200,1014800],[353600,1015000],[379000,1015000],[379000,1042950],[379100,1043000],[379350,1044000],[379400,1044350],[379000,1044800],[379000,1060000],[339000,1060000],[339000,1050400],[338700,1050200],[338800,1049800],[339000,1049400],[339000,1015000]] };
$maps{"C:6"} = { bbox => [[321000, 995000], [362375, 1041160]], area => '1808.4765', series => 'C', number => '6', parent => 'C:6', title => 'Orkney Islands (Kirkwall)', polygon => [[321000,995000],[361000,995000],[361000,1000000],[362375,1001800],[362375,1002900],[361500,1003200],[361000,1004000],[361000,1040000],[359300,1040000],[359000,1040450],[358000,1041000],[357100,1041160],[356900,1041160],[356000,1041000],[354700,1040000],[346000,1040000],[345000,1040800],[344600,1040830],[344400,1040830],[343750,1040600],[342850,1040000],[321000,1040000],[321000,995000]] };
$maps{"C:6.a"} = { bbox => [[261000, 1023000], [264000, 1025000]], area => '6', series => 'C', number => '6', parent => 'C:6', title => 'Orkney Islands (Kirkwall)', polygon => [[261000,1023000],[264000,1023000],[264000,1025000],[261000,1025000],[261000,1023000]] };
$maps{"C:6.b"} = { bbox => [[255000, 1017000], [258000, 1019000]], area => '6', series => 'C', number => '6', parent => 'C:6', title => 'Orkney Islands (Kirkwall)', polygon => [[255000,1017000],[258000,1017000],[258000,1019000],[255000,1019000],[255000,1017000]] };
$maps{"C:7"} = { bbox => [[309800, 961000], [351100, 1006000]], area => '1801.7344', series => 'C', number => '7', parent => 'C:7', title => 'Pentland Firth', polygon => [[310000,961000],[350000,961000],[350000,994400],[350330,995000],[350660,996000],[351100,996780],[350500,997000],[350000,997400],[350000,1006000],[310000,1006000],[310000,970400],[309850,970370],[309800,970000],[309820,969700],[310000,969100],[310000,961000]] };
$maps{"C:8"} = { bbox => [[116100, 925000], [158000, 970000]], area => '1808.5925', series => 'C', number => '8', parent => 'C:8', title => 'Isle of Lewis (Stornoway)', polygon => [[118000,925000],[158000,925000],[158000,970000],[118000,970000],[118000,945200],[117000,944700],[116100,943300],[116500,942000],[116600,941000],[116800,940000],[117300,939000],[118000,937850],[118000,925000]] };
$maps{"C:8.a"} = { bbox => [[159000, 1028000], [164000, 1033000]], area => '25', series => 'C', number => '8', parent => 'C:8', title => 'Isle of Lewis (Stornoway)', polygon => [[159000,1028000],[164000,1028000],[164000,1033000],[159000,1033000],[159000,1028000]] };
$maps{"C:8.b"} = { bbox => [[179000, 1030000], [184000, 1035000]], area => '25', series => 'C', number => '8', parent => 'C:8', title => 'Isle of Lewis (Stornoway)', polygon => [[179000,1030000],[184000,1030000],[184000,1035000],[179000,1035000],[179000,1030000]] };
$maps{"C:9"} = { bbox => [[210000, 935000], [250000, 980000]], area => '1800', series => 'C', number => '9', parent => 'C:9', title => 'Cape Wrath', polygon => [[210000,935000],[250000,935000],[250000,980000],[210000,980000],[210000,935000]] };
$maps{"C:10"} = { bbox => [[250000, 935000], [290000, 980000]], area => '1800', series => 'C', number => '10', parent => 'C:10', title => 'Tongue', polygon => [[250000,935000],[290000,935000],[290000,980000],[250000,980000],[250000,935000]] };
$maps{"C:11"} = { bbox => [[290000, 935000], [330000, 980000]], area => '1800', series => 'C', number => '11', parent => 'C:11', title => 'Thurso', polygon => [[290000,935000],[330000,935000],[330000,980000],[290000,980000],[290000,935000]] };
$maps{"C:12"} = { bbox => [[90000, 900000], [130000, 945000]], area => '1800', series => 'C', number => '12', parent => 'C:12', title => 'Isle of Lewis & North Harris', polygon => [[90000,900000],[130000,900000],[130000,945000],[90000,945000],[90000,900000]] };
$maps{"C:12.a"} = { bbox => [[67000, 944000], [76000, 948000]], area => '36', series => 'C', number => '12', parent => 'C:12', title => 'Isle of Lewis & North Harris', polygon => [[67000,944000],[76000,944000],[76000,948000],[67000,948000],[67000,944000]] };
$maps{"C:12.b"} = { bbox => [[86000, 910000], [90000, 913000]], area => '12', series => 'C', number => '12', parent => 'C:12', title => 'Isle of Lewis & North Harris', polygon => [[86000,910000],[90000,910000],[90000,913000],[86000,913000],[86000,910000]] };
$maps{"C:13"} = { bbox => [[194700, 900000], [235000, 945000]], area => '1800.305', series => 'C', number => '13', parent => 'C:13', title => 'Loch Inver & Loch Assynt', polygon => [[195000,900000],[235000,900000],[235000,945000],[195000,945000],[195000,910300],[194800,910000],[194700,909500],[194700,909300],[194800,909000],[195000,908850],[195000,900000]] };
$maps{"C:14"} = { bbox => [[235000, 900000], [275000, 945000]], area => '1800', series => 'C', number => '14', parent => 'C:14', title => 'Lairg', polygon => [[235000,900000],[275000,900000],[275000,945000],[235000,945000],[235000,900000]] };
$maps{"C:15"} = { bbox => [[265000, 900000], [305000, 945000]], area => '1800', series => 'C', number => '15', parent => 'C:15', title => 'Helmsdale', polygon => [[265000,900000],[305000,900000],[305000,945000],[265000,945000],[265000,900000]] };
$maps{"C:16"} = { bbox => [[300000, 916000], [340000, 961000]], area => '1800', series => 'C', number => '16', parent => 'C:16', title => 'Wick', polygon => [[300000,916000],[340000,916000],[340000,961000],[300000,961000],[300000,916000]] };
$maps{"C:17"} = { bbox => [[63800, 858000], [105000, 903920]], area => '1804.55625', series => 'C', number => '17', parent => 'C:17', title => 'North Uist', polygon => [[65000,858000],[105000,858000],[105000,903000],[104800,903000],[104500,903700],[104000,903920],[103000,903915],[102500,903900],[102000,903800],[101500,903600],[101000,903000],[65000,903000],[65000,868300],[64000,867600],[63800,867400],[63800,866800],[64800,866200],[65000,865800],[65000,858000]] };
$maps{"C:17.a"} = { bbox => [[5000, 896000], [17000, 907000]], area => '132', series => 'C', number => '17', parent => 'C:17', title => 'North Uist', polygon => [[5000,896000],[17000,896000],[17000,907000],[5000,907000],[5000,896000]] };
$maps{"C:17.b"} = { bbox => [[59000, 880000], [64000, 884000]], area => '20', series => 'C', number => '17', parent => 'C:17', title => 'North Uist', polygon => [[59000,880000],[64000,880000],[64000,884000],[59000,884000],[59000,880000]] };
$maps{"C:18"} = { bbox => [[105000, 880000], [145000, 925000]], area => '1800', series => 'C', number => '18', parent => 'C:18', title => 'Harris', polygon => [[105000,880000],[145000,880000],[145000,925000],[105000,925000],[105000,880000]] };
$maps{"C:19"} = { bbox => [[170000, 864850], [210000, 910000]], area => '1800.0445', series => 'C', number => '19', parent => 'C:19', title => 'Gairloch', polygon => [[170000,865000],[173000,865000],[173020,864900],[173100,864850],[173200,864870],[173500,865000],[210000,865000],[210000,910000],[170000,910000],[170000,865000]] };
$maps{"C:20"} = { bbox => [[194700, 865000], [235000, 910000]], area => '1800.275', series => 'C', number => '20', parent => 'C:20', title => 'Ullapool', polygon => [[195000,865000],[235000,865000],[235000,910000],[195000,910000],[194800,910000],[194700,909500],[194700,909300],[194800,909000],[195000,908850],[195000,865000]] };
$maps{"C:21"} = { bbox => [[235000, 865000], [275000, 910000]], area => '1800', series => 'C', number => '21', parent => 'C:21', title => 'Bonar-Bridge', polygon => [[235000,865000],[275000,865000],[275000,910000],[235000,910000],[235000,865000]] };
$maps{"C:22"} = { bbox => [[259750, 865000], [300000, 910000]], area => '1800.10375', series => 'C', number => '22', parent => 'C:22', title => 'Dornoch', polygon => [[260000,865000],[300000,865000],[300000,910000],[260000,910000],[260000,890700],[259900,890650],[259750,890500],[259800,890300],[260000,890000],[260000,865000]] };
$maps{"C:23"} = { bbox => [[55000, 820000], [95000, 865000]], area => '1800', series => 'C', number => '23', parent => 'C:23', title => 'South Uist', polygon => [[55000,820000],[95000,820000],[95000,865000],[55000,865000],[55000,820000]] };
$maps{"C:24"} = { bbox => [[112600, 835000], [153500, 880000]], area => '1802.11475', series => 'C', number => '24', parent => 'C:24', title => 'North Skye', polygon => [[113000,835000],[153000,835000],[153000,857600],[153100,857700],[153400,857900],[153400,858100],[153100,858400],[153000,858600],[153000,861100],[153300,862000],[153500,862900],[153500,863100],[153000,863400],[153000,880000],[113000,880000],[113000,851200],[112600,850900],[112600,850700],[113000,850400],[113000,849350],[112650,849000],[112600,848000],[112730,847700],[112600,846900],[112750,846300],[113000,846100],[113000,835000]] };
$maps{"C:25"} = { bbox => [[140000, 820000], [180000, 865000]], area => '1800', series => 'C', number => '25', parent => 'C:25', title => 'Portree', polygon => [[140000,820000],[180000,820000],[180000,865000],[140000,865000],[140000,820000]] };
$maps{"C:26"} = { bbox => [[175000, 820000], [215000, 865000]], area => '1800', series => 'C', number => '26', parent => 'C:26', title => 'Lochcarron', polygon => [[175000,820000],[215000,820000],[215000,865000],[175000,865000],[175000,820000]] };
$maps{"C:27"} = { bbox => [[215000, 820000], [255000, 865000]], area => '1800', series => 'C', number => '27', parent => 'C:27', title => 'Strathpeffer', polygon => [[215000,820000],[255000,820000],[255000,865000],[215000,865000],[215000,820000]] };
$maps{"C:28"} = { bbox => [[254900, 820000], [295000, 865000]], area => '1800.06', series => 'C', number => '28', parent => 'C:28', title => 'Inverness', polygon => [[255000,820000],[295000,820000],[295000,865000],[255000,865000],[255000,859400],[254950,859350],[254900,859300],[254900,858750],[255000,858750],[255000,820000]] };
$maps{"C:29"} = { bbox => [[295000, 830000], [335000, 875000]], area => '1800', series => 'C', number => '29', parent => 'C:29', title => 'Elgin', polygon => [[295000,830000],[335000,830000],[335000,875000],[295000,875000],[295000,830000]] };
$maps{"C:30"} = { bbox => [[335000, 830000], [375000, 875000]], area => '1800', series => 'C', number => '30', parent => 'C:30', title => 'Banff', polygon => [[335000,830000],[375000,830000],[375000,875000],[335000,875000],[335000,830000]] };
$maps{"C:31"} = { bbox => [[375000, 829600], [415000, 875000]], area => '1800.3425', series => 'C', number => '31', parent => 'C:31', title => 'Peterhead', polygon => [[375000,830000],[404400,830000],[404950,829600],[405150,829600],[405500,829700],[405700,830000],[415000,830000],[415000,875000],[375000,875000],[375000,830000]] };
$maps{"C:32"} = { bbox => [[50000, 775000], [90000, 820000]], area => '1800', series => 'C', number => '32', parent => 'C:32', title => 'Barra', polygon => [[50000,775000],[90000,775000],[90000,820000],[50000,820000],[50000,775000]] };
$maps{"C:33"} = { bbox => [[113000, 790000], [153000, 835000]], area => '1800', series => 'C', number => '33', parent => 'C:33', title => 'Rhum and part of Skye', polygon => [[113000,790000],[153000,790000],[153000,835000],[113000,835000],[113000,790000]] };
$maps{"C:34"} = { bbox => [[135000, 775000], [175000, 820000]], area => '1800', series => 'C', number => '34', parent => 'C:34', title => 'South Skye & Arisaig', polygon => [[135000,775000],[175000,775000],[175000,820000],[135000,820000],[135000,775000]] };
$maps{"C:35"} = { bbox => [[175000, 775000], [215000, 820000]], area => '1800', series => 'C', number => '35', parent => 'C:35', title => 'Loch Arkaig', polygon => [[175000,775000],[215000,775000],[215000,820000],[175000,820000],[175000,775000]] };
$maps{"C:36"} = { bbox => [[215000, 775000], [255000, 820000]], area => '1800', series => 'C', number => '36', parent => 'C:36', title => 'Fort Augustus', polygon => [[215000,775000],[255000,775000],[255000,820000],[215000,820000],[215000,775000]] };
$maps{"C:37"} = { bbox => [[255000, 775000], [295000, 820000]], area => '1800', series => 'C', number => '37', parent => 'C:37', title => 'Kingussie', polygon => [[255000,775000],[295000,775000],[295000,820000],[255000,820000],[255000,775000]] };
$maps{"C:38"} = { bbox => [[295000, 790000], [335000, 835000]], area => '1800', series => 'C', number => '38', parent => 'C:38', title => 'Grantown and Cairngorm', polygon => [[295000,790000],[335000,790000],[335000,835000],[295000,835000],[295000,790000]] };
$maps{"C:39"} = { bbox => [[325000, 790000], [365000, 835000]], area => '1800', series => 'C', number => '39', parent => 'C:39', title => 'Strathdon', polygon => [[325000,790000],[365000,790000],[365000,835000],[325000,835000],[325000,790000]] };
$maps{"C:40"} = { bbox => [[365000, 790000], [405000, 835000]], area => '1800', series => 'C', number => '40', parent => 'C:40', title => 'Aberdeen', polygon => [[365000,790000],[405000,790000],[405000,835000],[365000,835000],[365000,790000]] };
$maps{"C:41"} = { bbox => [[295000, 770000], [335000, 815000]], area => '1800', series => 'C', number => '41', parent => 'C:41', title => 'Braemar', polygon => [[295000,770000],[335000,770000],[335000,815000],[295000,815000],[295000,770000]] };
$maps{"C:42"} = { bbox => [[325000, 770000], [365000, 815000]], area => '1800', series => 'C', number => '42', parent => 'C:42', title => 'Ballater', polygon => [[325000,770000],[365000,770000],[365000,815000],[325000,815000],[325000,770000]] };
$maps{"C:43"} = { bbox => [[355000, 750000], [395000, 795000]], area => '1800', series => 'C', number => '43', parent => 'C:43', title => 'Stonehaven', polygon => [[355000,750000],[395000,750000],[395000,795000],[355000,795000],[355000,750000]] };
$maps{"C:44"} = { bbox => [[89500, 730000], [133600, 775000]], area => '1834.21', series => 'C', number => '44', parent => 'C:44', title => 'Coll & Tiree', polygon => [[93000,730000],[133000,730000],[133000,734300],[133500,734900],[133600,735200],[133600,735400],[133400,735800],[133000,736250],[133000,775000],[93000,775000],[93000,750000],[90000,750000],[90000,749000],[89600,748500],[89500,748300],[89500,748200],[89600,748000],[89900,747400],[90000,747300],[90000,739000],[93000,739000],[93000,730000]] };
$maps{"C:45"} = { bbox => [[132800, 730000], [173000, 775000]], area => '1800.232', series => 'C', number => '45', parent => 'C:45', title => 'Sound of Mull', polygon => [[133000,730000],[173000,730000],[173000,775000],[133000,775000],[133000,747900],[132800,747300],[132800,746800],[133000,746080],[133000,730000]] };
$maps{"C:46"} = { bbox => [[173000, 730000], [213000, 775000]], area => '1800', series => 'C', number => '46', parent => 'C:46', title => 'Loch Linnhe', polygon => [[173000,730000],[213000,730000],[213000,775000],[173000,775000],[173000,730000]] };
$maps{"C:47"} = { bbox => [[213000, 730000], [253000, 775000]], area => '1800', series => 'C', number => '47', parent => 'C:47', title => 'Glen Coe', polygon => [[213000,730000],[253000,730000],[253000,775000],[213000,775000],[213000,730000]] };
$maps{"C:48"} = { bbox => [[253000, 730000], [293000, 775000]], area => '1800', series => 'C', number => '48', parent => 'C:48', title => 'Loch Tay', polygon => [[253000,730000],[293000,730000],[293000,775000],[253000,775000],[253000,730000]] };
$maps{"C:49"} = { bbox => [[293000, 730000], [333000, 775000]], area => '1800', series => 'C', number => '49', parent => 'C:49', title => 'Blairgowrie', polygon => [[293000,730000],[333000,730000],[333000,775000],[293000,775000],[293000,730000]] };
$maps{"C:50"} = { bbox => [[333000, 725000], [373750, 770000]], area => '1801.508', series => 'C', number => '50', parent => 'C:50', title => 'Forfar', polygon => [[333000,725000],[373000,725000],[373000,754500],[373300,754900],[373500,755625],[373750,756300],[373700,756750],[373500,757155],[373250,757500],[373000,757800],[373000,770000],[333000,770000],[333000,725000]] };
$maps{"C:51"} = { bbox => [[122900, 685000], [165000, 730000]], area => '1816.630225', series => 'C', number => '51', parent => 'C:51', title => 'Iona & Colonsay', polygon => [[125000,685000],[165000,685000],[165000,730000],[125000,730000],[125000,727665],[124750,727280],[123385,726500],[123100,726200],[123100,725900],[123200,725700],[123500,725500],[123900,725500],[124100,725200],[124100,723200],[123500,722000],[123250,721000],[123200,720000],[122900,719400],[122900,718900],[123200,718500],[124000,718350],[124700,718000],[124900,717900],[125000,717500],[125000,715900],[124800,715500],[124000,715000],[123000,714500],[123000,713900],[124000,713300],[124500,713000],[124800,712500],[125000,712000],[125000,685000]] };
$maps{"C:52"} = { bbox => [[165000, 685000], [205000, 730000]], area => '1800', series => 'C', number => '52', parent => 'C:52', title => 'Loch Awe', polygon => [[165000,685000],[205000,685000],[205000,730000],[165000,730000],[165000,685000]] };
$maps{"C:53"} = { bbox => [[205000, 685000], [245000, 730000]], area => '1800', series => 'C', number => '53', parent => 'C:53', title => 'Loch Lomond', polygon => [[205000,685000],[245000,685000],[245000,730000],[205000,730000],[205000,685000]] };
$maps{"C:54"} = { bbox => [[245000, 685000], [285000, 730120]], area => '1800.051', series => 'C', number => '54', parent => 'C:54', title => 'Stirling', polygon => [[245000,685000],[285000,685000],[285000,730000],[255100,730000],[254950,730080],[254800,730120],[254700,730080],[254500,730080],[254400,730000],[245000,730000],[245000,685000]] };
$maps{"C:55"} = { bbox => [[285000, 685000], [325000, 730000]], area => '1800', series => 'C', number => '55', parent => 'C:55', title => 'Perth & Alloa', polygon => [[285000,685000],[325000,685000],[325000,730000],[285000,730000],[285000,685000]] };
$maps{"C:56"} = { bbox => [[325000, 684500], [367000, 730350]], area => '1804.718', series => 'C', number => '56', parent => 'C:56', title => 'St Andrews and Kirkcaldy', polygon => [[325000,685000],[354800,685000],[354800,684900],[355600,684525],[356000,684500],[356200,684500],[357000,684750],[357500,685000],[365000,685000],[365000,698250],[366000,698330],[366500,698500],[367000,699000],[367000,699500],[366800,700000],[366000,700300],[365500,700400],[365000,700400],[365000,730000],[340500,730000],[340500,730180],[340300,730350],[339500,730130],[339300,730000],[325000,730000],[325000,685000]] };
$maps{"C:57"} = { bbox => [[114300, 639700], [155000, 685000]], area => '1800.6925', series => 'C', number => '57', parent => 'C:57', title => 'Islay', polygon => [[115000,640000],[130500,640000],[131250,639700],[131400,639700],[132000,640000],[155000,640000],[155000,685000],[115000,685000],[115000,654400],[114500,654400],[114300,654100],[114500,653700],[115000,653600],[115000,640000]] };
$maps{"C:58"} = { bbox => [[155000, 640000], [195000, 685000]], area => '1800', series => 'C', number => '58', parent => 'C:58', title => 'Knapdale', polygon => [[155000,640000],[195000,640000],[195000,685000],[155000,685000],[155000,640000]] };
$maps{"C:59"} = { bbox => [[195000, 640000], [235000, 685000]], area => '1800', series => 'C', number => '59', parent => 'C:59', title => 'Firth of Clyde', polygon => [[195000,640000],[235000,640000],[235000,685000],[195000,685000],[195000,640000]] };
$maps{"C:60"} = { bbox => [[230000, 640000], [270000, 685000]], area => '1800', series => 'C', number => '60', parent => 'C:60', title => 'Glasgow', polygon => [[230000,640000],[270000,640000],[270000,685000],[230000,685000],[230000,640000]] };
$maps{"C:61"} = { bbox => [[270000, 640000], [310000, 685000]], area => '1800', series => 'C', number => '61', parent => 'C:61', title => 'Falkirk & Lanark', polygon => [[270000,640000],[310000,640000],[310000,685000],[270000,685000],[270000,640000]] };
$maps{"C:62"} = { bbox => [[310000, 640000], [350000, 686265]], area => '1801.893675', series => 'C', number => '62', parent => 'C:62', title => 'Edinburgh', polygon => [[310000,640000],[350000,640000],[350000,686265],[349000,686265],[348710,686000],[348500,685550],[348000,685000],[310000,685000],[310000,640000]] };
$maps{"C:63"} = { bbox => [[350000, 640000], [390000, 685500]], area => '1801.19975', series => 'C', number => '63', parent => 'C:63', title => 'Dunbar', polygon => [[350000,640000],[390000,640000],[390000,685000],[359050,685000],[359000,685050],[358400,685240],[358060,685200],[358000,685240],[357700,685200],[357100,685000],[356000,685000],[355600,685400],[355450,685500],[354400,685500],[353500,685000],[350000,685000],[350000,640000]] };
$maps{"C:64"} = { bbox => [[375000, 630000], [415000, 675000]], area => '1800', series => 'C', number => '64', parent => 'C:64', title => 'Berwick-upon-Tweed', polygon => [[375000,630000],[415000,630000],[415000,675000],[375000,675000],[375000,630000]] };
$maps{"C:65"} = { bbox => [[155000, 600000], [195000, 645000]], area => '1800', series => 'C', number => '65', parent => 'C:65', title => 'Kintyre', polygon => [[155000,600000],[195000,600000],[195000,645000],[155000,645000],[155000,600000]] };
$maps{"C:66"} = { bbox => [[180000, 615000], [220000, 660000]], area => '1800', series => 'C', number => '66', parent => 'C:66', title => 'Island of Arran', polygon => [[180000,615000],[220000,615000],[220000,660000],[180000,660000],[180000,615000]] };
$maps{"C:67"} = { bbox => [[227080, 595000], [270000, 640000]], area => '1809.4892375', series => 'C', number => '67', parent => 'C:67', title => 'Ayr', polygon => [[230000,595000],[270000,595000],[270000,640000],[227200,640000],[228000,639400],[228840,638900],[229260,638000],[229375,637710],[230000,637105],[230000,631500],[229900,631300],[229600,631000],[229000,630745],[228000,630495],[227300,630000],[227080,629500],[227100,629000],[227200,628700],[227500,628500],[228000,628525],[229000,628595],[229300,628595],[229800,628360],[230000,628100],[230000,595000]] };
$maps{"C:68"} = { bbox => [[270000, 595000], [310000, 640000]], area => '1800', series => 'C', number => '68', parent => 'C:68', title => 'Biggar', polygon => [[270000,595000],[310000,595000],[310000,640000],[270000,640000],[270000,595000]] };
$maps{"C:69"} = { bbox => [[310000, 595000], [350000, 640000]], area => '1800', series => 'C', number => '69', parent => 'C:69', title => 'Selkirk', polygon => [[310000,595000],[350000,595000],[350000,640000],[310000,640000],[310000,595000]] };
$maps{"C:70"} = { bbox => [[349850, 595000], [390000, 640000]], area => '1800.2675', series => 'C', number => '70', parent => 'C:70', title => 'Jedburgh', polygon => [[350000,595000],[390000,595000],[390000,640000],[350000,640000],[350000,615150],[349900,615100],[349850,615000],[349850,613420],[349900,613300],[350000,613290],[350000,595000]] };
$maps{"C:71"} = { bbox => [[390000, 595000], [430000, 640000]], area => '1800', series => 'C', number => '71', parent => 'C:71', title => 'Alnwick', polygon => [[390000,595000],[430000,595000],[430000,640000],[390000,640000],[390000,595000]] };
$maps{"C:72"} = { bbox => [[195000, 575000], [235000, 620000]], area => '1800', series => 'C', number => '72', parent => 'C:72', title => 'Girvan', polygon => [[195000,575000],[235000,575000],[235000,620000],[195000,620000],[195000,575000]] };
$maps{"C:73"} = { bbox => [[230000, 550000], [270000, 595000]], area => '1800', series => 'C', number => '73', parent => 'C:73', title => 'New Galloway', polygon => [[230000,550000],[270000,550000],[270000,595000],[230000,595000],[230000,550000]] };
$maps{"C:74"} = { bbox => [[270000, 550000], [310000, 595000]], area => '1800', series => 'C', number => '74', parent => 'C:74', title => 'Dumfries', polygon => [[270000,550000],[310000,550000],[310000,595000],[270000,595000],[270000,550000]] };
$maps{"C:75"} = { bbox => [[293000, 550000], [333000, 595000]], area => '1800', series => 'C', number => '75', parent => 'C:75', title => 'Dumfries & Gretna', polygon => [[293000,550000],[333000,550000],[333000,595000],[293000,595000],[293000,550000]] };
$maps{"C:76"} = { bbox => [[333000, 550000], [373000, 595000]], area => '1800', series => 'C', number => '76', parent => 'C:76', title => 'Carlisle', polygon => [[333000,550000],[373000,550000],[373000,595000],[333000,595000],[333000,550000]] };
$maps{"C:77"} = { bbox => [[373000, 550000], [413000, 595000]], area => '1800', series => 'C', number => '77', parent => 'C:77', title => 'Hexham', polygon => [[373000,550000],[413000,550000],[413000,595000],[373000,595000],[373000,550000]] };
$maps{"C:78"} = { bbox => [[403000, 550000], [443000, 595000]], area => '1800', series => 'C', number => '78', parent => 'C:78', title => 'Newcastle upon Tyne', polygon => [[403000,550000],[443000,550000],[443000,595000],[403000,595000],[403000,550000]] };
$maps{"C:79"} = { bbox => [[195000, 530000], [235000, 575000]], area => '1800', series => 'C', number => '79', parent => 'C:79', title => 'Stranraer', polygon => [[195000,530000],[235000,530000],[235000,575000],[195000,575000],[195000,530000]] };
$maps{"C:80"} = { bbox => [[230000, 530000], [270000, 575000]], area => '1800', series => 'C', number => '80', parent => 'C:80', title => 'Kirkcudbright', polygon => [[230000,530000],[270000,530000],[270000,575000],[230000,575000],[230000,530000]] };
$maps{"C:81"} = { bbox => [[270000, 530000], [310000, 575000]], area => '1800', series => 'C', number => '81', parent => 'C:81', title => 'Dalbeattie', polygon => [[270000,530000],[310000,530000],[310000,575000],[270000,575000],[270000,530000]] };
$maps{"C:82"} = { bbox => [[293000, 505000], [333000, 550000]], area => '1800', series => 'C', number => '82', parent => 'C:82', title => 'Keswick', polygon => [[293000,505000],[333000,505000],[333000,550000],[293000,550000],[293000,505000]] };
$maps{"C:83"} = { bbox => [[333000, 505000], [373000, 550000]], area => '1800', series => 'C', number => '83', parent => 'C:83', title => 'Penrith', polygon => [[333000,505000],[373000,505000],[373000,550000],[333000,550000],[333000,505000]] };
$maps{"C:84"} = { bbox => [[373000, 505000], [413000, 550000]], area => '1800', series => 'C', number => '84', parent => 'C:84', title => 'Teesdale', polygon => [[373000,505000],[413000,505000],[413000,550000],[373000,550000],[373000,505000]] };
$maps{"C:85"} = { bbox => [[413000, 505000], [453550, 550000]], area => '1800.736125', series => 'C', number => '85', parent => 'C:85', title => 'Durham', polygon => [[413000,505000],[453000,505000],[453000,531150],[453300,531450],[453315,531550],[453000,532000],[453000,532900],[453200,533100],[453445,533100],[453550,533200],[453550,533300],[453440,533750],[453440,534000],[453000,534600],[453000,550000],[413000,550000],[413000,505000]] };
$maps{"C:86"} = { bbox => [[453000, 485000], [493100, 530000]], area => '1800.072', series => 'C', number => '86', parent => 'C:86', title => 'Redcar & Whitby', polygon => [[453000,485000],[493000,485000],[493000,506200],[493100,506450],[493080,506800],[493070,507150],[493000,507200],[493000,530000],[453000,530000],[453000,485000]] };
$maps{"C:87"} = { bbox => [[212000, 462000], [252000, 507000]], area => '1800', series => 'C', number => '87', parent => 'C:87', title => 'Isle of Man', polygon => [[212000,462000],[252000,462000],[252000,507000],[212000,507000],[212000,462000]] };
$maps{"C:88"} = { bbox => [[300000, 460000], [340000, 505000]], area => '1800', series => 'C', number => '88', parent => 'C:88', title => 'Barrow in Furness', polygon => [[300000,460000],[340000,460000],[340000,505000],[300000,505000],[300000,460000]] };
$maps{"C:89"} = { bbox => [[330000, 460000], [370000, 505000]], area => '1800', series => 'C', number => '89', parent => 'C:89', title => 'Lancaster and Kendal', polygon => [[330000,460000],[370000,460000],[370000,505000],[330000,505000],[330000,460000]] };
$maps{"C:90"} = { bbox => [[370000, 460000], [410000, 505000]], area => '1800', series => 'C', number => '90', parent => 'C:90', title => 'Wensleydale', polygon => [[370000,460000],[410000,460000],[410000,505000],[370000,505000],[370000,460000]] };
$maps{"C:91"} = { bbox => [[410000, 460000], [450000, 505000]], area => '1800', series => 'C', number => '91', parent => 'C:91', title => 'Ripon', polygon => [[410000,460000],[450000,460000],[450000,505000],[410000,505000],[410000,460000]] };
$maps{"C:92"} = { bbox => [[450000, 460000], [490000, 505000]], area => '1800', series => 'C', number => '92', parent => 'C:92', title => 'Pickering', polygon => [[450000,460000],[490000,460000],[490000,505000],[450000,505000],[450000,460000]] };
$maps{"C:93"} = { bbox => [[487000, 465000], [527000, 510000]], area => '1800', series => 'C', number => '93', parent => 'C:93', title => 'Scarborough', polygon => [[487000,465000],[527000,465000],[527000,510000],[487000,510000],[487000,465000]] };
$maps{"C:94"} = { bbox => [[329050, 420000], [370000, 465000]], area => '1805.058125', series => 'C', number => '94', parent => 'C:94', title => 'Preston', polygon => [[330000,420000],[370000,420000],[370000,465000],[330000,465000],[330000,438100],[329075,431125],[329050,431000],[329250,430000],[329300,429300],[329500,428850],[330000,428500],[330000,420000]] };
$maps{"C:95"} = { bbox => [[360000, 415000], [400000, 460000]], area => '1800', series => 'C', number => '95', parent => 'C:95', title => 'Blackburn & Burnley', polygon => [[360000,415000],[400000,415000],[400000,460000],[360000,460000],[360000,415000]] };
$maps{"C:96"} = { bbox => [[400000, 415000], [440000, 460550]], area => '1801.017001', series => 'C', number => '96', parent => 'C:96', title => 'Leeds & Bradford', polygon => [[400000,415000],[440000,415000],[440000,460000],[424595,460000],[424475,460065],[424330,460105],[424120,460290],[423790,460450],[423200,460550],[422789,460526],[422171,460131],[422184,460210],[422157,460263],[422000,460223],[421500,460080],[421500,460000],[400000,460000],[400000,415000]] };
$maps{"C:97"} = { bbox => [[440000, 419860], [480000, 465000]], area => '1800.112', series => 'C', number => '97', parent => 'C:97', title => 'York', polygon => [[440000,420000],[442000,420000],[443000,419860],[443100,419860],[443500,420000],[480000,420000],[480000,465000],[440000,465000],[440000,420000]] };
$maps{"C:98"} = { bbox => [[460000, 420000], [500000, 465000]], area => '1800', series => 'C', number => '98', parent => 'C:98', title => 'Market Weighton', polygon => [[460000,420000],[500000,420000],[500000,465000],[460000,465000],[460000,420000]] };
$maps{"C:99"} = { bbox => [[500000, 420000], [540500, 465000]], area => '1800.2125', series => 'C', number => '99', parent => 'C:99', title => 'Hull', polygon => [[500000,420000],[540000,420000],[540500,420025],[540000,420850],[540000,465000],[500000,465000],[500000,420000]] };
$maps{"C:100"} = { bbox => [[318230, 375000], [360000, 420000]], area => '1807.0733', series => 'C', number => '100', parent => 'C:100', title => 'Liverpool', polygon => [[320000,375000],[360000,375000],[360000,420000],[320000,420000],[320000,392050],[319510,391800],[319250,391000],[319150,390000],[319000,389300],[318760,388800],[318300,388500],[318230,388290],[318230,387620],[318260,387080],[319100,386000],[320000,385680],[320000,375000]] };
$maps{"C:101"} = { bbox => [[360000, 375000], [400000, 420000]], area => '1800', series => 'C', number => '101', parent => 'C:101', title => 'Manchester', polygon => [[360000,375000],[400000,375000],[400000,420000],[360000,420000],[360000,375000]] };
$maps{"C:102"} = { bbox => [[400000, 385000], [440000, 430000]], area => '1800', series => 'C', number => '102', parent => 'C:102', title => 'Huddersfield', polygon => [[400000,385000],[440000,385000],[440000,430000],[400000,430000],[400000,385000]] };
$maps{"C:103"} = { bbox => [[434860, 375000], [475000, 420200]], area => '1800.48125', series => 'C', number => '103', parent => 'C:103', title => 'Doncaster', polygon => [[435000,375000],[475000,375000],[475000,420000],[442650,420000],[442650,420050],[442500,420100],[442000,420200],[441200,420200],[441000,420180],[440900,420150],[440050,420150],[440030,420000],[435000,420000],[435000,380000],[434950,379500],[434860,379200],[435000,379050],[435000,375000]] };
$maps{"C:104"} = { bbox => [[475000, 374860], [515000, 420000]], area => '1800.118', series => 'C', number => '104', parent => 'C:104', title => 'Gainsborough', polygon => [[475000,375000],[490400,375000],[490600,374950],[490900,374950],[491700,374860],[491950,374970],[492000,375000],[515000,375000],[515000,420000],[475000,420000],[475000,375000]] };
$maps{"C:105"} = { bbox => [[515000, 375000], [556000, 420000]], area => '1801.504', series => 'C', number => '105', parent => 'C:105', title => 'Grimsby', polygon => [[515000,375000],[556000,375000],[555790,375685],[555800,375900],[555000,377700],[555000,420000],[515000,420000],[515000,375000]] };
$maps{"C:106"} = { bbox => [[219765, 353000], [261290, 398000]], area => '1804.804125', series => 'C', number => '106', parent => 'C:106', title => 'Anglesey', polygon => [[221000,353000],[261000,353000],[261000,376500],[261130,377000],[261130,377200],[261290,377650],[261290,379800],[261200,380000],[261000,380080],[261000,398000],[221000,398000],[221000,384200],[220710,384000],[220315,383500],[219870,383000],[219765,382800],[219765,382450],[220130,381500],[220315,380800],[220315,380000],[220400,379500],[220660,379300],[221000,378900],[221000,353000]] };
$maps{"C:106.a"} = { bbox => [[261000, 376000], [266300, 383000]], area => '35.18', series => 'C', number => '106', parent => 'C:106', title => 'Anglesey', polygon => [[261000,376000],[266000,376000],[266000,378100],[266300,378300],[266000,379300],[266000,383000],[261000,383000],[261000,376000]] };
$maps{"C:107"} = { bbox => [[247920, 339890], [288000, 385000]], area => '1800.049325', series => 'C', number => '107', parent => 'C:107', title => 'Snowdon', polygon => [[248000,340000],[263920,340000],[264040,339900],[264145,339920],[264265,339890],[264310,340000],[288000,340000],[288000,385000],[248000,385000],[248000,345100],[247920,345000],[248000,344600],[248000,340000]] };
$maps{"C:108"} = { bbox => [[288000, 340000], [328000, 386000]], area => '1804.2511', series => 'C', number => '108', parent => 'C:108', title => 'Denbigh', polygon => [[288000,340000],[328000,340000],[328000,385000],[315000,385000],[314385,385615],[313000,385820],[311500,386000],[310000,385615],[308400,385000],[288000,385000],[288000,340000]] };
$maps{"C:109"} = { bbox => [[318230, 345000], [360000, 390000]], area => '1805.71605', series => 'C', number => '109', parent => 'C:109', title => 'Chester', polygon => [[320000,345000],[360000,345000],[360000,390000],[319150,390000],[319000,389300],[318760,388800],[318300,388500],[318230,388290],[318230,387620],[318260,387080],[319100,386000],[320000,385680],[320000,345000]] };
$maps{"C:110"} = { bbox => [[359900, 330000], [400000, 375000]], area => '1800.0355', series => 'C', number => '110', parent => 'C:110', title => 'Stoke on Trent', polygon => [[360000,330000],[400000,330000],[400000,375000],[360000,375000],[360000,343600],[359950,343450],[359900,343080],[360000,343000],[360000,330000]] };
$maps{"C:111"} = { bbox => [[400000, 344900], [440000, 390000]], area => '1800.0333', series => 'C', number => '111', parent => 'C:111', title => 'Buxton & Matlock', polygon => [[400000,345000],[430600,345000],[430800,344920],[431000,344950],[431100,344920],[431120,344900],[431200,345000],[440000,345000],[440000,390000],[400000,390000],[400000,345000]] };
$maps{"C:112"} = { bbox => [[439700, 330000], [480000, 375000]], area => '1800.36625', series => 'C', number => '112', parent => 'C:112', title => 'Nottingham', polygon => [[440000,330000],[480000,330000],[480000,375000],[440000,375000],[440000,351100],[439740,351000],[439700,350800],[439750,350250],[439830,350000],[440000,348900],[440000,330000]] };
$maps{"C:113"} = { bbox => [[480000, 330000], [520000, 375265]], area => '1800.3926725', series => 'C', number => '113', parent => 'C:113', title => 'Lincoln & Grantham', polygon => [[480000,330000],[520000,330000],[520000,375000],[492000,375000],[491900,375100],[491870,375100],[491820,375000],[491100,375000],[490800,375100],[489920,375210],[489919,375265],[489300,375265],[489100,375200],[488900,375000],[480000,375000],[480000,330000]] };
$maps{"C:114"} = { bbox => [[520000, 330000], [560000, 375000]], area => '1800', series => 'C', number => '114', parent => 'C:114', title => 'Boston & Skegness', polygon => [[520000,330000],[560000,330000],[560000,375000],[520000,375000],[520000,330000]] };
$maps{"C:115"} = { bbox => [[210000, 320000], [250000, 365000]], area => '1800', series => 'C', number => '115', parent => 'C:115', title => 'Pwllheli', polygon => [[210000,320000],[250000,320000],[250000,365000],[210000,365000],[210000,320000]] };
$maps{"C:116"} = { bbox => [[247950, 308000], [288000, 353000]], area => '1800.0135', series => 'C', number => '116', parent => 'C:116', title => 'Dolgellau', polygon => [[248000,308000],[288000,308000],[288000,353000],[248000,353000],[248000,345100],[247950,345050],[247950,344960],[248000,344650],[248000,308000]] };
$maps{"C:117"} = { bbox => [[288000, 300000], [328000, 345000]], area => '1800', series => 'C', number => '117', parent => 'C:117', title => 'Bala & Welshpool', polygon => [[288000,300000],[328000,300000],[328000,345000],[288000,345000],[288000,300000]] };
$maps{"C:118"} = { bbox => [[328000, 299630], [368140, 345000]], area => '1801.22981', series => 'C', number => '118', parent => 'C:118', title => 'Shrewsbury', polygon => [[328000,300000],[361500,300000],[361600,299800],[361800,299700],[362000,299630],[364500,299630],[365400,300000],[368000,300000],[368000,303240],[368120,303240],[368140,303320],[368000,303333],[368000,345000],[328000,345000],[328000,300000]] };
$maps{"C:119"} = { bbox => [[359900, 299630], [400080, 345000]], area => '1801.31495', series => 'C', number => '119', parent => 'C:119', title => 'Stafford', polygon => [[360000,300000],[361500,300000],[361600,299800],[361800,299700],[362000,299630],[364500,299630],[365400,300000],[400000,300000],[400000,323100],[400050,323200],[400080,323820],[400030,323940],[400030,324300],[400000,324350],[400000,345000],[360000,345000],[360000,343600],[359950,343450],[359900,343080],[360000,343000],[360000,300000]] };
$maps{"C:120"} = { bbox => [[399570, 300000], [440000, 345000]], area => '1800.49935', series => 'C', number => '120', parent => 'C:120', title => 'Burton upon Trent', polygon => [[400000,300000],[440000,300000],[440000,345000],[400000,345000],[400000,323200],[399600,323040],[399570,322870],[399750,322000],[399830,321600],[400000,321400],[400000,300000]] };
$maps{"C:121"} = { bbox => [[428000, 300000], [468000, 345000]], area => '1800', series => 'C', number => '121', parent => 'C:121', title => 'Derby & Leicester', polygon => [[428000,300000],[468000,300000],[468000,345000],[428000,345000],[428000,300000]] };
$maps{"C:122"} = { bbox => [[454220, 299500], [495000, 345000]], area => '1803.37385', series => 'C', number => '122', parent => 'C:122', title => 'Melton Mowbray', polygon => [[455000,300000],[486000,300000],[485790,299500],[487000,299500],[487500,300000],[495000,300000],[495000,345000],[455000,345000],[455000,342900],[454920,342900],[454315,342000],[454315,340500],[454220,340400],[454235,340000],[454340,339600],[454395,339000],[454500,338660],[455000,338300],[455000,300000]] };
$maps{"C:123"} = { bbox => [[495000, 300000], [535000, 345000]], area => '1800', series => 'C', number => '123', parent => 'C:123', title => 'Spalding', polygon => [[495000,300000],[535000,300000],[535000,345000],[495000,345000],[495000,300000]] };
$maps{"C:124"} = { bbox => [[535000, 300000], [575000, 346000]], area => '1803.9726625', series => 'C', number => '124', parent => 'C:124', title => 'Kings Lynn', polygon => [[535000,300000],[575000,300000],[575000,345500],[574420,345630],[573895,345950],[573550,345920],[573475,345975],[573000,345870],[572000,345850],[570800,345765],[570765,346000],[570700,345800],[569500,345000],[535000,345000],[535000,300000]] };
$maps{"C:125"} = { bbox => [[575000, 302000], [615000, 347710]], area => '1804.22945', series => 'C', number => '125', parent => 'C:125', title => 'Fakenham', polygon => [[575000,302000],[615000,302000],[615000,347000],[600700,347000],[600000,347250],[599300,347263],[598200,347080],[597700,347000],[595500,347265],[594500,347370],[591400,347710],[590900,347710],[590500,347690],[589500,347395],[588800,347000],[581200,347000],[580400,347100],[579600,347100],[578900,347000],[575000,347000],[575000,302000]] };
$maps{"C:126"} = { bbox => [[615000, 302000], [655000, 347000]], area => '1800', series => 'C', number => '126', parent => 'C:126', title => 'Norwich', polygon => [[615000,302000],[655000,302000],[655000,347000],[615000,347000],[615000,302000]] };
$maps{"C:127"} = { bbox => [[248000, 263000], [288000, 308000]], area => '1800', series => 'C', number => '127', parent => 'C:127', title => 'Aberystwyth', polygon => [[248000,263000],[288000,263000],[288000,308000],[248000,308000],[248000,263000]] };
$maps{"C:128"} = { bbox => [[288000, 255000], [328000, 300000]], area => '1800', series => 'C', number => '128', parent => 'C:128', title => 'Montgomery and Llandrindod Wells', polygon => [[288000,255000],[328000,255000],[328000,300000],[288000,300000],[288000,255000]] };
$maps{"C:129"} = { bbox => [[328000, 255000], [368000, 300240]], area => '1800.1134', series => 'C', number => '129', parent => 'C:129', title => 'Ludlow', polygon => [[328000,255000],[368000,255000],[368000,300000],[362580,300000],[362580,300240],[362265,300240],[361950,300000],[328000,300000],[328000,255000]] };
$maps{"C:130"} = { bbox => [[360000, 255000], [400000, 300240]], area => '1800.1134', series => 'C', number => '130', parent => 'C:130', title => 'Kidderminster', polygon => [[360000,255000],[400000,255000],[400000,300000],[362580,300000],[362580,300240],[362265,300240],[361950,300000],[360000,300000],[360000,255000]] };
$maps{"C:131"} = { bbox => [[388000, 255000], [428000, 300000]], area => '1800', series => 'C', number => '131', parent => 'C:131', title => 'Birmingham', polygon => [[388000,255000],[428000,255000],[428000,300000],[388000,300000],[388000,255000]] };
$maps{"C:132"} = { bbox => [[428000, 255000], [468000, 300000]], area => '1800', series => 'C', number => '132', parent => 'C:132', title => 'Coventry & Rugby', polygon => [[428000,255000],[468000,255000],[468000,300000],[428000,300000],[428000,255000]] };
$maps{"C:133"} = { bbox => [[455000, 255000], [495000, 300000]], area => '1800', series => 'C', number => '133', parent => 'C:133', title => 'Northampton', polygon => [[455000,255000],[495000,255000],[495000,300000],[455000,300000],[455000,255000]] };
$maps{"C:134"} = { bbox => [[495000, 255000], [535000, 300000]], area => '1800', series => 'C', number => '134', parent => 'C:134', title => 'Huntingdon & Peterborough', polygon => [[495000,255000],[535000,255000],[535000,300000],[495000,300000],[495000,255000]] };
$maps{"C:135"} = { bbox => [[535000, 255000], [575000, 300000]], area => '1800', series => 'C', number => '135', parent => 'C:135', title => 'Cambridge & Ely', polygon => [[535000,255000],[575000,255000],[575000,300000],[535000,300000],[535000,255000]] };
$maps{"C:136"} = { bbox => [[575000, 257000], [615000, 302000]], area => '1800', series => 'C', number => '136', parent => 'C:136', title => 'Bury St Edmunds', polygon => [[575000,257000],[615000,257000],[615000,302000],[575000,302000],[575000,257000]] };
$maps{"C:137"} = { bbox => [[615000, 257000], [656240, 302000]], area => '1805.0216', series => 'C', number => '137', parent => 'C:137', title => 'Lowestoft', polygon => [[615000,257000],[655000,257000],[655000,291600],[655580,292000],[656000,292280],[656240,292850],[656240,294500],[655300,297000],[655000,297500],[655000,302000],[615000,302000],[615000,257000]] };
$maps{"C:138"} = { bbox => [[164240, 205000], [208000, 250000]], area => '1818.306475', series => 'C', number => '138', parent => 'C:138', title => 'Fishguard', polygon => [[168000,205000],[208000,205000],[208000,250000],[168000,250000],[168000,228400],[167900,228340],[167500,228500],[167260,228520],[167000,228475],[166750,228250],[166250,228250],[166000,228090],[165920,228000],[165710,227500],[165340,225500],[165185,224500],[164950,224000],[164500,223400],[164240,222600],[164240,222450],[164335,222000],[165000,221350],[165280,221330],[166100,222000],[166400,222250],[168000,222250],[168000,205000]] };
$maps{"C:139"} = { bbox => [[208000, 218000], [248000, 264300]], area => '1802.0709', series => 'C', number => '139', parent => 'C:139', title => 'Cardigan', polygon => [[208000,218000],[248000,218000],[248000,264300],[247800,264300],[247600,264000],[247000,263800],[246200,263740],[245355,263250],[245302,263000],[208000,263000],[208000,218000]] };
$maps{"C:140"} = { bbox => [[248000, 218000], [288000, 263000]], area => '1800', series => 'C', number => '140', parent => 'C:140', title => 'Llandovery', polygon => [[248000,218000],[288000,218000],[288000,263000],[248000,263000],[248000,218000]] };
$maps{"C:141"} = { bbox => [[288000, 209660], [328000, 255000]], area => '1800.180375', series => 'C', number => '141', parent => 'C:141', title => 'Brecon', polygon => [[288000,210000],[313880,210000],[314355,209700],[314400,209660],[314525,209660],[314630,209750],[314800,210000],[328000,210000],[328000,255000],[288000,255000],[288000,210000]] };
$maps{"C:142"} = { bbox => [[328000, 210000], [368000, 255000]], area => '1800', series => 'C', number => '142', parent => 'C:142', title => 'Hereford', polygon => [[328000,210000],[368000,210000],[368000,255000],[328000,255000],[328000,210000]] };
$maps{"C:143"} = { bbox => [[360000, 210000], [400000, 255000]], area => '1800', series => 'C', number => '143', parent => 'C:143', title => 'Gloucester & Malvern', polygon => [[360000,210000],[400000,210000],[400000,255000],[360000,255000],[360000,210000]] };
$maps{"C:144"} = { bbox => [[388000, 210000], [428000, 255000]], area => '1800', series => 'C', number => '144', parent => 'C:144', title => 'Cheltenham & Evesham', polygon => [[388000,210000],[428000,210000],[428000,255000],[388000,255000],[388000,210000]] };
$maps{"C:145"} = { bbox => [[428000, 210000], [468000, 255000]], area => '1800', series => 'C', number => '145', parent => 'C:145', title => 'Banbury', polygon => [[428000,210000],[468000,210000],[468000,255000],[428000,255000],[428000,210000]] };
$maps{"C:146"} = { bbox => [[455000, 210000], [495000, 255000]], area => '1800', series => 'C', number => '146', parent => 'C:146', title => 'Buckingham', polygon => [[455000,210000],[495000,210000],[495000,255000],[455000,255000],[455000,210000]] };
$maps{"C:147"} = { bbox => [[495000, 210000], [535000, 255000]], area => '1800', series => 'C', number => '147', parent => 'C:147', title => 'Bedford & Luton', polygon => [[495000,210000],[535000,210000],[535000,255000],[495000,255000],[495000,210000]] };
$maps{"C:148"} = { bbox => [[535000, 210000], [575000, 255000]], area => '1800', series => 'C', number => '148', parent => 'C:148', title => 'Saffron Walden', polygon => [[535000,210000],[575000,210000],[575000,255000],[535000,255000],[535000,210000]] };
$maps{"C:149"} = { bbox => [[570000, 212000], [610000, 257000]], area => '1800', series => 'C', number => '149', parent => 'C:149', title => 'Colchester', polygon => [[570000,212000],[610000,212000],[610000,257000],[570000,257000],[570000,212000]] };
$maps{"C:150"} = { bbox => [[610000, 212000], [650000, 257000]], area => '1800', series => 'C', number => '150', parent => 'C:150', title => 'Ipswich', polygon => [[610000,212000],[650000,212000],[650000,257000],[610000,257000],[610000,212000]] };
$maps{"C:151"} = { bbox => [[164240, 190000], [208000, 235000]], area => '1818.306475', series => 'C', number => '151', parent => 'C:151', title => 'Pembroke', polygon => [[168000,190000],[208000,190000],[208000,235000],[168000,235000],[168000,228400],[167900,228340],[167500,228500],[167260,228520],[167000,228475],[166750,228250],[166250,228250],[166000,228090],[165920,228000],[165710,227500],[165340,225500],[165185,224500],[164950,224000],[164500,223400],[164240,222600],[164240,222450],[164335,222000],[165000,221350],[165280,221330],[166100,222000],[166400,222250],[168000,222250],[168000,190000]] };
$maps{"C:151.a"} = { bbox => [[145935, 205420], [161050, 211195]], area => '77.3075625', series => 'C', number => '151', parent => 'C:151', title => 'Pembroke', polygon => [[145935,206015],[160830,205420],[161050,210595],[146130,211195],[145935,206015]] };
$maps{"C:152"} = { bbox => [[208000, 180000], [248000, 225000]], area => '1800', series => 'C', number => '152', parent => 'C:152', title => 'Carmarthen and Tenby', polygon => [[208000,180000],[248000,180000],[248000,225000],[208000,225000],[208000,180000]] };
$maps{"C:153"} = { bbox => [[248000, 173000], [288000, 218000]], area => '1800', series => 'C', number => '153', parent => 'C:153', title => 'Swansea', polygon => [[248000,173000],[288000,173000],[288000,218000],[248000,218000],[248000,173000]] };
$maps{"C:154"} = { bbox => [[288000, 164485], [328000, 210000]], area => '1800.3716625', series => 'C', number => '154', parent => 'C:154', title => 'Cardiff', polygon => [[288000,165000],[321660,165000],[321670,164680],[321770,164630],[322000,164510],[322255,164485],[322385,164590],[322395,164820],[322900,165000],[328000,165000],[328000,210000],[288000,210000],[288000,165000]] };
$maps{"C:155"} = { bbox => [[328000, 165000], [368000, 210000]], area => '1800', series => 'C', number => '155', parent => 'C:155', title => 'Bristol & Newport', polygon => [[328000,165000],[368000,165000],[368000,210000],[328000,210000],[328000,165000]] };
$maps{"C:156"} = { bbox => [[352395, 164065], [393660, 210000]], area => '1805.770675', series => 'C', number => '156', parent => 'C:156', title => 'Bristol & Stroud', polygon => [[353000,165000],[371920,165000],[372100,164745],[372565,164410],[373000,164160],[373500,164065],[374300,164065],[375525,164130],[375660,164170],[375790,164240],[375920,164330],[376080,164590],[376080,165000],[393000,165000],[393000,184900],[393330,185500],[393395,186100],[393550,186330],[393660,187000],[393550,187395],[393235,188000],[393110,188630],[393000,188640],[393000,210000],[353000,210000],[353000,204500],[352395,204150],[352395,203850],[352670,203145],[352580,202670],[353000,202100],[353000,201100],[352900,201090],[352700,200670],[352800,200250],[353000,200000],[353000,165000]] };
$maps{"C:157"} = { bbox => [[388000, 165000], [428000, 210000]], area => '1800', series => 'C', number => '157', parent => 'C:157', title => 'Swindon', polygon => [[388000,165000],[428000,165000],[428000,210000],[388000,210000],[388000,165000]] };
$maps{"C:158"} = { bbox => [[428000, 165000], [468000, 210560]], area => '1801.2762', series => 'C', number => '158', parent => 'C:158', title => 'Oxford & Newbury', polygon => [[428000,165000],[468000,165000],[468000,210000],[436900,210000],[436315,210550],[436000,210560],[435150,210400],[434400,210500],[434100,210450],[434000,210400],[433950,210000],[428000,210000],[428000,165000]] };
$maps{"C:159"} = { bbox => [[463000, 172000], [503000, 218000]], area => '1805.19875', series => 'C', number => '159', parent => 'C:159', title => 'The Chilterns', polygon => [[463000,173000],[467900,173000],[468150,172600],[468550,172250],[469000,172000],[472500,172000],[474550,173000],[503000,173000],[503000,218000],[463000,218000],[463000,173000]] };
$maps{"C:160"} = { bbox => [[495000, 180000], [535000, 225000]], area => '1800', series => 'C', number => '160', parent => 'C:160', title => 'London NW', polygon => [[495000,180000],[535000,180000],[535000,225000],[495000,225000],[495000,180000]] };
$maps{"C:161"} = { bbox => [[535000, 170000], [575000, 215000]], area => '1800', series => 'C', number => '161', parent => 'C:161', title => 'London NE', polygon => [[535000,170000],[575000,170000],[575000,215000],[535000,215000],[535000,170000]] };
$maps{"C:162"} = { bbox => [[570000, 180000], [610000, 226300]], area => '1804.11175', series => 'C', number => '162', parent => 'C:162', title => 'Southend-on-Sea', polygon => [[570000,180000],[610000,180000],[610000,225000],[601700,225000],[601200,225600],[600900,225800],[600630,226000],[600500,226150],[600360,226300],[600000,226200],[599300,226180],[599000,226050],[598600,225800],[598250,225700],[597800,225600],[597300,225500],[596900,225400],[596800,225280],[596300,225200],[595840,225000],[570000,225000],[570000,180000]] };
$maps{"C:163"} = { bbox => [[240000, 110000], [280000, 155000]], area => '1800', series => 'C', number => '163', parent => 'C:163', title => 'Barnstaple', polygon => [[240000,110000],[280000,110000],[280000,155000],[240000,155000],[240000,110000]] };
$maps{"C:163.a"} = { bbox => [[211500, 142500], [216500, 148500]], area => '30', series => 'C', number => '163', parent => 'C:163', title => 'Barnstaple', polygon => [[211500,142500],[216500,142500],[216500,148500],[211500,148500],[211500,142500]] };
$maps{"C:164"} = { bbox => [[280000, 110000], [320000, 155000]], area => '1800', series => 'C', number => '164', parent => 'C:164', title => 'Minehead', polygon => [[280000,110000],[320000,110000],[320000,155000],[280000,155000],[280000,110000]] };
$maps{"C:165"} = { bbox => [[320000, 130000], [360000, 175000]], area => '1800', series => 'C', number => '165', parent => 'C:165', title => 'Weston-super-Mare', polygon => [[320000,130000],[360000,130000],[360000,175000],[320000,175000],[320000,130000]] };
$maps{"C:166"} = { bbox => [[353000, 120000], [393000, 165000]], area => '1800', series => 'C', number => '166', parent => 'C:166', title => 'Frome', polygon => [[353000,120000],[393000,120000],[393000,165000],[353000,165000],[353000,120000]] };
$maps{"C:167"} = { bbox => [[388000, 120000], [428000, 165000]], area => '1800', series => 'C', number => '167', parent => 'C:167', title => 'Salisbury', polygon => [[388000,120000],[428000,120000],[428000,165000],[388000,165000],[388000,120000]] };
$maps{"C:168"} = { bbox => [[428000, 120000], [468000, 165000]], area => '1800', series => 'C', number => '168', parent => 'C:168', title => 'Winchester', polygon => [[428000,120000],[468000,120000],[468000,165000],[428000,165000],[428000,120000]] };
$maps{"C:169"} = { bbox => [[463000, 127500], [503000, 174250]], area => '1806.807', series => 'C', number => '169', parent => 'C:169', title => 'Aldershot', polygon => [[463000,128000],[477250,128000],[477100,127700],[477650,127500],[477800,127500],[478300,127600],[478450,127900],[478600,128000],[503000,128000],[503000,173000],[474300,173000],[473550,174000],[472000,174000],[471750,174100],[471340,174100],[471320,174000],[470800,174000],[470000,174250],[470000,174000],[469000,174000],[468300,173900],[468000,173700],[467200,173000],[463000,173000],[463000,128000]] };
$maps{"C:170"} = { bbox => [[495000, 135000], [535180, 180000]], area => '1800.2587', series => 'C', number => '170', parent => 'C:170', title => 'London SW', polygon => [[495000,135000],[535000,135000],[535000,151400],[535150,151450],[535180,152200],[535100,153130],[535000,153150],[535000,180000],[495000,180000],[495000,135000]] };
$maps{"C:171"} = { bbox => [[535000, 135000], [575000, 180000]], area => '1800', series => 'C', number => '171', parent => 'C:171', title => 'London SE', polygon => [[535000,135000],[575000,135000],[575000,180000],[535000,180000],[535000,135000]] };
$maps{"C:172"} = { bbox => [[570000, 135000], [610000, 180000]], area => '1800', series => 'C', number => '172', parent => 'C:172', title => 'Chatham & Maidstone', polygon => [[570000,135000],[610000,135000],[610000,180000],[570000,180000],[570000,135000]] };
$maps{"C:173"} = { bbox => [[602000, 128000], [642500, 173000]], area => '1800.4055', series => 'C', number => '173', parent => 'C:173', title => 'East Kent', polygon => [[602000,128000],[642000,128000],[642000,144300],[642330,144500],[642500,144800],[642500,144960],[642400,145200],[642000,145500],[642000,173000],[602000,173000],[602000,128000]] };
$maps{"C:174"} = { bbox => [[200000, 84235], [240000, 130000]], area => '1803.1085', series => 'C', number => '174', parent => 'C:174', title => 'Bude', polygon => [[200000,85000],[230000,85000],[231000,84770],[232000,84500],[233000,84260],[233600,84235],[233950,84235],[234250,84245],[235000,84315],[235500,84500],[236000,84800],[236500,85000],[240000,85000],[240000,130000],[200000,130000],[200000,85000]] };
$maps{"C:175"} = { bbox => [[240000, 70000], [280000, 115000]], area => '1800', series => 'C', number => '175', parent => 'C:175', title => 'Okehampton', polygon => [[240000,70000],[280000,70000],[280000,115000],[240000,115000],[240000,70000]] };
$maps{"C:176"} = { bbox => [[280000, 70000], [320000, 115000]], area => '1800', series => 'C', number => '176', parent => 'C:176', title => 'Exeter', polygon => [[280000,70000],[320000,70000],[320000,115000],[280000,115000],[280000,70000]] };
$maps{"C:177"} = { bbox => [[320000, 85000], [360000, 130000]], area => '1800', series => 'C', number => '177', parent => 'C:177', title => 'Taunton & Lyme Regis', polygon => [[320000,85000],[360000,85000],[360000,130000],[320000,130000],[320000,85000]] };
$maps{"C:178"} = { bbox => [[353000, 74100], [393000, 120000]], area => '1802.94', series => 'C', number => '178', parent => 'C:178', title => 'Dorchester', polygon => [[353000,75000],[366300,75000],[368200,74100],[369500,74100],[370000,74200],[370300,74300],[370800,74700],[370900,75000],[393000,75000],[393000,120000],[353000,120000],[353000,75000]] };
$maps{"C:178.a"} = { bbox => [[367000, 68150], [371000, 74900]], area => '26.11275', series => 'C', number => '178', parent => 'C:178', title => 'Dorchester', polygon => [[367000,68300],[367400,68300],[367500,68150],[369250,68150],[369250,68300],[371000,68300],[371000,74750],[369150,74750],[369060,74900],[368840,74900],[368800,74750],[367000,74750],[367000,68300]] };
$maps{"C:179"} = { bbox => [[388000, 75000], [428000, 120000]], area => '1800', series => 'C', number => '179', parent => 'C:179', title => 'Bournemouth', polygon => [[388000,75000],[428000,75000],[428000,120000],[388000,120000],[388000,75000]] };
$maps{"C:180"} = { bbox => [[428000, 75000], [468000, 120000]], area => '1800', series => 'C', number => '180', parent => 'C:180', title => 'The Solent', polygon => [[428000,75000],[468000,75000],[468000,120000],[428000,120000],[428000,75000]] };
$maps{"C:181"} = { bbox => [[462000, 90000], [503000, 135000]], area => '1803.5', series => 'C', number => '181', parent => 'C:181', title => 'Chichester', polygon => [[463000,90000],[503000,90000],[503000,135000],[463000,135000],[463000,102000],[462000,102000],[462000,98500],[463000,98500],[463000,90000]] };
$maps{"C:182"} = { bbox => [[495000, 99160], [535000, 145000]], area => '1802.2214', series => 'C', number => '182', parent => 'C:182', title => 'Brighton & Worthing', polygon => [[495000,100000],[495000,99160],[495500,99263],[495750,99342],[496000,99265],[496400,99250],[497000,99447],[497500,99580],[498000,99630],[498300,99620],[499550,100000],[535000,100000],[535000,145000],[495000,145000],[495000,100000]] };
$maps{"C:183"} = { bbox => [[535000, 93000], [575000, 139000]], area => '1801.238175', series => 'C', number => '183', parent => 'C:183', title => 'Eastbourne', polygon => [[535000,93000],[575000,93000],[575000,138000],[540160,138000],[539815,138685],[539250,139000],[539000,139000],[538650,138790],[538550,138550],[538500,138000],[535000,138000],[535000,93000]] };
$maps{"C:184"} = { bbox => [[570000, 105000], [610000, 150000]], area => '1800', series => 'C', number => '184', parent => 'C:184', title => 'Hastings', polygon => [[570000,105000],[610000,105000],[610000,150000],[570000,150000],[570000,105000]] };
$maps{"C:185"} = { bbox => [[169184, 50000], [210120, 95000]], area => '1801.21547', series => 'C', number => '185', parent => 'C:185', title => 'Newquay & Padstow', polygon => [[170000,50000],[210000,50000],[210000,83000],[210100,83100],[210120,83460],[210060,84000],[210000,84360],[210000,84780],[210080,85080],[210070,85700],[210000,85800],[210000,95000],[170000,95000],[170000,53400],[169940,53300],[169940,53200],[170000,53070],[170000,51950],[169592,51789],[169500,51500],[169539,51170],[169538,51000],[169368,50500],[169184,50000],[170000,50000]] };
$maps{"C:186"} = { bbox => [[200000, 45000], [240000, 90000]], area => '1800', series => 'C', number => '186', parent => 'C:186', title => 'Bodmin & Launceston', polygon => [[200000,45000],[240000,45000],[240000,90000],[200000,90000],[200000,45000]] };
$maps{"C:187"} = { bbox => [[240000, 34315], [280000, 80000]], area => '1801.467', series => 'C', number => '187', parent => 'C:187', title => 'Plymouth', polygon => [[240000,35000],[276800,35000],[276820,34750],[277000,34600],[277315,34315],[278000,34400],[279000,34600],[279350,34500],[279900,35000],[280000,35000],[280000,80000],[240000,80000],[240000,35000]] };
$maps{"C:188"} = { bbox => [[260000, 34315], [300000, 80000]], area => '1801.467', series => 'C', number => '188', parent => 'C:188', title => 'Torbay', polygon => [[260000,35000],[276800,35000],[276820,34750],[277000,34600],[277315,34315],[278000,34400],[279000,34600],[279350,34500],[279900,35000],[300000,35000],[300000,80000],[260000,80000],[260000,35000]] };
$maps{"C:189"} = { bbox => [[131000, 10000], [171000, 55000]], area => '1800', series => 'C', number => '189', parent => 'C:189', title => 'Lands End', polygon => [[131000,10000],[171000,10000],[171000,55000],[131000,55000],[131000,10000]] };
$maps{"C:189.a"} = { bbox => [[80000, 5000], [97000, 18500]], area => '205.7', series => 'C', number => '189', parent => 'C:189', title => 'Lands End', polygon => [[80000,5000],[97000,5000],[97000,18500],[85600,18500],[80000,10000],[80000,5000]] };
$maps{"C:190"} = { bbox => [[170000, 10000], [210000, 55000]], area => '1800', series => 'C', number => '190', parent => 'C:190', title => 'Truro & Falmouth', polygon => [[170000,10000],[210000,10000],[210000,55000],[170000,55000],[170000,10000]] };
$maps{"H:101"} = { bbox => [[195240, 900170], [234920, 937770]], area => '1228.6647', series => 'H', number => '101', parent => 'H:101', title => 'Assynt', polygon => [[234400,920490],[234400,926730],[234500,926730],[234600,926730],[234920,926730],[234920,930560],[234600,930560],[234400,930560],[234400,936550],[234390,936560],[234380,936570],[234370,936580],[234360,936580],[234360,936590],[234350,936600],[234340,936610],[234330,936610],[234330,936620],[234320,936620],[234320,936630],[234310,936630],[234310,936640],[234300,936640],[234300,936650],[234290,936650],[234290,936660],[234280,936660],[234280,936670],[234270,936670],[234270,936680],[234260,936690],[234250,936690],[234250,936700],[234240,936700],[234240,936710],[234230,936720],[234220,936720],[234220,936730],[234210,936740],[234200,936750],[234190,936760],[234180,936770],[234170,936780],[234160,936780],[234160,936790],[234150,936800],[234140,936810],[234120,936830],[234100,936840],[234090,936850],[234080,936870],[234070,936880],[234060,936890],[234040,936900],[234030,936910],[234020,936920],[234000,936930],[233990,936940],[233980,936960],[233960,936970],[233950,936980],[233930,936990],[233920,937000],[233900,937010],[233890,937020],[233880,937040],[233860,937050],[233850,937060],[233830,937070],[233820,937080],[233800,937090],[233790,937100],[233780,937110],[233760,937120],[233750,937130],[233740,937140],[233730,937150],[233710,937160],[233700,937170],[233690,937170],[233680,937180],[233670,937190],[233660,937200],[233650,937200],[233640,937210],[233630,937220],[233620,937220],[233620,937230],[233610,937230],[233600,937240],[233590,937240],[233590,937250],[233580,937250],[233300,937450],[232800,937770],[230640,937770],[230640,937350],[230640,937250],[200200,937250],[200200,918970],[195760,918970],[195760,916800],[195660,916800],[195560,916800],[195240,916800],[195240,914190],[195560,914190],[195660,914190],[195760,914190],[195760,912520],[195560,912520],[195240,912520],[195240,910790],[195560,910790],[195660,910790],[195760,910790],[195760,908400],[195660,908400],[195560,908400],[195240,908400],[195240,905400],[195560,905400],[195760,905400],[195760,902980],[200200,902980],[200200,902390],[205160,902390],[205160,901760],[207900,901760],[207900,900690],[210120,900690],[210120,900590],[210120,900490],[210120,900170],[212540,900170],[212540,900490],[212540,900590],[212540,900690],[214400,900690],[214400,900700],[214400,900710],[214410,900720],[214410,900730],[214420,900730],[214420,900740],[214420,900750],[214430,900750],[214430,900760],[214440,900770],[214440,900780],[214450,900780],[214450,900790],[214460,900790],[214460,900800],[214470,900810],[214480,900820],[214490,900830],[214500,900840],[214510,900850],[214520,900860],[214530,900860],[214530,900870],[214540,900870],[214550,900880],[214560,900890],[214570,900890],[214580,900900],[214590,900900],[214600,900910],[214610,900910],[214620,900910],[214620,900920],[214630,900920],[214640,900920],[214650,900930],[214660,900930],[214670,900930],[214680,900940],[214690,900940],[214730,900950],[214750,900950],[214760,900960],[214780,900960],[214800,900970],[214820,900970],[214840,900980],[214860,900980],[214880,900990],[214900,901000],[214920,901000],[214940,901010],[214960,901020],[214980,901020],[215000,901030],[215020,901040],[215040,901050],[215060,901050],[215080,901060],[215100,901070],[215120,901080],[215130,901090],[215150,901100],[215170,901110],[215190,901120],[215210,901120],[215230,901130],[215250,901140],[215270,901150],[215290,901160],[215310,901170],[215330,901180],[215350,901190],[215370,901200],[215390,901210],[215410,901230],[215430,901240],[215450,901250],[215470,901260],[215490,901270],[215500,901280],[215520,901290],[215540,901300],[215560,901310],[215580,901330],[215600,901340],[215610,901350],[215630,901360],[215650,901370],[215690,901400],[215700,901410],[215720,901420],[215740,901430],[215760,901450],[215780,901460],[215800,901470],[215820,901480],[215840,901500],[215860,901510],[215880,901520],[215900,901530],[215930,901550],[215950,901560],[215970,901570],[215990,901590],[216010,901600],[216030,901610],[216050,901630],[216080,901640],[216100,901650],[216120,901660],[216140,901680],[216160,901690],[216180,901700],[216200,901720],[216220,901730],[216240,901740],[216260,901750],[216280,901770],[216300,901780],[216320,901790],[216340,901800],[216350,901820],[216370,901830],[216390,901840],[216410,901850],[216420,901860],[216440,901880],[216450,901890],[216470,901900],[216480,901910],[216500,901920],[216510,901930],[216520,901950],[216530,901960],[216540,901970],[216550,901980],[216560,901990],[216580,902010],[216590,902020],[216590,902030],[216600,902040],[216610,902050],[216610,902060],[216620,902070],[216630,902070],[216630,902080],[216640,902090],[216640,902100],[216650,902110],[216660,902110],[216660,902120],[216670,902130],[216670,902140],[216680,902140],[216690,902150],[216690,902160],[216700,902160],[216710,902170],[216720,902180],[216730,902190],[216740,902200],[216750,902200],[216760,902210],[216770,902210],[216780,902220],[216790,902220],[216800,902230],[216810,902230],[216820,902240],[216830,902240],[216850,902250],[216860,902250],[216870,902260],[216890,902260],[216900,902270],[216920,902270],[216940,902280],[216950,902280],[216970,902280],[216990,902290],[217010,902290],[217030,902300],[217060,902300],[217080,902310],[217130,902320],[217150,902320],[217170,902330],[217190,902330],[217210,902340],[217230,902350],[217250,902350],[217260,902360],[217280,902370],[217300,902370],[217310,902380],[217330,902390],[217340,902400],[217360,902410],[217370,902410],[217380,902420],[217400,902430],[217410,902440],[217420,902450],[217430,902460],[217440,902470],[217450,902480],[217460,902490],[217470,902500],[217480,902510],[217490,902520],[217490,902530],[217500,902540],[217510,902550],[217510,902560],[217520,902570],[217530,902580],[217530,902590],[217540,902600],[217540,902610],[217550,902630],[217550,902640],[217550,902650],[217560,902660],[217560,902670],[217560,902680],[217570,902690],[217570,902700],[217570,902710],[217570,902720],[217580,902730],[217580,902740],[217580,902750],[217580,902760],[217590,902790],[217590,902800],[217590,902810],[217590,902820],[217600,902830],[217600,902840],[217600,902850],[217610,902860],[217610,902880],[217620,902890],[217620,902900],[217620,902910],[217630,902930],[217630,902940],[217640,902950],[217650,902960],[217650,902980],[217660,902990],[217660,903000],[217670,903020],[217680,903030],[217680,903040],[217690,903060],[217700,903070],[217710,903080],[217710,903100],[217720,903110],[217730,903130],[217740,903140],[217750,903150],[217760,903170],[217760,903180],[217770,903200],[217780,903210],[217790,903220],[217800,903240],[217810,903250],[217820,903260],[217830,903280],[217840,903290],[217850,903310],[217860,903320],[217870,903330],[217880,903350],[217890,903360],[217910,903370],[217920,903390],[217930,903400],[217940,903410],[217960,903440],[217970,903450],[217990,903470],[218000,903480],[218010,903500],[218030,903510],[218040,903530],[218050,903550],[218070,903570],[218080,903580],[218100,903600],[218110,903620],[218130,903640],[218140,903660],[218160,903680],[218170,903700],[218190,903720],[218200,903750],[218220,903770],[218230,903790],[218250,903810],[218260,903840],[218280,903860],[218290,903880],[218310,903910],[218320,903930],[218330,903960],[218350,903980],[218360,904010],[218380,904030],[218390,904060],[218400,904090],[218410,904110],[218430,904140],[218440,904170],[218450,904200],[218460,904220],[218470,904250],[218480,904280],[218490,904310],[218500,904340],[218510,904370],[218520,904400],[218530,904430],[218530,904460],[218540,904490],[218550,904520],[218550,904550],[218550,904580],[218560,904650],[218570,904680],[218570,904720],[218570,904750],[218570,904790],[218570,904830],[218570,904860],[218570,904900],[218570,904940],[218570,904980],[218570,905020],[218570,905060],[218570,905100],[218570,905140],[218570,905180],[218570,905230],[218570,905270],[218560,905310],[218560,905350],[218560,905390],[218560,905430],[218560,905470],[218560,905510],[218560,905550],[218560,905590],[218560,905630],[218560,905670],[218560,905710],[218560,905740],[218570,905780],[218570,905820],[218570,905850],[218580,905880],[218580,905920],[218580,905950],[218590,905980],[218600,906000],[218600,906030],[218610,906060],[218620,906080],[218630,906100],[218640,906130],[218650,906150],[218660,906160],[218680,906180],[218690,906190],[218710,906210],[218720,906220],[218740,906220],[218780,906240],[218800,906240],[218820,906250],[218840,906250],[218860,906260],[218890,906260],[218910,906260],[218930,906270],[218960,906270],[218980,906270],[219010,906280],[219030,906280],[219060,906280],[219090,906280],[219110,906280],[219140,906290],[219170,906290],[219190,906290],[219220,906290],[219250,906290],[219280,906290],[219310,906300],[219330,906300],[219360,906300],[219390,906310],[219420,906310],[219450,906310],[219480,906320],[219500,906320],[219530,906330],[219560,906330],[219590,906340],[219610,906340],[219640,906350],[219670,906360],[219690,906370],[219720,906380],[219740,906390],[219770,906400],[219790,906410],[219820,906420],[219840,906440],[219860,906450],[219890,906470],[219910,906480],[219930,906500],[219950,906520],[219970,906540],[219990,906560],[220020,906600],[220040,906620],[220060,906640],[220070,906660],[220090,906680],[220100,906710],[220120,906730],[220140,906750],[220150,906770],[220170,906790],[220180,906810],[220200,906830],[220210,906850],[220230,906860],[220240,906880],[220250,906900],[220270,906920],[220280,906940],[220290,906960],[220310,906980],[220320,907000],[220340,907020],[220350,907030],[220360,907050],[220380,907070],[220390,907090],[220400,907110],[220420,907120],[220430,907140],[220440,907160],[220460,907180],[220470,907190],[220490,907210],[220500,907230],[220510,907240],[220530,907260],[220540,907280],[220560,907290],[220570,907310],[220590,907320],[220600,907340],[220620,907360],[220640,907370],[220650,907390],[220670,907400],[220680,907420],[220700,907430],[220720,907450],[220740,907460],[220760,907480],[220770,907490],[220790,907500],[220800,907510],[220820,907520],[220830,907520],[220850,907530],[220860,907540],[220880,907550],[220890,907550],[220910,907560],[220930,907570],[220950,907570],[220970,907580],[220990,907580],[221010,907590],[221030,907590],[221050,907600],[221070,907600],[221090,907610],[221120,907610],[221140,907610],[221160,907620],[221190,907620],[221220,907630],[221240,907630],[221270,907630],[221300,907630],[221330,907640],[221360,907640],[221390,907640],[221420,907640],[221450,907640],[221490,907650],[221520,907650],[221560,907650],[221590,907650],[221630,907650],[221670,907650],[221700,907650],[221740,907650],[221780,907660],[221830,907660],[221870,907660],[221910,907660],[221960,907660],[222000,907660],[222050,907660],[222100,907660],[222190,907660],[222230,907660],[222280,907660],[222330,907660],[222370,907660],[222420,907660],[222470,907660],[222520,907660],[222580,907660],[222630,907660],[222680,907660],[222730,907660],[222790,907660],[222840,907660],[222890,907660],[222950,907660],[223000,907660],[223060,907660],[223110,907660],[223160,907660],[223220,907660],[223270,907660],[223330,907660],[223380,907660],[223430,907660],[223490,907660],[223540,907660],[223590,907660],[223640,907660],[223690,907660],[223740,907660],[223790,907660],[223840,907660],[223890,907660],[223940,907660],[223980,907660],[224030,907660],[224070,907660],[224110,907660],[224150,907660],[224190,907660],[224230,907660],[224270,907660],[224310,907660],[224340,907660],[224370,907660],[224400,907660],[224430,907660],[224460,907660],[224530,907660],[224570,907660],[224610,907660],[224660,907660],[224710,907660],[224760,907660],[224820,907660],[224870,907660],[224930,907660],[225000,907660],[225060,907650],[225120,907650],[225190,907650],[225260,907650],[225330,907650],[225400,907650],[225480,907650],[225550,907650],[225630,907650],[225700,907650],[225780,907640],[225860,907640],[225940,907640],[226010,907640],[226090,907640],[226170,907640],[226250,907630],[226330,907630],[226400,907630],[226480,907630],[226560,907620],[226630,907620],[226710,907620],[226780,907610],[226850,907610],[226920,907600],[226990,907600],[227060,907600],[227120,907590],[227180,907590],[227250,907580],[227300,907580],[227360,907570],[227410,907570],[227470,907560],[227510,907560],[227560,907550],[227600,907540],[227640,907540],[227730,907520],[227770,907510],[227810,907500],[227850,907500],[227890,907490],[227920,907480],[227960,907470],[228000,907460],[228040,907460],[228070,907450],[228110,907440],[228140,907430],[228170,907420],[228210,907420],[228240,907410],[228270,907400],[228310,907390],[228340,907380],[228370,907370],[228400,907360],[228430,907360],[228460,907350],[228490,907340],[228520,907330],[228550,907320],[228570,907310],[228600,907300],[228630,907290],[228660,907280],[228690,907270],[228710,907260],[228740,907250],[228770,907240],[228790,907230],[228820,907220],[228850,907210],[228870,907190],[228900,907180],[228930,907170],[228950,907160],[228980,907150],[229010,907130],[229030,907120],[229060,907110],[229080,907100],[229110,907080],[229140,907070],[229170,907050],[229190,907040],[229230,907020],[229260,907010],[229280,907000],[229300,906980],[229330,906970],[229350,906960],[229380,906940],[229400,906930],[229430,906910],[229450,906890],[229480,906880],[229510,906860],[229540,906840],[229570,906820],[229600,906810],[229620,906790],[229650,906770],[229680,906750],[229710,906730],[229740,906710],[229770,906690],[229800,906660],[229830,906640],[229860,906620],[229890,906600],[229920,906580],[229940,906550],[229970,906530],[230000,906510],[230030,906480],[230060,906460],[230080,906440],[230110,906410],[230130,906390],[230160,906360],[230180,906340],[230200,906320],[230230,906290],[230250,906270],[230270,906240],[230290,906220],[230310,906190],[230330,906170],[230340,906150],[230360,906120],[230370,906100],[230390,906070],[230400,906050],[230410,906030],[230430,905970],[230440,905940],[230440,905910],[230450,905880],[230460,905840],[230460,905810],[230470,905770],[230470,905730],[230480,905680],[230480,905640],[230490,905590],[230490,905550],[230490,905500],[230500,905450],[230500,905400],[230500,905340],[230500,905290],[230510,905240],[230510,905180],[230510,905130],[230520,905070],[230520,905020],[230530,904960],[230530,904900],[230540,904850],[230540,904790],[230550,904730],[230560,904680],[230560,904620],[230570,904560],[230580,904510],[230590,904450],[230600,904400],[230610,904340],[230630,904290],[230640,904240],[230650,904180],[230670,904130],[230690,904080],[230710,904040],[230730,903990],[230750,903940],[230770,903900],[230790,903850],[230820,903810],[230850,903770],[230880,903740],[230910,903700],[230940,903670],[231000,903600],[231040,903570],[231070,903540],[231100,903520],[231140,903490],[231170,903460],[231200,903440],[231230,903410],[231270,903390],[231300,903370],[231330,903340],[231360,903320],[231390,903300],[231430,903280],[231460,903260],[231490,903250],[231520,903230],[231550,903210],[231580,903200],[231610,903180],[231640,903170],[231670,903150],[231700,903140],[231730,903130],[231760,903120],[231780,903100],[231810,903090],[231840,903080],[231860,903070],[231890,903070],[231920,903060],[231940,903050],[231970,903040],[231990,903040],[232010,903030],[232040,903020],[232060,903020],[232080,903010],[232100,903010],[232120,903000],[232140,903000],[232160,902990],[232180,902990],[232200,902990],[232210,902980],[232230,902980],[232250,902980],[232260,902980],[232280,902980],[232300,902970],[232320,902970],[232330,902970],[232340,902960],[232350,902960],[232370,902960],[232380,902950],[232390,902950],[232400,902950],[232410,902940],[232420,902940],[232430,902930],[232440,902930],[232460,902920],[232470,902920],[232480,902910],[232490,902910],[232490,902900],[232500,902900],[232510,902890],[232520,902890],[232530,902880],[232540,902880],[232550,902870],[232560,902860],[232570,902860],[232580,902850],[232580,902840],[232590,902840],[232600,902830],[232610,902820],[232620,902820],[232620,902810],[232630,902800],[232640,902790],[232650,902780],[232660,902770],[232670,902760],[232680,902750],[232690,902740],[232690,902730],[232700,902730],[232700,902720],[232710,902710],[232710,902700],[232720,902700],[232720,902690],[232720,902680],[232730,902680],[232730,902670],[232730,902660],[232740,902660],[232740,902650],[232740,902640],[232750,902630],[232750,902620],[232760,902610],[232760,902600],[232760,902590],[232770,902580],[232770,902570],[232770,902560],[232770,902550],[232780,902550],[232780,902540],[232780,902530],[232780,902520],[232790,902510],[232790,902500],[232790,902480],[232800,902470],[232800,902460],[232800,902450],[232810,902440],[232810,902430],[232820,902420],[232820,902410],[232830,902390],[232840,902380],[232840,902370],[232850,902350],[232850,902340],[232860,902330],[232870,902310],[232880,902300],[232880,902290],[232890,902270],[232900,902260],[232910,902240],[232920,902230],[232930,902210],[232940,902200],[232950,902180],[232960,902170],[232970,902150],[232980,902140],[232990,902120],[233010,902110],[233020,902090],[233030,902080],[233040,902070],[233060,902050],[233070,902040],[233090,902020],[233100,902010],[233110,902000],[233130,901980],[233140,901970],[233160,901960],[233180,901940],[233190,901930],[233210,901920],[233230,901910],[233240,901900],[233260,901890],[233280,901870],[233300,901860],[233310,901850],[233350,901840],[233370,901830],[233390,901820],[233410,901810],[233430,901800],[233450,901790],[233470,901780],[233490,901770],[233510,901760],[233530,901760],[233550,901750],[233570,901740],[233600,901730],[233620,901720],[233640,901710],[233660,901700],[233680,901700],[233710,901690],[233730,901680],[233750,901670],[233770,901670],[233800,901660],[233820,901650],[233840,901640],[233870,901640],[233890,901630],[233910,901620],[233930,901620],[233960,901610],[233980,901610],[234000,901600],[234030,901590],[234050,901590],[234070,901580],[234100,901580],[234120,901570],[234140,901570],[234160,901560],[234190,901560],[234210,901560],[234230,901550],[234250,901550],[234270,901550],[234300,901540],[234320,901540],[234340,901540],[234360,901540],[234380,901530],[234400,901530],[234400,914860],[234600,914860],[234920,914860],[234920,920490],[234600,920490],[234500,920490],[234400,920490]] };
$maps{"H:102"} = { bbox => [[178010, 855390], [217970, 892110]], area => '1170.47395', series => 'H', number => '102', parent => 'H:102', title => 'Torridon & Fisherfield', polygon => [[217030,861820],[217080,869570],[217590,870180],[217590,872440],[217120,872860],[217120,876150],[216460,875860],[211910,881970],[213220,883800],[211350,885960],[211390,887980],[210780,888680],[208860,888640],[208110,889430],[204680,890330],[203930,891310],[203930,892110],[189370,892110],[187070,889760],[186370,889760],[186320,886240],[186040,886240],[186040,884600],[183030,884650],[183030,881920],[184390,881920],[184390,880790],[183030,880840],[183030,878670],[181850,878670],[181850,879500],[179530,879500],[179530,873940],[178100,873940],[178010,872390],[178660,872440],[178660,859570],[178430,859520],[178430,858350],[178710,858300],[178710,855720],[189980,855670],[189980,855390],[192380,855440],[192230,855810],[195330,856420],[195620,856190],[196270,856190],[196270,856940],[200310,857600],[200590,858110],[201720,858580],[202990,859900],[205380,859850],[205290,858960],[208430,857410],[212190,858110],[213460,857830],[216370,857830],[217970,858400],[217970,860980],[217030,861820]] };
$maps{"H:103"} = { bbox => [[169710, 791180], [221800, 831640]], area => '1308.25305', series => 'H', number => '103', parent => 'H:103', title => 'Knoydart, Kintail & Glen Affric', polygon => [[221450,824270],[221450,831410],[220960,831640],[218150,830780],[216160,830960],[214340,830960],[214130,830100],[213710,830100],[213450,829910],[212890,830260],[211040,830170],[210150,829820],[207510,829700],[206250,829330],[205080,829960],[202510,828420],[202510,828240],[200880,827140],[199410,827210],[198860,827490],[197830,827510],[197810,827900],[197510,828260],[196550,828240],[195750,828720],[194670,828720],[194760,828470],[194950,828310],[189750,828310],[189400,827970],[187430,827260],[187820,826870],[188740,823180],[188460,823020],[188460,822720],[188990,822010],[189060,821230],[189430,820890],[189170,820130],[188650,820270],[187390,819830],[184870,820410],[182990,819790],[181680,820180],[181290,819720],[181640,819170],[181660,818390],[180400,818390],[180350,810050],[175860,810050],[175860,809750],[172220,809750],[172190,809720],[172190,806190],[169710,804270],[169710,798940],[175880,798950],[175890,792070],[176530,792090],[178800,791820],[179210,791910],[179570,791790],[180380,792070],[181090,792050],[182640,792340],[183240,792250],[185320,792410],[186010,792270],[186970,791910],[192340,791890],[192930,791700],[197280,791700],[197470,791220],[199070,791180],[199780,791680],[206320,791670],[206320,797360],[208760,799230],[208760,803060],[208690,803960],[208780,804280],[210180,804120],[211030,804260],[211400,804140],[212330,804780],[213320,804760],[213620,805080],[213410,805380],[214690,806410],[214690,810420],[214970,810440],[214970,813880],[214690,813900],[214680,819670],[221430,822960],[221450,823430],[221800,823570],[221800,824270],[221450,824270]] };
$maps{"H:104"} = { bbox => [[283990, 769740], [331310, 812940]], area => '1415.20565', series => 'H', number => '104', parent => 'H:104', title => 'Cairngorms & Lochnagar', polygon => [[331310,784260],[331310,788480],[327620,788470],[327620,788950],[320450,788950],[320440,794230],[319570,794230],[319570,796950],[320580,796950],[320580,799750],[322600,799750],[322600,806100],[318830,806090],[318820,809070],[316980,809460],[317010,812430],[311230,812420],[310540,812830],[308230,812830],[308460,812420],[300760,812410],[301000,812940],[294570,812940],[294780,812420],[289190,812420],[289270,812360],[289210,811010],[289390,809910],[288640,808930],[288670,808550],[287890,807260],[286650,806770],[285920,805610],[285090,805060],[284770,804600],[284680,802780],[283990,800420],[283990,799700],[284940,796930],[284650,793950],[283990,793200],[283990,786880],[284830,784690],[284860,780390],[288230,780390],[289300,781140],[289820,780420],[290340,780360],[290890,780190],[291410,779470],[292530,778800],[294470,779610],[295740,779730],[296370,780190],[296950,779930],[297810,779730],[298510,779350],[299310,779470],[299570,779060],[299950,778310],[300530,778200],[301020,777710],[300900,777010],[301160,776290],[302260,775920],[302570,775310],[302740,775310],[302740,774010],[307650,771850],[310270,770550],[310980,769740],[311370,769760],[312380,772700],[313090,773050],[316760,773050],[316790,775310],[318160,775310],[318160,775830],[328610,775860],[328730,775400],[331100,775400],[331100,775830],[331270,775830],[331270,781260],[330940,781370],[330940,784040],[331310,784260]] };
$maps{"H:105"} = { bbox => [[199390, 741440], [237980, 781930]], area => '1231.3249', series => 'H', number => '105', parent => 'H:105', title => 'Ben Nevis & Glen Coe', polygon => [[237940,757820],[235260,758060],[235260,758720],[234790,759560],[236150,760030],[236950,760590],[236760,763930],[237420,764020],[237940,764770],[237470,766040],[237660,768340],[237940,768720],[237940,769890],[236150,770220],[236150,778390],[235100,778390],[235100,778950],[234900,779120],[234900,780960],[232340,780930],[231500,781230],[229980,781230],[228990,780650],[227230,781460],[226160,781260],[225240,781530],[225190,781750],[224270,781750],[223320,781930],[222440,781770],[221080,781750],[221080,781200],[220940,781100],[221070,780700],[221070,780110],[220870,779550],[221070,779290],[221070,778390],[210190,778390],[209620,777360],[209390,775670],[209620,774920],[208920,774020],[208920,772900],[205680,768720],[205630,765710],[203800,765710],[203800,760170],[203800,760030],[200040,760030],[200090,752560],[200420,751950],[200610,749180],[199390,749180],[199430,741810],[201690,741810],[201870,741480],[203000,741480],[203240,741860],[220380,741910],[220660,741620],[223430,741620],[223660,741910],[227040,741910],[227230,741440],[230100,741440],[231030,742990],[232540,743970],[232540,744490],[233190,744960],[233190,749700],[232630,750360],[232910,750780],[233380,750550],[233900,751440],[235030,750970],[237980,753640],[237940,757820]] };
$maps{"H:106"} = { bbox => [[229620, 720490], [286540, 759180]], area => '1383.23895', series => 'H', number => '106', parent => 'H:106', title => 'Schiehallion, Ben Lawers & Glen Lyon', polygon => [[233050,731380],[267660,731370],[267660,728950],[272400,728940],[272400,723060],[273640,723090],[273980,722960],[275050,722950],[275330,722550],[275690,721980],[276310,721790],[276680,721940],[277000,721730],[277430,721820],[278330,722360],[278780,722240],[279920,722600],[280240,722680],[281790,722250],[282530,722730],[284460,722950],[285250,722890],[285410,722470],[285420,721630],[285860,720940],[286540,720490],[286540,731920],[285410,731930],[284420,732210],[282730,733230],[282730,734590],[278610,734590],[278610,738760],[279120,738760],[279120,748500],[276940,750370],[276770,751740],[277980,754370],[278070,754960],[277780,755420],[276920,755490],[275980,756030],[274720,756030],[274610,756180],[273590,756300],[273150,756360],[271860,757280],[270540,757760],[269030,757490],[267920,757640],[267720,758650],[265440,758840],[264570,759180],[259730,759180],[259740,758850],[257880,758110],[256030,758030],[252000,758370],[250910,757950],[241320,757980],[240600,757640],[234570,757640],[234590,751880],[233380,750040],[233370,746950],[230150,746950],[230130,743610],[229620,743370],[229620,738220],[231920,735030],[232270,734140],[232250,733780],[232760,733250],[233020,732400],[233050,731380]] };
$maps{"H:107"} = { bbox => [[218990, 697180], [265750, 734640]], area => '1413.03645', series => 'H', number => '107', parent => 'H:107', title => 'Southern Highlands', polygon => [[265750,723380],[258830,723380],[258830,724320],[258220,725380],[258220,733480],[257860,733480],[257410,734190],[253760,734190],[252850,733830],[250980,734140],[248950,733070],[247990,733380],[242320,733380],[241770,733780],[239280,733880],[238780,734240],[238630,734640],[232100,734640],[232250,734240],[231290,734240],[231340,733930],[225620,733930],[225670,730740],[224600,729880],[224000,730090],[224050,715960],[222930,715960],[218990,713230],[219040,709790],[219540,709690],[219540,705380],[219040,705230],[219040,704120],[219590,703920],[219590,700570],[226630,700570],[229360,699110],[230830,699110],[231390,697640],[251540,697690],[250880,697180],[253660,697180],[253510,697590],[254420,697640],[254420,698850],[255480,699410],[258820,699410],[258770,701480],[258320,701640],[258270,704420],[259030,704980],[259030,705010],[264990,705020],[265000,709440],[263950,710170],[263910,711350],[264700,712380],[264700,713470],[265190,713620],[265490,713570],[265750,713840],[265750,723380]] };
$maps{"H:107.a"} = { bbox => [[201700, 725560], [215670, 734430]], area => '90.81445', series => 'H', number => '107', parent => 'H:107', title => 'Southern Highlands', polygon => [[213610,733710],[212180,733670],[210700,733850],[206580,733850],[205600,734430],[204010,734420],[201700,733240],[201700,731090],[202170,730870],[202660,730180],[203200,729210],[204080,728910],[204580,728260],[205190,727640],[206170,727070],[206960,726810],[208290,725560],[212620,725560],[212280,726210],[212470,726440],[212670,726880],[213190,727020],[214430,727710],[214630,729050],[215670,730630],[215670,733620],[214660,733440],[213610,733710]] };
$maps{"H:201"} = { bbox => [[308770, 493480], [351060, 532660]], area => '1371.05195', series => 'H', number => '201', parent => 'H:201', title => 'Lake District', polygon => [[351060,515750],[351060,516310],[350610,516540],[350550,524090],[349370,525500],[349370,527420],[349990,528320],[348690,528610],[343730,527360],[340910,527870],[339160,527200],[336960,527360],[336790,529900],[333090,529900],[333090,532660],[328860,532660],[328860,532210],[325180,532210],[325180,532640],[324190,532640],[324190,529900],[316550,529900],[316560,519090],[313300,519090],[313300,518650],[309830,518650],[309830,519070],[308770,519070],[308770,510540],[308770,510510],[312150,510520],[312100,493480],[350610,493480],[350610,510220],[350830,510900],[350610,511070],[350610,515410],[351060,515750]] };
$maps{"H:202"} = { bbox => [[364930, 451060], [406940, 509070]], area => '1804.7495', series => 'H', number => '202', parent => 'H:202', title => 'Yorkshire Dales', polygon => [[404260,478190],[404260,490790],[405120,490490],[405120,499150],[404310,499200],[404310,509070],[377180,509070],[377130,507750],[376470,506740],[375860,506490],[375860,506130],[373690,504560],[373230,504660],[372780,504360],[371660,504510],[370500,505270],[369080,504870],[367860,505120],[367360,504820],[365590,505020],[365590,493630],[364930,493220],[364930,490740],[369990,490790],[369990,478240],[368420,478240],[368410,468770],[369210,468780],[374150,468790],[375910,467610],[378120,466870],[379860,463080],[381430,461690],[381530,460520],[393180,460570],[393230,455970],[396160,455970],[398140,454090],[398140,451060],[406940,451110],[406940,478190],[404260,478190]] };
$maps{"H:203"} = { bbox => [[443450, 481050], [501830, 516280]], area => '1399.0172', series => 'H', number => '203', parent => 'H:203', title => 'North York Moors', polygon => [[492520,501550],[492520,508310],[480340,508310],[478140,508940],[477940,508940],[477940,509340],[477060,509840],[476790,510160],[476700,511860],[475880,512670],[475910,512840],[474380,512760],[473960,512470],[473400,512470],[472570,512320],[471120,511700],[470440,511890],[469310,512860],[468600,513000],[468160,513520],[465860,514760],[465650,515120],[465340,514660],[464780,515710],[463540,515890],[463140,516280],[462830,516210],[460510,516210],[460050,515950],[459130,515900],[458420,515660],[458550,515370],[458120,514730],[458010,514340],[457730,514100],[457180,513090],[457080,512640],[456510,512300],[456540,511920],[456540,511910],[456400,511430],[456400,510820],[456510,510550],[456510,509800],[457220,508960],[457290,508670],[457620,508590],[458010,506630],[458220,506420],[457420,506420],[457210,506770],[455630,506770],[453710,505820],[452240,505680],[451050,505090],[450420,505230],[449090,504070],[448110,502500],[446460,501800],[444920,500440],[444290,498550],[444330,497320],[444080,497080],[444120,496380],[443450,494170],[444010,493580],[446080,492600],[447060,490950],[445900,490500],[446010,490080],[446810,489900],[447020,487350],[446780,487070],[446850,486680],[447370,486580],[447790,486090],[448840,486580],[449090,485210],[449370,482030],[449020,481610],[449090,481050],[452340,481080],[452900,481640],[456370,481640],[457140,481150],[458960,481710],[461370,481710],[461720,482800],[461480,483880],[462070,483780],[464870,484440],[466730,485070],[467360,484550],[469350,486160],[470330,485980],[471800,485840],[472570,485980],[474670,485210],[475550,485420],[476530,485910],[477540,485810],[479220,484090],[481920,482900],[484230,483220],[486460,482870],[489470,483180],[493150,481990],[493150,482010],[494650,482070],[501830,486570],[501830,501550],[492520,501550]] };
$maps{"H:204"} = { bbox => [[392960, 369730], [431390, 406200]], area => '1122.6812', series => 'H', number => '204', parent => 'H:204', title => 'Dark Peak', polygon => [[397340,402340],[397400,396970],[397400,397030],[398150,396450],[398090,395010],[398610,394200],[398780,394430],[398550,392470],[399070,391890],[398730,390280],[398960,389990],[398550,388830],[398670,388430],[398210,387100],[398550,386240],[397920,385490],[397920,384790],[394170,385600],[394400,384500],[394170,383810],[394280,382660],[394800,381330],[393940,380060],[393590,378730],[393010,378330],[392960,377000],[393990,376250],[393990,369730],[431390,369730],[431390,377170],[430930,377640],[430870,380460],[430580,383000],[430700,386520],[428850,386700],[428800,389870],[428450,390680],[426780,390850],[426550,393910],[424700,394550],[424290,395870],[424350,396620],[424010,396970],[424180,397490],[423370,398700],[424120,399510],[422040,400370],[420890,400370],[419790,401360],[419500,403320],[418290,403720],[418000,403490],[416910,404700],[415000,405400],[414710,406200],[397980,406200],[397920,402970],[397340,402340]] };
$maps{"H:205"} = { bbox => [[392820, 346370], [432800, 387150]], area => '1199.44615', series => 'H', number => '205', parent => 'H:205', title => 'White Peak', polygon => [[432800,368450],[432560,368230],[432560,368240],[431740,368500],[431440,368600],[431430,368790],[431410,369720],[431410,370930],[431360,370930],[431450,377150],[430940,377750],[430890,380540],[430640,383220],[418130,383220],[417630,383880],[417510,383880],[417510,386590],[415680,386590],[415660,387150],[408420,387150],[408410,384030],[408410,383280],[394240,383370],[394240,382770],[394790,381250],[393950,380070],[393590,378730],[393010,378340],[392920,377050],[394020,376260],[393930,367430],[392820,367380],[392870,365150],[393230,364800],[393280,363480],[395660,363480],[395600,362620],[395200,362420],[395250,360390],[398440,355480],[399250,356190],[403550,353100],[406640,350920],[410180,349810],[410640,349050],[413520,348340],[414940,346770],[416820,346770],[416820,346370],[419090,346370],[420210,349100],[421620,349150],[422590,349760],[423850,349510],[425520,349660],[426430,350820],[426690,352650],[427110,353140],[428570,353140],[428880,354780],[429480,356960],[429990,360180],[429460,360380],[429410,361590],[429660,361970],[429690,362880],[430340,363870],[430710,365100],[431700,365100],[431780,366160],[431810,366200],[431980,366260],[432510,366420],[432510,366430],[432800,366430],[432800,368450]] };
$maps{"H:206"} = { bbox => [[246910, 56000], [285050, 96200]], area => '1057.0787', series => 'H', number => '206', parent => 'H:206', title => 'Dartmoor', polygon => [[284340,85410],[284310,86670],[283120,88330],[283120,88480],[282670,88950],[282570,89080],[282190,90060],[281850,90090],[281300,90850],[279720,90850],[279320,91650],[278630,93270],[277580,93880],[276510,93930],[274720,93380],[273190,92510],[271450,92500],[270200,93000],[269910,92920],[269260,93520],[268990,93780],[268750,94370],[267320,94840],[266530,95740],[265370,96200],[264240,95910],[264240,95220],[258210,95220],[257980,95190],[257980,94680],[257140,93920],[256320,93130],[250230,88560],[250510,87940],[250150,87070],[251020,86250],[249750,83290],[248740,82870],[246910,80590],[246910,79290],[247360,79120],[247300,68910],[247580,68890],[247780,68290],[249920,68130],[250320,67420],[250090,65310],[250600,62400],[251530,62520],[252570,61920],[258490,61110],[260130,58600],[260470,56710],[262440,56710],[262970,56000],[265770,56000],[267290,56710],[268440,57530],[269540,58960],[270870,59360],[272470,60710],[273520,65170],[274930,65620],[274810,68460],[284290,76360],[284290,80750],[285050,80530],[285050,83770],[284340,85410]] };
$maps{"H:301"} = { bbox => [[248240, 336950], [287850, 374560]], area => '1111.581', series => 'H', number => '301', parent => 'H:301', title => 'Snowdonia North', polygon => [[253720,336970],[262240,336950],[262280,337540],[287250,337540],[287250,340480],[287850,340290],[287850,351080],[287760,351330],[286770,351410],[285830,351210],[285100,351430],[284910,352330],[285010,352550],[285660,353290],[285120,354090],[285040,354430],[284690,354680],[284270,355360],[283880,355800],[283770,356160],[283420,356530],[282450,358050],[282380,358440],[281970,358930],[281860,359380],[281600,359560],[281130,360650],[280890,360530],[280640,361140],[279800,362070],[279170,364400],[279230,365160],[279110,366050],[278530,367070],[278300,367800],[278430,368130],[278320,369420],[278520,370610],[279050,371680],[279470,371920],[279710,372210],[279750,372550],[278320,373950],[277070,373900],[276970,374150],[276010,374560],[267060,374470],[266530,373950],[262540,373910],[262270,373240],[261810,372810],[260380,372740],[260230,372340],[260230,371130],[259870,370910],[259930,369960],[259490,369670],[259480,369450],[259830,369090],[260150,368280],[259850,366230],[260010,366040],[260000,365760],[259540,365480],[259280,365150],[258470,364720],[258020,364870],[257080,364580],[256830,364010],[256370,364060],[255890,364080],[255410,363850],[253790,363890],[253210,363480],[253220,363160],[253410,362980],[253450,362820],[253190,361470],[253190,355760],[249920,355750],[249390,355420],[249130,354980],[249150,354670],[248920,354280],[248240,353860],[248250,343530],[249950,342970],[250640,342950],[251480,342100],[251260,341610],[251620,340650],[252160,340680],[253280,340320],[253770,340060],[253830,339510],[253560,338450],[253510,337790],[253720,336970]] };
$maps{"H:302"} = { bbox => [[255970, 295740], [296130, 340900]], area => '1297.0166', series => 'H', number => '302', parent => 'H:302', title => 'Snowdonia South', polygon => [[261460,340300],[261460,336250],[260730,334880],[260890,334650],[260910,334230],[260200,333910],[260000,333200],[260080,332830],[259710,332230],[258940,331590],[258100,331540],[257440,329390],[257800,328860],[257760,328420],[258580,326750],[258330,326310],[258480,325840],[258460,325380],[258540,323940],[258650,323490],[258750,323220],[258680,322190],[259010,321530],[259440,320490],[259340,320090],[259800,319320],[259840,318980],[259490,318900],[259490,316170],[260720,314590],[260700,312460],[259040,310510],[257130,310500],[257140,307540],[256530,306430],[256530,304750],[256090,304750],[256100,304350],[255970,304150],[255970,295740],[265620,295740],[265800,296050],[266240,295990],[266780,296090],[267500,296990],[268520,297210],[268950,296630],[269310,296670],[269670,297060],[269740,297560],[270530,297690],[270850,297870],[271450,298820],[272150,298960],[272620,299010],[272950,299210],[273450,299290],[274080,299440],[274250,299790],[274770,299820],[274770,300440],[275370,300440],[275370,303900],[278110,303900],[278120,306100],[278260,306320],[278500,306380],[280650,306380],[281000,306690],[281190,307340],[281310,309280],[281680,309580],[284380,309720],[284810,309910],[286110,309980],[286230,310920],[287130,311480],[288520,311830],[290240,311960],[291180,312360],[291180,322110],[295530,322110],[295530,327990],[296130,327700],[296130,333200],[295670,333510],[295530,333710],[295530,336060],[293900,335480],[293750,335660],[293370,335940],[292760,336850],[292160,336910],[291840,337970],[291840,337980],[291830,337990],[291820,337990],[291810,338000],[291800,338010],[291790,338030],[291770,338040],[291760,338050],[291740,338070],[291720,338090],[291710,338100],[291690,338120],[291660,338140],[291640,338160],[291620,338180],[291600,338200],[291570,338230],[291550,338250],[291530,338270],[291500,338290],[291480,338320],[291450,338340],[291420,338370],[291400,338390],[291370,338410],[291350,338440],[291320,338460],[291300,338480],[291270,338510],[291250,338530],[291220,338550],[291200,338570],[291180,338590],[291160,338620],[291130,338640],[291110,338650],[291090,338670],[291080,338690],[291060,338710],[291040,338720],[291030,338730],[291010,338750],[291000,338760],[290990,338770],[290980,338780],[290970,338780],[290970,338790],[290960,338790],[290960,338800],[290950,338810],[290950,338820],[290940,338820],[290940,338830],[290940,338840],[290930,338840],[290930,338850],[290920,338860],[290920,338870],[290920,338880],[290910,338890],[290910,338900],[290900,338910],[290900,338920],[290900,338930],[290890,338940],[290890,338950],[290890,338960],[290880,338970],[290880,338980],[290870,338990],[290870,339000],[290870,339010],[290860,339020],[290860,339030],[290860,339050],[290850,339060],[290850,339070],[290850,339080],[290840,339090],[290840,339100],[290840,339110],[290830,339120],[290830,339130],[290830,339140],[290830,339150],[290820,339150],[290820,339160],[290820,339170],[290820,339180],[290850,339500],[291140,339800],[291300,340460],[287250,340480],[286460,340900],[284580,340820],[284670,340540],[284590,340300],[268740,340300],[268510,340540],[267840,340870],[266630,340710],[266380,340900],[265970,340750],[265640,340320],[261460,340300]] };
$maps{"H:303"} = { bbox => [[267110, 205000], [323330, 230970]], area => '929.10525', series => 'H', number => '303', parent => 'H:303', title => 'Brecon Beacons', polygon => [[277090,229570],[276730,228890],[276680,228890],[276990,228130],[276610,227830],[277160,226990],[277210,225450],[276580,224940],[276100,224380],[274130,223680],[272860,221930],[271340,221270],[269870,221200],[268710,220540],[268080,219830],[267390,219630],[267420,217750],[267110,217200],[267110,216160],[267270,216080],[267290,213860],[268680,213170],[268680,213400],[269540,213480],[269850,213370],[270680,213830],[271140,213730],[271420,214390],[274100,213860],[275900,210970],[279040,211020],[279490,211600],[280120,211550],[280250,211830],[281010,212560],[281620,212540],[282200,212690],[282810,212260],[284480,211580],[286530,209700],[286880,209750],[287460,209270],[289460,208740],[289720,207830],[289490,207430],[288530,206720],[288730,206290],[289460,207170],[291590,207730],[292320,207120],[294500,206160],[295130,205380],[296150,205000],[298780,206010],[299010,206720],[299310,206720],[300140,207000],[300780,207430],[302730,207100],[303890,206570],[304780,205120],[306090,205020],[306420,206950],[307590,207650],[308520,208670],[310850,209530],[311610,210060],[313580,210770],[314770,211530],[316120,211780],[316240,211980],[318650,212970],[319380,212820],[319840,212060],[320980,212390],[321410,212440],[321890,212790],[322620,212740],[323300,213650],[323330,215960],[323050,216310],[322850,217200],[321660,217980],[321860,218640],[319680,219850],[318980,219550],[317790,219750],[316950,219520],[316320,220110],[315260,220130],[315030,221900],[314340,222410],[314090,222110],[313050,222410],[311810,224180],[310700,224940],[310240,227800],[307710,227800],[307080,229830],[307160,230260],[306830,229980],[305230,230080],[305000,230710],[304070,230810],[303410,230970],[302520,230760],[301740,230760],[301590,230480],[300600,230380],[299920,229780],[295840,229780],[295010,230210],[293970,230540],[292750,230610],[292400,230380],[291340,230310],[290200,229500],[288830,229500],[287920,230030],[286350,230130],[285720,230760],[283310,230760],[282760,230910],[282330,230760],[277090,230760],[277090,229570]] };
$maps{"J:101"} = { bbox => [[208700, 908178], [233057, 925442]], area => '366.717181', series => 'J', number => '101', parent => 'J:101', title => 'Suilven', polygon => [[208711,922739],[208764,922771],[208700,919288],[209064,919181],[209042,908178],[220708,908178],[220686,910784],[232459,910827],[232480,912430],[233015,912899],[233057,920848],[232545,920869],[232545,924950],[221862,924993],[221221,925441],[214982,925442],[208711,922739]] };
$maps{"J:102"} = { bbox => [[194910, 868472], [212436, 892470]], area => '342.0976655', series => 'J', number => '102', parent => 'J:102', title => 'An Teallach', polygon => [[195419,892470],[195419,892397],[195419,891937],[194910,891913],[194910,889295],[195395,889513],[195370,872908],[195152,872787],[195152,871308],[195370,871066],[195370,868981],[203176,868933],[203079,868472],[204097,868472],[204412,868981],[209551,868981],[209599,880762],[211902,880738],[212217,880956],[212217,882434],[212436,882847],[212436,884640],[212072,884761],[212048,885513],[211684,886143],[211975,886701],[211393,888276],[209769,889367],[209115,889246],[208000,890119],[203952,890822],[202934,892446],[195419,892470]] };
$maps{"J:103"} = { bbox => [[178437, 855346], [207313, 881656]], area => '582.133514', series => 'J', number => '103', parent => 'J:103', title => 'Torridon', polygon => [[203384,855597],[203388,859306],[204671,861153],[207313,861153],[207313,867498],[204416,867498],[204415,873527],[203195,873527],[201881,874470],[201881,875303],[198740,875303],[198739,878843],[191287,878843],[191267,879093],[190318,879093],[190317,881656],[184992,881656],[184992,879094],[183900,879094],[183662,878843],[178690,878843],[178690,870395],[178689,870237],[179109,870237],[179110,870237],[179110,870237],[179112,870237],[179113,870237],[179115,870237],[179118,870237],[179121,870237],[179124,870237],[179128,870236],[179131,870236],[179136,870235],[179140,870234],[179145,870234],[179150,870233],[179155,870232],[179161,870230],[179166,870229],[179172,870228],[179178,870226],[179184,870224],[179190,870222],[179196,870219],[179203,870217],[179209,870214],[179215,870211],[179222,870208],[179228,870204],[179234,870200],[179240,870196],[179247,870192],[179253,870187],[179259,870182],[179264,870177],[179270,870171],[179275,870165],[179281,870158],[179286,870152],[179290,870144],[179295,870137],[179299,870129],[179303,870121],[179307,870112],[179310,870103],[179313,870093],[179315,870083],[179317,870073],[179319,870062],[179320,870050],[179321,870026],[179321,870026],[179321,870013],[179321,870001],[179322,869988],[179323,869976],[179323,869964],[179324,869953],[179326,869941],[179327,869930],[179329,869918],[179331,869907],[179333,869897],[179335,869886],[179337,869875],[179340,869865],[179343,869855],[179346,869845],[179349,869835],[179353,869826],[179356,869816],[179360,869807],[179365,869798],[179369,869789],[179374,869781],[179378,869772],[179384,869764],[179389,869756],[179394,869748],[179400,869741],[179406,869733],[179413,869726],[179419,869719],[179426,869712],[179433,869706],[179440,869699],[179448,869693],[179455,869687],[179463,869681],[179472,869676],[179480,869670],[179489,869665],[179498,869660],[179507,869656],[179517,869651],[179527,869647],[179537,869643],[179547,869639],[179558,869635],[179569,869632],[179592,869626],[179592,869626],[179603,869623],[179615,869620],[179628,869617],[179640,869613],[179653,869610],[179666,869606],[179679,869603],[179692,869599],[179706,869595],[179719,869591],[179733,869587],[179747,869583],[179761,869578],[179775,869574],[179789,869569],[179803,869565],[179818,869560],[179832,869556],[179847,869551],[179861,869546],[179876,869542],[179890,869537],[179904,869532],[179919,869527],[179933,869522],[179948,869517],[179962,869513],[179976,869508],[179990,869503],[180004,869498],[180018,869493],[180032,869489],[180046,869484],[180059,869479],[180072,869474],[180086,869470],[180099,869465],[180111,869461],[180124,869456],[180136,869452],[180148,869448],[180160,869444],[180172,869440],[180183,869436],[180194,869432],[180205,869428],[180215,869424],[180225,869421],[180244,869414],[180244,869414],[180253,869411],[180263,869408],[180272,869405],[180281,869402],[180291,869400],[180300,869397],[180310,869395],[180319,869392],[180329,869390],[180338,869388],[180348,869386],[180357,869384],[180367,869382],[180376,869380],[180386,869378],[180395,869377],[180405,869375],[180414,869373],[180424,869372],[180433,869371],[180443,869369],[180452,869368],[180462,869367],[180471,869366],[180480,869365],[180489,869364],[180499,869363],[180508,869362],[180517,869362],[180526,869361],[180535,869360],[180543,869360],[180552,869359],[180561,869359],[180570,869358],[180578,869358],[180586,869357],[180595,869357],[180603,869357],[180611,869356],[180619,869356],[180627,869356],[180635,869356],[180642,869356],[180650,869356],[180657,869356],[180664,869356],[180671,869355],[180685,869355],[180685,869355],[180692,869355],[180698,869355],[180705,869355],[180712,869354],[180718,869354],[180724,869353],[180731,869352],[180737,869352],[180743,869350],[180749,869349],[180755,869348],[180761,869347],[180767,869345],[180773,869344],[180779,869342],[180785,869340],[180790,869338],[180796,869336],[180802,869334],[180807,869332],[180813,869330],[180818,869327],[180823,869325],[180828,869322],[180834,869319],[180839,869317],[180844,869314],[180849,869311],[180854,869308],[180858,869305],[180863,869301],[180868,869298],[180872,869295],[180877,869291],[180881,869288],[180886,869284],[180890,869280],[180894,869277],[180898,869273],[180902,869269],[180906,869265],[180910,869261],[180914,869257],[180917,869253],[180921,869248],[180925,869244],[180928,869240],[180931,869235],[180938,869226],[180938,869226],[180941,869221],[180944,869217],[180948,869212],[180951,869207],[180954,869202],[180958,869197],[180961,869191],[180964,869186],[180968,869180],[180971,869175],[180975,869169],[180979,869164],[180982,869158],[180986,869152],[180990,869147],[180994,869141],[180998,869135],[181002,869129],[181006,869123],[181010,869117],[181014,869111],[181018,869105],[181022,869100],[181027,869094],[181031,869088],[181036,869082],[181040,869076],[181045,869071],[181050,869065],[181055,869059],[181060,869054],[181065,869048],[181070,869043],[181075,869037],[181081,869032],[181086,869027],[181091,869022],[181097,869017],[181103,869012],[181109,869007],[181115,869003],[181121,868998],[181127,868994],[181133,868990],[181139,868985],[181146,868982],[181153,868978],[181159,868974],[181173,868967],[181173,868967],[181180,868964],[181188,868961],[181195,868958],[181202,868955],[181210,868953],[181217,868950],[181225,868947],[181233,868945],[181241,868942],[181248,868940],[181256,868937],[181264,868935],[181272,868932],[181279,868929],[181287,868927],[181295,868924],[181303,868922],[181310,868919],[181318,868916],[181325,868913],[181333,868910],[181340,868907],[181347,868904],[181354,868901],[181361,868898],[181368,868894],[181375,868890],[181381,868887],[181388,868883],[181394,868878],[181400,868874],[181405,868870],[181411,868865],[181416,868860],[181421,868855],[181426,868849],[181431,868844],[181435,868838],[181439,868832],[181443,868825],[181446,868819],[181449,868812],[181452,868804],[181454,868797],[181456,868789],[181458,868781],[181459,868772],[181460,868763],[181461,868744],[181461,868744],[181461,868734],[181461,868724],[181461,868714],[181461,868703],[181461,868693],[181461,868682],[181461,868672],[181461,868661],[181461,868650],[181461,868639],[181461,868629],[181461,868618],[181461,868607],[181461,868596],[181461,868586],[181461,868575],[181461,868564],[181461,868554],[181461,868543],[181461,868533],[181461,868523],[181461,868513],[181461,868503],[181461,868493],[181461,868484],[181461,868474],[181461,868465],[181461,868456],[181461,868448],[181461,868439],[181461,868431],[181461,868423],[181461,868416],[181461,868408],[181461,868401],[181461,868395],[181461,868389],[181461,868383],[181461,868377],[181461,868372],[181461,868368],[181461,868363],[181461,868360],[181461,868356],[181461,868353],[181461,868351],[181461,868349],[181461,868348],[181461,868347],[181461,868347],[181461,868347],[181461,867504],[181461,861424],[178688,861423],[178688,859752],[178437,859754],[178437,857755],[178688,857755],[178688,855598],[189145,855598],[189144,855347],[192060,855346],[192257,855598],[203384,855597]] };
$maps{"J:104"} = { bbox => [[138489, 843197], [152989, 877154]], area => '337.09833', series => 'J', number => '104', parent => 'J:104', title => 'Skye: Trotternish', polygon => [[146527,853853],[147219,853853],[147219,853803],[147219,853803],[147219,853803],[147219,853803],[147217,853443],[146977,853443],[146977,843298],[147636,843298],[147636,843198],[147618,843198],[147618,843197],[149676,843197],[149676,843198],[149652,843198],[149652,843298],[150766,843298],[150766,844190],[151037,844190],[151856,844605],[152302,844605],[152302,851097],[152689,851097],[152689,851639],[152302,851639],[152302,853443],[152294,853488],[152294,853753],[152294,853753],[152294,853853],[152764,853853],[152764,862178],[152989,862178],[152989,863280],[152820,863280],[152820,863280],[152764,863280],[152764,865910],[152820,865910],[152820,865912],[152820,865912],[152820,866553],[152036,867192],[150869,869687],[149124,872540],[147830,874070],[147830,874909],[147189,874909],[147189,875422],[145812,875422],[145812,876908],[144519,876908],[144519,877154],[140139,877154],[140139,876908],[140101,876908],[140101,874854],[139387,874854],[139387,874398],[138739,874398],[138720,870485],[138730,870377],[138739,870327],[138739,868654],[138693,868504],[138689,868474],[138689,868447],[138717,868064],[138715,867854],[138689,867611],[138689,867526],[138713,867497],[138739,867485],[138739,865864],[138736,865843],[138711,865782],[138670,865726],[138594,865569],[138526,865384],[138518,865332],[138531,865289],[138543,865257],[138608,865048],[138616,865008],[138619,864969],[138619,864850],[138489,864850],[138489,861217],[138511,861161],[138639,861212],[138639,861212],[138739,861252],[138739,857821],[138906,857821],[139111,857771],[139111,857771],[139111,857770],[139114,857765],[139386,857504],[139593,857370],[139649,857316],[139680,857280],[139704,857249],[139704,857249],[139704,857249],[139741,857160],[139790,856970],[139824,856873],[139861,856805],[139933,856648],[139932,856647],[140066,856340],[140128,856128],[140130,856097],[140128,856072],[140122,856046],[140064,855867],[140055,855814],[140046,855734],[140045,855679],[140113,855061],[140127,855015],[140149,854962],[140298,854703],[140405,854475],[140449,854406],[140552,854303],[140578,854273],[140578,854273],[140578,854273],[140623,854186],[140713,853955],[140743,853901],[140769,853860],[140774,853853],[146527,853853]] };
$maps{"J:105"} = { bbox => [[140500, 816094], [164552, 833094]], area => '346.9283735', series => 'J', number => '105', parent => 'J:105', title => 'Skye: Cuillin', polygon => [[164485,823373],[164552,823363],[164552,826611],[164551,826612],[164550,826613],[164548,826614],[164304,826760],[164303,826760],[164303,826761],[164303,826762],[164302,826763],[164302,826763],[164301,826764],[163660,827120],[163533,827171],[163245,827253],[162537,827366],[162372,827378],[162370,827378],[162369,827379],[162366,827380],[162363,827382],[162348,827394],[162322,827418],[161989,827826],[161982,827832],[161975,827837],[161968,827840],[161962,827839],[161959,827833],[161958,827823],[161959,827810],[161970,827739],[161970,827723],[161968,827706],[161964,827691],[161958,827677],[161949,827665],[161937,827655],[161900,827637],[161874,827627],[161847,827621],[161834,827620],[161819,827620],[161811,827620],[161804,827622],[161797,827624],[161790,827626],[161783,827630],[161761,827646],[161755,827649],[161748,827652],[161742,827654],[161735,827654],[161729,827653],[161723,827650],[161718,827647],[161714,827642],[161710,827636],[161704,827624],[161694,827598],[161687,827585],[161683,827578],[161678,827572],[161672,827567],[161666,827562],[161661,827558],[161655,827555],[161650,827553],[161644,827551],[161637,827550],[161631,827549],[161625,827549],[161619,827551],[161616,827552],[161614,827553],[161603,827559],[161601,827560],[161597,827562],[161594,827562],[161591,827563],[161584,827563],[161577,827562],[161558,827558],[161543,827553],[161529,827547],[161435,827491],[161377,827463],[161346,827451],[161315,827443],[161283,827438],[161252,827437],[161221,827441],[161185,827452],[161151,827467],[161118,827485],[161087,827507],[161058,827532],[161005,827586],[160975,827623],[160961,827638],[160953,827644],[160946,827649],[160937,827654],[160927,827658],[160917,827662],[160892,827669],[160841,827677],[160516,827686],[160495,827689],[160482,827693],[160457,827702],[160433,827715],[160410,827729],[160343,827780],[160292,827828],[159200,829092],[159118,829167],[159072,829200],[158948,829273],[158371,829543],[158254,829618],[158146,829709],[158097,829760],[158017,829862],[157950,829973],[157896,830091],[157852,830213],[157794,830457],[157711,831122],[157653,833094],[140505,833094],[140503,833093],[140501,833092],[140501,833090],[140501,816116],[140500,816102],[140500,816099],[140501,816096],[140503,816095],[140506,816094],[157193,816094],[157218,816250],[157235,816319],[157262,816393],[157290,816450],[157428,816666],[157538,816870],[157639,817125],[157905,818217],[157994,818457],[158049,818567],[158115,818671],[158154,818719],[158204,818770],[158259,818816],[158319,818855],[158382,818889],[158447,818919],[158584,818964],[158760,818999],[159021,819027],[161391,819035],[161523,819053],[161653,819081],[161763,819114],[161856,819150],[161944,819195],[162027,819250],[162084,819298],[162118,819334],[162149,819373],[162177,819415],[162201,819462],[162223,819514],[162664,821414],[162688,821493],[162705,821529],[162723,821563],[162844,821745],[162865,821770],[162876,821780],[162888,821790],[162901,821799],[162915,821805],[162929,821810],[162945,821812],[162960,821811],[162971,821808],[162981,821805],[162991,821801],[163044,821769],[163052,821766],[163059,821764],[163066,821763],[163073,821763],[163081,821763],[163088,821765],[163096,821767],[163111,821773],[163125,821780],[163152,821797],[163158,821802],[163163,821808],[163167,821814],[163171,821821],[163196,821881],[163204,821896],[163209,821903],[163215,821909],[163227,821920],[163239,821929],[163296,821962],[163323,821981],[163335,821991],[163346,822003],[163356,822016],[163366,822030],[163393,822084],[163542,822276],[163558,822306],[163569,822331],[163605,822464],[163615,822489],[163630,822512],[163896,822814],[163906,822829],[163910,822836],[163914,822844],[163916,822852],[163918,822861],[163919,822869],[163920,822908],[163921,822915],[163923,822923],[163927,822930],[163934,822943],[163943,822956],[163954,822968],[163965,822978],[163977,822988],[163990,822996],[164004,823003],[164028,823012],[164032,823014],[164035,823016],[164038,823019],[164040,823022],[164041,823025],[164047,823058],[164049,823060],[164055,823062],[164071,823065],[164158,823072],[164301,823067],[164301,823439],[164396,823415],[164401,823413],[164402,823412],[164402,823412],[164402,823411],[164402,823410],[164402,823409],[164402,823409],[164403,823408],[164478,823387],[164480,823386],[164482,823385],[164483,823384],[164484,823382],[164484,823381],[164485,823373]] };
$maps{"J:106"} = { bbox => [[191327, 806094], [214875, 823788]], area => '332.9440065', series => 'J', number => '106', parent => 'J:106', title => 'Kintail, Glen Shiel', polygon => [[203035,823393],[203062,823366],[201981,823393],[202086,823788],[200688,823788],[200319,823366],[198236,823366],[195388,821389],[191776,820176],[192250,818119],[191327,817697],[191327,812740],[191986,812397],[191934,808811],[195520,806094],[198605,806147],[199502,806648],[207360,806622],[207913,806226],[209232,806622],[210287,806648],[210287,809206],[214875,809206],[214822,820835],[203035,820835],[203035,823393]] };
$maps{"J:107"} = { bbox => [[172394, 792725], [196390, 809760]], area => '355.696933', series => 'J', number => '107', parent => 'J:107', title => 'Knoydart', polygon => [[172473,809708],[172420,809760],[172394,793227],[184181,793200],[184181,794914],[186290,794914],[189428,793833],[189428,793121],[192909,793095],[193120,792725],[196311,792778],[196337,793938],[195889,794017],[195889,799792],[196337,800056],[196311,801454],[195889,801506],[195889,804908],[196364,804038],[196390,806938],[195889,806596],[195889,807228],[184155,807308],[184181,809734],[172473,809708]] };
$maps{"J:108"} = { bbox => [[119744, 789982], [142862, 807000]], area => '257.328422', series => 'J', number => '108', parent => 'J:108', title => 'Rum, Eigg, Canna, Muck', polygon => [[119745,805416],[119744,804100],[120294,804100],[120294,803485],[126149,803484],[128624,801010],[128623,796427],[130596,796427],[130596,795083],[131209,795083],[131209,789982],[142862,789982],[142862,806897],[124394,806898],[124394,807000],[123494,807000],[123494,806901],[120294,806901],[120294,805416],[119745,805416]] };
$maps{"J:108.a"} = { bbox => [[138442, 777935], [143156, 781877]], area => '18.582588', series => 'J', number => '108', parent => 'J:108', title => 'Rum, Eigg, Canna, Muck', polygon => [[143156,777935],[143156,781877],[138442,781877],[138442,777935],[143156,777935]] };
$maps{"J:108.b"} = { bbox => [[143571, 782596], [150057, 791490]], area => '57.686484', series => 'J', number => '108', parent => 'J:108', title => 'Rum, Eigg, Canna, Muck', polygon => [[150057,782596],[150057,791490],[143571,791490],[143571,782596],[150057,782596]] };
$maps{"J:109"} = { bbox => [[300474, 788169], [317797, 811694]], area => '320.794539', series => 'J', number => '109', parent => 'J:109', title => 'Ben Avon', polygon => [[301020,802792],[301052,802631],[300474,802953],[300474,799450],[301052,799739],[301020,793857],[300506,793793],[300506,789069],[301084,788651],[301084,788169],[315193,788201],[315161,799964],[317732,799964],[317797,807484],[311979,807452],[307834,807966],[306966,810570],[304073,810570],[303688,811694],[301020,811694],[301020,802792]] };
$maps{"J:110"} = { bbox => [[283971, 786845], [318821, 810385]], area => '712.549108', series => 'J', number => '110', parent => 'J:110', title => 'Cairn Gorm', polygon => [[318615,806079],[318615,806084],[318575,806084],[318575,808227],[305410,808228],[304366,808818],[304363,810157],[302964,810157],[302672,810257],[302674,810257],[302673,810257],[302599,810385],[298717,810385],[298717,810257],[298717,810257],[298717,810157],[295351,810157],[295322,810202],[295321,810202],[295288,810257],[295290,810257],[295289,810258],[295252,810311],[295217,810343],[295163,810373],[295133,810385],[293910,810385],[293699,810257],[293717,810257],[293534,810157],[289342,810157],[289360,810083],[289255,810017],[289219,809957],[289155,809873],[289100,809778],[289043,809699],[289008,809670],[288968,809629],[288944,809593],[288926,809540],[288922,809505],[288922,809474],[288915,809461],[288834,809474],[288807,809457],[288551,809082],[288494,808930],[288479,808899],[288479,808868],[288490,808848],[288505,808813],[288514,808771],[288509,808742],[288492,808720],[288472,808636],[288457,808608],[288437,808583],[288404,808561],[288342,808489],[288333,808409],[288273,808317],[288240,808290],[288201,808268],[288183,808246],[287910,807763],[287907,807732],[287824,807604],[287799,807554],[287769,807525],[287652,807342],[287519,807318],[287469,807324],[287405,807324],[287127,807181],[286940,807128],[286913,807097],[286893,807062],[286858,806967],[286779,806939],[286750,806921],[286662,806833],[286609,806808],[286496,806773],[286470,806753],[286435,806711],[286402,806606],[286221,806352],[285919,806004],[285859,805966],[285824,805922],[284073,805922],[284073,800613],[283974,800205],[283971,799910],[283974,799903],[283974,799936],[284074,799647],[284074,799637],[284376,798995],[284370,798995],[284639,798276],[284667,798106],[284689,797777],[284750,797623],[284836,797199],[284836,796991],[284904,796635],[284824,796100],[284732,795885],[284716,795723],[284762,795621],[284768,795458],[284695,795271],[284604,794899],[284624,794777],[284590,794417],[284409,794092],[284403,793806],[284252,793478],[284096,793275],[284073,793276],[284073,790913],[284851,790909],[284900,790869],[284965,790803],[285123,790678],[285160,790640],[285175,790569],[285201,790507],[285241,790487],[285295,790476],[285333,790459],[285366,790437],[285389,790387],[285401,790343],[285445,790301],[285504,790260],[285576,790257],[285624,790185],[285677,790157],[285736,790162],[285788,790178],[285824,790179],[285920,790097],[285998,790079],[286068,790079],[286117,790068],[286142,790013],[286143,789950],[286132,789873],[286136,789819],[286145,789782],[286139,789741],[286139,789698],[286155,789631],[286185,789551],[286227,789517],[286264,789509],[286291,789488],[286318,789389],[286362,789303],[286512,789145],[286574,789100],[286640,789078],[286736,789073],[286739,789073],[286739,787095],[294689,787095],[294806,786994],[294801,786994],[294803,786993],[294981,786845],[301325,786845],[301322,787021],[301323,787021],[301325,787094],[315658,787094],[315655,788233],[315710,788290],[315732,788327],[315754,788393],[315755,788372],[315757,788397],[315802,788544],[315830,788604],[315858,788908],[315880,789000],[315868,789308],[315824,789482],[315658,789866],[315658,792089],[315694,792159],[315724,792199],[315758,792217],[315758,792206],[315759,792207],[315759,792800],[315658,792825],[315658,798233],[318575,798233],[318575,802576],[318615,802575],[318615,802578],[318821,802575],[318821,806076],[318615,806079]] };
$maps{"J:111"} = { bbox => [[307737, 772244], [331455, 788442]], area => '336.742926', series => 'J', number => '111', parent => 'J:111', title => 'Lochnagar', polygon => [[307801,787928],[307737,787960],[307769,773787],[323356,773755],[324031,772887],[328338,772983],[329398,772244],[331327,772309],[331327,777258],[329752,777258],[329463,778511],[330555,779057],[330523,783461],[331455,784328],[331423,787928],[316189,787928],[316254,788410],[314100,788442],[314068,787928],[309055,787928],[308894,788345],[308669,788345],[308444,787896],[307801,787928]] };
$maps{"J:112"} = { bbox => [[209487, 759704], [239988, 782044]], area => '575.6229215', series => 'J', number => '112', parent => 'J:112', title => 'Ben Nevis, Mamores & Grey Corries', polygon => [[239988,775662],[239923,776009],[239912,776104],[239893,776166],[239867,776234],[239849,776272],[239847,776278],[239847,776334],[239842,776356],[239836,776369],[239832,776383],[239817,776407],[239739,776515],[239733,776528],[239727,776549],[239725,776559],[239730,776592],[239726,776614],[239717,776637],[239696,776674],[239677,776688],[239659,776693],[239649,776698],[239643,776702],[239629,776711],[239607,776733],[239571,776751],[239536,776764],[239508,776768],[239480,776769],[239394,776781],[239372,776787],[239298,776816],[239284,776824],[239276,776833],[239257,776871],[239247,776896],[239240,776917],[239224,776935],[239193,776985],[239172,777004],[239147,777021],[239101,777039],[239092,777044],[239086,777050],[239083,777057],[239081,777066],[239078,777105],[239071,777125],[239045,777158],[239040,777166],[239036,777181],[239025,777197],[239008,777208],[238946,777231],[238928,777240],[238908,777253],[238852,777276],[238841,777285],[238830,777296],[238813,777303],[238793,777306],[238773,777305],[238764,777306],[238742,777313],[238681,777327],[238642,777328],[238640,777329],[238627,777336],[238603,777344],[238590,777347],[238567,777360],[238539,777371],[238473,777377],[238452,777383],[238380,777411],[238360,777421],[238273,777507],[238256,777516],[238225,777513],[238217,777514],[238210,777517],[238201,777522],[238195,777526],[238182,777536],[238158,777544],[238141,777544],[238132,777546],[238088,777562],[238078,777567],[238072,777573],[238058,777585],[238044,777600],[238012,777620],[237999,777635],[237987,777646],[237969,777652],[237954,777649],[237914,777647],[237890,777640],[237778,777614],[237672,777615],[237607,777632],[237581,777643],[237557,777650],[237539,777653],[237522,777655],[237510,777658],[237498,777665],[237381,777706],[237348,777713],[237322,777721],[237305,777725],[237284,777728],[237259,777728],[237231,777727],[237226,777727],[237216,777732],[237184,777753],[237184,777758],[237163,777761],[237142,777769],[237140,777765],[237108,777770],[237078,777770],[237065,777774],[237051,777775],[236982,777772],[236942,777766],[236936,777767],[236923,777770],[236916,777773],[236884,777797],[236863,777807],[236835,777810],[236684,777813],[236655,777817],[236642,777817],[236633,777825],[236618,777824],[236590,777845],[236542,777864],[236524,777881],[236513,777904],[236493,777919],[236460,777940],[236421,777937],[236397,777938],[236363,777935],[236304,777908],[236273,777884],[236255,777866],[236244,777864],[236239,777864],[236219,777876],[236176,777881],[236141,777870],[236085,777873],[236054,777884],[236013,777903],[235922,777931],[235915,777931],[235907,777934],[235896,777954],[235878,777969],[235889,777988],[235894,778030],[235880,778062],[235836,778105],[235830,778115],[235831,778123],[235842,778152],[235847,778175],[235864,778204],[235898,778278],[235909,778360],[235895,778386],[235881,778398],[235878,778409],[235881,778430],[235885,778440],[235910,778450],[235876,778693],[235863,778748],[235856,778762],[235850,778789],[235828,778848],[235890,779093],[235977,779867],[235969,779949],[235943,780035],[235922,780079],[235897,780111],[235901,780119],[235823,780184],[235734,780230],[235642,780255],[235566,780258],[235547,780297],[235528,780286],[235524,780286],[235513,780303],[235480,780337],[235169,780529],[235079,780552],[235043,780614],[235014,780600],[235003,780599],[234990,780603],[234961,780623],[234826,780763],[234741,780828],[234439,780982],[234389,780990],[234344,780988],[234291,780980],[234252,780979],[234115,780996],[233960,781004],[233824,781028],[233399,781024],[233340,781013],[233246,780986],[233214,780970],[233155,780931],[233133,780921],[233018,780906],[232757,780799],[232732,780793],[232609,780786],[232583,780791],[232571,780798],[232531,780838],[232481,780870],[232420,780886],[232334,780901],[232120,780981],[232023,780992],[231909,780995],[231858,780991],[231834,780991],[231806,781000],[231721,781048],[231645,781079],[231580,781072],[231506,781052],[231453,781055],[231031,781216],[230950,781234],[230897,781232],[230849,781215],[230617,781065],[230559,781043],[230437,781013],[230354,781003],[230299,781003],[230271,781010],[230241,781034],[230195,781082],[230148,781124],[230091,781140],[230042,781143],[229996,781153],[229893,781187],[229836,781188],[229744,781174],[229692,781151],[229624,781107],[229575,781052],[229536,780999],[229483,780935],[229447,780908],[229386,780870],[229260,780760],[229195,780715],[229155,780694],[229133,780688],[229090,780687],[229035,780691],[228928,780688],[228645,780758],[228419,780789],[228357,780813],[228219,780879],[228160,780898],[228002,780932],[227926,780956],[227680,781111],[227633,781131],[227477,781143],[227377,781166],[226998,781388],[226972,781398],[226922,781407],[226847,781395],[226535,781314],[226472,781302],[226239,781278],[226180,781278],[226163,781283],[226127,781286],[226094,781283],[226072,781278],[226050,781275],[225995,781262],[225937,781263],[225838,781275],[225342,781424],[225142,781464],[225142,781468],[225117,781468],[225093,781472],[225092,781469],[225091,781469],[224960,781449],[224929,781447],[224912,781450],[224890,781456],[224814,781487],[224801,781493],[224624,781630],[224596,781643],[224519,781664],[224468,781682],[224279,781782],[224274,781782],[224271,781784],[224271,781783],[224074,781882],[224076,781882],[223978,781913],[223849,781937],[223849,781938],[223777,781950],[223777,781949],[223684,781962],[223517,781962],[223504,781963],[223488,781967],[223400,782010],[223358,782021],[223235,782043],[223188,782044],[223084,782026],[222728,781934],[222682,781918],[222608,781902],[222507,781897],[222460,781887],[222221,781802],[222218,781805],[222166,781841],[222102,781876],[222056,781894],[222007,781896],[221962,781887],[221925,781870],[221870,781838],[221850,781836],[221828,781837],[221815,781841],[221800,781851],[221771,781883],[221764,781882],[221581,781882],[221609,781866],[221702,781826],[221725,781802],[221749,781782],[214720,781782],[214665,781722],[214646,781693],[214642,781656],[214650,781631],[214695,781549],[214697,781537],[214697,781516],[214680,781448],[214673,781433],[214663,781415],[214644,781364],[214629,781339],[214601,781302],[214556,781230],[214547,781219],[214541,781214],[214533,781210],[214475,781190],[214435,781168],[214378,781144],[214357,781131],[214255,781051],[214236,781033],[214219,780987],[214211,780969],[214196,780947],[214189,780939],[214178,780932],[214138,780913],[214119,780895],[214105,780879],[214093,780867],[214055,780840],[213998,780788],[213979,780768],[213963,780746],[213949,780725],[213921,780673],[213911,780658],[213901,780631],[213896,780603],[213895,780581],[213894,780574],[213813,780433],[213802,780401],[213776,780378],[213758,780354],[213707,780249],[213703,780225],[213703,780212],[213692,780205],[213688,780203],[213665,780189],[213652,780175],[213638,780154],[213628,780132],[213620,780101],[213617,780094],[213613,780090],[213539,780030],[213517,780017],[213492,780006],[213467,779991],[213450,779969],[213439,779946],[213434,779917],[213432,779891],[213429,779875],[213414,779836],[213385,779780],[213382,779780],[213350,779770],[213326,779750],[213308,779733],[213293,779712],[213284,779689],[213274,779640],[213269,779590],[213266,779574],[213264,779570],[213259,779564],[213248,779555],[213220,779535],[213158,779480],[213100,779442],[212924,779404],[212285,779404],[211053,779040],[210079,778153],[209487,777772],[209487,759954],[220302,759954],[220502,759854],[220498,759854],[220643,759780],[220769,759704],[225173,759704],[225174,759706],[225228,759724],[225263,759731],[225275,759728],[225276,759728],[225322,759729],[225353,759741],[225371,759774],[225369,759794],[225386,759793],[225411,759803],[225427,759815],[225429,759816],[225445,759831],[225457,759852],[225464,759859],[225529,759910],[225537,759912],[225541,759912],[225545,759910],[225547,759906],[225547,759891],[225558,759863],[225591,759855],[225662,759881],[225662,759882],[225663,759876],[225663,759871],[225664,759852],[225679,759824],[225709,759804],[225737,759805],[225800,759823],[225803,759823],[225819,759824],[225842,759834],[225861,759846],[225877,759851],[225880,759843],[225897,759824],[225923,759814],[225949,759816],[225977,759828],[226033,759886],[226054,759898],[226055,759898],[226065,759892],[226096,759883],[226101,759873],[226102,759871],[226117,759852],[226144,759839],[226175,759842],[226193,759854],[226212,759870],[226213,759870],[226227,759871],[226239,759876],[226241,759877],[226263,759879],[226282,759883],[226294,759882],[226317,759869],[226340,759860],[226374,759864],[226398,759878],[226418,759881],[226438,759886],[226461,759897],[226481,759916],[226493,759932],[226499,759935],[226503,759935],[226528,759909],[226554,759895],[226563,759891],[226582,759886],[226639,759875],[226669,759875],[226696,759881],[226722,759890],[226743,759901],[226778,759904],[226780,759903],[226796,759899],[226837,759905],[226853,759906],[226869,759908],[226886,759909],[226903,759910],[226938,759909],[226992,759889],[227008,759886],[227054,759873],[227099,759871],[227115,759868],[227127,759860],[227130,759858],[227151,759849],[227182,759849],[227209,759854],[227200,759854],[227214,759857],[227230,759863],[227246,759871],[227266,759874],[227291,759883],[227296,759887],[227325,759912],[227383,759945],[227415,759953],[229654,759954],[229654,759909],[229654,759909],[229654,763700],[236462,763700],[236598,763973],[236783,764111],[236803,764122],[236827,764127],[236859,764140],[236888,764147],[236890,764130],[236889,764115],[236891,764096],[236954,764100],[236954,764131],[236958,764132],[236959,764132],[237009,764130],[237023,764132],[237048,764149],[237057,764165],[237057,764167],[237095,764200],[237098,764196],[237122,764173],[237137,764170],[237138,764169],[237141,764152],[237158,764127],[237181,764112],[237209,764106],[237230,764110],[237232,764111],[237234,764112],[237253,764120],[237270,764143],[237274,764160],[237275,764164],[237289,764192],[237292,764204],[237292,764204],[237301,764214],[237308,764225],[237310,764228],[237327,764257],[237326,764276],[237330,764279],[237341,764288],[237362,764318],[237370,764325],[237373,764328],[237378,764328],[237382,764327],[237396,764325],[237397,764325],[237428,764337],[237437,764364],[237437,764364],[237442,764368],[237443,764370],[237455,764379],[237465,764396],[237466,764398],[237472,764416],[237474,764424],[237478,764429],[237483,764435],[237485,764437],[237485,764436],[237490,764432],[237490,764431],[237502,764416],[237528,764407],[237535,764408],[237561,764424],[237571,764445],[237571,764448],[237576,764448],[237588,764446],[237609,764446],[237613,764446],[237623,764449],[237637,764451],[237654,764456],[237665,764464],[237686,764482],[237663,764533],[237639,764525],[237626,764518],[237620,764513],[237617,764512],[237613,764512],[237614,764520],[237563,764698],[237545,765019],[237510,765081],[237470,765138],[237419,765327],[237386,765396],[237385,765402],[237311,765606],[237256,765715],[237238,765785],[237238,765805],[237236,765857],[237205,766005],[237196,766035],[237165,766080],[237178,766095],[237188,766122],[237193,766216],[237192,766274],[237181,766348],[237171,766386],[237172,766423],[237186,766465],[237190,766491],[237200,766515],[237216,766545],[237229,766583],[237231,766629],[237208,766657],[237195,766678],[237195,766701],[237199,766709],[237221,766731],[237236,766765],[237238,766800],[237259,766804],[237287,766834],[237300,766843],[237435,766871],[237458,766885],[237492,766921],[237533,766915],[238156,767083],[238180,767092],[238180,769883],[239988,769883],[239988,775662]] };
$maps{"J:113"} = { bbox => [[200395, 740138], [232230, 762631]], area => '667.660145', series => 'J', number => '113', parent => 'J:113', title => 'Glen Coe', polygon => [[200395,741717],[204308,741690],[204888,741261],[205622,741079],[206409,740645],[209220,740658],[209466,740873],[209681,741653],[210139,741554],[210219,741313],[210221,740194],[218642,740138],[218932,740590],[219359,740701],[221136,741622],[222218,741580],[222219,741579],[222223,741578],[222230,741577],[222239,741575],[222251,741573],[222265,741571],[222281,741568],[222299,741564],[222319,741560],[222341,741556],[222365,741552],[222390,741547],[222417,741542],[222445,741537],[222475,741531],[222505,741526],[222537,741520],[222570,741514],[222603,741508],[222638,741501],[222672,741495],[222708,741488],[222743,741482],[222779,741475],[222816,741468],[222852,741462],[222888,741455],[222924,741448],[222960,741442],[222995,741435],[223030,741429],[223064,741423],[223097,741416],[223130,741411],[223161,741405],[223192,741399],[223221,741394],[223250,741389],[223276,741384],[223302,741380],[223325,741376],[223347,741372],[223367,741368],[223385,741365],[223401,741362],[223415,741360],[223426,741358],[223435,741357],[223446,741356],[223446,741356],[223449,741356],[223454,741357],[223461,741358],[223469,741360],[223478,741362],[223489,741364],[223501,741367],[223514,741371],[223528,741375],[223543,741379],[223559,741383],[223576,741388],[223594,741393],[223612,741398],[223632,741404],[223652,741410],[223672,741416],[223693,741422],[223714,741428],[223736,741435],[223758,741441],[223780,741448],[223803,741455],[223825,741462],[223848,741468],[223870,741475],[223893,741482],[223915,741489],[223937,741495],[223958,741502],[223979,741509],[224000,741515],[224020,741521],[224040,741527],[224059,741533],[224077,741539],[224094,741544],[224111,741549],[224127,741554],[224141,741559],[224155,741563],[224167,741567],[224178,741570],[224188,741573],[224197,741576],[224204,741578],[224210,741580],[224214,741581],[224217,741582],[224217,741582],[224217,741582],[225340,742001],[225719,741945],[225955,741777],[225925,741546],[226364,741499],[226636,741703],[227042,741722],[227029,741317],[227622,741220],[228146,741315],[228647,740936],[228793,740475],[229093,740428],[229252,740138],[230109,740138],[230199,740791],[230195,741401],[230904,742898],[230905,742898],[230906,742900],[230909,742903],[230913,742907],[230917,742912],[230922,742917],[230929,742924],[230936,742932],[230943,742940],[230952,742950],[230961,742960],[230971,742970],[230981,742982],[230992,742993],[231003,743006],[231015,743019],[231027,743032],[231040,743046],[231053,743060],[231066,743074],[231080,743089],[231093,743104],[231107,743119],[231121,743134],[231136,743149],[231150,743164],[231164,743180],[231178,743195],[231192,743210],[231206,743225],[231220,743239],[231234,743254],[231247,743268],[231260,743281],[231273,743295],[231285,743307],[231297,743320],[231309,743332],[231320,743343],[231330,743353],[231340,743363],[231349,743372],[231358,743381],[231366,743388],[231373,743395],[231380,743401],[231385,743405],[231390,743409],[231397,743413],[231397,743413],[231400,743415],[231405,743417],[231411,743419],[231420,743422],[231429,743425],[231441,743429],[231453,743433],[231467,743437],[231482,743442],[231498,743447],[231515,743453],[231533,743458],[231552,743464],[231572,743471],[231593,743477],[231614,743484],[231636,743491],[231659,743498],[231682,743505],[231705,743513],[231729,743520],[231753,743528],[231777,743535],[231801,743543],[231826,743550],[231850,743558],[231874,743565],[231898,743573],[231921,743580],[231945,743587],[231968,743594],[231990,743601],[232012,743608],[232033,743615],[232053,743621],[232073,743627],[232092,743633],[232110,743639],[232127,743644],[232143,743649],[232157,743653],[232171,743657],[232183,743661],[232193,743665],[232203,743667],[232210,743670],[232217,743672],[232221,743673],[232225,743674],[232225,743674],[232225,743674],[232230,750465],[231982,750465],[231981,760606],[230937,760449],[230117,760503],[228863,760969],[227008,760822],[227008,761833],[228005,762631],[203648,762602],[203667,762079],[203736,761623],[203697,761325],[202969,761405],[201520,760343],[200413,760419],[200395,741717]] };
$maps{"J:114"} = { bbox => [[246460, 735870], [269954, 752550]], area => '334.6105935', series => 'J', number => '114', parent => 'J:114', title => 'Ben Lawers', polygon => [[249064,749979],[248999,750011],[248999,747376],[246460,747376],[246460,736288],[250670,736770],[252888,735870],[263590,735870],[268058,738698],[269954,742105],[269954,752550],[259477,752550],[258320,749979],[249064,749979]] };
$maps{"J:115"} = { bbox => [[223256, 715301], [247071, 733460]], area => '341.86081', series => 'J', number => '115', parent => 'J:115', title => 'Crianlarich, Ben Lui & Ben Mor', polygon => [[223706,729764],[223674,729700],[223674,729700],[223674,716490],[223256,716490],[223288,715366],[232223,715301],[231837,715719],[240450,715719],[247039,718322],[247071,728189],[240675,728157],[237558,728800],[237076,729667],[235340,729667],[235373,733042],[231355,733042],[231837,733460],[226663,733460],[226663,731789],[225795,731146],[225731,730374],[224831,730374],[223706,729764]] };
$maps{"J:116"} = { bbox => [[247318, 705884], [264458, 729828]], area => '342.651873', series => 'J', number => '116', parent => 'J:116', title => 'Ben Ledi', polygon => [[247318,718001],[247328,706268],[253756,706270],[253595,705884],[260023,705884],[260151,706302],[261533,706302],[261533,706784],[264072,706977],[264072,708134],[264426,708231],[264426,709870],[264040,710094],[263783,710898],[264458,711991],[264458,719543],[264040,719865],[264072,724846],[261533,724814],[260633,725585],[258609,725617],[258609,729828],[249931,729828],[249931,718001],[247489,718001],[247442,718001],[247406,718001],[247361,718002],[247318,718001]] };
$maps{"J:117"} = { bbox => [[232667, 694724], [250214, 718764]], area => '343.333734', series => 'J', number => '117', parent => 'J:117', title => 'Ben Lomond', polygon => [[233084,702052],[233149,702020],[233084,697585],[235495,697585],[235495,694757],[244590,694724],[244911,695399],[247257,695399],[247258,706519],[250182,706519],[250214,706776],[249893,707066],[249925,718186],[245747,718186],[246294,718764],[243433,718764],[243915,718153],[241216,718153],[241248,717671],[239576,716354],[233470,716418],[232667,715775],[232667,714136],[233052,713686],[233084,702052]] };
$maps{"J:118"} = { bbox => [[218750, 692539], [236105, 716129]], area => '331.057464', series => 'J', number => '118', parent => 'J:118', title => 'Arrochar Alps', polygon => [[219040,712947],[219072,712883],[219072,711790],[218751,711469],[218750,705523],[219040,705170],[219040,700863],[218750,700638],[218750,699963],[219072,699610],[219040,692571],[222639,692571],[226817,700317],[229871,698838],[227428,695946],[230095,692539],[236105,692539],[236105,694082],[235848,694564],[235848,704302],[233245,704302],[233245,716129],[223089,716129],[219040,712947]] };
$maps{"J:119"} = { bbox => [[240400, 690675], [264179, 708062]], area => '293.157619', series => 'J', number => '119', parent => 'J:119', title => 'Ben Venue', polygon => [[240428,707837],[240408,707837],[240430,707837],[240400,707845],[240428,691028],[241231,691028],[241328,690675],[242838,690675],[242903,691061],[249973,691060],[249716,691800],[252416,695785],[253830,696267],[253958,697038],[255694,697135],[257076,697938],[259840,697745],[259711,700895],[260354,701538],[261640,704205],[263986,704205],[263954,706326],[264179,706808],[264179,708062],[260933,708062],[261029,707805],[251516,707805],[251323,708062],[246535,708062],[246470,707837],[240428,707837]] };
$maps{"J:120"} = { bbox => [[277653, 696503], [302465, 713454]], area => '307.5645775', series => 'J', number => '120', parent => 'J:120', title => 'Ochil Hills', polygon => [[302105,709772],[301605,710924],[301211,712255],[301153,713136],[299003,713136],[298999,713236],[298998,713237],[299000,713391],[296761,713391],[296759,713237],[296754,713237],[296754,713136],[293913,713136],[293776,713391],[293777,713391],[293739,713454],[293424,713314],[293425,713314],[293040,713136],[290734,713136],[290734,709799],[290628,709694],[289314,709694],[288355,709596],[288355,708655],[282193,708655],[282171,708635],[282156,708595],[282149,708545],[282123,708507],[282054,708388],[281951,708121],[281772,707859],[281280,707416],[281239,707405],[280789,707394],[280749,707385],[280716,707367],[280524,707224],[280321,707045],[280321,704476],[280215,704370],[278463,704370],[278439,704334],[278436,704313],[278445,704270],[278448,704240],[278333,704211],[278310,704199],[278274,704155],[278251,704114],[278230,704093],[278204,704082],[278183,704070],[278169,704055],[278157,704038],[278139,703999],[278127,703979],[278148,703849],[278119,703838],[278101,703829],[278089,703811],[278077,703779],[278051,703720],[278051,703694],[278066,703664],[278063,703626],[278057,703591],[278030,703544],[278001,703429],[277995,703394],[278004,703350],[278019,703314],[278051,703259],[278074,702941],[278063,702912],[278048,702865],[278019,702812],[277983,702732],[277948,702668],[277886,702526],[277857,702488],[277848,702474],[277830,702471],[277778,702494],[277698,702494],[277653,702464],[277653,701526],[277668,701516],[277683,701442],[277716,701380],[277772,701338],[277811,701299],[277856,701136],[277853,701056],[277885,700907],[277954,700773],[277939,700554],[277945,700298],[277882,699724],[277835,699609],[277787,699540],[277716,699472],[277653,699420],[277653,698851],[277695,698779],[277710,698610],[277758,698509],[277811,698173],[277867,697947],[277859,697861],[277864,697712],[277856,697516],[277823,697392],[277826,697317],[277862,697281],[278084,697260],[278517,696754],[278713,696754],[278779,696654],[278776,696654],[278883,696503],[283238,696503],[283240,696726],[283243,696726],[283243,696754],[293790,696754],[293870,696929],[294338,697083],[294767,697083],[294908,697299],[295925,697396],[296208,697701],[296516,697956],[296830,698049],[296975,698153],[297165,698203],[297597,698252],[297879,698261],[297947,698316],[297967,698402],[298111,698474],[298294,698602],[298375,698717],[298624,699162],[298651,699284],[298702,699359],[298779,699427],[298856,699482],[298948,699575],[298971,699707],[299041,699828],[299189,699886],[299412,700230],[299590,700413],[299714,700430],[300489,700430],[300489,700432],[300589,700432],[300589,700430],[300738,700430],[300738,701236],[301368,701236],[301275,701554],[300767,702057],[300738,702226],[300738,702993],[300741,703001],[300882,703548],[300988,704342],[301279,705083],[301808,705439],[302465,705494],[302465,708891],[302105,709772]] };
$maps{"J:121"} = { bbox => [[301077, 646451], [325309, 669197]], area => '250.9389605', series => 'J', number => '121', parent => 'J:121', title => 'Pentland Hills', polygon => [[325171,667875],[325218,667923],[324888,668253],[324797,668307],[324540,668384],[323808,668396],[323715,668580],[323646,668682],[323572,668631],[323602,668587],[323084,668588],[323024,668618],[322969,668595],[322276,668876],[322241,668914],[321958,669041],[321903,669080],[321957,669136],[321892,669197],[321829,669132],[321787,669113],[321720,669097],[321650,669067],[321564,669019],[320739,669016],[320668,669044],[320692,669058],[320750,669116],[320686,669179],[320638,669130],[320606,669112],[320557,669195],[320480,669150],[320523,669076],[320301,668972],[320049,668804],[320020,668789],[319417,668394],[319143,668270],[319142,668270],[319099,668249],[319099,668248],[318934,668158],[318793,668102],[318744,668076],[318626,667980],[318563,667937],[318541,667928],[318503,667921],[318341,667859],[318271,667842],[318230,667836],[318188,667825],[318114,667797],[317718,667550],[317688,667535],[317547,667490],[317510,667473],[317414,667403],[317356,667370],[317145,667285],[316860,667143],[316812,667128],[316780,667108],[316734,667087],[316653,667063],[316528,667059],[316496,667052],[316417,667026],[316408,667025],[316399,667026],[316377,667033],[316356,667042],[316318,667051],[316286,667047],[315971,666988],[315936,666971],[315905,666952],[315483,666789],[315452,666737],[315456,666697],[315479,666654],[315479,666648],[315477,666634],[315475,666625],[315474,666623],[315448,666624],[315432,666628],[315399,666639],[315329,666655],[315308,666663],[315289,666673],[315253,666678],[315224,666679],[315189,666670],[315089,666620],[315034,666598],[315013,666592],[314989,666588],[314799,666568],[314774,666562],[314729,666545],[314682,666522],[314662,666510],[314642,666502],[314060,666323],[313764,666200],[313613,666119],[313072,665601],[312243,664959],[312197,665039],[312132,664974],[312171,664904],[311618,664461],[310919,663760],[310849,663670],[310161,662963],[309446,661957],[309421,661929],[309323,661848],[309323,661849],[309257,661790],[309229,661776],[308982,661696],[308939,661676],[308791,661574],[308770,661555],[308750,661525],[308745,661497],[308733,661108],[308632,661074],[308571,661049],[308430,661001],[308393,660984],[308362,660959],[308337,660933],[308279,660890],[308221,660836],[308138,660771],[308116,660750],[308083,660704],[308060,660680],[307890,660569],[307515,660265],[307334,660042],[307281,659997],[307208,659924],[306849,659691],[305837,658709],[305795,658679],[305440,658371],[305388,658318],[305375,658339],[305346,658311],[305360,658287],[305341,658266],[305157,657998],[305071,657913],[304850,657593],[304665,657244],[304544,657065],[304488,656955],[304450,656896],[304405,656812],[304393,656762],[304395,656603],[304386,656529],[304387,656463],[304381,656417],[304355,656301],[304354,656301],[304344,656254],[304344,656254],[303939,654733],[303853,654257],[303846,654244],[303824,654213],[303449,653772],[303422,653722],[303302,653434],[303286,653344],[303269,653315],[302995,653049],[302743,652741],[302743,652741],[302714,652702],[302715,652702],[302076,651775],[302065,651751],[302005,651571],[301978,651511],[301917,651406],[301840,651164],[301761,650783],[301663,649943],[301648,649895],[301635,649879],[301554,649820],[301532,649800],[301483,649744],[301411,649640],[301360,649577],[301142,649371],[301077,649297],[301216,649192],[301284,649061],[301127,648578],[301123,647317],[301989,646451],[302299,646774],[302317,646796],[302331,646809],[302403,646859],[302633,647104],[302830,647227],[302866,647254],[302897,647280],[302928,647312],[303017,647384],[303031,647392],[303050,647398],[303397,647433],[303822,647526],[303857,647528],[303885,647527],[303924,647531],[304370,647609],[304395,647606],[304399,647604],[304412,647593],[304433,647579],[304458,647567],[304478,647560],[304491,647553],[304508,647540],[304535,647523],[304568,647509],[304660,647482],[304731,647470],[304822,647463],[304852,647465],[304888,647470],[305022,647506],[305216,647586],[305247,647606],[305270,647628],[305763,648193],[305773,648201],[305831,648200],[306492,648255],[306513,648253],[306579,648234],[306609,648210],[306635,648197],[306766,648158],[306822,648148],[306929,648139],[306963,648142],[306986,648150],[306997,648152],[307009,648152],[307195,648134],[307228,648134],[307233,648134],[307252,648131],[307272,648124],[307279,648119],[307286,648114],[307290,648108],[307296,648097],[307305,648067],[307319,648036],[307354,648014],[307468,648010],[307509,648003],[307519,647999],[307532,647990],[307565,647964],[307588,647950],[307621,647936],[307935,647665],[307972,647624],[308160,647382],[308222,647255],[308228,647258],[308239,647239],[308296,647272],[308348,647309],[308389,647342],[308612,647498],[308644,647514],[308678,647527],[308711,647547],[308783,647578],[308812,647601],[308821,647604],[308889,647614],[308912,647620],[308930,647622],[308949,647621],[309095,647603],[309098,647603],[309098,647603],[309173,647606],[309373,647566],[309427,647573],[309460,647572],[309490,647494],[309496,647469],[309583,647491],[309577,647515],[309548,647593],[309579,647618],[309879,647917],[309887,647953],[309878,648092],[309881,648110],[309895,648160],[309897,648166],[309911,648173],[309914,648173],[309938,648189],[309961,648214],[309973,648247],[309987,648297],[309997,648320],[310005,648332],[310012,648337],[310022,648338],[310037,648336],[310069,648329],[310787,647965],[310944,647862],[311018,647830],[311027,647820],[310868,647709],[310919,647635],[311129,647782],[311346,647857],[311396,647885],[311533,647987],[313410,649696],[313447,649737],[313596,649922],[313649,650015],[313694,650060],[313762,650250],[314003,650755],[314339,651241],[314778,651713],[314808,651751],[314825,651788],[314836,651819],[314848,651842],[314865,651864],[314935,651931],[314958,651872],[314941,651785],[315029,651768],[315050,651880],[315016,651969],[315037,652038],[315063,652065],[315086,652084],[315195,652164],[315347,652309],[315383,652355],[315397,652377],[315417,652429],[315422,652457],[315418,652504],[315402,652551],[315389,652582],[315365,652629],[315344,652695],[315342,652772],[315357,652897],[315364,652926],[315402,653028],[315658,653553],[315904,654339],[315912,654384],[315926,654442],[316019,655345],[316050,655458],[316117,655622],[316150,655797],[316152,655829],[316150,655858],[316124,656010],[316124,656026],[316127,656040],[316134,656054],[316147,656073],[316160,656101],[316167,656123],[316173,656136],[316183,656148],[316283,656244],[316344,656285],[316365,656305],[316402,656362],[316414,656384],[316455,656440],[316524,656503],[316594,656546],[316768,656637],[317955,657610],[318429,658113],[318454,658145],[318730,658252],[318698,658336],[318546,658277],[318607,658368],[319349,659190],[319393,659231],[319429,659256],[319565,659323],[319609,659354],[319644,659384],[319678,659420],[319710,659467],[319733,659511],[319774,659622],[319790,659654],[319811,659687],[319837,659717],[320344,660218],[320393,660252],[320458,660306],[320465,660316],[320476,660327],[320565,660374],[320769,660522],[320770,660522],[320808,660551],[320808,660552],[321579,661158],[321714,661247],[321714,661247],[321756,661273],[321755,661273],[322373,661670],[322399,661681],[322432,661699],[322461,661727],[322499,661780],[322580,661950],[322622,662024],[322639,662042],[322670,662061],[322855,662222],[323081,662490],[323122,662528],[323268,662637],[323305,662684],[323369,662778],[323567,663137],[323590,663166],[323617,663192],[323747,663291],[323816,663354],[323844,663388],[323934,663568],[323952,663616],[323967,663641],[323989,663654],[324018,663668],[324025,663670],[324029,663665],[324045,663677],[324063,663683],[324061,663689],[324090,663710],[324144,663789],[324170,663834],[324190,663877],[324200,663921],[324212,664071],[324211,664113],[324214,664150],[324227,664225],[324242,664266],[324253,664325],[324251,664406],[324262,664467],[324276,664503],[324292,664524],[324317,664550],[324394,664668],[324430,664758],[324455,664925],[324826,665629],[324887,665849],[324898,665943],[324895,666017],[324899,666048],[324908,666074],[324971,666176],[325049,666280],[325228,666441],[325309,666602],[325127,666803],[325044,666997],[325041,667027],[325041,667109],[325035,667155],[325015,667251],[325020,667446],[325023,667460],[325042,667471],[325079,667465],[325082,667463],[325113,667445],[325161,667522],[325130,667538],[325110,667551],[325171,667875]] };
$maps{"J:122"} = { bbox => [[185601, 617926], [207631, 652917]], area => '704.517647', series => 'J', number => '122', parent => 'J:122', title => 'Arran', polygon => [[194949,617926],[206820,617926],[206820,628177],[207631,628177],[207631,629941],[206820,629941],[206820,652228],[196133,652228],[196133,652917],[193112,652917],[193112,652228],[185601,652228],[185601,620827],[194181,620827],[194183,620475],[194949,620475],[194949,617926]] };
$maps{"J:201"} = { bbox => [[375455, 605940], [402555, 633149]], area => '542.6615565', series => 'J', number => '201', parent => 'J:201', title => 'Cheviot Hills', polygon => [[375674,626374],[375638,626337],[375674,620764],[377932,620764],[378005,618980],[377277,618105],[377204,615301],[376038,612933],[376657,610275],[375455,608453],[379498,608271],[384015,611367],[386310,611003],[386674,608417],[389515,606231],[391118,606523],[392502,605940],[394177,606377],[394760,608089],[398184,608417],[400369,612351],[402118,612642],[401753,613443],[402081,614463],[402555,615957],[401826,617450],[401863,621893],[400588,623168],[399568,626009],[400078,627393],[402482,627393],[402482,632384],[400042,632384],[399058,629288],[397965,629033],[393121,630490],[390462,630271],[389588,631947],[387075,633149],[384962,632202],[383906,629433],[378224,629433],[378224,626374],[375674,626374]] };
$maps{"J:202"} = { bbox => [[306179, 513528], [340729, 537621]], area => '702.162686', series => 'J', number => '202', parent => 'J:202', title => 'Lake District North', polygon => [[340729,528994],[340540,529008],[340540,529008],[340486,529012],[340479,529021],[340479,529021],[340455,529048],[340433,529079],[340366,529153],[340215,529512],[340183,529543],[339454,530086],[338143,531305],[338125,531340],[338102,531374],[338063,531393],[337963,531415],[337730,531570],[337366,532019],[338218,533399],[338253,533573],[338218,533860],[337546,536461],[337493,536601],[337371,536848],[337401,536866],[337415,536877],[337368,536941],[337299,536898],[337288,536886],[337219,536847],[336978,537205],[336805,537335],[336780,537371],[334172,537371],[334163,537373],[334162,537386],[334146,537421],[334131,537434],[334124,537442],[334117,537466],[334115,537470],[334107,537483],[334051,537522],[334045,537526],[334083,537621],[330511,537621],[330466,537576],[330390,537515],[330366,537490],[330355,537484],[330332,537477],[330288,537470],[330275,537470],[330231,537455],[330105,537371],[316759,537371],[316757,537373],[316757,537373],[316564,537592],[316591,537621],[316469,537621],[316334,537471],[316335,537471],[316026,537117],[316026,537117],[313590,534267],[313440,534011],[313420,533985],[313396,533960],[313369,533941],[313339,533924],[313116,533833],[313063,533797],[312988,533728],[312923,533646],[312882,533567],[312730,533153],[312665,533045],[312278,532585],[312192,532525],[312146,532502],[312002,532404],[311812,532224],[311744,532171],[311567,532070],[311529,532054],[311264,531978],[311225,531989],[311148,531913],[311225,531837],[311235,531837],[311292,531788],[311339,531739],[311364,531700],[311384,531649],[311430,531414],[311456,531338],[311464,531306],[311465,531278],[311399,531138],[311340,531101],[311314,531081],[311287,531051],[311267,531016],[311261,530976],[311263,530936],[311264,530928],[311277,529706],[311464,529512],[311463,529505],[311504,529435],[311471,529320],[311444,529262],[311395,529183],[311359,529145],[311348,529123],[311280,529054],[311182,528883],[311125,528661],[310991,528425],[310827,527920],[310703,527691],[310668,527426],[310672,527285],[310580,527117],[310235,526643],[309913,526368],[309891,526357],[309891,526356],[309772,526301],[309611,526118],[309349,525619],[309349,525619],[309335,525580],[309338,525256],[309277,525120],[309153,525041],[309027,524894],[308868,524648],[308752,524506],[308677,524385],[308596,524164],[308519,524061],[308511,524054],[308440,523927],[308431,523886],[308383,523758],[308294,523593],[308148,523192],[308139,522971],[308404,522698],[308366,522499],[308373,522353],[308380,522335],[308329,522269],[308293,522248],[308339,522171],[308372,522191],[308558,522065],[308589,522007],[308596,521985],[308653,521897],[308711,521738],[308724,521484],[308693,521303],[308786,521032],[308849,520934],[308873,520875],[308865,520809],[308804,520796],[308797,520794],[308451,520619],[308397,520532],[308394,520521],[308379,520504],[308341,520442],[308318,520277],[308291,520225],[308242,520107],[308290,520053],[308283,520028],[308300,519932],[308324,519928],[308382,519939],[308446,519911],[308474,519865],[308477,519836],[308468,519762],[308459,519723],[308447,519643],[308464,519446],[308449,519327],[308442,518794],[308512,518504],[308596,518416],[308621,518379],[308638,518346],[308680,518243],[308664,518242],[308644,518238],[308623,518227],[308605,518214],[308580,518198],[308510,518174],[308489,518160],[308477,518142],[308466,518133],[308363,518088],[308355,518083],[308337,518076],[307934,517972],[307931,517971],[307622,518028],[307406,517977],[307397,517976],[307393,517981],[307356,518033],[307334,518054],[307298,518065],[307237,518066],[307213,518060],[307115,518064],[307076,518054],[306998,518017],[306958,518003],[306950,518004],[306881,518041],[306496,518117],[306451,518050],[306414,518011],[306394,517994],[306305,517901],[306262,517838],[306251,517814],[306244,517794],[306244,517775],[306248,517749],[306264,517701],[306270,517673],[306267,517637],[306262,517630],[306241,517581],[306223,517300],[306211,517266],[306205,517258],[306179,517209],[306179,517103],[306180,517097],[306179,517092],[306179,513794],[322251,513794],[322315,513684],[322426,513552],[322427,513551],[322426,513546],[322472,513528],[322473,513531],[322485,513531],[322569,513555],[322606,513557],[322715,513594],[322729,513611],[322733,513612],[322802,513659],[322815,513670],[322836,513676],[322874,513673],[323075,513611],[323158,513632],[323180,513640],[323186,513640],[323240,513631],[323251,513630],[323364,513680],[323366,513681],[323385,513693],[324553,513693],[324659,513660],[324683,513656],[324810,513647],[325100,513669],[325199,513695],[325214,513708],[325248,513744],[325276,513788],[325279,513794],[340479,513794],[340479,525471],[340729,525471],[340729,528994]] };
$maps{"J:203"} = { bbox => [[329848, 494201], [351736, 528515]], area => '663.615324', series => 'J', number => '203', parent => 'J:203', title => 'Lake District East', polygon => [[351731,517476],[351729,517481],[351728,517500],[351722,517533],[351713,517552],[351713,517554],[351715,517582],[351713,517597],[351676,517701],[351650,517739],[351636,517773],[351627,517887],[351617,517912],[351580,517965],[351580,517965],[351568,517983],[351542,518040],[351541,518046],[351543,518047],[351529,518092],[351528,518092],[351523,518108],[351521,518121],[351522,518126],[351542,518162],[351550,518189],[351543,518222],[351529,518248],[351510,518264],[351482,518277],[351480,518281],[351480,524002],[351166,524002],[351161,524007],[351148,524026],[351116,524037],[351000,523995],[350999,523996],[350955,523977],[350955,523977],[350948,523975],[350948,523975],[350932,523981],[350932,523981],[350877,524000],[350877,524000],[350864,524005],[350864,524005],[350857,524009],[350857,524009],[350844,524015],[350844,524015],[350829,524022],[350829,524022],[350786,524058],[350786,524058],[350741,524107],[350741,524107],[350724,524132],[350724,524132],[350701,524163],[350701,524163],[350680,524183],[350680,524183],[350667,524196],[350667,524196],[350650,524229],[350650,524229],[350650,524232],[350650,524232],[350651,524238],[350650,524253],[350648,524262],[350644,524270],[350638,524280],[350638,524280],[350567,524338],[350567,524338],[350544,524355],[350544,524355],[350531,524365],[350531,524365],[350472,524403],[350159,524403],[350159,524403],[350150,524409],[350150,524409],[350150,524409],[350108,524443],[350108,524443],[350059,524503],[350059,524503],[350028,524544],[350028,524544],[350028,524544],[349982,524598],[349982,524598],[349961,524615],[349961,524615],[349947,524627],[349947,524627],[349933,524651],[349933,524651],[349923,524668],[349923,524668],[349916,524681],[349916,524681],[349894,524716],[349894,524716],[349869,524737],[349869,524737],[349860,524743],[349860,524743],[349848,524766],[349848,524766],[349829,524799],[349829,524799],[349816,524815],[349789,524837],[349789,524837],[349734,524859],[349734,524859],[349616,524969],[349616,524969],[349604,524991],[349604,524991],[349598,525004],[349598,525004],[349575,525051],[349575,525051],[349551,525102],[349551,525102],[349537,525126],[349537,525126],[349523,525154],[349523,525154],[349521,525162],[349521,525162],[349515,525186],[349515,525186],[349502,525211],[349502,525211],[349497,525221],[349497,525221],[349500,525226],[349500,525226],[349497,525233],[349497,525233],[349494,525249],[349494,525249],[349489,525279],[349489,525279],[349461,525328],[349461,525328],[349461,525328],[349437,525353],[349076,525451],[349062,525461],[349055,525471],[349049,525487],[349047,525497],[349046,525512],[349046,525512],[349046,527571],[349046,527571],[349046,527571],[349210,527663],[349210,527663],[349280,527726],[349280,527726],[349320,527777],[349320,527777],[349320,527779],[349320,527779],[349324,527783],[349324,527783],[349324,527784],[349324,527784],[349332,527794],[349332,527794],[349362,527834],[349362,527834],[349403,527887],[349403,527887],[349489,527973],[349489,527973],[349561,528049],[349561,528049],[349627,528142],[349627,528142],[349627,528142],[349673,528230],[349687,528280],[349697,528340],[349727,528355],[349748,528377],[349755,528391],[349761,528408],[349761,528408],[349761,528408],[349780,528416],[349746,528505],[349728,528497],[349691,528515],[349641,528511],[349616,528496],[349595,528472],[345523,527998],[345523,527998],[345423,527958],[345423,527958],[345423,527958],[345423,527958],[344321,527648],[344321,527648],[344177,527596],[344177,527596],[344177,527596],[343959,527530],[343959,527530],[343674,527447],[343674,527443],[343202,527401],[343202,527401],[343202,527416],[343202,527416],[343200,527440],[343195,527462],[343188,527483],[343188,527483],[343178,527502],[343149,527533],[343149,527533],[343088,527567],[342936,527582],[342936,527582],[342925,527610],[342925,527610],[342909,527649],[342909,527649],[342892,527678],[342877,527693],[342877,527693],[342860,527704],[341998,527845],[341998,527845],[341998,527845],[341998,527874],[341982,527862],[341982,527862],[341976,527857],[340608,528023],[340608,528023],[340608,528023],[340608,528022],[340519,527990],[340519,527990],[340395,527934],[340395,527934],[340356,527907],[340356,527907],[339958,527750],[339958,527750],[339621,527604],[339621,527604],[339435,527518],[339435,527518],[339435,527518],[339296,527454],[339296,527454],[339231,527426],[339231,527426],[339108,527370],[339108,527370],[339098,527362],[339091,527353],[339086,527340],[339086,527340],[339047,527327],[339047,527327],[338881,527274],[338881,527274],[338872,527280],[337586,527282],[337574,527276],[337564,527267],[336938,527363],[336938,527363],[336938,527363],[336938,527363],[336888,527362],[336888,527362],[336888,527362],[336888,527362],[336527,527284],[336527,527284],[336456,527255],[336456,527255],[336456,527255],[336389,527226],[334837,527062],[334837,527062],[334837,527062],[334836,527063],[334787,527054],[334787,527054],[334787,527054],[334788,527053],[334497,526982],[334497,526982],[334497,526982],[334447,526966],[334447,526966],[334447,526966],[334225,526897],[334225,526897],[334138,526862],[334138,526862],[334100,526843],[334100,526843],[334004,526799],[334004,526799],[333971,526783],[333971,526783],[333859,526724],[333859,526724],[333734,526648],[333734,526648],[333687,526619],[333687,526619],[333615,526577],[333615,526577],[333495,526503],[333495,526503],[333284,526354],[333284,526354],[333110,526201],[333110,526201],[333109,526201],[333004,526176],[333004,526176],[332996,526173],[332996,526173],[332860,526127],[332860,526127],[332811,526111],[332811,526111],[332778,526097],[332778,526097],[332756,526085],[332756,526085],[332730,526072],[332730,526072],[332690,526051],[332690,526051],[332629,526004],[332629,526004],[332612,525977],[332592,525926],[332592,525926],[332589,525897],[332589,525897],[332583,525848],[332583,525848],[332565,525777],[332565,525777],[332564,525777],[332564,525777],[332530,525728],[332530,525728],[332457,525590],[332457,525590],[332446,525554],[332446,525554],[332438,525535],[332438,525535],[332425,525507],[332417,525508],[332370,525497],[332370,525497],[332370,525497],[332353,525490],[332353,525490],[332338,525483],[332338,525483],[332307,525473],[332307,525473],[332287,525461],[332287,525461],[332278,525455],[332278,525455],[332265,525449],[332265,525449],[332257,525446],[332257,525446],[332254,525444],[332254,525444],[332249,525442],[332249,525442],[332249,525442],[332184,525422],[332184,525422],[332147,525404],[332147,525404],[332118,525393],[332013,525407],[332013,525407],[331999,525416],[331999,525416],[331975,525429],[331975,525429],[331963,525444],[331963,525444],[331956,525451],[331956,525451],[331933,525479],[331933,525479],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525487],[331929,525489],[331929,525489],[331924,525514],[331924,525514],[331916,525536],[331916,525536],[331916,525536],[331885,525595],[331885,525595],[331806,525636],[331761,525628],[331761,525628],[331754,525626],[331522,525670],[331522,525670],[331522,525670],[331519,525678],[331505,525674],[331491,525677],[331489,525669],[331425,525679],[331296,525654],[331296,525654],[331276,525643],[331276,525643],[331266,525638],[331266,525638],[331251,525629],[331251,525629],[331251,525629],[331217,525636],[331019,525588],[330915,525606],[330720,525580],[330232,525687],[330232,525687],[330145,525732],[330145,525732],[330145,525732],[330098,525758],[330098,498731],[330048,498731],[330048,498727],[329848,498727],[329848,494202],[336760,494201],[336707,494264],[336704,494273],[336704,494295],[336693,494324],[336678,494350],[336635,494398],[336603,494412],[336570,494414],[336551,494429],[336532,494451],[341998,494451],[341998,498695],[342215,498764],[342421,498758],[342604,498858],[342765,498839],[343078,498679],[343216,498660],[343556,498780],[345799,498457],[346319,498126],[346509,498157],[346847,498088],[346931,498044],[346931,498044],[346987,498007],[346987,498007],[347052,497951],[347052,497951],[347083,497920],[347083,497920],[347103,497900],[347103,497900],[347165,497837],[347165,497837],[347165,497837],[347198,497805],[347198,497805],[347252,497751],[347252,497751],[347300,497708],[347300,497708],[347311,497699],[347311,497699],[347311,497699],[348214,497693],[348275,497656],[348297,497628],[348312,497595],[348316,497577],[348318,497553],[348318,497553],[348318,497553],[348318,497326],[349832,497326],[349832,497328],[349877,497389],[349896,497429],[349896,497469],[349886,497505],[349885,497530],[349898,497597],[349913,497620],[349931,497670],[349928,497691],[349942,497740],[349945,497747],[350032,497831],[350048,497830],[350093,497841],[350108,497838],[350157,497848],[350218,497839],[350253,497859],[350271,497884],[350284,497895],[350288,497894],[350472,498064],[350547,498051],[350559,498094],[350557,498175],[350755,498235],[350815,498454],[350905,498489],[350954,498490],[350990,498632],[351307,498576],[351336,498585],[351374,498611],[351374,498611],[351428,498643],[351480,498654],[351480,516796],[351578,516902],[351580,516906],[351580,516905],[351644,517025],[351657,517106],[351654,517152],[351655,517154],[351705,517266],[351710,517291],[351719,517377],[351730,517416],[351736,517459],[351731,517476]] };
$maps{"J:204"} = { bbox => [[310526, 482288], [334179, 516317]], area => '709.6552755', series => 'J', number => '204', parent => 'J:204', title => 'Lake District West', polygon => [[322141,513996],[322002,514106],[322002,514106],[321999,514115],[321931,514177],[321924,514181],[321921,514202],[321861,514310],[321743,514417],[321703,514477],[321347,514809],[321119,514893],[320922,514902],[320913,514884],[320867,514898],[320808,514888],[320730,514905],[320674,514897],[320509,514924],[320448,514911],[320442,514908],[320430,514908],[320385,514900],[320316,514916],[320224,514900],[320131,514903],[320089,514916],[320046,514905],[320044,514905],[319871,514914],[319793,514941],[319738,514949],[319680,514935],[319667,514937],[319575,514977],[319574,514976],[319484,515015],[319463,515035],[319409,515125],[319337,515202],[319242,515277],[319236,515280],[319173,515335],[319178,515455],[319126,515550],[319015,515621],[318934,515762],[318926,515758],[318773,515908],[318773,515909],[318787,515955],[318726,516055],[318432,516239],[318340,516317],[310907,516316],[310907,515786],[310871,515715],[310867,515674],[310871,515569],[310893,515462],[310907,515442],[310908,493795],[310877,493761],[310881,493739],[310658,493492],[310589,493434],[310557,493415],[310543,493402],[310532,493383],[310526,493361],[310526,493332],[310534,493302],[310649,493067],[310655,493039],[310656,493026],[310646,493001],[310615,492951],[310666,488791],[310666,488789],[310683,488590],[310655,488395],[310655,488393],[310657,488377],[310666,488346],[310684,488325],[310766,488159],[310745,488106],[310732,487929],[310736,487883],[310778,487807],[310825,487672],[310854,487628],[310899,487594],[310901,487594],[310969,487580],[310991,487536],[311019,487497],[311058,487458],[311058,487431],[311112,487144],[311154,487030],[311171,486891],[311201,486803],[311126,485435],[311174,485374],[311224,485346],[311236,485332],[311244,485314],[311232,485292],[311223,485242],[311230,485188],[311246,485152],[311251,485075],[311267,485016],[311325,484895],[311337,484857],[311422,484717],[311457,484591],[312555,482729],[312663,482629],[312768,482483],[312807,482459],[312839,482450],[312917,482381],[313066,482288],[313123,482357],[313186,482412],[313300,482471],[313330,482492],[313406,482506],[313507,482578],[313572,482600],[313664,482698],[313706,482764],[313838,482911],[313858,482950],[313933,482987],[313899,483044],[313966,483155],[314036,483360],[314040,483396],[314062,483446],[314300,483702],[314363,483793],[314386,483817],[314445,483855],[314488,483899],[314509,483940],[314537,483958],[314768,484242],[314869,484280],[314915,484313],[315042,484459],[315060,484495],[315077,484513],[315116,484574],[315124,484582],[315145,484594],[315178,484630],[315189,484638],[315216,484645],[315356,484652],[315386,484661],[315411,484680],[315430,484704],[315443,484706],[315478,484725],[315521,484788],[315598,484857],[315664,484886],[315675,484888],[315688,484888],[315711,484872],[315751,484854],[315876,484817],[315975,484805],[315987,484806],[316212,484887],[316337,484890],[316339,484889],[316344,484891],[316425,484900],[316510,484881],[316526,484883],[316665,484942],[316655,484965],[316666,484942],[316819,484995],[316926,485008],[316983,485000],[316990,485000],[317031,485012],[317080,485043],[317142,485065],[317166,485086],[317187,485098],[317226,485107],[317246,485103],[317287,485077],[317327,485067],[317332,485067],[317413,485096],[317572,485111],[317724,485201],[317828,485469],[317820,485595],[317791,485656],[317774,485722],[317774,485725],[317870,486004],[318083,486407],[318104,486433],[318192,486501],[318476,486613],[318526,486646],[318640,486750],[320426,486760],[320425,486757],[320479,486754],[320852,486615],[320872,486595],[320905,486485],[320885,486330],[320891,486282],[320925,486197],[320924,486190],[320806,485851],[320801,485784],[320820,485707],[320808,485620],[320859,485462],[320888,485431],[320928,485406],[320938,485396],[320961,485278],[321037,485182],[321102,485169],[321246,485234],[321272,485257],[321405,485275],[321416,485401],[321553,485554],[321573,485588],[321652,485651],[321652,485651],[321749,485745],[321838,485907],[321952,486030],[322280,486501],[322310,486525],[322337,486532],[322754,486405],[323065,486195],[323155,486155],[323146,486056],[323127,485992],[323126,485929],[323118,485891],[323130,485827],[323132,485780],[323159,485716],[323177,485687],[323115,485501],[323107,485454],[323127,485356],[323144,485307],[323188,485274],[323216,485259],[323242,485196],[323291,485145],[323450,485129],[323496,485135],[323601,485190],[323606,485190],[323622,485188],[323685,485164],[323784,485095],[323808,485023],[323806,484986],[323703,484891],[324334,484891],[324564,484767],[324647,484753],[324664,484754],[325117,484892],[325117,484891],[326112,484891],[326112,484893],[326183,484872],[326203,484869],[326626,484737],[326805,484734],[326870,484689],[326913,484671],[326937,484665],[326951,484664],[326989,484668],[327010,484676],[327322,484891],[330153,484892],[330185,484791],[332311,484791],[332362,484834],[332370,484845],[332390,484891],[333713,484891],[333713,490742],[333813,490807],[333813,490807],[333917,490908],[333929,490913],[334009,490923],[334036,490944],[334081,491013],[334102,491027],[334141,491045],[334157,491057],[334179,491063],[334179,498712],[334036,498722],[333945,498691],[333933,498690],[333922,498690],[333909,498694],[333899,498699],[333888,498707],[333843,498762],[333818,498777],[333795,498784],[333788,498797],[333763,498820],[333763,498820],[333758,498824],[333755,498827],[333753,498850],[333742,498904],[333724,498925],[333713,498933],[333713,502919],[333763,502944],[333763,502944],[333801,502966],[334028,503053],[334141,503059],[334141,507985],[333813,508556],[333813,508556],[333713,508800],[333713,510767],[333218,510767],[333141,510814],[332771,511655],[332643,512270],[332573,512438],[332563,512481],[332564,512801],[332461,513562],[332429,513673],[332464,513803],[332467,513810],[332452,514003],[332310,514551],[332287,514591],[332191,515014],[332181,515035],[332117,515318],[332029,515489],[332008,515580],[331945,515724],[331836,515896],[331836,515896],[331831,515927],[331658,516208],[331615,516317],[322162,516317],[322162,513976],[322141,513996]] };
$maps{"J:205"} = { bbox => [[328241, 482428], [362908, 506450]], area => '670.1891705', series => 'J', number => '205', parent => 'J:205', title => 'Lake District South East', polygon => [[328608,493921],[328608,494903],[328608,494606],[328567,494580],[328558,494577],[328558,494577],[328509,494561],[328484,494548],[328458,494516],[328454,494411],[328434,494332],[328430,494327],[328430,494327],[328415,494308],[328360,494195],[328241,494092],[328300,494024],[328395,494103],[328508,494037],[328508,494037],[328578,493989],[328608,493981],[328608,485361],[328661,485379],[328865,485403],[328926,485401],[328928,485400],[328941,485393],[329049,485356],[329061,485353],[329169,485307],[329217,485300],[329342,485318],[329448,485314],[329463,485304],[329743,485241],[329778,485222],[329831,485162],[330009,485045],[330014,485052],[330068,485016],[330107,484973],[330140,484924],[330228,484653],[330377,484427],[330484,484122],[330525,484055],[330559,484014],[330612,483976],[330626,483963],[330634,483918],[330638,483683],[330654,483582],[330717,483414],[330897,483151],[331219,482808],[331224,482795],[331224,482795],[331258,482705],[331278,482672],[331331,482643],[331349,482641],[331533,482672],[331539,482672],[331595,482661],[331481,482468],[331567,482428],[331767,482795],[331767,482795],[331783,482845],[338623,482845],[338622,482840],[338606,482814],[338600,482795],[338600,482795],[338597,482777],[338596,482745],[338596,482745],[338596,482737],[338588,482695],[338590,482666],[338579,482614],[338579,482461],[344059,482461],[344262,482745],[344261,482745],[344292,482795],[344292,482795],[344323,482845],[348147,482844],[348146,482848],[348143,482926],[348190,483090],[348192,483110],[348187,483189],[347975,483651],[347953,483681],[347929,483705],[347905,483723],[347771,483784],[347728,483792],[347659,483794],[347608,483787],[347600,483789],[347595,483790],[347123,483723],[347092,483726],[347078,483750],[347072,483787],[347072,483955],[347082,483984],[347125,484053],[347139,484070],[347155,484080],[347432,484153],[347486,484146],[347509,484135],[347587,484076],[347593,484070],[347638,484038],[347754,484020],[347872,484051],[347939,484102],[348013,484188],[348039,484239],[348070,484369],[348089,484408],[348123,484439],[348141,484447],[348144,484446],[348151,484444],[348265,484382],[348279,484370],[348314,484354],[348405,484294],[348459,484274],[350992,484294],[351284,484681],[351268,484811],[351279,485165],[351367,485513],[351508,485802],[352020,488100],[352110,488313],[352495,488889],[352915,489781],[353104,490057],[353196,490262],[353256,490610],[353255,491263],[353354,491633],[353504,493754],[353652,493935],[355043,494414],[357712,494414],[358512,494260],[359025,493911],[359122,493880],[359163,493836],[359361,492939],[359540,492742],[359841,492534],[359911,492333],[360033,492231],[360034,493612],[360058,493687],[360081,493919],[360080,493919],[362732,493921],[362659,494119],[362644,494148],[362576,494177],[362556,494190],[362549,494201],[362576,494282],[362578,494318],[362571,494351],[362560,494375],[362560,494399],[362573,494430],[362576,494457],[362558,494514],[362851,494514],[362836,494560],[362796,494620],[362756,494662],[362719,494719],[362730,494776],[362752,494827],[362869,494961],[362908,495061],[362908,495101],[362895,495167],[362862,495261],[362518,495458],[362479,495466],[362439,495466],[362404,495458],[362368,495460],[362340,495477],[362251,495749],[362223,495786],[362090,495901],[361998,496015],[361998,496223],[362031,496265],[362110,496322],[362181,496399],[362430,496575],[362483,496803],[362490,496988],[362525,496988],[362525,497160],[362463,497160],[362412,497402],[362393,498846],[362364,498963],[362307,499089],[362908,499089],[362908,505336],[362191,505137],[361740,504928],[361719,504931],[361644,504857],[361644,504855],[361569,504808],[361558,504804],[361521,504843],[361506,504944],[361555,505253],[361547,505279],[361529,505493],[361487,505649],[361387,505867],[361216,506068],[336615,506068],[336577,506118],[336577,506118],[336564,506136],[336528,506168],[336528,506168],[336451,506202],[336342,506203],[336323,506221],[336229,506281],[336201,506287],[336119,506333],[336092,506332],[336092,506332],[336075,506349],[335997,506398],[335895,506419],[335794,506410],[335733,506417],[335627,506448],[335591,506449],[335463,506422],[335407,506442],[335393,506450],[329490,506447],[329483,506415],[329232,506182],[329183,506159],[329043,506183],[328961,506167],[328926,506169],[328820,506154],[328750,506125],[328671,506068],[328608,506068],[328608,494738],[328608,494738],[328608,494605],[328567,494579],[328558,494576],[328558,494576],[328509,494560],[328484,494547],[328458,494515],[328454,494410],[328434,494331],[328430,494326],[328430,494326],[328414,494307],[328360,494194],[328241,494091],[328300,494024],[328395,494102],[328508,494036],[328508,494036],[328558,494000],[328558,494000],[328578,493988],[328608,493980],[328608,493921]] };
$maps{"J:206"} = { bbox => [[361112, 481560], [378694, 505376]], area => '338.9112475', series => 'J', number => '206', parent => 'J:206', title => 'Howgill Fells', polygon => [[361552,504705],[361619,505162],[361334,504909],[361112,500464],[362237,498776],[362069,497032],[362097,495794],[362969,495119],[362800,494725],[363053,493769],[361506,493544],[361506,482235],[363953,482208],[363925,481561],[370029,481560],[370029,482854],[372730,482854],[372702,485724],[375712,485724],[375684,493319],[378694,493319],[378694,494922],[378215,495879],[378215,498776],[378441,499451],[378412,502545],[378665,503277],[378272,504149],[378272,504993],[375909,505021],[375909,503924],[374193,503249],[370480,505330],[369045,504965],[368117,505162],[366963,504880],[363732,505376],[361816,504768],[361552,504705]] };
$maps{"J:207"} = { bbox => [[368420, 467060], [385120, 490520]], area => '324.1427', series => 'J', number => '207', parent => 'J:207', title => 'Yorkshire Dales: Three Peaks', polygon => [[368420,490520],[368530,490440],[368420,473020],[371230,470380],[375560,468210],[378150,467060],[383520,467060],[382850,467570],[385120,469820],[385120,478790],[382570,478790],[382570,488240],[379840,488240],[379840,490520],[377110,490520],[374460,489310],[372490,490520],[368420,490520]] };
$maps{"J:208"} = { bbox => [[357051, 460393], [380026, 483825]], area => '420.711918', series => 'J', number => '208', parent => 'J:208', title => 'Yorkshire Dales: Bentham', polygon => [[374154,471616],[374154,472770],[374597,473410],[374597,475125],[374154,475639],[374126,477186],[374435,478002],[374154,478564],[374182,483825],[357416,483825],[357360,483825],[357416,479408],[357051,479465],[357051,477468],[357416,477214],[357416,471223],[357191,470998],[357163,468157],[357444,468213],[357444,467200],[357276,467144],[357219,466694],[357416,466581],[357416,461574],[360933,461574],[362508,460393],[374182,460420],[374182,466152],[377797,466152],[377797,466778],[380026,466778],[380026,471616],[374154,471616]] };
$maps{"J:209"} = { bbox => [[397346, 389225], [425947, 412028]], area => '475.764651', series => 'J', number => '209', parent => 'J:209', title => 'Peak District North', polygon => [[425905,394279],[425774,394301],[425722,394316],[425680,394336],[425407,394434],[424761,394597],[424679,394675],[424579,394795],[424535,394855],[424490,395240],[424470,395327],[424420,395392],[424304,395701],[424286,395739],[424286,395744],[424278,395781],[424238,395849],[424221,395896],[424227,395997],[424240,396077],[424232,396219],[424232,396219],[424232,396373],[424328,396529],[424333,396549],[424407,396669],[424339,396754],[424203,396814],[424210,396815],[424286,396863],[424232,396935],[424213,396945],[424091,397031],[424027,397135],[423993,397203],[423987,397218],[423970,397288],[423915,397386],[423872,397419],[423893,397425],[423909,397428],[424009,397503],[424013,397503],[424007,397543],[423995,397594],[423968,397676],[423939,397735],[423918,397787],[423847,397915],[423444,398486],[423415,398540],[423457,398705],[423485,398758],[423601,398881],[423641,398902],[423718,398962],[423798,399070],[423851,399163],[423885,399272],[423868,399365],[423753,399666],[423735,399740],[423810,399729],[423818,399818],[423736,399830],[423739,399859],[423664,399867],[423661,399843],[423584,399858],[423406,399919],[423397,399896],[423405,399920],[423170,400022],[423002,400127],[423002,400127],[422832,400241],[422664,400312],[422500,400356],[422197,400501],[422014,400536],[421367,400517],[420845,400549],[420683,400575],[420546,400646],[420026,401280],[419912,401397],[419912,401403],[419779,401552],[419778,401566],[419426,403476],[419461,403500],[419403,403569],[419398,403585],[419315,403552],[419162,403571],[418234,403848],[418189,403854],[418178,403853],[417879,403796],[417873,403797],[417869,403799],[417313,404196],[417272,404233],[417169,404428],[416818,404915],[416780,404953],[416734,404981],[416670,405004],[416215,405115],[416170,405119],[416158,405120],[416132,405117],[416096,405104],[416065,405086],[416043,405069],[416017,405059],[416003,405056],[416002,405056],[415988,405060],[415954,405077],[415706,405259],[415671,405275],[415640,405280],[415601,405283],[415593,405283],[415533,405275],[415481,405255],[415451,405239],[415435,405236],[415431,405236],[415401,405246],[415161,405347],[415096,405381],[415027,405430],[414752,405742],[414728,405782],[414619,405997],[414617,406021],[414621,406050],[414690,406236],[414800,406649],[414681,406797],[414276,406826],[413385,406826],[412749,406907],[411831,406919],[411050,406702],[408400,406497],[408254,407527],[407903,408528],[407774,408814],[407505,408943],[406850,409540],[405732,410862],[405931,411751],[405931,412028],[397446,412027],[397446,410931],[397346,410931],[397346,410164],[397446,410164],[397446,408777],[399034,408777],[399272,408445],[399228,408363],[399179,408243],[399155,408157],[399125,407971],[399037,407810],[398987,407738],[398923,407665],[398914,407425],[398719,406821],[398485,406654],[398264,406566],[397994,406433],[397958,406406],[397948,406392],[397940,406279],[397902,406133],[397814,403539],[397813,403539],[397823,403152],[397805,403058],[397771,402970],[397741,402914],[397680,402827],[397446,402566],[397446,396919],[397905,396425],[397905,395459],[398514,393764],[398567,392182],[398734,390952],[398741,389226],[425946,389225],[425947,394261],[425905,394279]] };
$maps{"J:210"} = { bbox => [[395878, 369968], [430178, 392971]], area => '701.3014885', series => 'J', number => '210', parent => 'J:210', title => 'Peak District Central', polygon => [[430148,386596],[430071,386595],[429960,386580],[429875,386555],[429738,386478],[429302,386319],[429269,386315],[429267,386315],[429174,386322],[429154,386525],[429128,386574],[429086,386603],[429070,386607],[429081,386651],[429024,386672],[428902,386674],[428825,386710],[428718,386813],[428678,386895],[428650,386999],[428413,386947],[428402,387546],[428360,387630],[428341,387727],[428343,387742],[428342,387867],[428347,387912],[428407,388144],[428407,388186],[428416,388197],[428389,388262],[428389,388799],[428398,388880],[428450,388971],[428437,388978],[428443,389009],[428447,389044],[428432,389089],[428357,389223],[428353,389231],[428363,389382],[428353,389434],[428320,389478],[428256,389539],[428185,389586],[428043,389634],[428017,389656],[428017,389656],[428019,389732],[428011,389773],[428010,389785],[428041,389820],[428065,389860],[428070,389921],[428048,389968],[428008,390016],[428003,390024],[428003,390051],[427999,390091],[427977,390132],[427864,390289],[427829,390351],[427817,390368],[427869,390399],[427908,390436],[427930,390475],[427931,390514],[427926,390582],[427883,390601],[427790,390583],[427741,390561],[427723,390544],[427671,390528],[427656,390526],[427655,390526],[427640,390533],[427634,390541],[427631,390563],[427544,390647],[427462,390709],[427402,390746],[427379,390768],[427325,390833],[427291,390860],[427191,390919],[427137,390939],[427051,390952],[427043,390952],[427020,390950],[426974,390954],[426828,391019],[426829,391023],[426805,391030],[426781,391041],[426779,391037],[426473,391124],[426321,391199],[426327,391703],[426324,391704],[426322,391753],[426309,391816],[426355,391817],[426396,391848],[426404,391893],[426397,391942],[426387,391971],[426515,392198],[426531,392209],[426456,392254],[426445,392239],[426431,392248],[426396,392278],[426319,392412],[426279,392460],[426279,392467],[426285,392486],[426310,392535],[426325,392594],[426325,392647],[426311,392706],[426289,392755],[426281,392770],[410345,392770],[410336,392802],[410328,392821],[410323,392829],[410315,392839],[410299,392855],[410279,392869],[410225,392889],[410198,392902],[410134,392947],[410035,392970],[410002,392971],[409882,392963],[409751,392921],[409722,392908],[409684,392898],[409659,392909],[409653,392913],[409575,392943],[409546,392944],[409447,392932],[409404,392932],[409213,392956],[408522,392968],[408372,392885],[408274,392770],[400393,392770],[400313,392606],[400275,392553],[400183,392455],[400139,392416],[400058,392314],[400040,392281],[400030,392278],[400033,392268],[400025,392255],[400038,392248],[400064,392153],[400077,392130],[400080,392123],[400049,392008],[400044,391972],[400053,391939],[400073,391891],[400074,391883],[400071,391867],[400061,391841],[400056,391841],[400050,391842],[400014,391849],[399974,391863],[399928,391870],[399914,391871],[399874,391867],[399822,391850],[399788,391806],[399783,391764],[399789,391740],[399803,391697],[399810,391682],[399770,391605],[399760,391574],[399759,391571],[399757,391531],[399792,391451],[399774,391439],[399710,391371],[399687,391384],[399653,391399],[399645,391400],[399644,391401],[399620,391399],[399563,391387],[398753,391395],[398753,381868],[395879,381868],[395878,371672],[395983,371684],[395990,371684],[396003,371677],[396030,371667],[396137,371658],[396172,371659],[396175,371661],[396181,371663],[396452,371632],[396469,371634],[396660,371697],[396840,371707],[396869,371712],[396877,371712],[396891,371713],[396954,371724],[397010,371741],[397070,371746],[400169,371746],[400213,371733],[400495,371507],[400609,371432],[400827,371337],[401186,371099],[401274,371026],[401379,370981],[401471,370957],[401739,370925],[401819,370925],[401898,370932],[401985,370948],[402279,371055],[402609,371229],[402727,371277],[402783,371314],[402801,371316],[402818,371313],[402922,371270],[402969,371264],[402986,371264],[403085,371298],[403100,371300],[403247,371290],[403305,371303],[403488,371382],[403680,371495],[403717,371504],[403866,371503],[403871,371520],[403892,371551],[403912,371575],[403936,371596],[404064,371673],[404106,371713],[404124,371742],[404189,371769],[404294,371781],[404522,371779],[404563,371767],[404894,371585],[405026,371536],[405255,371411],[405715,371279],[405863,371159],[405899,371136],[405957,371114],[406132,371087],[406285,371099],[406319,371096],[406336,371078],[406652,370836],[406786,370763],[407045,370547],[407090,370520],[407197,370474],[407238,370466],[407370,370460],[408162,370111],[408185,370097],[408327,369968],[421847,369968],[421846,369969],[421846,369971],[421845,369972],[421845,369974],[421844,369975],[421844,369977],[421843,369978],[421843,369980],[421842,369982],[421842,369983],[421841,369985],[421841,369986],[421841,369988],[421840,369989],[421840,369991],[421839,369992],[421839,369994],[421838,369996],[421838,369997],[421837,369999],[421837,370000],[421836,370002],[421836,370003],[421836,370005],[421835,370006],[421835,370008],[421834,370009],[421834,370011],[421833,370012],[421833,370014],[421833,370016],[421832,370017],[421832,370019],[421831,370020],[421831,370022],[421831,370023],[421830,370025],[421830,370026],[421829,370028],[421829,370029],[421829,370031],[421828,370032],[421828,370034],[421828,370035],[421827,370037],[421827,370038],[421826,370040],[421826,370041],[421825,370044],[421825,370044],[421825,370046],[421825,370047],[421824,370049],[421824,370051],[421824,370052],[421823,370054],[421823,370055],[421823,370057],[421822,370059],[421822,370060],[421822,370062],[421821,370063],[421821,370065],[421821,370067],[421820,370068],[421820,370070],[421820,370071],[421819,370073],[421819,370075],[421819,370076],[421818,370078],[421818,370079],[421818,370081],[421818,370083],[421817,370084],[421817,370086],[421817,370087],[421816,370089],[421816,370091],[421816,370092],[421816,370094],[421815,370096],[421815,370097],[421815,370099],[421814,370100],[421814,370102],[421814,370104],[421814,370105],[421813,370107],[421813,370108],[421813,370110],[421812,370112],[421812,370113],[421812,370115],[421812,370117],[421811,370118],[421811,370120],[421811,370121],[421810,370125],[421810,370125],[421810,370125],[421810,370126],[421810,370127],[421810,370128],[421809,370129],[421809,370130],[421809,370131],[421809,370132],[421809,370133],[421809,370133],[421809,370134],[421808,370135],[421808,370136],[421808,370137],[421808,370138],[421808,370139],[421808,370140],[421807,370141],[421807,370142],[421807,370142],[421807,370143],[421807,370144],[421807,370145],[421807,370146],[421806,370147],[421806,370148],[421806,370149],[421806,370150],[421806,370151],[421806,370151],[421805,370152],[421805,370153],[421805,370154],[421805,370155],[421805,370156],[421805,370157],[421804,370158],[421804,370159],[421804,370160],[421804,370160],[421804,370161],[421804,370162],[421804,370163],[421803,370164],[421803,370165],[421803,370166],[421803,370167],[421803,370168],[421802,370169],[421802,370169],[421802,370170],[421802,370172],[421802,370173],[421802,370174],[421801,370175],[421801,370176],[421801,370177],[421801,370178],[421800,370179],[421800,370180],[421800,370182],[421800,370183],[421800,370184],[421799,370185],[421799,370186],[421799,370187],[421799,370188],[421799,370189],[421798,370190],[421798,370191],[421798,370193],[421798,370194],[421798,370195],[421797,370196],[421797,370197],[421797,370198],[421797,370199],[421796,370200],[421796,370201],[421796,370202],[421796,370204],[421796,370205],[421795,370206],[421795,370207],[421795,370208],[421795,370209],[421795,370210],[421794,370211],[421794,370212],[421794,370213],[421794,370215],[421793,370216],[421793,370217],[421793,370218],[421793,370219],[421793,370220],[421792,370221],[421792,370222],[421792,370225],[421792,370225],[421792,370225],[421791,370226],[421791,370228],[421791,370230],[421790,370231],[421790,370233],[421790,370235],[421789,370237],[421789,370239],[421789,370241],[421788,370243],[421788,370245],[421787,370246],[421787,370248],[421787,370250],[421786,370252],[421786,370254],[421786,370256],[421785,370258],[421785,370260],[421784,370262],[421784,370263],[421784,370265],[421783,370267],[421783,370269],[421783,370271],[421782,370273],[421782,370275],[421782,370277],[421781,370279],[421781,370281],[421781,370282],[421780,370284],[421780,370286],[421779,370288],[421779,370290],[421779,370292],[421778,370294],[421778,370296],[421778,370298],[421777,370300],[421777,370301],[421777,370303],[421776,370305],[421776,370307],[421776,370309],[421775,370311],[421775,370313],[421775,370315],[421774,370317],[421774,370320],[421774,370320],[421774,370321],[421773,370323],[421773,370324],[421773,370325],[421773,370326],[421773,370327],[421773,370329],[421772,370330],[421772,370331],[421772,370332],[421772,370333],[421772,370335],[421771,370336],[421771,370337],[421771,370338],[421771,370340],[421771,370341],[421771,370342],[421770,370343],[421770,370344],[421770,370346],[421770,370347],[421770,370348],[421770,370349],[421770,370351],[421769,370352],[421769,370353],[421769,370354],[421769,370355],[421769,370357],[421769,370358],[421768,370359],[421768,370360],[421768,370362],[421768,370363],[421768,370364],[421768,370365],[421768,370367],[421767,370368],[421767,370369],[421767,370370],[421767,370371],[421767,370373],[421767,370374],[421767,370375],[421766,370376],[421766,370378],[421766,370379],[421766,370381],[421766,370381],[421766,370381],[421763,370403],[421763,370403],[421763,370403],[421763,370404],[421763,370404],[421763,370404],[421763,370404],[421763,370405],[421763,370405],[421763,370405],[421763,370406],[421763,370406],[421763,370406],[421763,370407],[421763,370407],[421763,370407],[421763,370407],[421763,370408],[421763,370408],[421763,370408],[421763,370409],[421763,370409],[421763,370409],[421763,370410],[421763,370410],[421763,370410],[421763,370410],[421763,370411],[421763,370411],[421763,370411],[421763,370412],[421763,370412],[421763,370412],[421763,370413],[421762,370413],[421762,370413],[421762,370414],[421762,370414],[421762,370414],[421762,370415],[421762,370415],[421762,370415],[421762,370416],[421762,370416],[421762,370416],[421762,370417],[421762,370417],[421762,370417],[421762,370418],[421762,370418],[421762,370418],[421762,370419],[421762,370419],[421762,370420],[421762,370421],[421762,370421],[421762,370422],[421762,370422],[421762,370423],[421762,370424],[421762,370424],[421762,370425],[421762,370425],[421761,370426],[421761,370427],[421761,370427],[421761,370428],[421761,370429],[421761,370429],[421761,370430],[421761,370431],[421761,370431],[421761,370432],[421761,370433],[421761,370433],[421761,370434],[421761,370434],[421761,370435],[421761,370436],[421760,370436],[421760,370437],[421760,370438],[421760,370438],[421760,370439],[421760,370440],[421760,370440],[421760,370441],[421760,370442],[421760,370443],[421760,370443],[421760,370444],[421759,370445],[421759,370445],[421759,370446],[421759,370447],[421759,370447],[421759,370448],[421759,370449],[421759,370449],[421758,370451],[421758,370451],[421758,370451],[421758,370452],[421758,370453],[421758,370453],[421758,370454],[421758,370454],[421758,370455],[421757,370456],[421757,370456],[421757,370457],[421757,370457],[421757,370458],[421757,370458],[421757,370459],[421756,370460],[421756,370460],[421756,370461],[421756,370461],[421756,370462],[421756,370462],[421756,370463],[421755,370463],[421755,370464],[421755,370465],[421755,370465],[421755,370466],[421755,370466],[421755,370467],[421754,370467],[421754,370468],[421754,370468],[421754,370469],[421754,370469],[421754,370470],[421753,370470],[421753,370471],[421753,370472],[421753,370472],[421753,370473],[421753,370473],[421752,370474],[421752,370474],[421752,370475],[421752,370475],[421752,370476],[421752,370476],[421752,370477],[421751,370477],[421751,370478],[421751,370478],[421751,370478],[421751,370479],[421751,370479],[421751,370480],[421750,370480],[421750,370480],[421750,370481],[421750,370481],[421750,370481],[421750,370482],[421750,370482],[421750,370483],[421750,370483],[421749,370483],[421749,370484],[421749,370484],[421749,370484],[421749,370485],[421749,370485],[421749,370485],[421749,370486],[421749,370486],[421749,370486],[421748,370487],[421748,370487],[421748,370487],[421748,370488],[421748,370488],[421748,370488],[421748,370489],[421748,370489],[421748,370489],[421748,370490],[421747,370490],[421747,370490],[421747,370491],[421747,370491],[421747,370491],[421747,370492],[421747,370492],[421747,370492],[421747,370493],[421747,370493],[421747,370493],[421747,370494],[421747,370494],[421747,370494],[421746,370495],[421746,370495],[421746,370495],[421746,370495],[421746,370496],[421746,370496],[421746,370497],[421746,370497],[421746,370497],[421746,370498],[421746,370498],[421746,370498],[421746,370499],[421746,370499],[421746,370500],[421746,370500],[421746,370500],[421746,370501],[421746,370501],[421746,370502],[421746,370502],[421746,370502],[421746,370503],[421746,370503],[421746,370504],[421746,370504],[421745,370504],[421745,370505],[421745,370505],[421745,370506],[421745,370506],[421745,370507],[421745,370507],[421745,370507],[421745,370508],[421745,370508],[421745,370509],[421745,370509],[421745,370510],[421745,370510],[421745,370511],[421745,370511],[421745,370511],[421745,370512],[421745,370512],[421745,370513],[421745,370513],[421745,370514],[421745,370514],[421745,370515],[421745,370515],[421746,370516],[421746,370516],[421746,370516],[421746,370516],[421746,370516],[421746,370516],[421746,370517],[421746,370517],[421746,370517],[421746,370517],[421746,370517],[421746,370517],[421746,370517],[421746,370517],[421746,370518],[421746,370518],[421746,370518],[421746,370518],[421746,370518],[421746,370518],[421746,370519],[421746,370519],[421746,370519],[421746,370519],[421746,370519],[421746,370520],[421746,370520],[421746,370520],[421746,370520],[421746,370520],[421746,370521],[421746,370521],[421746,370521],[421746,370521],[421746,370522],[421746,370522],[421746,370522],[421746,370522],[421746,370523],[421746,370523],[421746,370523],[421746,370524],[421746,370524],[421746,370524],[421746,370524],[421747,370525],[421747,370525],[421747,370525],[421747,370526],[421747,370526],[421747,370526],[421747,370526],[421747,370526],[421760,370560],[421788,370636],[421790,370637],[421792,370637],[421793,370638],[421795,370639],[421797,370639],[421799,370640],[421800,370641],[421802,370642],[421804,370643],[421805,370644],[421807,370645],[421809,370646],[421810,370647],[421812,370648],[421813,370649],[421815,370650],[421816,370651],[421817,370653],[421819,370654],[421820,370655],[421822,370657],[421823,370658],[421824,370659],[421825,370661],[421826,370662],[421828,370664],[421829,370665],[421830,370667],[421831,370669],[421832,370670],[421833,370672],[421834,370673],[421834,370675],[421835,370677],[421836,370679],[421837,370680],[421837,370682],[421838,370684],[421839,370686],[421839,370688],[421840,370689],[421840,370691],[421840,370693],[421841,370695],[421841,370697],[421841,370699],[421841,370701],[421842,370703],[421842,370707],[421842,370707],[421842,370708],[421842,370709],[421842,370710],[421842,370711],[421842,370712],[421842,370712],[421841,370713],[421841,370714],[421841,370715],[421841,370716],[421841,370717],[421841,370718],[421841,370719],[421841,370720],[421840,370720],[421840,370721],[421840,370722],[421840,370723],[421840,370724],[421840,370725],[421839,370726],[421839,370727],[421839,370727],[421839,370728],[421838,370729],[421838,370730],[421838,370731],[421837,370732],[421837,370733],[421837,370733],[421836,370734],[421836,370735],[421836,370736],[421835,370737],[421835,370737],[421835,370738],[421834,370739],[421834,370740],[421833,370741],[421833,370742],[421833,370742],[421832,370743],[421832,370744],[421831,370745],[421831,370745],[421830,370746],[421830,370747],[421829,370748],[421828,370749],[421828,370749],[421829,370751],[421829,370752],[421830,370754],[421831,370756],[421831,370757],[421832,370759],[421832,370760],[421833,370762],[421833,370764],[421834,370765],[421834,370767],[421835,370768],[421835,370770],[421836,370771],[421836,370772],[421837,370774],[421837,370775],[421838,370777],[421838,370778],[421838,370779],[421839,370781],[421839,370782],[421840,370783],[421840,370785],[421841,370786],[421841,370787],[421841,370788],[421842,370789],[421842,370791],[421843,370792],[421843,370793],[421843,370794],[421844,370795],[421844,370796],[421845,370797],[421845,370798],[421845,370800],[421846,370801],[421846,370802],[421846,370803],[421847,370804],[421847,370805],[421847,370805],[421848,370806],[421848,370807],[421848,370808],[421849,370809],[421849,370810],[421849,370812],[421849,370812],[421849,370812],[421852,370819],[421852,370820],[421853,370821],[421853,370821],[421853,370822],[421853,370822],[421853,370823],[421854,370824],[421854,370824],[421854,370825],[421854,370826],[421854,370826],[421855,370827],[421855,370827],[421855,370828],[421855,370829],[421856,370829],[421856,370830],[421856,370830],[421856,370831],[421856,370832],[421857,370832],[421857,370833],[421857,370833],[421857,370834],[421858,370835],[421858,370835],[421858,370836],[421858,370836],[421858,370837],[421859,370837],[421859,370838],[421859,370839],[421859,370839],[421860,370840],[421860,370840],[421860,370841],[421860,370841],[421860,370842],[421861,370842],[421861,370843],[421861,370843],[421861,370844],[421862,370844],[421862,370845],[421862,370846],[421862,370846],[421863,370847],[421863,370847],[421863,370848],[421863,370848],[421864,370849],[421865,370850],[421865,370851],[421866,370853],[421867,370854],[421867,370855],[421868,370857],[421869,370858],[421870,370860],[421871,370861],[421872,370863],[421873,370865],[421874,370867],[421875,370868],[421876,370870],[421878,370872],[421879,370874],[421880,370876],[421881,370878],[421883,370880],[421884,370882],[421885,370884],[421886,370886],[421888,370888],[421889,370890],[421891,370892],[421892,370894],[421893,370896],[421895,370898],[421896,370900],[421897,370902],[421899,370904],[421900,370906],[421901,370908],[421903,370910],[421904,370912],[421905,370914],[421907,370915],[421908,370917],[421909,370919],[421910,370921],[421912,370923],[421913,370924],[421914,370926],[421915,370928],[421916,370929],[421917,370931],[421918,370932],[421920,370935],[421920,370935],[421920,370935],[421925,370942],[421926,370943],[421926,370943],[421927,370944],[421927,370944],[421927,370945],[421928,370946],[421928,370946],[421929,370947],[421929,370948],[421930,370948],[421930,370949],[421931,370949],[421931,370950],[421931,370951],[421932,370951],[421932,370952],[421933,370953],[421933,370953],[421934,370954],[421934,370954],[421935,370955],[421935,370956],[421935,370956],[421936,370957],[421936,370957],[421937,370958],[421937,370958],[421938,370959],[421938,370960],[421938,370960],[421939,370961],[421939,370961],[421940,370962],[421940,370963],[421941,370963],[421941,370964],[421942,370964],[421942,370965],[421942,370965],[421943,370966],[421943,370967],[421944,370967],[421944,370968],[421945,370968],[421945,370969],[421945,370969],[421946,370970],[421946,370970],[421947,370971],[421947,370971],[421948,370972],[421948,370973],[421949,370974],[421950,370974],[421950,370975],[421951,370976],[421952,370977],[421952,370977],[421953,370978],[421953,370979],[421954,370979],[421955,370980],[421955,370981],[421956,370981],[421956,370982],[421957,370983],[421957,370983],[421958,370984],[421959,370984],[421959,370985],[421960,370986],[421960,370986],[421961,370987],[421961,370988],[421962,370988],[421963,370989],[421963,370989],[421964,370990],[421964,370990],[421965,370991],[421965,370992],[421966,370992],[421966,370993],[421967,370993],[421967,370994],[421968,370994],[421969,370995],[421969,370995],[421970,370996],[421970,370996],[421971,370997],[421971,370998],[421972,370998],[421972,370999],[421973,370999],[421973,371000],[421974,371000],[421974,371001],[421976,371002],[421976,371002],[421976,371002],[421977,371003],[421978,371003],[421978,371004],[421979,371005],[421980,371005],[421980,371006],[421981,371007],[421982,371007],[421983,371008],[421983,371008],[421984,371009],[421985,371010],[421986,371010],[421986,371011],[421987,371011],[421988,371012],[421989,371013],[421989,371013],[421990,371014],[421991,371014],[421992,371015],[421992,371016],[421993,371016],[421994,371017],[421995,371017],[421995,371018],[421996,371019],[421997,371019],[421998,371020],[421999,371020],[421999,371021],[422000,371022],[422001,371022],[422002,371023],[422003,371023],[422003,371024],[422004,371025],[422005,371025],[422006,371026],[422006,371026],[422007,371027],[422008,371028],[422009,371028],[422010,371029],[422010,371029],[422011,371030],[422012,371030],[422014,371032],[422014,371032],[422014,371032],[422014,371032],[422015,371032],[422015,371033],[422015,371033],[422016,371033],[422016,371033],[422016,371034],[422017,371034],[422017,371034],[422017,371034],[422018,371035],[422018,371035],[422018,371035],[422019,371035],[422019,371036],[422020,371036],[422020,371036],[422020,371036],[422021,371037],[422021,371037],[422021,371037],[422022,371037],[422022,371038],[422022,371038],[422023,371038],[422023,371038],[422024,371039],[422024,371039],[422024,371039],[422025,371039],[422025,371040],[422025,371040],[422026,371040],[422026,371040],[422027,371041],[422027,371041],[422027,371041],[422028,371041],[422028,371042],[422029,371042],[422029,371042],[422029,371042],[422030,371043],[422030,371043],[422030,371043],[422031,371043],[422031,371044],[422032,371044],[422032,371044],[422033,371045],[422033,371045],[422034,371045],[422034,371046],[422035,371046],[422036,371046],[422036,371047],[422037,371047],[422037,371048],[422038,371048],[422039,371048],[422039,371049],[422040,371049],[422040,371050],[422041,371050],[422042,371050],[422042,371051],[422043,371051],[422043,371052],[422044,371052],[422045,371053],[422045,371053],[422046,371053],[422047,371054],[422047,371054],[422048,371055],[422048,371055],[422049,371056],[422050,371056],[422050,371056],[422051,371057],[422052,371057],[422052,371058],[422053,371058],[422053,371059],[422054,371059],[422055,371060],[422055,371060],[422056,371061],[422057,371061],[422057,371061],[422058,371062],[422058,371062],[422059,371063],[422060,371063],[422060,371064],[422061,371064],[422062,371065],[422063,371066],[422063,371066],[422064,371067],[422065,371067],[422066,371068],[422067,371069],[422067,371070],[422068,371071],[422069,371071],[422070,371072],[422071,371073],[422072,371074],[422073,371074],[422074,371075],[422074,371076],[422075,371077],[422076,371078],[422077,371078],[422078,371079],[422079,371080],[422079,371081],[422080,371081],[422081,371082],[422082,371083],[422083,371084],[422083,371085],[422084,371085],[422085,371086],[422086,371087],[422086,371088],[422087,371088],[422088,371089],[422089,371090],[422089,371091],[422090,371091],[422091,371092],[422091,371093],[422092,371093],[422093,371094],[422093,371095],[422094,371095],[422094,371096],[422095,371097],[422096,371098],[422096,371098],[422097,371099],[422097,371099],[422098,371100],[422098,371101],[422099,371101],[422100,371102],[422100,371102],[422101,371103],[422102,371104],[422103,371105],[422103,371106],[422104,371107],[422105,371108],[422106,371109],[422106,371110],[422107,371111],[422108,371112],[422109,371113],[422110,371114],[422110,371114],[422111,371115],[422112,371116],[422113,371117],[422113,371118],[422114,371119],[422115,371120],[422115,371121],[422116,371122],[422117,371123],[422118,371123],[422118,371124],[422119,371125],[422120,371126],[422120,371127],[422121,371128],[422122,371129],[422122,371130],[422123,371130],[422124,371131],[422124,371132],[422125,371133],[422126,371134],[422126,371135],[422127,371136],[422127,371137],[422128,371137],[422129,371138],[422129,371139],[422130,371140],[422131,371141],[422131,371142],[422132,371143],[422132,371144],[422133,371144],[422133,371145],[422135,371147],[422135,371147],[422135,371148],[422136,371148],[422136,371149],[422136,371150],[422137,371151],[422137,371151],[422138,371152],[422138,371153],[422139,371154],[422139,371154],[422140,371155],[422140,371156],[422141,371157],[422141,371157],[422142,371158],[422142,371159],[422142,371160],[422143,371161],[422143,371161],[422144,371162],[422144,371163],[422145,371164],[422145,371165],[422146,371165],[422146,371166],[422146,371167],[422147,371168],[422147,371169],[422148,371169],[422148,371170],[422149,371171],[422149,371172],[422149,371173],[422150,371174],[422150,371175],[422151,371175],[422151,371176],[422151,371177],[422152,371178],[422152,371179],[422153,371180],[422153,371181],[422153,371181],[422154,371182],[422154,371183],[422155,371184],[422155,371185],[422155,371186],[422156,371188],[422156,371188],[422156,371188],[422157,371189],[422157,371190],[422157,371190],[422157,371191],[422158,371192],[422158,371193],[422158,371193],[422158,371194],[422159,371195],[422159,371195],[422159,371196],[422159,371197],[422160,371198],[422160,371198],[422160,371199],[422160,371200],[422161,371200],[422161,371201],[422161,371202],[422161,371202],[422161,371203],[422162,371204],[422162,371205],[422162,371205],[422162,371206],[422162,371207],[422162,371207],[422163,371208],[422163,371209],[422163,371209],[422163,371210],[422163,371211],[422163,371211],[422164,371212],[422164,371213],[422164,371213],[422164,371214],[422164,371215],[422164,371215],[422165,371216],[422165,371217],[422165,371217],[422165,371218],[422165,371219],[422165,371219],[422165,371220],[422165,371221],[422166,371222],[422166,371222],[422166,371223],[422166,371224],[422166,371225],[422167,371226],[422167,371227],[422167,371228],[422167,371229],[422167,371230],[422167,371231],[422168,371231],[422168,371232],[422168,371233],[422168,371234],[422168,371235],[422168,371236],[422169,371237],[422169,371238],[422169,371239],[422169,371240],[422169,371241],[422169,371242],[422169,371242],[422170,371243],[422170,371244],[422170,371245],[422170,371246],[422170,371247],[422170,371248],[422170,371249],[422171,371249],[422171,371250],[422171,371251],[422171,371252],[422171,371253],[422171,371254],[422171,371255],[422171,371255],[422171,371256],[422172,371257],[422172,371258],[422172,371259],[422172,371260],[422172,371260],[422172,371261],[422172,371262],[422172,371263],[422172,371264],[422172,371265],[422173,371266],[422173,371266],[422173,371267],[422173,371268],[422173,371269],[422173,371269],[422173,371270],[422173,371271],[422173,371272],[422173,371272],[422173,371273],[422173,371274],[422173,371275],[422173,371276],[422173,371276],[422173,371277],[422173,371278],[422173,371279],[422173,371279],[422174,371280],[422174,371281],[422174,371282],[422174,371283],[422174,371283],[422174,371284],[422174,371285],[422174,371286],[422174,371286],[422174,371287],[422174,371288],[422174,371289],[422174,371289],[422174,371290],[422174,371291],[422174,371292],[422174,371292],[422174,371293],[422174,371294],[422174,371295],[422174,371295],[422174,371296],[422174,371297],[422174,371298],[422174,371298],[422174,371299],[422174,371300],[422174,371301],[422174,371301],[422174,371302],[422174,371303],[422174,371304],[422174,371304],[422174,371304],[422174,371313],[422174,371313],[422174,371314],[422174,371314],[422175,371314],[422175,371315],[422175,371315],[422175,371316],[422175,371316],[422175,371317],[422175,371317],[422175,371318],[422175,371318],[422175,371319],[422175,371319],[422175,371319],[422175,371320],[422175,371320],[422175,371321],[422175,371321],[422175,371322],[422175,371322],[422175,371323],[422175,371323],[422175,371323],[422175,371324],[422175,371324],[422175,371325],[422175,371325],[422175,371326],[422175,371326],[422175,371327],[422175,371327],[422175,371328],[422175,371328],[422175,371328],[422175,371329],[422175,371329],[422175,371330],[422175,371330],[422175,371331],[422175,371331],[422175,371332],[422175,371332],[422175,371332],[422175,371333],[422175,371333],[422175,371334],[422175,371334],[422175,371335],[422175,371335],[422175,371336],[422175,371336],[422175,371336],[422175,371337],[422175,371337],[422175,371337],[422175,371338],[422175,371338],[422175,371338],[422175,371339],[422175,371339],[422175,371339],[422175,371340],[422175,371340],[422175,371340],[422175,371341],[422175,371341],[422175,371341],[422175,371342],[422175,371342],[422175,371342],[422175,371343],[422175,371343],[422175,371343],[422175,371344],[422175,371344],[422175,371344],[422175,371345],[422175,371345],[422175,371345],[422175,371346],[422175,371346],[422175,371346],[422175,371347],[422175,371347],[422175,371347],[422175,371348],[422175,371348],[422175,371348],[422175,371349],[422175,371349],[422175,371349],[422175,371350],[422175,371350],[422175,371350],[422175,371351],[422175,371351],[422175,371351],[422175,371352],[422175,371352],[422175,371352],[422175,371362],[422175,371363],[422175,371363],[422175,371364],[422175,371364],[422175,371365],[422175,371366],[422175,371366],[422175,371367],[422175,371367],[422175,371368],[422175,371368],[422175,371369],[422175,371370],[422175,371370],[422175,371371],[422175,371371],[422175,371372],[422175,371372],[422175,371373],[422175,371374],[422175,371374],[422175,371375],[422175,371375],[422175,371376],[422175,371376],[422175,371377],[422175,371378],[422175,371378],[422175,371379],[422175,371379],[422175,371380],[422175,371380],[422175,371381],[422175,371381],[422175,371382],[422175,371383],[422175,371383],[422175,371384],[422175,371384],[422175,371385],[422175,371385],[422175,371386],[422175,371386],[422175,371387],[422175,371388],[422175,371388],[422176,371389],[422176,371389],[422176,371390],[422176,371390],[422176,371391],[422176,371391],[422176,371391],[422176,371392],[422176,371392],[422176,371393],[422176,371393],[422176,371393],[422176,371394],[422176,371394],[422176,371394],[422176,371395],[422176,371395],[422176,371396],[422176,371396],[422176,371396],[422176,371397],[422176,371397],[422176,371397],[422176,371398],[422176,371398],[422176,371399],[422176,371399],[422176,371399],[422177,371400],[422177,371400],[422177,371401],[422177,371401],[422177,371401],[422177,371402],[422177,371402],[422177,371403],[422177,371403],[422177,371403],[422177,371404],[422177,371404],[422177,371404],[422177,371405],[422177,371405],[422177,371406],[422177,371406],[422178,371406],[422178,371407],[422178,371407],[422178,371408],[422178,371408],[422178,371408],[422178,371409],[422178,371410],[422178,371410],[422178,371410],[422178,371411],[422178,371411],[422179,371412],[422179,371412],[422179,371413],[422179,371413],[422179,371414],[422179,371414],[422179,371415],[422179,371415],[422179,371416],[422180,371416],[422180,371417],[422180,371417],[422180,371418],[422180,371418],[422180,371419],[422180,371419],[422180,371420],[422180,371420],[422181,371421],[422181,371421],[422181,371422],[422181,371422],[422181,371422],[422181,371423],[422181,371423],[422181,371424],[422181,371424],[422182,371425],[422182,371425],[422182,371425],[422182,371426],[422182,371426],[422182,371427],[422182,371427],[422182,371428],[422182,371428],[422183,371428],[422183,371429],[422183,371429],[422183,371429],[422183,371430],[422183,371430],[422183,371431],[422183,371431],[422184,371431],[422184,371432],[422184,371432],[422184,371432],[422184,371432],[422184,371433],[422184,371433],[422184,371433],[422184,371433],[422184,371433],[422184,371434],[422184,371434],[422185,371434],[422185,371434],[422185,371435],[422185,371435],[422185,371435],[422185,371435],[422185,371436],[422185,371436],[422185,371436],[422186,371437],[422186,371437],[422186,371437],[422186,371438],[422186,371438],[422186,371438],[422186,371438],[422187,371439],[422187,371439],[422187,371439],[422187,371440],[422187,371440],[422187,371441],[422187,371441],[422188,371441],[422188,371442],[422188,371442],[422188,371442],[422188,371443],[422188,371443],[422189,371443],[422189,371443],[422189,371444],[422189,371444],[422189,371444],[422189,371445],[422189,371445],[422189,371445],[422190,371446],[422190,371446],[422190,371446],[422190,371446],[422190,371447],[422191,371448],[422191,371449],[422191,371450],[422192,371451],[422192,371451],[422193,371452],[422193,371453],[422193,371454],[422194,371454],[422194,371455],[422194,371456],[422195,371457],[422195,371457],[422195,371458],[422195,371459],[422196,371459],[422196,371460],[422196,371461],[422197,371461],[422197,371462],[422197,371463],[422197,371463],[422198,371464],[422198,371465],[422198,371465],[422198,371466],[422199,371466],[422199,371467],[422199,371468],[422199,371468],[422200,371469],[422200,371469],[422200,371470],[422200,371470],[422200,371471],[422201,371472],[422201,371472],[422201,371473],[422201,371473],[422201,371474],[422202,371474],[422202,371475],[422202,371475],[422202,371476],[422202,371476],[422202,371477],[422202,371477],[422203,371478],[422203,371478],[422203,371479],[422203,371480],[422203,371480],[422203,371481],[422203,371482],[422204,371482],[422204,371483],[422204,371484],[422204,371484],[422204,371485],[422204,371486],[422205,371486],[422205,371487],[422205,371488],[422205,371489],[422205,371489],[422205,371490],[422205,371491],[422205,371491],[422206,371492],[422206,371493],[422206,371493],[422206,371494],[422206,371495],[422206,371495],[422206,371496],[422207,371497],[422207,371497],[422207,371498],[422207,371499],[422207,371499],[422207,371500],[422207,371501],[422207,371501],[422208,371502],[422208,371503],[422208,371503],[422208,371504],[422208,371505],[422208,371505],[422208,371506],[422209,371507],[422209,371507],[422209,371508],[422209,371509],[422209,371509],[422209,371510],[422209,371511],[422210,371512],[422210,371512],[422210,371513],[422210,371513],[422210,371514],[422211,371514],[422211,371515],[422211,371516],[422211,371516],[422212,371516],[422212,371517],[422212,371517],[422213,371518],[422213,371518],[422214,371518],[422214,371519],[422214,371519],[422215,371519],[422215,371520],[422216,371520],[422216,371520],[422217,371520],[422217,371521],[422218,371521],[422218,371521],[422219,371521],[422219,371521],[422220,371521],[422220,371521],[422221,371522],[422221,371522],[422222,371522],[422222,371522],[422223,371522],[422224,371522],[422224,371522],[422225,371522],[422225,371522],[422226,371522],[422226,371522],[422227,371522],[422228,371522],[422228,371522],[422229,371522],[422229,371522],[422230,371522],[422230,371522],[422231,371522],[422231,371522],[422232,371522],[422233,371522],[422233,371522],[422233,371522],[424138,371522],[424168,371526],[424353,371526],[424400,371531],[424569,371579],[424870,371725],[424916,371740],[424946,371745],[424973,371742],[424983,371743],[425144,371787],[425198,372082],[425204,372095],[425214,372106],[425313,372196],[425324,372194],[425369,372151],[425713,372098],[425764,372105],[425917,372148],[426085,372217],[426191,372284],[426212,372293],[426267,372269],[426315,372286],[426368,372272],[426850,372228],[427173,372124],[427193,372122],[427391,372139],[427420,372139],[427468,372132],[427497,372116],[427532,372101],[427560,372098],[427576,372099],[427645,372112],[427662,372113],[427666,372113],[427936,372053],[427975,372034],[428006,372014],[428181,371812],[428269,371728],[428321,371686],[428372,371654],[428424,371639],[428443,371638],[428522,371642],[428519,371731],[428797,371907],[428817,371916],[428844,371926],[429134,371995],[430178,372006],[430178,386593],[430148,386596]] };
$maps{"J:211"} = { bbox => [[395331, 349307], [429881, 372609]], area => '702.3515445', series => 'J', number => '211', parent => 'J:211', title => 'Peak District South', polygon => [[429834,360287],[429803,360316],[429731,360360],[429731,360360],[429726,360364],[429660,360417],[429595,360459],[429599,360459],[429534,360495],[429472,360517],[429341,360543],[429323,360589],[429323,361311],[429324,361311],[429323,361368],[429333,361422],[429374,361494],[429398,361606],[429473,361740],[429631,361783],[429631,372359],[411473,372359],[411438,372412],[411397,372459],[411398,372459],[411350,372499],[411246,372529],[411236,372529],[411179,372516],[411160,372509],[411050,372454],[410954,372424],[410925,372423],[410859,372430],[410768,372464],[410679,372515],[410612,372572],[410562,372595],[410536,372597],[410509,372594],[410467,372575],[410343,372498],[410279,372485],[410257,372484],[410225,372487],[410185,372498],[410159,372512],[410119,372522],[410089,372524],[410061,372522],[409885,372492],[409860,372492],[409817,372498],[409595,372554],[409496,372564],[409426,372563],[409386,372557],[409346,372545],[409302,372525],[409258,372495],[409236,372466],[409231,372459],[409232,372459],[409209,372424],[409195,372409],[409195,372409],[409158,372378],[409121,372359],[408721,372359],[408715,372399],[408707,372419],[408702,372429],[408695,372439],[408687,372448],[408675,372459],[408633,372487],[408535,372532],[408467,372550],[408353,372568],[408345,372569],[408310,372563],[408273,372545],[408252,372526],[408140,372517],[408082,372519],[408018,372527],[407795,372588],[407762,372609],[404177,372609],[404164,372584],[404146,372529],[404136,372459],[404136,372459],[404129,372411],[404129,372409],[404129,372409],[404128,372359],[395331,372359],[395331,360459],[398206,360459],[398206,355654],[398445,355678],[398457,355680],[398466,355640],[398558,355662],[398654,355673],[399449,355673],[399605,355596],[399630,355543],[399656,355514],[399688,355494],[399728,355482],[399786,355479],[399822,355488],[399867,355513],[400007,355678],[400028,355694],[400049,355703],[400051,355703],[400059,355702],[400071,355694],[400338,355436],[400665,355230],[400684,355212],[400896,354958],[400895,354957],[400930,354924],[400931,354925],[401170,354718],[401640,354429],[402084,353957],[402141,353877],[402175,353838],[402205,353811],[402261,353776],[402261,353775],[402304,353751],[402304,353751],[403522,353135],[403978,352778],[404451,352545],[404696,352449],[405137,352171],[405383,351976],[405718,351622],[405976,351424],[406003,351398],[406066,351309],[406148,351216],[406344,350909],[406382,350867],[406441,350821],[406483,350799],[406830,350682],[406890,350670],[407158,350642],[407226,350627],[407306,350602],[407563,350486],[407651,350456],[407920,350419],[407963,350409],[407963,350410],[408003,350395],[408044,350374],[408108,350323],[408162,350261],[408190,350236],[408219,350220],[408264,350205],[408516,350150],[408565,350147],[408681,350157],[408827,350157],[408857,350153],[408888,350144],[409015,350078],[409108,350042],[409190,350019],[409205,350013],[409222,350000],[409258,349979],[409334,349961],[409376,349956],[409419,349961],[409539,349992],[409544,349992],[409557,349986],[409577,349973],[409590,349961],[409617,349918],[409637,349893],[409662,349871],[409757,349808],[409768,349796],[409917,349557],[409917,349557],[409939,349523],[409939,349523],[409984,349457],[409984,349457],[410036,349382],[410122,349307],[419730,349307],[419733,349314],[419740,349326],[419938,349557],[425503,349557],[425591,349716],[425599,349750],[425613,349872],[425695,350142],[425711,350178],[425727,350195],[425742,350217],[425785,350402],[425786,350435],[425798,350492],[425803,350499],[425936,350560],[425964,350576],[425993,350599],[426011,350619],[426023,350628],[426491,350761],[426526,350764],[426506,350858],[426503,350896],[426526,351288],[426549,351426],[426540,351881],[426557,351935],[426566,352016],[426564,352048],[426589,352157],[426603,352262],[426612,352299],[426634,352362],[426642,352400],[426652,352424],[426669,352451],[426684,352489],[426695,352533],[426706,352635],[426696,352723],[426700,352785],[426686,352860],[426687,352869],[426691,352878],[426753,352943],[426821,353029],[426841,353089],[426849,353124],[427146,353249],[428374,353249],[428564,353319],[428567,353359],[428575,353396],[428686,353647],[428715,353736],[428731,353817],[428730,353890],[428711,353951],[428696,353971],[428710,354080],[428728,354121],[428771,354199],[428792,354264],[428789,354313],[428788,354317],[428778,354350],[428771,354405],[428771,354521],[428776,354571],[428843,354741],[428843,354742],[428930,354880],[428955,354945],[428974,355039],[428973,355160],[428995,355305],[428978,355642],[428992,355736],[429020,355842],[429029,355861],[429058,355897],[429117,355992],[429221,356355],[429242,356405],[429250,356433],[429255,356481],[429263,356496],[429265,356499],[429292,356511],[429337,356528],[429361,356551],[429389,356599],[429413,356657],[429436,356742],[429443,356753],[429593,356893],[429624,356916],[429631,356912],[429631,356921],[429669,356989],[429647,357001],[429631,357016],[429631,358312],[429681,358312],[429681,358312],[429881,358312],[429881,360266],[429834,360287]] };
$maps{"J:301"} = { bbox => [[252292, 349010], [280960, 372340]], area => '567.899619', series => 'J', number => '301', parent => 'J:301', title => 'Snowdonia North', polygon => [[252292,349010],[278264,349013],[278677,349649],[278992,350489],[279186,350483],[280030,351828],[280441,352256],[280947,352905],[280960,360453],[280564,361042],[280509,361525],[280402,361831],[280133,362283],[279509,362768],[279064,364319],[279113,365617],[278329,367158],[278099,367945],[278392,368293],[278189,369578],[278453,370810],[278641,371046],[278913,371777],[279486,372088],[273407,372120],[273309,372340],[264310,372340],[263718,372088],[259142,372039],[259178,371698],[259662,370947],[259644,370641],[259238,369979],[259283,369572],[260244,368962],[260365,368320],[259979,367670],[259960,367219],[260298,366488],[259857,365769],[259057,365348],[258984,364897],[258365,364760],[258128,364855],[257732,365050],[257033,364517],[256664,364018],[255838,364163],[255209,363951],[255209,360530],[252669,360526],[252634,360102],[252292,360045],[252292,349010]] };
$maps{"J:302"} = { bbox => [[271477, 316034], [289072, 340294]], area => '341.2676785', series => 'J', number => '302', parent => 'J:302', title => 'Snowdonia: Arans', polygon => [[274473,336123],[274425,336123],[274497,328140],[271884,328140],[271908,323802],[272771,323825],[272843,322962],[273322,322363],[273371,321836],[272843,321069],[272028,321021],[272004,319534],[271525,319367],[271477,318168],[272292,317689],[274761,317593],[275504,317233],[276463,317185],[276463,317065],[276774,316610],[278596,317281],[280107,317113],[281473,316322],[283846,316298],[284134,316034],[286866,316058],[286891,316442],[288688,316466],[288664,320541],[289072,320254],[289072,326007],[288592,325431],[288616,339934],[287921,339934],[288089,340270],[284661,340294],[284134,339958],[282767,339958],[282456,339766],[281976,339431],[281209,339215],[280730,338424],[280154,338352],[279555,338232],[279220,338400],[278740,338712],[277973,338256],[277781,337945],[277230,337537],[277038,337225],[275863,336674],[275480,336123],[274473,336123]] };
$maps{"J:303"} = { bbox => [[257525, 315411], [274689, 339598]], area => '285.1744635', series => 'J', number => '303', parent => 'J:303', title => 'Snowdonia: Rhinogs', polygon => [[263015,339287],[263063,339311],[262775,338544],[262224,338496],[261888,337585],[261169,337369],[261145,335787],[260833,334948],[260857,334349],[260210,333822],[260018,333174],[260186,332719],[258868,331352],[258125,331472],[257525,329387],[257909,328883],[257789,328332],[258676,326678],[258412,326294],[258580,323921],[258748,323346],[258844,322219],[259851,318887],[259563,318839],[259491,318719],[260522,315411],[263183,315411],[263470,315915],[264117,316394],[264957,316466],[265724,316802],[266035,317305],[266754,317353],[266994,317425],[267857,318168],[269104,318024],[269871,318360],[271884,317497],[272891,317161],[273467,317185],[274018,317976],[274329,319319],[274234,319678],[274689,320541],[274665,321117],[274473,321308],[274665,322099],[274329,322531],[273802,322675],[273418,322531],[273155,322890],[272795,325216],[271812,327661],[271117,333031],[271189,335212],[270686,336506],[270997,337249],[269919,338376],[269391,339407],[268864,339598],[268600,339263],[265963,339239],[265076,339598],[264453,339431],[264166,339551],[263015,339287]] };
$maps{"J:304"} = { bbox => [[263398, 301172], [287034, 318623]], area => '334.38808', series => 'J', number => '304', parent => 'J:304', title => 'Snowdonia: Cadair Idris', polygon => [[265604,318264],[265652,318240],[265604,316969],[265124,315915],[263398,315891],[263398,301484],[264309,301484],[264501,301172],[265724,301196],[265724,301532],[275168,301532],[275192,304073],[281521,304073],[282647,304600],[283894,305751],[284781,307381],[284637,308100],[284781,309323],[285237,309970],[285332,310641],[286147,311264],[286411,312079],[286123,312942],[286267,313541],[286099,313877],[286267,314237],[285956,314692],[287034,315723],[287010,318264],[279843,318264],[279987,318024],[279675,317185],[278596,317257],[276774,316586],[276079,317761],[276367,318240],[275936,318240],[275264,318432],[275096,318264],[271549,318264],[270374,318623],[269248,318264],[265604,318264]] };
$maps{"J:305"} = { bbox => [[292212, 208403], [316255, 225974]], area => '333.563634', series => 'J', number => '305', parent => 'J:305', title => 'Brecon Beacons East', polygon => [[294969,225615],[294967,225589],[294969,225567],[295041,223146],[292500,223122],[292524,220125],[292212,219814],[292428,219670],[292548,218375],[292572,211448],[294681,211448],[294537,209219],[294609,208787],[295017,208715],[295137,208907],[302448,208907],[302592,208427],[304246,208403],[304246,211448],[314146,211447],[314146,211831],[315608,212934],[315992,212934],[315992,216314],[315776,216506],[315896,217560],[315321,217368],[315273,217656],[315201,218567],[316255,219310],[315464,219670],[315057,221588],[315440,221995],[314290,222498],[313930,222283],[313091,222523],[312420,223433],[311725,224512],[310023,225351],[309783,225639],[308920,225615],[308417,225879],[308177,225926],[307578,225687],[306595,225950],[306475,225615],[299979,225615],[299739,225950],[299428,225974],[299476,225615],[294969,225615]] };
$maps{"J:306"} = { bbox => [[271645, 208355], [295664, 225902]], area => '334.1674055', series => 'J', number => '306', parent => 'J:306', title => 'Brecon Beacons West', polygon => [[276847,225423],[276847,225447],[275912,224464],[275121,224320],[273778,223601],[273898,222426],[272963,221348],[273994,219598],[273107,219574],[272508,219214],[273083,219262],[273395,218519],[272724,217896],[271741,216482],[272652,215667],[271669,214732],[271645,214156],[272939,214012],[274090,213653],[275528,211352],[279316,211328],[279747,211471],[280179,211447],[280658,212191],[281066,212478],[282240,212526],[282624,212119],[283607,211999],[284661,211328],[285668,210033],[286962,209578],[287562,209146],[289168,208739],[292859,208763],[293075,208355],[295161,208355],[294873,208907],[295664,208859],[295640,225447],[285141,225447],[285428,225902],[283055,225855],[282983,225447],[277638,225447],[277350,225710],[276847,225423]] };
$maps{"J:401"} = { bbox => [[214162, 464312], [250179, 505023]], area => '791.665297', series => 'J', number => '401', parent => 'J:401', title => 'Isle of Man', polygon => [[247159,494715],[247159,503441],[247471,503488],[247471,504615],[246056,505023],[245505,504591],[235844,504615],[235844,501211],[232560,501211],[232560,494283],[232544,494235],[232321,494235],[231961,493708],[228605,493708],[228605,491095],[228581,491095],[227454,491095],[227454,487955],[224026,487931],[224050,485270],[220311,485246],[220335,479085],[218728,479085],[218728,471174],[218318,470518],[214162,465619],[214174,465619],[214162,464780],[214809,464780],[215049,464312],[216212,464312],[216583,464816],[221641,464828],[221641,465445],[227382,465445],[227550,465014],[228653,465014],[229012,465469],[230618,465469],[230594,466380],[235269,471870],[238889,471870],[238889,473979],[239296,474243],[239296,475870],[239824,475873],[239992,476424],[243755,476424],[243755,478773],[246823,479325],[249652,479325],[249652,490424],[250179,490903],[250179,492078],[247159,494715]] };
1;

=pod

=head1 NAME

Geo::Coordinates::OSGB::Maps - Data for OSGB Maps

=head1 SUBROUTINES AND METHODS

This module exports no functions, but two hashes of data.

=head2 Hash C<%name_for_map_series>

The keys are the single letter codes used for each map series.  
The values are the descriptive names of each series.

Currently (V2.12) we have

  A => 'OS Landranger', 
  B => 'OS Explorer',
  C => 'OS One-Inch 7th series',
  H => 'Harvey British Mountain maps',
  J => 'Harvey Superwalker',

=head2 Hash C<%maps>

The keys are short identifiers for each sheet or inset.  Where a map has more than one side, or includes
insets then, there will be a separate entry for each side and inset.

The value for each key is another hash containing the following items

=over 4

=item bbox

The bounding box of the sheet as a list of two pairs of coordinates (in metres
from the grid origin)

=item polygon

A list of pairs of coordinates (in metres from grid origin) that define the
corners of the sheet.  The list starts at the SW corner (approximately, on some
sheets it's not entirely obvious where to start), and works round
anticlockwise.  In all cases the last pair is the same as the first pair.

=item area 

The calculated area of the sheet in square kilometres

=item series

A single letter series identifier -- this will be one of the keys from the
"name_for_map_series" hash

=item number

The identifier for this map within the series, not including any suffix for a
sheet or an inset.  The two sides of a single map have the same number.  The
number is not always an integer - Outdoor Leisure maps are designated "OL14"
etc.  Those maps known by two numbers have a "number" consisting of both
numbers divided by a "/"; such as "418/OL60" in the Explorer series.

=item parent

The key of the parent map for an inset.  Main sheets of a map, will have
"parent" equal to their own key.

=item title

The title of the map.  Different sheets and insets from the same map will have
the same title.

=back

=cut

