use v5.32;
use utf8;
package Art::World;


# use Art::Agent;
#has Art::Agent::Artist @.artists;

our $VERSION = '0.15';

1;

=encoding UTF-8

=head1 NAME

Art::World - An Art World simulator game 🎨

=head1 SYNOPSIS

  use Art::World;

=head1 DESCRIPTION

Art::World is an attempt to model an art world simulation system. If a
correct API is reached, we'll try to build a "game of art" frontend.

=over

=item 01 Idea is the first step of process

=item 02 Idea is inserted in the file (through process)

=item 03 Idea comes from discourse (given about project)

=item 04 Idea come when there is no time left

=item 05 Ideas constitue the project

=back

=over

=item 06 Process allows ideas to evolve

=item 07 Process allows to fill the file (with ideas + discourse)

=item 08 Process allows to generate some discourse

=item 09 Process allows to save time

=item 10 Process allows to set up the project

=back

=over

=item 11 File is made of ideas

=item 12 File is filled and emptied with the process

=item 13 File is made of discourse

=item 14 File archive ideas, that makes possible to forget them

=item 15 File generate a project

=back

=over

=item 16 Discourse steers ideas

=item 17 Discourse analyze process

=item 18 Discourse talks about the file

=item 19 Discourse allows to link various stages of the projet

=item 20 Discourse is a constituent of the project

=back

=over

=item 21 From time to time, ideas appears

=item 22 Time needed to apply the process

=item 23 Time is suspended into file, process is off there

=item 24 Discourse's time (reading time)

=item 25 Various times contained in project give it's shape

=back

=over

=item 26 Project is updated by new ideas

=item 27 Project is constantly updated by the process

=item 28 Project is set up when file is updated

=item 29 Project and discourse are inseparable

=item 30 Project is what takes the longuest time to set up

=back

=head1 HISTORY

This is a long term continuation of an art project started circa 2006.

=head1 AUTHOR

Sébastien Feugère <sebastien@feugere.net>
Seb. Hu-Rillettes <shr@balik.network>

=head1 COPYRIGHT AND LICENSE

Copyright 2006-2020 Seb. Hu-Rillettes

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.

=cut
