package Date::Manip::TZ::asbish00;
# Copyright (c) 2008-2012 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Tue Aug 28 10:05:06 EDT 2012
#    Data version: tzdata2012e
#    Code version: tzcode2012e

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

=pod

=head1 NAME

Date::Manip::TZ::asbish00 - Support for the Asia/Bishkek time zone

=head1 SYNPOSIS

This module contains data describing a time zone.  Most of the time zone
data comes from the Olsen database, but there are a few exceptions.

This module is not intended to be used directly.  Other Date::Manip modules
will load it as needed.

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.34';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,4,58,24],'+04:58:24',[4,58,24],
          'LMT',0,[1924,5,1,19,1,35],[1924,5,1,23,59,59],
          '0001010200:00:00','0001010204:58:24','1924050119:01:35','1924050123:59:59' ],
     ],
   1924 =>
     [
        [ [1924,5,1,19,1,36],[1924,5,2,0,1,36],'+05:00:00',[5,0,0],
          'FRUT',0,[1930,6,20,18,59,59],[1930,6,20,23,59,59],
          '1924050119:01:36','1924050200:01:36','1930062018:59:59','1930062023:59:59' ],
     ],
   1930 =>
     [
        [ [1930,6,20,19,0,0],[1930,6,21,1,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1981,3,31,17,59,59],[1981,3,31,23,59,59],
          '1930062019:00:00','1930062101:00:00','1981033117:59:59','1981033123:59:59' ],
     ],
   1981 =>
     [
        [ [1981,3,31,18,0,0],[1981,4,1,1,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1981,9,30,16,59,59],[1981,9,30,23,59,59],
          '1981033118:00:00','1981040101:00:00','1981093016:59:59','1981093023:59:59' ],
        [ [1981,9,30,17,0,0],[1981,9,30,23,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1982,3,31,17,59,59],[1982,3,31,23,59,59],
          '1981093017:00:00','1981093023:00:00','1982033117:59:59','1982033123:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,31,18,0,0],[1982,4,1,1,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1982,9,30,16,59,59],[1982,9,30,23,59,59],
          '1982033118:00:00','1982040101:00:00','1982093016:59:59','1982093023:59:59' ],
        [ [1982,9,30,17,0,0],[1982,9,30,23,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1983,3,31,17,59,59],[1983,3,31,23,59,59],
          '1982093017:00:00','1982093023:00:00','1983033117:59:59','1983033123:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,31,18,0,0],[1983,4,1,1,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1983,9,30,16,59,59],[1983,9,30,23,59,59],
          '1983033118:00:00','1983040101:00:00','1983093016:59:59','1983093023:59:59' ],
        [ [1983,9,30,17,0,0],[1983,9,30,23,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1984,3,31,17,59,59],[1984,3,31,23,59,59],
          '1983093017:00:00','1983093023:00:00','1984033117:59:59','1984033123:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,31,18,0,0],[1984,4,1,1,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1984,9,29,19,59,59],[1984,9,30,2,59,59],
          '1984033118:00:00','1984040101:00:00','1984092919:59:59','1984093002:59:59' ],
        [ [1984,9,29,20,0,0],[1984,9,30,2,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1985,3,30,19,59,59],[1985,3,31,1,59,59],
          '1984092920:00:00','1984093002:00:00','1985033019:59:59','1985033101:59:59' ],
     ],
   1985 =>
     [
        [ [1985,3,30,20,0,0],[1985,3,31,3,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1985,9,28,19,59,59],[1985,9,29,2,59,59],
          '1985033020:00:00','1985033103:00:00','1985092819:59:59','1985092902:59:59' ],
        [ [1985,9,28,20,0,0],[1985,9,29,2,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1986,3,29,19,59,59],[1986,3,30,1,59,59],
          '1985092820:00:00','1985092902:00:00','1986032919:59:59','1986033001:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,29,20,0,0],[1986,3,30,3,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1986,9,27,19,59,59],[1986,9,28,2,59,59],
          '1986032920:00:00','1986033003:00:00','1986092719:59:59','1986092802:59:59' ],
        [ [1986,9,27,20,0,0],[1986,9,28,2,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1987,3,28,19,59,59],[1987,3,29,1,59,59],
          '1986092720:00:00','1986092802:00:00','1987032819:59:59','1987032901:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,28,20,0,0],[1987,3,29,3,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1987,9,26,19,59,59],[1987,9,27,2,59,59],
          '1987032820:00:00','1987032903:00:00','1987092619:59:59','1987092702:59:59' ],
        [ [1987,9,26,20,0,0],[1987,9,27,2,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1988,3,26,19,59,59],[1988,3,27,1,59,59],
          '1987092620:00:00','1987092702:00:00','1988032619:59:59','1988032701:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,26,20,0,0],[1988,3,27,3,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1988,9,24,19,59,59],[1988,9,25,2,59,59],
          '1988032620:00:00','1988032703:00:00','1988092419:59:59','1988092502:59:59' ],
        [ [1988,9,24,20,0,0],[1988,9,25,2,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1989,3,25,19,59,59],[1989,3,26,1,59,59],
          '1988092420:00:00','1988092502:00:00','1989032519:59:59','1989032601:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,25,20,0,0],[1989,3,26,3,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1989,9,23,19,59,59],[1989,9,24,2,59,59],
          '1989032520:00:00','1989032603:00:00','1989092319:59:59','1989092402:59:59' ],
        [ [1989,9,23,20,0,0],[1989,9,24,2,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1990,3,24,19,59,59],[1990,3,25,1,59,59],
          '1989092320:00:00','1989092402:00:00','1990032419:59:59','1990032501:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,24,20,0,0],[1990,3,25,3,0,0],'+07:00:00',[7,0,0],
          'FRUST',1,[1990,9,29,19,59,59],[1990,9,30,2,59,59],
          '1990032420:00:00','1990032503:00:00','1990092919:59:59','1990093002:59:59' ],
        [ [1990,9,29,20,0,0],[1990,9,30,2,0,0],'+06:00:00',[6,0,0],
          'FRUT',0,[1991,3,30,19,59,59],[1991,3,31,1,59,59],
          '1990092920:00:00','1990093002:00:00','1991033019:59:59','1991033101:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,30,20,0,0],[1991,3,31,2,0,0],'+06:00:00',[6,0,0],
          'FRUST',1,[1991,8,30,19,59,59],[1991,8,31,1,59,59],
          '1991033020:00:00','1991033102:00:00','1991083019:59:59','1991083101:59:59' ],
        [ [1991,8,30,20,0,0],[1991,8,31,1,0,0],'+05:00:00',[5,0,0],
          'KGT',0,[1992,4,11,18,59,59],[1992,4,11,23,59,59],
          '1991083020:00:00','1991083101:00:00','1992041118:59:59','1992041123:59:59' ],
     ],
   1992 =>
     [
        [ [1992,4,11,19,0,0],[1992,4,12,1,0,0],'+06:00:00',[6,0,0],
          'KGST',1,[1992,9,26,17,59,59],[1992,9,26,23,59,59],
          '1992041119:00:00','1992041201:00:00','1992092617:59:59','1992092623:59:59' ],
        [ [1992,9,26,18,0,0],[1992,9,26,23,0,0],'+05:00:00',[5,0,0],
          'KGT',0,[1993,4,10,18,59,59],[1993,4,10,23,59,59],
          '1992092618:00:00','1992092623:00:00','1993041018:59:59','1993041023:59:59' ],
     ],
   1993 =>
     [
        [ [1993,4,10,19,0,0],[1993,4,11,1,0,0],'+06:00:00',[6,0,0],
          'KGST',1,[1993,9,25,17,59,59],[1993,9,25,23,59,59],
          '1993041019:00:00','1993041101:00:00','1993092517:59:59','1993092523:59:59' ],
        [ [1993,9,25,18,0,0],[1993,9,25,23,0,0],'+05:00:00',[5,0,0],
          'KGT',0,[1994,4,9,18,59,59],[1994,4,9,23,59,59],
          '1993092518:00:00','1993092523:00:00','1994040918:59:59','1994040923:59:59' ],
     ],
   1994 =>
     [
        [ [1994,4,9,19,0,0],[1994,4,10,1,0,0],'+06:00:00',[6,0,0],
          'KGST',1,[1994,9,24,17,59,59],[1994,9,24,23,59,59],
          '1994040919:00:00','1994041001:00:00','1994092417:59:59','1994092423:59:59' ],
        [ [1994,9,24,18,0,0],[1994,9,24,23,0,0],'+05:00:00',[5,0,0],
          'KGT',0,[1995,4,8,18,59,59],[1995,4,8,23,59,59],
          '1994092418:00:00','1994092423:00:00','1995040818:59:59','1995040823:59:59' ],
     ],
   1995 =>
     [
        [ [1995,4,8,19,0,0],[1995,4,9,1,0,0],'+06:00:00',[6,0,0],
          'KGST',1,[1995,9,23,17,59,59],[1995,9,23,23,59,59],
          '1995040819:00:00','1995040901:00:00','1995092317:59:59','1995092323:59:59' ],
        [ [1995,9,23,18,0,0],[1995,9,23,23,0,0],'+05:00:00',[5,0,0],
          'KGT',0,[1996,4,6,18,59,59],[1996,4,6,23,59,59],
          '1995092318:00:00','1995092323:00:00','1996040618:59:59','1996040623:59:59' ],
     ],
   1996 =>
     [
        [ [1996,4,6,19,0,0],[1996,4,7,1,0,0],'+06:00:00',[6,0,0],
          'KGST',1,[1996,9,28,17,59,59],[1996,9,28,23,59,59],
          '1996040619:00:00','1996040701:00:00','1996092817:59:59','1996092823:59:59' ],
        [ [1996,9,28,18,0,0],[1996,9,28,23,0,0],'+05:00:00',[5,0,0],
          'KGT',0,[1997,3,29,21,29,59],[1997,3,30,2,29,59],
          '1996092818:00:00','1996092823:00:00','1997032921:29:59','1997033002:29:59' ],
     ],
   1997 =>
     [
        [ [1997,3,29,21,30,0],[1997,3,30,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[1997,10,25,20,29,59],[1997,10,26,2,29,59],
          '1997032921:30:00','1997033003:30:00','1997102520:29:59','1997102602:29:59' ],
        [ [1997,10,25,20,30,0],[1997,10,26,1,30,0],'+05:00:00',[5,0,0],
          'KGT',0,[1998,3,28,21,29,59],[1998,3,29,2,29,59],
          '1997102520:30:00','1997102601:30:00','1998032821:29:59','1998032902:29:59' ],
     ],
   1998 =>
     [
        [ [1998,3,28,21,30,0],[1998,3,29,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[1998,10,24,20,29,59],[1998,10,25,2,29,59],
          '1998032821:30:00','1998032903:30:00','1998102420:29:59','1998102502:29:59' ],
        [ [1998,10,24,20,30,0],[1998,10,25,1,30,0],'+05:00:00',[5,0,0],
          'KGT',0,[1999,3,27,21,29,59],[1999,3,28,2,29,59],
          '1998102420:30:00','1998102501:30:00','1999032721:29:59','1999032802:29:59' ],
     ],
   1999 =>
     [
        [ [1999,3,27,21,30,0],[1999,3,28,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[1999,10,30,20,29,59],[1999,10,31,2,29,59],
          '1999032721:30:00','1999032803:30:00','1999103020:29:59','1999103102:29:59' ],
        [ [1999,10,30,20,30,0],[1999,10,31,1,30,0],'+05:00:00',[5,0,0],
          'KGT',0,[2000,3,25,21,29,59],[2000,3,26,2,29,59],
          '1999103020:30:00','1999103101:30:00','2000032521:29:59','2000032602:29:59' ],
     ],
   2000 =>
     [
        [ [2000,3,25,21,30,0],[2000,3,26,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[2000,10,28,20,29,59],[2000,10,29,2,29,59],
          '2000032521:30:00','2000032603:30:00','2000102820:29:59','2000102902:29:59' ],
        [ [2000,10,28,20,30,0],[2000,10,29,1,30,0],'+05:00:00',[5,0,0],
          'KGT',0,[2001,3,24,21,29,59],[2001,3,25,2,29,59],
          '2000102820:30:00','2000102901:30:00','2001032421:29:59','2001032502:29:59' ],
     ],
   2001 =>
     [
        [ [2001,3,24,21,30,0],[2001,3,25,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[2001,10,27,20,29,59],[2001,10,28,2,29,59],
          '2001032421:30:00','2001032503:30:00','2001102720:29:59','2001102802:29:59' ],
        [ [2001,10,27,20,30,0],[2001,10,28,1,30,0],'+05:00:00',[5,0,0],
          'KGT',0,[2002,3,30,21,29,59],[2002,3,31,2,29,59],
          '2001102720:30:00','2001102801:30:00','2002033021:29:59','2002033102:29:59' ],
     ],
   2002 =>
     [
        [ [2002,3,30,21,30,0],[2002,3,31,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[2002,10,26,20,29,59],[2002,10,27,2,29,59],
          '2002033021:30:00','2002033103:30:00','2002102620:29:59','2002102702:29:59' ],
        [ [2002,10,26,20,30,0],[2002,10,27,1,30,0],'+05:00:00',[5,0,0],
          'KGT',0,[2003,3,29,21,29,59],[2003,3,30,2,29,59],
          '2002102620:30:00','2002102701:30:00','2003032921:29:59','2003033002:29:59' ],
     ],
   2003 =>
     [
        [ [2003,3,29,21,30,0],[2003,3,30,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[2003,10,25,20,29,59],[2003,10,26,2,29,59],
          '2003032921:30:00','2003033003:30:00','2003102520:29:59','2003102602:29:59' ],
        [ [2003,10,25,20,30,0],[2003,10,26,1,30,0],'+05:00:00',[5,0,0],
          'KGT',0,[2004,3,27,21,29,59],[2004,3,28,2,29,59],
          '2003102520:30:00','2003102601:30:00','2004032721:29:59','2004032802:29:59' ],
     ],
   2004 =>
     [
        [ [2004,3,27,21,30,0],[2004,3,28,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[2004,10,30,20,29,59],[2004,10,31,2,29,59],
          '2004032721:30:00','2004032803:30:00','2004103020:29:59','2004103102:29:59' ],
        [ [2004,10,30,20,30,0],[2004,10,31,1,30,0],'+05:00:00',[5,0,0],
          'KGT',0,[2005,3,26,21,29,59],[2005,3,27,2,29,59],
          '2004103020:30:00','2004103101:30:00','2005032621:29:59','2005032702:29:59' ],
     ],
   2005 =>
     [
        [ [2005,3,26,21,30,0],[2005,3,27,3,30,0],'+06:00:00',[6,0,0],
          'KGST',1,[2005,8,11,17,59,59],[2005,8,11,23,59,59],
          '2005032621:30:00','2005032703:30:00','2005081117:59:59','2005081123:59:59' ],
        [ [2005,8,11,18,0,0],[2005,8,12,0,0,0],'+06:00:00',[6,0,0],
          'KGT',0,[9999,12,31,0,0,0],[9999,12,31,6,0,0],
          '2005081118:00:00','2005081200:00:00','9999123100:00:00','9999123106:00:00' ],
     ],
);

%LastRule      = (
);

1;
