package Date::Manip::TZ::askara00;
# Copyright (c) 2008-2009 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Tue Nov 24 11:04:40 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::askara00 - Support for the Asia/Karachi time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION='6.03';

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,4,28,12],'+04:28:12',[4,28,12],
          'LMT',0,[1906,12,31,19,31,47],[1906,12,31,23,59,59],
          '0001010200:00:00','0001010204:28:12','1906123119:31:47','1906123123:59:59' ],
     ],
   1906 =>
     [
        [ [1906,12,31,19,31,48],[1907,1,1,1,1,48],'+05:30:00',[5,30,0],
          'IST',0,[1942,8,31,18,29,59],[1942,8,31,23,59,59],
          '1906123119:31:48','1907010101:01:48','1942083118:29:59','1942083123:59:59' ],
     ],
   1942 =>
     [
        [ [1942,8,31,18,30,0],[1942,9,1,1,0,0],'+06:30:00',[6,30,0],
          'IST',1,[1945,10,14,17,29,59],[1945,10,14,23,59,59],
          '1942083118:30:00','1942090101:00:00','1945101417:29:59','1945101423:59:59' ],
     ],
   1945 =>
     [
        [ [1945,10,14,17,30,0],[1945,10,14,23,0,0],'+05:30:00',[5,30,0],
          'IST',0,[1951,9,29,18,29,59],[1951,9,29,23,59,59],
          '1945101417:30:00','1945101423:00:00','1951092918:29:59','1951092923:59:59' ],
     ],
   1951 =>
     [
        [ [1951,9,29,18,30,0],[1951,9,29,23,30,0],'+05:00:00',[5,0,0],
          'KART',0,[1971,3,25,18,59,59],[1971,3,25,23,59,59],
          '1951092918:30:00','1951092923:30:00','1971032518:59:59','1971032523:59:59' ],
     ],
   1971 =>
     [
        [ [1971,3,25,19,0,0],[1971,3,26,0,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2002,4,6,19,0,59],[2002,4,7,0,0,59],
          '1971032519:00:00','1971032600:00:00','2002040619:00:59','2002040700:00:59' ],
     ],
   2002 =>
     [
        [ [2002,4,6,19,1,0],[2002,4,7,1,1,0],'+06:00:00',[6,0,0],
          'PKST',1,[2002,10,5,18,0,59],[2002,10,6,0,0,59],
          '2002040619:01:00','2002040701:01:00','2002100518:00:59','2002100600:00:59' ],
        [ [2002,10,5,18,1,0],[2002,10,5,23,1,0],'+05:00:00',[5,0,0],
          'PKT',0,[2008,5,31,18,59,59],[2008,5,31,23,59,59],
          '2002100518:01:00','2002100523:01:00','2008053118:59:59','2008053123:59:59' ],
     ],
   2008 =>
     [
        [ [2008,5,31,19,0,0],[2008,6,1,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2008,10,31,17,59,59],[2008,10,31,23,59,59],
          '2008053119:00:00','2008060101:00:00','2008103117:59:59','2008103123:59:59' ],
        [ [2008,10,31,18,0,0],[2008,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2009,4,14,18,59,59],[2009,4,14,23,59,59],
          '2008103118:00:00','2008103123:00:00','2009041418:59:59','2009041423:59:59' ],
     ],
   2009 =>
     [
        [ [2009,4,14,19,0,0],[2009,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2009,10,31,17,59,59],[2009,10,31,23,59,59],
          '2009041419:00:00','2009041501:00:00','2009103117:59:59','2009103123:59:59' ],
        [ [2009,10,31,18,0,0],[2009,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2010,4,14,18,59,59],[2010,4,14,23,59,59],
          '2009103118:00:00','2009103123:00:00','2010041418:59:59','2010041423:59:59' ],
     ],
   2010 =>
     [
        [ [2010,4,14,19,0,0],[2010,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2010,10,31,17,59,59],[2010,10,31,23,59,59],
          '2010041419:00:00','2010041501:00:00','2010103117:59:59','2010103123:59:59' ],
        [ [2010,10,31,18,0,0],[2010,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2011,4,14,18,59,59],[2011,4,14,23,59,59],
          '2010103118:00:00','2010103123:00:00','2011041418:59:59','2011041423:59:59' ],
     ],
   2011 =>
     [
        [ [2011,4,14,19,0,0],[2011,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2011,10,31,17,59,59],[2011,10,31,23,59,59],
          '2011041419:00:00','2011041501:00:00','2011103117:59:59','2011103123:59:59' ],
        [ [2011,10,31,18,0,0],[2011,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2012,4,14,18,59,59],[2012,4,14,23,59,59],
          '2011103118:00:00','2011103123:00:00','2012041418:59:59','2012041423:59:59' ],
     ],
   2012 =>
     [
        [ [2012,4,14,19,0,0],[2012,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2012,10,31,17,59,59],[2012,10,31,23,59,59],
          '2012041419:00:00','2012041501:00:00','2012103117:59:59','2012103123:59:59' ],
        [ [2012,10,31,18,0,0],[2012,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2013,4,14,18,59,59],[2013,4,14,23,59,59],
          '2012103118:00:00','2012103123:00:00','2013041418:59:59','2013041423:59:59' ],
     ],
   2013 =>
     [
        [ [2013,4,14,19,0,0],[2013,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2013,10,31,17,59,59],[2013,10,31,23,59,59],
          '2013041419:00:00','2013041501:00:00','2013103117:59:59','2013103123:59:59' ],
        [ [2013,10,31,18,0,0],[2013,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2014,4,14,18,59,59],[2014,4,14,23,59,59],
          '2013103118:00:00','2013103123:00:00','2014041418:59:59','2014041423:59:59' ],
     ],
   2014 =>
     [
        [ [2014,4,14,19,0,0],[2014,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2014,10,31,17,59,59],[2014,10,31,23,59,59],
          '2014041419:00:00','2014041501:00:00','2014103117:59:59','2014103123:59:59' ],
        [ [2014,10,31,18,0,0],[2014,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2015,4,14,18,59,59],[2015,4,14,23,59,59],
          '2014103118:00:00','2014103123:00:00','2015041418:59:59','2015041423:59:59' ],
     ],
   2015 =>
     [
        [ [2015,4,14,19,0,0],[2015,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2015,10,31,17,59,59],[2015,10,31,23,59,59],
          '2015041419:00:00','2015041501:00:00','2015103117:59:59','2015103123:59:59' ],
        [ [2015,10,31,18,0,0],[2015,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2016,4,14,18,59,59],[2016,4,14,23,59,59],
          '2015103118:00:00','2015103123:00:00','2016041418:59:59','2016041423:59:59' ],
     ],
   2016 =>
     [
        [ [2016,4,14,19,0,0],[2016,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2016,10,31,17,59,59],[2016,10,31,23,59,59],
          '2016041419:00:00','2016041501:00:00','2016103117:59:59','2016103123:59:59' ],
        [ [2016,10,31,18,0,0],[2016,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2017,4,14,18,59,59],[2017,4,14,23,59,59],
          '2016103118:00:00','2016103123:00:00','2017041418:59:59','2017041423:59:59' ],
     ],
   2017 =>
     [
        [ [2017,4,14,19,0,0],[2017,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2017,10,31,17,59,59],[2017,10,31,23,59,59],
          '2017041419:00:00','2017041501:00:00','2017103117:59:59','2017103123:59:59' ],
        [ [2017,10,31,18,0,0],[2017,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2018,4,14,18,59,59],[2018,4,14,23,59,59],
          '2017103118:00:00','2017103123:00:00','2018041418:59:59','2018041423:59:59' ],
     ],
   2018 =>
     [
        [ [2018,4,14,19,0,0],[2018,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2018,10,31,17,59,59],[2018,10,31,23,59,59],
          '2018041419:00:00','2018041501:00:00','2018103117:59:59','2018103123:59:59' ],
        [ [2018,10,31,18,0,0],[2018,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2019,4,14,18,59,59],[2019,4,14,23,59,59],
          '2018103118:00:00','2018103123:00:00','2019041418:59:59','2019041423:59:59' ],
     ],
   2019 =>
     [
        [ [2019,4,14,19,0,0],[2019,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2019,10,31,17,59,59],[2019,10,31,23,59,59],
          '2019041419:00:00','2019041501:00:00','2019103117:59:59','2019103123:59:59' ],
        [ [2019,10,31,18,0,0],[2019,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2020,4,14,18,59,59],[2020,4,14,23,59,59],
          '2019103118:00:00','2019103123:00:00','2020041418:59:59','2020041423:59:59' ],
     ],
   2020 =>
     [
        [ [2020,4,14,19,0,0],[2020,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2020,10,31,17,59,59],[2020,10,31,23,59,59],
          '2020041419:00:00','2020041501:00:00','2020103117:59:59','2020103123:59:59' ],
        [ [2020,10,31,18,0,0],[2020,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2021,4,14,18,59,59],[2021,4,14,23,59,59],
          '2020103118:00:00','2020103123:00:00','2021041418:59:59','2021041423:59:59' ],
     ],
   2021 =>
     [
        [ [2021,4,14,19,0,0],[2021,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2021,10,31,17,59,59],[2021,10,31,23,59,59],
          '2021041419:00:00','2021041501:00:00','2021103117:59:59','2021103123:59:59' ],
        [ [2021,10,31,18,0,0],[2021,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2022,4,14,18,59,59],[2022,4,14,23,59,59],
          '2021103118:00:00','2021103123:00:00','2022041418:59:59','2022041423:59:59' ],
     ],
   2022 =>
     [
        [ [2022,4,14,19,0,0],[2022,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2022,10,31,17,59,59],[2022,10,31,23,59,59],
          '2022041419:00:00','2022041501:00:00','2022103117:59:59','2022103123:59:59' ],
        [ [2022,10,31,18,0,0],[2022,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2023,4,14,18,59,59],[2023,4,14,23,59,59],
          '2022103118:00:00','2022103123:00:00','2023041418:59:59','2023041423:59:59' ],
     ],
   2023 =>
     [
        [ [2023,4,14,19,0,0],[2023,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2023,10,31,17,59,59],[2023,10,31,23,59,59],
          '2023041419:00:00','2023041501:00:00','2023103117:59:59','2023103123:59:59' ],
        [ [2023,10,31,18,0,0],[2023,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2024,4,14,18,59,59],[2024,4,14,23,59,59],
          '2023103118:00:00','2023103123:00:00','2024041418:59:59','2024041423:59:59' ],
     ],
   2024 =>
     [
        [ [2024,4,14,19,0,0],[2024,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2024,10,31,17,59,59],[2024,10,31,23,59,59],
          '2024041419:00:00','2024041501:00:00','2024103117:59:59','2024103123:59:59' ],
        [ [2024,10,31,18,0,0],[2024,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2025,4,14,18,59,59],[2025,4,14,23,59,59],
          '2024103118:00:00','2024103123:00:00','2025041418:59:59','2025041423:59:59' ],
     ],
   2025 =>
     [
        [ [2025,4,14,19,0,0],[2025,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2025,10,31,17,59,59],[2025,10,31,23,59,59],
          '2025041419:00:00','2025041501:00:00','2025103117:59:59','2025103123:59:59' ],
        [ [2025,10,31,18,0,0],[2025,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2026,4,14,18,59,59],[2026,4,14,23,59,59],
          '2025103118:00:00','2025103123:00:00','2026041418:59:59','2026041423:59:59' ],
     ],
   2026 =>
     [
        [ [2026,4,14,19,0,0],[2026,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2026,10,31,17,59,59],[2026,10,31,23,59,59],
          '2026041419:00:00','2026041501:00:00','2026103117:59:59','2026103123:59:59' ],
        [ [2026,10,31,18,0,0],[2026,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2027,4,14,18,59,59],[2027,4,14,23,59,59],
          '2026103118:00:00','2026103123:00:00','2027041418:59:59','2027041423:59:59' ],
     ],
   2027 =>
     [
        [ [2027,4,14,19,0,0],[2027,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2027,10,31,17,59,59],[2027,10,31,23,59,59],
          '2027041419:00:00','2027041501:00:00','2027103117:59:59','2027103123:59:59' ],
        [ [2027,10,31,18,0,0],[2027,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2028,4,14,18,59,59],[2028,4,14,23,59,59],
          '2027103118:00:00','2027103123:00:00','2028041418:59:59','2028041423:59:59' ],
     ],
   2028 =>
     [
        [ [2028,4,14,19,0,0],[2028,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2028,10,31,17,59,59],[2028,10,31,23,59,59],
          '2028041419:00:00','2028041501:00:00','2028103117:59:59','2028103123:59:59' ],
        [ [2028,10,31,18,0,0],[2028,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2029,4,14,18,59,59],[2029,4,14,23,59,59],
          '2028103118:00:00','2028103123:00:00','2029041418:59:59','2029041423:59:59' ],
     ],
   2029 =>
     [
        [ [2029,4,14,19,0,0],[2029,4,15,1,0,0],'+06:00:00',[6,0,0],
          'PKST',1,[2029,10,31,17,59,59],[2029,10,31,23,59,59],
          '2029041419:00:00','2029041501:00:00','2029103117:59:59','2029103123:59:59' ],
        [ [2029,10,31,18,0,0],[2029,10,31,23,0,0],'+05:00:00',[5,0,0],
          'PKT',0,[2030,4,14,18,59,59],[2030,4,14,23,59,59],
          '2029103118:00:00','2029103123:00:00','2030041418:59:59','2030041423:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+06:00:00',
                'stdoff' => '+05:00:00',

               },
   'rules'  => {
                '04' => {
                         'flag'    => 'dom',
                         'dow'     => '0',
                         'num'     => '15',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '1',
                         'abb'     => 'PKST',
                        },
                '11' => {
                         'flag'    => 'dom',
                         'dow'     => '0',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '0',
                         'abb'     => 'PKT',
                        },

               },
);

1;
