package Date::Manip::TZ::asjeru00;
# Copyright (c) 2008-2010 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:25 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::asjeru00 - Support for the Asia/Jerusalem time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.00";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,2,20,56],'+02:20:56',[2,20,56],
          'LMT',0,[1879,12,31,21,39,3],[1879,12,31,23,59,59] ],
     ],
   1879 =>
     [
        [ [1879,12,31,21,39,4],[1879,12,31,23,59,44],'+02:20:40',[2,20,40],
          'JMT',0,[1917,12,31,21,39,19],[1917,12,31,23,59,59] ],
     ],
   1917 =>
     [
        [ [1917,12,31,21,39,20],[1917,12,31,23,39,20],'+02:00:00',[2,0,0],
          'IST',0,[1940,5,31,21,59,59],[1940,5,31,23,59,59] ],
     ],
   1940 =>
     [
        [ [1940,5,31,22,0,0],[1940,6,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1942,10,31,20,59,59],[1942,10,31,23,59,59] ],
     ],
   1942 =>
     [
        [ [1942,10,31,21,0,0],[1942,10,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1943,3,31,23,59,59],[1943,4,1,1,59,59] ],
     ],
   1943 =>
     [
        [ [1943,4,1,0,0,0],[1943,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1943,10,31,20,59,59],[1943,10,31,23,59,59] ],
        [ [1943,10,31,21,0,0],[1943,10,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1944,3,31,21,59,59],[1944,3,31,23,59,59] ],
     ],
   1944 =>
     [
        [ [1944,3,31,22,0,0],[1944,4,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1944,10,31,20,59,59],[1944,10,31,23,59,59] ],
        [ [1944,10,31,21,0,0],[1944,10,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1945,4,15,21,59,59],[1945,4,15,23,59,59] ],
     ],
   1945 =>
     [
        [ [1945,4,15,22,0,0],[1945,4,16,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1945,10,31,22,59,59],[1945,11,1,1,59,59] ],
        [ [1945,10,31,23,0,0],[1945,11,1,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1946,4,15,23,59,59],[1946,4,16,1,59,59] ],
     ],
   1946 =>
     [
        [ [1946,4,16,0,0,0],[1946,4,16,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1946,10,31,20,59,59],[1946,10,31,23,59,59] ],
        [ [1946,10,31,21,0,0],[1946,10,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1948,5,22,21,59,59],[1948,5,22,23,59,59] ],
     ],
   1948 =>
     [
        [ [1948,5,22,22,0,0],[1948,5,23,2,0,0],'+04:00:00',[4,0,0],
          'IDDT',1,[1948,8,31,19,59,59],[1948,8,31,23,59,59] ],
        [ [1948,8,31,20,0,0],[1948,8,31,23,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1948,10,31,22,59,59],[1948,11,1,1,59,59] ],
        [ [1948,10,31,23,0,0],[1948,11,1,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1949,4,30,21,59,59],[1949,4,30,23,59,59] ],
     ],
   1949 =>
     [
        [ [1949,4,30,22,0,0],[1949,5,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1949,10,31,22,59,59],[1949,11,1,1,59,59] ],
        [ [1949,10,31,23,0,0],[1949,11,1,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1950,4,15,21,59,59],[1950,4,15,23,59,59] ],
     ],
   1950 =>
     [
        [ [1950,4,15,22,0,0],[1950,4,16,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1950,9,14,23,59,59],[1950,9,15,2,59,59] ],
        [ [1950,9,15,0,0,0],[1950,9,15,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1951,3,31,21,59,59],[1951,3,31,23,59,59] ],
     ],
   1951 =>
     [
        [ [1951,3,31,22,0,0],[1951,4,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1951,11,10,23,59,59],[1951,11,11,2,59,59] ],
        [ [1951,11,11,0,0,0],[1951,11,11,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1952,4,19,23,59,59],[1952,4,20,1,59,59] ],
     ],
   1952 =>
     [
        [ [1952,4,20,0,0,0],[1952,4,20,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1952,10,18,23,59,59],[1952,10,19,2,59,59] ],
        [ [1952,10,19,0,0,0],[1952,10,19,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1953,4,11,23,59,59],[1953,4,12,1,59,59] ],
     ],
   1953 =>
     [
        [ [1953,4,12,0,0,0],[1953,4,12,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1953,9,12,23,59,59],[1953,9,13,2,59,59] ],
        [ [1953,9,13,0,0,0],[1953,9,13,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1954,6,12,21,59,59],[1954,6,12,23,59,59] ],
     ],
   1954 =>
     [
        [ [1954,6,12,22,0,0],[1954,6,13,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1954,9,11,20,59,59],[1954,9,11,23,59,59] ],
        [ [1954,9,11,21,0,0],[1954,9,11,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1955,6,10,23,59,59],[1955,6,11,1,59,59] ],
     ],
   1955 =>
     [
        [ [1955,6,11,0,0,0],[1955,6,11,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1955,9,10,20,59,59],[1955,9,10,23,59,59] ],
        [ [1955,9,10,21,0,0],[1955,9,10,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1956,6,2,21,59,59],[1956,6,2,23,59,59] ],
     ],
   1956 =>
     [
        [ [1956,6,2,22,0,0],[1956,6,3,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1956,9,29,23,59,59],[1956,9,30,2,59,59] ],
        [ [1956,9,30,0,0,0],[1956,9,30,2,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1957,4,28,23,59,59],[1957,4,29,1,59,59] ],
     ],
   1957 =>
     [
        [ [1957,4,29,0,0,0],[1957,4,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1957,9,21,20,59,59],[1957,9,21,23,59,59] ],
        [ [1957,9,21,21,0,0],[1957,9,21,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1974,7,6,21,59,59],[1974,7,6,23,59,59] ],
     ],
   1974 =>
     [
        [ [1974,7,6,22,0,0],[1974,7,7,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1974,10,12,20,59,59],[1974,10,12,23,59,59] ],
        [ [1974,10,12,21,0,0],[1974,10,12,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1975,4,19,21,59,59],[1975,4,19,23,59,59] ],
     ],
   1975 =>
     [
        [ [1975,4,19,22,0,0],[1975,4,20,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1975,8,30,20,59,59],[1975,8,30,23,59,59] ],
        [ [1975,8,30,21,0,0],[1975,8,30,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1985,4,13,21,59,59],[1985,4,13,23,59,59] ],
     ],
   1985 =>
     [
        [ [1985,4,13,22,0,0],[1985,4,14,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1985,9,14,20,59,59],[1985,9,14,23,59,59] ],
        [ [1985,9,14,21,0,0],[1985,9,14,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1986,5,17,21,59,59],[1986,5,17,23,59,59] ],
     ],
   1986 =>
     [
        [ [1986,5,17,22,0,0],[1986,5,18,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1986,9,6,20,59,59],[1986,9,6,23,59,59] ],
        [ [1986,9,6,21,0,0],[1986,9,6,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1987,4,14,21,59,59],[1987,4,14,23,59,59] ],
     ],
   1987 =>
     [
        [ [1987,4,14,22,0,0],[1987,4,15,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1987,9,12,20,59,59],[1987,9,12,23,59,59] ],
        [ [1987,9,12,21,0,0],[1987,9,12,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1988,4,8,21,59,59],[1988,4,8,23,59,59] ],
     ],
   1988 =>
     [
        [ [1988,4,8,22,0,0],[1988,4,9,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1988,9,2,20,59,59],[1988,9,2,23,59,59] ],
        [ [1988,9,2,21,0,0],[1988,9,2,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1989,4,29,21,59,59],[1989,4,29,23,59,59] ],
     ],
   1989 =>
     [
        [ [1989,4,29,22,0,0],[1989,4,30,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1989,9,2,20,59,59],[1989,9,2,23,59,59] ],
        [ [1989,9,2,21,0,0],[1989,9,2,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1990,3,24,21,59,59],[1990,3,24,23,59,59] ],
     ],
   1990 =>
     [
        [ [1990,3,24,22,0,0],[1990,3,25,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1990,8,25,20,59,59],[1990,8,25,23,59,59] ],
        [ [1990,8,25,21,0,0],[1990,8,25,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1991,3,23,21,59,59],[1991,3,23,23,59,59] ],
     ],
   1991 =>
     [
        [ [1991,3,23,22,0,0],[1991,3,24,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1991,8,31,20,59,59],[1991,8,31,23,59,59] ],
        [ [1991,8,31,21,0,0],[1991,8,31,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1992,3,28,21,59,59],[1992,3,28,23,59,59] ],
     ],
   1992 =>
     [
        [ [1992,3,28,22,0,0],[1992,3,29,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1992,9,5,20,59,59],[1992,9,5,23,59,59] ],
        [ [1992,9,5,21,0,0],[1992,9,5,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1993,4,1,21,59,59],[1993,4,1,23,59,59] ],
     ],
   1993 =>
     [
        [ [1993,4,1,22,0,0],[1993,4,2,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1993,9,4,20,59,59],[1993,9,4,23,59,59] ],
        [ [1993,9,4,21,0,0],[1993,9,4,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1994,3,31,21,59,59],[1994,3,31,23,59,59] ],
     ],
   1994 =>
     [
        [ [1994,3,31,22,0,0],[1994,4,1,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1994,8,27,20,59,59],[1994,8,27,23,59,59] ],
        [ [1994,8,27,21,0,0],[1994,8,27,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1995,3,30,21,59,59],[1995,3,30,23,59,59] ],
     ],
   1995 =>
     [
        [ [1995,3,30,22,0,0],[1995,3,31,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1995,9,2,20,59,59],[1995,9,2,23,59,59] ],
        [ [1995,9,2,21,0,0],[1995,9,2,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1996,3,14,21,59,59],[1996,3,14,23,59,59] ],
     ],
   1996 =>
     [
        [ [1996,3,14,22,0,0],[1996,3,15,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1996,9,15,20,59,59],[1996,9,15,23,59,59] ],
        [ [1996,9,15,21,0,0],[1996,9,15,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1997,3,20,21,59,59],[1997,3,20,23,59,59] ],
     ],
   1997 =>
     [
        [ [1997,3,20,22,0,0],[1997,3,21,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1997,9,13,20,59,59],[1997,9,13,23,59,59] ],
        [ [1997,9,13,21,0,0],[1997,9,13,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1998,3,19,21,59,59],[1998,3,19,23,59,59] ],
     ],
   1998 =>
     [
        [ [1998,3,19,22,0,0],[1998,3,20,1,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1998,9,5,20,59,59],[1998,9,5,23,59,59] ],
        [ [1998,9,5,21,0,0],[1998,9,5,23,0,0],'+02:00:00',[2,0,0],
          'IST',0,[1999,4,1,23,59,59],[1999,4,2,1,59,59] ],
     ],
   1999 =>
     [
        [ [1999,4,2,0,0,0],[1999,4,2,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[1999,9,2,22,59,59],[1999,9,3,1,59,59] ],
        [ [1999,9,2,23,0,0],[1999,9,3,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2000,4,13,23,59,59],[2000,4,14,1,59,59] ],
     ],
   2000 =>
     [
        [ [2000,4,14,0,0,0],[2000,4,14,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2000,10,5,21,59,59],[2000,10,6,0,59,59] ],
        [ [2000,10,5,22,0,0],[2000,10,6,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2001,4,8,22,59,59],[2001,4,9,0,59,59] ],
     ],
   2001 =>
     [
        [ [2001,4,8,23,0,0],[2001,4,9,2,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2001,9,23,21,59,59],[2001,9,24,0,59,59] ],
        [ [2001,9,23,22,0,0],[2001,9,24,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2002,3,28,22,59,59],[2002,3,29,0,59,59] ],
     ],
   2002 =>
     [
        [ [2002,3,28,23,0,0],[2002,3,29,2,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2002,10,6,21,59,59],[2002,10,7,0,59,59] ],
        [ [2002,10,6,22,0,0],[2002,10,7,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2003,3,27,22,59,59],[2003,3,28,0,59,59] ],
     ],
   2003 =>
     [
        [ [2003,3,27,23,0,0],[2003,3,28,2,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2003,10,2,21,59,59],[2003,10,3,0,59,59] ],
        [ [2003,10,2,22,0,0],[2003,10,3,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2004,4,6,22,59,59],[2004,4,7,0,59,59] ],
     ],
   2004 =>
     [
        [ [2004,4,6,23,0,0],[2004,4,7,2,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2004,9,21,21,59,59],[2004,9,22,0,59,59] ],
        [ [2004,9,21,22,0,0],[2004,9,22,0,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2005,3,31,23,59,59],[2005,4,1,1,59,59] ],
     ],
   2005 =>
     [
        [ [2005,4,1,0,0,0],[2005,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2005,10,8,22,59,59],[2005,10,9,1,59,59] ],
        [ [2005,10,8,23,0,0],[2005,10,9,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2006,3,30,23,59,59],[2006,3,31,1,59,59] ],
     ],
   2006 =>
     [
        [ [2006,3,31,0,0,0],[2006,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2006,9,30,22,59,59],[2006,10,1,1,59,59] ],
        [ [2006,9,30,23,0,0],[2006,10,1,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2007,3,29,23,59,59],[2007,3,30,1,59,59] ],
     ],
   2007 =>
     [
        [ [2007,3,30,0,0,0],[2007,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2007,9,15,22,59,59],[2007,9,16,1,59,59] ],
        [ [2007,9,15,23,0,0],[2007,9,16,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2008,3,27,23,59,59],[2008,3,28,1,59,59] ],
     ],
   2008 =>
     [
        [ [2008,3,28,0,0,0],[2008,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2008,10,4,22,59,59],[2008,10,5,1,59,59] ],
        [ [2008,10,4,23,0,0],[2008,10,5,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2009,3,26,23,59,59],[2009,3,27,1,59,59] ],
     ],
   2009 =>
     [
        [ [2009,3,27,0,0,0],[2009,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2009,9,26,22,59,59],[2009,9,27,1,59,59] ],
        [ [2009,9,26,23,0,0],[2009,9,27,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2010,3,25,23,59,59],[2010,3,26,1,59,59] ],
     ],
   2010 =>
     [
        [ [2010,3,26,0,0,0],[2010,3,26,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2010,9,11,22,59,59],[2010,9,12,1,59,59] ],
        [ [2010,9,11,23,0,0],[2010,9,12,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2011,3,31,23,59,59],[2011,4,1,1,59,59] ],
     ],
   2011 =>
     [
        [ [2011,4,1,0,0,0],[2011,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2011,10,1,22,59,59],[2011,10,2,1,59,59] ],
        [ [2011,10,1,23,0,0],[2011,10,2,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2012,3,29,23,59,59],[2012,3,30,1,59,59] ],
     ],
   2012 =>
     [
        [ [2012,3,30,0,0,0],[2012,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2012,9,22,22,59,59],[2012,9,23,1,59,59] ],
        [ [2012,9,22,23,0,0],[2012,9,23,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2013,3,28,23,59,59],[2013,3,29,1,59,59] ],
     ],
   2013 =>
     [
        [ [2013,3,29,0,0,0],[2013,3,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2013,9,7,22,59,59],[2013,9,8,1,59,59] ],
        [ [2013,9,7,23,0,0],[2013,9,8,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2014,3,27,23,59,59],[2014,3,28,1,59,59] ],
     ],
   2014 =>
     [
        [ [2014,3,28,0,0,0],[2014,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2014,9,27,22,59,59],[2014,9,28,1,59,59] ],
        [ [2014,9,27,23,0,0],[2014,9,28,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2015,3,26,23,59,59],[2015,3,27,1,59,59] ],
     ],
   2015 =>
     [
        [ [2015,3,27,0,0,0],[2015,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2015,9,19,22,59,59],[2015,9,20,1,59,59] ],
        [ [2015,9,19,23,0,0],[2015,9,20,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2016,3,31,23,59,59],[2016,4,1,1,59,59] ],
     ],
   2016 =>
     [
        [ [2016,4,1,0,0,0],[2016,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2016,10,8,22,59,59],[2016,10,9,1,59,59] ],
        [ [2016,10,8,23,0,0],[2016,10,9,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2017,3,30,23,59,59],[2017,3,31,1,59,59] ],
     ],
   2017 =>
     [
        [ [2017,3,31,0,0,0],[2017,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2017,9,23,22,59,59],[2017,9,24,1,59,59] ],
        [ [2017,9,23,23,0,0],[2017,9,24,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2018,3,29,23,59,59],[2018,3,30,1,59,59] ],
     ],
   2018 =>
     [
        [ [2018,3,30,0,0,0],[2018,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2018,9,15,22,59,59],[2018,9,16,1,59,59] ],
        [ [2018,9,15,23,0,0],[2018,9,16,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2019,3,28,23,59,59],[2019,3,29,1,59,59] ],
     ],
   2019 =>
     [
        [ [2019,3,29,0,0,0],[2019,3,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2019,10,5,22,59,59],[2019,10,6,1,59,59] ],
        [ [2019,10,5,23,0,0],[2019,10,6,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2020,3,26,23,59,59],[2020,3,27,1,59,59] ],
     ],
   2020 =>
     [
        [ [2020,3,27,0,0,0],[2020,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2020,9,26,22,59,59],[2020,9,27,1,59,59] ],
        [ [2020,9,26,23,0,0],[2020,9,27,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2021,3,25,23,59,59],[2021,3,26,1,59,59] ],
     ],
   2021 =>
     [
        [ [2021,3,26,0,0,0],[2021,3,26,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2021,9,11,22,59,59],[2021,9,12,1,59,59] ],
        [ [2021,9,11,23,0,0],[2021,9,12,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2022,3,31,23,59,59],[2022,4,1,1,59,59] ],
     ],
   2022 =>
     [
        [ [2022,4,1,0,0,0],[2022,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2022,10,1,22,59,59],[2022,10,2,1,59,59] ],
        [ [2022,10,1,23,0,0],[2022,10,2,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2023,3,30,23,59,59],[2023,3,31,1,59,59] ],
     ],
   2023 =>
     [
        [ [2023,3,31,0,0,0],[2023,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2023,9,23,22,59,59],[2023,9,24,1,59,59] ],
        [ [2023,9,23,23,0,0],[2023,9,24,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2024,3,28,23,59,59],[2024,3,29,1,59,59] ],
     ],
   2024 =>
     [
        [ [2024,3,29,0,0,0],[2024,3,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2024,10,5,22,59,59],[2024,10,6,1,59,59] ],
        [ [2024,10,5,23,0,0],[2024,10,6,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2025,3,27,23,59,59],[2025,3,28,1,59,59] ],
     ],
   2025 =>
     [
        [ [2025,3,28,0,0,0],[2025,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2025,9,27,22,59,59],[2025,9,28,1,59,59] ],
        [ [2025,9,27,23,0,0],[2025,9,28,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2026,3,26,23,59,59],[2026,3,27,1,59,59] ],
     ],
   2026 =>
     [
        [ [2026,3,27,0,0,0],[2026,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2026,9,19,22,59,59],[2026,9,20,1,59,59] ],
        [ [2026,9,19,23,0,0],[2026,9,20,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2027,3,25,23,59,59],[2027,3,26,1,59,59] ],
     ],
   2027 =>
     [
        [ [2027,3,26,0,0,0],[2027,3,26,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2027,10,9,22,59,59],[2027,10,10,1,59,59] ],
        [ [2027,10,9,23,0,0],[2027,10,10,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2028,3,30,23,59,59],[2028,3,31,1,59,59] ],
     ],
   2028 =>
     [
        [ [2028,3,31,0,0,0],[2028,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2028,9,23,22,59,59],[2028,9,24,1,59,59] ],
        [ [2028,9,23,23,0,0],[2028,9,24,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2029,3,29,23,59,59],[2029,3,30,1,59,59] ],
     ],
   2029 =>
     [
        [ [2029,3,30,0,0,0],[2029,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2029,9,15,22,59,59],[2029,9,16,1,59,59] ],
        [ [2029,9,15,23,0,0],[2029,9,16,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2030,3,28,23,59,59],[2030,3,29,1,59,59] ],
     ],
   2030 =>
     [
        [ [2030,3,29,0,0,0],[2030,3,29,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2030,10,5,22,59,59],[2030,10,6,1,59,59] ],
        [ [2030,10,5,23,0,0],[2030,10,6,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2031,3,27,23,59,59],[2031,3,28,1,59,59] ],
     ],
   2031 =>
     [
        [ [2031,3,28,0,0,0],[2031,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2031,9,20,22,59,59],[2031,9,21,1,59,59] ],
        [ [2031,9,20,23,0,0],[2031,9,21,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2032,3,25,23,59,59],[2032,3,26,1,59,59] ],
     ],
   2032 =>
     [
        [ [2032,3,26,0,0,0],[2032,3,26,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2032,9,11,22,59,59],[2032,9,12,1,59,59] ],
        [ [2032,9,11,23,0,0],[2032,9,12,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2033,3,31,23,59,59],[2033,4,1,1,59,59] ],
     ],
   2033 =>
     [
        [ [2033,4,1,0,0,0],[2033,4,1,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2033,10,1,22,59,59],[2033,10,2,1,59,59] ],
        [ [2033,10,1,23,0,0],[2033,10,2,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2034,3,30,23,59,59],[2034,3,31,1,59,59] ],
     ],
   2034 =>
     [
        [ [2034,3,31,0,0,0],[2034,3,31,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2034,9,16,22,59,59],[2034,9,17,1,59,59] ],
        [ [2034,9,16,23,0,0],[2034,9,17,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2035,3,29,23,59,59],[2035,3,30,1,59,59] ],
     ],
   2035 =>
     [
        [ [2035,3,30,0,0,0],[2035,3,30,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2035,10,6,22,59,59],[2035,10,7,1,59,59] ],
        [ [2035,10,6,23,0,0],[2035,10,7,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2036,3,27,23,59,59],[2036,3,28,1,59,59] ],
     ],
   2036 =>
     [
        [ [2036,3,28,0,0,0],[2036,3,28,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2036,9,27,22,59,59],[2036,9,28,1,59,59] ],
        [ [2036,9,27,23,0,0],[2036,9,28,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[2037,3,26,23,59,59],[2037,3,27,1,59,59] ],
     ],
   2037 =>
     [
        [ [2037,3,27,0,0,0],[2037,3,27,3,0,0],'+03:00:00',[3,0,0],
          'IDT',1,[2037,9,12,22,59,59],[2037,9,13,1,59,59] ],
        [ [2037,9,12,23,0,0],[2037,9,13,1,0,0],'+02:00:00',[2,0,0],
          'IST',0,[9999,12,31,0,0,0],[9999,12,31,2,0,0] ],
     ],
);

%LastRule      = (
   'zone'   => {

               },
   'rules'  => {

               },
);

1;
