#########
# Author:        rmp
# Last Modified: $Date: 2009/01/12 10:29:26 $ $Author: rmp $
# Id:            $Id: Makefile.PL,v 1.47 2009/01/12 10:29:26 rmp Exp $
# Source:        $Source: /cvsroot/Bio-DasLite/Bio-DasLite/Makefile.PL,v $
# $HeadURL$
#
package Makefile;
use strict;
use warnings;
use 5.005;
use ExtUtils::MakeMaker;
use English qw(-no_match_vars);

our $VERSION = do { my @r = (q$Revision: 1.47 $ =~ /\d+/mxg); sprintf '%d.'.'%03d' x $#r, @r };

WriteMakefile(
	      'NAME'          => 'Bio::Das::Lite',
	      'AUTHOR'        => q(Roger Pettett <rpettett@cpan.org>),
	      'ABSTRACT_FROM' => 'lib/Bio/Das/Lite.pm',
	      'VERSION_FROM'  => 'lib/Bio/Das/Lite.pm',
	      'DISTNAME'      => 'Bio-Das-Lite',
	      'PREREQ_PM'     => {
				  'WWW::Curl::Simple' => '0.100181',
				  'HTTP::Request'     => '1.4',
				  'HTTP::Headers'     => '1.64',
				  'SOAP::Lite'        => '0.69',
				  'English'           => '1.01',
				  'Carp'              => '1.02',
				  'Readonly'          => '1.03',
				 },
	      'dist'          => {
				  COMPRESS => 'gzip',
				  SUFFIX   => 'gz',
				 },
	      'LICENSE'       => 'perl',
	     );

print q(
******************************************************************************
** Some of the tests for this module need internet access                   **
** Also remember to set your http_proxy environment variable if you need to **
******************************************************************************
);

1;
