BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Data::Dumper base strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  if($^O eq 'midnightbsd')
  {
    print "Sorry, MidnightBSD is not supported.\n";
    print "See:\n";
    print "https://github.com/PerlAlien/Alien-Base-Extras/issues/4\n";
    print "pull requests to fix this are welcome.\n";
    print "OS Unsupported\n";
    exit;
  }
  unless(eval q{ use 5.006; 1}) {
    print "Perl 5.006 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.70.
use strict;
use warnings;
use 5.006;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"       => "Test Module for Alien::Base::ModuleBuild",
  "AUTHOR"         => "Graham Ollis <plicease\@cpan.org>, Joel A Berger <joel.a.berger\@gmail.com>",
  "BUILD_REQUIRES" => {
    "Alien::Build"        => "0.40",
    "Alien::Build::MM"    => "0.40",
    "ExtUtils::MakeMaker" => "6.52"
  },
  "CONFIGURE_REQUIRES" => {
    "Alien::Build"                            => "2.59",
    "Alien::Build::MM"                        => "0.40",
    "Alien::Build::Plugin::Digest::Negotiate" => 0,
    "ExtUtils::MakeMaker"                     => "6.52"
  },
  "DISTNAME"         => "Acme-Alien-DontPanic",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME"             => "Acme::Alien::DontPanic",
  "PM"               => {
    "lib/Acme/Alien/DontPanic.pm" => "\$(INST_LIB)/Acme/Alien/DontPanic.pm"
  },
  "PREREQ_PM" => {
    "Alien::Base" => "2.59"
  },
  "TEST_REQUIRES" => {
    "File::Temp"        => 0,
    "Inline"            => "0.56",
    "Inline::C"         => 0,
    "Inline::CPP"       => 0,
    "Path::Tiny"        => 0,
    "Test2::V0"         => "0.000121",
    "Test::Alien"       => "0.05",
    "Test::Alien::Diag" => 0
  },
  "VERSION" => "2.5900",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Alien::Base"         => "2.59",
  "Alien::Build"        => "0.40",
  "Alien::Build::MM"    => "0.40",
  "ExtUtils::MakeMaker" => "6.52",
  "File::Temp"          => 0,
  "Inline"              => "0.56",
  "Inline::C"           => 0,
  "Inline::CPP"         => 0,
  "Path::Tiny"          => 0,
  "Test2::V0"           => "0.000121",
  "Test::Alien"         => "0.05",
  "Test::Alien::Diag"   => 0
);

# BEGIN code inserted by Dist::Zilla::Plugin::AlienBuild
use Alien::Build::MM;
my $abmm = Alien::Build::MM->new;
%WriteMakefileArgs = $abmm->mm_args(%WriteMakefileArgs);

# END code inserted by Dist::Zilla::Plugin::AlienBuild

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::AlienBuild
{ package
    MY;

  sub postamble {
    $abmm->mm_postamble(@_);
  }

  sub install {
    $abmm->can('mm_install')
      ? $abmm->mm_install(@_)
      : shift->SUPER::install(@_);
  }
}

# END code inserted by Dist::Zilla::Plugin::AlienBuild