Check the [functional-perl website](http://functional-perl.org/) for
properly formatted versions of these documents.

---

See also [[ideas]], [[htmlgen/TODO]], [[functional_XML/TODO]] and the
"todo" markers in text (website / .md) files. Also, the [[names]] page.

<with_toc>

## Get rid of unnecessary home-grown code

These may better be replaced by more widely used code, roughly in the
order of most likely replacement (those replaced most easily or
usefully listed first).

- `Chj::xperlfunc`: maybe `use autodie`, although I'm somewhat wary of
  the fact that this way it's not directly visible anymore whether a
  call dies or not. Also, there are various utilities like xspawn,
  xxsystem etc. that need replacing, too.

- Chj::xopen*, Chj::xtmpfile, Chj::xpipe, Chj::IO::*

- should `Chj::TEST` stay or be made a lexical extension of other test
  modules?

- migrate `FP::Struct` functionality as Moose extensions or something?

- merge Chj::Repl with other repls/debuggers? Also,
  Chj::{Trapl,WithRepl,Backtrace}. They are still fertile grounds for
  experimentation, though, thus shouldn't merge things too soon.

- maybe `FP::Path` is not general or useful enough to keep

## Licensing

- should I move the licensing statements from the top of the files
  into the POD section of each file?

- should I specify a license for the text? A different one than the
  ones for the code? Who should be the copyright holder of the
  website, "the project"?


## Documentation and tests

- document the change in recent (blead) perl with regards to lexical
  capture and weak references (e.g. see `FP::DBI` commit 8862338..) in
  the howto

- more `intro/`, more `examples/`

- more tests:

  - more systematic stream leak testing.
    Idea: LEAK_TEST forms in `Chj::TEST` (see comment in `FP::Stream`)

  - tests for `Chj::TEST` itself

  - systematic testing of mixed FP::List / FP::PureArray
    etc. sequences. (etc.)


## Other people's code

- replace `FP::Lazy` with `Data::Thunk`? This would be cool from a
  transparency stand point, except that separate code by way of
  dynamic dispatch (method calls) *can't* be used anymore then, and
  thus the only code always needs to do the environment cleaning,
  which is bad from a usability perspective since users not working
  with lazy data will still have their variables (unexpectedly)
  deleted. Also, when a `Data::Thunk` thunk (promise) fails, it won't be
  run again and is instead silently casted to e.g. an integer in
  number context, which will be a usability neightmare.

  Also, what about `Params::Lazy`?

- `Sub::Call::Tail` depends on `B::Hooks::OP::Check::EntersubForCV`
  which doesn't work on current bleadperl. Get this fixed.

  Reimplement it on top of `Devel::CallChecker` or
  `Devel::CallParser`?

  (Would it be obsolete if automatic TCO is implemented?)

- replace Chj::IO::* with something else?

- work on getting perl issues fixed, see failing tests `t/perl-*`

- disable stringification and numerification lexically using "no
  stringification"? But it currently doesn't work with bleadperl
  anymore. -> Just suggest in docs?

- change `FP::Array` to use `autobox`? (But that's lexically scoped, how
  will that 'scale'? Or, what about blessing and then providing an
  overload for dumping? Not exist, right. What about writing an
  alternative Dump?)

- extend Data::Dumper (or alternative dumper(s)) to show a simpler
  syntax for linked lists, and streams (and perhaps more) (mostly for
  the repl, but also in general):

        FP::list(1,2,3)  # instead of bless [1, bless [2, bless ...],...

  (Show only evaluated part of streams (and the rest as a promise), or
  force evaluation of the first n items then cut off the same way as
  for lists?)


## Code structure

- fix the now horrible hand-optimized-but-convoluted code in
  `PXML::Serialize` (and figure out an automatic way to make it fast).

- finish PXML's HTML5 support.

- improve sequences class hierarchy

    - look at Ord (Ordering) in Haskell etc.

    - avoid the duplication between `FP::List` and `FP::Stream` as much as
      possible.

        - those not using lazy internally: implement the List variants using
          Keep and the stream variants.

- what to do about data types that have both a class and some
  functions, like `is_sequence`, that now lives in `FP::Predicates`,
  and might be moved elsewhere in the future, breaking code importing
  it...?

- messages like "expecting 2 arguments" are unclear and inconsistently
  used for functions reused as methods. How should it be? `flip`
  should work, for example, so do we have to live with methods
  including $self in their argument count? (For this reason, much of
  the code is now simply throwing the message "wrong number of
  arguments" without any indication of the expected
  count. `Function::Parameters` issues "Too many arguments" and "Not
  enough arguments", `Method::Signatures` says "missing required
  argument $a" or "was given too many arguments", both of which are
  good.)

- should `rest` (`cdr`) weaken its argument in the case of streams? 
  (`first` clearly shouldn't, right?)

- add `FP::List`'s `none` and the `all` alias (also, remove `every`
  *or* `all`?) to `FP::Stream`, or to common base class.


## Security, safety

- check 'XX.*[Ss]ecurity' comments


## Possibilities

- port `PXML::Element` to `FP::Struct` (it was originally written
  before that existed, iirc). Create a version/extension of
  `FP::Struct` that uses arrays instead of hashes,
  or is that irrelevant and stupid? (benchmark cpu and memory)

</with_toc>
