package Bencher::Scenario::LogGer::OutputStartup;

our $DATE = '2021-01-31'; # DATE
our $VERSION = '0.017'; # VERSION

use 5.010001;
use strict;
use warnings;

use Data::Dmp;
use File::Temp qw(tempdir tempfile);

my $str;
my $ary = [];
my ($fh, $fname) = tempfile();
my $dname = tempdir(CLEANUP => 1);

our %output_modules = (
    Null => {},
    String => { string => \$str },
    Array => { array => $ary },

    ArrayRotate => { array => $ary },
    File => { path => $fname },
    Screen => {},
    Callback => {},
    FileWriteRotate => { dir => $dname, prefix => 'prefix' },
    DirWriteRotate => { path => $dname },
    LogAny => {},
    #LogDispatchOutput => { output => 'ArrayWithLimits', args => {array => $ary} }, # Log::Dispatch::ArrayWithLimits already removed from CPAN
    Composite => { outputs => {Screen => {conf=>{}}, File => {conf=>{path=>$fname}}} },
    Syslog => { ident => 'test' },
);

our $scenario = {
    modules => {
        'Log::ger::Output::Composite' => {version=>'0.009'},
        'Log::ger::Output::File' => {version=>'0.002'},
        'Log::ger::Output::LogAny' => {version=>'0.003'},
        'Log::ger::Output::Screen' => {version=>'0.015'},
    },
    participants => [
        {name=>"baseline", perl_cmdline => ["-e1"]},

        map {
            (
                +{
                    name => "load-$_",
                    module => "Log::ger::Output::$_",
                    perl_cmdline => ["-mLog::ger::Output::$_", "-e1"],
                },
                +{
                    name => "init-with-$_",
                    module => "Log::ger::Output::$_",
                    #perl_cmdline => ["-e", "use Log::ger::Output '$_'; use Log::ger"],
                    perl_cmdline => ["-e", "use Log::ger::Output '$_' => %{ +".dmp($output_modules{$_})." }; use Log::ger"],
                },
            )
        } sort keys %output_modules,
    ],
};

1;
# ABSTRACT:

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LogGer::OutputStartup

=head1 VERSION

This document describes version 0.017 of Bencher::Scenario::LogGer::OutputStartup (from Perl distribution Bencher-Scenarios-LogGer), released on 2021-01-31.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LogGer::OutputStartup

To run module startup overhead benchmark:

 % bencher --module-startup -m LogGer::OutputStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Log::ger::Output::Array> 0.038

L<Log::ger::Output::ArrayRotate> 0.004

L<Log::ger::Output::Callback> 0.009

L<Log::ger::Output::Composite> 0.016

L<Log::ger::Output::DirWriteRotate> 0.004

L<Log::ger::Output::File> 0.012

L<Log::ger::Output::FileWriteRotate> 0.005

L<Log::ger::Output::LogAny> 0.009

L<Log::ger::Output::Null> 0.038

L<Log::ger::Output::Screen> 0.015

L<Log::ger::Output::String> 0.038

L<Log::ger::Output::Syslog> 0.005

=head1 BENCHMARK PARTICIPANTS

=over

=item * baseline (command)



=item * load-Array (command)

L<Log::ger::Output::Array>



=item * init-with-Array (command)

L<Log::ger::Output::Array>



=item * load-ArrayRotate (command)

L<Log::ger::Output::ArrayRotate>



=item * init-with-ArrayRotate (command)

L<Log::ger::Output::ArrayRotate>



=item * load-Callback (command)

L<Log::ger::Output::Callback>



=item * init-with-Callback (command)

L<Log::ger::Output::Callback>



=item * load-Composite (command)

L<Log::ger::Output::Composite>



=item * init-with-Composite (command)

L<Log::ger::Output::Composite>



=item * load-DirWriteRotate (command)

L<Log::ger::Output::DirWriteRotate>



=item * init-with-DirWriteRotate (command)

L<Log::ger::Output::DirWriteRotate>



=item * load-File (command)

L<Log::ger::Output::File>



=item * init-with-File (command)

L<Log::ger::Output::File>



=item * load-FileWriteRotate (command)

L<Log::ger::Output::FileWriteRotate>



=item * init-with-FileWriteRotate (command)

L<Log::ger::Output::FileWriteRotate>



=item * load-LogAny (command)

L<Log::ger::Output::LogAny>



=item * init-with-LogAny (command)

L<Log::ger::Output::LogAny>



=item * load-Null (command)

L<Log::ger::Output::Null>



=item * init-with-Null (command)

L<Log::ger::Output::Null>



=item * load-Screen (command)

L<Log::ger::Output::Screen>



=item * init-with-Screen (command)

L<Log::ger::Output::Screen>



=item * load-String (command)

L<Log::ger::Output::String>



=item * init-with-String (command)

L<Log::ger::Output::String>



=item * load-Syslog (command)

L<Log::ger::Output::Syslog>



=item * init-with-Syslog (command)

L<Log::ger::Output::Syslog>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.30.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux LinuxMint version 19 >>, OS kernel: I<< Linux version 5.3.0-68-generic >>.

Benchmark with default options (C<< bencher -m LogGer::OutputStartup >>):

 #table1#
 +---------------------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+
 | participant               | rate (/s) | time (ms) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +---------------------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+
 | init-with-FileWriteRotate |        29 |      34   |                 0.00% |               574.52% | 6.4e-05   |      20 |
 | init-with-Syslog          |        40 |      25   |                37.83% |               389.37% |   0.00015 |      21 |
 | init-with-Composite       |        45 |      22   |                53.57% |               339.22% |   0.00019 |      20 |
 | init-with-File            |        55 |      18   |                86.51% |               261.65% | 8.3e-05   |      20 |
 | init-with-LogAny          |        66 |      15   |               123.64% |               201.62% |   0.00015 |      20 |
 | load-File                 |        71 |      14   |               141.15% |               179.71% | 4.7e-05   |      20 |
 | init-with-DirWriteRotate  |        82 |      12   |               178.29% |               142.38% | 5.2e-05   |      20 |
 | init-with-String          |        90 |      10   |               191.78% |               131.18% |   0.00026 |      20 |
 | init-with-Array           |        90 |      10   |               199.05% |               125.55% |   0.00019 |      21 |
 | init-with-Callback        |        90 |      10   |               208.14% |               118.90% |   0.0002  |      20 |
 | load-Composite            |        90 |      10   |               208.93% |               118.34% |   0.00032 |      20 |
 | init-with-Screen          |        90 |      10   |               210.69% |               117.10% |   0.00012 |      20 |
 | init-with-Null            |        90 |      10   |               217.38% |               112.53% |   0.00021 |      20 |
 | load-Syslog               |       100 |       9.6 |               254.42% |                90.32% | 9.4e-05   |      20 |
 | load-Screen               |       100 |      10   |               258.19% |                88.32% |   0.00012 |      20 |
 | init-with-ArrayRotate     |       110 |       9.3 |               266.57% |                84.01% | 2.1e-05   |      23 |
 | load-String               |       100 |       8   |               344.26% |                51.83% |   0.00015 |      20 |
 | load-LogAny               |       100 |       8   |               347.04% |                50.89% |   8e-05   |      20 |
 | load-ArrayRotate          |       100 |       8   |               353.83% |                48.63% | 9.4e-05   |      20 |
 | load-Array                |       100 |       7   |               356.37% |                47.80% | 9.2e-05   |      20 |
 | load-DirWriteRotate       |       100 |       7   |               364.97% |                45.07% |   0.0002  |      20 |
 | load-FileWriteRotate      |       100 |       7   |               369.74% |                43.59% |   0.00012 |      21 |
 | load-Null                 |       200 |       6   |               446.19% |                23.50% | 7.8e-05   |      20 |
 | load-Callback             |       170 |       5.8 |               486.76% |                14.96% | 5.7e-05   |      20 |
 | baseline                  |       200 |       5   |               574.52% |                 0.00% |   0.00019 |      20 |
 +---------------------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+


Benchmark module startup overhead (C<< bencher -m LogGer::OutputStartup --module-startup >>):

 #table2#
 +-----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | participant                       | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +-----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | Log::ger::Output::File            |      10   |               5.9 |                 0.00% |               253.84% |   0.00024 |      20 |
 | Log::ger::Output::Composite       |      10   |               5.9 |                39.51% |               153.63% |   0.00021 |      20 |
 | Log::ger::Output::Screen          |       9.1 |               5   |                58.60% |               123.10% | 4.3e-05   |      20 |
 | Log::ger::Output::Syslog          |       8.9 |               4.8 |                62.56% |               117.67% | 2.1e-05   |      20 |
 | Log::ger::Output::Callback        |       7.8 |               3.7 |                86.51% |                89.71% | 6.7e-05   |      20 |
 | Log::ger::Output::ArrayRotate     |       7.6 |               3.5 |                89.42% |                86.80% | 7.1e-05   |      20 |
 | Log::ger::Output::DirWriteRotate  |       8   |               3.9 |                90.59% |                85.65% |   0.00016 |      20 |
 | Log::ger::Output::LogAny          |       7   |               2.9 |                93.05% |                83.29% |   0.00015 |      20 |
 | Log::ger::Output::FileWriteRotate |       7   |               2.9 |               100.38% |                76.58% | 8.6e-05   |      21 |
 | Log::ger::Output::String          |       6.4 |               2.3 |               125.43% |                56.96% | 3.5e-05   |      20 |
 | Log::ger::Output::Null            |       6   |               1.9 |               128.71% |                54.71% | 7.5e-05   |      20 |
 | Log::ger::Output::Array           |       6.2 |               2.1 |               134.85% |                50.67% | 2.8e-05   |      23 |
 | perl -e1 (baseline)               |       4.1 |               0   |               253.84% |                 0.00% | 3.6e-05   |      20 |
 +-----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-LogGer>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-LogGer>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-LogGer>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020, 2018, 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
