package Bencher::Scenario::DamerauLevenshteinModules;

our $DATE = '2016-10-14'; # DATE
our $VERSION = '0.11'; # VERSION

use 5.010001;
use strict;
use utf8;
use warnings;

our $scenario = {
    summary => 'Benchmark various modules calculating the Damerau-Levenshtein edit distance',
    modules => {
    },
    participants => [
        {
            fcall_template => "Text::Levenshtein::Damerau::PP::pp_edistance(<word1>, <word2>)",
        },
        {
            fcall_template => "Text::Levenshtein::Damerau::XS::xs_edistance(<word1>, <word2>)",
        },
    ],
    datasets => [
        { name=>"a",       args => {word1=>"a"      , word2=>"aa"},      result => 1 },
        { name=>"foo",     args => {word1=>"foo"    , word2=>"bar"},     result => 3 },
        { name=>"program", args => {word1=>"program", word2=>"porgram"}, result => 1 },
        { name=>"reve"   , args => {word1=>"reve"   , word2=>"rêves"},   result => 2, tags=>['unicode'], exclude_participant_tags=>['no_unicode_support'] },
        { name=>"euro"   , args => {word1=>"Euro"   , word2=>"€uro"},    result => 1, tags=>['unicode'], exclude_participant_tags=>['no_unicode_support'] },
    ],
    on_result_failure => 'warn',
};

1;
# ABSTRACT: Benchmark various modules calculating the Damerau-Levenshtein edit distance

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DamerauLevenshteinModules - Benchmark various modules calculating the Damerau-Levenshtein edit distance

=head1 VERSION

This document describes version 0.11 of Bencher::Scenario::DamerauLevenshteinModules (from Perl distribution Bencher-Scenarios-LevenshteinModules), released on 2016-10-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DamerauLevenshteinModules

To run module startup overhead benchmark:

 % bencher --module-startup -m DamerauLevenshteinModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Text::Levenshtein::Damerau::PP> 0.25

L<Text::Levenshtein::Damerau::XS> 3.1

=head1 BENCHMARK PARTICIPANTS

=over

=item * Text::Levenshtein::Damerau::PP::pp_edistance (perl_code)

Function call template:

 Text::Levenshtein::Damerau::PP::pp_edistance(<word1>, <word2>)



=item * Text::Levenshtein::Damerau::XS::xs_edistance (perl_code)

Function call template:

 Text::Levenshtein::Damerau::XS::xs_edistance(<word1>, <word2>)



=back

=head1 BENCHMARK DATASETS

=over

=item * a

=item * foo

=item * program

=item * reve [unicode]

=item * euro [unicode]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DamerauLevenshteinModules >>):

 #table1#
 +----------------------------------------------+---------+-----------+-----------+------------+---------+---------+
 | participant                                  | dataset | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +----------------------------------------------+---------+-----------+-----------+------------+---------+---------+
 | Text::Levenshtein::Damerau::PP::pp_edistance | program |     15000 |    68     |     1      | 3.4e-07 |      21 |
 | Text::Levenshtein::Damerau::PP::pp_edistance | euro    |     32000 |    32     |     2.2    | 5.2e-08 |      21 |
 | Text::Levenshtein::Damerau::PP::pp_edistance | reve    |     32333 |    30.928 |     2.2118 | 1.4e-10 |      28 |
 | Text::Levenshtein::Damerau::PP::pp_edistance | foo     |     59000 |    17     |     4      |   6e-08 |      20 |
 | Text::Levenshtein::Damerau::PP::pp_edistance | a       |    164000 |     6.09  |    11.2    | 1.7e-09 |      20 |
 | Text::Levenshtein::Damerau::XS::xs_edistance | program |    430000 |     2.3   |    29      | 3.3e-09 |      20 |
 | Text::Levenshtein::Damerau::XS::xs_edistance | reve    |    555000 |     1.8   |    38      | 8.4e-10 |      20 |
 | Text::Levenshtein::Damerau::XS::xs_edistance | euro    |    600000 |     1.7   |    41      | 4.2e-09 |      20 |
 | Text::Levenshtein::Damerau::XS::xs_edistance | foo     |    690000 |     1.4   |    48      | 1.7e-09 |      20 |
 | Text::Levenshtein::Damerau::XS::xs_edistance | a       |    920000 |     1.1   |    63      | 1.7e-09 |      20 |
 +----------------------------------------------+---------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DamerauLevenshteinModules --module-startup >>):

 #table2#
 +--------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                    | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +--------------------------------+-----------+------------------------+------------+---------+---------+
 | Text::Levenshtein::Damerau::PP |       9.3 |                    4.5 |        1   | 3.1e-05 |      20 |
 | Text::Levenshtein::Damerau::XS |       6.9 |                    2.1 |        1.3 | 3.1e-05 |      20 |
 | perl -e1 (baseline)            |       4.8 |                    0   |        1.9 | 3.7e-05 |      20 |
 +--------------------------------+-----------+------------------------+------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-LevenshteinModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-LevenshteinModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-LevenshteinModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Bencher::Scenario::LevenshteinModules>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
