package Bencher::Scenario::DataCleansing::Startup;

our $DATE = '2016-04-24'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup of various data cleansing modules',
    module_startup => 1,
    modules => {
    },
    participants => [
        {module=>'Data::Clean'},
        {module=>'Data::Clean::JSON'},

        {module=>'JSON::MaybeXS'},
        {module=>'JSON::PP'},
        {module=>'JSON::XS'},
        {module=>'Cpanel::JSON::XS'},

        {module=>'Data::Rmap'},
        {module=>'Data::Abridge'},
        {module=>'Data::Visitor::Callback'},
    ],
};

1;
# ABSTRACT: Benchmark startup of various data cleansing modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataCleansing::Startup - Benchmark startup of various data cleansing modules

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::DataCleansing::Startup (from Perl distribution Bencher-Scenarios-DataCleansing), released on 2016-04-24.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataCleansing::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Cpanel::JSON::XS> 3.0115

L<Data::Abridge> 0.03.01

L<Data::Clean> 0.33

L<Data::Clean::JSON> 0.33

L<Data::Rmap> 0.64

L<Data::Visitor::Callback> 0.30

L<JSON::MaybeXS> 1.003005

L<JSON::PP> 2.27300

L<JSON::XS> 3.01

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::Clean (perl_code)

L<Data::Clean>



=item * Data::Clean::JSON (perl_code)

L<Data::Clean::JSON>



=item * JSON::MaybeXS (perl_code)

L<JSON::MaybeXS>



=item * JSON::PP (perl_code)

L<JSON::PP>



=item * JSON::XS (perl_code)

L<JSON::XS>



=item * Cpanel::JSON::XS (perl_code)

L<Cpanel::JSON::XS>



=item * Data::Rmap (perl_code)

L<Data::Rmap>



=item * Data::Abridge (perl_code)

L<Data::Abridge>



=item * Data::Visitor::Callback (perl_code)

L<Data::Visitor::Callback>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataCleansing::Startup >>):

 +-------------------------+-----------+------------------------+------------+---------+---------+
 | participant             | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +-------------------------+-----------+------------------------+------------+---------+---------+
 | Data::Visitor::Callback | 1.2e+02   | 117.6                  | 1          | 0.00032 | 20      |
 | JSON::PP                | 15        | 12.6                   | 8          | 3.4e-05 | 20      |
 | JSON::MaybeXS           | 10        | 7.6                    | 12         | 4.4e-05 | 20      |
 | Data::Abridge           | 9.3       | 6.9                    | 13         | 2e-05   | 20      |
 | Data::Rmap              | 7.4       | 5                      | 16         | 1.1e-05 | 20      |
 | Data::Clean::JSON       | 7.4       | 5                      | 16         | 3.3e-05 | 20      |
 | JSON::XS                | 7.2       | 4.8                    | 17         | 3.8e-05 | 20      |
 | Cpanel::JSON::XS        | 6.8       | 4.4                    | 18         | 2.4e-05 | 21      |
 | Data::Clean             | 6.5       | 4.1                    | 19         | 1.2e-05 | 20      |
 | perl -e1 (baseline)     | 2.4       | 0                      | 50         | 4.5e-06 | 22      |
 +-------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataCleansing>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataCleansing>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataCleansing>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
