package Bencher::Scenario::Accessors::Set;

our $DATE = '2016-09-29'; # DATE
our $VERSION = '0.11'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute write/set',
    modules => {
        # include the generator modules here so we can show their versions in
        # sample benchmark results produced by PWP:Bencher::Scenario
        (map { $_=>0 } grep {defined} map { $classes->{$_}{generator} }
             keys %$classes),
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o }; \$o->attr1(42)",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o }; \$o->{attr1} = 42",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o }; \$o->[0] = 42",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute write/set

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Set - Benchmark attribute write/set

=head1 VERSION

This document describes version 0.11 of Bencher::Scenario::Accessors::Set (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-09-29.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Set

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Set

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::InsideOut> 1.13

L<Class::Tiny> 1.004

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Mo> 0.40

L<Mojo::Base>

L<Mojo::Base::XS> 0.07

L<Moo> 2.002004

L<Moose> 2.1805

L<Mouse> v2.4.5

L<Object::Simple> 3.1703

L<Perl::Examples::Accessors::Array> 0.08

L<Perl::Examples::Accessors::ClassAccessor> 0.08

L<Perl::Examples::Accessors::ClassAccessorArray> 0.08

L<Perl::Examples::Accessors::ClassInsideOut> 0.08

L<Perl::Examples::Accessors::ClassTiny> 0.08

L<Perl::Examples::Accessors::ClassXSAccessor> 0.08

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.08

L<Perl::Examples::Accessors::Hash> 0.08

L<Perl::Examples::Accessors::Mo> 0.08

L<Perl::Examples::Accessors::MojoBase> 0.08

L<Perl::Examples::Accessors::MojoBaseXS> 0.08

L<Perl::Examples::Accessors::Moo> 0.08

L<Perl::Examples::Accessors::Moose> 0.08

L<Perl::Examples::Accessors::Mouse> 0.08

L<Perl::Examples::Accessors::ObjectSimple> 0.08

L<Perl::Examples::Accessors::SimpleAccessor> 0.08

L<Simple::Accessor> 1.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::Tiny (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassTiny->new; $o }; $o->attr1(42)



=item * Object::Simple (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectSimple->new; $o }; $o->attr1(42)



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o }; $o->attr1(42)



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o }; $o->attr1(42)



=item * Mojo::Base::XS (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBaseXS->new; $o }; $o->attr1(42)



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o }; $o->attr1(42)



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o }; $o->attr1(42)



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->attr1(42)



=item * Class::InsideOut (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassInsideOut->new; $o }; $o->attr1(42)



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o }; $o->attr1(42)



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o }; $o->attr1(42)



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o }; $o->attr1(42)



=item * Mojo::Base (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBase->new; $o }; $o->attr1(42)



=item * Simple::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::SimpleAccessor->new; $o }; $o->attr1(42)



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->attr1(42)



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o }; $o->attr1(42)



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->{attr1} = 42



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->[0] = 42



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Set >>):

 #table1#
 +----------------------------+-----------+-----------+------------+---------+---------+
 | participant                | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +----------------------------+-----------+-----------+------------+---------+---------+
 | Simple::Accessor           |    195000 |    5.12   |       1    |   5e-09 |      20 |
 | Class::Accessor            |   1500000 |    0.67   |       7.7  | 1.4e-09 |      23 |
 | Class::InsideOut           |   1998000 |    0.5005 |      10.23 | 4.6e-11 |      21 |
 | Moose                      |   3500000 |    0.29   |      18    | 7.5e-10 |      31 |
 | Class::Tiny                |   3490000 |    0.286  |      17.9  | 5.8e-11 |      20 |
 | Mojo::Base                 |   3620000 |    0.276  |      18.6  |   1e-10 |      24 |
 | Mo                         |   3800000 |    0.27   |      19    | 9.1e-10 |      21 |
 | Object::Simple             |   3960000 |    0.252  |      20.3  | 1.1e-10 |      20 |
 | Class::Accessor::Array     |   4040000 |    0.248  |      20.7  | 4.6e-11 |      20 |
 | no generator (hash-based)  |   4460000 |    0.224  |      22.8  | 5.7e-11 |      20 |
 | no generator (array-based) |   4600000 |    0.22   |      24    | 4.1e-10 |      23 |
 | Mouse                      |   7200000 |    0.14   |      37    | 5.2e-10 |      20 |
 | Mojo::Base::XS             |   7300000 |    0.14   |      37    | 4.2e-10 |      20 |
 | Moo                        |   8390000 |    0.119  |      43    | 4.5e-11 |      20 |
 | Class::XSAccessor          |   8710000 |    0.115  |      44.6  | 1.2e-11 |      20 |
 | Class::XSAccessor::Array   |   9600000 |    0.1    |      49    | 2.4e-10 |      24 |
 | raw hash access            |  14000000 |    0.072  |      71    | 2.1e-10 |      20 |
 | raw array access           |  20000000 |    0.05   |     100    | 8.9e-10 |      20 |
 +----------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
